/* ExportText.c generated by valac 0.56.18, the Vala compiler
 * generated from ExportText.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_NODE_HIER (node_hier_get_type ())
#define NODE_HIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_HIER, NodeHier))
#define NODE_HIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_HIER, NodeHierClass))
#define IS_NODE_HIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_HIER))
#define IS_NODE_HIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_HIER))
#define NODE_HIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_HIER, NodeHierClass))

typedef struct _NodeHier NodeHier;
typedef struct _NodeHierClass NodeHierClass;
typedef struct _NodeHierPrivate NodeHierPrivate;

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecNodeHier ParamSpecNodeHier;

#define TYPE_EXPORT (export_get_type ())
#define EXPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT, Export))
#define EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT, ExportClass))
#define IS_EXPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT))
#define IS_EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT))
#define EXPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT, ExportClass))

typedef struct _Export Export;
typedef struct _ExportClass ExportClass;
typedef struct _ExportPrivate ExportPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_EXPORT_TEXT (export_text_get_type ())
#define EXPORT_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT_TEXT, ExportText))
#define EXPORT_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT_TEXT, ExportTextClass))
#define IS_EXPORT_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT_TEXT))
#define IS_EXPORT_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT_TEXT))
#define EXPORT_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT_TEXT, ExportTextClass))

typedef struct _ExportText ExportText;
typedef struct _ExportTextClass ExportTextClass;
typedef struct _ExportTextPrivate ExportTextPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define TYPE_NODE_IMAGE (node_image_get_type ())
#define NODE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_IMAGE, NodeImage))
#define NODE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_IMAGE, NodeImageClass))
#define IS_NODE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_IMAGE))
#define IS_NODE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_IMAGE))
#define NODE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_IMAGE, NodeImageClass))

typedef struct _NodeImage NodeImage;
typedef struct _NodeImageClass NodeImageClass;

#define TYPE_IMAGE_MANAGER (image_manager_get_type ())
#define IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMAGE_MANAGER, ImageManager))
#define IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMAGE_MANAGER, ImageManagerClass))
#define IS_IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMAGE_MANAGER))
#define IS_IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMAGE_MANAGER))
#define IMAGE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMAGE_MANAGER, ImageManagerClass))

typedef struct _ImageManager ImageManager;
typedef struct _ImageManagerClass ImageManagerClass;

#define TYPE_LAYOUTS (layouts_get_type ())
#define LAYOUTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LAYOUTS, Layouts))
#define LAYOUTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LAYOUTS, LayoutsClass))
#define IS_LAYOUTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LAYOUTS))
#define IS_LAYOUTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LAYOUTS))
#define LAYOUTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LAYOUTS, LayoutsClass))

typedef struct _Layouts Layouts;
typedef struct _LayoutsClass LayoutsClass;

#define TYPE_LAYOUT (layout_get_type ())
#define LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LAYOUT, Layout))
#define LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LAYOUT, LayoutClass))
#define IS_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LAYOUT))
#define IS_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LAYOUT))
#define LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LAYOUT, LayoutClass))

typedef struct _Layout Layout;
typedef struct _LayoutClass LayoutClass;

#define TYPE_STYLES (styles_get_type ())
#define STYLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLES, Styles))
#define STYLES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLES, StylesClass))
#define IS_STYLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLES))
#define IS_STYLES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLES))
#define STYLES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLES, StylesClass))

typedef struct _Styles Styles;
typedef struct _StylesClass StylesClass;

#define TYPE_STYLE (style_get_type ())
#define STYLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLE, Style))
#define STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLE, StyleClass))
#define IS_STYLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLE))
#define IS_STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLE))
#define STYLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLE, StyleClass))

typedef struct _Style Style;
typedef struct _StyleClass StyleClass;
#define _style_unref0(var) ((var == NULL) ? NULL : (var = (style_unref (var), NULL)))

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _node_image_unref0(var) ((var == NULL) ? NULL : (var = (node_image_unref (var), NULL)))
#define _node_hier_unref0(var) ((var == NULL) ? NULL : (var = (node_hier_unref (var), NULL)))

struct _NodeHier {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NodeHierPrivate * priv;
	gint spaces;
	Node* node;
	gboolean in_sequence;
	gint first_line;
	gint last_line;
};

struct _NodeHierClass {
	GTypeClass parent_class;
	void (*finalize) (NodeHier *self);
};

struct _ParamSpecNodeHier {
	GParamSpec parent_instance;
};

struct _Export {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ExportPrivate * priv;
};

struct _ExportClass {
	GTypeClass parent_class;
	void (*finalize) (Export *self);
	gboolean (*export) (Export* self, const gchar* fname, DrawArea* da);
	gboolean (*import) (Export* self, const gchar* fname, DrawArea* da);
	void (*add_settings) (Export* self, GtkGrid* grid);
	void (*save_settings) (Export* self, xmlNode* node);
	void (*load_settings) (Export* self, xmlNode* node);
};

struct _ExportText {
	Export parent_instance;
	ExportTextPrivate * priv;
};

struct _ExportTextClass {
	ExportClass parent_class;
};

static gpointer node_hier_parent_class = NULL;
static gpointer export_text_parent_class = NULL;
VALA_EXTERN Styles* style_inspector_styles;

VALA_EXTERN gpointer node_hier_ref (gpointer instance);
VALA_EXTERN void node_hier_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_node_hier (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_node_hier (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_node_hier (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_node_hier (const GValue* value);
VALA_EXTERN GType node_hier_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeHier, node_hier_unref)
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN NodeHier* node_hier_new (gint s,
                         Node* n,
                         gboolean is,
                         gint f,
                         gint l);
VALA_EXTERN NodeHier* node_hier_construct (GType object_type,
                               gint s,
                               Node* n,
                               gboolean is,
                               gint f,
                               gint l);
static void node_hier_finalize (NodeHier * obj);
static GType node_hier_get_type_once (void);
VALA_EXTERN gpointer export_ref (gpointer instance);
VALA_EXTERN void export_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_export (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_export (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_export (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_export (const GValue* value);
VALA_EXTERN GType export_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Export, export_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType export_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExportText, export_unref)
VALA_EXTERN gboolean export_export (Export* self,
                        const gchar* fname,
                        DrawArea* da);
VALA_EXTERN gboolean export_import (Export* self,
                        const gchar* fname,
                        DrawArea* da);
VALA_EXTERN ExportText* export_text_new (void);
VALA_EXTERN ExportText* export_text_construct (GType object_type);
VALA_EXTERN Export* export_new (const gchar* name,
                    const gchar* label,
                    gchar** extensions,
                    gint extensions_length1,
                    gboolean exportable,
                    gboolean importable,
                    gboolean dir);
VALA_EXTERN Export* export_construct (GType object_type,
                          const gchar* name,
                          const gchar* label,
                          gchar** extensions,
                          gint extensions_length1,
                          gboolean exportable,
                          gboolean importable,
                          gboolean dir);
static gboolean export_text_real_export (Export* base,
                                  const gchar* fname,
                                  DrawArea* da);
VALA_EXTERN gchar* export_text_export_top_nodes (ExportText* self,
                                     DrawArea* da);
VALA_EXTERN GArray* draw_area_get_nodes (DrawArea* self);
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN CanvasText* node_get_name (Node* self);
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
VALA_EXTERN const gchar* formatted_text_get_text (FormattedText* self);
VALA_EXTERN GArray* node_children (Node* self);
VALA_EXTERN gchar* export_text_export_node (ExportText* self,
                                DrawArea* da,
                                Node* node,
                                const gchar* prefix);
VALA_EXTERN gboolean node_is_in_sequence (Node* self);
VALA_EXTERN gint node_index (Node* self);
VALA_EXTERN gboolean node_is_task (Node* self);
VALA_EXTERN gboolean node_is_task_done (Node* self);
VALA_EXTERN gpointer node_image_ref (gpointer instance);
VALA_EXTERN void node_image_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_node_image (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_node_image (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_node_image (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_node_image (const GValue* value);
VALA_EXTERN GType node_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeImage, node_image_unref)
VALA_EXTERN NodeImage* node_get_image (Node* self);
VALA_EXTERN gpointer image_manager_ref (gpointer instance);
VALA_EXTERN void image_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_image_manager (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_image_manager (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_image_manager (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_image_manager (const GValue* value);
VALA_EXTERN GType image_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ImageManager, image_manager_unref)
VALA_EXTERN ImageManager* draw_area_get_image_manager (DrawArea* self);
VALA_EXTERN gchar* image_manager_get_uri (ImageManager* self,
                              gint id);
VALA_EXTERN gint node_image_get_id (NodeImage* self);
VALA_EXTERN const gchar* node_get_note (Node* self);
static gboolean export_text_real_import (Export* base,
                                  const gchar* fname,
                                  DrawArea* da);
VALA_EXTERN void export_text_import_text (ExportText* self,
                              const gchar* txt,
                              gint tab_spaces,
                              DrawArea* da,
                              gboolean replace,
                              GArray* nodes);
VALA_EXTERN GSettings* draw_area_get_settings (DrawArea* self);
VALA_EXTERN void draw_area_auto_save (DrawArea* self);
VALA_EXTERN Node* export_text_make_node (ExportText* self,
                             DrawArea* da,
                             const gchar* task,
                             const gchar* name);
VALA_EXTERN GType layouts_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Layouts, g_object_unref)
VALA_EXTERN Layouts* draw_area_get_layouts (DrawArea* self);
VALA_EXTERN GType layout_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Layout, g_object_unref)
VALA_EXTERN Layout* layouts_get_default (Layouts* self);
VALA_EXTERN Node* node_new_with_name (DrawArea* da,
                          const gchar* n,
                          Layout* layout);
VALA_EXTERN Node* node_construct_with_name (GType object_type,
                                DrawArea* da,
                                const gchar* n,
                                Layout* layout);
VALA_EXTERN void node_enable_task (Node* self,
                       gboolean task);
VALA_EXTERN void node_set_task_done (Node* self,
                         gboolean done);
static void export_text_parent_node (ExportText* self,
                              DrawArea* da,
                              Node* node,
                              gboolean node_in_sequence,
                              Node* parent);
VALA_EXTERN gpointer styles_ref (gpointer instance);
VALA_EXTERN void styles_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_styles (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_styles (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_styles (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_styles (const GValue* value);
VALA_EXTERN GType styles_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Styles, styles_unref)
VALA_EXTERN gpointer style_ref (gpointer instance);
VALA_EXTERN void style_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_style (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_style (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_style (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_style (const GValue* value);
VALA_EXTERN GType style_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Style, style_unref)
VALA_EXTERN Style* styles_get_global_style (Styles* self);
VALA_EXTERN void node_set_style (Node* self,
                     Style* value);
VALA_EXTERN void draw_area_position_root_node (DrawArea* self,
                                   Node* node);
VALA_EXTERN void draw_area_add_root (DrawArea* self,
                         Node* n,
                         gint index);
VALA_EXTERN void draw_area_set_current_node (DrawArea* self,
                                 Node* n);
VALA_EXTERN void node_set_sequence (Node* self,
                        gboolean value);
VALA_EXTERN Style* styles_get_style_for_level (Styles* self,
                                   guint level,
                                   Style* alternative);
VALA_EXTERN guint node_get_level (Node* self);
VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN void node_attach (Node* self,
                  Node* parent,
                  gint index,
                  Theme* theme,
                  gboolean set_side);
VALA_EXTERN Theme* draw_area_get_theme (DrawArea* self);
VALA_EXTERN void export_text_append_note (ExportText* self,
                              Node* node,
                              const gchar* str);
VALA_EXTERN void node_set_note (Node* self,
                    const gchar* value);
VALA_EXTERN void export_text_append_title (ExportText* self,
                               Node* node,
                               const gchar* str);
VALA_EXTERN void formatted_text_append_text (FormattedText* self,
                                 const gchar* str);
VALA_EXTERN gboolean export_text_parse_text (ExportText* self,
                                 DrawArea* da,
                                 const gchar* txt,
                                 gint tab_spaces,
                                 GArray* stack);
VALA_EXTERN NodeImage* node_image_new_from_uri (ImageManager* im,
                                    const gchar* uri,
                                    gint width);
VALA_EXTERN NodeImage* node_image_construct_from_uri (GType object_type,
                                          ImageManager* im,
                                          const gchar* uri,
                                          gint width);
VALA_EXTERN void node_set_image (Node* self,
                     ImageManager* im,
                     NodeImage* ni);
static void _node_hier_unref0_ (gpointer var);
static void _vala_NodeHier_free_function_content_of (gpointer data);
VALA_EXTERN Node* draw_area_get_current_node (DrawArea* self);
VALA_EXTERN void draw_area_replace_node (DrawArea* self,
                             Node* orig_node,
                             Node* new_node);
VALA_EXTERN Node* node_get_parent (Node* self);
VALA_EXTERN void export_text_display_node_hier (ExportText* self,
                                    GArray* stack);
VALA_EXTERN NodeHier* export_text_get_node_at_line (ExportText* self,
                                        GArray* stack,
                                        gint current_line);
static GType export_text_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

NodeHier*
node_hier_construct (GType object_type,
                     gint s,
                     Node* n,
                     gboolean is,
                     gint f,
                     gint l)
{
	NodeHier* self = NULL;
	Node* _tmp0_;
	g_return_val_if_fail (n != NULL, NULL);
	self = (NodeHier*) g_type_create_instance (object_type);
	self->spaces = s;
	_tmp0_ = _g_object_ref0 (n);
	_g_object_unref0 (self->node);
	self->node = _tmp0_;
	self->in_sequence = is;
	self->first_line = f;
	self->last_line = l;
	return self;
}

NodeHier*
node_hier_new (gint s,
               Node* n,
               gboolean is,
               gint f,
               gint l)
{
	return node_hier_construct (TYPE_NODE_HIER, s, n, is, f, l);
}

static void
value_node_hier_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_node_hier_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		node_hier_unref (value->data[0].v_pointer);
	}
}

static void
value_node_hier_copy_value (const GValue* src_value,
                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = node_hier_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_node_hier_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_node_hier_collect_value (GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		NodeHier * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = node_hier_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_node_hier_lcopy_value (const GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	NodeHier ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = node_hier_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_node_hier (const gchar* name,
                      const gchar* nick,
                      const gchar* blurb,
                      GType object_type,
                      GParamFlags flags)
{
	ParamSpecNodeHier* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_NODE_HIER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_node_hier (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NODE_HIER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_node_hier (GValue* value,
                     gpointer v_object)
{
	NodeHier * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NODE_HIER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NODE_HIER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		node_hier_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		node_hier_unref (old);
	}
}

void
value_take_node_hier (GValue* value,
                      gpointer v_object)
{
	NodeHier * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NODE_HIER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NODE_HIER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		node_hier_unref (old);
	}
}

static void
node_hier_class_init (NodeHierClass * klass,
                      gpointer klass_data)
{
	node_hier_parent_class = g_type_class_peek_parent (klass);
	((NodeHierClass *) klass)->finalize = node_hier_finalize;
}

static void
node_hier_instance_init (NodeHier * self,
                         gpointer klass)
{
	self->ref_count = 1;
}

static void
node_hier_finalize (NodeHier * obj)
{
	NodeHier * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NODE_HIER, NodeHier);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->node);
}

static GType
node_hier_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_node_hier_init, value_node_hier_free_value, value_node_hier_copy_value, value_node_hier_peek_pointer, "p", value_node_hier_collect_value, "p", value_node_hier_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (NodeHierClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) node_hier_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NodeHier), 0, (GInstanceInitFunc) node_hier_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType node_hier_type_id;
	node_hier_type_id = g_type_register_fundamental (g_type_fundamental_next (), "NodeHier", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return node_hier_type_id;
}

GType
node_hier_get_type (void)
{
	static volatile gsize node_hier_type_id__once = 0;
	if (g_once_init_enter (&node_hier_type_id__once)) {
		GType node_hier_type_id;
		node_hier_type_id = node_hier_get_type_once ();
		g_once_init_leave (&node_hier_type_id__once, node_hier_type_id);
	}
	return node_hier_type_id__once;
}

gpointer
node_hier_ref (gpointer instance)
{
	NodeHier * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
node_hier_unref (gpointer instance)
{
	NodeHier * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		NODE_HIER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

ExportText*
export_text_construct (GType object_type)
{
	ExportText* self = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	_tmp0_ = g_strdup (".txt");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	self = (ExportText*) export_construct (object_type, "text", _ ("PlainText"), _tmp2_, (gint) 1, TRUE, TRUE, FALSE);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	return self;
}

ExportText*
export_text_new (void)
{
	return export_text_construct (TYPE_EXPORT_TEXT);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gboolean
export_text_real_export (Export* base,
                         const gchar* fname,
                         DrawArea* da)
{
	ExportText * self;
	GFile* file = NULL;
	GFile* _tmp0_;
	gboolean retval = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (ExportText*) base;
	g_return_val_if_fail (fname != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (fname);
	file = _tmp0_;
	retval = TRUE;
	{
		GFileOutputStream* os = NULL;
		GFile* _tmp1_;
		GFileOutputStream* _tmp2_;
		gchar* str = NULL;
		gchar* _tmp3_;
		GFileOutputStream* _tmp4_;
		const gchar* _tmp5_;
		guint8* _tmp6_;
		gint _tmp6__length1;
		gint _tmp7_ = 0;
		guint8* _tmp8_;
		gint _tmp8__length1;
		GFileOutputStream* _tmp9_;
		_tmp1_ = file;
		_tmp2_ = g_file_replace (_tmp1_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
		os = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = export_text_export_top_nodes (self, da);
		str = _tmp3_;
		_tmp4_ = os;
		_tmp5_ = str;
		_tmp6_ = string_get_data (_tmp5_, &_tmp7_);
		_tmp6__length1 = _tmp7_;
		_tmp8_ = _tmp6_;
		_tmp8__length1 = _tmp6__length1;
		g_output_stream_write ((GOutputStream*) _tmp4_, _tmp8_, (gsize) _tmp8__length1, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (str);
			_g_object_unref0 (os);
			goto __catch0_g_error;
		}
		_tmp9_ = os;
		g_output_stream_close ((GOutputStream*) _tmp9_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (str);
			_g_object_unref0 (os);
			goto __catch0_g_error;
		}
		_g_free0 (str);
		_g_object_unref0 (os);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		retval = FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	result = retval;
	_g_object_unref0 (file);
	return result;
}

gchar*
export_text_export_top_nodes (ExportText* self,
                              DrawArea* da)
{
	gchar* value = NULL;
	gchar* _tmp0_;
	GArray* nodes = NULL;
	GArray* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (da != NULL, NULL);
	_tmp0_ = g_strdup ("");
	value = _tmp0_;
	_tmp1_ = draw_area_get_nodes (da);
	nodes = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GArray* _tmp4_;
				const gchar* _tmp5_;
				GArray* _tmp6_;
				Node* _tmp7_;
				CanvasText* _tmp8_;
				CanvasText* _tmp9_;
				FormattedText* _tmp10_;
				FormattedText* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				GArray* children = NULL;
				GArray* _tmp19_;
				Node* _tmp20_;
				GArray* _tmp21_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = nodes;
				if (!(((guint) i) < _tmp4_->len)) {
					break;
				}
				_tmp5_ = value;
				_tmp6_ = nodes;
				_tmp7_ = g_array_index (_tmp6_, Node*, (guint) i);
				_tmp8_ = node_get_name (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = canvas_text_get_text (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = formatted_text_get_text (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_strconcat ("# ", _tmp13_, NULL);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strconcat (_tmp15_, "\n", NULL);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strconcat (_tmp5_, _tmp17_, NULL);
				_g_free0 (value);
				value = _tmp18_;
				_g_free0 (_tmp17_);
				_g_free0 (_tmp15_);
				_tmp19_ = nodes;
				_tmp20_ = g_array_index (_tmp19_, Node*, (guint) i);
				_tmp21_ = node_children (_tmp20_);
				children = _tmp21_;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp22_ = FALSE;
						_tmp22_ = TRUE;
						while (TRUE) {
							GArray* _tmp24_;
							const gchar* _tmp25_;
							GArray* _tmp26_;
							Node* _tmp27_;
							gchar* _tmp28_;
							gchar* _tmp29_;
							gchar* _tmp30_;
							if (!_tmp22_) {
								gint _tmp23_;
								_tmp23_ = j;
								j = _tmp23_ + 1;
							}
							_tmp22_ = FALSE;
							_tmp24_ = children;
							if (!(((guint) j) < _tmp24_->len)) {
								break;
							}
							_tmp25_ = value;
							_tmp26_ = children;
							_tmp27_ = g_array_index (_tmp26_, Node*, (guint) j);
							_tmp28_ = export_text_export_node (self, da, _tmp27_, "\t");
							_tmp29_ = _tmp28_;
							_tmp30_ = g_strconcat (_tmp25_, _tmp29_, NULL);
							_g_free0 (value);
							value = _tmp30_;
							_g_free0 (_tmp29_);
						}
					}
				}
				_g_array_unref0 (children);
			}
		}
	}
	result = value;
	_g_array_unref0 (nodes);
	return result;
}

static gchar*
string_chomp (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
export_text_export_node (ExportText* self,
                         DrawArea* da,
                         Node* node,
                         const gchar* prefix)
{
	gchar* _tmp0_ = NULL;
	gchar* value = NULL;
	gchar* _tmp3_;
	const gchar* _tmp8_;
	CanvasText* _tmp9_;
	CanvasText* _tmp10_;
	FormattedText* _tmp11_;
	FormattedText* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	NodeImage* _tmp24_;
	NodeImage* _tmp25_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	GArray* children = NULL;
	GArray* _tmp61_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (da != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	if (node_is_in_sequence (node)) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup_printf ("%d. ", node_index (node) + 1);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("- ");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = g_strconcat (prefix, _tmp0_, NULL);
	value = _tmp3_;
	if (node_is_task (node)) {
		if (node_is_task_done (node)) {
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = value;
			_tmp5_ = g_strconcat (_tmp4_, "[x] ", NULL);
			_g_free0 (value);
			value = _tmp5_;
		} else {
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = value;
			_tmp7_ = g_strconcat (_tmp6_, "[ ] ", NULL);
			_g_free0 (value);
			value = _tmp7_;
		}
	}
	_tmp8_ = value;
	_tmp9_ = node_get_name (node);
	_tmp10_ = _tmp9_;
	_tmp11_ = canvas_text_get_text (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = formatted_text_get_text (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = string_chomp (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strdup_printf ("\n%s  ", prefix);
	_tmp18_ = _tmp17_;
	_tmp19_ = string_replace (_tmp16_, "\n", _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strconcat (_tmp20_, "\n", NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strconcat (_tmp8_, _tmp22_, NULL);
	_g_free0 (value);
	value = _tmp23_;
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	_tmp24_ = node_get_image (node);
	_tmp25_ = _tmp24_;
	if (_tmp25_ != NULL) {
		gchar* uri = NULL;
		ImageManager* _tmp26_;
		ImageManager* _tmp27_;
		NodeImage* _tmp28_;
		NodeImage* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp26_ = draw_area_get_image_manager (da);
		_tmp27_ = _tmp26_;
		_tmp28_ = node_get_image (node);
		_tmp29_ = _tmp28_;
		_tmp30_ = node_image_get_id (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = image_manager_get_uri (_tmp27_, _tmp31_);
		uri = _tmp32_;
		_tmp33_ = uri;
		if (g_strcmp0 (_tmp33_, "") != 0) {
			const gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			const gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			_tmp34_ = value;
			_tmp35_ = g_strconcat (prefix, "  ! ", NULL);
			_tmp36_ = _tmp35_;
			_tmp37_ = uri;
			_tmp38_ = g_strconcat (_tmp36_, _tmp37_, NULL);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strconcat (_tmp39_, "\n", NULL);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strconcat (_tmp34_, _tmp41_, NULL);
			_g_free0 (value);
			value = _tmp42_;
			_g_free0 (_tmp41_);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp36_);
		}
		_g_free0 (uri);
	}
	_tmp43_ = node_get_note (node);
	_tmp44_ = _tmp43_;
	if (g_strcmp0 (_tmp44_, "") != 0) {
		const gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		_tmp45_ = value;
		_tmp46_ = g_strconcat (prefix, "  > ", NULL);
		_tmp47_ = _tmp46_;
		_tmp48_ = node_get_note (node);
		_tmp49_ = _tmp48_;
		_tmp50_ = string_chomp (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = g_strdup_printf ("\n%s  > ", prefix);
		_tmp53_ = _tmp52_;
		_tmp54_ = string_replace (_tmp51_, "\n", _tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = g_strconcat (_tmp47_, _tmp55_, NULL);
		_tmp57_ = _tmp56_;
		_tmp58_ = g_strconcat (_tmp57_, "\n", NULL);
		_tmp59_ = _tmp58_;
		_tmp60_ = g_strconcat (_tmp45_, _tmp59_, NULL);
		_g_free0 (value);
		value = _tmp60_;
		_g_free0 (_tmp59_);
		_g_free0 (_tmp57_);
		_g_free0 (_tmp55_);
		_g_free0 (_tmp53_);
		_g_free0 (_tmp51_);
		_g_free0 (_tmp47_);
	}
	_tmp61_ = node_children (node);
	children = _tmp61_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp62_ = FALSE;
			_tmp62_ = TRUE;
			while (TRUE) {
				GArray* _tmp64_;
				const gchar* _tmp65_;
				GArray* _tmp66_;
				Node* _tmp67_;
				gchar* _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				gchar* _tmp71_;
				gchar* _tmp72_;
				if (!_tmp62_) {
					gint _tmp63_;
					_tmp63_ = i;
					i = _tmp63_ + 1;
				}
				_tmp62_ = FALSE;
				_tmp64_ = children;
				if (!(((guint) i) < _tmp64_->len)) {
					break;
				}
				_tmp65_ = value;
				_tmp66_ = children;
				_tmp67_ = g_array_index (_tmp66_, Node*, (guint) i);
				_tmp68_ = g_strconcat (prefix, "\t", NULL);
				_tmp69_ = _tmp68_;
				_tmp70_ = export_text_export_node (self, da, _tmp67_, _tmp69_);
				_tmp71_ = _tmp70_;
				_tmp72_ = g_strconcat (_tmp65_, _tmp71_, NULL);
				_g_free0 (value);
				value = _tmp72_;
				_g_free0 (_tmp71_);
				_g_free0 (_tmp69_);
			}
		}
	}
	result = value;
	_g_array_unref0 (children);
	_g_free0 (_tmp0_);
	return result;
}

/****************************************************************************/
static gboolean
export_text_real_import (Export* base,
                         const gchar* fname,
                         DrawArea* da)
{
	ExportText * self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (ExportText*) base;
	g_return_val_if_fail (fname != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	{
		GFile* file = NULL;
		GFile* _tmp0_;
		GFileInputStream* _tmp1_ = NULL;
		GFile* _tmp2_;
		GFileInputStream* _tmp3_;
		GDataInputStream* dis = NULL;
		GDataInputStream* _tmp4_;
		gsize len = 0UL;
		GArray* nodes = NULL;
		gchar* _tmp5_ = NULL;
		GDataInputStream* _tmp6_;
		gsize _tmp7_ = 0UL;
		gchar* _tmp8_;
		gchar* str = NULL;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		GSettings* _tmp11_;
		GSettings* _tmp12_;
		_tmp0_ = g_file_new_for_path (fname);
		file = _tmp0_;
		_tmp2_ = file;
		_tmp3_ = g_file_read (_tmp2_, NULL, &_inner_error0_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			goto __catch0_g_error;
		}
		_tmp4_ = g_data_input_stream_new ((GInputStream*) _tmp1_);
		dis = _tmp4_;
		_tmp6_ = dis;
		_tmp8_ = g_data_input_stream_read_upto (_tmp6_, "\0", (gssize) 1, &_tmp7_, NULL, &_inner_error0_);
		len = _tmp7_;
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_array_unref0 (nodes);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp1_);
			_g_object_unref0 (file);
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			goto __catch0_g_error;
		}
		_tmp9_ = g_strconcat (_tmp5_, "\0", NULL);
		str = _tmp9_;
		_tmp10_ = str;
		_tmp11_ = draw_area_get_settings (da);
		_tmp12_ = _tmp11_;
		export_text_import_text (self, _tmp10_, g_settings_get_int (_tmp12_, "quick-entry-spaces-per-tab"), da, FALSE, NULL);
		gtk_widget_queue_draw ((GtkWidget*) da);
		draw_area_auto_save (da);
		_g_free0 (str);
		_g_free0 (_tmp5_);
		_g_array_unref0 (nodes);
		_g_object_unref0 (dis);
		_g_object_unref0 (_tmp1_);
		_g_object_unref0 (file);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp13_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp13_;
	}
	result = TRUE;
	return result;
}

Node*
export_text_make_node (ExportText* self,
                       DrawArea* da,
                       const gchar* task,
                       const gchar* name)
{
	Node* node = NULL;
	Layouts* _tmp0_;
	Layouts* _tmp1_;
	Layout* _tmp2_;
	Layout* _tmp3_;
	Node* _tmp4_;
	Node* _tmp5_;
	Node* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (da != NULL, NULL);
	g_return_val_if_fail (task != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = draw_area_get_layouts (da);
	_tmp1_ = _tmp0_;
	_tmp2_ = layouts_get_default (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = node_new_with_name (da, name, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	node = _tmp5_;
	if (g_strcmp0 (task, "") != 0) {
		Node* _tmp6_;
		gboolean _tmp7_ = FALSE;
		_tmp6_ = node;
		node_enable_task (_tmp6_, TRUE);
		if (g_strcmp0 (task, "x") == 0) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = g_strcmp0 (task, "X") == 0;
		}
		if (_tmp7_) {
			Node* _tmp8_;
			_tmp8_ = node;
			node_set_task_done (_tmp8_, TRUE);
		}
	}
	result = node;
	return result;
}

static void
export_text_parent_node (ExportText* self,
                         DrawArea* da,
                         Node* node,
                         gboolean node_in_sequence,
                         Node* parent)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	g_return_if_fail (node != NULL);
	if (parent == NULL) {
		Styles* _tmp0_;
		Style* _tmp1_;
		Style* _tmp2_;
		_tmp0_ = style_inspector_styles;
		_tmp1_ = styles_get_global_style (_tmp0_);
		_tmp2_ = _tmp1_;
		node_set_style (node, _tmp2_);
		_style_unref0 (_tmp2_);
		draw_area_position_root_node (da, node);
		draw_area_add_root (da, node, -1);
		draw_area_set_current_node (da, node);
	} else {
		Styles* _tmp3_;
		Style* _tmp4_;
		Style* _tmp5_;
		GArray* _tmp6_;
		GArray* _tmp7_;
		Theme* _tmp8_;
		Theme* _tmp9_;
		node_set_sequence (parent, node_in_sequence);
		_tmp3_ = style_inspector_styles;
		_tmp4_ = styles_get_style_for_level (_tmp3_, node_get_level (parent) + 1, NULL);
		_tmp5_ = _tmp4_;
		node_set_style (node, _tmp5_);
		_style_unref0 (_tmp5_);
		_tmp6_ = node_children (parent);
		_tmp7_ = _tmp6_;
		_tmp8_ = draw_area_get_theme (da);
		_tmp9_ = _tmp8_;
		node_attach (node, parent, (gint) _tmp7_->len, _tmp9_, TRUE);
		_g_object_unref0 (_tmp9_);
		_g_array_unref0 (_tmp7_);
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

void
export_text_append_note (ExportText* self,
                         Node* node,
                         const gchar* str)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (str != NULL);
	_tmp0_ = node_get_note (node);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s\n%s", _tmp1_, str);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_strip (_tmp3_);
	_tmp5_ = _tmp4_;
	node_set_note (node, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
}

void
export_text_append_title (ExportText* self,
                          Node* node,
                          const gchar* str)
{
	CanvasText* _tmp0_;
	CanvasText* _tmp1_;
	FormattedText* _tmp2_;
	FormattedText* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (str != NULL);
	_tmp0_ = node_get_name (node);
	_tmp1_ = _tmp0_;
	_tmp2_ = canvas_text_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("\n", str, NULL);
	_tmp5_ = _tmp4_;
	formatted_text_append_text (_tmp3_, _tmp5_);
	_g_free0 (_tmp5_);
}

static gpointer
_node_hier_ref0 (gpointer self)
{
	return self ? node_hier_ref (self) : NULL;
}

gboolean
export_text_parse_text (ExportText* self,
                        DrawArea* da,
                        const gchar* txt,
                        gint tab_spaces,
                        GArray* stack)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	g_return_val_if_fail (txt != NULL, FALSE);
	g_return_val_if_fail (stack != NULL, FALSE);
	{
		Node* node = NULL;
		gchar** lines = NULL;
		gchar** _tmp0_;
		gchar** _tmp1_;
		gint lines_length1;
		gint _lines_size_;
		GRegex* re = NULL;
		GRegex* _tmp2_;
		gint _tmp4_ = 0;
		gchar* tspace = NULL;
		gchar* _tmp5_;
		gint lnum = 0;
		gchar** _tmp6_;
		gint _tmp6__length1;
		node = NULL;
		_tmp1_ = _tmp0_ = g_strsplit (txt, "\n", 0);
		lines = _tmp1_;
		lines_length1 = _vala_array_length (_tmp0_);
		_lines_size_ = lines_length1;
		_tmp2_ = g_regex_new ("^(\\s*)((\\-|\\+|\\*|#|>|\\d+\\.|!)\\s*)?(\\[([ xX])\\]\\s*)?(.*)$", 0, 0, &_inner_error0_);
		re = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp3_ = FALSE;
			lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (node);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
		if (tab_spaces <= 0) {
			_tmp4_ = 1;
		} else {
			_tmp4_ = tab_spaces;
		}
		_tmp5_ = g_strnfill ((gsize) _tmp4_, ' ');
		tspace = _tmp5_;
		lnum = 0;
		_tmp6_ = lines;
		_tmp6__length1 = lines_length1;
		{
			gchar** line_collection = NULL;
			gint line_collection_length1 = 0;
			gint _line_collection_size_ = 0;
			gint line_it = 0;
			line_collection = _tmp6_;
			line_collection_length1 = _tmp6__length1;
			for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
				gchar* _tmp7_;
				gchar* line = NULL;
				_tmp7_ = g_strdup (line_collection[line_it]);
				line = _tmp7_;
				{
					GMatchInfo* match_info = NULL;
					GRegex* _tmp8_;
					const gchar* _tmp9_;
					GMatchInfo* _tmp10_ = NULL;
					gboolean _tmp11_;
					gint _tmp59_;
					_tmp8_ = re;
					_tmp9_ = line;
					_tmp11_ = g_regex_match (_tmp8_, _tmp9_, 0, &_tmp10_);
					_g_match_info_unref0 (match_info);
					match_info = _tmp10_;
					if (_tmp11_) {
						gint spaces = 0;
						GMatchInfo* _tmp12_;
						gchar* _tmp13_;
						gchar* _tmp14_;
						const gchar* _tmp15_;
						gchar* _tmp16_;
						gchar* _tmp17_;
						gint _tmp18_;
						gint _tmp19_;
						gint _tmp20_;
						gchar* bullet = NULL;
						GMatchInfo* _tmp21_;
						gchar* _tmp22_;
						gchar* task = NULL;
						GMatchInfo* _tmp23_;
						gchar* _tmp24_;
						gchar* str = NULL;
						GMatchInfo* _tmp25_;
						gchar* _tmp26_;
						const gchar* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						gboolean _tmp30_;
						const gchar* _tmp31_;
						_tmp12_ = match_info;
						_tmp13_ = g_match_info_fetch (_tmp12_, 1);
						_tmp14_ = _tmp13_;
						_tmp15_ = tspace;
						_tmp16_ = string_replace (_tmp14_, "\t", _tmp15_);
						_tmp17_ = _tmp16_;
						_tmp18_ = strlen (_tmp17_);
						_tmp19_ = _tmp18_;
						_tmp20_ = _tmp19_;
						_g_free0 (_tmp17_);
						_g_free0 (_tmp14_);
						spaces = _tmp20_;
						_tmp21_ = match_info;
						_tmp22_ = g_match_info_fetch (_tmp21_, 3);
						bullet = _tmp22_;
						_tmp23_ = match_info;
						_tmp24_ = g_match_info_fetch (_tmp23_, 5);
						task = _tmp24_;
						_tmp25_ = match_info;
						_tmp26_ = g_match_info_fetch (_tmp25_, 6);
						str = _tmp26_;
						_tmp27_ = str;
						_tmp28_ = string_strip (_tmp27_);
						_tmp29_ = _tmp28_;
						_tmp30_ = g_strcmp0 (_tmp29_, "") == 0;
						_g_free0 (_tmp29_);
						if (_tmp30_) {
							_g_free0 (str);
							_g_free0 (task);
							_g_free0 (bullet);
							_g_match_info_unref0 (match_info);
							_g_free0 (line);
							continue;
						}
						_tmp31_ = bullet;
						if (g_strcmp0 (_tmp31_, ">") == 0) {
							Node* _tmp32_;
							_tmp32_ = node;
							if (_tmp32_ != NULL) {
								Node* _tmp33_;
								const gchar* _tmp34_;
								NodeHier* _tmp35_;
								_tmp33_ = node;
								_tmp34_ = str;
								export_text_append_note (self, _tmp33_, _tmp34_);
								_tmp35_ = g_array_index (stack, NodeHier*, stack->len - 1);
								_tmp35_->last_line = lnum;
							}
						} else {
							const gchar* _tmp36_;
							_tmp36_ = bullet;
							if (g_strcmp0 (_tmp36_, "!") == 0) {
								Node* _tmp37_;
								_tmp37_ = node;
								if (_tmp37_ != NULL) {
									NodeImage* img = NULL;
									ImageManager* _tmp38_;
									ImageManager* _tmp39_;
									const gchar* _tmp40_;
									NodeImage* _tmp41_;
									Node* _tmp42_;
									ImageManager* _tmp43_;
									ImageManager* _tmp44_;
									NodeImage* _tmp45_;
									_tmp38_ = draw_area_get_image_manager (da);
									_tmp39_ = _tmp38_;
									_tmp40_ = str;
									_tmp41_ = node_image_new_from_uri (_tmp39_, _tmp40_, 200);
									img = _tmp41_;
									_tmp42_ = node;
									_tmp43_ = draw_area_get_image_manager (da);
									_tmp44_ = _tmp43_;
									_tmp45_ = img;
									node_set_image (_tmp42_, _tmp44_, _tmp45_);
									_node_image_unref0 (img);
								}
							} else {
								const gchar* _tmp46_;
								_tmp46_ = bullet;
								if (g_strcmp0 (_tmp46_, "") != 0) {
									const gchar* _tmp47_;
									const gchar* _tmp48_;
									Node* _tmp49_;
									NodeHier* hier = NULL;
									Node* _tmp50_;
									const gchar* _tmp51_;
									NodeHier* _tmp52_;
									NodeHier* _tmp53_;
									NodeHier* _tmp54_;
									_tmp47_ = task;
									_tmp48_ = str;
									_tmp49_ = export_text_make_node (self, da, _tmp47_, _tmp48_);
									_g_object_unref0 (node);
									node = _tmp49_;
									_tmp50_ = node;
									_tmp51_ = bullet;
									_tmp52_ = node_hier_new (spaces, _tmp50_, g_regex_match_simple ("\\d+\\.", _tmp51_, 0, 0), lnum, lnum);
									hier = _tmp52_;
									_tmp53_ = hier;
									_tmp54_ = _node_hier_ref0 (_tmp53_);
									g_array_append_val (stack, _tmp54_);
									_node_hier_unref0 (hier);
								} else {
									Node* _tmp55_;
									_tmp55_ = node;
									if (_tmp55_ != NULL) {
										Node* _tmp56_;
										const gchar* _tmp57_;
										NodeHier* _tmp58_;
										_tmp56_ = node;
										_tmp57_ = str;
										export_text_append_title (self, _tmp56_, _tmp57_);
										_tmp58_ = g_array_index (stack, NodeHier*, stack->len - 1);
										_tmp58_->last_line = lnum;
									}
								}
							}
						}
						_g_free0 (str);
						_g_free0 (task);
						_g_free0 (bullet);
					}
					_tmp59_ = lnum;
					lnum = _tmp59_ + 1;
					_g_match_info_unref0 (match_info);
					_g_free0 (line);
				}
			}
		}
		_g_free0 (tspace);
		_g_regex_unref0 (re);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (node);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp60_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp60_;
	}
	result = stack->len > ((guint) 0);
	return result;
}

static void
_node_hier_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (node_hier_unref (var), NULL));
}

static void
_vala_NodeHier_free_function_content_of (gpointer data)
{
	NodeHier* self;
	self = *((NodeHier**) data);
	_node_hier_unref0_ (self);
}

void
export_text_import_text (ExportText* self,
                         const gchar* txt,
                         gint tab_spaces,
                         DrawArea* da,
                         gboolean replace,
                         GArray* nodes)
{
	GArray* stack = NULL;
	GArray* _tmp0_;
	GArray* _tmp1_;
	Node* current = NULL;
	Node* _tmp2_;
	gboolean _tmp3_ = FALSE;
	Node* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (txt != NULL);
	g_return_if_fail (da != NULL);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (NodeHier*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_NodeHier_free_function_content_of);
	stack = _tmp0_;
	_tmp1_ = stack;
	if (!export_text_parse_text (self, da, txt, tab_spaces, _tmp1_)) {
		_g_array_unref0 (stack);
		return;
	}
	_tmp2_ = draw_area_get_current_node (da);
	current = _tmp2_;
	_tmp4_ = current;
	if (_tmp4_ != NULL) {
		_tmp3_ = replace;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		Node* _tmp5_;
		GArray* _tmp6_;
		NodeHier* _tmp7_;
		Node* _tmp8_;
		_tmp5_ = current;
		_tmp6_ = stack;
		_tmp7_ = g_array_index (_tmp6_, NodeHier*, (guint) 0);
		_tmp8_ = _tmp7_->node;
		draw_area_replace_node (da, _tmp5_, _tmp8_);
	} else {
		GArray* _tmp9_;
		NodeHier* _tmp10_;
		Node* _tmp11_;
		GArray* _tmp12_;
		NodeHier* _tmp13_;
		Node* _tmp14_;
		_tmp9_ = stack;
		_tmp10_ = g_array_index (_tmp9_, NodeHier*, (guint) 0);
		_tmp11_ = _tmp10_->node;
		_tmp12_ = stack;
		_tmp13_ = g_array_index (_tmp12_, NodeHier*, (guint) 0);
		_tmp14_ = current;
		export_text_parent_node (self, da, _tmp11_, _tmp13_->in_sequence, _tmp14_);
	}
	if (nodes != NULL) {
		GArray* _tmp15_;
		NodeHier* _tmp16_;
		Node* _tmp17_;
		Node* _tmp18_;
		_tmp15_ = stack;
		_tmp16_ = g_array_index (_tmp15_, NodeHier*, (guint) 0);
		_tmp17_ = _tmp16_->node;
		_tmp18_ = _g_object_ref0 (_tmp17_);
		g_array_append_val (nodes, _tmp18_);
	}
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp19_ = FALSE;
			_tmp19_ = TRUE;
			while (TRUE) {
				GArray* _tmp21_;
				gint spaces = 0;
				GArray* _tmp22_;
				NodeHier* _tmp23_;
				Node* node = NULL;
				GArray* _tmp24_;
				NodeHier* _tmp25_;
				Node* _tmp26_;
				Node* _tmp27_;
				gboolean in_seq = FALSE;
				GArray* _tmp28_;
				NodeHier* _tmp29_;
				GArray* _tmp30_;
				NodeHier* _tmp31_;
				if (!_tmp19_) {
					gint _tmp20_;
					_tmp20_ = i;
					i = _tmp20_ + 1;
				}
				_tmp19_ = FALSE;
				_tmp21_ = stack;
				if (!(((guint) i) < _tmp21_->len)) {
					break;
				}
				_tmp22_ = stack;
				_tmp23_ = g_array_index (_tmp22_, NodeHier*, (guint) i);
				spaces = _tmp23_->spaces;
				_tmp24_ = stack;
				_tmp25_ = g_array_index (_tmp24_, NodeHier*, (guint) i);
				_tmp26_ = _tmp25_->node;
				_tmp27_ = _g_object_ref0 (_tmp26_);
				node = _tmp27_;
				_tmp28_ = stack;
				_tmp29_ = g_array_index (_tmp28_, NodeHier*, (guint) i);
				in_seq = _tmp29_->in_sequence;
				_tmp30_ = stack;
				_tmp31_ = g_array_index (_tmp30_, NodeHier*, (guint) (i - 1));
				if (spaces == _tmp31_->spaces) {
					Node* _tmp32_;
					GArray* _tmp33_;
					NodeHier* _tmp34_;
					Node* _tmp35_;
					Node* _tmp36_;
					Node* _tmp37_;
					_tmp32_ = node;
					_tmp33_ = stack;
					_tmp34_ = g_array_index (_tmp33_, NodeHier*, (guint) (i - 1));
					_tmp35_ = _tmp34_->node;
					_tmp36_ = node_get_parent (_tmp35_);
					_tmp37_ = _tmp36_;
					export_text_parent_node (self, da, _tmp32_, in_seq, _tmp37_);
				} else {
					GArray* _tmp38_;
					NodeHier* _tmp39_;
					_tmp38_ = stack;
					_tmp39_ = g_array_index (_tmp38_, NodeHier*, (guint) (i - 1));
					if (spaces > _tmp39_->spaces) {
						Node* _tmp40_;
						GArray* _tmp41_;
						NodeHier* _tmp42_;
						Node* _tmp43_;
						_tmp40_ = node;
						_tmp41_ = stack;
						_tmp42_ = g_array_index (_tmp41_, NodeHier*, (guint) (i - 1));
						_tmp43_ = _tmp42_->node;
						export_text_parent_node (self, da, _tmp40_, in_seq, _tmp43_);
					} else {
						gint parent = 0;
						parent = i - 1;
						while (TRUE) {
							gboolean _tmp44_ = FALSE;
							gint _tmp47_;
							if (parent >= 0) {
								GArray* _tmp45_;
								NodeHier* _tmp46_;
								_tmp45_ = stack;
								_tmp46_ = g_array_index (_tmp45_, NodeHier*, (guint) parent);
								_tmp44_ = spaces < _tmp46_->spaces;
							} else {
								_tmp44_ = FALSE;
							}
							if (!_tmp44_) {
								break;
							}
							_tmp47_ = parent;
							parent = _tmp47_ - 1;
						}
						if (parent != -1) {
							GArray* _tmp48_;
							NodeHier* _tmp49_;
							_tmp48_ = stack;
							_tmp49_ = g_array_index (_tmp48_, NodeHier*, (guint) parent);
							if (spaces == _tmp49_->spaces) {
								Node* _tmp50_;
								GArray* _tmp51_;
								NodeHier* _tmp52_;
								Node* _tmp53_;
								Node* _tmp54_;
								Node* _tmp55_;
								_tmp50_ = node;
								_tmp51_ = stack;
								_tmp52_ = g_array_index (_tmp51_, NodeHier*, (guint) parent);
								_tmp53_ = _tmp52_->node;
								_tmp54_ = node_get_parent (_tmp53_);
								_tmp55_ = _tmp54_;
								export_text_parent_node (self, da, _tmp50_, in_seq, _tmp55_);
							} else {
								Node* _tmp56_;
								GArray* _tmp57_;
								NodeHier* _tmp58_;
								Node* _tmp59_;
								_tmp56_ = node;
								_tmp57_ = stack;
								_tmp58_ = g_array_index (_tmp57_, NodeHier*, (guint) parent);
								_tmp59_ = _tmp58_->node;
								export_text_parent_node (self, da, _tmp56_, in_seq, _tmp59_);
							}
						}
					}
				}
				if (nodes != NULL) {
					Node* _tmp60_;
					Node* _tmp61_;
					_tmp60_ = node;
					_tmp61_ = _g_object_ref0 (_tmp60_);
					g_array_append_val (nodes, _tmp61_);
				}
				_g_object_unref0 (node);
			}
		}
	}
	_g_object_unref0 (current);
	_g_array_unref0 (stack);
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

void
export_text_display_node_hier (ExportText* self,
                               GArray* stack)
{
	FILE* _tmp0_;
	FILE* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stack != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Node Hierarchy (%u)\n", stack->len);
	_tmp1_ = stdout;
	fprintf (_tmp1_, "--------------\n");
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				NodeHier* entry = NULL;
				NodeHier* _tmp4_;
				NodeHier* _tmp5_;
				const gchar* _tmp6_ = NULL;
				NodeHier* _tmp7_;
				Node* _tmp8_;
				FILE* _tmp17_;
				NodeHier* _tmp18_;
				NodeHier* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				NodeHier* _tmp22_;
				NodeHier* _tmp23_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(((guint) i) < stack->len)) {
					break;
				}
				_tmp4_ = g_array_index (stack, NodeHier*, (guint) i);
				_tmp5_ = _node_hier_ref0 (_tmp4_);
				entry = _tmp5_;
				_tmp7_ = entry;
				_tmp8_ = _tmp7_->node;
				if (_tmp8_ == NULL) {
					_tmp6_ = "NULL";
				} else {
					NodeHier* _tmp9_;
					Node* _tmp10_;
					CanvasText* _tmp11_;
					CanvasText* _tmp12_;
					FormattedText* _tmp13_;
					FormattedText* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					_tmp9_ = entry;
					_tmp10_ = _tmp9_->node;
					_tmp11_ = node_get_name (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = canvas_text_get_text (_tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = formatted_text_get_text (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp6_ = _tmp16_;
				}
				_tmp17_ = stdout;
				_tmp18_ = entry;
				_tmp19_ = entry;
				_tmp20_ = bool_to_string (_tmp19_->in_sequence);
				_tmp21_ = _tmp20_;
				_tmp22_ = entry;
				_tmp23_ = entry;
				fprintf (_tmp17_, "  %s, spaces: %d, in_seq: %s, first: %d, last: %d\n", _tmp6_, _tmp18_->spaces, _tmp21_, _tmp22_->first_line, _tmp23_->last_line);
				_g_free0 (_tmp21_);
				_node_hier_unref0 (entry);
			}
		}
	}
}

NodeHier*
export_text_get_node_at_line (ExportText* self,
                              GArray* stack,
                              gint current_line)
{
	NodeHier* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (stack != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp0_ = FALSE;
				_tmp0_ = TRUE;
				while (TRUE) {
					gint first_line = 0;
					NodeHier* _tmp2_;
					gint last_line = 0;
					NodeHier* _tmp3_;
					gboolean _tmp4_ = FALSE;
					if (!_tmp0_) {
						gint _tmp1_;
						_tmp1_ = i;
						i = _tmp1_ + 1;
					}
					_tmp0_ = FALSE;
					if (!(((guint) i) < stack->len)) {
						break;
					}
					_tmp2_ = g_array_index (stack, NodeHier*, (guint) i);
					first_line = _tmp2_->first_line;
					_tmp3_ = g_array_index (stack, NodeHier*, (guint) i);
					last_line = _tmp3_->last_line;
					if (first_line <= current_line) {
						_tmp4_ = current_line <= last_line;
					} else {
						_tmp4_ = FALSE;
					}
					if (_tmp4_) {
						NodeHier* _tmp5_;
						NodeHier* _tmp6_;
						_tmp5_ = g_array_index (stack, NodeHier*, (guint) i);
						_tmp6_ = _node_hier_ref0 (_tmp5_);
						result = _tmp6_;
						return result;
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}

static void
export_text_class_init (ExportTextClass * klass,
                        gpointer klass_data)
{
	export_text_parent_class = g_type_class_peek_parent (klass);
	((ExportClass *) klass)->export = (gboolean (*) (Export*, const gchar*, DrawArea*)) export_text_real_export;
	((ExportClass *) klass)->import = (gboolean (*) (Export*, const gchar*, DrawArea*)) export_text_real_import;
}

static void
export_text_instance_init (ExportText * self,
                           gpointer klass)
{
}

static GType
export_text_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExportTextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) export_text_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExportText), 0, (GInstanceInitFunc) export_text_instance_init, NULL };
	GType export_text_type_id;
	export_text_type_id = g_type_register_static (TYPE_EXPORT, "ExportText", &g_define_type_info, 0);
	return export_text_type_id;
}

GType
export_text_get_type (void)
{
	static volatile gsize export_text_type_id__once = 0;
	if (g_once_init_enter (&export_text_type_id__once)) {
		GType export_text_type_id;
		export_text_type_id = export_text_get_type_once ();
		g_once_init_leave (&export_text_type_id__once, export_text_type_id);
	}
	return export_text_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

