/* ExportMermaid.c generated by valac 0.56.18, the Vala compiler
 * generated from ExportMermaid.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_EXPORT (export_get_type ())
#define EXPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT, Export))
#define EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT, ExportClass))
#define IS_EXPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT))
#define IS_EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT))
#define EXPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT, ExportClass))

typedef struct _Export Export;
typedef struct _ExportClass ExportClass;
typedef struct _ExportPrivate ExportPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_EXPORT_MERMAID (export_mermaid_get_type ())
#define EXPORT_MERMAID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT_MERMAID, ExportMermaid))
#define EXPORT_MERMAID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT_MERMAID, ExportMermaidClass))
#define IS_EXPORT_MERMAID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT_MERMAID))
#define IS_EXPORT_MERMAID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT_MERMAID))
#define EXPORT_MERMAID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT_MERMAID, ExportMermaidClass))

typedef struct _ExportMermaid ExportMermaid;
typedef struct _ExportMermaidClass ExportMermaidClass;
typedef struct _ExportMermaidPrivate ExportMermaidPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;

#define TYPE_LAYOUT (layout_get_type ())
#define LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LAYOUT, Layout))
#define LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LAYOUT, LayoutClass))
#define IS_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LAYOUT))
#define IS_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LAYOUT))
#define LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LAYOUT, LayoutClass))

typedef struct _Layout Layout;
typedef struct _LayoutClass LayoutClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

#define TYPE_STYLE (style_get_type ())
#define STYLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLE, Style))
#define STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLE, StyleClass))
#define IS_STYLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLE))
#define IS_STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLE))
#define STYLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLE, StyleClass))

typedef struct _Style Style;
typedef struct _StyleClass StyleClass;

#define TYPE_NODE_BORDER (node_border_get_type ())
#define NODE_BORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_BORDER, NodeBorder))
#define IS_NODE_BORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_BORDER))
#define NODE_BORDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_NODE_BORDER, NodeBorderIface))

typedef struct _NodeBorder NodeBorder;
typedef struct _NodeBorderIface NodeBorderIface;
typedef enum  {
	NODE_SIDE_LEFT = 1,
	NODE_SIDE_TOP = 2,
	NODE_SIDE_RIGHT = 4,
	NODE_SIDE_BOTTOM = 8
} NodeSide;

#define TYPE_NODE_SIDE (node_side_get_type ())

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;

#define TYPE_NODE_IMAGE (node_image_get_type ())
#define NODE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_IMAGE, NodeImage))
#define NODE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_IMAGE, NodeImageClass))
#define IS_NODE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_IMAGE))
#define IS_NODE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_IMAGE))
#define NODE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_IMAGE, NodeImageClass))

typedef struct _NodeImage NodeImage;
typedef struct _NodeImageClass NodeImageClass;

#define TYPE_LINK_DASH (link_dash_get_type ())
#define LINK_DASH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINK_DASH, LinkDash))
#define LINK_DASH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINK_DASH, LinkDashClass))
#define IS_LINK_DASH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINK_DASH))
#define IS_LINK_DASH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINK_DASH))
#define LINK_DASH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINK_DASH, LinkDashClass))

typedef struct _LinkDash LinkDash;
typedef struct _LinkDashClass LinkDashClass;
typedef struct _LinkDashPrivate LinkDashPrivate;
#define __vala_GdkRGBA_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRGBA_free (var), NULL)))

struct _Export {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ExportPrivate * priv;
};

struct _ExportClass {
	GTypeClass parent_class;
	void (*finalize) (Export *self);
	gboolean (*export) (Export* self, const gchar* fname, DrawArea* da);
	gboolean (*import) (Export* self, const gchar* fname, DrawArea* da);
	void (*add_settings) (Export* self, GtkGrid* grid);
	void (*save_settings) (Export* self, xmlNode* node);
	void (*load_settings) (Export* self, xmlNode* node);
};

struct _ExportMermaid {
	Export parent_instance;
	ExportMermaidPrivate * priv;
};

struct _ExportMermaidClass {
	ExportClass parent_class;
};

struct _NodeBorderIface {
	GTypeInterface parent_iface;
	gchar* (*name) (NodeBorder* self);
	gchar* (*display_name) (NodeBorder* self);
	gchar* (*icon_name) (NodeBorder* self);
	gboolean (*is_fillable) (NodeBorder* self);
	void (*draw_border) (NodeBorder* self, cairo_t* ctx, gdouble x, gdouble y, gdouble w, gdouble h, NodeSide s, gint padding);
	void (*draw_fill) (NodeBorder* self, cairo_t* ctx, gdouble x, gdouble y, gdouble w, gdouble h, NodeSide s, gint padding);
};

struct _LinkDash {
	GObject parent_instance;
	LinkDashPrivate * priv;
	gchar* name;
	gchar* display_name;
	gdouble* pattern;
	gint pattern_length1;
};

struct _LinkDashClass {
	GObjectClass parent_class;
};

static gpointer export_mermaid_parent_class = NULL;

VALA_EXTERN gpointer export_ref (gpointer instance);
VALA_EXTERN void export_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_export (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_export (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_export (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_export (const GValue* value);
VALA_EXTERN GType export_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Export, export_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType export_mermaid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExportMermaid, export_unref)
VALA_EXTERN gboolean export_export (Export* self,
                        const gchar* fname,
                        DrawArea* da);
VALA_EXTERN ExportMermaid* export_mermaid_new (void);
VALA_EXTERN ExportMermaid* export_mermaid_construct (GType object_type);
VALA_EXTERN Export* export_new (const gchar* name,
                    const gchar* label,
                    gchar** extensions,
                    gint extensions_length1,
                    gboolean exportable,
                    gboolean importable,
                    gboolean dir);
VALA_EXTERN Export* export_construct (GType object_type,
                          const gchar* name,
                          const gchar* label,
                          gchar** extensions,
                          gint extensions_length1,
                          gboolean exportable,
                          gboolean importable,
                          gboolean dir);
static gboolean export_mermaid_real_export (Export* base,
                                     const gchar* fname,
                                     DrawArea* da);
static void export_mermaid_export_top_nodes (ExportMermaid* self,
                                      GFileOutputStream* os,
                                      DrawArea* da);
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
static gchar* export_mermaid_map_layout_to_direction (ExportMermaid* self,
                                               Node* n);
VALA_EXTERN GType layout_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Layout, g_object_unref)
VALA_EXTERN Layout* node_get_layout (Node* self);
VALA_EXTERN const gchar* layout_get_name (Layout* self);
VALA_EXTERN GArray* draw_area_get_nodes (DrawArea* self);
static void export_mermaid_export_node (ExportMermaid* self,
                                 GFileOutputStream* os,
                                 Node* node,
                                 gint* link_id);
static gchar* export_mermaid_make_id (ExportMermaid* self,
                               Node* n);
VALA_EXTERN gint node_id (Node* self);
static gchar* export_mermaid_make_title (ExportMermaid* self,
                                  Node* n);
VALA_EXTERN gpointer style_ref (gpointer instance);
VALA_EXTERN void style_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_style (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_style (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_style (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_style (const GValue* value);
VALA_EXTERN GType style_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Style, style_unref)
VALA_EXTERN Style* node_get_style (Node* self);
VALA_EXTERN GType node_side_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType node_border_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeBorder, g_object_unref)
VALA_EXTERN NodeBorder* style_get_node_border (Style* self);
VALA_EXTERN gchar* node_border_name (NodeBorder* self);
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN CanvasText* node_get_name (Node* self);
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
VALA_EXTERN const gchar* formatted_text_get_text (FormattedText* self);
VALA_EXTERN gpointer node_image_ref (gpointer instance);
VALA_EXTERN void node_image_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_node_image (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_node_image (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_node_image (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_node_image (const GValue* value);
VALA_EXTERN GType node_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeImage, node_image_unref)
VALA_EXTERN NodeImage* node_get_image (Node* self);
static gchar* export_mermaid_make_link (ExportMermaid* self,
                                 Node* n);
VALA_EXTERN gboolean* style_get_link_arrow (Style* self);
VALA_EXTERN GType link_dash_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinkDash, g_object_unref)
VALA_EXTERN LinkDash* style_get_link_dash (Style* self);
static gchar* export_mermaid_make_link_color (ExportMermaid* self,
                                       Node* n);
VALA_EXTERN GdkRGBA* node_get_link_color (Node* self);
static GdkRGBA* _vala_GdkRGBA_copy (GdkRGBA* self);
static void _vala_GdkRGBA_free (GdkRGBA* self);
static gchar* export_mermaid_make_node_style (ExportMermaid* self,
                                       Node* n);
VALA_EXTERN gboolean* style_get_node_fill (Style* self);
VALA_EXTERN gint* style_get_node_borderwidth (Style* self);
static gchar* export_mermaid_make_link_style (ExportMermaid* self,
                                       Node* n,
                                       gint* link_id);
VALA_EXTERN gint* style_get_link_width (Style* self);
static gdouble* _vala_array_dup4 (gdouble* self,
                           gssize length);
VALA_EXTERN GArray* node_children (Node* self);
VALA_EXTERN gboolean node_is_root (Node* self);
static GType export_mermaid_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

ExportMermaid*
export_mermaid_construct (GType object_type)
{
	ExportMermaid* self = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	_tmp0_ = g_strdup (".mmd");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	self = (ExportMermaid*) export_construct (object_type, "mermaid", _ ("Mermaid"), _tmp2_, (gint) 1, TRUE, FALSE, FALSE);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	return self;
}

ExportMermaid*
export_mermaid_new (void)
{
	return export_mermaid_construct (TYPE_EXPORT_MERMAID);
}

static gboolean
export_mermaid_real_export (Export* base,
                            const gchar* fname,
                            DrawArea* da)
{
	ExportMermaid * self;
	GFile* file = NULL;
	GFile* _tmp0_;
	gboolean retval = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (ExportMermaid*) base;
	g_return_val_if_fail (fname != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (fname);
	file = _tmp0_;
	retval = TRUE;
	{
		GFileOutputStream* os = NULL;
		GFileOutputStream* _tmp1_;
		_tmp1_ = g_file_replace (file, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
		os = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		export_mermaid_export_top_nodes (self, os, da);
		_g_object_unref0 (os);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		retval = FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp2_;
	}
	result = retval;
	_g_object_unref0 (file);
	return result;
}

static gchar*
export_mermaid_map_layout_to_direction (ExportMermaid* self,
                                        Node* n)
{
	gchar* lname = NULL;
	Layout* _tmp0_;
	Layout* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	_tmp0_ = node_get_layout (n);
	_tmp1_ = _tmp0_;
	_tmp2_ = layout_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	lname = _tmp4_;
	_tmp6_ = lname;
	if (g_strcmp0 (_tmp6_, _ ("Vertical")) == 0) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp7_;
		_tmp7_ = lname;
		_tmp5_ = g_strcmp0 (_tmp7_, _ ("Downwards")) == 0;
	}
	if (_tmp5_) {
		gchar* _tmp8_;
		_tmp8_ = g_strdup ("TB");
		result = _tmp8_;
		_g_free0 (lname);
		return result;
	} else {
		const gchar* _tmp9_;
		_tmp9_ = lname;
		if (g_strcmp0 (_tmp9_, _ ("To left")) == 0) {
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("RL");
			result = _tmp10_;
			_g_free0 (lname);
			return result;
		} else {
			const gchar* _tmp11_;
			_tmp11_ = lname;
			if (g_strcmp0 (_tmp11_, _ ("Upwards")) == 0) {
				gchar* _tmp12_;
				_tmp12_ = g_strdup ("BT");
				result = _tmp12_;
				_g_free0 (lname);
				return result;
			}
		}
	}
	_tmp13_ = g_strdup ("LR");
	result = _tmp13_;
	_g_free0 (lname);
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
export_mermaid_export_top_nodes (ExportMermaid* self,
                                 GFileOutputStream* os,
                                 DrawArea* da)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	g_return_if_fail (da != NULL);
	{
		GArray* nodes = NULL;
		GArray* _tmp0_;
		gint link_id = 0;
		GArray* _tmp1_;
		gchar* title = NULL;
		GArray* _tmp2_;
		Node* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		guint8* _tmp11_;
		gint _tmp11__length1;
		gint _tmp12_ = 0;
		guint8* _tmp13_;
		gint _tmp13__length1;
		_tmp0_ = draw_area_get_nodes (da);
		nodes = _tmp0_;
		link_id = 0;
		_tmp1_ = nodes;
		if (_tmp1_->len == ((guint) 0)) {
			_g_array_unref0 (nodes);
			return;
		}
		_tmp2_ = nodes;
		_tmp3_ = g_array_index (_tmp2_, Node*, (guint) 0);
		_tmp4_ = export_mermaid_map_layout_to_direction (self, _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat ("graph ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp7_, "\n", NULL);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		title = _tmp9_;
		_tmp10_ = title;
		_tmp11_ = string_get_data (_tmp10_, &_tmp12_);
		_tmp11__length1 = _tmp12_;
		_tmp13_ = _tmp11_;
		_tmp13__length1 = _tmp11__length1;
		g_output_stream_write ((GOutputStream*) os, _tmp13_, (gsize) _tmp13__length1, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (title);
			_g_array_unref0 (nodes);
			goto __catch0_g_error;
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp14_ = FALSE;
				_tmp14_ = TRUE;
				while (TRUE) {
					GArray* _tmp16_;
					GArray* _tmp17_;
					Node* _tmp18_;
					if (!_tmp14_) {
						gint _tmp15_;
						_tmp15_ = i;
						i = _tmp15_ + 1;
					}
					_tmp14_ = FALSE;
					_tmp16_ = nodes;
					if (!(((guint) i) < _tmp16_->len)) {
						break;
					}
					_tmp17_ = nodes;
					_tmp18_ = g_array_index (_tmp17_, Node*, (guint) i);
					export_mermaid_export_node (self, os, _tmp18_, &link_id);
				}
			}
		}
		_g_free0 (title);
		_g_array_unref0 (nodes);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gchar*
export_mermaid_make_id (ExportMermaid* self,
                        Node* n)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%i", node_id (n));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("id", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static gchar*
export_mermaid_make_title (ExportMermaid* self,
                           Node* n)
{
	gboolean rounded = FALSE;
	Style* _tmp0_;
	Style* _tmp1_;
	NodeBorder* _tmp2_;
	NodeBorder* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* left = NULL;
	gchar* _tmp8_;
	const gchar* _tmp9_ = NULL;
	gchar* right = NULL;
	gchar* _tmp10_;
	gchar* name = NULL;
	CanvasText* _tmp11_;
	CanvasText* _tmp12_;
	FormattedText* _tmp13_;
	FormattedText* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	CanvasText* _tmp30_;
	CanvasText* _tmp31_;
	FormattedText* _tmp32_;
	FormattedText* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	_tmp0_ = node_get_style (n);
	_tmp1_ = _tmp0_;
	_tmp2_ = style_get_node_border (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = node_border_name (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strcmp0 (_tmp5_, "rounded") == 0;
	_g_free0 (_tmp5_);
	rounded = _tmp6_;
	if (rounded) {
		_tmp7_ = "(";
	} else {
		_tmp7_ = "[";
	}
	_tmp8_ = g_strdup (_tmp7_);
	left = _tmp8_;
	if (rounded) {
		_tmp9_ = ")";
	} else {
		_tmp9_ = "]";
	}
	_tmp10_ = g_strdup (_tmp9_);
	right = _tmp10_;
	_tmp11_ = node_get_name (n);
	_tmp12_ = _tmp11_;
	_tmp13_ = canvas_text_get_text (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = formatted_text_get_text (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strdup (_tmp16_);
	name = _tmp17_;
	_tmp19_ = name;
	if (g_strcmp0 (_tmp19_, "") == 0) {
		NodeImage* _tmp20_;
		NodeImage* _tmp21_;
		_tmp20_ = node_get_image (n);
		_tmp21_ = _tmp20_;
		_tmp18_ = _tmp21_ != NULL;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		gchar* _tmp22_;
		_tmp22_ = g_strdup ("Image");
		_g_free0 (name);
		name = _tmp22_;
	}
	_tmp23_ = export_mermaid_make_id (self, n);
	_tmp24_ = _tmp23_;
	_tmp25_ = left;
	_tmp26_ = g_strconcat (_tmp24_, _tmp25_, NULL);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strconcat (_tmp27_, "\"", NULL);
	_tmp29_ = _tmp28_;
	_tmp30_ = node_get_name (n);
	_tmp31_ = _tmp30_;
	_tmp32_ = canvas_text_get_text (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = formatted_text_get_text (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_strconcat (_tmp29_, _tmp35_, NULL);
	_tmp37_ = _tmp36_;
	_tmp38_ = g_strconcat (_tmp37_, "\"", NULL);
	_tmp39_ = _tmp38_;
	_tmp40_ = right;
	_tmp41_ = g_strconcat (_tmp39_, _tmp40_, NULL);
	_tmp42_ = _tmp41_;
	_g_free0 (_tmp39_);
	_g_free0 (_tmp37_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp24_);
	result = _tmp42_;
	_g_free0 (name);
	_g_free0 (right);
	_g_free0 (left);
	return result;
}

static gchar*
export_mermaid_make_link (ExportMermaid* self,
                          Node* n)
{
	gboolean arrow = FALSE;
	Style* _tmp0_;
	Style* _tmp1_;
	gboolean* _tmp2_;
	gboolean* _tmp3_;
	gboolean solid = FALSE;
	Style* _tmp4_;
	Style* _tmp5_;
	LinkDash* _tmp6_;
	LinkDash* _tmp7_;
	const gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	_tmp0_ = node_get_style (n);
	_tmp1_ = _tmp0_;
	_tmp2_ = style_get_link_arrow (_tmp1_);
	_tmp3_ = _tmp2_;
	arrow = *_tmp3_;
	_tmp4_ = node_get_style (n);
	_tmp5_ = _tmp4_;
	_tmp6_ = style_get_link_dash (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_->name;
	solid = g_strcmp0 (_tmp8_, "solid") == 0;
	if (arrow) {
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		if (solid) {
			_tmp9_ = "-->";
		} else {
			_tmp9_ = "-.->";
		}
		_tmp10_ = g_strdup (_tmp9_);
		result = _tmp10_;
		return result;
	} else {
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		if (solid) {
			_tmp11_ = "---";
		} else {
			_tmp11_ = "-.-";
		}
		_tmp12_ = g_strdup (_tmp11_);
		result = _tmp12_;
		return result;
	}
}

static GdkRGBA*
_vala_GdkRGBA_copy (GdkRGBA* self)
{
	return g_boxed_copy (gdk_rgba_get_type (), self);
}

static gpointer
__vala_GdkRGBA_copy0 (gpointer self)
{
	return self ? _vala_GdkRGBA_copy (self) : NULL;
}

static void
_vala_GdkRGBA_free (GdkRGBA* self)
{
	g_boxed_free (gdk_rgba_get_type (), self);
}

static gchar*
export_mermaid_make_link_color (ExportMermaid* self,
                                Node* n)
{
	GdkRGBA* rgba = NULL;
	GdkRGBA* _tmp0_;
	GdkRGBA* _tmp1_;
	GdkRGBA* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	_tmp0_ = node_get_link_color (n);
	_tmp1_ = _tmp0_;
	_tmp2_ = __vala_GdkRGBA_copy0 (_tmp1_);
	rgba = _tmp2_;
	_tmp3_ = g_strdup_printf ("#%02x%02x%02x", (guint) ((gint) ((*rgba).red * 255)), (guint) ((gint) ((*rgba).green * 255)), (guint) ((gint) ((*rgba).blue * 255)));
	result = _tmp3_;
	__vala_GdkRGBA_free0 (rgba);
	return result;
}

static gchar*
export_mermaid_make_node_style (ExportMermaid* self,
                                Node* n)
{
	gchar* color = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	Style* _tmp2_;
	Style* _tmp3_;
	gboolean* _tmp4_;
	gboolean* _tmp5_;
	gchar* fill = NULL;
	gchar* _tmp11_;
	gchar* width = NULL;
	Style* _tmp12_;
	Style* _tmp13_;
	gint* _tmp14_;
	gint* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	_tmp0_ = export_mermaid_make_link_color (self, n);
	color = _tmp0_;
	_tmp2_ = node_get_style (n);
	_tmp3_ = _tmp2_;
	_tmp4_ = style_get_node_fill (_tmp3_);
	_tmp5_ = _tmp4_;
	if (*_tmp5_) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = color;
		_tmp7_ = g_strconcat ("fill:", _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp8_, ",", NULL);
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp9_;
		_g_free0 (_tmp8_);
	} else {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("");
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp10_;
	}
	_tmp11_ = g_strdup (_tmp1_);
	fill = _tmp11_;
	_tmp12_ = node_get_style (n);
	_tmp13_ = _tmp12_;
	_tmp14_ = style_get_node_borderwidth (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strdup_printf ("%i", *_tmp15_);
	width = _tmp16_;
	_tmp17_ = export_mermaid_make_id (self, n);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat ("style ", _tmp18_, NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strconcat (_tmp20_, " ", NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strconcat (_tmp22_, fill, NULL);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strconcat (_tmp24_, "stroke:", NULL);
	_tmp26_ = _tmp25_;
	_tmp27_ = color;
	_tmp28_ = g_strconcat (_tmp26_, _tmp27_, NULL);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strconcat (_tmp29_, ",stroke-width:", NULL);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strconcat (_tmp31_, width, NULL);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_strconcat (_tmp33_, "px", NULL);
	_tmp35_ = _tmp34_;
	_g_free0 (_tmp33_);
	_g_free0 (_tmp31_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp26_);
	_g_free0 (_tmp24_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	result = _tmp35_;
	_g_free0 (width);
	_g_free0 (fill);
	_g_free0 (_tmp1_);
	_g_free0 (color);
	return result;
}

static gdouble*
_vala_array_dup4 (gdouble* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gdouble));
	}
	return NULL;
}

static gchar*
export_mermaid_make_link_style (ExportMermaid* self,
                                Node* n,
                                gint* link_id)
{
	gchar* color = NULL;
	gchar* _tmp0_;
	gchar* width = NULL;
	Style* _tmp1_;
	Style* _tmp2_;
	gint* _tmp3_;
	gint* _tmp4_;
	gchar* _tmp5_;
	gint lid = 0;
	gint _tmp6_;
	gdouble* pattern = NULL;
	Style* _tmp7_;
	Style* _tmp8_;
	LinkDash* _tmp9_;
	LinkDash* _tmp10_;
	gdouble* _tmp11_;
	gint _tmp11__length1;
	gdouble* _tmp12_;
	gint _tmp12__length1;
	gint pattern_length1;
	gint _pattern_size_;
	gchar* pattern_str = NULL;
	gchar* _tmp13_;
	gdouble* _tmp14_;
	gint _tmp14__length1;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	_tmp0_ = export_mermaid_make_link_color (self, n);
	color = _tmp0_;
	_tmp1_ = node_get_style (n);
	_tmp2_ = _tmp1_;
	_tmp3_ = style_get_link_width (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%i", *_tmp4_);
	width = _tmp5_;
	_tmp6_ = *link_id;
	*link_id = _tmp6_ + 1;
	lid = _tmp6_;
	_tmp7_ = node_get_style (n);
	_tmp8_ = _tmp7_;
	_tmp9_ = style_get_link_dash (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_->pattern;
	_tmp11__length1 = _tmp10_->pattern_length1;
	_tmp12_ = (_tmp11_ != NULL) ? _vala_array_dup4 (_tmp11_, _tmp11__length1) : _tmp11_;
	_tmp12__length1 = _tmp11__length1;
	pattern = _tmp12_;
	pattern_length1 = _tmp12__length1;
	_pattern_size_ = pattern_length1;
	_tmp13_ = g_strdup ("");
	pattern_str = _tmp13_;
	_tmp14_ = pattern;
	_tmp14__length1 = pattern_length1;
	if (_tmp14__length1 > 0) {
		gchar* _tmp15_;
		_tmp15_ = g_strdup (",stroke-dasharray:");
		_g_free0 (pattern_str);
		pattern_str = _tmp15_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp16_ = FALSE;
				_tmp16_ = TRUE;
				while (TRUE) {
					gdouble* _tmp18_;
					gint _tmp18__length1;
					const gchar* _tmp19_ = NULL;
					const gchar* _tmp20_;
					gdouble* _tmp21_;
					gint _tmp21__length1;
					gdouble _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					if (!_tmp16_) {
						gint _tmp17_;
						_tmp17_ = i;
						i = _tmp17_ + 1;
					}
					_tmp16_ = FALSE;
					_tmp18_ = pattern;
					_tmp18__length1 = pattern_length1;
					if (!(i < _tmp18__length1)) {
						break;
					}
					if (i == 0) {
						_tmp19_ = "";
					} else {
						_tmp19_ = ",";
					}
					_tmp20_ = pattern_str;
					_tmp21_ = pattern;
					_tmp21__length1 = pattern_length1;
					_tmp22_ = _tmp21_[i];
					_tmp23_ = g_strdup_printf ("%s%d", _tmp19_, (gint) _tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = g_strconcat (_tmp20_, _tmp24_, NULL);
					_g_free0 (pattern_str);
					pattern_str = _tmp25_;
					_g_free0 (_tmp24_);
				}
			}
		}
	}
	_tmp26_ = g_strdup_printf ("%i", lid);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strconcat ("linkStyle ", _tmp27_, NULL);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strconcat (_tmp29_, " stroke:", NULL);
	_tmp31_ = _tmp30_;
	_tmp32_ = color;
	_tmp33_ = g_strconcat (_tmp31_, _tmp32_, NULL);
	_tmp34_ = _tmp33_;
	_tmp35_ = g_strconcat (_tmp34_, ",stroke-width:", NULL);
	_tmp36_ = _tmp35_;
	_tmp37_ = width;
	_tmp38_ = g_strconcat (_tmp36_, _tmp37_, NULL);
	_tmp39_ = _tmp38_;
	_tmp40_ = g_strconcat (_tmp39_, "px", NULL);
	_tmp41_ = _tmp40_;
	_tmp42_ = pattern_str;
	_tmp43_ = g_strconcat (_tmp41_, _tmp42_, NULL);
	_tmp44_ = _tmp43_;
	_g_free0 (_tmp41_);
	_g_free0 (_tmp39_);
	_g_free0 (_tmp36_);
	_g_free0 (_tmp34_);
	_g_free0 (_tmp31_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp27_);
	result = _tmp44_;
	_g_free0 (pattern_str);
	pattern = (g_free (pattern), NULL);
	_g_free0 (width);
	_g_free0 (color);
	return result;
}

static void
export_mermaid_export_node (ExportMermaid* self,
                            GFileOutputStream* os,
                            Node* node,
                            gint* link_id)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	g_return_if_fail (node != NULL);
	{
		gchar* title = NULL;
		gchar* _tmp0_;
		GArray* children = NULL;
		GArray* _tmp1_;
		gboolean _tmp2_ = FALSE;
		_tmp0_ = export_mermaid_make_title (self, node);
		title = _tmp0_;
		_tmp1_ = node_children (node);
		children = _tmp1_;
		if (node_is_root (node)) {
			GArray* _tmp3_;
			_tmp3_ = children;
			_tmp2_ = _tmp3_->len == ((guint) 0);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gchar* line = NULL;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp9_;
			guint8* _tmp10_;
			gint _tmp10__length1;
			gint _tmp11_ = 0;
			guint8* _tmp12_;
			gint _tmp12__length1;
			_tmp4_ = title;
			_tmp5_ = g_strconcat ("  ", _tmp4_, NULL);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strconcat (_tmp6_, ";\n", NULL);
			_tmp8_ = _tmp7_;
			_g_free0 (_tmp6_);
			line = _tmp8_;
			_tmp9_ = line;
			_tmp10_ = string_get_data (_tmp9_, &_tmp11_);
			_tmp10__length1 = _tmp11_;
			_tmp12_ = _tmp10_;
			_tmp12__length1 = _tmp10__length1;
			g_output_stream_write ((GOutputStream*) os, _tmp12_, (gsize) _tmp12__length1, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (line);
				_g_array_unref0 (children);
				_g_free0 (title);
				goto __catch0_g_error;
			}
			_g_free0 (line);
		} else {
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp13_ = FALSE;
					_tmp13_ = TRUE;
					while (TRUE) {
						GArray* _tmp15_;
						gchar* link = NULL;
						GArray* _tmp16_;
						Node* _tmp17_;
						gchar* _tmp18_;
						gchar* ctitle = NULL;
						GArray* _tmp19_;
						Node* _tmp20_;
						gchar* _tmp21_;
						gchar* nstyle = NULL;
						GArray* _tmp22_;
						Node* _tmp23_;
						gchar* _tmp24_;
						gchar* lstyle = NULL;
						GArray* _tmp25_;
						Node* _tmp26_;
						gchar* _tmp27_;
						gchar* line = NULL;
						const gchar* _tmp28_;
						gchar* _tmp29_;
						gchar* _tmp30_;
						gchar* _tmp31_;
						gchar* _tmp32_;
						const gchar* _tmp33_;
						gchar* _tmp34_;
						gchar* _tmp35_;
						gchar* _tmp36_;
						gchar* _tmp37_;
						const gchar* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						const gchar* _tmp43_;
						gchar* _tmp44_;
						gchar* _tmp45_;
						gchar* _tmp46_;
						gchar* _tmp47_;
						const gchar* _tmp48_;
						gchar* _tmp49_;
						gchar* _tmp50_;
						gchar* _tmp51_;
						gchar* _tmp52_;
						const gchar* _tmp53_;
						guint8* _tmp54_;
						gint _tmp54__length1;
						gint _tmp55_ = 0;
						guint8* _tmp56_;
						gint _tmp56__length1;
						GArray* _tmp57_;
						Node* _tmp58_;
						if (!_tmp13_) {
							gint _tmp14_;
							_tmp14_ = i;
							i = _tmp14_ + 1;
						}
						_tmp13_ = FALSE;
						_tmp15_ = children;
						if (!(((guint) i) < _tmp15_->len)) {
							break;
						}
						_tmp16_ = children;
						_tmp17_ = g_array_index (_tmp16_, Node*, (guint) i);
						_tmp18_ = export_mermaid_make_link (self, _tmp17_);
						link = _tmp18_;
						_tmp19_ = children;
						_tmp20_ = g_array_index (_tmp19_, Node*, (guint) i);
						_tmp21_ = export_mermaid_make_title (self, _tmp20_);
						ctitle = _tmp21_;
						_tmp22_ = children;
						_tmp23_ = g_array_index (_tmp22_, Node*, (guint) i);
						_tmp24_ = export_mermaid_make_node_style (self, _tmp23_);
						nstyle = _tmp24_;
						_tmp25_ = children;
						_tmp26_ = g_array_index (_tmp25_, Node*, (guint) i);
						_tmp27_ = export_mermaid_make_link_style (self, _tmp26_, link_id);
						lstyle = _tmp27_;
						_tmp28_ = title;
						_tmp29_ = g_strconcat ("  ", _tmp28_, NULL);
						_tmp30_ = _tmp29_;
						_tmp31_ = g_strconcat (_tmp30_, " ", NULL);
						_tmp32_ = _tmp31_;
						_tmp33_ = link;
						_tmp34_ = g_strconcat (_tmp32_, _tmp33_, NULL);
						_tmp35_ = _tmp34_;
						_tmp36_ = g_strconcat (_tmp35_, " ", NULL);
						_tmp37_ = _tmp36_;
						_tmp38_ = ctitle;
						_tmp39_ = g_strconcat (_tmp37_, _tmp38_, NULL);
						_tmp40_ = _tmp39_;
						_tmp41_ = g_strconcat (_tmp40_, ";  ", NULL);
						_tmp42_ = _tmp41_;
						_tmp43_ = nstyle;
						_tmp44_ = g_strconcat (_tmp42_, _tmp43_, NULL);
						_tmp45_ = _tmp44_;
						_tmp46_ = g_strconcat (_tmp45_, ";  ", NULL);
						_tmp47_ = _tmp46_;
						_tmp48_ = lstyle;
						_tmp49_ = g_strconcat (_tmp47_, _tmp48_, NULL);
						_tmp50_ = _tmp49_;
						_tmp51_ = g_strconcat (_tmp50_, ";\n", NULL);
						_tmp52_ = _tmp51_;
						_g_free0 (_tmp50_);
						_g_free0 (_tmp47_);
						_g_free0 (_tmp45_);
						_g_free0 (_tmp42_);
						_g_free0 (_tmp40_);
						_g_free0 (_tmp37_);
						_g_free0 (_tmp35_);
						_g_free0 (_tmp32_);
						_g_free0 (_tmp30_);
						line = _tmp52_;
						_tmp53_ = line;
						_tmp54_ = string_get_data (_tmp53_, &_tmp55_);
						_tmp54__length1 = _tmp55_;
						_tmp56_ = _tmp54_;
						_tmp56__length1 = _tmp54__length1;
						g_output_stream_write ((GOutputStream*) os, _tmp56_, (gsize) _tmp56__length1, NULL, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (line);
							_g_free0 (lstyle);
							_g_free0 (nstyle);
							_g_free0 (ctitle);
							_g_free0 (link);
							_g_array_unref0 (children);
							_g_free0 (title);
							goto __catch0_g_error;
						}
						_tmp57_ = children;
						_tmp58_ = g_array_index (_tmp57_, Node*, (guint) i);
						export_mermaid_export_node (self, os, _tmp58_, link_id);
						_g_free0 (line);
						_g_free0 (lstyle);
						_g_free0 (nstyle);
						_g_free0 (ctitle);
						_g_free0 (link);
					}
				}
			}
		}
		_g_array_unref0 (children);
		_g_free0 (title);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
export_mermaid_class_init (ExportMermaidClass * klass,
                           gpointer klass_data)
{
	export_mermaid_parent_class = g_type_class_peek_parent (klass);
	((ExportClass *) klass)->export = (gboolean (*) (Export*, const gchar*, DrawArea*)) export_mermaid_real_export;
}

static void
export_mermaid_instance_init (ExportMermaid * self,
                              gpointer klass)
{
}

static GType
export_mermaid_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExportMermaidClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) export_mermaid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExportMermaid), 0, (GInstanceInitFunc) export_mermaid_instance_init, NULL };
	GType export_mermaid_type_id;
	export_mermaid_type_id = g_type_register_static (TYPE_EXPORT, "ExportMermaid", &g_define_type_info, 0);
	return export_mermaid_type_id;
}

GType
export_mermaid_get_type (void)
{
	static volatile gsize export_mermaid_type_id__once = 0;
	if (g_once_init_enter (&export_mermaid_type_id__once)) {
		GType export_mermaid_type_id;
		export_mermaid_type_id = export_mermaid_get_type_once ();
		g_once_init_leave (&export_mermaid_type_id__once, export_mermaid_type_id);
	}
	return export_mermaid_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

