/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	corev1 "k8s.io/api/core/v1"
)

// SeccompProfileApplyConfiguration represents a declarative configuration of the SeccompProfile type for use
// with apply.
//
// SeccompProfile defines a pod/container's seccomp profile settings.
// Only one profile source may be set.
type SeccompProfileApplyConfiguration struct {
	// type indicates which kind of seccomp profile will be applied.
	// Valid options are:
	//
	// Localhost - a profile defined in a file on the node should be used.
	// RuntimeDefault - the container runtime default profile should be used.
	// Unconfined - no profile should be applied.
	Type *corev1.SeccompProfileType `json:"type,omitempty"`
	// localhostProfile indicates a profile defined in a file on the node should be used.
	// The profile must be preconfigured on the node to work.
	// Must be a descending path, relative to the kubelet's configured seccomp profile location.
	// Must be set if type is "Localhost". Must NOT be set for any other type.
	LocalhostProfile *string `json:"localhostProfile,omitempty"`
}

// SeccompProfileApplyConfiguration constructs a declarative configuration of the SeccompProfile type for use with
// apply.
func SeccompProfile() *SeccompProfileApplyConfiguration {
	return &SeccompProfileApplyConfiguration{}
}

// WithType sets the Type field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Type field is set to the value of the last call.
func (b *SeccompProfileApplyConfiguration) WithType(value corev1.SeccompProfileType) *SeccompProfileApplyConfiguration {
	b.Type = &value
	return b
}

// WithLocalhostProfile sets the LocalhostProfile field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LocalhostProfile field is set to the value of the last call.
func (b *SeccompProfileApplyConfiguration) WithLocalhostProfile(value string) *SeccompProfileApplyConfiguration {
	b.LocalhostProfile = &value
	return b
}
