#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 5013
#define LARGE_STATE_COUNT 1100
#define SYMBOL_COUNT 395
#define ALIAS_COUNT 7
#define TOKEN_COUNT 167
#define EXTERNAL_TOKEN_COUNT 5
#define FIELD_COUNT 51
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 330

enum {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_export = 3,
  anon_sym_STAR = 4,
  anon_sym_default = 5,
  anon_sym_type = 6,
  anon_sym_EQ = 7,
  anon_sym_as = 8,
  anon_sym_namespace = 9,
  anon_sym_LBRACE = 10,
  anon_sym_COMMA = 11,
  anon_sym_RBRACE = 12,
  anon_sym_typeof = 13,
  anon_sym_import = 14,
  anon_sym_from = 15,
  anon_sym_var = 16,
  anon_sym_let = 17,
  anon_sym_const = 18,
  anon_sym_BANG = 19,
  anon_sym_else = 20,
  anon_sym_if = 21,
  anon_sym_switch = 22,
  anon_sym_for = 23,
  anon_sym_LPAREN = 24,
  anon_sym_RPAREN = 25,
  anon_sym_await = 26,
  anon_sym_in = 27,
  anon_sym_of = 28,
  anon_sym_while = 29,
  anon_sym_do = 30,
  anon_sym_try = 31,
  anon_sym_with = 32,
  anon_sym_break = 33,
  anon_sym_continue = 34,
  anon_sym_debugger = 35,
  anon_sym_return = 36,
  anon_sym_throw = 37,
  anon_sym_SEMI = 38,
  anon_sym_COLON = 39,
  anon_sym_case = 40,
  anon_sym_catch = 41,
  anon_sym_finally = 42,
  anon_sym_yield = 43,
  anon_sym_LBRACK = 44,
  anon_sym_RBRACK = 45,
  sym__glimmer_template_content = 46,
  anon_sym_LTtemplate_GT = 47,
  anon_sym_LT_SLASHtemplate_GT = 48,
  anon_sym_LT = 49,
  anon_sym_GT = 50,
  anon_sym_SLASH = 51,
  anon_sym_DOT = 52,
  anon_sym_class = 53,
  anon_sym_async = 54,
  anon_sym_function = 55,
  anon_sym_EQ_GT = 56,
  anon_sym_QMARK_DOT = 57,
  anon_sym_new = 58,
  anon_sym_PLUS_EQ = 59,
  anon_sym_DASH_EQ = 60,
  anon_sym_STAR_EQ = 61,
  anon_sym_SLASH_EQ = 62,
  anon_sym_PERCENT_EQ = 63,
  anon_sym_CARET_EQ = 64,
  anon_sym_AMP_EQ = 65,
  anon_sym_PIPE_EQ = 66,
  anon_sym_GT_GT_EQ = 67,
  anon_sym_GT_GT_GT_EQ = 68,
  anon_sym_LT_LT_EQ = 69,
  anon_sym_STAR_STAR_EQ = 70,
  anon_sym_AMP_AMP_EQ = 71,
  anon_sym_PIPE_PIPE_EQ = 72,
  anon_sym_QMARK_QMARK_EQ = 73,
  anon_sym_DOT_DOT_DOT = 74,
  anon_sym_AMP_AMP = 75,
  anon_sym_PIPE_PIPE = 76,
  anon_sym_GT_GT = 77,
  anon_sym_GT_GT_GT = 78,
  anon_sym_LT_LT = 79,
  anon_sym_AMP = 80,
  anon_sym_CARET = 81,
  anon_sym_PIPE = 82,
  anon_sym_PLUS = 83,
  anon_sym_DASH = 84,
  anon_sym_PERCENT = 85,
  anon_sym_STAR_STAR = 86,
  anon_sym_LT_EQ = 87,
  anon_sym_EQ_EQ = 88,
  anon_sym_EQ_EQ_EQ = 89,
  anon_sym_BANG_EQ = 90,
  anon_sym_BANG_EQ_EQ = 91,
  anon_sym_GT_EQ = 92,
  anon_sym_QMARK_QMARK = 93,
  anon_sym_instanceof = 94,
  anon_sym_TILDE = 95,
  anon_sym_void = 96,
  anon_sym_delete = 97,
  anon_sym_PLUS_PLUS = 98,
  anon_sym_DASH_DASH = 99,
  anon_sym_DQUOTE = 100,
  anon_sym_SQUOTE = 101,
  sym_unescaped_double_string_fragment = 102,
  sym_unescaped_single_string_fragment = 103,
  sym_escape_sequence = 104,
  sym_comment = 105,
  anon_sym_BQUOTE = 106,
  anon_sym_DOLLAR_LBRACE = 107,
  anon_sym_SLASH2 = 108,
  sym_regex_pattern = 109,
  sym_regex_flags = 110,
  sym_number = 111,
  sym_private_property_identifier = 112,
  anon_sym_target = 113,
  sym_this = 114,
  sym_super = 115,
  sym_true = 116,
  sym_false = 117,
  sym_null = 118,
  sym_undefined = 119,
  anon_sym_AT = 120,
  anon_sym_static = 121,
  anon_sym_readonly = 122,
  anon_sym_get = 123,
  anon_sym_set = 124,
  anon_sym_QMARK = 125,
  anon_sym_declare = 126,
  anon_sym_public = 127,
  anon_sym_private = 128,
  anon_sym_protected = 129,
  anon_sym_override = 130,
  anon_sym_module = 131,
  anon_sym_any = 132,
  anon_sym_number = 133,
  anon_sym_boolean = 134,
  anon_sym_string = 135,
  anon_sym_symbol = 136,
  anon_sym_property = 137,
  anon_sym_signal = 138,
  anon_sym_on = 139,
  anon_sym_required = 140,
  anon_sym_component = 141,
  anon_sym_abstract = 142,
  anon_sym_require = 143,
  anon_sym_extends = 144,
  anon_sym_implements = 145,
  anon_sym_global = 146,
  anon_sym_interface = 147,
  anon_sym_enum = 148,
  anon_sym_DASH_QMARK_COLON = 149,
  anon_sym_QMARK_COLON = 150,
  anon_sym_asserts = 151,
  anon_sym_infer = 152,
  anon_sym_is = 153,
  anon_sym_keyof = 154,
  anon_sym_unknown = 155,
  anon_sym_never = 156,
  anon_sym_object = 157,
  anon_sym_LBRACE_PIPE = 158,
  anon_sym_PIPE_RBRACE = 159,
  anon_sym_pragma = 160,
  aux_sym_ui_version_specifier_token1 = 161,
  anon_sym_list = 162,
  sym__automatic_semicolon = 163,
  sym__template_chars = 164,
  sym__ternary_qmark = 165,
  sym__function_signature_automatic_semicolon = 166,
  sym_program = 167,
  sym_export_statement = 168,
  sym_export_clause = 169,
  sym__import_export_specifier = 170,
  sym_declaration = 171,
  sym_import = 172,
  sym_import_statement = 173,
  sym_import_clause = 174,
  sym__from_clause = 175,
  sym_namespace_import_export = 176,
  sym_named_imports = 177,
  sym_expression_statement = 178,
  sym_variable_declaration = 179,
  sym_lexical_declaration = 180,
  sym_variable_declarator = 181,
  sym_statement_block = 182,
  sym_else_clause = 183,
  sym_if_statement = 184,
  sym_switch_statement = 185,
  sym_for_statement = 186,
  sym_for_in_statement = 187,
  sym__for_header = 188,
  sym_while_statement = 189,
  sym_do_statement = 190,
  sym_try_statement = 191,
  sym_with_statement = 192,
  sym_break_statement = 193,
  sym_continue_statement = 194,
  sym_debugger_statement = 195,
  sym_return_statement = 196,
  sym_throw_statement = 197,
  sym_empty_statement = 198,
  sym_labeled_statement = 199,
  sym_switch_body = 200,
  sym_switch_case = 201,
  sym_switch_default = 202,
  sym_catch_clause = 203,
  sym_finally_clause = 204,
  sym_parenthesized_expression = 205,
  sym_expression = 206,
  sym_primary_expression = 207,
  sym_yield_expression = 208,
  sym_object = 209,
  sym_object_pattern = 210,
  sym_assignment_pattern = 211,
  sym_object_assignment_pattern = 212,
  sym_array = 213,
  sym_array_pattern = 214,
  sym_glimmer_template = 215,
  sym_glimmer_opening_tag = 216,
  sym_glimmer_closing_tag = 217,
  sym_nested_identifier = 218,
  sym_class = 219,
  sym_class_declaration = 220,
  sym_class_heritage = 221,
  sym_function = 222,
  sym_function_declaration = 223,
  sym_generator_function = 224,
  sym_generator_function_declaration = 225,
  sym_arrow_function = 226,
  sym__call_signature = 227,
  sym__formal_parameter = 228,
  sym_optional_chain = 229,
  sym_call_expression = 230,
  sym_new_expression = 231,
  sym_await_expression = 232,
  sym_member_expression = 233,
  sym_subscript_expression = 234,
  sym_assignment_expression = 235,
  sym__augmented_assignment_lhs = 236,
  sym_augmented_assignment_expression = 237,
  sym__initializer = 238,
  sym__destructuring_pattern = 239,
  sym_spread_element = 240,
  sym_ternary_expression = 241,
  sym_binary_expression = 242,
  sym_unary_expression = 243,
  sym_update_expression = 244,
  sym_sequence_expression = 245,
  sym_string = 246,
  sym_template_string = 247,
  sym_template_substitution = 248,
  sym_regex = 249,
  sym_meta_property = 250,
  sym_arguments = 251,
  sym_decorator = 252,
  sym_decorator_member_expression = 253,
  sym_decorator_call_expression = 254,
  sym_class_body = 255,
  sym_formal_parameters = 256,
  sym_pattern = 257,
  sym_rest_pattern = 258,
  sym_method_definition = 259,
  sym_pair = 260,
  sym_pair_pattern = 261,
  sym__property_name = 262,
  sym_computed_property_name = 263,
  sym_public_field_definition = 264,
  sym_non_null_expression = 265,
  sym_method_signature = 266,
  sym_abstract_method_signature = 267,
  sym_function_signature = 268,
  sym_type_assertion = 269,
  sym_as_expression = 270,
  sym_import_require_clause = 271,
  sym_extends_clause = 272,
  sym_implements_clause = 273,
  sym_ambient_declaration = 274,
  sym_abstract_class_declaration = 275,
  sym_module = 276,
  sym_internal_module = 277,
  sym__module = 278,
  sym_import_alias = 279,
  sym_nested_type_identifier = 280,
  sym_interface_declaration = 281,
  sym_extends_type_clause = 282,
  sym_enum_declaration = 283,
  sym_enum_body = 284,
  sym_enum_assignment = 285,
  sym_type_alias_declaration = 286,
  sym_accessibility_modifier = 287,
  sym_override_modifier = 288,
  sym_required_parameter = 289,
  sym_optional_parameter = 290,
  sym__parameter_name = 291,
  sym_omitting_type_annotation = 292,
  sym_opting_type_annotation = 293,
  sym_type_annotation = 294,
  sym_asserts = 295,
  sym__type = 296,
  sym_tuple_parameter = 297,
  sym_optional_tuple_parameter = 298,
  sym_optional_type = 299,
  sym_rest_type = 300,
  sym__tuple_type_member = 301,
  sym_constructor_type = 302,
  sym__primary_type = 303,
  sym_template_type = 304,
  sym_template_literal_type = 305,
  sym_infer_type = 306,
  sym_conditional_type = 307,
  sym_generic_type = 308,
  sym_type_predicate = 309,
  sym_type_predicate_annotation = 310,
  sym__type_query_member_expression = 311,
  sym__type_query_subscript_expression = 312,
  sym__type_query_call_expression = 313,
  sym_type_query = 314,
  sym_index_type_query = 315,
  sym_lookup_type = 316,
  sym_mapped_type_clause = 317,
  sym_literal_type = 318,
  sym__number = 319,
  sym_existential_type = 320,
  sym_flow_maybe_type = 321,
  sym_parenthesized_type = 322,
  sym_predefined_type = 323,
  sym_type_arguments = 324,
  sym_object_type = 325,
  sym_call_signature = 326,
  sym_property_signature = 327,
  sym_type_parameters = 328,
  sym_type_parameter = 329,
  sym_default_type = 330,
  sym_constraint = 331,
  sym_construct_signature = 332,
  sym_index_signature = 333,
  sym_array_type = 334,
  sym_tuple_type = 335,
  sym_readonly_type = 336,
  sym_union_type = 337,
  sym_intersection_type = 338,
  sym_function_type = 339,
  sym_ui_pragma = 340,
  sym_ui_import = 341,
  sym_ui_version_specifier = 342,
  sym_ui_object_definition = 343,
  sym_ui_annotated_object = 344,
  sym_ui_annotation = 345,
  sym_ui_object_initializer = 346,
  sym_ui_annotated_object_member = 347,
  sym_ui_object_definition_binding = 348,
  sym_ui_binding = 349,
  sym_ui_property = 350,
  sym_ui_list_property_type = 351,
  sym_ui_property_modifier = 352,
  sym_ui_object_array = 353,
  sym_ui_required = 354,
  sym_ui_signal = 355,
  sym_ui_signal_parameters = 356,
  sym_ui_signal_parameter = 357,
  sym_ui_inline_component = 358,
  sym__qml_enum_declaration = 359,
  sym__qml_enum_body = 360,
  sym__qml_enum_assignment = 361,
  sym__qml_enum_negative_number = 362,
  sym_ui_nested_identifier = 363,
  aux_sym_program_repeat1 = 364,
  aux_sym_export_statement_repeat1 = 365,
  aux_sym_export_clause_repeat1 = 366,
  aux_sym_named_imports_repeat1 = 367,
  aux_sym_variable_declaration_repeat1 = 368,
  aux_sym_statement_block_repeat1 = 369,
  aux_sym_switch_body_repeat1 = 370,
  aux_sym_object_repeat1 = 371,
  aux_sym_object_pattern_repeat1 = 372,
  aux_sym_array_repeat1 = 373,
  aux_sym_array_pattern_repeat1 = 374,
  aux_sym_glimmer_template_repeat1 = 375,
  aux_sym_string_repeat1 = 376,
  aux_sym_string_repeat2 = 377,
  aux_sym_template_string_repeat1 = 378,
  aux_sym_class_body_repeat1 = 379,
  aux_sym_formal_parameters_repeat1 = 380,
  aux_sym_extends_clause_repeat1 = 381,
  aux_sym_implements_clause_repeat1 = 382,
  aux_sym_extends_type_clause_repeat1 = 383,
  aux_sym_enum_body_repeat1 = 384,
  aux_sym_template_literal_type_repeat1 = 385,
  aux_sym_object_type_repeat1 = 386,
  aux_sym_type_parameters_repeat1 = 387,
  aux_sym_tuple_type_repeat1 = 388,
  aux_sym_ui_annotated_object_repeat1 = 389,
  aux_sym_ui_object_initializer_repeat1 = 390,
  aux_sym_ui_property_repeat1 = 391,
  aux_sym_ui_object_array_repeat1 = 392,
  aux_sym_ui_signal_parameters_repeat1 = 393,
  aux_sym__qml_enum_body_repeat1 = 394,
  alias_sym_import_specifier = 395,
  alias_sym_namespace_export = 396,
  alias_sym_property_identifier = 397,
  alias_sym_shorthand_property_identifier = 398,
  alias_sym_shorthand_property_identifier_pattern = 399,
  alias_sym_statement_identifier = 400,
  alias_sym_this_type = 401,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_export] = "export",
  [anon_sym_STAR] = "*",
  [anon_sym_default] = "default",
  [anon_sym_type] = "type",
  [anon_sym_EQ] = "=",
  [anon_sym_as] = "as",
  [anon_sym_namespace] = "namespace",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_typeof] = "typeof",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_var] = "var",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_BANG] = "!",
  [anon_sym_else] = "else",
  [anon_sym_if] = "if",
  [anon_sym_switch] = "switch",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_in] = "in",
  [anon_sym_of] = "of",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_with] = "with",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_debugger] = "debugger",
  [anon_sym_return] = "return",
  [anon_sym_throw] = "throw",
  [anon_sym_SEMI] = ";",
  [anon_sym_COLON] = ":",
  [anon_sym_case] = "case",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_yield] = "yield",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [sym__glimmer_template_content] = "_glimmer_template_content",
  [anon_sym_LTtemplate_GT] = "<template>",
  [anon_sym_LT_SLASHtemplate_GT] = "</template>",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_SLASH] = "/",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_async] = "async",
  [anon_sym_function] = "function",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_QMARK_DOT] = "\?.",
  [anon_sym_new] = "new",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_AMP_AMP_EQ] = "&&=",
  [anon_sym_PIPE_PIPE_EQ] = "||=",
  [anon_sym_QMARK_QMARK_EQ] = "\?\?=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_TILDE] = "~",
  [anon_sym_void] = "void",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_unescaped_single_string_fragment] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [sym_comment] = "comment",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH2] = "/",
  [sym_regex_pattern] = "regex_pattern",
  [sym_regex_flags] = "regex_flags",
  [sym_number] = "number",
  [sym_private_property_identifier] = "private_property_identifier",
  [anon_sym_target] = "target",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_undefined] = "undefined",
  [anon_sym_AT] = "@",
  [anon_sym_static] = "static",
  [anon_sym_readonly] = "readonly",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [anon_sym_QMARK] = "\?",
  [anon_sym_declare] = "declare",
  [anon_sym_public] = "public",
  [anon_sym_private] = "private",
  [anon_sym_protected] = "protected",
  [anon_sym_override] = "override",
  [anon_sym_module] = "module",
  [anon_sym_any] = "any",
  [anon_sym_number] = "number",
  [anon_sym_boolean] = "boolean",
  [anon_sym_string] = "string",
  [anon_sym_symbol] = "symbol",
  [anon_sym_property] = "property",
  [anon_sym_signal] = "signal",
  [anon_sym_on] = "on",
  [anon_sym_required] = "required",
  [anon_sym_component] = "component",
  [anon_sym_abstract] = "abstract",
  [anon_sym_require] = "require",
  [anon_sym_extends] = "extends",
  [anon_sym_implements] = "implements",
  [anon_sym_global] = "global",
  [anon_sym_interface] = "interface",
  [anon_sym_enum] = "enum",
  [anon_sym_DASH_QMARK_COLON] = "-\?:",
  [anon_sym_QMARK_COLON] = "\?:",
  [anon_sym_asserts] = "asserts",
  [anon_sym_infer] = "infer",
  [anon_sym_is] = "is",
  [anon_sym_keyof] = "keyof",
  [anon_sym_unknown] = "unknown",
  [anon_sym_never] = "never",
  [anon_sym_object] = "object",
  [anon_sym_LBRACE_PIPE] = "{|",
  [anon_sym_PIPE_RBRACE] = "|}",
  [anon_sym_pragma] = "pragma",
  [aux_sym_ui_version_specifier_token1] = "number",
  [anon_sym_list] = "type_identifier",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars] = "_template_chars",
  [sym__ternary_qmark] = "\?",
  [sym__function_signature_automatic_semicolon] = "_function_signature_automatic_semicolon",
  [sym_program] = "program",
  [sym_export_statement] = "export_statement",
  [sym_export_clause] = "export_clause",
  [sym__import_export_specifier] = "export_specifier",
  [sym_declaration] = "declaration",
  [sym_import] = "import",
  [sym_import_statement] = "import_statement",
  [sym_import_clause] = "import_clause",
  [sym__from_clause] = "_from_clause",
  [sym_namespace_import_export] = "namespace_import",
  [sym_named_imports] = "named_imports",
  [sym_expression_statement] = "expression_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_lexical_declaration] = "lexical_declaration",
  [sym_variable_declarator] = "variable_declarator",
  [sym_statement_block] = "statement_block",
  [sym_else_clause] = "else_clause",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__for_header] = "_for_header",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_try_statement] = "try_statement",
  [sym_with_statement] = "with_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_debugger_statement] = "debugger_statement",
  [sym_return_statement] = "return_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_case] = "switch_case",
  [sym_switch_default] = "switch_default",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_yield_expression] = "yield_expression",
  [sym_object] = "object",
  [sym_object_pattern] = "object_pattern",
  [sym_assignment_pattern] = "assignment_pattern",
  [sym_object_assignment_pattern] = "object_assignment_pattern",
  [sym_array] = "array",
  [sym_array_pattern] = "array_pattern",
  [sym_glimmer_template] = "glimmer_template",
  [sym_glimmer_opening_tag] = "glimmer_opening_tag",
  [sym_glimmer_closing_tag] = "glimmer_closing_tag",
  [sym_nested_identifier] = "nested_identifier",
  [sym_class] = "class",
  [sym_class_declaration] = "class_declaration",
  [sym_class_heritage] = "class_heritage",
  [sym_function] = "function",
  [sym_function_declaration] = "function_declaration",
  [sym_generator_function] = "generator_function",
  [sym_generator_function_declaration] = "generator_function_declaration",
  [sym_arrow_function] = "arrow_function",
  [sym__call_signature] = "_call_signature",
  [sym__formal_parameter] = "_formal_parameter",
  [sym_optional_chain] = "optional_chain",
  [sym_call_expression] = "call_expression",
  [sym_new_expression] = "new_expression",
  [sym_await_expression] = "await_expression",
  [sym_member_expression] = "member_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym__augmented_assignment_lhs] = "_augmented_assignment_lhs",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym__initializer] = "_initializer",
  [sym__destructuring_pattern] = "_destructuring_pattern",
  [sym_spread_element] = "spread_element",
  [sym_ternary_expression] = "ternary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_sequence_expression] = "sequence_expression",
  [sym_string] = "string",
  [sym_template_string] = "template_string",
  [sym_template_substitution] = "template_substitution",
  [sym_regex] = "regex",
  [sym_meta_property] = "meta_property",
  [sym_arguments] = "arguments",
  [sym_decorator] = "decorator",
  [sym_decorator_member_expression] = "member_expression",
  [sym_decorator_call_expression] = "call_expression",
  [sym_class_body] = "class_body",
  [sym_formal_parameters] = "formal_parameters",
  [sym_pattern] = "pattern",
  [sym_rest_pattern] = "rest_pattern",
  [sym_method_definition] = "method_definition",
  [sym_pair] = "pair",
  [sym_pair_pattern] = "pair_pattern",
  [sym__property_name] = "_property_name",
  [sym_computed_property_name] = "computed_property_name",
  [sym_public_field_definition] = "public_field_definition",
  [sym_non_null_expression] = "non_null_expression",
  [sym_method_signature] = "method_signature",
  [sym_abstract_method_signature] = "abstract_method_signature",
  [sym_function_signature] = "function_signature",
  [sym_type_assertion] = "type_assertion",
  [sym_as_expression] = "as_expression",
  [sym_import_require_clause] = "import_require_clause",
  [sym_extends_clause] = "extends_clause",
  [sym_implements_clause] = "implements_clause",
  [sym_ambient_declaration] = "ambient_declaration",
  [sym_abstract_class_declaration] = "abstract_class_declaration",
  [sym_module] = "module",
  [sym_internal_module] = "internal_module",
  [sym__module] = "_module",
  [sym_import_alias] = "import_alias",
  [sym_nested_type_identifier] = "nested_type_identifier",
  [sym_interface_declaration] = "interface_declaration",
  [sym_extends_type_clause] = "extends_type_clause",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body] = "enum_body",
  [sym_enum_assignment] = "enum_assignment",
  [sym_type_alias_declaration] = "type_alias_declaration",
  [sym_accessibility_modifier] = "accessibility_modifier",
  [sym_override_modifier] = "override_modifier",
  [sym_required_parameter] = "required_parameter",
  [sym_optional_parameter] = "optional_parameter",
  [sym__parameter_name] = "_parameter_name",
  [sym_omitting_type_annotation] = "omitting_type_annotation",
  [sym_opting_type_annotation] = "opting_type_annotation",
  [sym_type_annotation] = "type_annotation",
  [sym_asserts] = "asserts",
  [sym__type] = "_type",
  [sym_tuple_parameter] = "required_parameter",
  [sym_optional_tuple_parameter] = "optional_parameter",
  [sym_optional_type] = "optional_type",
  [sym_rest_type] = "rest_type",
  [sym__tuple_type_member] = "_tuple_type_member",
  [sym_constructor_type] = "constructor_type",
  [sym__primary_type] = "_primary_type",
  [sym_template_type] = "template_type",
  [sym_template_literal_type] = "template_literal_type",
  [sym_infer_type] = "infer_type",
  [sym_conditional_type] = "conditional_type",
  [sym_generic_type] = "generic_type",
  [sym_type_predicate] = "type_predicate",
  [sym_type_predicate_annotation] = "type_predicate_annotation",
  [sym__type_query_member_expression] = "member_expression",
  [sym__type_query_subscript_expression] = "subscript_expression",
  [sym__type_query_call_expression] = "call_expression",
  [sym_type_query] = "type_query",
  [sym_index_type_query] = "index_type_query",
  [sym_lookup_type] = "lookup_type",
  [sym_mapped_type_clause] = "mapped_type_clause",
  [sym_literal_type] = "literal_type",
  [sym__number] = "unary_expression",
  [sym_existential_type] = "existential_type",
  [sym_flow_maybe_type] = "flow_maybe_type",
  [sym_parenthesized_type] = "parenthesized_type",
  [sym_predefined_type] = "predefined_type",
  [sym_type_arguments] = "type_arguments",
  [sym_object_type] = "object_type",
  [sym_call_signature] = "call_signature",
  [sym_property_signature] = "property_signature",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_default_type] = "default_type",
  [sym_constraint] = "constraint",
  [sym_construct_signature] = "construct_signature",
  [sym_index_signature] = "index_signature",
  [sym_array_type] = "array_type",
  [sym_tuple_type] = "tuple_type",
  [sym_readonly_type] = "readonly_type",
  [sym_union_type] = "union_type",
  [sym_intersection_type] = "intersection_type",
  [sym_function_type] = "function_type",
  [sym_ui_pragma] = "ui_pragma",
  [sym_ui_import] = "ui_import",
  [sym_ui_version_specifier] = "ui_version_specifier",
  [sym_ui_object_definition] = "ui_object_definition",
  [sym_ui_annotated_object] = "ui_annotated_object",
  [sym_ui_annotation] = "ui_annotation",
  [sym_ui_object_initializer] = "ui_object_initializer",
  [sym_ui_annotated_object_member] = "ui_annotated_object_member",
  [sym_ui_object_definition_binding] = "ui_object_definition_binding",
  [sym_ui_binding] = "ui_binding",
  [sym_ui_property] = "ui_property",
  [sym_ui_list_property_type] = "ui_list_property_type",
  [sym_ui_property_modifier] = "ui_property_modifier",
  [sym_ui_object_array] = "ui_object_array",
  [sym_ui_required] = "ui_required",
  [sym_ui_signal] = "ui_signal",
  [sym_ui_signal_parameters] = "ui_signal_parameters",
  [sym_ui_signal_parameter] = "ui_signal_parameter",
  [sym_ui_inline_component] = "ui_inline_component",
  [sym__qml_enum_declaration] = "enum_declaration",
  [sym__qml_enum_body] = "enum_body",
  [sym__qml_enum_assignment] = "enum_assignment",
  [sym__qml_enum_negative_number] = "unary_expression",
  [sym_ui_nested_identifier] = "nested_identifier",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_export_clause_repeat1] = "export_clause_repeat1",
  [aux_sym_named_imports_repeat1] = "named_imports_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_statement_block_repeat1] = "statement_block_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_object_pattern_repeat1] = "object_pattern_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_array_pattern_repeat1] = "array_pattern_repeat1",
  [aux_sym_glimmer_template_repeat1] = "glimmer_template_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_template_string_repeat1] = "template_string_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [aux_sym_extends_clause_repeat1] = "extends_clause_repeat1",
  [aux_sym_implements_clause_repeat1] = "implements_clause_repeat1",
  [aux_sym_extends_type_clause_repeat1] = "extends_type_clause_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_template_literal_type_repeat1] = "template_literal_type_repeat1",
  [aux_sym_object_type_repeat1] = "object_type_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [aux_sym_ui_annotated_object_repeat1] = "ui_annotated_object_repeat1",
  [aux_sym_ui_object_initializer_repeat1] = "ui_object_initializer_repeat1",
  [aux_sym_ui_property_repeat1] = "ui_property_repeat1",
  [aux_sym_ui_object_array_repeat1] = "ui_object_array_repeat1",
  [aux_sym_ui_signal_parameters_repeat1] = "ui_signal_parameters_repeat1",
  [aux_sym__qml_enum_body_repeat1] = "_qml_enum_body_repeat1",
  [alias_sym_import_specifier] = "import_specifier",
  [alias_sym_namespace_export] = "namespace_export",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_shorthand_property_identifier] = "shorthand_property_identifier",
  [alias_sym_shorthand_property_identifier_pattern] = "shorthand_property_identifier_pattern",
  [alias_sym_statement_identifier] = "statement_identifier",
  [alias_sym_this_type] = "this_type",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_namespace] = anon_sym_namespace,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_debugger] = anon_sym_debugger,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [sym__glimmer_template_content] = sym__glimmer_template_content,
  [anon_sym_LTtemplate_GT] = anon_sym_LTtemplate_GT,
  [anon_sym_LT_SLASHtemplate_GT] = anon_sym_LT_SLASHtemplate_GT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_QMARK_DOT] = anon_sym_QMARK_DOT,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_AMP_AMP_EQ] = anon_sym_AMP_AMP_EQ,
  [anon_sym_PIPE_PIPE_EQ] = anon_sym_PIPE_PIPE_EQ,
  [anon_sym_QMARK_QMARK_EQ] = anon_sym_QMARK_QMARK_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym_unescaped_double_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_unescaped_single_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_comment] = sym_comment,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [sym_regex_pattern] = sym_regex_pattern,
  [sym_regex_flags] = sym_regex_flags,
  [sym_number] = sym_number,
  [sym_private_property_identifier] = sym_private_property_identifier,
  [anon_sym_target] = anon_sym_target,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_undefined] = sym_undefined,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_readonly] = anon_sym_readonly,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_declare] = anon_sym_declare,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_override] = anon_sym_override,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_any] = anon_sym_any,
  [anon_sym_number] = anon_sym_number,
  [anon_sym_boolean] = anon_sym_boolean,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_symbol] = anon_sym_symbol,
  [anon_sym_property] = anon_sym_property,
  [anon_sym_signal] = anon_sym_signal,
  [anon_sym_on] = anon_sym_on,
  [anon_sym_required] = anon_sym_required,
  [anon_sym_component] = anon_sym_component,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_require] = anon_sym_require,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_DASH_QMARK_COLON] = anon_sym_DASH_QMARK_COLON,
  [anon_sym_QMARK_COLON] = anon_sym_QMARK_COLON,
  [anon_sym_asserts] = anon_sym_asserts,
  [anon_sym_infer] = anon_sym_infer,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_keyof] = anon_sym_keyof,
  [anon_sym_unknown] = anon_sym_unknown,
  [anon_sym_never] = anon_sym_never,
  [anon_sym_object] = anon_sym_object,
  [anon_sym_LBRACE_PIPE] = anon_sym_LBRACE_PIPE,
  [anon_sym_PIPE_RBRACE] = anon_sym_PIPE_RBRACE,
  [anon_sym_pragma] = anon_sym_pragma,
  [aux_sym_ui_version_specifier_token1] = sym_number,
  [anon_sym_list] = anon_sym_list,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars] = sym__template_chars,
  [sym__ternary_qmark] = anon_sym_QMARK,
  [sym__function_signature_automatic_semicolon] = sym__function_signature_automatic_semicolon,
  [sym_program] = sym_program,
  [sym_export_statement] = sym_export_statement,
  [sym_export_clause] = sym_export_clause,
  [sym__import_export_specifier] = sym__import_export_specifier,
  [sym_declaration] = sym_declaration,
  [sym_import] = sym_import,
  [sym_import_statement] = sym_import_statement,
  [sym_import_clause] = sym_import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym_namespace_import_export] = sym_namespace_import_export,
  [sym_named_imports] = sym_named_imports,
  [sym_expression_statement] = sym_expression_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_lexical_declaration] = sym_lexical_declaration,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym_statement_block] = sym_statement_block,
  [sym_else_clause] = sym_else_clause,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__for_header] = sym__for_header,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_with_statement] = sym_with_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_debugger_statement] = sym_debugger_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_case] = sym_switch_case,
  [sym_switch_default] = sym_switch_default,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_yield_expression] = sym_yield_expression,
  [sym_object] = sym_object,
  [sym_object_pattern] = sym_object_pattern,
  [sym_assignment_pattern] = sym_assignment_pattern,
  [sym_object_assignment_pattern] = sym_object_assignment_pattern,
  [sym_array] = sym_array,
  [sym_array_pattern] = sym_array_pattern,
  [sym_glimmer_template] = sym_glimmer_template,
  [sym_glimmer_opening_tag] = sym_glimmer_opening_tag,
  [sym_glimmer_closing_tag] = sym_glimmer_closing_tag,
  [sym_nested_identifier] = sym_nested_identifier,
  [sym_class] = sym_class,
  [sym_class_declaration] = sym_class_declaration,
  [sym_class_heritage] = sym_class_heritage,
  [sym_function] = sym_function,
  [sym_function_declaration] = sym_function_declaration,
  [sym_generator_function] = sym_generator_function,
  [sym_generator_function_declaration] = sym_generator_function_declaration,
  [sym_arrow_function] = sym_arrow_function,
  [sym__call_signature] = sym__call_signature,
  [sym__formal_parameter] = sym__formal_parameter,
  [sym_optional_chain] = sym_optional_chain,
  [sym_call_expression] = sym_call_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym__augmented_assignment_lhs] = sym__augmented_assignment_lhs,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym__initializer] = sym__initializer,
  [sym__destructuring_pattern] = sym__destructuring_pattern,
  [sym_spread_element] = sym_spread_element,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_sequence_expression] = sym_sequence_expression,
  [sym_string] = sym_string,
  [sym_template_string] = sym_template_string,
  [sym_template_substitution] = sym_template_substitution,
  [sym_regex] = sym_regex,
  [sym_meta_property] = sym_meta_property,
  [sym_arguments] = sym_arguments,
  [sym_decorator] = sym_decorator,
  [sym_decorator_member_expression] = sym_member_expression,
  [sym_decorator_call_expression] = sym_call_expression,
  [sym_class_body] = sym_class_body,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_pattern] = sym_pattern,
  [sym_rest_pattern] = sym_rest_pattern,
  [sym_method_definition] = sym_method_definition,
  [sym_pair] = sym_pair,
  [sym_pair_pattern] = sym_pair_pattern,
  [sym__property_name] = sym__property_name,
  [sym_computed_property_name] = sym_computed_property_name,
  [sym_public_field_definition] = sym_public_field_definition,
  [sym_non_null_expression] = sym_non_null_expression,
  [sym_method_signature] = sym_method_signature,
  [sym_abstract_method_signature] = sym_abstract_method_signature,
  [sym_function_signature] = sym_function_signature,
  [sym_type_assertion] = sym_type_assertion,
  [sym_as_expression] = sym_as_expression,
  [sym_import_require_clause] = sym_import_require_clause,
  [sym_extends_clause] = sym_extends_clause,
  [sym_implements_clause] = sym_implements_clause,
  [sym_ambient_declaration] = sym_ambient_declaration,
  [sym_abstract_class_declaration] = sym_abstract_class_declaration,
  [sym_module] = sym_module,
  [sym_internal_module] = sym_internal_module,
  [sym__module] = sym__module,
  [sym_import_alias] = sym_import_alias,
  [sym_nested_type_identifier] = sym_nested_type_identifier,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_extends_type_clause] = sym_extends_type_clause,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_assignment] = sym_enum_assignment,
  [sym_type_alias_declaration] = sym_type_alias_declaration,
  [sym_accessibility_modifier] = sym_accessibility_modifier,
  [sym_override_modifier] = sym_override_modifier,
  [sym_required_parameter] = sym_required_parameter,
  [sym_optional_parameter] = sym_optional_parameter,
  [sym__parameter_name] = sym__parameter_name,
  [sym_omitting_type_annotation] = sym_omitting_type_annotation,
  [sym_opting_type_annotation] = sym_opting_type_annotation,
  [sym_type_annotation] = sym_type_annotation,
  [sym_asserts] = sym_asserts,
  [sym__type] = sym__type,
  [sym_tuple_parameter] = sym_required_parameter,
  [sym_optional_tuple_parameter] = sym_optional_parameter,
  [sym_optional_type] = sym_optional_type,
  [sym_rest_type] = sym_rest_type,
  [sym__tuple_type_member] = sym__tuple_type_member,
  [sym_constructor_type] = sym_constructor_type,
  [sym__primary_type] = sym__primary_type,
  [sym_template_type] = sym_template_type,
  [sym_template_literal_type] = sym_template_literal_type,
  [sym_infer_type] = sym_infer_type,
  [sym_conditional_type] = sym_conditional_type,
  [sym_generic_type] = sym_generic_type,
  [sym_type_predicate] = sym_type_predicate,
  [sym_type_predicate_annotation] = sym_type_predicate_annotation,
  [sym__type_query_member_expression] = sym_member_expression,
  [sym__type_query_subscript_expression] = sym_subscript_expression,
  [sym__type_query_call_expression] = sym_call_expression,
  [sym_type_query] = sym_type_query,
  [sym_index_type_query] = sym_index_type_query,
  [sym_lookup_type] = sym_lookup_type,
  [sym_mapped_type_clause] = sym_mapped_type_clause,
  [sym_literal_type] = sym_literal_type,
  [sym__number] = sym_unary_expression,
  [sym_existential_type] = sym_existential_type,
  [sym_flow_maybe_type] = sym_flow_maybe_type,
  [sym_parenthesized_type] = sym_parenthesized_type,
  [sym_predefined_type] = sym_predefined_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_object_type] = sym_object_type,
  [sym_call_signature] = sym_call_signature,
  [sym_property_signature] = sym_property_signature,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_default_type] = sym_default_type,
  [sym_constraint] = sym_constraint,
  [sym_construct_signature] = sym_construct_signature,
  [sym_index_signature] = sym_index_signature,
  [sym_array_type] = sym_array_type,
  [sym_tuple_type] = sym_tuple_type,
  [sym_readonly_type] = sym_readonly_type,
  [sym_union_type] = sym_union_type,
  [sym_intersection_type] = sym_intersection_type,
  [sym_function_type] = sym_function_type,
  [sym_ui_pragma] = sym_ui_pragma,
  [sym_ui_import] = sym_ui_import,
  [sym_ui_version_specifier] = sym_ui_version_specifier,
  [sym_ui_object_definition] = sym_ui_object_definition,
  [sym_ui_annotated_object] = sym_ui_annotated_object,
  [sym_ui_annotation] = sym_ui_annotation,
  [sym_ui_object_initializer] = sym_ui_object_initializer,
  [sym_ui_annotated_object_member] = sym_ui_annotated_object_member,
  [sym_ui_object_definition_binding] = sym_ui_object_definition_binding,
  [sym_ui_binding] = sym_ui_binding,
  [sym_ui_property] = sym_ui_property,
  [sym_ui_list_property_type] = sym_ui_list_property_type,
  [sym_ui_property_modifier] = sym_ui_property_modifier,
  [sym_ui_object_array] = sym_ui_object_array,
  [sym_ui_required] = sym_ui_required,
  [sym_ui_signal] = sym_ui_signal,
  [sym_ui_signal_parameters] = sym_ui_signal_parameters,
  [sym_ui_signal_parameter] = sym_ui_signal_parameter,
  [sym_ui_inline_component] = sym_ui_inline_component,
  [sym__qml_enum_declaration] = sym_enum_declaration,
  [sym__qml_enum_body] = sym_enum_body,
  [sym__qml_enum_assignment] = sym_enum_assignment,
  [sym__qml_enum_negative_number] = sym_unary_expression,
  [sym_ui_nested_identifier] = sym_nested_identifier,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_export_clause_repeat1] = aux_sym_export_clause_repeat1,
  [aux_sym_named_imports_repeat1] = aux_sym_named_imports_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_statement_block_repeat1] = aux_sym_statement_block_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_object_pattern_repeat1] = aux_sym_object_pattern_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_array_pattern_repeat1] = aux_sym_array_pattern_repeat1,
  [aux_sym_glimmer_template_repeat1] = aux_sym_glimmer_template_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_template_string_repeat1] = aux_sym_template_string_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [aux_sym_extends_clause_repeat1] = aux_sym_extends_clause_repeat1,
  [aux_sym_implements_clause_repeat1] = aux_sym_implements_clause_repeat1,
  [aux_sym_extends_type_clause_repeat1] = aux_sym_extends_type_clause_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_template_literal_type_repeat1] = aux_sym_template_literal_type_repeat1,
  [aux_sym_object_type_repeat1] = aux_sym_object_type_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [aux_sym_ui_annotated_object_repeat1] = aux_sym_ui_annotated_object_repeat1,
  [aux_sym_ui_object_initializer_repeat1] = aux_sym_ui_object_initializer_repeat1,
  [aux_sym_ui_property_repeat1] = aux_sym_ui_property_repeat1,
  [aux_sym_ui_object_array_repeat1] = aux_sym_ui_object_array_repeat1,
  [aux_sym_ui_signal_parameters_repeat1] = aux_sym_ui_signal_parameters_repeat1,
  [aux_sym__qml_enum_body_repeat1] = aux_sym__qml_enum_body_repeat1,
  [alias_sym_import_specifier] = alias_sym_import_specifier,
  [alias_sym_namespace_export] = alias_sym_namespace_export,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_shorthand_property_identifier] = alias_sym_shorthand_property_identifier,
  [alias_sym_shorthand_property_identifier_pattern] = alias_sym_shorthand_property_identifier_pattern,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
  [alias_sym_this_type] = alias_sym_this_type,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debugger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym__glimmer_template_content] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LTtemplate_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_SLASHtemplate_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_single_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_private_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_target] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_undefined] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_declare] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_override] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_any] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_number] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_boolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_symbol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_property] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_signal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_on] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_required] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_component] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_require] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asserts] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_infer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_keyof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unknown] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_never] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_object] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pragma] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_ui_version_specifier_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars] = {
    .visible = false,
    .named = true,
  },
  [sym__ternary_qmark] = {
    .visible = true,
    .named = false,
  },
  [sym__function_signature_automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_export_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__import_export_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_namespace_import_export] = {
    .visible = true,
    .named = true,
  },
  [sym_named_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lexical_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_header] = {
    .visible = false,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_debugger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_default] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_yield_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_object_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_object_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_glimmer_template] = {
    .visible = true,
    .named = true,
  },
  [sym_glimmer_opening_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_glimmer_closing_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow_function] = {
    .visible = true,
    .named = true,
  },
  [sym__call_signature] = {
    .visible = false,
    .named = true,
  },
  [sym__formal_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_optional_chain] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__augmented_assignment_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__initializer] = {
    .visible = false,
    .named = true,
  },
  [sym__destructuring_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_property] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_rest_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_pair_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = false,
    .named = true,
  },
  [sym_computed_property_name] = {
    .visible = true,
    .named = true,
  },
  [sym_public_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_non_null_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_function_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_type_assertion] = {
    .visible = true,
    .named = true,
  },
  [sym_as_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_import_require_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_implements_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_ambient_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_internal_module] = {
    .visible = true,
    .named = true,
  },
  [sym__module] = {
    .visible = false,
    .named = true,
  },
  [sym_import_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_type_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_accessibility_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_override_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_required_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_name] = {
    .visible = false,
    .named = true,
  },
  [sym_omitting_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_opting_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_asserts] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_tuple_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_rest_type] = {
    .visible = true,
    .named = true,
  },
  [sym__tuple_type_member] = {
    .visible = false,
    .named = true,
  },
  [sym_constructor_type] = {
    .visible = true,
    .named = true,
  },
  [sym__primary_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_template_type] = {
    .visible = true,
    .named = true,
  },
  [sym_template_literal_type] = {
    .visible = true,
    .named = true,
  },
  [sym_infer_type] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_predicate] = {
    .visible = true,
    .named = true,
  },
  [sym_type_predicate_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_query] = {
    .visible = true,
    .named = true,
  },
  [sym_index_type_query] = {
    .visible = true,
    .named = true,
  },
  [sym_lookup_type] = {
    .visible = true,
    .named = true,
  },
  [sym_mapped_type_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_type] = {
    .visible = true,
    .named = true,
  },
  [sym__number] = {
    .visible = true,
    .named = true,
  },
  [sym_existential_type] = {
    .visible = true,
    .named = true,
  },
  [sym_flow_maybe_type] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type] = {
    .visible = true,
    .named = true,
  },
  [sym_predefined_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_object_type] = {
    .visible = true,
    .named = true,
  },
  [sym_call_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_property_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_default_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_construct_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_index_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_readonly_type] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_intersection_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_pragma] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_import] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_version_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_object_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_annotated_object] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_object_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_annotated_object_member] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_object_definition_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_property] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_list_property_type] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_property_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_object_array] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_required] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_signal] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_signal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_signal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_inline_component] = {
    .visible = true,
    .named = true,
  },
  [sym__qml_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__qml_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym__qml_enum_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym__qml_enum_negative_number] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_glimmer_template_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_implements_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_type_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_literal_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_ui_annotated_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_ui_object_initializer_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_ui_property_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_ui_object_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_ui_signal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__qml_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_import_specifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_namespace_export] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_this_type] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_alternative = 2,
  field_annotation = 3,
  field_argument = 4,
  field_arguments = 5,
  field_body = 6,
  field_close_tag = 7,
  field_component = 8,
  field_condition = 9,
  field_consequence = 10,
  field_constraint = 11,
  field_constructor = 12,
  field_content = 13,
  field_declaration = 14,
  field_decorator = 15,
  field_definition = 16,
  field_finalizer = 17,
  field_flags = 18,
  field_function = 19,
  field_handler = 20,
  field_increment = 21,
  field_index = 22,
  field_index_type = 23,
  field_initializer = 24,
  field_key = 25,
  field_kind = 26,
  field_label = 27,
  field_left = 28,
  field_major = 29,
  field_minor = 30,
  field_module = 31,
  field_name = 32,
  field_object = 33,
  field_open_tag = 34,
  field_operator = 35,
  field_optional_chain = 36,
  field_parameter = 37,
  field_parameters = 38,
  field_pattern = 39,
  field_property = 40,
  field_return_type = 41,
  field_right = 42,
  field_root = 43,
  field_sign = 44,
  field_source = 45,
  field_type = 46,
  field_type_arguments = 47,
  field_type_name = 48,
  field_type_parameters = 49,
  field_value = 50,
  field_version = 51,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_annotation] = "annotation",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_close_tag] = "close_tag",
  [field_component] = "component",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constraint] = "constraint",
  [field_constructor] = "constructor",
  [field_content] = "content",
  [field_declaration] = "declaration",
  [field_decorator] = "decorator",
  [field_definition] = "definition",
  [field_finalizer] = "finalizer",
  [field_flags] = "flags",
  [field_function] = "function",
  [field_handler] = "handler",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_index_type] = "index_type",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_kind] = "kind",
  [field_label] = "label",
  [field_left] = "left",
  [field_major] = "major",
  [field_minor] = "minor",
  [field_module] = "module",
  [field_name] = "name",
  [field_object] = "object",
  [field_open_tag] = "open_tag",
  [field_operator] = "operator",
  [field_optional_chain] = "optional_chain",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_property] = "property",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_root] = "root",
  [field_sign] = "sign",
  [field_source] = "source",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_name] = "type_name",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
  [field_version] = "version",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 2},
  [5] = {.index = 3, .length = 2},
  [6] = {.index = 5, .length = 2},
  [7] = {.index = 7, .length = 2},
  [8] = {.index = 9, .length = 1},
  [9] = {.index = 10, .length = 2},
  [11] = {.index = 12, .length = 1},
  [12] = {.index = 13, .length = 1},
  [13] = {.index = 14, .length = 2},
  [14] = {.index = 16, .length = 1},
  [15] = {.index = 17, .length = 1},
  [16] = {.index = 18, .length = 4},
  [17] = {.index = 22, .length = 2},
  [18] = {.index = 24, .length = 2},
  [19] = {.index = 26, .length = 1},
  [20] = {.index = 27, .length = 1},
  [22] = {.index = 28, .length = 2},
  [23] = {.index = 30, .length = 2},
  [24] = {.index = 24, .length = 2},
  [25] = {.index = 16, .length = 1},
  [26] = {.index = 32, .length = 3},
  [27] = {.index = 35, .length = 2},
  [28] = {.index = 37, .length = 2},
  [29] = {.index = 39, .length = 2},
  [30] = {.index = 41, .length = 2},
  [31] = {.index = 43, .length = 2},
  [32] = {.index = 45, .length = 1},
  [33] = {.index = 46, .length = 2},
  [34] = {.index = 48, .length = 1},
  [36] = {.index = 17, .length = 1},
  [38] = {.index = 49, .length = 2},
  [39] = {.index = 51, .length = 1},
  [40] = {.index = 52, .length = 2},
  [41] = {.index = 54, .length = 2},
  [42] = {.index = 56, .length = 2},
  [43] = {.index = 58, .length = 2},
  [44] = {.index = 60, .length = 2},
  [45] = {.index = 62, .length = 2},
  [46] = {.index = 64, .length = 3},
  [47] = {.index = 64, .length = 3},
  [50] = {.index = 67, .length = 1},
  [51] = {.index = 68, .length = 2},
  [52] = {.index = 70, .length = 3},
  [53] = {.index = 73, .length = 5},
  [54] = {.index = 64, .length = 3},
  [55] = {.index = 64, .length = 3},
  [56] = {.index = 78, .length = 2},
  [57] = {.index = 80, .length = 2},
  [58] = {.index = 78, .length = 2},
  [59] = {.index = 78, .length = 2},
  [60] = {.index = 78, .length = 2},
  [61] = {.index = 82, .length = 2},
  [62] = {.index = 84, .length = 2},
  [63] = {.index = 86, .length = 3},
  [64] = {.index = 89, .length = 2},
  [65] = {.index = 91, .length = 2},
  [66] = {.index = 93, .length = 2},
  [68] = {.index = 95, .length = 1},
  [69] = {.index = 96, .length = 2},
  [70] = {.index = 98, .length = 2},
  [71] = {.index = 100, .length = 1},
  [72] = {.index = 101, .length = 3},
  [73] = {.index = 104, .length = 3},
  [74] = {.index = 107, .length = 2},
  [75] = {.index = 109, .length = 2},
  [76] = {.index = 111, .length = 2},
  [77] = {.index = 113, .length = 2},
  [78] = {.index = 115, .length = 3},
  [79] = {.index = 118, .length = 2},
  [80] = {.index = 120, .length = 2},
  [81] = {.index = 122, .length = 2},
  [82] = {.index = 124, .length = 2},
  [83] = {.index = 126, .length = 2},
  [84] = {.index = 128, .length = 2},
  [86] = {.index = 124, .length = 2},
  [87] = {.index = 130, .length = 2},
  [88] = {.index = 132, .length = 1},
  [89] = {.index = 133, .length = 2},
  [90] = {.index = 135, .length = 4},
  [91] = {.index = 139, .length = 2},
  [92] = {.index = 141, .length = 2},
  [93] = {.index = 89, .length = 2},
  [94] = {.index = 91, .length = 2},
  [95] = {.index = 143, .length = 3},
  [96] = {.index = 146, .length = 2},
  [97] = {.index = 146, .length = 2},
  [98] = {.index = 148, .length = 3},
  [99] = {.index = 148, .length = 3},
  [100] = {.index = 151, .length = 3},
  [101] = {.index = 154, .length = 2},
  [102] = {.index = 156, .length = 3},
  [103] = {.index = 159, .length = 4},
  [104] = {.index = 163, .length = 3},
  [105] = {.index = 166, .length = 2},
  [106] = {.index = 89, .length = 2},
  [107] = {.index = 168, .length = 2},
  [108] = {.index = 170, .length = 5},
  [109] = {.index = 175, .length = 3},
  [110] = {.index = 175, .length = 3},
  [112] = {.index = 175, .length = 3},
  [113] = {.index = 175, .length = 3},
  [114] = {.index = 178, .length = 2},
  [115] = {.index = 178, .length = 2},
  [116] = {.index = 180, .length = 2},
  [117] = {.index = 182, .length = 2},
  [118] = {.index = 182, .length = 2},
  [119] = {.index = 182, .length = 2},
  [120] = {.index = 182, .length = 2},
  [121] = {.index = 184, .length = 1},
  [122] = {.index = 185, .length = 2},
  [123] = {.index = 187, .length = 1},
  [124] = {.index = 188, .length = 6},
  [125] = {.index = 194, .length = 2},
  [126] = {.index = 196, .length = 1},
  [127] = {.index = 130, .length = 2},
  [128] = {.index = 197, .length = 5},
  [129] = {.index = 202, .length = 2},
  [130] = {.index = 204, .length = 3},
  [131] = {.index = 207, .length = 1},
  [132] = {.index = 208, .length = 1},
  [133] = {.index = 209, .length = 3},
  [134] = {.index = 212, .length = 3},
  [135] = {.index = 215, .length = 4},
  [136] = {.index = 219, .length = 2},
  [137] = {.index = 221, .length = 3},
  [138] = {.index = 224, .length = 1},
  [139] = {.index = 225, .length = 4},
  [140] = {.index = 229, .length = 4},
  [141] = {.index = 233, .length = 4},
  [142] = {.index = 237, .length = 3},
  [143] = {.index = 240, .length = 2},
  [144] = {.index = 242, .length = 2},
  [145] = {.index = 244, .length = 2},
  [146] = {.index = 246, .length = 3},
  [147] = {.index = 249, .length = 2},
  [148] = {.index = 251, .length = 3},
  [149] = {.index = 254, .length = 2},
  [150] = {.index = 256, .length = 2},
  [151] = {.index = 258, .length = 4},
  [152] = {.index = 256, .length = 2},
  [153] = {.index = 262, .length = 4},
  [154] = {.index = 266, .length = 3},
  [155] = {.index = 269, .length = 2},
  [156] = {.index = 271, .length = 3},
  [157] = {.index = 274, .length = 3},
  [158] = {.index = 277, .length = 2},
  [159] = {.index = 279, .length = 3},
  [160] = {.index = 282, .length = 5},
  [161] = {.index = 287, .length = 4},
  [162] = {.index = 287, .length = 4},
  [163] = {.index = 287, .length = 4},
  [164] = {.index = 287, .length = 4},
  [165] = {.index = 68, .length = 2},
  [166] = {.index = 291, .length = 4},
  [167] = {.index = 295, .length = 2},
  [168] = {.index = 297, .length = 2},
  [169] = {.index = 299, .length = 3},
  [170] = {.index = 302, .length = 3},
  [171] = {.index = 302, .length = 3},
  [172] = {.index = 302, .length = 3},
  [173] = {.index = 302, .length = 3},
  [174] = {.index = 305, .length = 1},
  [175] = {.index = 306, .length = 1},
  [176] = {.index = 307, .length = 2},
  [177] = {.index = 305, .length = 1},
  [178] = {.index = 309, .length = 1},
  [179] = {.index = 307, .length = 2},
  [180] = {.index = 310, .length = 2},
  [181] = {.index = 312, .length = 6},
  [182] = {.index = 318, .length = 4},
  [183] = {.index = 310, .length = 2},
  [184] = {.index = 322, .length = 1},
  [185] = {.index = 322, .length = 1},
  [186] = {.index = 323, .length = 5},
  [187] = {.index = 328, .length = 2},
  [188] = {.index = 330, .length = 1},
  [189] = {.index = 331, .length = 4},
  [190] = {.index = 335, .length = 2},
  [191] = {.index = 337, .length = 2},
  [192] = {.index = 339, .length = 2},
  [193] = {.index = 341, .length = 1},
  [194] = {.index = 342, .length = 2},
  [195] = {.index = 344, .length = 1},
  [196] = {.index = 345, .length = 4},
  [197] = {.index = 349, .length = 4},
  [198] = {.index = 349, .length = 4},
  [199] = {.index = 353, .length = 4},
  [200] = {.index = 353, .length = 4},
  [201] = {.index = 357, .length = 4},
  [202] = {.index = 357, .length = 4},
  [203] = {.index = 361, .length = 2},
  [204] = {.index = 363, .length = 3},
  [205] = {.index = 366, .length = 2},
  [206] = {.index = 368, .length = 2},
  [207] = {.index = 370, .length = 3},
  [208] = {.index = 373, .length = 4},
  [209] = {.index = 377, .length = 4},
  [210] = {.index = 381, .length = 4},
  [211] = {.index = 385, .length = 3},
  [212] = {.index = 388, .length = 3},
  [213] = {.index = 68, .length = 2},
  [214] = {.index = 391, .length = 3},
  [215] = {.index = 394, .length = 4},
  [216] = {.index = 398, .length = 3},
  [217] = {.index = 401, .length = 4},
  [218] = {.index = 401, .length = 4},
  [219] = {.index = 401, .length = 4},
  [220] = {.index = 401, .length = 4},
  [221] = {.index = 405, .length = 1},
  [222] = {.index = 406, .length = 2},
  [223] = {.index = 408, .length = 5},
  [224] = {.index = 39, .length = 2},
  [225] = {.index = 413, .length = 2},
  [226] = {.index = 415, .length = 4},
  [227] = {.index = 419, .length = 2},
  [228] = {.index = 421, .length = 3},
  [229] = {.index = 424, .length = 2},
  [230] = {.index = 424, .length = 2},
  [231] = {.index = 426, .length = 2},
  [232] = {.index = 428, .length = 3},
  [233] = {.index = 431, .length = 2},
  [234] = {.index = 433, .length = 4},
  [235] = {.index = 68, .length = 2},
  [236] = {.index = 437, .length = 1},
  [237] = {.index = 438, .length = 3},
  [238] = {.index = 441, .length = 2},
  [239] = {.index = 443, .length = 2},
  [240] = {.index = 445, .length = 1},
  [241] = {.index = 446, .length = 2},
  [242] = {.index = 448, .length = 2},
  [243] = {.index = 450, .length = 4},
  [244] = {.index = 454, .length = 4},
  [245] = {.index = 458, .length = 4},
  [246] = {.index = 462, .length = 3},
  [247] = {.index = 465, .length = 2},
  [248] = {.index = 467, .length = 2},
  [249] = {.index = 469, .length = 2},
  [250] = {.index = 471, .length = 3},
  [251] = {.index = 474, .length = 3},
  [252] = {.index = 477, .length = 4},
  [253] = {.index = 481, .length = 2},
  [254] = {.index = 483, .length = 3},
  [255] = {.index = 486, .length = 3},
  [256] = {.index = 486, .length = 3},
  [257] = {.index = 489, .length = 3},
  [258] = {.index = 492, .length = 5},
  [259] = {.index = 497, .length = 3},
  [260] = {.index = 500, .length = 2},
  [261] = {.index = 502, .length = 1},
  [262] = {.index = 503, .length = 3},
  [263] = {.index = 506, .length = 4},
  [264] = {.index = 510, .length = 2},
  [265] = {.index = 512, .length = 2},
  [266] = {.index = 514, .length = 4},
  [267] = {.index = 518, .length = 4},
  [268] = {.index = 522, .length = 2},
  [269] = {.index = 524, .length = 2},
  [270] = {.index = 526, .length = 1},
  [271] = {.index = 527, .length = 3},
  [272] = {.index = 530, .length = 1},
  [273] = {.index = 531, .length = 2},
  [274] = {.index = 533, .length = 4},
  [275] = {.index = 537, .length = 4},
  [276] = {.index = 541, .length = 4},
  [277] = {.index = 545, .length = 3},
  [278] = {.index = 548, .length = 2},
  [279] = {.index = 550, .length = 3},
  [280] = {.index = 553, .length = 3},
  [281] = {.index = 556, .length = 2},
  [282] = {.index = 558, .length = 1},
  [283] = {.index = 559, .length = 4},
  [284] = {.index = 563, .length = 4},
  [285] = {.index = 567, .length = 5},
  [286] = {.index = 572, .length = 5},
  [288] = {.index = 577, .length = 4},
  [289] = {.index = 581, .length = 3},
  [290] = {.index = 584, .length = 3},
  [291] = {.index = 587, .length = 3},
  [292] = {.index = 584, .length = 3},
  [293] = {.index = 590, .length = 2},
  [294] = {.index = 592, .length = 4},
  [295] = {.index = 596, .length = 4},
  [296] = {.index = 600, .length = 2},
  [297] = {.index = 602, .length = 2},
  [298] = {.index = 604, .length = 4},
  [299] = {.index = 608, .length = 3},
  [300] = {.index = 611, .length = 2},
  [301] = {.index = 613, .length = 3},
  [302] = {.index = 616, .length = 2},
  [303] = {.index = 618, .length = 1},
  [304] = {.index = 619, .length = 5},
  [305] = {.index = 624, .length = 5},
  [306] = {.index = 629, .length = 5},
  [307] = {.index = 634, .length = 4},
  [308] = {.index = 638, .length = 4},
  [309] = {.index = 642, .length = 3},
  [310] = {.index = 642, .length = 3},
  [311] = {.index = 645, .length = 2},
  [312] = {.index = 647, .length = 3},
  [313] = {.index = 650, .length = 2},
  [314] = {.index = 652, .length = 3},
  [315] = {.index = 655, .length = 2},
  [316] = {.index = 657, .length = 2},
  [317] = {.index = 659, .length = 5},
  [318] = {.index = 664, .length = 5},
  [319] = {.index = 669, .length = 4},
  [320] = {.index = 669, .length = 4},
  [321] = {.index = 673, .length = 4},
  [322] = {.index = 677, .length = 4},
  [323] = {.index = 681, .length = 3},
  [324] = {.index = 684, .length = 2},
  [325] = {.index = 686, .length = 2},
  [326] = {.index = 688, .length = 3},
  [327] = {.index = 691, .length = 5},
  [328] = {.index = 696, .length = 4},
  [329] = {.index = 700, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_root, 0},
  [1] =
    {field_annotation, 0},
  [2] =
    {field_root, 1},
  [3] =
    {field_initializer, 1},
    {field_type_name, 0},
  [5] =
    {field_annotation, 0, .inherited = true},
    {field_definition, 1},
  [7] =
    {field_annotation, 0, .inherited = true},
    {field_annotation, 1, .inherited = true},
  [9] =
    {field_root, 2},
  [10] =
    {field_body, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [12] =
    {field_source, 1},
  [13] =
    {field_major, 0},
  [14] =
    {field_initializer, 2},
    {field_type_name, 1},
  [16] =
    {field_name, 1},
  [17] =
    {field_name, 0},
  [18] =
    {field_annotation, 0, .inherited = true},
    {field_body, 1, .inherited = true},
    {field_definition, 1},
    {field_name, 1, .inherited = true},
  [22] =
    {field_source, 1},
    {field_version, 2},
  [24] =
    {field_name, 0},
    {field_value, 2},
  [26] =
    {field_decorator, 0},
  [27] =
    {field_parameters, 0},
  [28] =
    {field_name, 0},
    {field_value, 1, .inherited = true},
  [30] =
    {field_name, 0},
    {field_type, 1},
  [32] =
    {field_body, 2},
    {field_name, 1},
    {field_name, 2, .inherited = true},
  [35] =
    {field_alias, 3},
    {field_source, 1},
  [37] =
    {field_major, 0},
    {field_minor, 2},
  [39] =
    {field_name, 1},
    {field_value, 3},
  [41] =
    {field_body, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [43] =
    {field_argument, 1},
    {field_operator, 0},
  [45] =
    {field_pattern, 0},
  [46] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
  [48] =
    {field_body, 1},
  [49] =
    {field_argument, 0, .inherited = true},
    {field_operator, 0, .inherited = true},
  [51] =
    {field_constructor, 1},
  [52] =
    {field_argument, 0},
    {field_operator, 1},
  [54] =
    {field_arguments, 1},
    {field_function, 0},
  [56] =
    {field_close_tag, 1},
    {field_open_tag, 0},
  [58] =
    {field_parameters, 0},
    {field_return_type, 1},
  [60] =
    {field_parameters, 1},
    {field_type_parameters, 0},
  [62] =
    {field_decorator, 0, .inherited = true},
    {field_decorator, 1, .inherited = true},
  [64] =
    {field_initializer, 3},
    {field_name, 2},
    {field_type_name, 0},
  [67] =
    {field_value, 1},
  [68] =
    {field_name, 0},
    {field_type, 2},
  [70] =
    {field_name, 0},
    {field_type, 1},
    {field_value, 2, .inherited = true},
  [73] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [78] =
    {field_name, 2},
    {field_type, 1},
  [80] =
    {field_module, 0},
    {field_name, 2},
  [82] =
    {field_name, 1},
    {field_parameters, 2},
  [84] =
    {field_component, 3},
    {field_name, 1},
  [86] =
    {field_alias, 4},
    {field_source, 1},
    {field_version, 2},
  [89] =
    {field_left, 0},
    {field_right, 2},
  [91] =
    {field_body, 2},
    {field_parameter, 0},
  [93] =
    {field_body, 1},
    {field_name, 0},
  [95] =
    {field_declaration, 1},
  [96] =
    {field_condition, 1},
    {field_consequence, 2},
  [98] =
    {field_body, 2},
    {field_value, 1},
  [100] =
    {field_pattern, 1},
  [101] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [104] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 1},
  [107] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 1},
  [109] =
    {field_body, 1},
    {field_handler, 2},
  [111] =
    {field_body, 1},
    {field_finalizer, 2},
  [113] =
    {field_body, 2},
    {field_object, 1},
  [115] =
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [118] =
    {field_object, 1, .inherited = true},
    {field_property, 1, .inherited = true},
  [120] =
    {field_index, 1, .inherited = true},
    {field_object, 1, .inherited = true},
  [122] =
    {field_arguments, 1, .inherited = true},
    {field_function, 1, .inherited = true},
  [124] =
    {field_name, 0},
    {field_type_arguments, 1},
  [126] =
    {field_name, 0},
    {field_value, 1},
  [128] =
    {field_constraint, 1},
    {field_name, 0},
  [130] =
    {field_body, 2},
    {field_name, 1},
  [132] =
    {field_body, 2},
  [133] =
    {field_body, 2},
    {field_type_parameters, 1},
  [135] =
    {field_body, 2},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [139] =
    {field_arguments, 2},
    {field_constructor, 1},
  [141] =
    {field_constructor, 1},
    {field_type_arguments, 2},
  [143] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [146] =
    {field_object, 0},
    {field_property, 2},
  [148] =
    {field_object, 0},
    {field_optional_chain, 1},
    {field_property, 2},
  [151] =
    {field_arguments, 2},
    {field_function, 0},
    {field_type_arguments, 1},
  [154] =
    {field_arguments, 2},
    {field_function, 0},
  [156] =
    {field_close_tag, 2},
    {field_content, 1},
    {field_open_tag, 0},
  [159] =
    {field_body, 2},
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [163] =
    {field_parameters, 1},
    {field_return_type, 2},
    {field_type_parameters, 0},
  [166] =
    {field_body, 2},
    {field_decorator, 0, .inherited = true},
  [168] =
    {field_key, 0},
    {field_value, 2},
  [170] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [175] =
    {field_name, 2},
    {field_type, 1},
    {field_value, 4},
  [178] =
    {field_name, 1},
    {field_type, 0},
  [180] =
    {field_name, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [182] =
    {field_name, 3},
    {field_type, 2},
  [184] =
    {field_declaration, 2},
  [185] =
    {field_body, 2},
    {field_label, 0},
  [187] =
    {field_kind, 0},
  [188] =
    {field_body, 2},
    {field_kind, 1, .inherited = true},
    {field_left, 1, .inherited = true},
    {field_operator, 1, .inherited = true},
    {field_right, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [194] =
    {field_body, 2},
    {field_condition, 1},
  [196] =
    {field_label, 1},
  [197] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [202] =
    {field_declaration, 2},
    {field_decorator, 0, .inherited = true},
  [204] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [207] =
    {field_type, 2},
  [208] =
    {field_pattern, 2},
  [209] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_value, 2, .inherited = true},
  [212] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 2},
  [215] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 1},
    {field_value, 2, .inherited = true},
  [219] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 2},
  [221] =
    {field_body, 1},
    {field_finalizer, 3},
    {field_handler, 2},
  [224] =
    {field_parameters, 1},
  [225] =
    {field_name, 0},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [229] =
    {field_arguments, 1},
    {field_function, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [233] =
    {field_arguments, 1},
    {field_function, 0},
    {field_index, 0, .inherited = true},
    {field_object, 0, .inherited = true},
  [237] =
    {field_constraint, 1},
    {field_name, 0},
    {field_value, 2},
  [240] =
    {field_parameters, 0},
    {field_return_type, 2},
  [242] =
    {field_flags, 3},
    {field_pattern, 1},
  [244] =
    {field_body, 3},
    {field_name, 1},
  [246] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [249] =
    {field_type_arguments, 2},
    {field_value, 1},
  [251] =
    {field_type_arguments, 2, .inherited = true},
    {field_value, 1},
    {field_value, 2, .inherited = true},
  [254] =
    {field_body, 3},
    {field_type_parameters, 1},
  [256] =
    {field_body, 3},
    {field_parameter, 1},
  [258] =
    {field_body, 3},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [262] =
    {field_body, 3},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [266] =
    {field_arguments, 3},
    {field_constructor, 1},
    {field_type_arguments, 2},
  [269] =
    {field_index, 2},
    {field_object, 0},
  [271] =
    {field_arguments, 3},
    {field_function, 0},
    {field_type_arguments, 2},
  [274] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [277] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
  [279] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_type_parameters, 2},
  [282] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [287] =
    {field_name, 2},
    {field_type, 1},
    {field_value, 4},
    {field_value, 5},
  [291] =
    {field_argument, 2, .inherited = true},
    {field_name, 0},
    {field_operator, 2, .inherited = true},
    {field_value, 2},
  [295] =
    {field_name, 1},
    {field_name, 2, .inherited = true},
  [297] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [299] =
    {field_name, 1, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_value, 1, .inherited = true},
  [302] =
    {field_name, 3},
    {field_type, 2},
    {field_value, 5},
  [305] =
    {field_source, 2, .inherited = true},
  [306] =
    {field_value, 2},
  [307] =
    {field_alias, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [309] =
    {field_source, 2},
  [310] =
    {field_body, 3},
    {field_name, 2},
  [312] =
    {field_body, 3},
    {field_kind, 2, .inherited = true},
    {field_left, 2, .inherited = true},
    {field_operator, 2, .inherited = true},
    {field_right, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [318] =
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [322] =
    {field_type, 1},
  [323] =
    {field_body, 3},
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [328] =
    {field_declaration, 3},
    {field_decorator, 0, .inherited = true},
  [330] =
    {field_pattern, 3},
  [331] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [335] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 3},
  [337] =
    {field_parameters, 1},
    {field_type, 2},
  [339] =
    {field_parameters, 2},
    {field_type_parameters, 1},
  [341] =
    {field_name, 2},
  [342] =
    {field_name, 1},
    {field_type, 2},
  [344] =
    {field_parameters, 2},
  [345] =
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [349] =
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
    {field_property, 2},
  [353] =
    {field_index, 0, .inherited = true},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 2},
  [357] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_object, 0},
    {field_property, 2},
  [361] =
    {field_parameters, 1},
    {field_type, 3},
  [363] =
    {field_parameters, 1},
    {field_return_type, 3},
    {field_type_parameters, 0},
  [366] =
    {field_name, 1},
    {field_value, 2, .inherited = true},
  [368] =
    {field_name, 0},
    {field_value, 2, .inherited = true},
  [370] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [373] =
    {field_type_arguments, 2},
    {field_type_arguments, 3, .inherited = true},
    {field_value, 1},
    {field_value, 3, .inherited = true},
  [377] =
    {field_type_arguments, 0, .inherited = true},
    {field_type_arguments, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [381] =
    {field_body, 4},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [385] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [388] =
    {field_index, 3},
    {field_object, 0},
    {field_optional_chain, 1},
  [391] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [394] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type_parameters, 3},
  [398] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_type_parameters, 2},
  [401] =
    {field_name, 3},
    {field_type, 2},
    {field_value, 5},
    {field_value, 6},
  [405] =
    {field_source, 3, .inherited = true},
  [406] =
    {field_alias, 2},
    {field_name, 0},
  [408] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [413] =
    {field_body, 1},
    {field_condition, 3},
  [415] =
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [419] =
    {field_body, 4},
    {field_name, 2},
  [421] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [424] =
    {field_type, 1},
    {field_type, 2, .inherited = true},
  [426] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3},
  [428] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [431] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 4},
  [433] =
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [437] =
    {field_type, 3},
  [438] =
    {field_parameters, 2},
    {field_type, 3},
    {field_type_parameters, 1},
  [441] =
    {field_name, 2},
    {field_type, 3},
  [443] =
    {field_name, 1},
    {field_type, 3},
  [445] =
    {field_name, 3},
  [446] =
    {field_parameters, 2},
    {field_type, 3},
  [448] =
    {field_parameters, 3},
    {field_type_parameters, 2},
  [450] =
    {field_index, 2},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [454] =
    {field_index, 0, .inherited = true},
    {field_index, 2},
    {field_object, 0},
    {field_object, 0, .inherited = true},
  [458] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_index, 2},
    {field_object, 0},
  [462] =
    {field_parameters, 2},
    {field_type, 4},
    {field_type_parameters, 1},
  [465] =
    {field_parameters, 2},
    {field_type, 4},
  [467] =
    {field_name, 2},
    {field_value, 3, .inherited = true},
  [469] =
    {field_name, 1},
    {field_value, 3, .inherited = true},
  [471] =
    {field_name, 1},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [474] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [477] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type_parameters, 3},
  [481] =
    {field_alias, 3},
    {field_name, 1},
  [483] =
    {field_name, 1},
    {field_type_parameters, 2},
    {field_value, 4},
  [486] =
    {field_left, 1},
    {field_operator, 2},
    {field_right, 3},
  [489] =
    {field_body, 5},
    {field_condition, 3},
    {field_initializer, 2},
  [492] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [497] =
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [500] =
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [502] =
    {field_name, 2, .inherited = true},
  [503] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [506] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type_parameters, 4},
  [510] =
    {field_body, 3},
    {field_value, 1},
  [512] =
    {field_body, 4},
    {field_parameter, 2},
  [514] =
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [518] =
    {field_name, 3},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [522] =
    {field_name, 2},
    {field_type, 4},
  [524] =
    {field_name, 3},
    {field_type, 4},
  [526] =
    {field_type, 4},
  [527] =
    {field_parameters, 3},
    {field_type, 4},
    {field_type_parameters, 2},
  [530] =
    {field_name, 4},
  [531] =
    {field_index, 3},
    {field_object, 0},
  [533] =
    {field_index, 3},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [537] =
    {field_index, 0, .inherited = true},
    {field_index, 3},
    {field_object, 0},
    {field_object, 0, .inherited = true},
  [541] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_index, 3},
    {field_object, 0},
  [545] =
    {field_parameters, 3},
    {field_type, 5},
    {field_type_parameters, 2},
  [548] =
    {field_name, 2},
    {field_value, 4, .inherited = true},
  [550] =
    {field_name, 2},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [553] =
    {field_name, 1},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [556] =
    {field_name, 3},
    {field_value, 4, .inherited = true},
  [558] =
    {field_source, 4},
  [559] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 3},
    {field_right, 4},
  [563] =
    {field_body, 6},
    {field_condition, 3},
    {field_increment, 4},
    {field_initializer, 2},
  [567] =
    {field_body, 6},
    {field_name, 3},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [572] =
    {field_body, 6},
    {field_name, 4},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [577] =
    {field_body, 6},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type_parameters, 4},
  [581] =
    {field_body, 5},
    {field_parameter, 2},
    {field_type, 3},
  [584] =
    {field_index_type, 3},
    {field_name, 1},
    {field_type, 5},
  [587] =
    {field_alias, 4},
    {field_name, 0},
    {field_type, 2},
  [590] =
    {field_sign, 0},
    {field_type, 5},
  [592] =
    {field_name, 3},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [596] =
    {field_name, 4},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [600] =
    {field_name, 3},
    {field_type, 5},
  [602] =
    {field_name, 4},
    {field_type, 5},
  [604] =
    {field_alternative, 6},
    {field_consequence, 4},
    {field_left, 0},
    {field_right, 2},
  [608] =
    {field_name, 2},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [611] =
    {field_name, 3},
    {field_value, 5, .inherited = true},
  [613] =
    {field_name, 3},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [616] =
    {field_name, 4},
    {field_value, 5, .inherited = true},
  [618] =
    {field_name, 5},
  [619] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 4},
    {field_right, 5},
    {field_value, 3, .inherited = true},
  [624] =
    {field_body, 7},
    {field_name, 4},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [629] =
    {field_body, 7},
    {field_name, 5},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [634] =
    {field_name, 4},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [638] =
    {field_name, 5},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [642] =
    {field_index_type, 4},
    {field_name, 2},
    {field_type, 6},
  [645] =
    {field_name, 4},
    {field_type, 6},
  [647] =
    {field_name, 3},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [650] =
    {field_name, 4},
    {field_value, 6, .inherited = true},
  [652] =
    {field_name, 4},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [655] =
    {field_name, 5},
    {field_value, 6, .inherited = true},
  [657] =
    {field_name, 5},
    {field_type, 6},
  [659] =
    {field_body, 8},
    {field_name, 5},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [664] =
    {field_body, 8},
    {field_name, 6},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [669] =
    {field_index_type, 5},
    {field_name, 3},
    {field_sign, 0},
    {field_type, 7},
  [673] =
    {field_name, 5},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [677] =
    {field_name, 6},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [681] =
    {field_name, 4},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [684] =
    {field_name, 5},
    {field_value, 7, .inherited = true},
  [686] =
    {field_name, 5},
    {field_type, 7},
  [688] =
    {field_name, 5},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [691] =
    {field_body, 9},
    {field_name, 6},
    {field_parameters, 8, .inherited = true},
    {field_return_type, 8, .inherited = true},
    {field_type_parameters, 8, .inherited = true},
  [696] =
    {field_name, 6},
    {field_parameters, 8, .inherited = true},
    {field_return_type, 8, .inherited = true},
    {field_type_parameters, 8, .inherited = true},
  [700] =
    {field_name, 5},
    {field_type, 7},
    {field_value, 8, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [4] = {
    [0] = sym_identifier,
  },
  [10] = {
    [0] = sym_identifier,
  },
  [18] = {
    [0] = sym_identifier,
  },
  [21] = {
    [0] = alias_sym_property_identifier,
  },
  [25] = {
    [1] = sym_identifier,
  },
  [35] = {
    [0] = anon_sym_list,
  },
  [36] = {
    [0] = anon_sym_list,
  },
  [37] = {
    [0] = alias_sym_this_type,
  },
  [46] = {
    [0] = sym_identifier,
    [2] = sym_identifier,
  },
  [47] = {
    [0] = sym_identifier,
  },
  [48] = {
    [1] = alias_sym_shorthand_property_identifier_pattern,
  },
  [49] = {
    [1] = sym_identifier,
  },
  [54] = {
    [2] = sym_identifier,
  },
  [56] = {
    [1] = anon_sym_list,
    [2] = sym_identifier,
  },
  [57] = {
    [2] = anon_sym_list,
  },
  [58] = {
    [1] = anon_sym_list,
  },
  [59] = {
    [2] = sym_identifier,
  },
  [64] = {
    [0] = sym_identifier,
  },
  [65] = {
    [0] = sym_identifier,
  },
  [67] = {
    [1] = alias_sym_shorthand_property_identifier,
  },
  [82] = {
    [0] = anon_sym_list,
  },
  [83] = {
    [0] = anon_sym_list,
  },
  [84] = {
    [0] = anon_sym_list,
  },
  [85] = {
    [1] = anon_sym_list,
  },
  [87] = {
    [1] = anon_sym_list,
  },
  [96] = {
    [2] = alias_sym_property_identifier,
  },
  [98] = {
    [2] = alias_sym_property_identifier,
  },
  [106] = {
    [0] = alias_sym_shorthand_property_identifier_pattern,
  },
  [109] = {
    [1] = anon_sym_list,
    [2] = sym_identifier,
  },
  [110] = {
    [1] = anon_sym_list,
  },
  [111] = {
    [2] = anon_sym_list,
  },
  [112] = {
    [2] = sym_identifier,
  },
  [114] = {
    [0] = anon_sym_list,
  },
  [117] = {
    [2] = anon_sym_list,
    [3] = sym_identifier,
  },
  [118] = {
    [2] = anon_sym_list,
  },
  [119] = {
    [3] = sym_identifier,
  },
  [122] = {
    [0] = alias_sym_statement_identifier,
  },
  [126] = {
    [1] = alias_sym_statement_identifier,
  },
  [142] = {
    [0] = anon_sym_list,
  },
  [145] = {
    [1] = anon_sym_list,
  },
  [146] = {
    [1] = anon_sym_list,
  },
  [150] = {
    [1] = sym_identifier,
  },
  [157] = {
    [2] = anon_sym_list,
  },
  [161] = {
    [1] = anon_sym_list,
    [2] = sym_identifier,
  },
  [162] = {
    [1] = anon_sym_list,
  },
  [163] = {
    [2] = sym_identifier,
  },
  [165] = {
    [2] = anon_sym_list,
  },
  [170] = {
    [2] = anon_sym_list,
    [3] = sym_identifier,
  },
  [171] = {
    [2] = anon_sym_list,
  },
  [172] = {
    [3] = sym_identifier,
  },
  [177] = {
    [1] = alias_sym_namespace_export,
  },
  [179] = {
    [1] = alias_sym_import_specifier,
  },
  [183] = {
    [2] = anon_sym_list,
  },
  [184] = {
    [1] = anon_sym_list,
  },
  [197] = {
    [2] = alias_sym_property_identifier,
  },
  [199] = {
    [2] = alias_sym_property_identifier,
  },
  [201] = {
    [2] = alias_sym_property_identifier,
  },
  [207] = {
    [1] = anon_sym_list,
  },
  [213] = {
    [0] = sym_identifier,
  },
  [214] = {
    [2] = anon_sym_list,
  },
  [215] = {
    [2] = anon_sym_list,
  },
  [217] = {
    [2] = anon_sym_list,
    [3] = sym_identifier,
  },
  [218] = {
    [2] = anon_sym_list,
  },
  [219] = {
    [3] = sym_identifier,
  },
  [224] = {
    [1] = anon_sym_list,
  },
  [227] = {
    [2] = anon_sym_list,
  },
  [228] = {
    [2] = anon_sym_list,
  },
  [229] = {
    [1] = anon_sym_list,
  },
  [232] = {
    [3] = anon_sym_list,
  },
  [235] = {
    [0] = anon_sym_list,
  },
  [252] = {
    [2] = anon_sym_list,
  },
  [254] = {
    [1] = anon_sym_list,
  },
  [255] = {
    [1] = sym_identifier,
  },
  [259] = {
    [2] = anon_sym_list,
  },
  [262] = {
    [3] = anon_sym_list,
  },
  [263] = {
    [3] = anon_sym_list,
  },
  [287] = {
    [3] = alias_sym_property_identifier,
  },
  [288] = {
    [3] = anon_sym_list,
  },
  [290] = {
    [1] = sym_identifier,
  },
  [291] = {
    [0] = anon_sym_list,
  },
  [309] = {
    [2] = sym_identifier,
  },
  [319] = {
    [3] = sym_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__import_export_specifier, 2,
    sym__import_export_specifier,
    alias_sym_import_specifier,
  sym_namespace_import_export, 2,
    sym_namespace_import_export,
    alias_sym_namespace_export,
  sym_predefined_type, 2,
    sym_predefined_type,
    sym_identifier,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 4,
  [5] = 4,
  [6] = 4,
  [7] = 4,
  [8] = 4,
  [9] = 4,
  [10] = 4,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 16,
  [18] = 18,
  [19] = 16,
  [20] = 18,
  [21] = 18,
  [22] = 16,
  [23] = 16,
  [24] = 18,
  [25] = 16,
  [26] = 18,
  [27] = 16,
  [28] = 16,
  [29] = 18,
  [30] = 18,
  [31] = 18,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 33,
  [37] = 35,
  [38] = 38,
  [39] = 39,
  [40] = 35,
  [41] = 33,
  [42] = 42,
  [43] = 38,
  [44] = 44,
  [45] = 39,
  [46] = 34,
  [47] = 47,
  [48] = 44,
  [49] = 38,
  [50] = 50,
  [51] = 34,
  [52] = 44,
  [53] = 47,
  [54] = 50,
  [55] = 42,
  [56] = 32,
  [57] = 47,
  [58] = 39,
  [59] = 50,
  [60] = 42,
  [61] = 61,
  [62] = 61,
  [63] = 61,
  [64] = 61,
  [65] = 61,
  [66] = 61,
  [67] = 61,
  [68] = 61,
  [69] = 61,
  [70] = 61,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 75,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 79,
  [81] = 79,
  [82] = 82,
  [83] = 82,
  [84] = 82,
  [85] = 82,
  [86] = 82,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 90,
  [92] = 90,
  [93] = 90,
  [94] = 90,
  [95] = 90,
  [96] = 90,
  [97] = 90,
  [98] = 98,
  [99] = 90,
  [100] = 100,
  [101] = 100,
  [102] = 100,
  [103] = 100,
  [104] = 100,
  [105] = 100,
  [106] = 100,
  [107] = 100,
  [108] = 100,
  [109] = 109,
  [110] = 109,
  [111] = 109,
  [112] = 112,
  [113] = 112,
  [114] = 109,
  [115] = 112,
  [116] = 112,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 127,
  [129] = 129,
  [130] = 130,
  [131] = 129,
  [132] = 132,
  [133] = 133,
  [134] = 133,
  [135] = 132,
  [136] = 136,
  [137] = 130,
  [138] = 133,
  [139] = 132,
  [140] = 130,
  [141] = 136,
  [142] = 136,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 145,
  [147] = 147,
  [148] = 145,
  [149] = 149,
  [150] = 145,
  [151] = 151,
  [152] = 145,
  [153] = 153,
  [154] = 145,
  [155] = 155,
  [156] = 155,
  [157] = 145,
  [158] = 155,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 153,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 153,
  [181] = 181,
  [182] = 182,
  [183] = 143,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 130,
  [189] = 189,
  [190] = 130,
  [191] = 191,
  [192] = 191,
  [193] = 143,
  [194] = 130,
  [195] = 130,
  [196] = 130,
  [197] = 197,
  [198] = 197,
  [199] = 199,
  [200] = 200,
  [201] = 144,
  [202] = 130,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 143,
  [207] = 143,
  [208] = 143,
  [209] = 204,
  [210] = 143,
  [211] = 143,
  [212] = 204,
  [213] = 143,
  [214] = 204,
  [215] = 215,
  [216] = 204,
  [217] = 204,
  [218] = 218,
  [219] = 204,
  [220] = 205,
  [221] = 215,
  [222] = 222,
  [223] = 143,
  [224] = 224,
  [225] = 224,
  [226] = 226,
  [227] = 224,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 231,
  [235] = 235,
  [236] = 231,
  [237] = 231,
  [238] = 231,
  [239] = 231,
  [240] = 231,
  [241] = 235,
  [242] = 231,
  [243] = 231,
  [244] = 244,
  [245] = 231,
  [246] = 231,
  [247] = 231,
  [248] = 231,
  [249] = 231,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 253,
  [255] = 252,
  [256] = 252,
  [257] = 257,
  [258] = 258,
  [259] = 258,
  [260] = 258,
  [261] = 261,
  [262] = 262,
  [263] = 262,
  [264] = 257,
  [265] = 262,
  [266] = 258,
  [267] = 262,
  [268] = 268,
  [269] = 269,
  [270] = 258,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 262,
  [275] = 257,
  [276] = 258,
  [277] = 277,
  [278] = 278,
  [279] = 269,
  [280] = 280,
  [281] = 280,
  [282] = 269,
  [283] = 278,
  [284] = 257,
  [285] = 277,
  [286] = 257,
  [287] = 287,
  [288] = 269,
  [289] = 278,
  [290] = 269,
  [291] = 280,
  [292] = 287,
  [293] = 280,
  [294] = 258,
  [295] = 278,
  [296] = 296,
  [297] = 296,
  [298] = 257,
  [299] = 278,
  [300] = 280,
  [301] = 301,
  [302] = 257,
  [303] = 277,
  [304] = 269,
  [305] = 262,
  [306] = 287,
  [307] = 262,
  [308] = 308,
  [309] = 287,
  [310] = 310,
  [311] = 280,
  [312] = 278,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 287,
  [317] = 262,
  [318] = 269,
  [319] = 262,
  [320] = 258,
  [321] = 258,
  [322] = 277,
  [323] = 271,
  [324] = 287,
  [325] = 257,
  [326] = 278,
  [327] = 277,
  [328] = 277,
  [329] = 269,
  [330] = 280,
  [331] = 257,
  [332] = 287,
  [333] = 333,
  [334] = 268,
  [335] = 258,
  [336] = 287,
  [337] = 287,
  [338] = 277,
  [339] = 273,
  [340] = 340,
  [341] = 269,
  [342] = 262,
  [343] = 340,
  [344] = 280,
  [345] = 280,
  [346] = 278,
  [347] = 277,
  [348] = 348,
  [349] = 278,
  [350] = 350,
  [351] = 277,
  [352] = 352,
  [353] = 353,
  [354] = 354,
  [355] = 355,
  [356] = 354,
  [357] = 357,
  [358] = 358,
  [359] = 353,
  [360] = 360,
  [361] = 353,
  [362] = 362,
  [363] = 363,
  [364] = 362,
  [365] = 354,
  [366] = 366,
  [367] = 363,
  [368] = 368,
  [369] = 369,
  [370] = 366,
  [371] = 369,
  [372] = 355,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 355,
  [383] = 373,
  [384] = 374,
  [385] = 385,
  [386] = 386,
  [387] = 375,
  [388] = 388,
  [389] = 380,
  [390] = 390,
  [391] = 353,
  [392] = 375,
  [393] = 376,
  [394] = 394,
  [395] = 377,
  [396] = 378,
  [397] = 362,
  [398] = 379,
  [399] = 354,
  [400] = 363,
  [401] = 385,
  [402] = 385,
  [403] = 378,
  [404] = 366,
  [405] = 369,
  [406] = 355,
  [407] = 373,
  [408] = 379,
  [409] = 409,
  [410] = 353,
  [411] = 374,
  [412] = 379,
  [413] = 413,
  [414] = 369,
  [415] = 366,
  [416] = 366,
  [417] = 362,
  [418] = 418,
  [419] = 419,
  [420] = 363,
  [421] = 375,
  [422] = 380,
  [423] = 378,
  [424] = 424,
  [425] = 368,
  [426] = 426,
  [427] = 376,
  [428] = 358,
  [429] = 357,
  [430] = 377,
  [431] = 378,
  [432] = 379,
  [433] = 385,
  [434] = 358,
  [435] = 380,
  [436] = 436,
  [437] = 377,
  [438] = 385,
  [439] = 436,
  [440] = 376,
  [441] = 436,
  [442] = 442,
  [443] = 375,
  [444] = 374,
  [445] = 368,
  [446] = 374,
  [447] = 363,
  [448] = 419,
  [449] = 436,
  [450] = 354,
  [451] = 357,
  [452] = 373,
  [453] = 373,
  [454] = 355,
  [455] = 369,
  [456] = 419,
  [457] = 386,
  [458] = 388,
  [459] = 436,
  [460] = 381,
  [461] = 380,
  [462] = 366,
  [463] = 358,
  [464] = 353,
  [465] = 380,
  [466] = 358,
  [467] = 388,
  [468] = 381,
  [469] = 385,
  [470] = 362,
  [471] = 357,
  [472] = 472,
  [473] = 379,
  [474] = 436,
  [475] = 386,
  [476] = 476,
  [477] = 378,
  [478] = 377,
  [479] = 419,
  [480] = 368,
  [481] = 380,
  [482] = 363,
  [483] = 354,
  [484] = 353,
  [485] = 368,
  [486] = 366,
  [487] = 380,
  [488] = 380,
  [489] = 419,
  [490] = 373,
  [491] = 491,
  [492] = 376,
  [493] = 493,
  [494] = 375,
  [495] = 374,
  [496] = 373,
  [497] = 355,
  [498] = 369,
  [499] = 366,
  [500] = 363,
  [501] = 354,
  [502] = 376,
  [503] = 374,
  [504] = 375,
  [505] = 368,
  [506] = 357,
  [507] = 358,
  [508] = 380,
  [509] = 381,
  [510] = 386,
  [511] = 381,
  [512] = 436,
  [513] = 357,
  [514] = 388,
  [515] = 368,
  [516] = 358,
  [517] = 381,
  [518] = 518,
  [519] = 436,
  [520] = 491,
  [521] = 386,
  [522] = 385,
  [523] = 379,
  [524] = 378,
  [525] = 381,
  [526] = 381,
  [527] = 386,
  [528] = 358,
  [529] = 419,
  [530] = 380,
  [531] = 362,
  [532] = 362,
  [533] = 357,
  [534] = 377,
  [535] = 386,
  [536] = 381,
  [537] = 358,
  [538] = 368,
  [539] = 353,
  [540] = 376,
  [541] = 386,
  [542] = 375,
  [543] = 374,
  [544] = 354,
  [545] = 380,
  [546] = 373,
  [547] = 547,
  [548] = 357,
  [549] = 426,
  [550] = 368,
  [551] = 363,
  [552] = 377,
  [553] = 362,
  [554] = 419,
  [555] = 369,
  [556] = 380,
  [557] = 419,
  [558] = 362,
  [559] = 355,
  [560] = 366,
  [561] = 561,
  [562] = 369,
  [563] = 436,
  [564] = 386,
  [565] = 380,
  [566] = 419,
  [567] = 353,
  [568] = 355,
  [569] = 385,
  [570] = 355,
  [571] = 379,
  [572] = 378,
  [573] = 357,
  [574] = 385,
  [575] = 354,
  [576] = 379,
  [577] = 378,
  [578] = 377,
  [579] = 376,
  [580] = 377,
  [581] = 375,
  [582] = 363,
  [583] = 374,
  [584] = 373,
  [585] = 376,
  [586] = 369,
  [587] = 587,
  [588] = 587,
  [589] = 587,
  [590] = 587,
  [591] = 591,
  [592] = 591,
  [593] = 591,
  [594] = 591,
  [595] = 595,
  [596] = 595,
  [597] = 595,
  [598] = 595,
  [599] = 599,
  [600] = 600,
  [601] = 599,
  [602] = 600,
  [603] = 599,
  [604] = 600,
  [605] = 599,
  [606] = 600,
  [607] = 607,
  [608] = 608,
  [609] = 609,
  [610] = 610,
  [611] = 607,
  [612] = 612,
  [613] = 613,
  [614] = 607,
  [615] = 607,
  [616] = 616,
  [617] = 616,
  [618] = 616,
  [619] = 619,
  [620] = 620,
  [621] = 620,
  [622] = 619,
  [623] = 620,
  [624] = 620,
  [625] = 619,
  [626] = 619,
  [627] = 627,
  [628] = 627,
  [629] = 627,
  [630] = 630,
  [631] = 631,
  [632] = 631,
  [633] = 633,
  [634] = 634,
  [635] = 633,
  [636] = 634,
  [637] = 637,
  [638] = 638,
  [639] = 633,
  [640] = 640,
  [641] = 637,
  [642] = 637,
  [643] = 638,
  [644] = 638,
  [645] = 630,
  [646] = 633,
  [647] = 638,
  [648] = 633,
  [649] = 633,
  [650] = 650,
  [651] = 651,
  [652] = 633,
  [653] = 633,
  [654] = 654,
  [655] = 655,
  [656] = 633,
  [657] = 657,
  [658] = 657,
  [659] = 173,
  [660] = 170,
  [661] = 631,
  [662] = 657,
  [663] = 663,
  [664] = 187,
  [665] = 186,
  [666] = 633,
  [667] = 657,
  [668] = 633,
  [669] = 633,
  [670] = 633,
  [671] = 161,
  [672] = 163,
  [673] = 633,
  [674] = 151,
  [675] = 675,
  [676] = 676,
  [677] = 163,
  [678] = 678,
  [679] = 679,
  [680] = 680,
  [681] = 149,
  [682] = 682,
  [683] = 683,
  [684] = 186,
  [685] = 161,
  [686] = 686,
  [687] = 687,
  [688] = 688,
  [689] = 689,
  [690] = 690,
  [691] = 187,
  [692] = 692,
  [693] = 633,
  [694] = 633,
  [695] = 175,
  [696] = 696,
  [697] = 650,
  [698] = 633,
  [699] = 699,
  [700] = 700,
  [701] = 701,
  [702] = 702,
  [703] = 703,
  [704] = 704,
  [705] = 705,
  [706] = 706,
  [707] = 707,
  [708] = 708,
  [709] = 709,
  [710] = 170,
  [711] = 711,
  [712] = 712,
  [713] = 713,
  [714] = 714,
  [715] = 715,
  [716] = 716,
  [717] = 717,
  [718] = 173,
  [719] = 719,
  [720] = 720,
  [721] = 721,
  [722] = 722,
  [723] = 723,
  [724] = 724,
  [725] = 725,
  [726] = 726,
  [727] = 727,
  [728] = 728,
  [729] = 729,
  [730] = 730,
  [731] = 731,
  [732] = 732,
  [733] = 733,
  [734] = 734,
  [735] = 735,
  [736] = 736,
  [737] = 737,
  [738] = 738,
  [739] = 739,
  [740] = 740,
  [741] = 741,
  [742] = 742,
  [743] = 743,
  [744] = 744,
  [745] = 745,
  [746] = 746,
  [747] = 747,
  [748] = 748,
  [749] = 749,
  [750] = 750,
  [751] = 751,
  [752] = 752,
  [753] = 753,
  [754] = 754,
  [755] = 755,
  [756] = 756,
  [757] = 757,
  [758] = 758,
  [759] = 759,
  [760] = 760,
  [761] = 761,
  [762] = 762,
  [763] = 763,
  [764] = 764,
  [765] = 765,
  [766] = 766,
  [767] = 767,
  [768] = 768,
  [769] = 769,
  [770] = 770,
  [771] = 771,
  [772] = 772,
  [773] = 773,
  [774] = 774,
  [775] = 775,
  [776] = 776,
  [777] = 777,
  [778] = 778,
  [779] = 779,
  [780] = 780,
  [781] = 781,
  [782] = 782,
  [783] = 783,
  [784] = 784,
  [785] = 785,
  [786] = 786,
  [787] = 787,
  [788] = 788,
  [789] = 789,
  [790] = 790,
  [791] = 176,
  [792] = 792,
  [793] = 793,
  [794] = 794,
  [795] = 795,
  [796] = 796,
  [797] = 797,
  [798] = 798,
  [799] = 799,
  [800] = 800,
  [801] = 801,
  [802] = 177,
  [803] = 803,
  [804] = 804,
  [805] = 805,
  [806] = 806,
  [807] = 807,
  [808] = 808,
  [809] = 809,
  [810] = 185,
  [811] = 811,
  [812] = 812,
  [813] = 813,
  [814] = 814,
  [815] = 815,
  [816] = 816,
  [817] = 817,
  [818] = 818,
  [819] = 178,
  [820] = 820,
  [821] = 821,
  [822] = 822,
  [823] = 823,
  [824] = 824,
  [825] = 825,
  [826] = 826,
  [827] = 827,
  [828] = 828,
  [829] = 829,
  [830] = 830,
  [831] = 831,
  [832] = 832,
  [833] = 833,
  [834] = 834,
  [835] = 835,
  [836] = 836,
  [837] = 837,
  [838] = 838,
  [839] = 839,
  [840] = 840,
  [841] = 841,
  [842] = 842,
  [843] = 843,
  [844] = 844,
  [845] = 845,
  [846] = 846,
  [847] = 847,
  [848] = 848,
  [849] = 849,
  [850] = 850,
  [851] = 851,
  [852] = 852,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 856,
  [857] = 857,
  [858] = 858,
  [859] = 859,
  [860] = 860,
  [861] = 861,
  [862] = 862,
  [863] = 863,
  [864] = 864,
  [865] = 151,
  [866] = 149,
  [867] = 867,
  [868] = 867,
  [869] = 176,
  [870] = 867,
  [871] = 867,
  [872] = 867,
  [873] = 147,
  [874] = 175,
  [875] = 177,
  [876] = 168,
  [877] = 166,
  [878] = 186,
  [879] = 174,
  [880] = 182,
  [881] = 171,
  [882] = 162,
  [883] = 883,
  [884] = 884,
  [885] = 884,
  [886] = 884,
  [887] = 887,
  [888] = 884,
  [889] = 889,
  [890] = 887,
  [891] = 169,
  [892] = 884,
  [893] = 884,
  [894] = 889,
  [895] = 884,
  [896] = 185,
  [897] = 884,
  [898] = 167,
  [899] = 899,
  [900] = 164,
  [901] = 884,
  [902] = 184,
  [903] = 884,
  [904] = 178,
  [905] = 181,
  [906] = 884,
  [907] = 907,
  [908] = 187,
  [909] = 170,
  [910] = 189,
  [911] = 172,
  [912] = 887,
  [913] = 887,
  [914] = 889,
  [915] = 884,
  [916] = 161,
  [917] = 173,
  [918] = 889,
  [919] = 889,
  [920] = 884,
  [921] = 163,
  [922] = 887,
  [923] = 923,
  [924] = 924,
  [925] = 924,
  [926] = 926,
  [927] = 927,
  [928] = 928,
  [929] = 926,
  [930] = 928,
  [931] = 926,
  [932] = 928,
  [933] = 928,
  [934] = 927,
  [935] = 927,
  [936] = 926,
  [937] = 937,
  [938] = 938,
  [939] = 939,
  [940] = 940,
  [941] = 937,
  [942] = 937,
  [943] = 943,
  [944] = 943,
  [945] = 937,
  [946] = 943,
  [947] = 939,
  [948] = 948,
  [949] = 937,
  [950] = 943,
  [951] = 943,
  [952] = 940,
  [953] = 940,
  [954] = 940,
  [955] = 948,
  [956] = 939,
  [957] = 940,
  [958] = 940,
  [959] = 937,
  [960] = 943,
  [961] = 948,
  [962] = 948,
  [963] = 939,
  [964] = 939,
  [965] = 939,
  [966] = 948,
  [967] = 967,
  [968] = 968,
  [969] = 969,
  [970] = 967,
  [971] = 971,
  [972] = 972,
  [973] = 973,
  [974] = 974,
  [975] = 975,
  [976] = 968,
  [977] = 975,
  [978] = 978,
  [979] = 979,
  [980] = 980,
  [981] = 981,
  [982] = 982,
  [983] = 974,
  [984] = 968,
  [985] = 985,
  [986] = 986,
  [987] = 969,
  [988] = 967,
  [989] = 971,
  [990] = 972,
  [991] = 973,
  [992] = 992,
  [993] = 974,
  [994] = 994,
  [995] = 974,
  [996] = 994,
  [997] = 994,
  [998] = 994,
  [999] = 968,
  [1000] = 975,
  [1001] = 985,
  [1002] = 1002,
  [1003] = 973,
  [1004] = 1004,
  [1005] = 1004,
  [1006] = 1006,
  [1007] = 972,
  [1008] = 971,
  [1009] = 1009,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 1013,
  [1014] = 1006,
  [1015] = 986,
  [1016] = 1006,
  [1017] = 1017,
  [1018] = 978,
  [1019] = 1019,
  [1020] = 979,
  [1021] = 994,
  [1022] = 967,
  [1023] = 980,
  [1024] = 974,
  [1025] = 981,
  [1026] = 982,
  [1027] = 969,
  [1028] = 971,
  [1029] = 986,
  [1030] = 972,
  [1031] = 1031,
  [1032] = 1032,
  [1033] = 973,
  [1034] = 975,
  [1035] = 985,
  [1036] = 972,
  [1037] = 985,
  [1038] = 974,
  [1039] = 1006,
  [1040] = 1040,
  [1041] = 986,
  [1042] = 1042,
  [1043] = 1004,
  [1044] = 969,
  [1045] = 1006,
  [1046] = 967,
  [1047] = 1047,
  [1048] = 978,
  [1049] = 979,
  [1050] = 992,
  [1051] = 1040,
  [1052] = 1031,
  [1053] = 980,
  [1054] = 1054,
  [1055] = 978,
  [1056] = 981,
  [1057] = 982,
  [1058] = 1032,
  [1059] = 1006,
  [1060] = 992,
  [1061] = 969,
  [1062] = 967,
  [1063] = 981,
  [1064] = 980,
  [1065] = 979,
  [1066] = 978,
  [1067] = 1067,
  [1068] = 971,
  [1069] = 972,
  [1070] = 982,
  [1071] = 981,
  [1072] = 1042,
  [1073] = 1073,
  [1074] = 980,
  [1075] = 985,
  [1076] = 1076,
  [1077] = 973,
  [1078] = 979,
  [1079] = 978,
  [1080] = 973,
  [1081] = 1081,
  [1082] = 1082,
  [1083] = 1083,
  [1084] = 982,
  [1085] = 979,
  [1086] = 980,
  [1087] = 981,
  [1088] = 982,
  [1089] = 1031,
  [1090] = 994,
  [1091] = 975,
  [1092] = 968,
  [1093] = 985,
  [1094] = 986,
  [1095] = 968,
  [1096] = 975,
  [1097] = 969,
  [1098] = 986,
  [1099] = 971,
  [1100] = 1100,
  [1101] = 1101,
  [1102] = 1101,
  [1103] = 1100,
  [1104] = 1104,
  [1105] = 1100,
  [1106] = 1106,
  [1107] = 1107,
  [1108] = 1100,
  [1109] = 1104,
  [1110] = 1110,
  [1111] = 1100,
  [1112] = 1112,
  [1113] = 1106,
  [1114] = 1106,
  [1115] = 1002,
  [1116] = 1116,
  [1117] = 1104,
  [1118] = 1100,
  [1119] = 1119,
  [1120] = 1120,
  [1121] = 1121,
  [1122] = 1122,
  [1123] = 1121,
  [1124] = 1124,
  [1125] = 1121,
  [1126] = 1126,
  [1127] = 1127,
  [1128] = 1128,
  [1129] = 1129,
  [1130] = 1121,
  [1131] = 1100,
  [1132] = 1100,
  [1133] = 1133,
  [1134] = 1134,
  [1135] = 1135,
  [1136] = 1136,
  [1137] = 1137,
  [1138] = 1138,
  [1139] = 1139,
  [1140] = 1140,
  [1141] = 1100,
  [1142] = 1134,
  [1143] = 1139,
  [1144] = 1139,
  [1145] = 1145,
  [1146] = 1146,
  [1147] = 1134,
  [1148] = 1100,
  [1149] = 1149,
  [1150] = 1139,
  [1151] = 1138,
  [1152] = 1152,
  [1153] = 1138,
  [1154] = 1134,
  [1155] = 1138,
  [1156] = 1100,
  [1157] = 1032,
  [1158] = 1100,
  [1159] = 1159,
  [1160] = 1100,
  [1161] = 1100,
  [1162] = 855,
  [1163] = 1163,
  [1164] = 1163,
  [1165] = 1163,
  [1166] = 1166,
  [1167] = 1167,
  [1168] = 1167,
  [1169] = 1169,
  [1170] = 1163,
  [1171] = 1163,
  [1172] = 1163,
  [1173] = 1173,
  [1174] = 860,
  [1175] = 1175,
  [1176] = 1100,
  [1177] = 1112,
  [1178] = 1100,
  [1179] = 1100,
  [1180] = 1100,
  [1181] = 1163,
  [1182] = 1167,
  [1183] = 1173,
  [1184] = 1169,
  [1185] = 1185,
  [1186] = 1173,
  [1187] = 1187,
  [1188] = 1188,
  [1189] = 1189,
  [1190] = 1185,
  [1191] = 1169,
  [1192] = 1167,
  [1193] = 1193,
  [1194] = 1167,
  [1195] = 1195,
  [1196] = 1187,
  [1197] = 1100,
  [1198] = 1198,
  [1199] = 1199,
  [1200] = 1200,
  [1201] = 1195,
  [1202] = 1202,
  [1203] = 1167,
  [1204] = 1204,
  [1205] = 1200,
  [1206] = 1199,
  [1207] = 1207,
  [1208] = 1202,
  [1209] = 1209,
  [1210] = 1199,
  [1211] = 1198,
  [1212] = 1204,
  [1213] = 1200,
  [1214] = 1167,
  [1215] = 1215,
  [1216] = 1167,
  [1217] = 1199,
  [1218] = 1202,
  [1219] = 1199,
  [1220] = 1188,
  [1221] = 1198,
  [1222] = 1200,
  [1223] = 1198,
  [1224] = 1224,
  [1225] = 1200,
  [1226] = 1198,
  [1227] = 1199,
  [1228] = 1198,
  [1229] = 1188,
  [1230] = 1200,
  [1231] = 1200,
  [1232] = 1224,
  [1233] = 1209,
  [1234] = 1234,
  [1235] = 1169,
  [1236] = 1199,
  [1237] = 1234,
  [1238] = 1215,
  [1239] = 1169,
  [1240] = 1240,
  [1241] = 1195,
  [1242] = 1240,
  [1243] = 1198,
  [1244] = 1244,
  [1245] = 1245,
  [1246] = 1169,
  [1247] = 1136,
  [1248] = 1167,
  [1249] = 1249,
  [1250] = 1234,
  [1251] = 1149,
  [1252] = 855,
  [1253] = 1245,
  [1254] = 1254,
  [1255] = 1169,
  [1256] = 1189,
  [1257] = 1188,
  [1258] = 1146,
  [1259] = 1140,
  [1260] = 1167,
  [1261] = 1234,
  [1262] = 860,
  [1263] = 1175,
  [1264] = 1167,
  [1265] = 1169,
  [1266] = 1215,
  [1267] = 1234,
  [1268] = 1268,
  [1269] = 1269,
  [1270] = 1254,
  [1271] = 1152,
  [1272] = 1169,
  [1273] = 1215,
  [1274] = 1245,
  [1275] = 1135,
  [1276] = 1167,
  [1277] = 1215,
  [1278] = 1254,
  [1279] = 1145,
  [1280] = 1268,
  [1281] = 1281,
  [1282] = 1195,
  [1283] = 1215,
  [1284] = 1234,
  [1285] = 1175,
  [1286] = 1188,
  [1287] = 1234,
  [1288] = 1234,
  [1289] = 1289,
  [1290] = 1290,
  [1291] = 1291,
  [1292] = 1291,
  [1293] = 1167,
  [1294] = 1215,
  [1295] = 1295,
  [1296] = 1188,
  [1297] = 1291,
  [1298] = 1291,
  [1299] = 1291,
  [1300] = 1289,
  [1301] = 1188,
  [1302] = 1167,
  [1303] = 1215,
  [1304] = 1175,
  [1305] = 1188,
  [1306] = 1306,
  [1307] = 1291,
  [1308] = 1169,
  [1309] = 1291,
  [1310] = 1289,
  [1311] = 1175,
  [1312] = 1312,
  [1313] = 1188,
  [1314] = 1207,
  [1315] = 1193,
  [1316] = 1234,
  [1317] = 1185,
  [1318] = 1318,
  [1319] = 1234,
  [1320] = 1187,
  [1321] = 1215,
  [1322] = 1175,
  [1323] = 1323,
  [1324] = 1324,
  [1325] = 1325,
  [1326] = 1188,
  [1327] = 1215,
  [1328] = 1328,
  [1329] = 1328,
  [1330] = 1215,
  [1331] = 1215,
  [1332] = 1215,
  [1333] = 1215,
  [1334] = 1281,
  [1335] = 1234,
  [1336] = 1234,
  [1337] = 1328,
  [1338] = 1215,
  [1339] = 1328,
  [1340] = 1328,
  [1341] = 1234,
  [1342] = 1249,
  [1343] = 1328,
  [1344] = 1215,
  [1345] = 1175,
  [1346] = 1234,
  [1347] = 1234,
  [1348] = 1240,
  [1349] = 1328,
  [1350] = 1234,
  [1351] = 1175,
  [1352] = 1215,
  [1353] = 1234,
  [1354] = 1175,
  [1355] = 1306,
  [1356] = 1175,
  [1357] = 1357,
  [1358] = 1357,
  [1359] = 1359,
  [1360] = 1360,
  [1361] = 1361,
  [1362] = 1361,
  [1363] = 1363,
  [1364] = 1363,
  [1365] = 176,
  [1366] = 177,
  [1367] = 1363,
  [1368] = 1363,
  [1369] = 1363,
  [1370] = 1363,
  [1371] = 1371,
  [1372] = 1372,
  [1373] = 1373,
  [1374] = 1374,
  [1375] = 1372,
  [1376] = 1372,
  [1377] = 1373,
  [1378] = 1372,
  [1379] = 1372,
  [1380] = 1371,
  [1381] = 1373,
  [1382] = 1371,
  [1383] = 1371,
  [1384] = 1372,
  [1385] = 1373,
  [1386] = 1371,
  [1387] = 1373,
  [1388] = 1371,
  [1389] = 1373,
  [1390] = 1373,
  [1391] = 1391,
  [1392] = 1373,
  [1393] = 1372,
  [1394] = 1391,
  [1395] = 1372,
  [1396] = 1396,
  [1397] = 1397,
  [1398] = 1396,
  [1399] = 1396,
  [1400] = 1396,
  [1401] = 1396,
  [1402] = 1397,
  [1403] = 1397,
  [1404] = 1397,
  [1405] = 1397,
  [1406] = 1406,
  [1407] = 1407,
  [1408] = 1408,
  [1409] = 1397,
  [1410] = 1396,
  [1411] = 1411,
  [1412] = 177,
  [1413] = 176,
  [1414] = 163,
  [1415] = 1411,
  [1416] = 1416,
  [1417] = 1411,
  [1418] = 187,
  [1419] = 1411,
  [1420] = 1411,
  [1421] = 161,
  [1422] = 1411,
  [1423] = 186,
  [1424] = 1424,
  [1425] = 1425,
  [1426] = 1426,
  [1427] = 1427,
  [1428] = 1428,
  [1429] = 1426,
  [1430] = 1430,
  [1431] = 1428,
  [1432] = 1426,
  [1433] = 1433,
  [1434] = 1434,
  [1435] = 1435,
  [1436] = 1426,
  [1437] = 1437,
  [1438] = 1438,
  [1439] = 1439,
  [1440] = 1426,
  [1441] = 1426,
  [1442] = 1442,
  [1443] = 1426,
  [1444] = 1444,
  [1445] = 1445,
  [1446] = 151,
  [1447] = 1447,
  [1448] = 1448,
  [1449] = 1449,
  [1450] = 1450,
  [1451] = 1451,
  [1452] = 1452,
  [1453] = 1453,
  [1454] = 1454,
  [1455] = 1455,
  [1456] = 1456,
  [1457] = 1457,
  [1458] = 1458,
  [1459] = 149,
  [1460] = 1460,
  [1461] = 176,
  [1462] = 1462,
  [1463] = 1451,
  [1464] = 1464,
  [1465] = 1465,
  [1466] = 1466,
  [1467] = 1467,
  [1468] = 177,
  [1469] = 1469,
  [1470] = 1454,
  [1471] = 1471,
  [1472] = 1472,
  [1473] = 1473,
  [1474] = 1448,
  [1475] = 1453,
  [1476] = 1445,
  [1477] = 1477,
  [1478] = 1478,
  [1479] = 1478,
  [1480] = 1480,
  [1481] = 1481,
  [1482] = 1480,
  [1483] = 1478,
  [1484] = 1484,
  [1485] = 147,
  [1486] = 1486,
  [1487] = 1453,
  [1488] = 1457,
  [1489] = 1453,
  [1490] = 1457,
  [1491] = 1453,
  [1492] = 1480,
  [1493] = 1478,
  [1494] = 1457,
  [1495] = 1457,
  [1496] = 1496,
  [1497] = 1453,
  [1498] = 1498,
  [1499] = 1478,
  [1500] = 1480,
  [1501] = 1501,
  [1502] = 1457,
  [1503] = 1453,
  [1504] = 1504,
  [1505] = 1478,
  [1506] = 1480,
  [1507] = 1480,
  [1508] = 1508,
  [1509] = 1509,
  [1510] = 1457,
  [1511] = 1511,
  [1512] = 1512,
  [1513] = 1513,
  [1514] = 1514,
  [1515] = 610,
  [1516] = 1516,
  [1517] = 1517,
  [1518] = 1518,
  [1519] = 1519,
  [1520] = 1520,
  [1521] = 1521,
  [1522] = 1522,
  [1523] = 1523,
  [1524] = 1524,
  [1525] = 1525,
  [1526] = 1526,
  [1527] = 1527,
  [1528] = 1528,
  [1529] = 1529,
  [1530] = 1530,
  [1531] = 1531,
  [1532] = 1532,
  [1533] = 1533,
  [1534] = 1534,
  [1535] = 1535,
  [1536] = 1536,
  [1537] = 1537,
  [1538] = 1538,
  [1539] = 1539,
  [1540] = 1540,
  [1541] = 1541,
  [1542] = 1542,
  [1543] = 1543,
  [1544] = 1544,
  [1545] = 1545,
  [1546] = 1546,
  [1547] = 1547,
  [1548] = 1548,
  [1549] = 1549,
  [1550] = 1550,
  [1551] = 186,
  [1552] = 187,
  [1553] = 1553,
  [1554] = 1554,
  [1555] = 1555,
  [1556] = 1556,
  [1557] = 1557,
  [1558] = 1120,
  [1559] = 149,
  [1560] = 151,
  [1561] = 1561,
  [1562] = 1562,
  [1563] = 1563,
  [1564] = 1564,
  [1565] = 1542,
  [1566] = 1126,
  [1567] = 1567,
  [1568] = 1554,
  [1569] = 1569,
  [1570] = 1554,
  [1571] = 1546,
  [1572] = 1572,
  [1573] = 1124,
  [1574] = 1574,
  [1575] = 1548,
  [1576] = 1549,
  [1577] = 175,
  [1578] = 1554,
  [1579] = 1554,
  [1580] = 1580,
  [1581] = 1581,
  [1582] = 1554,
  [1583] = 1583,
  [1584] = 1554,
  [1585] = 1585,
  [1586] = 1586,
  [1587] = 1587,
  [1588] = 1588,
  [1589] = 1589,
  [1590] = 1590,
  [1591] = 1591,
  [1592] = 1592,
  [1593] = 1593,
  [1594] = 1594,
  [1595] = 1595,
  [1596] = 1596,
  [1597] = 1597,
  [1598] = 1598,
  [1599] = 1599,
  [1600] = 1600,
  [1601] = 1601,
  [1602] = 1602,
  [1603] = 609,
  [1604] = 1604,
  [1605] = 1605,
  [1606] = 1606,
  [1607] = 1607,
  [1608] = 1608,
  [1609] = 1609,
  [1610] = 1610,
  [1611] = 883,
  [1612] = 1612,
  [1613] = 1613,
  [1614] = 608,
  [1615] = 1615,
  [1616] = 1616,
  [1617] = 1617,
  [1618] = 1618,
  [1619] = 1619,
  [1620] = 1620,
  [1621] = 1621,
  [1622] = 1622,
  [1623] = 907,
  [1624] = 1624,
  [1625] = 1625,
  [1626] = 1626,
  [1627] = 1627,
  [1628] = 1628,
  [1629] = 1629,
  [1630] = 1630,
  [1631] = 1631,
  [1632] = 1632,
  [1633] = 1633,
  [1634] = 1634,
  [1635] = 1635,
  [1636] = 1636,
  [1637] = 1637,
  [1638] = 1638,
  [1639] = 1639,
  [1640] = 1640,
  [1641] = 1641,
  [1642] = 1642,
  [1643] = 1643,
  [1644] = 613,
  [1645] = 1645,
  [1646] = 1646,
  [1647] = 612,
  [1648] = 1648,
  [1649] = 1649,
  [1650] = 1650,
  [1651] = 1651,
  [1652] = 1652,
  [1653] = 1653,
  [1654] = 1654,
  [1655] = 1655,
  [1656] = 1656,
  [1657] = 1657,
  [1658] = 1658,
  [1659] = 1659,
  [1660] = 1660,
  [1661] = 1661,
  [1662] = 1662,
  [1663] = 899,
  [1664] = 1664,
  [1665] = 1665,
  [1666] = 1666,
  [1667] = 1667,
  [1668] = 1668,
  [1669] = 173,
  [1670] = 1580,
  [1671] = 163,
  [1672] = 1672,
  [1673] = 1545,
  [1674] = 1544,
  [1675] = 1543,
  [1676] = 1676,
  [1677] = 175,
  [1678] = 1678,
  [1679] = 1679,
  [1680] = 1680,
  [1681] = 1523,
  [1682] = 1682,
  [1683] = 185,
  [1684] = 1524,
  [1685] = 1685,
  [1686] = 1525,
  [1687] = 1687,
  [1688] = 1688,
  [1689] = 1689,
  [1690] = 1690,
  [1691] = 1528,
  [1692] = 170,
  [1693] = 1435,
  [1694] = 1541,
  [1695] = 1540,
  [1696] = 1539,
  [1697] = 1697,
  [1698] = 1698,
  [1699] = 1538,
  [1700] = 1537,
  [1701] = 1536,
  [1702] = 1535,
  [1703] = 1534,
  [1704] = 1533,
  [1705] = 1532,
  [1706] = 1531,
  [1707] = 1531,
  [1708] = 1530,
  [1709] = 1532,
  [1710] = 1710,
  [1711] = 170,
  [1712] = 1528,
  [1713] = 178,
  [1714] = 1714,
  [1715] = 1525,
  [1716] = 1716,
  [1717] = 1524,
  [1718] = 1718,
  [1719] = 1719,
  [1720] = 1720,
  [1721] = 1523,
  [1722] = 1628,
  [1723] = 1723,
  [1724] = 1533,
  [1725] = 1725,
  [1726] = 1726,
  [1727] = 1727,
  [1728] = 1728,
  [1729] = 1729,
  [1730] = 1730,
  [1731] = 1731,
  [1732] = 1534,
  [1733] = 1728,
  [1734] = 1535,
  [1735] = 1536,
  [1736] = 1537,
  [1737] = 1629,
  [1738] = 1530,
  [1739] = 1739,
  [1740] = 1740,
  [1741] = 1741,
  [1742] = 1742,
  [1743] = 178,
  [1744] = 1539,
  [1745] = 1633,
  [1746] = 1746,
  [1747] = 1540,
  [1748] = 1541,
  [1749] = 1749,
  [1750] = 1750,
  [1751] = 1751,
  [1752] = 1752,
  [1753] = 1753,
  [1754] = 1754,
  [1755] = 1516,
  [1756] = 1516,
  [1757] = 187,
  [1758] = 1758,
  [1759] = 186,
  [1760] = 1538,
  [1761] = 1761,
  [1762] = 173,
  [1763] = 1763,
  [1764] = 1764,
  [1765] = 1765,
  [1766] = 1766,
  [1767] = 1767,
  [1768] = 1768,
  [1769] = 1434,
  [1770] = 1634,
  [1771] = 1771,
  [1772] = 1513,
  [1773] = 1580,
  [1774] = 1774,
  [1775] = 1775,
  [1776] = 1776,
  [1777] = 1777,
  [1778] = 1778,
  [1779] = 1779,
  [1780] = 1780,
  [1781] = 1781,
  [1782] = 1547,
  [1783] = 1529,
  [1784] = 1784,
  [1785] = 1785,
  [1786] = 161,
  [1787] = 1529,
  [1788] = 1788,
  [1789] = 1634,
  [1790] = 1728,
  [1791] = 1633,
  [1792] = 1629,
  [1793] = 1728,
  [1794] = 1628,
  [1795] = 1795,
  [1796] = 1796,
  [1797] = 1797,
  [1798] = 1798,
  [1799] = 1799,
  [1800] = 1800,
  [1801] = 1801,
  [1802] = 1730,
  [1803] = 1803,
  [1804] = 1804,
  [1805] = 1805,
  [1806] = 1547,
  [1807] = 1807,
  [1808] = 1808,
  [1809] = 1809,
  [1810] = 1545,
  [1811] = 1811,
  [1812] = 1812,
  [1813] = 1813,
  [1814] = 1797,
  [1815] = 1815,
  [1816] = 1517,
  [1817] = 1817,
  [1818] = 161,
  [1819] = 1682,
  [1820] = 1544,
  [1821] = 1543,
  [1822] = 163,
  [1823] = 1513,
  [1824] = 185,
  [1825] = 1825,
  [1826] = 1524,
  [1827] = 1730,
  [1828] = 1828,
  [1829] = 1829,
  [1830] = 1634,
  [1831] = 1831,
  [1832] = 1633,
  [1833] = 1629,
  [1834] = 1628,
  [1835] = 1478,
  [1836] = 1480,
  [1837] = 1529,
  [1838] = 1547,
  [1839] = 1545,
  [1840] = 1778,
  [1841] = 1544,
  [1842] = 1543,
  [1843] = 1541,
  [1844] = 1540,
  [1845] = 1845,
  [1846] = 1450,
  [1847] = 1847,
  [1848] = 1539,
  [1849] = 1538,
  [1850] = 1537,
  [1851] = 1536,
  [1852] = 1852,
  [1853] = 1509,
  [1854] = 1557,
  [1855] = 1456,
  [1856] = 1856,
  [1857] = 1829,
  [1858] = 1508,
  [1859] = 1535,
  [1860] = 1534,
  [1861] = 1861,
  [1862] = 1825,
  [1863] = 1580,
  [1864] = 1533,
  [1865] = 1480,
  [1866] = 1631,
  [1867] = 1478,
  [1868] = 1778,
  [1869] = 1829,
  [1870] = 1480,
  [1871] = 1478,
  [1872] = 1478,
  [1873] = 1532,
  [1874] = 1480,
  [1875] = 1875,
  [1876] = 1632,
  [1877] = 1531,
  [1878] = 1513,
  [1879] = 1530,
  [1880] = 1829,
  [1881] = 1829,
  [1882] = 1882,
  [1883] = 1883,
  [1884] = 1828,
  [1885] = 1885,
  [1886] = 1478,
  [1887] = 1480,
  [1888] = 1888,
  [1889] = 1889,
  [1890] = 1496,
  [1891] = 1480,
  [1892] = 1892,
  [1893] = 1478,
  [1894] = 1888,
  [1895] = 1528,
  [1896] = 1896,
  [1897] = 1525,
  [1898] = 1473,
  [1899] = 1472,
  [1900] = 1631,
  [1901] = 1831,
  [1902] = 1516,
  [1903] = 1829,
  [1904] = 1889,
  [1905] = 1892,
  [1906] = 1682,
  [1907] = 1480,
  [1908] = 1478,
  [1909] = 1632,
  [1910] = 1523,
  [1911] = 1911,
  [1912] = 1912,
  [1913] = 1797,
  [1914] = 1465,
  [1915] = 1829,
  [1916] = 1538,
  [1917] = 1654,
  [1918] = 1662,
  [1919] = 1661,
  [1920] = 1616,
  [1921] = 1660,
  [1922] = 1580,
  [1923] = 1513,
  [1924] = 1657,
  [1925] = 1656,
  [1926] = 1517,
  [1927] = 1628,
  [1928] = 1629,
  [1929] = 1651,
  [1930] = 1633,
  [1931] = 1512,
  [1932] = 1615,
  [1933] = 1634,
  [1934] = 899,
  [1935] = 1516,
  [1936] = 1936,
  [1937] = 1718,
  [1938] = 1645,
  [1939] = 1939,
  [1940] = 1596,
  [1941] = 1523,
  [1942] = 1524,
  [1943] = 1525,
  [1944] = 1528,
  [1945] = 1945,
  [1946] = 1668,
  [1947] = 1666,
  [1948] = 1665,
  [1949] = 1530,
  [1950] = 1531,
  [1951] = 1532,
  [1952] = 1533,
  [1953] = 1534,
  [1954] = 1535,
  [1955] = 610,
  [1956] = 1627,
  [1957] = 1536,
  [1958] = 1537,
  [1959] = 1527,
  [1960] = 1539,
  [1961] = 1632,
  [1962] = 1529,
  [1963] = 1963,
  [1964] = 613,
  [1965] = 1635,
  [1966] = 1540,
  [1967] = 1967,
  [1968] = 1541,
  [1969] = 1562,
  [1970] = 1655,
  [1971] = 1971,
  [1972] = 1972,
  [1973] = 1646,
  [1974] = 1124,
  [1975] = 1667,
  [1976] = 1971,
  [1977] = 1971,
  [1978] = 883,
  [1979] = 1730,
  [1980] = 608,
  [1981] = 1613,
  [1982] = 1659,
  [1983] = 1658,
  [1984] = 1588,
  [1985] = 1589,
  [1986] = 1590,
  [1987] = 1591,
  [1988] = 1592,
  [1989] = 1593,
  [1990] = 1594,
  [1991] = 1991,
  [1992] = 1882,
  [1993] = 1595,
  [1994] = 1543,
  [1995] = 1626,
  [1996] = 1544,
  [1997] = 1514,
  [1998] = 1563,
  [1999] = 1610,
  [2000] = 1618,
  [2001] = 1598,
  [2002] = 1600,
  [2003] = 1624,
  [2004] = 1609,
  [2005] = 1617,
  [2006] = 1601,
  [2007] = 1518,
  [2008] = 1653,
  [2009] = 1652,
  [2010] = 1650,
  [2011] = 1545,
  [2012] = 2012,
  [2013] = 1649,
  [2014] = 1648,
  [2015] = 1563,
  [2016] = 612,
  [2017] = 2017,
  [2018] = 1645,
  [2019] = 2019,
  [2020] = 1622,
  [2021] = 2021,
  [2022] = 1519,
  [2023] = 1619,
  [2024] = 1967,
  [2025] = 907,
  [2026] = 1861,
  [2027] = 1710,
  [2028] = 1547,
  [2029] = 2029,
  [2030] = 1963,
  [2031] = 1710,
  [2032] = 1945,
  [2033] = 1718,
  [2034] = 1608,
  [2035] = 1520,
  [2036] = 1620,
  [2037] = 1120,
  [2038] = 1607,
  [2039] = 1750,
  [2040] = 1632,
  [2041] = 609,
  [2042] = 1606,
  [2043] = 1631,
  [2044] = 1861,
  [2045] = 1605,
  [2046] = 2046,
  [2047] = 1882,
  [2048] = 1604,
  [2049] = 1991,
  [2050] = 2012,
  [2051] = 1521,
  [2052] = 1621,
  [2053] = 1602,
  [2054] = 1586,
  [2055] = 1967,
  [2056] = 1556,
  [2057] = 1750,
  [2058] = 1526,
  [2059] = 1585,
  [2060] = 1797,
  [2061] = 2061,
  [2062] = 1632,
  [2063] = 1126,
  [2064] = 1682,
  [2065] = 1555,
  [2066] = 1963,
  [2067] = 1631,
  [2068] = 2068,
  [2069] = 1631,
  [2070] = 1612,
  [2071] = 1630,
  [2072] = 1631,
  [2073] = 1632,
  [2074] = 1583,
  [2075] = 1636,
  [2076] = 1581,
  [2077] = 1637,
  [2078] = 2078,
  [2079] = 1638,
  [2080] = 1553,
  [2081] = 1639,
  [2082] = 1640,
  [2083] = 1641,
  [2084] = 147,
  [2085] = 1625,
  [2086] = 2086,
  [2087] = 147,
  [2088] = 2088,
  [2089] = 2089,
  [2090] = 1642,
  [2091] = 1643,
  [2092] = 2092,
  [2093] = 2093,
  [2094] = 1739,
  [2095] = 2095,
  [2096] = 1537,
  [2097] = 1536,
  [2098] = 1689,
  [2099] = 1780,
  [2100] = 1861,
  [2101] = 1716,
  [2102] = 1720,
  [2103] = 166,
  [2104] = 1538,
  [2105] = 1539,
  [2106] = 172,
  [2107] = 1778,
  [2108] = 1540,
  [2109] = 1723,
  [2110] = 1725,
  [2111] = 1726,
  [2112] = 1727,
  [2113] = 1682,
  [2114] = 1729,
  [2115] = 1797,
  [2116] = 1534,
  [2117] = 1533,
  [2118] = 2118,
  [2119] = 1731,
  [2120] = 1532,
  [2121] = 2121,
  [2122] = 1730,
  [2123] = 2123,
  [2124] = 2124,
  [2125] = 1631,
  [2126] = 1632,
  [2127] = 1531,
  [2128] = 2128,
  [2129] = 1530,
  [2130] = 1528,
  [2131] = 167,
  [2132] = 164,
  [2133] = 2133,
  [2134] = 1541,
  [2135] = 1543,
  [2136] = 1544,
  [2137] = 1545,
  [2138] = 184,
  [2139] = 189,
  [2140] = 2140,
  [2141] = 1547,
  [2142] = 1718,
  [2143] = 181,
  [2144] = 168,
  [2145] = 1861,
  [2146] = 2146,
  [2147] = 2021,
  [2148] = 1563,
  [2149] = 1777,
  [2150] = 2121,
  [2151] = 1776,
  [2152] = 1808,
  [2153] = 1809,
  [2154] = 1775,
  [2155] = 1807,
  [2156] = 1753,
  [2157] = 1774,
  [2158] = 1685,
  [2159] = 1631,
  [2160] = 1525,
  [2161] = 1524,
  [2162] = 1523,
  [2163] = 1632,
  [2164] = 1516,
  [2165] = 1805,
  [2166] = 1804,
  [2167] = 1781,
  [2168] = 1803,
  [2169] = 1513,
  [2170] = 1580,
  [2171] = 1710,
  [2172] = 1529,
  [2173] = 1679,
  [2174] = 2174,
  [2175] = 1678,
  [2176] = 1750,
  [2177] = 2121,
  [2178] = 1768,
  [2179] = 1767,
  [2180] = 1749,
  [2181] = 1750,
  [2182] = 1784,
  [2183] = 2121,
  [2184] = 1766,
  [2185] = 1765,
  [2186] = 1764,
  [2187] = 1107,
  [2188] = 1763,
  [2189] = 1535,
  [2190] = 2190,
  [2191] = 168,
  [2192] = 2192,
  [2193] = 2193,
  [2194] = 2193,
  [2195] = 1785,
  [2196] = 174,
  [2197] = 2121,
  [2198] = 1740,
  [2199] = 1741,
  [2200] = 1687,
  [2201] = 1742,
  [2202] = 1688,
  [2203] = 1714,
  [2204] = 182,
  [2205] = 1801,
  [2206] = 2121,
  [2207] = 1690,
  [2208] = 2021,
  [2209] = 1758,
  [2210] = 1751,
  [2211] = 171,
  [2212] = 162,
  [2213] = 1719,
  [2214] = 169,
  [2215] = 166,
  [2216] = 1645,
  [2217] = 172,
  [2218] = 1634,
  [2219] = 1761,
  [2220] = 1750,
  [2221] = 1882,
  [2222] = 1633,
  [2223] = 1629,
  [2224] = 1628,
  [2225] = 2174,
  [2226] = 1634,
  [2227] = 1633,
  [2228] = 1629,
  [2229] = 1628,
  [2230] = 2230,
  [2231] = 1718,
  [2232] = 1754,
  [2233] = 2233,
  [2234] = 2121,
  [2235] = 167,
  [2236] = 1752,
  [2237] = 1563,
  [2238] = 2238,
  [2239] = 162,
  [2240] = 171,
  [2241] = 182,
  [2242] = 174,
  [2243] = 2121,
  [2244] = 2244,
  [2245] = 1529,
  [2246] = 1634,
  [2247] = 1812,
  [2248] = 169,
  [2249] = 1633,
  [2250] = 1629,
  [2251] = 1628,
  [2252] = 164,
  [2253] = 1811,
  [2254] = 184,
  [2255] = 189,
  [2256] = 181,
  [2257] = 1547,
  [2258] = 1545,
  [2259] = 1544,
  [2260] = 1543,
  [2261] = 1580,
  [2262] = 1541,
  [2263] = 1513,
  [2264] = 1540,
  [2265] = 1680,
  [2266] = 1539,
  [2267] = 1538,
  [2268] = 1516,
  [2269] = 1523,
  [2270] = 1676,
  [2271] = 2271,
  [2272] = 1718,
  [2273] = 2273,
  [2274] = 2121,
  [2275] = 1524,
  [2276] = 1537,
  [2277] = 1536,
  [2278] = 1746,
  [2279] = 1529,
  [2280] = 1547,
  [2281] = 1580,
  [2282] = 1513,
  [2283] = 1516,
  [2284] = 1535,
  [2285] = 1523,
  [2286] = 1524,
  [2287] = 2244,
  [2288] = 1545,
  [2289] = 1534,
  [2290] = 1525,
  [2291] = 1528,
  [2292] = 1544,
  [2293] = 1543,
  [2294] = 1533,
  [2295] = 1532,
  [2296] = 1531,
  [2297] = 1530,
  [2298] = 1528,
  [2299] = 1541,
  [2300] = 1540,
  [2301] = 1525,
  [2302] = 1530,
  [2303] = 1531,
  [2304] = 1532,
  [2305] = 1533,
  [2306] = 1534,
  [2307] = 1539,
  [2308] = 1535,
  [2309] = 1536,
  [2310] = 1538,
  [2311] = 1537,
  [2312] = 1533,
  [2313] = 1531,
  [2314] = 1544,
  [2315] = 1543,
  [2316] = 1861,
  [2317] = 2317,
  [2318] = 2318,
  [2319] = 1861,
  [2320] = 2320,
  [2321] = 2321,
  [2322] = 1718,
  [2323] = 186,
  [2324] = 2324,
  [2325] = 187,
  [2326] = 2326,
  [2327] = 1645,
  [2328] = 2328,
  [2329] = 2329,
  [2330] = 2330,
  [2331] = 1750,
  [2332] = 2332,
  [2333] = 1634,
  [2334] = 1682,
  [2335] = 2335,
  [2336] = 2336,
  [2337] = 1563,
  [2338] = 2338,
  [2339] = 2339,
  [2340] = 2340,
  [2341] = 2341,
  [2342] = 2342,
  [2343] = 1797,
  [2344] = 1861,
  [2345] = 2345,
  [2346] = 2346,
  [2347] = 2347,
  [2348] = 2021,
  [2349] = 1524,
  [2350] = 2350,
  [2351] = 1525,
  [2352] = 1516,
  [2353] = 1633,
  [2354] = 1629,
  [2355] = 1528,
  [2356] = 1547,
  [2357] = 1513,
  [2358] = 651,
  [2359] = 1545,
  [2360] = 2360,
  [2361] = 2361,
  [2362] = 1710,
  [2363] = 1580,
  [2364] = 2364,
  [2365] = 1628,
  [2366] = 1530,
  [2367] = 2367,
  [2368] = 2368,
  [2369] = 1861,
  [2370] = 1883,
  [2371] = 1529,
  [2372] = 1532,
  [2373] = 1710,
  [2374] = 2338,
  [2375] = 1682,
  [2376] = 1133,
  [2377] = 1534,
  [2378] = 1523,
  [2379] = 1730,
  [2380] = 2380,
  [2381] = 1631,
  [2382] = 1632,
  [2383] = 2383,
  [2384] = 1541,
  [2385] = 2385,
  [2386] = 1540,
  [2387] = 2387,
  [2388] = 2388,
  [2389] = 2389,
  [2390] = 1535,
  [2391] = 2391,
  [2392] = 1536,
  [2393] = 1537,
  [2394] = 1538,
  [2395] = 2395,
  [2396] = 1539,
  [2397] = 2397,
  [2398] = 2398,
  [2399] = 1596,
  [2400] = 1549,
  [2401] = 2401,
  [2402] = 1542,
  [2403] = 1718,
  [2404] = 2404,
  [2405] = 1750,
  [2406] = 2406,
  [2407] = 1563,
  [2408] = 2408,
  [2409] = 1511,
  [2410] = 2410,
  [2411] = 1542,
  [2412] = 163,
  [2413] = 1574,
  [2414] = 2414,
  [2415] = 2415,
  [2416] = 2416,
  [2417] = 1861,
  [2418] = 2418,
  [2419] = 1569,
  [2420] = 161,
  [2421] = 2421,
  [2422] = 1546,
  [2423] = 1548,
  [2424] = 1549,
  [2425] = 2406,
  [2426] = 2426,
  [2427] = 1546,
  [2428] = 1710,
  [2429] = 1828,
  [2430] = 2397,
  [2431] = 2431,
  [2432] = 1548,
  [2433] = 2433,
  [2434] = 1564,
  [2435] = 2397,
  [2436] = 2436,
  [2437] = 2437,
  [2438] = 2438,
  [2439] = 2439,
  [2440] = 2440,
  [2441] = 1710,
  [2442] = 2442,
  [2443] = 2443,
  [2444] = 1129,
  [2445] = 1730,
  [2446] = 151,
  [2447] = 2021,
  [2448] = 1122,
  [2449] = 1797,
  [2450] = 2450,
  [2451] = 675,
  [2452] = 2450,
  [2453] = 2442,
  [2454] = 2450,
  [2455] = 2455,
  [2456] = 2456,
  [2457] = 2457,
  [2458] = 2457,
  [2459] = 2455,
  [2460] = 175,
  [2461] = 1563,
  [2462] = 1563,
  [2463] = 2463,
  [2464] = 1682,
  [2465] = 2465,
  [2466] = 2466,
  [2467] = 1563,
  [2468] = 2457,
  [2469] = 2456,
  [2470] = 1124,
  [2471] = 1126,
  [2472] = 2455,
  [2473] = 2456,
  [2474] = 2442,
  [2475] = 1120,
  [2476] = 2476,
  [2477] = 2128,
  [2478] = 2478,
  [2479] = 696,
  [2480] = 2480,
  [2481] = 678,
  [2482] = 2482,
  [2483] = 2483,
  [2484] = 2484,
  [2485] = 2485,
  [2486] = 149,
  [2487] = 2487,
  [2488] = 2488,
  [2489] = 680,
  [2490] = 2490,
  [2491] = 2491,
  [2492] = 2492,
  [2493] = 2493,
  [2494] = 692,
  [2495] = 2495,
  [2496] = 2496,
  [2497] = 2497,
  [2498] = 686,
  [2499] = 1522,
  [2500] = 2500,
  [2501] = 2501,
  [2502] = 2502,
  [2503] = 700,
  [2504] = 688,
  [2505] = 2505,
  [2506] = 687,
  [2507] = 731,
  [2508] = 818,
  [2509] = 2509,
  [2510] = 682,
  [2511] = 2511,
  [2512] = 2512,
  [2513] = 744,
  [2514] = 2514,
  [2515] = 2515,
  [2516] = 809,
  [2517] = 2517,
  [2518] = 2518,
  [2519] = 689,
  [2520] = 2520,
  [2521] = 2521,
  [2522] = 2522,
  [2523] = 2512,
  [2524] = 2524,
  [2525] = 2518,
  [2526] = 2526,
  [2527] = 690,
  [2528] = 2528,
  [2529] = 812,
  [2530] = 813,
  [2531] = 2531,
  [2532] = 720,
  [2533] = 721,
  [2534] = 2528,
  [2535] = 2535,
  [2536] = 2536,
  [2537] = 703,
  [2538] = 683,
  [2539] = 2539,
  [2540] = 170,
  [2541] = 679,
  [2542] = 2542,
  [2543] = 173,
  [2544] = 2544,
  [2545] = 2545,
  [2546] = 2546,
  [2547] = 2522,
  [2548] = 2548,
  [2549] = 701,
  [2550] = 676,
  [2551] = 737,
  [2552] = 702,
  [2553] = 736,
  [2554] = 738,
  [2555] = 727,
  [2556] = 699,
  [2557] = 2557,
  [2558] = 716,
  [2559] = 715,
  [2560] = 2560,
  [2561] = 2521,
  [2562] = 2531,
  [2563] = 714,
  [2564] = 2564,
  [2565] = 2565,
  [2566] = 820,
  [2567] = 821,
  [2568] = 803,
  [2569] = 807,
  [2570] = 704,
  [2571] = 825,
  [2572] = 839,
  [2573] = 835,
  [2574] = 822,
  [2575] = 811,
  [2576] = 795,
  [2577] = 792,
  [2578] = 793,
  [2579] = 776,
  [2580] = 726,
  [2581] = 173,
  [2582] = 851,
  [2583] = 708,
  [2584] = 712,
  [2585] = 706,
  [2586] = 774,
  [2587] = 739,
  [2588] = 845,
  [2589] = 746,
  [2590] = 789,
  [2591] = 2591,
  [2592] = 826,
  [2593] = 844,
  [2594] = 843,
  [2595] = 837,
  [2596] = 816,
  [2597] = 815,
  [2598] = 814,
  [2599] = 788,
  [2600] = 786,
  [2601] = 785,
  [2602] = 608,
  [2603] = 705,
  [2604] = 784,
  [2605] = 796,
  [2606] = 794,
  [2607] = 782,
  [2608] = 781,
  [2609] = 780,
  [2610] = 779,
  [2611] = 790,
  [2612] = 722,
  [2613] = 732,
  [2614] = 778,
  [2615] = 777,
  [2616] = 170,
  [2617] = 775,
  [2618] = 772,
  [2619] = 178,
  [2620] = 770,
  [2621] = 768,
  [2622] = 767,
  [2623] = 766,
  [2624] = 765,
  [2625] = 733,
  [2626] = 846,
  [2627] = 760,
  [2628] = 745,
  [2629] = 800,
  [2630] = 185,
  [2631] = 805,
  [2632] = 840,
  [2633] = 808,
  [2634] = 817,
  [2635] = 801,
  [2636] = 764,
  [2637] = 823,
  [2638] = 824,
  [2639] = 783,
  [2640] = 743,
  [2641] = 830,
  [2642] = 742,
  [2643] = 741,
  [2644] = 740,
  [2645] = 761,
  [2646] = 758,
  [2647] = 723,
  [2648] = 834,
  [2649] = 757,
  [2650] = 748,
  [2651] = 773,
  [2652] = 836,
  [2653] = 842,
  [2654] = 849,
  [2655] = 850,
  [2656] = 848,
  [2657] = 729,
  [2658] = 734,
  [2659] = 755,
  [2660] = 747,
  [2661] = 847,
  [2662] = 763,
  [2663] = 711,
  [2664] = 841,
  [2665] = 735,
  [2666] = 838,
  [2667] = 833,
  [2668] = 724,
  [2669] = 832,
  [2670] = 831,
  [2671] = 610,
  [2672] = 829,
  [2673] = 828,
  [2674] = 749,
  [2675] = 751,
  [2676] = 756,
  [2677] = 827,
  [2678] = 709,
  [2679] = 806,
  [2680] = 804,
  [2681] = 797,
  [2682] = 719,
  [2683] = 717,
  [2684] = 609,
  [2685] = 730,
  [2686] = 787,
  [2687] = 759,
  [2688] = 728,
  [2689] = 725,
  [2690] = 798,
  [2691] = 707,
  [2692] = 713,
  [2693] = 612,
  [2694] = 799,
  [2695] = 613,
  [2696] = 762,
  [2697] = 771,
  [2698] = 769,
  [2699] = 754,
  [2700] = 753,
  [2701] = 752,
  [2702] = 750,
  [2703] = 2703,
  [2704] = 2704,
  [2705] = 2705,
  [2706] = 2706,
  [2707] = 2707,
  [2708] = 2705,
  [2709] = 2709,
  [2710] = 2710,
  [2711] = 2711,
  [2712] = 2712,
  [2713] = 2713,
  [2714] = 2714,
  [2715] = 2715,
  [2716] = 2705,
  [2717] = 2717,
  [2718] = 2706,
  [2719] = 2719,
  [2720] = 2720,
  [2721] = 2721,
  [2722] = 2722,
  [2723] = 2723,
  [2724] = 2724,
  [2725] = 2725,
  [2726] = 2726,
  [2727] = 2727,
  [2728] = 2728,
  [2729] = 2729,
  [2730] = 2730,
  [2731] = 2731,
  [2732] = 2732,
  [2733] = 2733,
  [2734] = 2705,
  [2735] = 2735,
  [2736] = 2736,
  [2737] = 2737,
  [2738] = 2706,
  [2739] = 2706,
  [2740] = 2740,
  [2741] = 2741,
  [2742] = 2742,
  [2743] = 2743,
  [2744] = 2744,
  [2745] = 2745,
  [2746] = 2746,
  [2747] = 2747,
  [2748] = 2748,
  [2749] = 2749,
  [2750] = 2750,
  [2751] = 2751,
  [2752] = 2752,
  [2753] = 2753,
  [2754] = 2754,
  [2755] = 2755,
  [2756] = 2756,
  [2757] = 2757,
  [2758] = 2758,
  [2759] = 2759,
  [2760] = 2760,
  [2761] = 2761,
  [2762] = 2762,
  [2763] = 2763,
  [2764] = 2764,
  [2765] = 2765,
  [2766] = 2766,
  [2767] = 2767,
  [2768] = 2768,
  [2769] = 2769,
  [2770] = 2770,
  [2771] = 2771,
  [2772] = 2772,
  [2773] = 2773,
  [2774] = 2774,
  [2775] = 2775,
  [2776] = 2776,
  [2777] = 2777,
  [2778] = 2778,
  [2779] = 2779,
  [2780] = 2780,
  [2781] = 2781,
  [2782] = 2782,
  [2783] = 2783,
  [2784] = 2784,
  [2785] = 2785,
  [2786] = 2786,
  [2787] = 2787,
  [2788] = 1496,
  [2789] = 1473,
  [2790] = 1472,
  [2791] = 1659,
  [2792] = 1605,
  [2793] = 1650,
  [2794] = 1586,
  [2795] = 176,
  [2796] = 1619,
  [2797] = 1607,
  [2798] = 1608,
  [2799] = 1649,
  [2800] = 1620,
  [2801] = 1618,
  [2802] = 1609,
  [2803] = 1610,
  [2804] = 1613,
  [2805] = 1624,
  [2806] = 1622,
  [2807] = 1655,
  [2808] = 1667,
  [2809] = 1665,
  [2810] = 1666,
  [2811] = 1585,
  [2812] = 1646,
  [2813] = 1652,
  [2814] = 1602,
  [2815] = 1653,
  [2816] = 1654,
  [2817] = 1621,
  [2818] = 1668,
  [2819] = 1648,
  [2820] = 1625,
  [2821] = 1435,
  [2822] = 1604,
  [2823] = 1658,
  [2824] = 177,
  [2825] = 1635,
  [2826] = 1627,
  [2827] = 1626,
  [2828] = 1630,
  [2829] = 1612,
  [2830] = 1606,
  [2831] = 1465,
  [2832] = 1514,
  [2833] = 1124,
  [2834] = 1120,
  [2835] = 1126,
  [2836] = 1450,
  [2837] = 1456,
  [2838] = 1616,
  [2839] = 1520,
  [2840] = 1519,
  [2841] = 1588,
  [2842] = 2842,
  [2843] = 1589,
  [2844] = 1583,
  [2845] = 1591,
  [2846] = 1592,
  [2847] = 1593,
  [2848] = 1640,
  [2849] = 1595,
  [2850] = 1641,
  [2851] = 1660,
  [2852] = 1656,
  [2853] = 1643,
  [2854] = 1651,
  [2855] = 1598,
  [2856] = 2842,
  [2857] = 1600,
  [2858] = 2842,
  [2859] = 1435,
  [2860] = 1601,
  [2861] = 2842,
  [2862] = 1509,
  [2863] = 2842,
  [2864] = 1527,
  [2865] = 2842,
  [2866] = 2842,
  [2867] = 1638,
  [2868] = 1615,
  [2869] = 1526,
  [2870] = 1496,
  [2871] = 1473,
  [2872] = 1472,
  [2873] = 1637,
  [2874] = 1521,
  [2875] = 1617,
  [2876] = 2842,
  [2877] = 1508,
  [2878] = 2842,
  [2879] = 1512,
  [2880] = 1518,
  [2881] = 1636,
  [2882] = 1648,
  [2883] = 1590,
  [2884] = 1668,
  [2885] = 1665,
  [2886] = 1646,
  [2887] = 1618,
  [2888] = 1667,
  [2889] = 1659,
  [2890] = 1658,
  [2891] = 1666,
  [2892] = 1654,
  [2893] = 1653,
  [2894] = 1652,
  [2895] = 1635,
  [2896] = 1627,
  [2897] = 2897,
  [2898] = 1626,
  [2899] = 2899,
  [2900] = 2900,
  [2901] = 1465,
  [2902] = 1650,
  [2903] = 2903,
  [2904] = 1662,
  [2905] = 1661,
  [2906] = 1649,
  [2907] = 1625,
  [2908] = 2908,
  [2909] = 1624,
  [2910] = 1642,
  [2911] = 1655,
  [2912] = 2912,
  [2913] = 1639,
  [2914] = 1657,
  [2915] = 2900,
  [2916] = 2897,
  [2917] = 2899,
  [2918] = 2918,
  [2919] = 1594,
  [2920] = 1581,
  [2921] = 1610,
  [2922] = 2922,
  [2923] = 2923,
  [2924] = 2924,
  [2925] = 1619,
  [2926] = 2918,
  [2927] = 2899,
  [2928] = 2897,
  [2929] = 2900,
  [2930] = 1622,
  [2931] = 1613,
  [2932] = 2918,
  [2933] = 2918,
  [2934] = 2899,
  [2935] = 2897,
  [2936] = 2900,
  [2937] = 2937,
  [2938] = 1585,
  [2939] = 1621,
  [2940] = 1620,
  [2941] = 1586,
  [2942] = 2900,
  [2943] = 2897,
  [2944] = 2899,
  [2945] = 2918,
  [2946] = 1609,
  [2947] = 1602,
  [2948] = 1608,
  [2949] = 1607,
  [2950] = 1604,
  [2951] = 1605,
  [2952] = 2952,
  [2953] = 1435,
  [2954] = 1517,
  [2955] = 2955,
  [2956] = 2956,
  [2957] = 2957,
  [2958] = 2958,
  [2959] = 1514,
  [2960] = 1496,
  [2961] = 1473,
  [2962] = 1472,
  [2963] = 2963,
  [2964] = 2964,
  [2965] = 1120,
  [2966] = 2966,
  [2967] = 2963,
  [2968] = 2968,
  [2969] = 1126,
  [2970] = 2970,
  [2971] = 1606,
  [2972] = 2972,
  [2973] = 1630,
  [2974] = 1456,
  [2975] = 1124,
  [2976] = 2976,
  [2977] = 2963,
  [2978] = 1612,
  [2979] = 1465,
  [2980] = 1620,
  [2981] = 2981,
  [2982] = 2982,
  [2983] = 2983,
  [2984] = 2984,
  [2985] = 2985,
  [2986] = 2986,
  [2987] = 2987,
  [2988] = 2988,
  [2989] = 2989,
  [2990] = 2990,
  [2991] = 2991,
  [2992] = 2992,
  [2993] = 2993,
  [2994] = 1648,
  [2995] = 1649,
  [2996] = 1650,
  [2997] = 1508,
  [2998] = 1652,
  [2999] = 1653,
  [3000] = 1654,
  [3001] = 1658,
  [3002] = 2981,
  [3003] = 1509,
  [3004] = 1659,
  [3005] = 1667,
  [3006] = 1646,
  [3007] = 1655,
  [3008] = 1665,
  [3009] = 3009,
  [3010] = 2981,
  [3011] = 1450,
  [3012] = 3012,
  [3013] = 1666,
  [3014] = 1668,
  [3015] = 1635,
  [3016] = 3016,
  [3017] = 1627,
  [3018] = 1626,
  [3019] = 3019,
  [3020] = 1585,
  [3021] = 1586,
  [3022] = 1602,
  [3023] = 1604,
  [3024] = 1605,
  [3025] = 1625,
  [3026] = 1624,
  [3027] = 1607,
  [3028] = 1608,
  [3029] = 1609,
  [3030] = 2981,
  [3031] = 1610,
  [3032] = 1613,
  [3033] = 1618,
  [3034] = 2981,
  [3035] = 1619,
  [3036] = 1622,
  [3037] = 3037,
  [3038] = 2981,
  [3039] = 3039,
  [3040] = 1621,
  [3041] = 899,
  [3042] = 1637,
  [3043] = 1583,
  [3044] = 3044,
  [3045] = 1598,
  [3046] = 1657,
  [3047] = 1662,
  [3048] = 1595,
  [3049] = 1124,
  [3050] = 1601,
  [3051] = 1594,
  [3052] = 1593,
  [3053] = 1527,
  [3054] = 1592,
  [3055] = 1643,
  [3056] = 1456,
  [3057] = 1591,
  [3058] = 1590,
  [3059] = 1660,
  [3060] = 613,
  [3061] = 1636,
  [3062] = 1517,
  [3063] = 1642,
  [3064] = 1641,
  [3065] = 883,
  [3066] = 1526,
  [3067] = 1640,
  [3068] = 1521,
  [3069] = 612,
  [3070] = 1600,
  [3071] = 609,
  [3072] = 1514,
  [3073] = 1639,
  [3074] = 1512,
  [3075] = 1517,
  [3076] = 1589,
  [3077] = 1126,
  [3078] = 1656,
  [3079] = 1661,
  [3080] = 1638,
  [3081] = 1606,
  [3082] = 1612,
  [3083] = 1630,
  [3084] = 1520,
  [3085] = 1651,
  [3086] = 1519,
  [3087] = 1615,
  [3088] = 1581,
  [3089] = 1518,
  [3090] = 610,
  [3091] = 1120,
  [3092] = 1616,
  [3093] = 1617,
  [3094] = 1588,
  [3095] = 608,
  [3096] = 907,
  [3097] = 3097,
  [3098] = 3098,
  [3099] = 3099,
  [3100] = 3100,
  [3101] = 3101,
  [3102] = 1435,
  [3103] = 3103,
  [3104] = 3104,
  [3105] = 3105,
  [3106] = 1508,
  [3107] = 1509,
  [3108] = 3108,
  [3109] = 3109,
  [3110] = 3110,
  [3111] = 3104,
  [3112] = 3105,
  [3113] = 3108,
  [3114] = 3105,
  [3115] = 3104,
  [3116] = 3116,
  [3117] = 3116,
  [3118] = 3099,
  [3119] = 3119,
  [3120] = 3104,
  [3121] = 3105,
  [3122] = 3122,
  [3123] = 1450,
  [3124] = 3124,
  [3125] = 3125,
  [3126] = 3125,
  [3127] = 1592,
  [3128] = 3128,
  [3129] = 3129,
  [3130] = 612,
  [3131] = 1591,
  [3132] = 1590,
  [3133] = 1589,
  [3134] = 1588,
  [3135] = 610,
  [3136] = 3136,
  [3137] = 3125,
  [3138] = 1518,
  [3139] = 1519,
  [3140] = 1520,
  [3141] = 3141,
  [3142] = 1521,
  [3143] = 1512,
  [3144] = 1651,
  [3145] = 1526,
  [3146] = 883,
  [3147] = 1656,
  [3148] = 1657,
  [3149] = 1660,
  [3150] = 1661,
  [3151] = 1662,
  [3152] = 613,
  [3153] = 3153,
  [3154] = 1527,
  [3155] = 3155,
  [3156] = 3124,
  [3157] = 3155,
  [3158] = 3158,
  [3159] = 3155,
  [3160] = 3125,
  [3161] = 1617,
  [3162] = 1616,
  [3163] = 1615,
  [3164] = 2981,
  [3165] = 608,
  [3166] = 3166,
  [3167] = 3158,
  [3168] = 3098,
  [3169] = 3169,
  [3170] = 1593,
  [3171] = 3169,
  [3172] = 1594,
  [3173] = 3173,
  [3174] = 3153,
  [3175] = 3175,
  [3176] = 1583,
  [3177] = 3128,
  [3178] = 1581,
  [3179] = 3169,
  [3180] = 3158,
  [3181] = 1643,
  [3182] = 1595,
  [3183] = 1642,
  [3184] = 2981,
  [3185] = 1641,
  [3186] = 3186,
  [3187] = 3128,
  [3188] = 2981,
  [3189] = 3128,
  [3190] = 899,
  [3191] = 2981,
  [3192] = 1598,
  [3193] = 3193,
  [3194] = 3194,
  [3195] = 1640,
  [3196] = 2981,
  [3197] = 907,
  [3198] = 2981,
  [3199] = 3153,
  [3200] = 3200,
  [3201] = 3201,
  [3202] = 3202,
  [3203] = 1600,
  [3204] = 1639,
  [3205] = 3101,
  [3206] = 2981,
  [3207] = 1638,
  [3208] = 1601,
  [3209] = 899,
  [3210] = 3210,
  [3211] = 175,
  [3212] = 1637,
  [3213] = 883,
  [3214] = 3200,
  [3215] = 1465,
  [3216] = 3216,
  [3217] = 176,
  [3218] = 177,
  [3219] = 1636,
  [3220] = 3220,
  [3221] = 3122,
  [3222] = 609,
  [3223] = 907,
  [3224] = 151,
  [3225] = 3225,
  [3226] = 3225,
  [3227] = 3225,
  [3228] = 3228,
  [3229] = 3229,
  [3230] = 3225,
  [3231] = 3229,
  [3232] = 3225,
  [3233] = 3233,
  [3234] = 3225,
  [3235] = 3101,
  [3236] = 1456,
  [3237] = 3237,
  [3238] = 3229,
  [3239] = 3239,
  [3240] = 3225,
  [3241] = 3225,
  [3242] = 3242,
  [3243] = 3243,
  [3244] = 3244,
  [3245] = 3245,
  [3246] = 3246,
  [3247] = 3247,
  [3248] = 149,
  [3249] = 3202,
  [3250] = 3250,
  [3251] = 3251,
  [3252] = 3245,
  [3253] = 3253,
  [3254] = 3254,
  [3255] = 3255,
  [3256] = 3246,
  [3257] = 3257,
  [3258] = 3258,
  [3259] = 3251,
  [3260] = 3260,
  [3261] = 3261,
  [3262] = 3262,
  [3263] = 3263,
  [3264] = 3264,
  [3265] = 3265,
  [3266] = 3266,
  [3267] = 3243,
  [3268] = 3247,
  [3269] = 3269,
  [3270] = 3270,
  [3271] = 3243,
  [3272] = 3272,
  [3273] = 3273,
  [3274] = 3274,
  [3275] = 3245,
  [3276] = 3246,
  [3277] = 3277,
  [3278] = 3278,
  [3279] = 3279,
  [3280] = 3280,
  [3281] = 3281,
  [3282] = 3282,
  [3283] = 3280,
  [3284] = 3201,
  [3285] = 3285,
  [3286] = 3286,
  [3287] = 3264,
  [3288] = 3288,
  [3289] = 3289,
  [3290] = 3260,
  [3291] = 3291,
  [3292] = 3292,
  [3293] = 3141,
  [3294] = 3294,
  [3295] = 3295,
  [3296] = 3296,
  [3297] = 3297,
  [3298] = 3298,
  [3299] = 3263,
  [3300] = 3110,
  [3301] = 3301,
  [3302] = 3302,
  [3303] = 3097,
  [3304] = 3304,
  [3305] = 3305,
  [3306] = 3186,
  [3307] = 3307,
  [3308] = 3250,
  [3309] = 3242,
  [3310] = 3262,
  [3311] = 3136,
  [3312] = 3312,
  [3313] = 3313,
  [3314] = 3314,
  [3315] = 3315,
  [3316] = 3263,
  [3317] = 3317,
  [3318] = 3318,
  [3319] = 3319,
  [3320] = 3242,
  [3321] = 3246,
  [3322] = 3322,
  [3323] = 3315,
  [3324] = 3324,
  [3325] = 3325,
  [3326] = 1509,
  [3327] = 3245,
  [3328] = 1508,
  [3329] = 3329,
  [3330] = 3330,
  [3331] = 3315,
  [3332] = 3258,
  [3333] = 3333,
  [3334] = 3315,
  [3335] = 3322,
  [3336] = 3336,
  [3337] = 3337,
  [3338] = 3322,
  [3339] = 3339,
  [3340] = 3340,
  [3341] = 3341,
  [3342] = 3342,
  [3343] = 3343,
  [3344] = 3344,
  [3345] = 3345,
  [3346] = 3346,
  [3347] = 3250,
  [3348] = 3250,
  [3349] = 3349,
  [3350] = 3350,
  [3351] = 3346,
  [3352] = 3352,
  [3353] = 3353,
  [3354] = 1107,
  [3355] = 3352,
  [3356] = 3251,
  [3357] = 3353,
  [3358] = 3262,
  [3359] = 3263,
  [3360] = 3278,
  [3361] = 3247,
  [3362] = 3260,
  [3363] = 3296,
  [3364] = 3364,
  [3365] = 3365,
  [3366] = 3337,
  [3367] = 3340,
  [3368] = 3368,
  [3369] = 3369,
  [3370] = 3370,
  [3371] = 1642,
  [3372] = 3372,
  [3373] = 3373,
  [3374] = 3365,
  [3375] = 3375,
  [3376] = 3376,
  [3377] = 3377,
  [3378] = 3378,
  [3379] = 3330,
  [3380] = 3380,
  [3381] = 3380,
  [3382] = 3382,
  [3383] = 3333,
  [3384] = 3341,
  [3385] = 3370,
  [3386] = 3368,
  [3387] = 3378,
  [3388] = 3388,
  [3389] = 3369,
  [3390] = 3390,
  [3391] = 3391,
  [3392] = 3329,
  [3393] = 3393,
  [3394] = 3281,
  [3395] = 1590,
  [3396] = 1594,
  [3397] = 3286,
  [3398] = 3382,
  [3399] = 3399,
  [3400] = 3400,
  [3401] = 3377,
  [3402] = 1133,
  [3403] = 3098,
  [3404] = 3314,
  [3405] = 3405,
  [3406] = 3406,
  [3407] = 3407,
  [3408] = 3408,
  [3409] = 3409,
  [3410] = 3409,
  [3411] = 3407,
  [3412] = 3412,
  [3413] = 3413,
  [3414] = 3414,
  [3415] = 3415,
  [3416] = 3382,
  [3417] = 3417,
  [3418] = 3369,
  [3419] = 3419,
  [3420] = 3420,
  [3421] = 3421,
  [3422] = 3422,
  [3423] = 3376,
  [3424] = 3292,
  [3425] = 3425,
  [3426] = 3426,
  [3427] = 3365,
  [3428] = 3428,
  [3429] = 3376,
  [3430] = 3376,
  [3431] = 3370,
  [3432] = 3369,
  [3433] = 3272,
  [3434] = 1110,
  [3435] = 3343,
  [3436] = 3407,
  [3437] = 3336,
  [3438] = 3375,
  [3439] = 3291,
  [3440] = 3312,
  [3441] = 3441,
  [3442] = 3409,
  [3443] = 3443,
  [3444] = 3444,
  [3445] = 3253,
  [3446] = 3377,
  [3447] = 3377,
  [3448] = 3273,
  [3449] = 3254,
  [3450] = 3377,
  [3451] = 3451,
  [3452] = 3452,
  [3453] = 3453,
  [3454] = 3454,
  [3455] = 3382,
  [3456] = 3378,
  [3457] = 3307,
  [3458] = 3458,
  [3459] = 3370,
  [3460] = 3460,
  [3461] = 3342,
  [3462] = 3044,
  [3463] = 3463,
  [3464] = 3304,
  [3465] = 3465,
  [3466] = 3294,
  [3467] = 3467,
  [3468] = 3468,
  [3469] = 3469,
  [3470] = 3255,
  [3471] = 3257,
  [3472] = 3370,
  [3473] = 3473,
  [3474] = 3406,
  [3475] = 3475,
  [3476] = 3476,
  [3477] = 3477,
  [3478] = 3478,
  [3479] = 3122,
  [3480] = 3480,
  [3481] = 3481,
  [3482] = 3468,
  [3483] = 3409,
  [3484] = 3289,
  [3485] = 3485,
  [3486] = 3486,
  [3487] = 3487,
  [3488] = 3393,
  [3489] = 3489,
  [3490] = 3490,
  [3491] = 3463,
  [3492] = 3407,
  [3493] = 1581,
  [3494] = 3452,
  [3495] = 3376,
  [3496] = 3369,
  [3497] = 3382,
  [3498] = 3465,
  [3499] = 3417,
  [3500] = 3415,
  [3501] = 3378,
  [3502] = 3480,
  [3503] = 3377,
  [3504] = 3274,
  [3505] = 3382,
  [3506] = 1662,
  [3507] = 3378,
  [3508] = 3508,
  [3509] = 3509,
  [3510] = 1661,
  [3511] = 3370,
  [3512] = 3512,
  [3513] = 3425,
  [3514] = 1657,
  [3515] = 3515,
  [3516] = 3516,
  [3517] = 3370,
  [3518] = 3518,
  [3519] = 3369,
  [3520] = 177,
  [3521] = 176,
  [3522] = 3378,
  [3523] = 608,
  [3524] = 613,
  [3525] = 3525,
  [3526] = 612,
  [3527] = 3527,
  [3528] = 609,
  [3529] = 610,
  [3530] = 3377,
  [3531] = 3391,
  [3532] = 3417,
  [3533] = 3533,
  [3534] = 1639,
  [3535] = 3415,
  [3536] = 3288,
  [3537] = 3537,
  [3538] = 3372,
  [3539] = 3415,
  [3540] = 3382,
  [3541] = 3417,
  [3542] = 3378,
  [3543] = 3543,
  [3544] = 3285,
  [3545] = 3545,
  [3546] = 3546,
  [3547] = 3547,
  [3548] = 3548,
  [3549] = 3549,
  [3550] = 3550,
  [3551] = 3551,
  [3552] = 3552,
  [3553] = 3553,
  [3554] = 3554,
  [3555] = 3555,
  [3556] = 3556,
  [3557] = 3557,
  [3558] = 3558,
  [3559] = 3559,
  [3560] = 3560,
  [3561] = 3561,
  [3562] = 3562,
  [3563] = 3527,
  [3564] = 3564,
  [3565] = 3565,
  [3566] = 3566,
  [3567] = 3567,
  [3568] = 3525,
  [3569] = 3569,
  [3570] = 3570,
  [3571] = 3571,
  [3572] = 3572,
  [3573] = 3552,
  [3574] = 3570,
  [3575] = 724,
  [3576] = 3576,
  [3577] = 3577,
  [3578] = 3578,
  [3579] = 3579,
  [3580] = 3580,
  [3581] = 3581,
  [3582] = 3582,
  [3583] = 3583,
  [3584] = 751,
  [3585] = 3585,
  [3586] = 709,
  [3587] = 713,
  [3588] = 744,
  [3589] = 680,
  [3590] = 3590,
  [3591] = 844,
  [3592] = 837,
  [3593] = 3593,
  [3594] = 3572,
  [3595] = 3595,
  [3596] = 3583,
  [3597] = 814,
  [3598] = 3598,
  [3599] = 3599,
  [3600] = 3600,
  [3601] = 3601,
  [3602] = 3602,
  [3603] = 3603,
  [3604] = 3604,
  [3605] = 3605,
  [3606] = 734,
  [3607] = 3607,
  [3608] = 729,
  [3609] = 3609,
  [3610] = 717,
  [3611] = 3611,
  [3612] = 3612,
  [3613] = 728,
  [3614] = 3614,
  [3615] = 3615,
  [3616] = 690,
  [3617] = 748,
  [3618] = 3618,
  [3619] = 757,
  [3620] = 758,
  [3621] = 3621,
  [3622] = 3580,
  [3623] = 723,
  [3624] = 764,
  [3625] = 3625,
  [3626] = 707,
  [3627] = 3627,
  [3628] = 730,
  [3629] = 3629,
  [3630] = 3630,
  [3631] = 3599,
  [3632] = 688,
  [3633] = 3593,
  [3634] = 700,
  [3635] = 3635,
  [3636] = 3636,
  [3637] = 3569,
  [3638] = 3638,
  [3639] = 3569,
  [3640] = 3640,
  [3641] = 3641,
  [3642] = 3593,
  [3643] = 3643,
  [3644] = 3644,
  [3645] = 3645,
  [3646] = 3646,
  [3647] = 3647,
  [3648] = 3648,
  [3649] = 3649,
  [3650] = 3650,
  [3651] = 3651,
  [3652] = 689,
  [3653] = 3653,
  [3654] = 746,
  [3655] = 3655,
  [3656] = 773,
  [3657] = 3657,
  [3658] = 3658,
  [3659] = 3400,
  [3660] = 3660,
  [3661] = 3661,
  [3662] = 3662,
  [3663] = 3590,
  [3664] = 3598,
  [3665] = 3665,
  [3666] = 3279,
  [3667] = 3607,
  [3668] = 3668,
  [3669] = 3669,
  [3670] = 3670,
  [3671] = 3580,
  [3672] = 3672,
  [3673] = 3673,
  [3674] = 3674,
  [3675] = 3675,
  [3676] = 185,
  [3677] = 3677,
  [3678] = 790,
  [3679] = 796,
  [3680] = 3680,
  [3681] = 3681,
  [3682] = 3635,
  [3683] = 3683,
  [3684] = 3577,
  [3685] = 3685,
  [3686] = 3686,
  [3687] = 3687,
  [3688] = 3688,
  [3689] = 3689,
  [3690] = 3680,
  [3691] = 3598,
  [3692] = 3692,
  [3693] = 801,
  [3694] = 803,
  [3695] = 3590,
  [3696] = 754,
  [3697] = 178,
  [3698] = 3556,
  [3699] = 807,
  [3700] = 3700,
  [3701] = 3602,
  [3702] = 704,
  [3703] = 3703,
  [3704] = 825,
  [3705] = 839,
  [3706] = 835,
  [3707] = 3557,
  [3708] = 3545,
  [3709] = 3709,
  [3710] = 3604,
  [3711] = 3583,
  [3712] = 822,
  [3713] = 3713,
  [3714] = 3549,
  [3715] = 774,
  [3716] = 820,
  [3717] = 3572,
  [3718] = 3718,
  [3719] = 3719,
  [3720] = 3720,
  [3721] = 3564,
  [3722] = 3579,
  [3723] = 3602,
  [3724] = 3601,
  [3725] = 851,
  [3726] = 3579,
  [3727] = 3570,
  [3728] = 3728,
  [3729] = 3557,
  [3730] = 3556,
  [3731] = 3552,
  [3732] = 3553,
  [3733] = 3546,
  [3734] = 3669,
  [3735] = 3601,
  [3736] = 3736,
  [3737] = 3670,
  [3738] = 3569,
  [3739] = 3607,
  [3740] = 3740,
  [3741] = 706,
  [3742] = 3742,
  [3743] = 3670,
  [3744] = 721,
  [3745] = 3745,
  [3746] = 720,
  [3747] = 701,
  [3748] = 3677,
  [3749] = 3282,
  [3750] = 3305,
  [3751] = 3551,
  [3752] = 3443,
  [3753] = 3753,
  [3754] = 676,
  [3755] = 740,
  [3756] = 702,
  [3757] = 3602,
  [3758] = 3625,
  [3759] = 3759,
  [3760] = 3760,
  [3761] = 3572,
  [3762] = 776,
  [3763] = 3763,
  [3764] = 739,
  [3765] = 3765,
  [3766] = 3766,
  [3767] = 840,
  [3768] = 845,
  [3769] = 3769,
  [3770] = 3770,
  [3771] = 683,
  [3772] = 741,
  [3773] = 3773,
  [3774] = 3774,
  [3775] = 3775,
  [3776] = 3776,
  [3777] = 3777,
  [3778] = 687,
  [3779] = 742,
  [3780] = 743,
  [3781] = 3781,
  [3782] = 3551,
  [3783] = 736,
  [3784] = 3549,
  [3785] = 3785,
  [3786] = 3786,
  [3787] = 3753,
  [3788] = 3549,
  [3789] = 699,
  [3790] = 789,
  [3791] = 809,
  [3792] = 826,
  [3793] = 3793,
  [3794] = 3794,
  [3795] = 3552,
  [3796] = 3796,
  [3797] = 3797,
  [3798] = 3553,
  [3799] = 3799,
  [3800] = 714,
  [3801] = 3801,
  [3802] = 3802,
  [3803] = 3803,
  [3804] = 3668,
  [3805] = 753,
  [3806] = 805,
  [3807] = 722,
  [3808] = 3553,
  [3809] = 732,
  [3810] = 3810,
  [3811] = 733,
  [3812] = 3552,
  [3813] = 745,
  [3814] = 3814,
  [3815] = 760,
  [3816] = 800,
  [3817] = 3817,
  [3818] = 3818,
  [3819] = 3579,
  [3820] = 3570,
  [3821] = 3557,
  [3822] = 3556,
  [3823] = 3823,
  [3824] = 3824,
  [3825] = 3546,
  [3826] = 750,
  [3827] = 3601,
  [3828] = 3828,
  [3829] = 3829,
  [3830] = 3830,
  [3831] = 3567,
  [3832] = 3553,
  [3833] = 3669,
  [3834] = 808,
  [3835] = 3565,
  [3836] = 3670,
  [3837] = 3837,
  [3838] = 3838,
  [3839] = 3786,
  [3840] = 692,
  [3841] = 806,
  [3842] = 752,
  [3843] = 3843,
  [3844] = 3844,
  [3845] = 151,
  [3846] = 3740,
  [3847] = 3546,
  [3848] = 804,
  [3849] = 3849,
  [3850] = 3849,
  [3851] = 3851,
  [3852] = 3852,
  [3853] = 3853,
  [3854] = 3854,
  [3855] = 3855,
  [3856] = 3856,
  [3857] = 3857,
  [3858] = 3855,
  [3859] = 3855,
  [3860] = 3854,
  [3861] = 3861,
  [3862] = 3862,
  [3863] = 3863,
  [3864] = 3864,
  [3865] = 3854,
  [3866] = 3866,
  [3867] = 3867,
  [3868] = 3868,
  [3869] = 3869,
  [3870] = 3862,
  [3871] = 3871,
  [3872] = 3872,
  [3873] = 3873,
  [3874] = 3874,
  [3875] = 3875,
  [3876] = 3863,
  [3877] = 3877,
  [3878] = 3878,
  [3879] = 3879,
  [3880] = 3856,
  [3881] = 3851,
  [3882] = 3878,
  [3883] = 3852,
  [3884] = 3884,
  [3885] = 3863,
  [3886] = 3849,
  [3887] = 3866,
  [3888] = 3869,
  [3889] = 3874,
  [3890] = 3868,
  [3891] = 3891,
  [3892] = 3892,
  [3893] = 3893,
  [3894] = 3852,
  [3895] = 3895,
  [3896] = 3869,
  [3897] = 3868,
  [3898] = 149,
  [3899] = 3899,
  [3900] = 3891,
  [3901] = 3901,
  [3902] = 3902,
  [3903] = 3903,
  [3904] = 3904,
  [3905] = 3875,
  [3906] = 3862,
  [3907] = 3899,
  [3908] = 3908,
  [3909] = 3854,
  [3910] = 3856,
  [3911] = 3911,
  [3912] = 3852,
  [3913] = 3849,
  [3914] = 3869,
  [3915] = 3868,
  [3916] = 3862,
  [3917] = 3857,
  [3918] = 3918,
  [3919] = 3856,
  [3920] = 3920,
  [3921] = 3921,
  [3922] = 3871,
  [3923] = 3857,
  [3924] = 3879,
  [3925] = 3925,
  [3926] = 3852,
  [3927] = 3871,
  [3928] = 3849,
  [3929] = 3929,
  [3930] = 3930,
  [3931] = 3869,
  [3932] = 3932,
  [3933] = 3862,
  [3934] = 3856,
  [3935] = 3868,
  [3936] = 3936,
  [3937] = 3862,
  [3938] = 3884,
  [3939] = 3939,
  [3940] = 3893,
  [3941] = 3941,
  [3942] = 3942,
  [3943] = 3943,
  [3944] = 3944,
  [3945] = 3945,
  [3946] = 3946,
  [3947] = 3852,
  [3948] = 3849,
  [3949] = 3949,
  [3950] = 3950,
  [3951] = 3951,
  [3952] = 3868,
  [3953] = 3856,
  [3954] = 3954,
  [3955] = 3955,
  [3956] = 3956,
  [3957] = 3957,
  [3958] = 3899,
  [3959] = 3959,
  [3960] = 3960,
  [3961] = 3875,
  [3962] = 3962,
  [3963] = 3869,
  [3964] = 3871,
  [3965] = 3849,
  [3966] = 3966,
  [3967] = 3852,
  [3968] = 3968,
  [3969] = 3849,
  [3970] = 3852,
  [3971] = 3971,
  [3972] = 3871,
  [3973] = 3849,
  [3974] = 3884,
  [3975] = 3869,
  [3976] = 3976,
  [3977] = 3869,
  [3978] = 3978,
  [3979] = 3868,
  [3980] = 3868,
  [3981] = 3899,
  [3982] = 3868,
  [3983] = 3869,
  [3984] = 3884,
  [3985] = 3884,
  [3986] = 3871,
  [3987] = 3987,
  [3988] = 3893,
  [3989] = 3884,
  [3990] = 3879,
  [3991] = 3854,
  [3992] = 3992,
  [3993] = 3993,
  [3994] = 3852,
  [3995] = 3899,
  [3996] = 3996,
  [3997] = 3997,
  [3998] = 3998,
  [3999] = 3999,
  [4000] = 4000,
  [4001] = 4001,
  [4002] = 4002,
  [4003] = 4003,
  [4004] = 4004,
  [4005] = 4005,
  [4006] = 3281,
  [4007] = 4007,
  [4008] = 4008,
  [4009] = 4009,
  [4010] = 4010,
  [4011] = 4011,
  [4012] = 4012,
  [4013] = 4013,
  [4014] = 4014,
  [4015] = 4014,
  [4016] = 4013,
  [4017] = 4017,
  [4018] = 4018,
  [4019] = 4019,
  [4020] = 4020,
  [4021] = 4008,
  [4022] = 3341,
  [4023] = 4023,
  [4024] = 4024,
  [4025] = 3997,
  [4026] = 4026,
  [4027] = 4027,
  [4028] = 4028,
  [4029] = 4029,
  [4030] = 4030,
  [4031] = 4031,
  [4032] = 4032,
  [4033] = 4033,
  [4034] = 4034,
  [4035] = 4035,
  [4036] = 4036,
  [4037] = 4031,
  [4038] = 4038,
  [4039] = 4039,
  [4040] = 4040,
  [4041] = 4041,
  [4042] = 4042,
  [4043] = 4043,
  [4044] = 4044,
  [4045] = 4045,
  [4046] = 4046,
  [4047] = 4047,
  [4048] = 4048,
  [4049] = 4049,
  [4050] = 4050,
  [4051] = 4051,
  [4052] = 4034,
  [4053] = 4053,
  [4054] = 4054,
  [4055] = 4055,
  [4056] = 4056,
  [4057] = 4057,
  [4058] = 4058,
  [4059] = 4059,
  [4060] = 4060,
  [4061] = 4061,
  [4062] = 4062,
  [4063] = 4063,
  [4064] = 4064,
  [4065] = 4040,
  [4066] = 4066,
  [4067] = 4067,
  [4068] = 4068,
  [4069] = 4069,
  [4070] = 4070,
  [4071] = 4071,
  [4072] = 4033,
  [4073] = 4073,
  [4074] = 4074,
  [4075] = 4075,
  [4076] = 4076,
  [4077] = 4077,
  [4078] = 4078,
  [4079] = 4079,
  [4080] = 4080,
  [4081] = 4081,
  [4082] = 4035,
  [4083] = 4083,
  [4084] = 4084,
  [4085] = 4085,
  [4086] = 4086,
  [4087] = 4038,
  [4088] = 3272,
  [4089] = 4089,
  [4090] = 4090,
  [4091] = 4091,
  [4092] = 4092,
  [4093] = 4093,
  [4094] = 4094,
  [4095] = 4039,
  [4096] = 4096,
  [4097] = 4097,
  [4098] = 4032,
  [4099] = 4099,
  [4100] = 3296,
  [4101] = 4101,
  [4102] = 4102,
  [4103] = 4103,
  [4104] = 4104,
  [4105] = 4005,
  [4106] = 4051,
  [4107] = 4107,
  [4108] = 4049,
  [4109] = 4109,
  [4110] = 3638,
  [4111] = 4111,
  [4112] = 4101,
  [4113] = 4113,
  [4114] = 4114,
  [4115] = 4101,
  [4116] = 4032,
  [4117] = 4051,
  [4118] = 4094,
  [4119] = 3997,
  [4120] = 4120,
  [4121] = 4121,
  [4122] = 4075,
  [4123] = 4123,
  [4124] = 4084,
  [4125] = 4081,
  [4126] = 4036,
  [4127] = 4127,
  [4128] = 4032,
  [4129] = 4129,
  [4130] = 4039,
  [4131] = 4114,
  [4132] = 682,
  [4133] = 4133,
  [4134] = 4044,
  [4135] = 4135,
  [4136] = 4094,
  [4137] = 4137,
  [4138] = 3998,
  [4139] = 4139,
  [4140] = 4140,
  [4141] = 4141,
  [4142] = 4123,
  [4143] = 4143,
  [4144] = 4144,
  [4145] = 4040,
  [4146] = 3996,
  [4147] = 4081,
  [4148] = 4129,
  [4149] = 4149,
  [4150] = 3996,
  [4151] = 4005,
  [4152] = 4120,
  [4153] = 3342,
  [4154] = 4081,
  [4155] = 4084,
  [4156] = 4002,
  [4157] = 4157,
  [4158] = 4158,
  [4159] = 3999,
  [4160] = 4073,
  [4161] = 4161,
  [4162] = 4019,
  [4163] = 4163,
  [4164] = 3996,
  [4165] = 4079,
  [4166] = 4166,
  [4167] = 4167,
  [4168] = 1593,
  [4169] = 1601,
  [4170] = 4085,
  [4171] = 4047,
  [4172] = 4172,
  [4173] = 4050,
  [4174] = 4101,
  [4175] = 4032,
  [4176] = 4094,
  [4177] = 4177,
  [4178] = 4143,
  [4179] = 4179,
  [4180] = 3996,
  [4181] = 4149,
  [4182] = 4182,
  [4183] = 4183,
  [4184] = 4184,
  [4185] = 4185,
  [4186] = 4109,
  [4187] = 4187,
  [4188] = 4081,
  [4189] = 3566,
  [4190] = 4084,
  [4191] = 4191,
  [4192] = 4192,
  [4193] = 4094,
  [4194] = 4057,
  [4195] = 4195,
  [4196] = 4120,
  [4197] = 4197,
  [4198] = 4198,
  [4199] = 4084,
  [4200] = 4081,
  [4201] = 4084,
  [4202] = 4103,
  [4203] = 4203,
  [4204] = 4204,
  [4205] = 4157,
  [4206] = 4206,
  [4207] = 4090,
  [4208] = 4208,
  [4209] = 4209,
  [4210] = 4027,
  [4211] = 4030,
  [4212] = 4212,
  [4213] = 4213,
  [4214] = 4214,
  [4215] = 3336,
  [4216] = 4027,
  [4217] = 4030,
  [4218] = 4218,
  [4219] = 4047,
  [4220] = 4050,
  [4221] = 4221,
  [4222] = 4222,
  [4223] = 4223,
  [4224] = 4224,
  [4225] = 4209,
  [4226] = 4226,
  [4227] = 4227,
  [4228] = 3774,
  [4229] = 4229,
  [4230] = 4230,
  [4231] = 4057,
  [4232] = 4232,
  [4233] = 4233,
  [4234] = 4157,
  [4235] = 3996,
  [4236] = 4236,
  [4237] = 4046,
  [4238] = 4238,
  [4239] = 4239,
  [4240] = 4040,
  [4241] = 4049,
  [4242] = 4242,
  [4243] = 4243,
  [4244] = 4244,
  [4245] = 4004,
  [4246] = 4246,
  [4247] = 4247,
  [4248] = 4236,
  [4249] = 4249,
  [4250] = 4250,
  [4251] = 4251,
  [4252] = 4212,
  [4253] = 4208,
  [4254] = 4101,
  [4255] = 4238,
  [4256] = 4256,
  [4257] = 4032,
  [4258] = 4258,
  [4259] = 4094,
  [4260] = 4260,
  [4261] = 4229,
  [4262] = 4084,
  [4263] = 4081,
  [4264] = 4264,
  [4265] = 4238,
  [4266] = 4208,
  [4267] = 4212,
  [4268] = 4236,
  [4269] = 4269,
  [4270] = 4270,
  [4271] = 4040,
  [4272] = 4272,
  [4273] = 4073,
  [4274] = 3996,
  [4275] = 4275,
  [4276] = 4276,
  [4277] = 4277,
  [4278] = 2347,
  [4279] = 4279,
  [4280] = 4279,
  [4281] = 4281,
  [4282] = 4282,
  [4283] = 4283,
  [4284] = 2350,
  [4285] = 4285,
  [4286] = 4286,
  [4287] = 4287,
  [4288] = 4288,
  [4289] = 4281,
  [4290] = 4290,
  [4291] = 4291,
  [4292] = 4292,
  [4293] = 4283,
  [4294] = 4285,
  [4295] = 4295,
  [4296] = 4296,
  [4297] = 4297,
  [4298] = 4298,
  [4299] = 4299,
  [4300] = 4300,
  [4301] = 4301,
  [4302] = 4302,
  [4303] = 4303,
  [4304] = 4304,
  [4305] = 4279,
  [4306] = 4306,
  [4307] = 4307,
  [4308] = 4308,
  [4309] = 4309,
  [4310] = 4300,
  [4311] = 4311,
  [4312] = 4312,
  [4313] = 4313,
  [4314] = 4314,
  [4315] = 4315,
  [4316] = 4275,
  [4317] = 4304,
  [4318] = 4299,
  [4319] = 2342,
  [4320] = 4320,
  [4321] = 4321,
  [4322] = 4322,
  [4323] = 4309,
  [4324] = 4324,
  [4325] = 4325,
  [4326] = 4326,
  [4327] = 4327,
  [4328] = 4328,
  [4329] = 4329,
  [4330] = 4328,
  [4331] = 4331,
  [4332] = 4332,
  [4333] = 4285,
  [4334] = 4334,
  [4335] = 4335,
  [4336] = 4336,
  [4337] = 4337,
  [4338] = 4338,
  [4339] = 4339,
  [4340] = 2328,
  [4341] = 4341,
  [4342] = 4312,
  [4343] = 4343,
  [4344] = 4344,
  [4345] = 4345,
  [4346] = 4346,
  [4347] = 2368,
  [4348] = 2324,
  [4349] = 4349,
  [4350] = 4350,
  [4351] = 4304,
  [4352] = 4352,
  [4353] = 4353,
  [4354] = 4277,
  [4355] = 4355,
  [4356] = 4313,
  [4357] = 4357,
  [4358] = 4321,
  [4359] = 4359,
  [4360] = 4360,
  [4361] = 4361,
  [4362] = 4352,
  [4363] = 4363,
  [4364] = 4364,
  [4365] = 4365,
  [4366] = 4366,
  [4367] = 4367,
  [4368] = 4345,
  [4369] = 4297,
  [4370] = 860,
  [4371] = 4306,
  [4372] = 4325,
  [4373] = 4373,
  [4374] = 4374,
  [4375] = 4341,
  [4376] = 4376,
  [4377] = 4346,
  [4378] = 3443,
  [4379] = 4360,
  [4380] = 4341,
  [4381] = 4295,
  [4382] = 4382,
  [4383] = 2385,
  [4384] = 4315,
  [4385] = 4385,
  [4386] = 2387,
  [4387] = 4283,
  [4388] = 4388,
  [4389] = 4360,
  [4390] = 4363,
  [4391] = 2360,
  [4392] = 2364,
  [4393] = 4393,
  [4394] = 4394,
  [4395] = 4395,
  [4396] = 4396,
  [4397] = 4300,
  [4398] = 4398,
  [4399] = 2318,
  [4400] = 2326,
  [4401] = 4401,
  [4402] = 4331,
  [4403] = 4403,
  [4404] = 4327,
  [4405] = 4326,
  [4406] = 4281,
  [4407] = 4304,
  [4408] = 4308,
  [4409] = 4409,
  [4410] = 4285,
  [4411] = 4283,
  [4412] = 4281,
  [4413] = 4279,
  [4414] = 4414,
  [4415] = 4415,
  [4416] = 4303,
  [4417] = 4277,
  [4418] = 4418,
  [4419] = 4419,
  [4420] = 2335,
  [4421] = 4421,
  [4422] = 4329,
  [4423] = 4423,
  [4424] = 4332,
  [4425] = 4425,
  [4426] = 4426,
  [4427] = 4427,
  [4428] = 4275,
  [4429] = 4429,
  [4430] = 4430,
  [4431] = 4431,
  [4432] = 4432,
  [4433] = 4433,
  [4434] = 4335,
  [4435] = 4435,
  [4436] = 2746,
  [4437] = 4355,
  [4438] = 4298,
  [4439] = 3527,
  [4440] = 3978,
  [4441] = 4441,
  [4442] = 2340,
  [4443] = 4300,
  [4444] = 4444,
  [4445] = 4445,
  [4446] = 4446,
  [4447] = 4447,
  [4448] = 4301,
  [4449] = 2764,
  [4450] = 4450,
  [4451] = 4451,
  [4452] = 4452,
  [4453] = 4447,
  [4454] = 4450,
  [4455] = 4451,
  [4456] = 4396,
  [4457] = 4457,
  [4458] = 3525,
  [4459] = 4459,
  [4460] = 4460,
  [4461] = 4403,
  [4462] = 4462,
  [4463] = 4452,
  [4464] = 4409,
  [4465] = 4326,
  [4466] = 4466,
  [4467] = 4467,
  [4468] = 4468,
  [4469] = 4409,
  [4470] = 4470,
  [4471] = 4471,
  [4472] = 4472,
  [4473] = 4327,
  [4474] = 4474,
  [4475] = 4475,
  [4476] = 4367,
  [4477] = 4477,
  [4478] = 4409,
  [4479] = 4479,
  [4480] = 4396,
  [4481] = 4320,
  [4482] = 4324,
  [4483] = 4483,
  [4484] = 4403,
  [4485] = 2380,
  [4486] = 4335,
  [4487] = 4487,
  [4488] = 4488,
  [4489] = 4409,
  [4490] = 2391,
  [4491] = 4444,
  [4492] = 4350,
  [4493] = 4331,
  [4494] = 4337,
  [4495] = 4435,
  [4496] = 4298,
  [4497] = 4497,
  [4498] = 4364,
  [4499] = 4355,
  [4500] = 4425,
  [4501] = 4393,
  [4502] = 4502,
  [4503] = 4503,
  [4504] = 4504,
  [4505] = 4505,
  [4506] = 4353,
  [4507] = 4507,
  [4508] = 4508,
  [4509] = 4403,
  [4510] = 4510,
  [4511] = 4511,
  [4512] = 4401,
  [4513] = 4513,
  [4514] = 4376,
  [4515] = 4515,
  [4516] = 4302,
  [4517] = 4517,
  [4518] = 855,
  [4519] = 4519,
  [4520] = 2317,
  [4521] = 4521,
  [4522] = 2321,
  [4523] = 4401,
  [4524] = 4396,
  [4525] = 4366,
  [4526] = 4366,
  [4527] = 4527,
  [4528] = 4528,
  [4529] = 4529,
  [4530] = 4530,
  [4531] = 4531,
  [4532] = 4359,
  [4533] = 4511,
  [4534] = 4429,
  [4535] = 4357,
  [4536] = 4536,
  [4537] = 4537,
  [4538] = 4444,
  [4539] = 2329,
  [4540] = 4540,
  [4541] = 4403,
  [4542] = 4475,
  [4543] = 4540,
  [4544] = 4396,
  [4545] = 4497,
  [4546] = 4503,
  [4547] = 2395,
  [4548] = 4529,
  [4549] = 2484,
  [4550] = 4296,
  [4551] = 2483,
  [4552] = 2501,
  [4553] = 4497,
  [4554] = 2478,
  [4555] = 4423,
  [4556] = 4460,
  [4557] = 4459,
  [4558] = 4558,
  [4559] = 4559,
  [4560] = 4560,
  [4561] = 4561,
  [4562] = 4562,
  [4563] = 4296,
  [4564] = 4396,
  [4565] = 4565,
  [4566] = 4537,
  [4567] = 4507,
  [4568] = 4568,
  [4569] = 4432,
  [4570] = 4431,
  [4571] = 4537,
  [4572] = 4572,
  [4573] = 4363,
  [4574] = 4360,
  [4575] = 4575,
  [4576] = 4513,
  [4577] = 4403,
  [4578] = 4578,
  [4579] = 4346,
  [4580] = 4341,
  [4581] = 4581,
  [4582] = 4582,
  [4583] = 2332,
  [4584] = 4584,
  [4585] = 4585,
  [4586] = 4444,
  [4587] = 4306,
  [4588] = 4364,
  [4589] = 4511,
  [4590] = 4337,
  [4591] = 4409,
  [4592] = 2339,
  [4593] = 4297,
  [4594] = 4298,
  [4595] = 4466,
  [4596] = 3400,
  [4597] = 4314,
  [4598] = 4529,
  [4599] = 4298,
  [4600] = 4600,
  [4601] = 4601,
  [4602] = 4602,
  [4603] = 4603,
  [4604] = 4350,
  [4605] = 4605,
  [4606] = 4606,
  [4607] = 4607,
  [4608] = 4332,
  [4609] = 4329,
  [4610] = 4325,
  [4611] = 4611,
  [4612] = 4277,
  [4613] = 4427,
  [4614] = 4614,
  [4615] = 4615,
  [4616] = 4616,
  [4617] = 4299,
  [4618] = 4474,
  [4619] = 4331,
  [4620] = 4279,
  [4621] = 4328,
  [4622] = 4281,
  [4623] = 4327,
  [4624] = 4326,
  [4625] = 4283,
  [4626] = 4285,
  [4627] = 4446,
  [4628] = 4628,
  [4629] = 4315,
  [4630] = 4288,
  [4631] = 4479,
  [4632] = 4445,
  [4633] = 4423,
  [4634] = 4634,
  [4635] = 4635,
  [4636] = 4636,
  [4637] = 4637,
  [4638] = 4638,
  [4639] = 4639,
  [4640] = 4640,
  [4641] = 4635,
  [4642] = 4642,
  [4643] = 4643,
  [4644] = 4644,
  [4645] = 4645,
  [4646] = 4646,
  [4647] = 4647,
  [4648] = 4648,
  [4649] = 4636,
  [4650] = 4650,
  [4651] = 4651,
  [4652] = 4650,
  [4653] = 4653,
  [4654] = 4654,
  [4655] = 4655,
  [4656] = 4656,
  [4657] = 4657,
  [4658] = 4658,
  [4659] = 4659,
  [4660] = 4660,
  [4661] = 4642,
  [4662] = 4662,
  [4663] = 4663,
  [4664] = 4664,
  [4665] = 4634,
  [4666] = 4666,
  [4667] = 4667,
  [4668] = 4668,
  [4669] = 4669,
  [4670] = 4670,
  [4671] = 4671,
  [4672] = 4672,
  [4673] = 4673,
  [4674] = 4654,
  [4675] = 4675,
  [4676] = 4676,
  [4677] = 4671,
  [4678] = 4678,
  [4679] = 4672,
  [4680] = 4680,
  [4681] = 4681,
  [4682] = 4682,
  [4683] = 4683,
  [4684] = 4684,
  [4685] = 4685,
  [4686] = 4655,
  [4687] = 4656,
  [4688] = 4688,
  [4689] = 4689,
  [4690] = 4690,
  [4691] = 4691,
  [4692] = 4692,
  [4693] = 4693,
  [4694] = 4669,
  [4695] = 4695,
  [4696] = 4696,
  [4697] = 4697,
  [4698] = 4698,
  [4699] = 4699,
  [4700] = 4700,
  [4701] = 4701,
  [4702] = 4638,
  [4703] = 4647,
  [4704] = 4636,
  [4705] = 4675,
  [4706] = 4706,
  [4707] = 4646,
  [4708] = 4683,
  [4709] = 4688,
  [4710] = 4710,
  [4711] = 4711,
  [4712] = 4712,
  [4713] = 4668,
  [4714] = 4701,
  [4715] = 4715,
  [4716] = 4642,
  [4717] = 4675,
  [4718] = 4718,
  [4719] = 4697,
  [4720] = 4710,
  [4721] = 4721,
  [4722] = 4722,
  [4723] = 4692,
  [4724] = 4678,
  [4725] = 4690,
  [4726] = 4678,
  [4727] = 4648,
  [4728] = 4635,
  [4729] = 4729,
  [4730] = 4701,
  [4731] = 4664,
  [4732] = 4637,
  [4733] = 4664,
  [4734] = 4640,
  [4735] = 4735,
  [4736] = 4637,
  [4737] = 4640,
  [4738] = 4738,
  [4739] = 4712,
  [4740] = 4668,
  [4741] = 4738,
  [4742] = 4711,
  [4743] = 4743,
  [4744] = 4684,
  [4745] = 4684,
  [4746] = 4640,
  [4747] = 4700,
  [4748] = 4637,
  [4749] = 4636,
  [4750] = 4647,
  [4751] = 4638,
  [4752] = 4666,
  [4753] = 4706,
  [4754] = 4682,
  [4755] = 4699,
  [4756] = 4640,
  [4757] = 4680,
  [4758] = 4634,
  [4759] = 4666,
  [4760] = 4637,
  [4761] = 4761,
  [4762] = 4648,
  [4763] = 4690,
  [4764] = 4764,
  [4765] = 4765,
  [4766] = 4688,
  [4767] = 4698,
  [4768] = 4683,
  [4769] = 4769,
  [4770] = 4770,
  [4771] = 4669,
  [4772] = 4668,
  [4773] = 4658,
  [4774] = 4701,
  [4775] = 4659,
  [4776] = 4776,
  [4777] = 4706,
  [4778] = 4710,
  [4779] = 4664,
  [4780] = 4688,
  [4781] = 4683,
  [4782] = 4695,
  [4783] = 4783,
  [4784] = 4693,
  [4785] = 4691,
  [4786] = 4689,
  [4787] = 4683,
  [4788] = 4706,
  [4789] = 4634,
  [4790] = 4666,
  [4791] = 4791,
  [4792] = 4792,
  [4793] = 4636,
  [4794] = 4647,
  [4795] = 4638,
  [4796] = 4796,
  [4797] = 4638,
  [4798] = 4647,
  [4799] = 4799,
  [4800] = 4672,
  [4801] = 4671,
  [4802] = 4660,
  [4803] = 4638,
  [4804] = 4804,
  [4805] = 4805,
  [4806] = 4806,
  [4807] = 4807,
  [4808] = 4678,
  [4809] = 4663,
  [4810] = 4645,
  [4811] = 4634,
  [4812] = 4663,
  [4813] = 4813,
  [4814] = 4814,
  [4815] = 4815,
  [4816] = 4697,
  [4817] = 4817,
  [4818] = 4666,
  [4819] = 4682,
  [4820] = 4820,
  [4821] = 4821,
  [4822] = 4636,
  [4823] = 4647,
  [4824] = 4712,
  [4825] = 4648,
  [4826] = 4669,
  [4827] = 4668,
  [4828] = 4640,
  [4829] = 4738,
  [4830] = 4637,
  [4831] = 4662,
  [4832] = 4664,
  [4833] = 4833,
  [4834] = 4676,
  [4835] = 4692,
  [4836] = 4836,
  [4837] = 4764,
  [4838] = 4642,
  [4839] = 4636,
  [4840] = 4647,
  [4841] = 4638,
  [4842] = 4842,
  [4843] = 4843,
  [4844] = 4710,
  [4845] = 4711,
  [4846] = 4646,
  [4847] = 4700,
  [4848] = 4848,
  [4849] = 4799,
  [4850] = 4635,
  [4851] = 4699,
  [4852] = 4761,
  [4853] = 4729,
  [4854] = 1754,
  [4855] = 4698,
  [4856] = 4695,
  [4857] = 4693,
  [4858] = 4650,
  [4859] = 4806,
  [4860] = 4654,
  [4861] = 4861,
  [4862] = 4691,
  [4863] = 4863,
  [4864] = 4655,
  [4865] = 4689,
  [4866] = 4776,
  [4867] = 4656,
  [4868] = 4657,
  [4869] = 4869,
  [4870] = 4634,
  [4871] = 4871,
  [4872] = 4658,
  [4873] = 4696,
  [4874] = 4659,
  [4875] = 4820,
  [4876] = 4660,
  [4877] = 4670,
  [4878] = 4673,
  [4879] = 4675,
  [4880] = 4738,
  [4881] = 4881,
  [4882] = 4689,
  [4883] = 4691,
  [4884] = 4685,
  [4885] = 4695,
  [4886] = 4698,
  [4887] = 4738,
  [4888] = 4888,
  [4889] = 4699,
  [4890] = 4700,
  [4891] = 4646,
  [4892] = 4711,
  [4893] = 4712,
  [4894] = 4693,
  [4895] = 4640,
  [4896] = 4896,
  [4897] = 4861,
  [4898] = 4738,
  [4899] = 4899,
  [4900] = 4900,
  [4901] = 4675,
  [4902] = 4640,
  [4903] = 4817,
  [4904] = 4904,
  [4905] = 4673,
  [4906] = 4670,
  [4907] = 4660,
  [4908] = 4659,
  [4909] = 4658,
  [4910] = 4657,
  [4911] = 4670,
  [4912] = 4637,
  [4913] = 4656,
  [4914] = 4655,
  [4915] = 4680,
  [4916] = 4654,
  [4917] = 4639,
  [4918] = 4918,
  [4919] = 4648,
  [4920] = 4648,
  [4921] = 4921,
  [4922] = 4673,
  [4923] = 4650,
  [4924] = 4685,
  [4925] = 4925,
  [4926] = 4926,
  [4927] = 4927,
  [4928] = 4738,
  [4929] = 4929,
  [4930] = 4843,
  [4931] = 4710,
  [4932] = 4640,
  [4933] = 4688,
  [4934] = 4637,
  [4935] = 4636,
  [4936] = 4647,
  [4937] = 4638,
  [4938] = 4683,
  [4939] = 4706,
  [4940] = 4940,
  [4941] = 4941,
  [4942] = 4636,
  [4943] = 4943,
  [4944] = 4647,
  [4945] = 4945,
  [4946] = 4638,
  [4947] = 4712,
  [4948] = 4711,
  [4949] = 4949,
  [4950] = 4646,
  [4951] = 4700,
  [4952] = 4699,
  [4953] = 4698,
  [4954] = 4676,
  [4955] = 4764,
  [4956] = 4843,
  [4957] = 4695,
  [4958] = 4693,
  [4959] = 4691,
  [4960] = 4960,
  [4961] = 4689,
  [4962] = 4637,
  [4963] = 4761,
  [4964] = 4729,
  [4965] = 4675,
  [4966] = 4966,
  [4967] = 4806,
  [4968] = 4673,
  [4969] = 4861,
  [4970] = 4639,
  [4971] = 4896,
  [4972] = 4776,
  [4973] = 4670,
  [4974] = 4660,
  [4975] = 4659,
  [4976] = 4976,
  [4977] = 4658,
  [4978] = 4978,
  [4979] = 4657,
  [4980] = 4764,
  [4981] = 4656,
  [4982] = 4655,
  [4983] = 4654,
  [4984] = 4650,
  [4985] = 4668,
  [4986] = 4635,
  [4987] = 4642,
  [4988] = 4764,
  [4989] = 4989,
  [4990] = 4820,
  [4991] = 4662,
  [4992] = 4992,
  [4993] = 4764,
  [4994] = 4994,
  [4995] = 4918,
  [4996] = 4899,
  [4997] = 4997,
  [4998] = 4635,
  [4999] = 4869,
  [5000] = 4642,
  [5001] = 5001,
  [5002] = 4669,
  [5003] = 5003,
  [5004] = 4918,
  [5005] = 4899,
  [5006] = 4657,
  [5007] = 4664,
  [5008] = 4869,
  [5009] = 4899,
  [5010] = 5010,
  [5011] = 5011,
  [5012] = 5012,
};

static inline bool anon_sym_BANG_character_set_1(int32_t c) {
  return (c < 8192
    ? (c < ' '
      ? (c < '\r'
        ? (c >= '\t' && c <= '\n')
        : c <= '\r')
      : (c <= ' ' || (c < 5760
        ? c == 160
        : c <= 5760)))
    : (c <= 8203 || (c < 12288
      ? (c < 8287
        ? c == 8239
        : c <= 8288)
      : (c <= 12288 || c == 65279))));
}

static inline bool sym__glimmer_template_content_character_set_1(int32_t c) {
  return (c < 8192
    ? (c < ' '
      ? (c < '\r'
        ? c == '\t'
        : c <= '\r')
      : (c <= ' ' || (c < 5760
        ? c == 160
        : c <= 5760)))
    : (c <= 8203 || (c < 12288
      ? (c < 8287
        ? c == 8239
        : c <= 8288)
      : (c <= 12288 || c == 65279))));
}

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < 160
    ? (c < ':'
      ? (c < 0
        ? c == 0
        : (c <= '#' || (c >= '%' && c <= '/')))
      : (c <= '@' || (c < '`'
        ? (c >= '[' && c <= '^')
        : (c <= '`' || (c >= '{' && c <= '~')))))
    : (c <= 160 || (c < 8287
      ? (c < 8192
        ? c == 5760
        : (c <= 8203 || c == 8239))
      : (c <= 8288 || (c < 65279
        ? c == 12288
        : c <= 65279)))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < 160
    ? (c < ':'
      ? (c < 0
        ? c == 0
        : (c <= '#' || (c >= '%' && c <= '/')))
      : (c <= '@' || (c < '`'
        ? (c >= '[' && c <= '^')
        : c <= '~')))
    : (c <= 160 || (c < 8287
      ? (c < 8192
        ? c == 5760
        : (c <= 8203 || c == 8239))
      : (c <= 8288 || (c < 65279
        ? c == 12288
        : c <= 65279)))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < 160
    ? (c < ':'
      ? (c < 0
        ? c == 0
        : (c <= '#' || (c >= '%' && c <= '/')))
      : (c <= '@' || (c < '`'
        ? (c >= '[' && c <= '^')
        : (c <= '`' || (c >= '|' && c <= '~')))))
    : (c <= 160 || (c < 8287
      ? (c < 8192
        ? c == 5760
        : (c <= 8203 || c == 8239))
      : (c <= 8288 || (c < 65279
        ? c == 12288
        : c <= 65279)))));
}

static inline bool sym_private_property_identifier_character_set_1(int32_t c) {
  return (c < 160
    ? (c < '['
      ? (c < 0
        ? c == 0
        : (c <= '#' || (c >= '%' && c <= '@')))
      : (c <= '^' || (c < '{'
        ? c == '`'
        : c <= '~')))
    : (c <= 160 || (c < 8287
      ? (c < 8192
        ? c == 5760
        : (c <= 8203 || c == 8239))
      : (c <= 8288 || (c < 65279
        ? c == 12288
        : c <= 65279)))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(94);
      if (lookahead == '!') ADVANCE(107);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(10);
      if (lookahead == '$') ADVANCE(231);
      if (lookahead == '%') ADVANCE(181);
      if (lookahead == '&') ADVANCE(163);
      if (lookahead == '\'') ADVANCE(196);
      if (lookahead == '(') ADVANCE(108);
      if (lookahead == ')') ADVANCE(109);
      if (lookahead == '*') ADVANCE(97);
      if (lookahead == '+') ADVANCE(175);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(179);
      if (lookahead == '.') ADVANCE(132);
      if (lookahead == '/') ADVANCE(217);
      if (lookahead == '0') ADVANCE(222);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == ';') ADVANCE(110);
      if (lookahead == '<') ADVANCE(122);
      if (lookahead == '=') ADVANCE(100);
      if (lookahead == '>') ADVANCE(127);
      if (lookahead == '?') ADVANCE(237);
      if (lookahead == '@') ADVANCE(234);
      if (lookahead == '[') ADVANCE(112);
      if (lookahead == '\\') ADVANCE(53);
      if (lookahead == ']') ADVANCE(113);
      if (lookahead == '^') ADVANCE(166);
      if (lookahead == '`') ADVANCE(215);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '|') ADVANCE(169);
      if (lookahead == '}') ADVANCE(105);
      if (lookahead == '~') ADVANCE(192);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(223);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(92)
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(232);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(1)
      if (lookahead == '/') ADVANCE(115);
      if (lookahead == '<') ADVANCE(117);
      if (sym__glimmer_template_content_character_set_1(lookahead)) ADVANCE(116);
      if (lookahead != 0) ADVANCE(114);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(29)
      if (lookahead == '/') ADVANCE(23);
      if (lookahead == '[') ADVANCE(37);
      if (lookahead == '\\') ADVANCE(91);
      if (sym__glimmer_template_content_character_set_1(lookahead)) ADVANCE(218);
      if (lookahead != 0) ADVANCE(219);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(107);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(36);
      if (lookahead == '%') ADVANCE(181);
      if (lookahead == '&') ADVANCE(163);
      if (lookahead == '\'') ADVANCE(196);
      if (lookahead == '(') ADVANCE(108);
      if (lookahead == ')') ADVANCE(109);
      if (lookahead == '*') ADVANCE(97);
      if (lookahead == '+') ADVANCE(175);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(178);
      if (lookahead == '.') ADVANCE(133);
      if (lookahead == '/') ADVANCE(130);
      if (lookahead == '0') ADVANCE(222);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == ';') ADVANCE(110);
      if (lookahead == '<') ADVANCE(121);
      if (lookahead == '=') ADVANCE(100);
      if (lookahead == '>') ADVANCE(127);
      if (lookahead == '?') ADVANCE(237);
      if (lookahead == '[') ADVANCE(112);
      if (lookahead == '\\') ADVANCE(55);
      if (lookahead == ']') ADVANCE(113);
      if (lookahead == '^') ADVANCE(166);
      if (lookahead == '`') ADVANCE(215);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '|') ADVANCE(168);
      if (lookahead == '}') ADVANCE(105);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(223);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(3)
      if (lookahead != 0 &&
          lookahead > 31 &&
          lookahead != '@' &&
          lookahead != '~') ADVANCE(232);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(107);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '%') ADVANCE(181);
      if (lookahead == '&') ADVANCE(163);
      if (lookahead == '\'') ADVANCE(196);
      if (lookahead == '(') ADVANCE(108);
      if (lookahead == ')') ADVANCE(109);
      if (lookahead == '*') ADVANCE(97);
      if (lookahead == '+') ADVANCE(175);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(178);
      if (lookahead == '.') ADVANCE(132);
      if (lookahead == '/') ADVANCE(130);
      if (lookahead == '0') ADVANCE(222);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == '<') ADVANCE(122);
      if (lookahead == '=') ADVANCE(100);
      if (lookahead == '>') ADVANCE(127);
      if (lookahead == '?') ADVANCE(237);
      if (lookahead == '@') ADVANCE(234);
      if (lookahead == '[') ADVANCE(112);
      if (lookahead == '\\') ADVANCE(55);
      if (lookahead == '^') ADVANCE(166);
      if (lookahead == '`') ADVANCE(215);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(168);
      if (lookahead == '~') ADVANCE(192);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(223);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(4)
      if (lookahead != 0 &&
          lookahead > '#' &&
          lookahead != ';' &&
          lookahead != ']' &&
          lookahead != '}') ADVANCE(232);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(107);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '%') ADVANCE(181);
      if (lookahead == '&') ADVANCE(163);
      if (lookahead == '\'') ADVANCE(196);
      if (lookahead == '(') ADVANCE(108);
      if (lookahead == ')') ADVANCE(109);
      if (lookahead == '*') ADVANCE(97);
      if (lookahead == '+') ADVANCE(175);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(178);
      if (lookahead == '.') ADVANCE(131);
      if (lookahead == '/') ADVANCE(130);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == ';') ADVANCE(110);
      if (lookahead == '<') ADVANCE(121);
      if (lookahead == '=') ADVANCE(100);
      if (lookahead == '>') ADVANCE(127);
      if (lookahead == '?') ADVANCE(237);
      if (lookahead == '@') ADVANCE(234);
      if (lookahead == '[') ADVANCE(112);
      if (lookahead == '\\') ADVANCE(55);
      if (lookahead == ']') ADVANCE(113);
      if (lookahead == '^') ADVANCE(166);
      if (lookahead == '`') ADVANCE(215);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(169);
      if (lookahead == '}') ADVANCE(105);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(243);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(5)
      if (lookahead != 0 &&
          lookahead > '#' &&
          lookahead != '~') ADVANCE(232);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(107);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '%') ADVANCE(180);
      if (lookahead == '&') ADVANCE(164);
      if (lookahead == '\'') ADVANCE(196);
      if (lookahead == '(') ADVANCE(108);
      if (lookahead == ')') ADVANCE(109);
      if (lookahead == '*') ADVANCE(98);
      if (lookahead == '+') ADVANCE(174);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(177);
      if (lookahead == '.') ADVANCE(133);
      if (lookahead == '/') ADVANCE(129);
      if (lookahead == '0') ADVANCE(222);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == ';') ADVANCE(110);
      if (lookahead == '<') ADVANCE(124);
      if (lookahead == '=') ADVANCE(99);
      if (lookahead == '>') ADVANCE(128);
      if (lookahead == '?') ADVANCE(27);
      if (lookahead == '@') ADVANCE(234);
      if (lookahead == '[') ADVANCE(112);
      if (lookahead == '\\') ADVANCE(55);
      if (lookahead == ']') ADVANCE(113);
      if (lookahead == '^') ADVANCE(165);
      if (lookahead == '`') ADVANCE(215);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(170);
      if (lookahead == '}') ADVANCE(105);
      if (lookahead == '~') ADVANCE(192);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(223);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(6)
      if (lookahead != 0 &&
          lookahead > '#') ADVANCE(232);
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(107);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '%') ADVANCE(180);
      if (lookahead == '&') ADVANCE(164);
      if (lookahead == '\'') ADVANCE(196);
      if (lookahead == '(') ADVANCE(108);
      if (lookahead == ')') ADVANCE(109);
      if (lookahead == '*') ADVANCE(98);
      if (lookahead == '+') ADVANCE(174);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(177);
      if (lookahead == '.') ADVANCE(131);
      if (lookahead == '/') ADVANCE(129);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == ';') ADVANCE(110);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(99);
      if (lookahead == '>') ADVANCE(128);
      if (lookahead == '?') ADVANCE(238);
      if (lookahead == '@') ADVANCE(234);
      if (lookahead == '[') ADVANCE(112);
      if (lookahead == '\\') ADVANCE(55);
      if (lookahead == ']') ADVANCE(113);
      if (lookahead == '^') ADVANCE(165);
      if (lookahead == '`') ADVANCE(215);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(171);
      if (lookahead == '}') ADVANCE(105);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(7)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != '~') ADVANCE(232);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(107);
      if (lookahead == '%') ADVANCE(180);
      if (lookahead == '&') ADVANCE(164);
      if (lookahead == '(') ADVANCE(108);
      if (lookahead == ')') ADVANCE(109);
      if (lookahead == '*') ADVANCE(98);
      if (lookahead == '+') ADVANCE(174);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(177);
      if (lookahead == '.') ADVANCE(131);
      if (lookahead == '/') ADVANCE(129);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == ';') ADVANCE(110);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(32);
      if (lookahead == '>') ADVANCE(128);
      if (lookahead == '?') ADVANCE(27);
      if (lookahead == '[') ADVANCE(112);
      if (lookahead == '\\') ADVANCE(55);
      if (lookahead == ']') ADVANCE(113);
      if (lookahead == '^') ADVANCE(165);
      if (lookahead == '`') ADVANCE(215);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(170);
      if (lookahead == '}') ADVANCE(105);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(9)
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(220);
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(232);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(107);
      if (lookahead == '%') ADVANCE(180);
      if (lookahead == '&') ADVANCE(164);
      if (lookahead == '(') ADVANCE(108);
      if (lookahead == ')') ADVANCE(109);
      if (lookahead == '*') ADVANCE(98);
      if (lookahead == '+') ADVANCE(174);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(177);
      if (lookahead == '.') ADVANCE(131);
      if (lookahead == '/') ADVANCE(129);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == ';') ADVANCE(110);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(32);
      if (lookahead == '>') ADVANCE(128);
      if (lookahead == '?') ADVANCE(27);
      if (lookahead == '[') ADVANCE(112);
      if (lookahead == '\\') ADVANCE(55);
      if (lookahead == ']') ADVANCE(113);
      if (lookahead == '^') ADVANCE(165);
      if (lookahead == '`') ADVANCE(215);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(170);
      if (lookahead == '}') ADVANCE(105);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(9)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(232);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(54);
      if (!sym_private_property_identifier_character_set_1(lookahead)) ADVANCE(233);
      END_STATE();
    case 11:
      if (lookahead == '!') ADVANCE(106);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(36);
      if (lookahead == '&') ADVANCE(162);
      if (lookahead == '\'') ADVANCE(196);
      if (lookahead == '(') ADVANCE(108);
      if (lookahead == ')') ADVANCE(109);
      if (lookahead == '*') ADVANCE(96);
      if (lookahead == '+') ADVANCE(174);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(177);
      if (lookahead == '.') ADVANCE(132);
      if (lookahead == '/') ADVANCE(129);
      if (lookahead == '0') ADVANCE(222);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == ';') ADVANCE(110);
      if (lookahead == '<') ADVANCE(125);
      if (lookahead == '=') ADVANCE(101);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(235);
      if (lookahead == '@') ADVANCE(234);
      if (lookahead == '[') ADVANCE(112);
      if (lookahead == '\\') ADVANCE(55);
      if (lookahead == ']') ADVANCE(113);
      if (lookahead == '`') ADVANCE(215);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(172);
      if (lookahead == '}') ADVANCE(105);
      if (lookahead == '~') ADVANCE(192);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(223);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(11)
      if (lookahead != 0 &&
          lookahead > 31 &&
          lookahead != '%' &&
          lookahead != '^') ADVANCE(232);
      END_STATE();
    case 12:
      if (lookahead == '!') ADVANCE(106);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(36);
      if (lookahead == '&') ADVANCE(162);
      if (lookahead == '\'') ADVANCE(196);
      if (lookahead == '(') ADVANCE(108);
      if (lookahead == '*') ADVANCE(96);
      if (lookahead == '+') ADVANCE(173);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(176);
      if (lookahead == '.') ADVANCE(132);
      if (lookahead == '/') ADVANCE(217);
      if (lookahead == '0') ADVANCE(222);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == ';') ADVANCE(110);
      if (lookahead == '<') ADVANCE(120);
      if (lookahead == '=') ADVANCE(101);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(235);
      if (lookahead == '@') ADVANCE(234);
      if (lookahead == '[') ADVANCE(112);
      if (lookahead == '\\') ADVANCE(55);
      if (lookahead == ']') ADVANCE(113);
      if (lookahead == '`') ADVANCE(215);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '|') ADVANCE(172);
      if (lookahead == '}') ADVANCE(105);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(223);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(13)
      if (lookahead != 0 &&
          lookahead > 31 &&
          (lookahead < '%' || ')' < lookahead) &&
          lookahead != '^' &&
          lookahead != '~') ADVANCE(232);
      END_STATE();
    case 13:
      if (lookahead == '!') ADVANCE(106);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(36);
      if (lookahead == '&') ADVANCE(162);
      if (lookahead == '\'') ADVANCE(196);
      if (lookahead == '(') ADVANCE(108);
      if (lookahead == '*') ADVANCE(96);
      if (lookahead == '+') ADVANCE(173);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(176);
      if (lookahead == '.') ADVANCE(132);
      if (lookahead == '/') ADVANCE(23);
      if (lookahead == '0') ADVANCE(222);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == ';') ADVANCE(110);
      if (lookahead == '<') ADVANCE(120);
      if (lookahead == '=') ADVANCE(101);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(235);
      if (lookahead == '@') ADVANCE(234);
      if (lookahead == '[') ADVANCE(112);
      if (lookahead == '\\') ADVANCE(55);
      if (lookahead == ']') ADVANCE(113);
      if (lookahead == '`') ADVANCE(215);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '|') ADVANCE(172);
      if (lookahead == '}') ADVANCE(105);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(223);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(13)
      if (lookahead != 0 &&
          lookahead > 31 &&
          (lookahead < '%' || ')' < lookahead) &&
          lookahead != '^' &&
          lookahead != '~') ADVANCE(232);
      END_STATE();
    case 14:
      if (lookahead == '!') ADVANCE(106);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '&') ADVANCE(162);
      if (lookahead == '\'') ADVANCE(196);
      if (lookahead == '(') ADVANCE(108);
      if (lookahead == ')') ADVANCE(109);
      if (lookahead == '*') ADVANCE(96);
      if (lookahead == '+') ADVANCE(174);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(177);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '/') ADVANCE(129);
      if (lookahead == '0') ADVANCE(222);
      if (lookahead == '<') ADVANCE(125);
      if (lookahead == '?') ADVANCE(235);
      if (lookahead == '@') ADVANCE(234);
      if (lookahead == '[') ADVANCE(112);
      if (lookahead == '\\') ADVANCE(55);
      if (lookahead == ']') ADVANCE(113);
      if (lookahead == '`') ADVANCE(215);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '|') ADVANCE(167);
      if (lookahead == '~') ADVANCE(192);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(223);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(14)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '%' || '>' < lookahead) &&
          lookahead != '^' &&
          lookahead != '}') ADVANCE(232);
      END_STATE();
    case 15:
      if (lookahead == '!') ADVANCE(106);
      if (lookahead == '&') ADVANCE(162);
      if (lookahead == '(') ADVANCE(108);
      if (lookahead == ')') ADVANCE(109);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '.') ADVANCE(131);
      if (lookahead == '/') ADVANCE(23);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == ';') ADVANCE(110);
      if (lookahead == '<') ADVANCE(120);
      if (lookahead == '=') ADVANCE(101);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(235);
      if (lookahead == '[') ADVANCE(112);
      if (lookahead == '\\') ADVANCE(55);
      if (lookahead == ']') ADVANCE(113);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(172);
      if (lookahead == '}') ADVANCE(105);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(243);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(15)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          lookahead != '^' &&
          lookahead != '`' &&
          lookahead != '~') ADVANCE(232);
      END_STATE();
    case 16:
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(36);
      if (lookahead == '&') ADVANCE(162);
      if (lookahead == '\'') ADVANCE(196);
      if (lookahead == '(') ADVANCE(108);
      if (lookahead == ')') ADVANCE(109);
      if (lookahead == '*') ADVANCE(96);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(176);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '/') ADVANCE(23);
      if (lookahead == '0') ADVANCE(222);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == ';') ADVANCE(110);
      if (lookahead == '<') ADVANCE(120);
      if (lookahead == '=') ADVANCE(101);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(235);
      if (lookahead == '@') ADVANCE(234);
      if (lookahead == '[') ADVANCE(112);
      if (lookahead == '\\') ADVANCE(55);
      if (lookahead == ']') ADVANCE(113);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(172);
      if (lookahead == '}') ADVANCE(105);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(223);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(16)
      if (lookahead != 0 &&
          lookahead > '!' &&
          (lookahead < '%' || '+' < lookahead) &&
          lookahead != '^' &&
          lookahead != '`' &&
          lookahead != '~') ADVANCE(232);
      END_STATE();
    case 17:
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '/') ADVANCE(198);
      if (lookahead == '\\') ADVANCE(56);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead != 0) ADVANCE(202);
      END_STATE();
    case 18:
      if (lookahead == '$') ADVANCE(57);
      if (lookahead == '/') ADVANCE(23);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == '`') ADVANCE(215);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(19)
      END_STATE();
    case 19:
      if (lookahead == '$') ADVANCE(57);
      if (lookahead == '/') ADVANCE(23);
      if (lookahead == '`') ADVANCE(215);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(19)
      END_STATE();
    case 20:
      if (lookahead == '&') ADVANCE(162);
      if (lookahead == '(') ADVANCE(108);
      if (lookahead == ')') ADVANCE(109);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '.') ADVANCE(131);
      if (lookahead == '/') ADVANCE(23);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == ';') ADVANCE(110);
      if (lookahead == '=') ADVANCE(101);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(236);
      if (lookahead == '[') ADVANCE(112);
      if (lookahead == '\\') ADVANCE(55);
      if (lookahead == ']') ADVANCE(113);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(172);
      if (lookahead == '}') ADVANCE(105);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(20)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          lookahead != '^' &&
          lookahead != '`' &&
          lookahead != '~') ADVANCE(232);
      END_STATE();
    case 21:
      if (lookahead == '&') ADVANCE(162);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(35);
      if (lookahead == '.') ADVANCE(131);
      if (lookahead == '/') ADVANCE(23);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == '<') ADVANCE(120);
      if (lookahead == '?') ADVANCE(31);
      if (lookahead == '[') ADVANCE(112);
      if (lookahead == '\\') ADVANCE(55);
      if (lookahead == ']') ADVANCE(113);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '|') ADVANCE(167);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(21)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          lookahead != '^' &&
          lookahead != '`' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(232);
      END_STATE();
    case 22:
      if (lookahead == '\'') ADVANCE(196);
      if (lookahead == '/') ADVANCE(204);
      if (lookahead == '\\') ADVANCE(56);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(207);
      if (lookahead != 0) ADVANCE(208);
      END_STATE();
    case 23:
      if (lookahead == '*') ADVANCE(25);
      if (lookahead == '/') ADVANCE(214);
      END_STATE();
    case 24:
      if (lookahead == '*') ADVANCE(24);
      if (lookahead == '/') ADVANCE(213);
      if (lookahead != 0) ADVANCE(25);
      END_STATE();
    case 25:
      if (lookahead == '*') ADVANCE(24);
      if (lookahead != 0) ADVANCE(25);
      END_STATE();
    case 26:
      if (lookahead == '.') ADVANCE(28);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(229);
      END_STATE();
    case 27:
      if (lookahead == '.') ADVANCE(135);
      if (lookahead == '?') ADVANCE(190);
      END_STATE();
    case 28:
      if (lookahead == '.') ADVANCE(151);
      END_STATE();
    case 29:
      if (lookahead == '/') ADVANCE(23);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(29)
      END_STATE();
    case 30:
      if (lookahead == ':') ADVANCE(239);
      END_STATE();
    case 31:
      if (lookahead == ':') ADVANCE(240);
      END_STATE();
    case 32:
      if (lookahead == '=') ADVANCE(185);
      END_STATE();
    case 33:
      if (lookahead == '>') ADVANCE(118);
      END_STATE();
    case 34:
      if (lookahead == '>') ADVANCE(119);
      END_STATE();
    case 35:
      if (lookahead == '?') ADVANCE(30);
      END_STATE();
    case 36:
      if (lookahead == '\\') ADVANCE(54);
      if (!sym_private_property_identifier_character_set_1(lookahead)) ADVANCE(233);
      END_STATE();
    case 37:
      if (lookahead == '\\') ADVANCE(90);
      if (lookahead == ']') ADVANCE(219);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(37);
      END_STATE();
    case 38:
      if (lookahead == 'a') ADVANCE(50);
      END_STATE();
    case 39:
      if (lookahead == 'a') ADVANCE(51);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(46);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(33);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(34);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(47);
      END_STATE();
    case 44:
      if (lookahead == 'l') ADVANCE(38);
      END_STATE();
    case 45:
      if (lookahead == 'l') ADVANCE(39);
      END_STATE();
    case 46:
      if (lookahead == 'm') ADVANCE(48);
      END_STATE();
    case 47:
      if (lookahead == 'm') ADVANCE(49);
      END_STATE();
    case 48:
      if (lookahead == 'p') ADVANCE(44);
      END_STATE();
    case 49:
      if (lookahead == 'p') ADVANCE(45);
      END_STATE();
    case 50:
      if (lookahead == 't') ADVANCE(41);
      END_STATE();
    case 51:
      if (lookahead == 't') ADVANCE(42);
      END_STATE();
    case 52:
      if (lookahead == 't') ADVANCE(43);
      END_STATE();
    case 53:
      if (lookahead == 'u') ADVANCE(58);
      if (lookahead == 'x') ADVANCE(82);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(212);
      if (lookahead != 0) ADVANCE(209);
      END_STATE();
    case 54:
      if (lookahead == 'u') ADVANCE(59);
      END_STATE();
    case 55:
      if (lookahead == 'u') ADVANCE(60);
      END_STATE();
    case 56:
      if (lookahead == 'u') ADVANCE(61);
      if (lookahead == 'x') ADVANCE(82);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(212);
      if (lookahead != 0) ADVANCE(209);
      END_STATE();
    case 57:
      if (lookahead == '{') ADVANCE(216);
      END_STATE();
    case 58:
      if (lookahead == '{') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(87);
      END_STATE();
    case 59:
      if (lookahead == '{') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(88);
      END_STATE();
    case 60:
      if (lookahead == '{') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(89);
      END_STATE();
    case 61:
      if (lookahead == '{') ADVANCE(83);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(79);
      END_STATE();
    case 62:
      if (lookahead == '}') ADVANCE(232);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      END_STATE();
    case 63:
      if (lookahead == '}') ADVANCE(233);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(63);
      END_STATE();
    case 64:
      if (lookahead == '}') ADVANCE(209);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(64);
      END_STATE();
    case 65:
      if (lookahead == '}') ADVANCE(210);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(65);
      END_STATE();
    case 66:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(72);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(228);
      END_STATE();
    case 67:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(224);
      END_STATE();
    case 68:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(225);
      END_STATE();
    case 69:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(223);
      END_STATE();
    case 70:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(229);
      END_STATE();
    case 71:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(227);
      END_STATE();
    case 72:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(228);
      END_STATE();
    case 73:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(232);
      END_STATE();
    case 74:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(233);
      END_STATE();
    case 75:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(209);
      END_STATE();
    case 76:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(226);
      END_STATE();
    case 77:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(65);
      END_STATE();
    case 78:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(210);
      END_STATE();
    case 79:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(82);
      END_STATE();
    case 80:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(63);
      END_STATE();
    case 81:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      END_STATE();
    case 82:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(75);
      END_STATE();
    case 83:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(64);
      END_STATE();
    case 84:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(78);
      END_STATE();
    case 85:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(74);
      END_STATE();
    case 86:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(73);
      END_STATE();
    case 87:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(84);
      END_STATE();
    case 88:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(85);
      END_STATE();
    case 89:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(86);
      END_STATE();
    case 90:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(37);
      END_STATE();
    case 91:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(219);
      END_STATE();
    case 92:
      if (eof) ADVANCE(94);
      if (lookahead == '!') ADVANCE(107);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(10);
      if (lookahead == '$') ADVANCE(231);
      if (lookahead == '%') ADVANCE(181);
      if (lookahead == '&') ADVANCE(163);
      if (lookahead == '\'') ADVANCE(196);
      if (lookahead == '(') ADVANCE(108);
      if (lookahead == ')') ADVANCE(109);
      if (lookahead == '*') ADVANCE(97);
      if (lookahead == '+') ADVANCE(175);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(179);
      if (lookahead == '.') ADVANCE(132);
      if (lookahead == '/') ADVANCE(129);
      if (lookahead == '0') ADVANCE(222);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == ';') ADVANCE(110);
      if (lookahead == '<') ADVANCE(122);
      if (lookahead == '=') ADVANCE(100);
      if (lookahead == '>') ADVANCE(127);
      if (lookahead == '?') ADVANCE(237);
      if (lookahead == '@') ADVANCE(234);
      if (lookahead == '[') ADVANCE(112);
      if (lookahead == '\\') ADVANCE(55);
      if (lookahead == ']') ADVANCE(113);
      if (lookahead == '^') ADVANCE(166);
      if (lookahead == '`') ADVANCE(215);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '|') ADVANCE(169);
      if (lookahead == '}') ADVANCE(105);
      if (lookahead == '~') ADVANCE(192);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(223);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(92)
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(232);
      END_STATE();
    case 93:
      if (eof) ADVANCE(94);
      if (lookahead == '!') ADVANCE(107);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(10);
      if (lookahead == '%') ADVANCE(181);
      if (lookahead == '&') ADVANCE(163);
      if (lookahead == '\'') ADVANCE(196);
      if (lookahead == '(') ADVANCE(108);
      if (lookahead == ')') ADVANCE(109);
      if (lookahead == '*') ADVANCE(97);
      if (lookahead == '+') ADVANCE(175);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(178);
      if (lookahead == '.') ADVANCE(132);
      if (lookahead == '/') ADVANCE(130);
      if (lookahead == '0') ADVANCE(222);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == ';') ADVANCE(110);
      if (lookahead == '<') ADVANCE(122);
      if (lookahead == '=') ADVANCE(100);
      if (lookahead == '>') ADVANCE(127);
      if (lookahead == '?') ADVANCE(237);
      if (lookahead == '@') ADVANCE(234);
      if (lookahead == '[') ADVANCE(112);
      if (lookahead == '\\') ADVANCE(55);
      if (lookahead == ']') ADVANCE(113);
      if (lookahead == '^') ADVANCE(166);
      if (lookahead == '`') ADVANCE(215);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '|') ADVANCE(168);
      if (lookahead == '}') ADVANCE(105);
      if (lookahead == '~') ADVANCE(192);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(223);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(93)
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(232);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(95);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(183);
      if (lookahead == '=') ADVANCE(138);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(182);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(185);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(185);
      if (lookahead == '>') ADVANCE(134);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(134);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '|') ADVANCE(241);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(187);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym__glimmer_template_content);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym__glimmer_template_content);
      if (lookahead == '*') ADVANCE(25);
      if (lookahead == '/') ADVANCE(214);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym__glimmer_template_content);
      if (lookahead == '/') ADVANCE(115);
      if (lookahead == '<') ADVANCE(117);
      if (sym__glimmer_template_content_character_set_1(lookahead)) ADVANCE(116);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(114);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym__glimmer_template_content);
      if (lookahead == '/') ADVANCE(52);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_LTtemplate_GT);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_LT_SLASHtemplate_GT);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(161);
      if (lookahead == '=') ADVANCE(184);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(161);
      if (lookahead == '=') ADVANCE(184);
      if (lookahead == 't') ADVANCE(40);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(160);
      if (lookahead == '=') ADVANCE(184);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(160);
      if (lookahead == '=') ADVANCE(184);
      if (lookahead == 't') ADVANCE(40);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == 't') ADVANCE(40);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(189);
      if (lookahead == '>') ADVANCE(156);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(189);
      if (lookahead == '>') ADVANCE(157);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(25);
      if (lookahead == '/') ADVANCE(214);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(25);
      if (lookahead == '/') ADVANCE(214);
      if (lookahead == '=') ADVANCE(139);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(28);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(229);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(229);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_AMP_AMP_EQ);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE_EQ);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK_EQ);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      if (lookahead == '=') ADVANCE(148);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '=') ADVANCE(149);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(144);
      if (lookahead == '>') ADVANCE(159);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(158);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(145);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(146);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(153);
      if (lookahead == '=') ADVANCE(142);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(152);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(141);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(143);
      if (lookahead == '|') ADVANCE(155);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(143);
      if (lookahead == '|') ADVANCE(155);
      if (lookahead == '}') ADVANCE(242);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(154);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(154);
      if (lookahead == '}') ADVANCE(242);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '}') ADVANCE(242);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(193);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(193);
      if (lookahead == '=') ADVANCE(136);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(194);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(194);
      if (lookahead == '=') ADVANCE(137);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(194);
      if (lookahead == '=') ADVANCE(137);
      if (lookahead == '?') ADVANCE(30);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(140);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(147);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(186);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(188);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      if (lookahead == '=') ADVANCE(150);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '\n') ADVANCE(202);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(197);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(200);
      if (lookahead == '/') ADVANCE(197);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(202);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(199);
      if (lookahead == '/') ADVANCE(202);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(200);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(199);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(200);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '/') ADVANCE(198);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(202);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(202);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '\n') ADVANCE(208);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(203);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(206);
      if (lookahead == '/') ADVANCE(203);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(208);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(205);
      if (lookahead == '/') ADVANCE(208);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(206);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(205);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(206);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '/') ADVANCE(204);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(207);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(208);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(208);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(55);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(232);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(209);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(211);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(214);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      if (lookahead == '*') ADVANCE(25);
      if (lookahead == '/') ADVANCE(214);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '\n') SKIP(29)
      if (lookahead == '/') ADVANCE(23);
      if (lookahead == '[') ADVANCE(37);
      if (lookahead == '\\') ADVANCE(91);
      if (sym__glimmer_template_content_character_set_1(lookahead)) ADVANCE(218);
      if (lookahead != 0) ADVANCE(219);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(37);
      if (lookahead == '\\') ADVANCE(91);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(219);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_regex_flags);
      if (lookahead == '\\') ADVANCE(55);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(220);
      if (!sym_identifier_character_set_2(lookahead)) ADVANCE(232);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(230);
      if (lookahead == '0') ADVANCE(227);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(67);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(66);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(68);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(76);
      if (lookahead == '_') ADVANCE(71);
      if (lookahead == 'n') ADVANCE(221);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(223);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(230);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(66);
      if (lookahead == '_') ADVANCE(69);
      if (lookahead == 'n') ADVANCE(221);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(223);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(67);
      if (lookahead == 'n') ADVANCE(221);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(224);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(68);
      if (lookahead == 'n') ADVANCE(221);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(225);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(76);
      if (lookahead == 'n') ADVANCE(221);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(226);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(71);
      if (lookahead == 'n') ADVANCE(221);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(227);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(72);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(228);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(66);
      if (lookahead == '_') ADVANCE(70);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(229);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(66);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(229);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(55);
      if (lookahead == '{') ADVANCE(216);
      if (!sym_identifier_character_set_3(lookahead)) ADVANCE(232);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(55);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(232);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_private_property_identifier);
      if (lookahead == '\\') ADVANCE(54);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(233);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(135);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(135);
      if (lookahead == '?') ADVANCE(191);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(135);
      if (lookahead == '?') ADVANCE(190);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_DASH_QMARK_COLON);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_QMARK_COLON);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_LBRACE_PIPE);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_PIPE_RBRACE);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(aux_sym_ui_version_specifier_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(243);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'g') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'k') ADVANCE(9);
      if (lookahead == 'l') ADVANCE(10);
      if (lookahead == 'm') ADVANCE(11);
      if (lookahead == 'n') ADVANCE(12);
      if (lookahead == 'o') ADVANCE(13);
      if (lookahead == 'p') ADVANCE(14);
      if (lookahead == 'r') ADVANCE(15);
      if (lookahead == 's') ADVANCE(16);
      if (lookahead == 't') ADVANCE(17);
      if (lookahead == 'u') ADVANCE(18);
      if (lookahead == 'v') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      if (lookahead == 'y') ADVANCE(21);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8203) ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 8288 ||
          lookahead == 12288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(22);
      if (lookahead == 'n') ADVANCE(23);
      if (lookahead == 's') ADVANCE(24);
      if (lookahead == 'w') ADVANCE(25);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(26);
      if (lookahead == 'r') ADVANCE(27);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(28);
      if (lookahead == 'l') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(32);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(33);
      if (lookahead == 'n') ADVANCE(34);
      if (lookahead == 'x') ADVANCE(35);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(36);
      if (lookahead == 'i') ADVANCE(37);
      if (lookahead == 'o') ADVANCE(38);
      if (lookahead == 'r') ADVANCE(39);
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(41);
      if (lookahead == 'l') ADVANCE(42);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(43);
      if (lookahead == 'm') ADVANCE(44);
      if (lookahead == 'n') ADVANCE(45);
      if (lookahead == 's') ADVANCE(46);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(47);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(48);
      if (lookahead == 'i') ADVANCE(49);
      END_STATE();
    case 11:
      if (lookahead == 'o') ADVANCE(50);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(51);
      if (lookahead == 'e') ADVANCE(52);
      if (lookahead == 'u') ADVANCE(53);
      END_STATE();
    case 13:
      if (lookahead == 'b') ADVANCE(54);
      if (lookahead == 'f') ADVANCE(55);
      if (lookahead == 'n') ADVANCE(56);
      if (lookahead == 'v') ADVANCE(57);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(58);
      if (lookahead == 'u') ADVANCE(59);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(61);
      if (lookahead == 'i') ADVANCE(62);
      if (lookahead == 't') ADVANCE(63);
      if (lookahead == 'u') ADVANCE(64);
      if (lookahead == 'w') ADVANCE(65);
      if (lookahead == 'y') ADVANCE(66);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(67);
      if (lookahead == 'h') ADVANCE(68);
      if (lookahead == 'r') ADVANCE(69);
      if (lookahead == 'y') ADVANCE(70);
      END_STATE();
    case 18:
      if (lookahead == 'n') ADVANCE(71);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(72);
      if (lookahead == 'o') ADVANCE(73);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(74);
      if (lookahead == 'i') ADVANCE(75);
      END_STATE();
    case 21:
      if (lookahead == 'i') ADVANCE(76);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(77);
      END_STATE();
    case 23:
      if (lookahead == 'y') ADVANCE(78);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(79);
      if (lookahead == 'y') ADVANCE(80);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(81);
      END_STATE();
    case 26:
      if (lookahead == 'o') ADVANCE(82);
      END_STATE();
    case 27:
      if (lookahead == 'e') ADVANCE(83);
      END_STATE();
    case 28:
      if (lookahead == 's') ADVANCE(84);
      if (lookahead == 't') ADVANCE(85);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(86);
      END_STATE();
    case 30:
      if (lookahead == 'm') ADVANCE(87);
      if (lookahead == 'n') ADVANCE(88);
      END_STATE();
    case 31:
      if (lookahead == 'b') ADVANCE(89);
      if (lookahead == 'c') ADVANCE(90);
      if (lookahead == 'f') ADVANCE(91);
      if (lookahead == 'l') ADVANCE(92);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 33:
      if (lookahead == 's') ADVANCE(93);
      END_STATE();
    case 34:
      if (lookahead == 'u') ADVANCE(94);
      END_STATE();
    case 35:
      if (lookahead == 'p') ADVANCE(95);
      if (lookahead == 't') ADVANCE(96);
      END_STATE();
    case 36:
      if (lookahead == 'l') ADVANCE(97);
      END_STATE();
    case 37:
      if (lookahead == 'n') ADVANCE(98);
      END_STATE();
    case 38:
      if (lookahead == 'r') ADVANCE(99);
      END_STATE();
    case 39:
      if (lookahead == 'o') ADVANCE(100);
      END_STATE();
    case 40:
      if (lookahead == 'n') ADVANCE(101);
      END_STATE();
    case 41:
      if (lookahead == 't') ADVANCE(102);
      END_STATE();
    case 42:
      if (lookahead == 'o') ADVANCE(103);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 44:
      if (lookahead == 'p') ADVANCE(104);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'f') ADVANCE(105);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == 't') ADVANCE(107);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 47:
      if (lookahead == 'y') ADVANCE(108);
      END_STATE();
    case 48:
      if (lookahead == 't') ADVANCE(109);
      END_STATE();
    case 49:
      if (lookahead == 's') ADVANCE(110);
      END_STATE();
    case 50:
      if (lookahead == 'd') ADVANCE(111);
      END_STATE();
    case 51:
      if (lookahead == 'm') ADVANCE(112);
      END_STATE();
    case 52:
      if (lookahead == 'v') ADVANCE(113);
      if (lookahead == 'w') ADVANCE(114);
      END_STATE();
    case 53:
      if (lookahead == 'l') ADVANCE(115);
      if (lookahead == 'm') ADVANCE(116);
      END_STATE();
    case 54:
      if (lookahead == 'j') ADVANCE(117);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_on);
      END_STATE();
    case 57:
      if (lookahead == 'e') ADVANCE(118);
      END_STATE();
    case 58:
      if (lookahead == 'a') ADVANCE(119);
      if (lookahead == 'i') ADVANCE(120);
      if (lookahead == 'o') ADVANCE(121);
      END_STATE();
    case 59:
      if (lookahead == 'b') ADVANCE(122);
      END_STATE();
    case 60:
      if (lookahead == 'a') ADVANCE(123);
      if (lookahead == 'q') ADVANCE(124);
      if (lookahead == 't') ADVANCE(125);
      END_STATE();
    case 61:
      if (lookahead == 't') ADVANCE(126);
      END_STATE();
    case 62:
      if (lookahead == 'g') ADVANCE(127);
      END_STATE();
    case 63:
      if (lookahead == 'a') ADVANCE(128);
      if (lookahead == 'r') ADVANCE(129);
      END_STATE();
    case 64:
      if (lookahead == 'p') ADVANCE(130);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(131);
      END_STATE();
    case 66:
      if (lookahead == 'm') ADVANCE(132);
      END_STATE();
    case 67:
      if (lookahead == 'r') ADVANCE(133);
      END_STATE();
    case 68:
      if (lookahead == 'i') ADVANCE(134);
      if (lookahead == 'r') ADVANCE(135);
      END_STATE();
    case 69:
      if (lookahead == 'u') ADVANCE(136);
      if (lookahead == 'y') ADVANCE(137);
      END_STATE();
    case 70:
      if (lookahead == 'p') ADVANCE(138);
      END_STATE();
    case 71:
      if (lookahead == 'd') ADVANCE(139);
      if (lookahead == 'k') ADVANCE(140);
      END_STATE();
    case 72:
      if (lookahead == 'r') ADVANCE(141);
      END_STATE();
    case 73:
      if (lookahead == 'i') ADVANCE(142);
      END_STATE();
    case 74:
      if (lookahead == 'i') ADVANCE(143);
      END_STATE();
    case 75:
      if (lookahead == 't') ADVANCE(144);
      END_STATE();
    case 76:
      if (lookahead == 'e') ADVANCE(145);
      END_STATE();
    case 77:
      if (lookahead == 't') ADVANCE(146);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_any);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(147);
      END_STATE();
    case 80:
      if (lookahead == 'n') ADVANCE(148);
      END_STATE();
    case 81:
      if (lookahead == 'i') ADVANCE(149);
      END_STATE();
    case 82:
      if (lookahead == 'l') ADVANCE(150);
      END_STATE();
    case 83:
      if (lookahead == 'a') ADVANCE(151);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 85:
      if (lookahead == 'c') ADVANCE(153);
      END_STATE();
    case 86:
      if (lookahead == 's') ADVANCE(154);
      END_STATE();
    case 87:
      if (lookahead == 'p') ADVANCE(155);
      END_STATE();
    case 88:
      if (lookahead == 's') ADVANCE(156);
      if (lookahead == 't') ADVANCE(157);
      END_STATE();
    case 89:
      if (lookahead == 'u') ADVANCE(158);
      END_STATE();
    case 90:
      if (lookahead == 'l') ADVANCE(159);
      END_STATE();
    case 91:
      if (lookahead == 'a') ADVANCE(160);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(161);
      END_STATE();
    case 93:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 94:
      if (lookahead == 'm') ADVANCE(163);
      END_STATE();
    case 95:
      if (lookahead == 'o') ADVANCE(164);
      END_STATE();
    case 96:
      if (lookahead == 'e') ADVANCE(165);
      END_STATE();
    case 97:
      if (lookahead == 's') ADVANCE(166);
      END_STATE();
    case 98:
      if (lookahead == 'a') ADVANCE(167);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 100:
      if (lookahead == 'm') ADVANCE(168);
      END_STATE();
    case 101:
      if (lookahead == 'c') ADVANCE(169);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 103:
      if (lookahead == 'b') ADVANCE(170);
      END_STATE();
    case 104:
      if (lookahead == 'l') ADVANCE(171);
      if (lookahead == 'o') ADVANCE(172);
      END_STATE();
    case 105:
      if (lookahead == 'e') ADVANCE(173);
      END_STATE();
    case 106:
      if (lookahead == 't') ADVANCE(174);
      END_STATE();
    case 107:
      if (lookahead == 'e') ADVANCE(175);
      END_STATE();
    case 108:
      if (lookahead == 'o') ADVANCE(176);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 110:
      if (lookahead == 't') ADVANCE(177);
      END_STATE();
    case 111:
      if (lookahead == 'u') ADVANCE(178);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(179);
      END_STATE();
    case 113:
      if (lookahead == 'e') ADVANCE(180);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 115:
      if (lookahead == 'l') ADVANCE(181);
      END_STATE();
    case 116:
      if (lookahead == 'b') ADVANCE(182);
      END_STATE();
    case 117:
      if (lookahead == 'e') ADVANCE(183);
      END_STATE();
    case 118:
      if (lookahead == 'r') ADVANCE(184);
      END_STATE();
    case 119:
      if (lookahead == 'g') ADVANCE(185);
      END_STATE();
    case 120:
      if (lookahead == 'v') ADVANCE(186);
      END_STATE();
    case 121:
      if (lookahead == 'p') ADVANCE(187);
      if (lookahead == 't') ADVANCE(188);
      END_STATE();
    case 122:
      if (lookahead == 'l') ADVANCE(189);
      END_STATE();
    case 123:
      if (lookahead == 'd') ADVANCE(190);
      END_STATE();
    case 124:
      if (lookahead == 'u') ADVANCE(191);
      END_STATE();
    case 125:
      if (lookahead == 'u') ADVANCE(192);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 127:
      if (lookahead == 'n') ADVANCE(193);
      END_STATE();
    case 128:
      if (lookahead == 't') ADVANCE(194);
      END_STATE();
    case 129:
      if (lookahead == 'i') ADVANCE(195);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(196);
      END_STATE();
    case 131:
      if (lookahead == 't') ADVANCE(197);
      END_STATE();
    case 132:
      if (lookahead == 'b') ADVANCE(198);
      END_STATE();
    case 133:
      if (lookahead == 'g') ADVANCE(199);
      END_STATE();
    case 134:
      if (lookahead == 's') ADVANCE(200);
      END_STATE();
    case 135:
      if (lookahead == 'o') ADVANCE(201);
      END_STATE();
    case 136:
      if (lookahead == 'e') ADVANCE(202);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 138:
      if (lookahead == 'e') ADVANCE(203);
      END_STATE();
    case 139:
      if (lookahead == 'e') ADVANCE(204);
      END_STATE();
    case 140:
      if (lookahead == 'n') ADVANCE(205);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 142:
      if (lookahead == 'd') ADVANCE(206);
      END_STATE();
    case 143:
      if (lookahead == 'l') ADVANCE(207);
      END_STATE();
    case 144:
      if (lookahead == 'h') ADVANCE(208);
      END_STATE();
    case 145:
      if (lookahead == 'l') ADVANCE(209);
      END_STATE();
    case 146:
      if (lookahead == 'r') ADVANCE(210);
      END_STATE();
    case 147:
      if (lookahead == 'r') ADVANCE(211);
      END_STATE();
    case 148:
      if (lookahead == 'c') ADVANCE(212);
      END_STATE();
    case 149:
      if (lookahead == 't') ADVANCE(213);
      END_STATE();
    case 150:
      if (lookahead == 'e') ADVANCE(214);
      END_STATE();
    case 151:
      if (lookahead == 'k') ADVANCE(215);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 153:
      if (lookahead == 'h') ADVANCE(216);
      END_STATE();
    case 154:
      if (lookahead == 's') ADVANCE(217);
      END_STATE();
    case 155:
      if (lookahead == 'o') ADVANCE(218);
      END_STATE();
    case 156:
      if (lookahead == 't') ADVANCE(219);
      END_STATE();
    case 157:
      if (lookahead == 'i') ADVANCE(220);
      END_STATE();
    case 158:
      if (lookahead == 'g') ADVANCE(221);
      END_STATE();
    case 159:
      if (lookahead == 'a') ADVANCE(222);
      END_STATE();
    case 160:
      if (lookahead == 'u') ADVANCE(223);
      END_STATE();
    case 161:
      if (lookahead == 't') ADVANCE(224);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 164:
      if (lookahead == 'r') ADVANCE(225);
      END_STATE();
    case 165:
      if (lookahead == 'n') ADVANCE(226);
      END_STATE();
    case 166:
      if (lookahead == 'e') ADVANCE(227);
      END_STATE();
    case 167:
      if (lookahead == 'l') ADVANCE(228);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 169:
      if (lookahead == 't') ADVANCE(229);
      END_STATE();
    case 170:
      if (lookahead == 'a') ADVANCE(230);
      END_STATE();
    case 171:
      if (lookahead == 'e') ADVANCE(231);
      END_STATE();
    case 172:
      if (lookahead == 'r') ADVANCE(232);
      END_STATE();
    case 173:
      if (lookahead == 'r') ADVANCE(233);
      END_STATE();
    case 174:
      if (lookahead == 'a') ADVANCE(234);
      END_STATE();
    case 175:
      if (lookahead == 'r') ADVANCE(235);
      END_STATE();
    case 176:
      if (lookahead == 'f') ADVANCE(236);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_list);
      END_STATE();
    case 178:
      if (lookahead == 'l') ADVANCE(237);
      END_STATE();
    case 179:
      if (lookahead == 's') ADVANCE(238);
      END_STATE();
    case 180:
      if (lookahead == 'r') ADVANCE(239);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 182:
      if (lookahead == 'e') ADVANCE(240);
      END_STATE();
    case 183:
      if (lookahead == 'c') ADVANCE(241);
      END_STATE();
    case 184:
      if (lookahead == 'r') ADVANCE(242);
      END_STATE();
    case 185:
      if (lookahead == 'm') ADVANCE(243);
      END_STATE();
    case 186:
      if (lookahead == 'a') ADVANCE(244);
      END_STATE();
    case 187:
      if (lookahead == 'e') ADVANCE(245);
      END_STATE();
    case 188:
      if (lookahead == 'e') ADVANCE(246);
      END_STATE();
    case 189:
      if (lookahead == 'i') ADVANCE(247);
      END_STATE();
    case 190:
      if (lookahead == 'o') ADVANCE(248);
      END_STATE();
    case 191:
      if (lookahead == 'i') ADVANCE(249);
      END_STATE();
    case 192:
      if (lookahead == 'r') ADVANCE(250);
      END_STATE();
    case 193:
      if (lookahead == 'a') ADVANCE(251);
      END_STATE();
    case 194:
      if (lookahead == 'i') ADVANCE(252);
      END_STATE();
    case 195:
      if (lookahead == 'n') ADVANCE(253);
      END_STATE();
    case 196:
      if (lookahead == 'r') ADVANCE(254);
      END_STATE();
    case 197:
      if (lookahead == 'c') ADVANCE(255);
      END_STATE();
    case 198:
      if (lookahead == 'o') ADVANCE(256);
      END_STATE();
    case 199:
      if (lookahead == 'e') ADVANCE(257);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 201:
      if (lookahead == 'w') ADVANCE(258);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_type);
      if (lookahead == 'o') ADVANCE(259);
      END_STATE();
    case 204:
      if (lookahead == 'f') ADVANCE(260);
      END_STATE();
    case 205:
      if (lookahead == 'o') ADVANCE(261);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 207:
      if (lookahead == 'e') ADVANCE(262);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 209:
      if (lookahead == 'd') ADVANCE(263);
      END_STATE();
    case 210:
      if (lookahead == 'a') ADVANCE(264);
      END_STATE();
    case 211:
      if (lookahead == 't') ADVANCE(265);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 214:
      if (lookahead == 'a') ADVANCE(266);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 218:
      if (lookahead == 'n') ADVANCE(267);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 220:
      if (lookahead == 'n') ADVANCE(268);
      END_STATE();
    case 221:
      if (lookahead == 'g') ADVANCE(269);
      END_STATE();
    case 222:
      if (lookahead == 'r') ADVANCE(270);
      END_STATE();
    case 223:
      if (lookahead == 'l') ADVANCE(271);
      END_STATE();
    case 224:
      if (lookahead == 'e') ADVANCE(272);
      END_STATE();
    case 225:
      if (lookahead == 't') ADVANCE(273);
      END_STATE();
    case 226:
      if (lookahead == 'd') ADVANCE(274);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 228:
      if (lookahead == 'l') ADVANCE(275);
      END_STATE();
    case 229:
      if (lookahead == 'i') ADVANCE(276);
      END_STATE();
    case 230:
      if (lookahead == 'l') ADVANCE(277);
      END_STATE();
    case 231:
      if (lookahead == 'm') ADVANCE(278);
      END_STATE();
    case 232:
      if (lookahead == 't') ADVANCE(279);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_infer);
      END_STATE();
    case 234:
      if (lookahead == 'n') ADVANCE(280);
      END_STATE();
    case 235:
      if (lookahead == 'f') ADVANCE(281);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_keyof);
      END_STATE();
    case 237:
      if (lookahead == 'e') ADVANCE(282);
      END_STATE();
    case 238:
      if (lookahead == 'p') ADVANCE(283);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_never);
      END_STATE();
    case 240:
      if (lookahead == 'r') ADVANCE(284);
      END_STATE();
    case 241:
      if (lookahead == 't') ADVANCE(285);
      END_STATE();
    case 242:
      if (lookahead == 'i') ADVANCE(286);
      END_STATE();
    case 243:
      if (lookahead == 'a') ADVANCE(287);
      END_STATE();
    case 244:
      if (lookahead == 't') ADVANCE(288);
      END_STATE();
    case 245:
      if (lookahead == 'r') ADVANCE(289);
      END_STATE();
    case 246:
      if (lookahead == 'c') ADVANCE(290);
      END_STATE();
    case 247:
      if (lookahead == 'c') ADVANCE(291);
      END_STATE();
    case 248:
      if (lookahead == 'n') ADVANCE(292);
      END_STATE();
    case 249:
      if (lookahead == 'r') ADVANCE(293);
      END_STATE();
    case 250:
      if (lookahead == 'n') ADVANCE(294);
      END_STATE();
    case 251:
      if (lookahead == 'l') ADVANCE(295);
      END_STATE();
    case 252:
      if (lookahead == 'c') ADVANCE(296);
      END_STATE();
    case 253:
      if (lookahead == 'g') ADVANCE(297);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 255:
      if (lookahead == 'h') ADVANCE(298);
      END_STATE();
    case 256:
      if (lookahead == 'l') ADVANCE(299);
      END_STATE();
    case 257:
      if (lookahead == 't') ADVANCE(300);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 259:
      if (lookahead == 'f') ADVANCE(301);
      END_STATE();
    case 260:
      if (lookahead == 'i') ADVANCE(302);
      END_STATE();
    case 261:
      if (lookahead == 'w') ADVANCE(303);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 264:
      if (lookahead == 'c') ADVANCE(304);
      END_STATE();
    case 265:
      if (lookahead == 's') ADVANCE(305);
      END_STATE();
    case 266:
      if (lookahead == 'n') ADVANCE(306);
      END_STATE();
    case 267:
      if (lookahead == 'e') ADVANCE(307);
      END_STATE();
    case 268:
      if (lookahead == 'u') ADVANCE(308);
      END_STATE();
    case 269:
      if (lookahead == 'e') ADVANCE(309);
      END_STATE();
    case 270:
      if (lookahead == 'e') ADVANCE(310);
      END_STATE();
    case 271:
      if (lookahead == 't') ADVANCE(311);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 274:
      if (lookahead == 's') ADVANCE(312);
      END_STATE();
    case 275:
      if (lookahead == 'y') ADVANCE(313);
      END_STATE();
    case 276:
      if (lookahead == 'o') ADVANCE(314);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 278:
      if (lookahead == 'e') ADVANCE(315);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 280:
      if (lookahead == 'c') ADVANCE(316);
      END_STATE();
    case 281:
      if (lookahead == 'a') ADVANCE(317);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 283:
      if (lookahead == 'a') ADVANCE(318);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_number);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_object);
      END_STATE();
    case 286:
      if (lookahead == 'd') ADVANCE(319);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_pragma);
      END_STATE();
    case 288:
      if (lookahead == 'e') ADVANCE(320);
      END_STATE();
    case 289:
      if (lookahead == 't') ADVANCE(321);
      END_STATE();
    case 290:
      if (lookahead == 't') ADVANCE(322);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 292:
      if (lookahead == 'l') ADVANCE(323);
      END_STATE();
    case 293:
      if (lookahead == 'e') ADVANCE(324);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_signal);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_symbol);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_target);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 302:
      if (lookahead == 'n') ADVANCE(325);
      END_STATE();
    case 303:
      if (lookahead == 'n') ADVANCE(326);
      END_STATE();
    case 304:
      if (lookahead == 't') ADVANCE(327);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_asserts);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_boolean);
      END_STATE();
    case 307:
      if (lookahead == 'n') ADVANCE(328);
      END_STATE();
    case 308:
      if (lookahead == 'e') ADVANCE(329);
      END_STATE();
    case 309:
      if (lookahead == 'r') ADVANCE(330);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_declare);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 314:
      if (lookahead == 'n') ADVANCE(331);
      END_STATE();
    case 315:
      if (lookahead == 'n') ADVANCE(332);
      END_STATE();
    case 316:
      if (lookahead == 'e') ADVANCE(333);
      END_STATE();
    case 317:
      if (lookahead == 'c') ADVANCE(334);
      END_STATE();
    case 318:
      if (lookahead == 'c') ADVANCE(335);
      END_STATE();
    case 319:
      if (lookahead == 'e') ADVANCE(336);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 321:
      if (lookahead == 'y') ADVANCE(337);
      END_STATE();
    case 322:
      if (lookahead == 'e') ADVANCE(338);
      END_STATE();
    case 323:
      if (lookahead == 'y') ADVANCE(339);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_require);
      if (lookahead == 'd') ADVANCE(340);
      END_STATE();
    case 325:
      if (lookahead == 'e') ADVANCE(341);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_unknown);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 328:
      if (lookahead == 't') ADVANCE(342);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_debugger);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 332:
      if (lookahead == 't') ADVANCE(343);
      END_STATE();
    case 333:
      if (lookahead == 'o') ADVANCE(344);
      END_STATE();
    case 334:
      if (lookahead == 'e') ADVANCE(345);
      END_STATE();
    case 335:
      if (lookahead == 'e') ADVANCE(346);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(anon_sym_override);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_property);
      END_STATE();
    case 338:
      if (lookahead == 'd') ADVANCE(347);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_readonly);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_required);
      END_STATE();
    case 341:
      if (lookahead == 'd') ADVANCE(348);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(anon_sym_component);
      END_STATE();
    case 343:
      if (lookahead == 's') ADVANCE(349);
      END_STATE();
    case 344:
      if (lookahead == 'f') ADVANCE(350);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_namespace);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_undefined);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 93},
  [2] = {.lex_state = 93, .external_lex_state = 2},
  [3] = {.lex_state = 93, .external_lex_state = 2},
  [4] = {.lex_state = 11},
  [5] = {.lex_state = 11},
  [6] = {.lex_state = 11},
  [7] = {.lex_state = 11},
  [8] = {.lex_state = 11},
  [9] = {.lex_state = 11},
  [10] = {.lex_state = 11},
  [11] = {.lex_state = 11},
  [12] = {.lex_state = 11},
  [13] = {.lex_state = 11},
  [14] = {.lex_state = 11},
  [15] = {.lex_state = 11},
  [16] = {.lex_state = 11},
  [17] = {.lex_state = 11},
  [18] = {.lex_state = 11},
  [19] = {.lex_state = 11},
  [20] = {.lex_state = 11},
  [21] = {.lex_state = 11},
  [22] = {.lex_state = 11},
  [23] = {.lex_state = 11},
  [24] = {.lex_state = 11},
  [25] = {.lex_state = 11},
  [26] = {.lex_state = 11},
  [27] = {.lex_state = 11},
  [28] = {.lex_state = 11},
  [29] = {.lex_state = 11},
  [30] = {.lex_state = 11},
  [31] = {.lex_state = 11},
  [32] = {.lex_state = 11},
  [33] = {.lex_state = 11},
  [34] = {.lex_state = 11},
  [35] = {.lex_state = 11},
  [36] = {.lex_state = 11},
  [37] = {.lex_state = 11},
  [38] = {.lex_state = 11},
  [39] = {.lex_state = 11},
  [40] = {.lex_state = 11},
  [41] = {.lex_state = 11},
  [42] = {.lex_state = 11},
  [43] = {.lex_state = 11},
  [44] = {.lex_state = 11},
  [45] = {.lex_state = 11},
  [46] = {.lex_state = 11},
  [47] = {.lex_state = 11},
  [48] = {.lex_state = 11},
  [49] = {.lex_state = 11},
  [50] = {.lex_state = 11},
  [51] = {.lex_state = 11},
  [52] = {.lex_state = 11},
  [53] = {.lex_state = 11},
  [54] = {.lex_state = 11},
  [55] = {.lex_state = 11},
  [56] = {.lex_state = 11},
  [57] = {.lex_state = 11},
  [58] = {.lex_state = 11},
  [59] = {.lex_state = 11},
  [60] = {.lex_state = 11},
  [61] = {.lex_state = 14},
  [62] = {.lex_state = 14},
  [63] = {.lex_state = 14},
  [64] = {.lex_state = 14},
  [65] = {.lex_state = 14},
  [66] = {.lex_state = 14},
  [67] = {.lex_state = 14},
  [68] = {.lex_state = 14},
  [69] = {.lex_state = 14},
  [70] = {.lex_state = 14},
  [71] = {.lex_state = 4, .external_lex_state = 2},
  [72] = {.lex_state = 4, .external_lex_state = 2},
  [73] = {.lex_state = 4, .external_lex_state = 2},
  [74] = {.lex_state = 4, .external_lex_state = 2},
  [75] = {.lex_state = 4, .external_lex_state = 2},
  [76] = {.lex_state = 4, .external_lex_state = 2},
  [77] = {.lex_state = 4, .external_lex_state = 2},
  [78] = {.lex_state = 4, .external_lex_state = 2},
  [79] = {.lex_state = 14},
  [80] = {.lex_state = 14},
  [81] = {.lex_state = 14},
  [82] = {.lex_state = 14},
  [83] = {.lex_state = 14},
  [84] = {.lex_state = 14},
  [85] = {.lex_state = 14},
  [86] = {.lex_state = 14},
  [87] = {.lex_state = 14},
  [88] = {.lex_state = 14},
  [89] = {.lex_state = 14},
  [90] = {.lex_state = 14},
  [91] = {.lex_state = 14},
  [92] = {.lex_state = 14},
  [93] = {.lex_state = 14},
  [94] = {.lex_state = 14},
  [95] = {.lex_state = 14},
  [96] = {.lex_state = 14},
  [97] = {.lex_state = 14},
  [98] = {.lex_state = 14},
  [99] = {.lex_state = 14},
  [100] = {.lex_state = 6, .external_lex_state = 2},
  [101] = {.lex_state = 6, .external_lex_state = 3},
  [102] = {.lex_state = 6, .external_lex_state = 3},
  [103] = {.lex_state = 6, .external_lex_state = 2},
  [104] = {.lex_state = 6, .external_lex_state = 3},
  [105] = {.lex_state = 6, .external_lex_state = 2},
  [106] = {.lex_state = 6, .external_lex_state = 2},
  [107] = {.lex_state = 6, .external_lex_state = 2},
  [108] = {.lex_state = 6, .external_lex_state = 2},
  [109] = {.lex_state = 11},
  [110] = {.lex_state = 11},
  [111] = {.lex_state = 11},
  [112] = {.lex_state = 11},
  [113] = {.lex_state = 11},
  [114] = {.lex_state = 11},
  [115] = {.lex_state = 11},
  [116] = {.lex_state = 11},
  [117] = {.lex_state = 11},
  [118] = {.lex_state = 11},
  [119] = {.lex_state = 11},
  [120] = {.lex_state = 11},
  [121] = {.lex_state = 11},
  [122] = {.lex_state = 11},
  [123] = {.lex_state = 11},
  [124] = {.lex_state = 11},
  [125] = {.lex_state = 11},
  [126] = {.lex_state = 11},
  [127] = {.lex_state = 11},
  [128] = {.lex_state = 11},
  [129] = {.lex_state = 11},
  [130] = {.lex_state = 3, .external_lex_state = 2},
  [131] = {.lex_state = 11},
  [132] = {.lex_state = 11},
  [133] = {.lex_state = 11},
  [134] = {.lex_state = 11},
  [135] = {.lex_state = 11},
  [136] = {.lex_state = 11},
  [137] = {.lex_state = 3, .external_lex_state = 3},
  [138] = {.lex_state = 11},
  [139] = {.lex_state = 11},
  [140] = {.lex_state = 3, .external_lex_state = 3},
  [141] = {.lex_state = 11},
  [142] = {.lex_state = 11},
  [143] = {.lex_state = 11},
  [144] = {.lex_state = 3, .external_lex_state = 2},
  [145] = {.lex_state = 11},
  [146] = {.lex_state = 11},
  [147] = {.lex_state = 6, .external_lex_state = 3},
  [148] = {.lex_state = 11},
  [149] = {.lex_state = 6, .external_lex_state = 3},
  [150] = {.lex_state = 11},
  [151] = {.lex_state = 6, .external_lex_state = 3},
  [152] = {.lex_state = 11},
  [153] = {.lex_state = 3, .external_lex_state = 2},
  [154] = {.lex_state = 11},
  [155] = {.lex_state = 11},
  [156] = {.lex_state = 11},
  [157] = {.lex_state = 11},
  [158] = {.lex_state = 11},
  [159] = {.lex_state = 11},
  [160] = {.lex_state = 11},
  [161] = {.lex_state = 6, .external_lex_state = 3},
  [162] = {.lex_state = 6, .external_lex_state = 3},
  [163] = {.lex_state = 6, .external_lex_state = 3},
  [164] = {.lex_state = 6, .external_lex_state = 3},
  [165] = {.lex_state = 3, .external_lex_state = 2},
  [166] = {.lex_state = 6, .external_lex_state = 3},
  [167] = {.lex_state = 6, .external_lex_state = 3},
  [168] = {.lex_state = 6, .external_lex_state = 3},
  [169] = {.lex_state = 6, .external_lex_state = 3},
  [170] = {.lex_state = 6, .external_lex_state = 3},
  [171] = {.lex_state = 6, .external_lex_state = 3},
  [172] = {.lex_state = 6, .external_lex_state = 3},
  [173] = {.lex_state = 6, .external_lex_state = 3},
  [174] = {.lex_state = 6, .external_lex_state = 3},
  [175] = {.lex_state = 6, .external_lex_state = 3},
  [176] = {.lex_state = 6, .external_lex_state = 3},
  [177] = {.lex_state = 6, .external_lex_state = 3},
  [178] = {.lex_state = 6, .external_lex_state = 3},
  [179] = {.lex_state = 11},
  [180] = {.lex_state = 3, .external_lex_state = 2},
  [181] = {.lex_state = 6, .external_lex_state = 3},
  [182] = {.lex_state = 6, .external_lex_state = 3},
  [183] = {.lex_state = 11, .external_lex_state = 4},
  [184] = {.lex_state = 6, .external_lex_state = 3},
  [185] = {.lex_state = 6, .external_lex_state = 3},
  [186] = {.lex_state = 6, .external_lex_state = 3},
  [187] = {.lex_state = 6, .external_lex_state = 3},
  [188] = {.lex_state = 3, .external_lex_state = 3},
  [189] = {.lex_state = 6, .external_lex_state = 3},
  [190] = {.lex_state = 3, .external_lex_state = 2},
  [191] = {.lex_state = 11},
  [192] = {.lex_state = 11},
  [193] = {.lex_state = 11},
  [194] = {.lex_state = 3, .external_lex_state = 2},
  [195] = {.lex_state = 3, .external_lex_state = 2},
  [196] = {.lex_state = 3, .external_lex_state = 2},
  [197] = {.lex_state = 11},
  [198] = {.lex_state = 11},
  [199] = {.lex_state = 11},
  [200] = {.lex_state = 11},
  [201] = {.lex_state = 3, .external_lex_state = 2},
  [202] = {.lex_state = 3, .external_lex_state = 2},
  [203] = {.lex_state = 11},
  [204] = {.lex_state = 11},
  [205] = {.lex_state = 4, .external_lex_state = 2},
  [206] = {.lex_state = 11},
  [207] = {.lex_state = 11},
  [208] = {.lex_state = 11},
  [209] = {.lex_state = 11},
  [210] = {.lex_state = 11},
  [211] = {.lex_state = 11},
  [212] = {.lex_state = 11},
  [213] = {.lex_state = 11},
  [214] = {.lex_state = 11},
  [215] = {.lex_state = 4, .external_lex_state = 2},
  [216] = {.lex_state = 11},
  [217] = {.lex_state = 11},
  [218] = {.lex_state = 11},
  [219] = {.lex_state = 11},
  [220] = {.lex_state = 4, .external_lex_state = 2},
  [221] = {.lex_state = 4, .external_lex_state = 2},
  [222] = {.lex_state = 11},
  [223] = {.lex_state = 11},
  [224] = {.lex_state = 11},
  [225] = {.lex_state = 11},
  [226] = {.lex_state = 11},
  [227] = {.lex_state = 11},
  [228] = {.lex_state = 11},
  [229] = {.lex_state = 11},
  [230] = {.lex_state = 11},
  [231] = {.lex_state = 11},
  [232] = {.lex_state = 11},
  [233] = {.lex_state = 11},
  [234] = {.lex_state = 11},
  [235] = {.lex_state = 11, .external_lex_state = 4},
  [236] = {.lex_state = 11},
  [237] = {.lex_state = 11},
  [238] = {.lex_state = 11},
  [239] = {.lex_state = 11},
  [240] = {.lex_state = 11},
  [241] = {.lex_state = 11, .external_lex_state = 4},
  [242] = {.lex_state = 11},
  [243] = {.lex_state = 11},
  [244] = {.lex_state = 11},
  [245] = {.lex_state = 11},
  [246] = {.lex_state = 11},
  [247] = {.lex_state = 11},
  [248] = {.lex_state = 11},
  [249] = {.lex_state = 11},
  [250] = {.lex_state = 11},
  [251] = {.lex_state = 11},
  [252] = {.lex_state = 11},
  [253] = {.lex_state = 11},
  [254] = {.lex_state = 11},
  [255] = {.lex_state = 11},
  [256] = {.lex_state = 11},
  [257] = {.lex_state = 11},
  [258] = {.lex_state = 11},
  [259] = {.lex_state = 11},
  [260] = {.lex_state = 11},
  [261] = {.lex_state = 11},
  [262] = {.lex_state = 11},
  [263] = {.lex_state = 11},
  [264] = {.lex_state = 11},
  [265] = {.lex_state = 11},
  [266] = {.lex_state = 11},
  [267] = {.lex_state = 11},
  [268] = {.lex_state = 11},
  [269] = {.lex_state = 11},
  [270] = {.lex_state = 11},
  [271] = {.lex_state = 11},
  [272] = {.lex_state = 11},
  [273] = {.lex_state = 11},
  [274] = {.lex_state = 11},
  [275] = {.lex_state = 11},
  [276] = {.lex_state = 11},
  [277] = {.lex_state = 11},
  [278] = {.lex_state = 11},
  [279] = {.lex_state = 11},
  [280] = {.lex_state = 11},
  [281] = {.lex_state = 11},
  [282] = {.lex_state = 11},
  [283] = {.lex_state = 11},
  [284] = {.lex_state = 11},
  [285] = {.lex_state = 11},
  [286] = {.lex_state = 11},
  [287] = {.lex_state = 11},
  [288] = {.lex_state = 11},
  [289] = {.lex_state = 11},
  [290] = {.lex_state = 11},
  [291] = {.lex_state = 11},
  [292] = {.lex_state = 11},
  [293] = {.lex_state = 11},
  [294] = {.lex_state = 11},
  [295] = {.lex_state = 11},
  [296] = {.lex_state = 11},
  [297] = {.lex_state = 11},
  [298] = {.lex_state = 11},
  [299] = {.lex_state = 11},
  [300] = {.lex_state = 11},
  [301] = {.lex_state = 11},
  [302] = {.lex_state = 11},
  [303] = {.lex_state = 11},
  [304] = {.lex_state = 11},
  [305] = {.lex_state = 11},
  [306] = {.lex_state = 11},
  [307] = {.lex_state = 11},
  [308] = {.lex_state = 11},
  [309] = {.lex_state = 11},
  [310] = {.lex_state = 11},
  [311] = {.lex_state = 11},
  [312] = {.lex_state = 11},
  [313] = {.lex_state = 11},
  [314] = {.lex_state = 11},
  [315] = {.lex_state = 11},
  [316] = {.lex_state = 11},
  [317] = {.lex_state = 11},
  [318] = {.lex_state = 11},
  [319] = {.lex_state = 11},
  [320] = {.lex_state = 11},
  [321] = {.lex_state = 11},
  [322] = {.lex_state = 11},
  [323] = {.lex_state = 11},
  [324] = {.lex_state = 11},
  [325] = {.lex_state = 11},
  [326] = {.lex_state = 11},
  [327] = {.lex_state = 11},
  [328] = {.lex_state = 11},
  [329] = {.lex_state = 11},
  [330] = {.lex_state = 11},
  [331] = {.lex_state = 11},
  [332] = {.lex_state = 11},
  [333] = {.lex_state = 11},
  [334] = {.lex_state = 11},
  [335] = {.lex_state = 11},
  [336] = {.lex_state = 11},
  [337] = {.lex_state = 11},
  [338] = {.lex_state = 11},
  [339] = {.lex_state = 11},
  [340] = {.lex_state = 11},
  [341] = {.lex_state = 11},
  [342] = {.lex_state = 11},
  [343] = {.lex_state = 11},
  [344] = {.lex_state = 11},
  [345] = {.lex_state = 11},
  [346] = {.lex_state = 11},
  [347] = {.lex_state = 11},
  [348] = {.lex_state = 11},
  [349] = {.lex_state = 11},
  [350] = {.lex_state = 11},
  [351] = {.lex_state = 11},
  [352] = {.lex_state = 11},
  [353] = {.lex_state = 11},
  [354] = {.lex_state = 11},
  [355] = {.lex_state = 11},
  [356] = {.lex_state = 11},
  [357] = {.lex_state = 11},
  [358] = {.lex_state = 11},
  [359] = {.lex_state = 11},
  [360] = {.lex_state = 11},
  [361] = {.lex_state = 11},
  [362] = {.lex_state = 11},
  [363] = {.lex_state = 11},
  [364] = {.lex_state = 11},
  [365] = {.lex_state = 11},
  [366] = {.lex_state = 11},
  [367] = {.lex_state = 11},
  [368] = {.lex_state = 11},
  [369] = {.lex_state = 11},
  [370] = {.lex_state = 11},
  [371] = {.lex_state = 11},
  [372] = {.lex_state = 11},
  [373] = {.lex_state = 11},
  [374] = {.lex_state = 11},
  [375] = {.lex_state = 11},
  [376] = {.lex_state = 11},
  [377] = {.lex_state = 11},
  [378] = {.lex_state = 11},
  [379] = {.lex_state = 11},
  [380] = {.lex_state = 11},
  [381] = {.lex_state = 11},
  [382] = {.lex_state = 11},
  [383] = {.lex_state = 11},
  [384] = {.lex_state = 11},
  [385] = {.lex_state = 11},
  [386] = {.lex_state = 11},
  [387] = {.lex_state = 11},
  [388] = {.lex_state = 11},
  [389] = {.lex_state = 11},
  [390] = {.lex_state = 11},
  [391] = {.lex_state = 11},
  [392] = {.lex_state = 11},
  [393] = {.lex_state = 11},
  [394] = {.lex_state = 11},
  [395] = {.lex_state = 11},
  [396] = {.lex_state = 11},
  [397] = {.lex_state = 11},
  [398] = {.lex_state = 11},
  [399] = {.lex_state = 11},
  [400] = {.lex_state = 11},
  [401] = {.lex_state = 11},
  [402] = {.lex_state = 11},
  [403] = {.lex_state = 11},
  [404] = {.lex_state = 11},
  [405] = {.lex_state = 11},
  [406] = {.lex_state = 11},
  [407] = {.lex_state = 11},
  [408] = {.lex_state = 11},
  [409] = {.lex_state = 11},
  [410] = {.lex_state = 11},
  [411] = {.lex_state = 11},
  [412] = {.lex_state = 11},
  [413] = {.lex_state = 11},
  [414] = {.lex_state = 11},
  [415] = {.lex_state = 11},
  [416] = {.lex_state = 11},
  [417] = {.lex_state = 11},
  [418] = {.lex_state = 11},
  [419] = {.lex_state = 11},
  [420] = {.lex_state = 11},
  [421] = {.lex_state = 11},
  [422] = {.lex_state = 11},
  [423] = {.lex_state = 11},
  [424] = {.lex_state = 11},
  [425] = {.lex_state = 11},
  [426] = {.lex_state = 11},
  [427] = {.lex_state = 11},
  [428] = {.lex_state = 11},
  [429] = {.lex_state = 11},
  [430] = {.lex_state = 11},
  [431] = {.lex_state = 11},
  [432] = {.lex_state = 11},
  [433] = {.lex_state = 11},
  [434] = {.lex_state = 11},
  [435] = {.lex_state = 11},
  [436] = {.lex_state = 11},
  [437] = {.lex_state = 11},
  [438] = {.lex_state = 11},
  [439] = {.lex_state = 11},
  [440] = {.lex_state = 11},
  [441] = {.lex_state = 11},
  [442] = {.lex_state = 11},
  [443] = {.lex_state = 11},
  [444] = {.lex_state = 11},
  [445] = {.lex_state = 11},
  [446] = {.lex_state = 11},
  [447] = {.lex_state = 11},
  [448] = {.lex_state = 11},
  [449] = {.lex_state = 11},
  [450] = {.lex_state = 11},
  [451] = {.lex_state = 11},
  [452] = {.lex_state = 11},
  [453] = {.lex_state = 11},
  [454] = {.lex_state = 11},
  [455] = {.lex_state = 11},
  [456] = {.lex_state = 11},
  [457] = {.lex_state = 11},
  [458] = {.lex_state = 11},
  [459] = {.lex_state = 11},
  [460] = {.lex_state = 11},
  [461] = {.lex_state = 11},
  [462] = {.lex_state = 11},
  [463] = {.lex_state = 11},
  [464] = {.lex_state = 11},
  [465] = {.lex_state = 11},
  [466] = {.lex_state = 11},
  [467] = {.lex_state = 11},
  [468] = {.lex_state = 11},
  [469] = {.lex_state = 11},
  [470] = {.lex_state = 11},
  [471] = {.lex_state = 11},
  [472] = {.lex_state = 11},
  [473] = {.lex_state = 11},
  [474] = {.lex_state = 11},
  [475] = {.lex_state = 11},
  [476] = {.lex_state = 11},
  [477] = {.lex_state = 11},
  [478] = {.lex_state = 11},
  [479] = {.lex_state = 11},
  [480] = {.lex_state = 11},
  [481] = {.lex_state = 11},
  [482] = {.lex_state = 11},
  [483] = {.lex_state = 11},
  [484] = {.lex_state = 11},
  [485] = {.lex_state = 11},
  [486] = {.lex_state = 11},
  [487] = {.lex_state = 11},
  [488] = {.lex_state = 11},
  [489] = {.lex_state = 11},
  [490] = {.lex_state = 11},
  [491] = {.lex_state = 11},
  [492] = {.lex_state = 11},
  [493] = {.lex_state = 11},
  [494] = {.lex_state = 11},
  [495] = {.lex_state = 11},
  [496] = {.lex_state = 11},
  [497] = {.lex_state = 11},
  [498] = {.lex_state = 11},
  [499] = {.lex_state = 11},
  [500] = {.lex_state = 11},
  [501] = {.lex_state = 11},
  [502] = {.lex_state = 11},
  [503] = {.lex_state = 11},
  [504] = {.lex_state = 11},
  [505] = {.lex_state = 11},
  [506] = {.lex_state = 11},
  [507] = {.lex_state = 11},
  [508] = {.lex_state = 11},
  [509] = {.lex_state = 11},
  [510] = {.lex_state = 11},
  [511] = {.lex_state = 11},
  [512] = {.lex_state = 11},
  [513] = {.lex_state = 11},
  [514] = {.lex_state = 11},
  [515] = {.lex_state = 11},
  [516] = {.lex_state = 11},
  [517] = {.lex_state = 11},
  [518] = {.lex_state = 11},
  [519] = {.lex_state = 11},
  [520] = {.lex_state = 11},
  [521] = {.lex_state = 11},
  [522] = {.lex_state = 11},
  [523] = {.lex_state = 11},
  [524] = {.lex_state = 11},
  [525] = {.lex_state = 11},
  [526] = {.lex_state = 11},
  [527] = {.lex_state = 11},
  [528] = {.lex_state = 11},
  [529] = {.lex_state = 11},
  [530] = {.lex_state = 11},
  [531] = {.lex_state = 11},
  [532] = {.lex_state = 11},
  [533] = {.lex_state = 11},
  [534] = {.lex_state = 11},
  [535] = {.lex_state = 11},
  [536] = {.lex_state = 11},
  [537] = {.lex_state = 11},
  [538] = {.lex_state = 11},
  [539] = {.lex_state = 11},
  [540] = {.lex_state = 11},
  [541] = {.lex_state = 11},
  [542] = {.lex_state = 11},
  [543] = {.lex_state = 11},
  [544] = {.lex_state = 11},
  [545] = {.lex_state = 11},
  [546] = {.lex_state = 11},
  [547] = {.lex_state = 11},
  [548] = {.lex_state = 11},
  [549] = {.lex_state = 11},
  [550] = {.lex_state = 11},
  [551] = {.lex_state = 11},
  [552] = {.lex_state = 11},
  [553] = {.lex_state = 11},
  [554] = {.lex_state = 11},
  [555] = {.lex_state = 11},
  [556] = {.lex_state = 11},
  [557] = {.lex_state = 11},
  [558] = {.lex_state = 11},
  [559] = {.lex_state = 11},
  [560] = {.lex_state = 11},
  [561] = {.lex_state = 11},
  [562] = {.lex_state = 11},
  [563] = {.lex_state = 11},
  [564] = {.lex_state = 11},
  [565] = {.lex_state = 11},
  [566] = {.lex_state = 11},
  [567] = {.lex_state = 11},
  [568] = {.lex_state = 11},
  [569] = {.lex_state = 11},
  [570] = {.lex_state = 11},
  [571] = {.lex_state = 11},
  [572] = {.lex_state = 11},
  [573] = {.lex_state = 11},
  [574] = {.lex_state = 11},
  [575] = {.lex_state = 11},
  [576] = {.lex_state = 11},
  [577] = {.lex_state = 11},
  [578] = {.lex_state = 11},
  [579] = {.lex_state = 11},
  [580] = {.lex_state = 11},
  [581] = {.lex_state = 11},
  [582] = {.lex_state = 11},
  [583] = {.lex_state = 11},
  [584] = {.lex_state = 11},
  [585] = {.lex_state = 11},
  [586] = {.lex_state = 11},
  [587] = {.lex_state = 3, .external_lex_state = 3},
  [588] = {.lex_state = 3, .external_lex_state = 3},
  [589] = {.lex_state = 3, .external_lex_state = 3},
  [590] = {.lex_state = 3, .external_lex_state = 3},
  [591] = {.lex_state = 5, .external_lex_state = 3},
  [592] = {.lex_state = 5, .external_lex_state = 3},
  [593] = {.lex_state = 5, .external_lex_state = 3},
  [594] = {.lex_state = 5, .external_lex_state = 3},
  [595] = {.lex_state = 3, .external_lex_state = 3},
  [596] = {.lex_state = 3, .external_lex_state = 3},
  [597] = {.lex_state = 3, .external_lex_state = 3},
  [598] = {.lex_state = 3, .external_lex_state = 3},
  [599] = {.lex_state = 3, .external_lex_state = 3},
  [600] = {.lex_state = 3, .external_lex_state = 3},
  [601] = {.lex_state = 3, .external_lex_state = 3},
  [602] = {.lex_state = 3, .external_lex_state = 3},
  [603] = {.lex_state = 3, .external_lex_state = 3},
  [604] = {.lex_state = 3, .external_lex_state = 3},
  [605] = {.lex_state = 3, .external_lex_state = 3},
  [606] = {.lex_state = 3, .external_lex_state = 3},
  [607] = {.lex_state = 5, .external_lex_state = 3},
  [608] = {.lex_state = 11},
  [609] = {.lex_state = 11},
  [610] = {.lex_state = 11},
  [611] = {.lex_state = 5, .external_lex_state = 3},
  [612] = {.lex_state = 11},
  [613] = {.lex_state = 11},
  [614] = {.lex_state = 5, .external_lex_state = 3},
  [615] = {.lex_state = 5, .external_lex_state = 3},
  [616] = {.lex_state = 5, .external_lex_state = 3},
  [617] = {.lex_state = 5, .external_lex_state = 3},
  [618] = {.lex_state = 5, .external_lex_state = 3},
  [619] = {.lex_state = 3, .external_lex_state = 3},
  [620] = {.lex_state = 3, .external_lex_state = 3},
  [621] = {.lex_state = 3, .external_lex_state = 3},
  [622] = {.lex_state = 3, .external_lex_state = 3},
  [623] = {.lex_state = 3, .external_lex_state = 3},
  [624] = {.lex_state = 3, .external_lex_state = 3},
  [625] = {.lex_state = 3, .external_lex_state = 3},
  [626] = {.lex_state = 3, .external_lex_state = 3},
  [627] = {.lex_state = 5, .external_lex_state = 3},
  [628] = {.lex_state = 5, .external_lex_state = 3},
  [629] = {.lex_state = 5, .external_lex_state = 3},
  [630] = {.lex_state = 5, .external_lex_state = 2},
  [631] = {.lex_state = 5, .external_lex_state = 2},
  [632] = {.lex_state = 5, .external_lex_state = 2},
  [633] = {.lex_state = 5, .external_lex_state = 2},
  [634] = {.lex_state = 5, .external_lex_state = 3},
  [635] = {.lex_state = 5, .external_lex_state = 2},
  [636] = {.lex_state = 5, .external_lex_state = 3},
  [637] = {.lex_state = 5, .external_lex_state = 3},
  [638] = {.lex_state = 5, .external_lex_state = 3},
  [639] = {.lex_state = 5, .external_lex_state = 3},
  [640] = {.lex_state = 5, .external_lex_state = 2},
  [641] = {.lex_state = 5, .external_lex_state = 3},
  [642] = {.lex_state = 5, .external_lex_state = 3},
  [643] = {.lex_state = 5, .external_lex_state = 3},
  [644] = {.lex_state = 5, .external_lex_state = 3},
  [645] = {.lex_state = 5, .external_lex_state = 2},
  [646] = {.lex_state = 5, .external_lex_state = 3},
  [647] = {.lex_state = 5, .external_lex_state = 3},
  [648] = {.lex_state = 5, .external_lex_state = 3},
  [649] = {.lex_state = 5, .external_lex_state = 2},
  [650] = {.lex_state = 5, .external_lex_state = 3},
  [651] = {.lex_state = 11},
  [652] = {.lex_state = 5, .external_lex_state = 2},
  [653] = {.lex_state = 5, .external_lex_state = 3},
  [654] = {.lex_state = 5, .external_lex_state = 2},
  [655] = {.lex_state = 5, .external_lex_state = 2},
  [656] = {.lex_state = 5, .external_lex_state = 3},
  [657] = {.lex_state = 5, .external_lex_state = 3},
  [658] = {.lex_state = 5, .external_lex_state = 3},
  [659] = {.lex_state = 11, .external_lex_state = 4},
  [660] = {.lex_state = 11, .external_lex_state = 4},
  [661] = {.lex_state = 5, .external_lex_state = 2},
  [662] = {.lex_state = 5, .external_lex_state = 3},
  [663] = {.lex_state = 5, .external_lex_state = 2},
  [664] = {.lex_state = 11, .external_lex_state = 4},
  [665] = {.lex_state = 11, .external_lex_state = 4},
  [666] = {.lex_state = 5, .external_lex_state = 3},
  [667] = {.lex_state = 5, .external_lex_state = 3},
  [668] = {.lex_state = 5, .external_lex_state = 2},
  [669] = {.lex_state = 5, .external_lex_state = 2},
  [670] = {.lex_state = 5, .external_lex_state = 2},
  [671] = {.lex_state = 11},
  [672] = {.lex_state = 11},
  [673] = {.lex_state = 5, .external_lex_state = 2},
  [674] = {.lex_state = 11},
  [675] = {.lex_state = 11},
  [676] = {.lex_state = 11, .external_lex_state = 4},
  [677] = {.lex_state = 11, .external_lex_state = 4},
  [678] = {.lex_state = 11},
  [679] = {.lex_state = 11},
  [680] = {.lex_state = 11, .external_lex_state = 4},
  [681] = {.lex_state = 11},
  [682] = {.lex_state = 11},
  [683] = {.lex_state = 11, .external_lex_state = 4},
  [684] = {.lex_state = 11, .external_lex_state = 4},
  [685] = {.lex_state = 11, .external_lex_state = 4},
  [686] = {.lex_state = 11},
  [687] = {.lex_state = 11, .external_lex_state = 4},
  [688] = {.lex_state = 11, .external_lex_state = 4},
  [689] = {.lex_state = 11, .external_lex_state = 4},
  [690] = {.lex_state = 11, .external_lex_state = 4},
  [691] = {.lex_state = 11, .external_lex_state = 4},
  [692] = {.lex_state = 11, .external_lex_state = 4},
  [693] = {.lex_state = 5, .external_lex_state = 2},
  [694] = {.lex_state = 5, .external_lex_state = 2},
  [695] = {.lex_state = 11},
  [696] = {.lex_state = 11},
  [697] = {.lex_state = 5, .external_lex_state = 2},
  [698] = {.lex_state = 5, .external_lex_state = 2},
  [699] = {.lex_state = 11, .external_lex_state = 4},
  [700] = {.lex_state = 11, .external_lex_state = 4},
  [701] = {.lex_state = 11, .external_lex_state = 4},
  [702] = {.lex_state = 11, .external_lex_state = 4},
  [703] = {.lex_state = 11},
  [704] = {.lex_state = 11},
  [705] = {.lex_state = 11},
  [706] = {.lex_state = 11},
  [707] = {.lex_state = 11},
  [708] = {.lex_state = 11},
  [709] = {.lex_state = 11},
  [710] = {.lex_state = 11},
  [711] = {.lex_state = 11},
  [712] = {.lex_state = 11},
  [713] = {.lex_state = 11},
  [714] = {.lex_state = 11},
  [715] = {.lex_state = 11},
  [716] = {.lex_state = 11},
  [717] = {.lex_state = 11},
  [718] = {.lex_state = 11},
  [719] = {.lex_state = 11},
  [720] = {.lex_state = 11},
  [721] = {.lex_state = 11},
  [722] = {.lex_state = 11},
  [723] = {.lex_state = 11},
  [724] = {.lex_state = 11},
  [725] = {.lex_state = 11},
  [726] = {.lex_state = 11},
  [727] = {.lex_state = 11},
  [728] = {.lex_state = 11},
  [729] = {.lex_state = 11},
  [730] = {.lex_state = 11},
  [731] = {.lex_state = 11},
  [732] = {.lex_state = 11},
  [733] = {.lex_state = 11},
  [734] = {.lex_state = 11},
  [735] = {.lex_state = 11},
  [736] = {.lex_state = 11},
  [737] = {.lex_state = 11},
  [738] = {.lex_state = 11},
  [739] = {.lex_state = 11},
  [740] = {.lex_state = 11},
  [741] = {.lex_state = 11},
  [742] = {.lex_state = 11},
  [743] = {.lex_state = 11},
  [744] = {.lex_state = 11},
  [745] = {.lex_state = 11},
  [746] = {.lex_state = 11},
  [747] = {.lex_state = 11},
  [748] = {.lex_state = 11},
  [749] = {.lex_state = 11},
  [750] = {.lex_state = 11},
  [751] = {.lex_state = 11},
  [752] = {.lex_state = 11},
  [753] = {.lex_state = 11},
  [754] = {.lex_state = 11},
  [755] = {.lex_state = 11},
  [756] = {.lex_state = 11},
  [757] = {.lex_state = 11},
  [758] = {.lex_state = 11},
  [759] = {.lex_state = 11},
  [760] = {.lex_state = 11},
  [761] = {.lex_state = 11},
  [762] = {.lex_state = 11},
  [763] = {.lex_state = 11},
  [764] = {.lex_state = 11},
  [765] = {.lex_state = 11},
  [766] = {.lex_state = 11},
  [767] = {.lex_state = 11},
  [768] = {.lex_state = 11},
  [769] = {.lex_state = 11},
  [770] = {.lex_state = 11},
  [771] = {.lex_state = 11},
  [772] = {.lex_state = 11},
  [773] = {.lex_state = 11},
  [774] = {.lex_state = 11},
  [775] = {.lex_state = 11},
  [776] = {.lex_state = 11},
  [777] = {.lex_state = 11},
  [778] = {.lex_state = 11},
  [779] = {.lex_state = 11},
  [780] = {.lex_state = 11},
  [781] = {.lex_state = 11},
  [782] = {.lex_state = 11},
  [783] = {.lex_state = 11},
  [784] = {.lex_state = 11},
  [785] = {.lex_state = 11},
  [786] = {.lex_state = 11},
  [787] = {.lex_state = 11},
  [788] = {.lex_state = 11},
  [789] = {.lex_state = 11},
  [790] = {.lex_state = 11},
  [791] = {.lex_state = 11},
  [792] = {.lex_state = 11},
  [793] = {.lex_state = 11},
  [794] = {.lex_state = 11},
  [795] = {.lex_state = 11},
  [796] = {.lex_state = 11},
  [797] = {.lex_state = 11},
  [798] = {.lex_state = 11},
  [799] = {.lex_state = 11},
  [800] = {.lex_state = 11},
  [801] = {.lex_state = 11},
  [802] = {.lex_state = 11},
  [803] = {.lex_state = 11},
  [804] = {.lex_state = 11},
  [805] = {.lex_state = 11},
  [806] = {.lex_state = 11},
  [807] = {.lex_state = 11},
  [808] = {.lex_state = 11},
  [809] = {.lex_state = 11},
  [810] = {.lex_state = 11},
  [811] = {.lex_state = 11},
  [812] = {.lex_state = 11},
  [813] = {.lex_state = 11},
  [814] = {.lex_state = 11},
  [815] = {.lex_state = 11},
  [816] = {.lex_state = 11},
  [817] = {.lex_state = 11},
  [818] = {.lex_state = 11},
  [819] = {.lex_state = 11},
  [820] = {.lex_state = 11},
  [821] = {.lex_state = 11},
  [822] = {.lex_state = 11},
  [823] = {.lex_state = 11},
  [824] = {.lex_state = 11},
  [825] = {.lex_state = 11},
  [826] = {.lex_state = 11},
  [827] = {.lex_state = 11},
  [828] = {.lex_state = 11},
  [829] = {.lex_state = 11},
  [830] = {.lex_state = 11},
  [831] = {.lex_state = 11},
  [832] = {.lex_state = 11},
  [833] = {.lex_state = 11},
  [834] = {.lex_state = 11},
  [835] = {.lex_state = 11},
  [836] = {.lex_state = 11},
  [837] = {.lex_state = 11},
  [838] = {.lex_state = 11},
  [839] = {.lex_state = 11},
  [840] = {.lex_state = 11},
  [841] = {.lex_state = 11},
  [842] = {.lex_state = 11},
  [843] = {.lex_state = 11},
  [844] = {.lex_state = 11},
  [845] = {.lex_state = 11},
  [846] = {.lex_state = 11},
  [847] = {.lex_state = 11},
  [848] = {.lex_state = 11},
  [849] = {.lex_state = 11},
  [850] = {.lex_state = 11},
  [851] = {.lex_state = 11},
  [852] = {.lex_state = 11},
  [853] = {.lex_state = 11},
  [854] = {.lex_state = 11},
  [855] = {.lex_state = 11},
  [856] = {.lex_state = 11},
  [857] = {.lex_state = 11},
  [858] = {.lex_state = 11},
  [859] = {.lex_state = 11},
  [860] = {.lex_state = 11},
  [861] = {.lex_state = 11},
  [862] = {.lex_state = 11},
  [863] = {.lex_state = 11},
  [864] = {.lex_state = 11},
  [865] = {.lex_state = 7, .external_lex_state = 3},
  [866] = {.lex_state = 7, .external_lex_state = 3},
  [867] = {.lex_state = 12},
  [868] = {.lex_state = 12},
  [869] = {.lex_state = 7, .external_lex_state = 3},
  [870] = {.lex_state = 12},
  [871] = {.lex_state = 12},
  [872] = {.lex_state = 12},
  [873] = {.lex_state = 7, .external_lex_state = 3},
  [874] = {.lex_state = 7, .external_lex_state = 3},
  [875] = {.lex_state = 7, .external_lex_state = 3},
  [876] = {.lex_state = 7, .external_lex_state = 3},
  [877] = {.lex_state = 7, .external_lex_state = 3},
  [878] = {.lex_state = 7, .external_lex_state = 3},
  [879] = {.lex_state = 7, .external_lex_state = 3},
  [880] = {.lex_state = 7, .external_lex_state = 3},
  [881] = {.lex_state = 7, .external_lex_state = 3},
  [882] = {.lex_state = 7, .external_lex_state = 3},
  [883] = {.lex_state = 11},
  [884] = {.lex_state = 16},
  [885] = {.lex_state = 16},
  [886] = {.lex_state = 16},
  [887] = {.lex_state = 12},
  [888] = {.lex_state = 16},
  [889] = {.lex_state = 12},
  [890] = {.lex_state = 12},
  [891] = {.lex_state = 7, .external_lex_state = 3},
  [892] = {.lex_state = 16},
  [893] = {.lex_state = 16},
  [894] = {.lex_state = 12},
  [895] = {.lex_state = 16},
  [896] = {.lex_state = 7, .external_lex_state = 3},
  [897] = {.lex_state = 16},
  [898] = {.lex_state = 7, .external_lex_state = 3},
  [899] = {.lex_state = 11},
  [900] = {.lex_state = 7, .external_lex_state = 3},
  [901] = {.lex_state = 16},
  [902] = {.lex_state = 7, .external_lex_state = 3},
  [903] = {.lex_state = 16},
  [904] = {.lex_state = 7, .external_lex_state = 3},
  [905] = {.lex_state = 7, .external_lex_state = 3},
  [906] = {.lex_state = 16},
  [907] = {.lex_state = 11},
  [908] = {.lex_state = 7, .external_lex_state = 3},
  [909] = {.lex_state = 7, .external_lex_state = 3},
  [910] = {.lex_state = 7, .external_lex_state = 3},
  [911] = {.lex_state = 7, .external_lex_state = 3},
  [912] = {.lex_state = 12},
  [913] = {.lex_state = 12},
  [914] = {.lex_state = 12},
  [915] = {.lex_state = 16},
  [916] = {.lex_state = 7, .external_lex_state = 3},
  [917] = {.lex_state = 7, .external_lex_state = 3},
  [918] = {.lex_state = 12},
  [919] = {.lex_state = 12},
  [920] = {.lex_state = 16},
  [921] = {.lex_state = 7, .external_lex_state = 3},
  [922] = {.lex_state = 12},
  [923] = {.lex_state = 12},
  [924] = {.lex_state = 16},
  [925] = {.lex_state = 16},
  [926] = {.lex_state = 5, .external_lex_state = 3},
  [927] = {.lex_state = 12},
  [928] = {.lex_state = 5, .external_lex_state = 3},
  [929] = {.lex_state = 5, .external_lex_state = 3},
  [930] = {.lex_state = 5, .external_lex_state = 3},
  [931] = {.lex_state = 5, .external_lex_state = 3},
  [932] = {.lex_state = 5, .external_lex_state = 3},
  [933] = {.lex_state = 5, .external_lex_state = 3},
  [934] = {.lex_state = 12},
  [935] = {.lex_state = 12},
  [936] = {.lex_state = 5, .external_lex_state = 3},
  [937] = {.lex_state = 12},
  [938] = {.lex_state = 12},
  [939] = {.lex_state = 12},
  [940] = {.lex_state = 12},
  [941] = {.lex_state = 12},
  [942] = {.lex_state = 12},
  [943] = {.lex_state = 12},
  [944] = {.lex_state = 12},
  [945] = {.lex_state = 12},
  [946] = {.lex_state = 12},
  [947] = {.lex_state = 12},
  [948] = {.lex_state = 12},
  [949] = {.lex_state = 12},
  [950] = {.lex_state = 12},
  [951] = {.lex_state = 12},
  [952] = {.lex_state = 12},
  [953] = {.lex_state = 12},
  [954] = {.lex_state = 12},
  [955] = {.lex_state = 12},
  [956] = {.lex_state = 12},
  [957] = {.lex_state = 12},
  [958] = {.lex_state = 12},
  [959] = {.lex_state = 12},
  [960] = {.lex_state = 12},
  [961] = {.lex_state = 12},
  [962] = {.lex_state = 12},
  [963] = {.lex_state = 12},
  [964] = {.lex_state = 12},
  [965] = {.lex_state = 12},
  [966] = {.lex_state = 12},
  [967] = {.lex_state = 12},
  [968] = {.lex_state = 12},
  [969] = {.lex_state = 12},
  [970] = {.lex_state = 12},
  [971] = {.lex_state = 12},
  [972] = {.lex_state = 12},
  [973] = {.lex_state = 12},
  [974] = {.lex_state = 12},
  [975] = {.lex_state = 12},
  [976] = {.lex_state = 12},
  [977] = {.lex_state = 12},
  [978] = {.lex_state = 12},
  [979] = {.lex_state = 12},
  [980] = {.lex_state = 12},
  [981] = {.lex_state = 12},
  [982] = {.lex_state = 12},
  [983] = {.lex_state = 12},
  [984] = {.lex_state = 12},
  [985] = {.lex_state = 12},
  [986] = {.lex_state = 12},
  [987] = {.lex_state = 12},
  [988] = {.lex_state = 12},
  [989] = {.lex_state = 12},
  [990] = {.lex_state = 12},
  [991] = {.lex_state = 12},
  [992] = {.lex_state = 12},
  [993] = {.lex_state = 12},
  [994] = {.lex_state = 12},
  [995] = {.lex_state = 12},
  [996] = {.lex_state = 12},
  [997] = {.lex_state = 12},
  [998] = {.lex_state = 12},
  [999] = {.lex_state = 12},
  [1000] = {.lex_state = 12},
  [1001] = {.lex_state = 12},
  [1002] = {.lex_state = 5, .external_lex_state = 2},
  [1003] = {.lex_state = 12},
  [1004] = {.lex_state = 12},
  [1005] = {.lex_state = 12},
  [1006] = {.lex_state = 12},
  [1007] = {.lex_state = 12},
  [1008] = {.lex_state = 12},
  [1009] = {.lex_state = 12},
  [1010] = {.lex_state = 12},
  [1011] = {.lex_state = 12},
  [1012] = {.lex_state = 12},
  [1013] = {.lex_state = 12},
  [1014] = {.lex_state = 12},
  [1015] = {.lex_state = 12},
  [1016] = {.lex_state = 12},
  [1017] = {.lex_state = 12},
  [1018] = {.lex_state = 12},
  [1019] = {.lex_state = 12},
  [1020] = {.lex_state = 12},
  [1021] = {.lex_state = 12},
  [1022] = {.lex_state = 12},
  [1023] = {.lex_state = 12},
  [1024] = {.lex_state = 12},
  [1025] = {.lex_state = 12},
  [1026] = {.lex_state = 12},
  [1027] = {.lex_state = 12},
  [1028] = {.lex_state = 12},
  [1029] = {.lex_state = 12},
  [1030] = {.lex_state = 12},
  [1031] = {.lex_state = 12},
  [1032] = {.lex_state = 5, .external_lex_state = 2},
  [1033] = {.lex_state = 12},
  [1034] = {.lex_state = 12},
  [1035] = {.lex_state = 12},
  [1036] = {.lex_state = 12},
  [1037] = {.lex_state = 12},
  [1038] = {.lex_state = 12},
  [1039] = {.lex_state = 12},
  [1040] = {.lex_state = 12},
  [1041] = {.lex_state = 12},
  [1042] = {.lex_state = 12},
  [1043] = {.lex_state = 12},
  [1044] = {.lex_state = 12},
  [1045] = {.lex_state = 12},
  [1046] = {.lex_state = 12},
  [1047] = {.lex_state = 12},
  [1048] = {.lex_state = 12},
  [1049] = {.lex_state = 12},
  [1050] = {.lex_state = 12},
  [1051] = {.lex_state = 12},
  [1052] = {.lex_state = 12},
  [1053] = {.lex_state = 12},
  [1054] = {.lex_state = 12},
  [1055] = {.lex_state = 12},
  [1056] = {.lex_state = 12},
  [1057] = {.lex_state = 12},
  [1058] = {.lex_state = 5, .external_lex_state = 2},
  [1059] = {.lex_state = 12},
  [1060] = {.lex_state = 12},
  [1061] = {.lex_state = 12},
  [1062] = {.lex_state = 12},
  [1063] = {.lex_state = 12},
  [1064] = {.lex_state = 12},
  [1065] = {.lex_state = 12},
  [1066] = {.lex_state = 12},
  [1067] = {.lex_state = 12},
  [1068] = {.lex_state = 12},
  [1069] = {.lex_state = 12},
  [1070] = {.lex_state = 12},
  [1071] = {.lex_state = 12},
  [1072] = {.lex_state = 12},
  [1073] = {.lex_state = 12},
  [1074] = {.lex_state = 12},
  [1075] = {.lex_state = 12},
  [1076] = {.lex_state = 12},
  [1077] = {.lex_state = 12},
  [1078] = {.lex_state = 12},
  [1079] = {.lex_state = 12},
  [1080] = {.lex_state = 12},
  [1081] = {.lex_state = 12},
  [1082] = {.lex_state = 12},
  [1083] = {.lex_state = 12},
  [1084] = {.lex_state = 12},
  [1085] = {.lex_state = 12},
  [1086] = {.lex_state = 12},
  [1087] = {.lex_state = 12},
  [1088] = {.lex_state = 12},
  [1089] = {.lex_state = 12},
  [1090] = {.lex_state = 12},
  [1091] = {.lex_state = 12},
  [1092] = {.lex_state = 12},
  [1093] = {.lex_state = 12},
  [1094] = {.lex_state = 12},
  [1095] = {.lex_state = 12},
  [1096] = {.lex_state = 12},
  [1097] = {.lex_state = 12},
  [1098] = {.lex_state = 12},
  [1099] = {.lex_state = 12},
  [1100] = {.lex_state = 5, .external_lex_state = 2},
  [1101] = {.lex_state = 5, .external_lex_state = 3},
  [1102] = {.lex_state = 5, .external_lex_state = 3},
  [1103] = {.lex_state = 5, .external_lex_state = 2},
  [1104] = {.lex_state = 5, .external_lex_state = 3},
  [1105] = {.lex_state = 5, .external_lex_state = 3},
  [1106] = {.lex_state = 5, .external_lex_state = 3},
  [1107] = {.lex_state = 11},
  [1108] = {.lex_state = 5, .external_lex_state = 3},
  [1109] = {.lex_state = 5, .external_lex_state = 3},
  [1110] = {.lex_state = 11},
  [1111] = {.lex_state = 5, .external_lex_state = 3},
  [1112] = {.lex_state = 5, .external_lex_state = 3},
  [1113] = {.lex_state = 5, .external_lex_state = 3},
  [1114] = {.lex_state = 5, .external_lex_state = 3},
  [1115] = {.lex_state = 5, .external_lex_state = 2},
  [1116] = {.lex_state = 5, .external_lex_state = 2},
  [1117] = {.lex_state = 5, .external_lex_state = 3},
  [1118] = {.lex_state = 5, .external_lex_state = 3},
  [1119] = {.lex_state = 11},
  [1120] = {.lex_state = 11},
  [1121] = {.lex_state = 5, .external_lex_state = 3},
  [1122] = {.lex_state = 11},
  [1123] = {.lex_state = 5, .external_lex_state = 3},
  [1124] = {.lex_state = 11},
  [1125] = {.lex_state = 5, .external_lex_state = 3},
  [1126] = {.lex_state = 11},
  [1127] = {.lex_state = 5, .external_lex_state = 2},
  [1128] = {.lex_state = 11},
  [1129] = {.lex_state = 11},
  [1130] = {.lex_state = 5, .external_lex_state = 3},
  [1131] = {.lex_state = 5, .external_lex_state = 2},
  [1132] = {.lex_state = 5, .external_lex_state = 2},
  [1133] = {.lex_state = 11},
  [1134] = {.lex_state = 5, .external_lex_state = 3},
  [1135] = {.lex_state = 5, .external_lex_state = 2},
  [1136] = {.lex_state = 5, .external_lex_state = 2},
  [1137] = {.lex_state = 5, .external_lex_state = 2},
  [1138] = {.lex_state = 5, .external_lex_state = 3},
  [1139] = {.lex_state = 5, .external_lex_state = 3},
  [1140] = {.lex_state = 5, .external_lex_state = 2},
  [1141] = {.lex_state = 5, .external_lex_state = 3},
  [1142] = {.lex_state = 5, .external_lex_state = 3},
  [1143] = {.lex_state = 5, .external_lex_state = 3},
  [1144] = {.lex_state = 5, .external_lex_state = 3},
  [1145] = {.lex_state = 5, .external_lex_state = 2},
  [1146] = {.lex_state = 5, .external_lex_state = 2},
  [1147] = {.lex_state = 5, .external_lex_state = 3},
  [1148] = {.lex_state = 5, .external_lex_state = 3},
  [1149] = {.lex_state = 5, .external_lex_state = 2},
  [1150] = {.lex_state = 5, .external_lex_state = 3},
  [1151] = {.lex_state = 5, .external_lex_state = 3},
  [1152] = {.lex_state = 5, .external_lex_state = 2},
  [1153] = {.lex_state = 5, .external_lex_state = 3},
  [1154] = {.lex_state = 5, .external_lex_state = 3},
  [1155] = {.lex_state = 5, .external_lex_state = 3},
  [1156] = {.lex_state = 5, .external_lex_state = 3},
  [1157] = {.lex_state = 5, .external_lex_state = 2},
  [1158] = {.lex_state = 5, .external_lex_state = 3},
  [1159] = {.lex_state = 5, .external_lex_state = 2},
  [1160] = {.lex_state = 5, .external_lex_state = 2},
  [1161] = {.lex_state = 5, .external_lex_state = 2},
  [1162] = {.lex_state = 5, .external_lex_state = 2},
  [1163] = {.lex_state = 12},
  [1164] = {.lex_state = 12},
  [1165] = {.lex_state = 12},
  [1166] = {.lex_state = 5, .external_lex_state = 2},
  [1167] = {.lex_state = 5, .external_lex_state = 2},
  [1168] = {.lex_state = 5, .external_lex_state = 3},
  [1169] = {.lex_state = 5, .external_lex_state = 2},
  [1170] = {.lex_state = 12},
  [1171] = {.lex_state = 12},
  [1172] = {.lex_state = 12},
  [1173] = {.lex_state = 5, .external_lex_state = 3},
  [1174] = {.lex_state = 5, .external_lex_state = 2},
  [1175] = {.lex_state = 5, .external_lex_state = 2},
  [1176] = {.lex_state = 5, .external_lex_state = 2},
  [1177] = {.lex_state = 5, .external_lex_state = 2},
  [1178] = {.lex_state = 5, .external_lex_state = 2},
  [1179] = {.lex_state = 5, .external_lex_state = 2},
  [1180] = {.lex_state = 5, .external_lex_state = 2},
  [1181] = {.lex_state = 12},
  [1182] = {.lex_state = 5, .external_lex_state = 3},
  [1183] = {.lex_state = 5, .external_lex_state = 2},
  [1184] = {.lex_state = 5, .external_lex_state = 3},
  [1185] = {.lex_state = 5, .external_lex_state = 2},
  [1186] = {.lex_state = 5, .external_lex_state = 2},
  [1187] = {.lex_state = 5, .external_lex_state = 2},
  [1188] = {.lex_state = 5, .external_lex_state = 2},
  [1189] = {.lex_state = 5, .external_lex_state = 2},
  [1190] = {.lex_state = 5, .external_lex_state = 2},
  [1191] = {.lex_state = 5, .external_lex_state = 3},
  [1192] = {.lex_state = 5, .external_lex_state = 3},
  [1193] = {.lex_state = 5, .external_lex_state = 2},
  [1194] = {.lex_state = 5, .external_lex_state = 2},
  [1195] = {.lex_state = 5, .external_lex_state = 3},
  [1196] = {.lex_state = 5, .external_lex_state = 2},
  [1197] = {.lex_state = 5, .external_lex_state = 2},
  [1198] = {.lex_state = 12},
  [1199] = {.lex_state = 12},
  [1200] = {.lex_state = 12},
  [1201] = {.lex_state = 5, .external_lex_state = 2},
  [1202] = {.lex_state = 5, .external_lex_state = 3},
  [1203] = {.lex_state = 5, .external_lex_state = 2},
  [1204] = {.lex_state = 5, .external_lex_state = 2},
  [1205] = {.lex_state = 12},
  [1206] = {.lex_state = 12},
  [1207] = {.lex_state = 5, .external_lex_state = 2},
  [1208] = {.lex_state = 5, .external_lex_state = 3},
  [1209] = {.lex_state = 5, .external_lex_state = 3},
  [1210] = {.lex_state = 12},
  [1211] = {.lex_state = 12},
  [1212] = {.lex_state = 5, .external_lex_state = 2},
  [1213] = {.lex_state = 12},
  [1214] = {.lex_state = 5, .external_lex_state = 3},
  [1215] = {.lex_state = 5, .external_lex_state = 2},
  [1216] = {.lex_state = 5, .external_lex_state = 2},
  [1217] = {.lex_state = 12},
  [1218] = {.lex_state = 5, .external_lex_state = 3},
  [1219] = {.lex_state = 12},
  [1220] = {.lex_state = 5, .external_lex_state = 3},
  [1221] = {.lex_state = 12},
  [1222] = {.lex_state = 12},
  [1223] = {.lex_state = 12},
  [1224] = {.lex_state = 5, .external_lex_state = 3},
  [1225] = {.lex_state = 12},
  [1226] = {.lex_state = 12},
  [1227] = {.lex_state = 12},
  [1228] = {.lex_state = 12},
  [1229] = {.lex_state = 5, .external_lex_state = 3},
  [1230] = {.lex_state = 12},
  [1231] = {.lex_state = 12},
  [1232] = {.lex_state = 5, .external_lex_state = 3},
  [1233] = {.lex_state = 5, .external_lex_state = 3},
  [1234] = {.lex_state = 5, .external_lex_state = 2},
  [1235] = {.lex_state = 5, .external_lex_state = 2},
  [1236] = {.lex_state = 12},
  [1237] = {.lex_state = 5, .external_lex_state = 2},
  [1238] = {.lex_state = 5, .external_lex_state = 2},
  [1239] = {.lex_state = 5, .external_lex_state = 3},
  [1240] = {.lex_state = 5, .external_lex_state = 2},
  [1241] = {.lex_state = 5, .external_lex_state = 2},
  [1242] = {.lex_state = 5, .external_lex_state = 2},
  [1243] = {.lex_state = 12},
  [1244] = {.lex_state = 5, .external_lex_state = 2},
  [1245] = {.lex_state = 5, .external_lex_state = 3},
  [1246] = {.lex_state = 5, .external_lex_state = 2},
  [1247] = {.lex_state = 5, .external_lex_state = 3},
  [1248] = {.lex_state = 5, .external_lex_state = 2},
  [1249] = {.lex_state = 5, .external_lex_state = 3},
  [1250] = {.lex_state = 5, .external_lex_state = 3},
  [1251] = {.lex_state = 5, .external_lex_state = 3},
  [1252] = {.lex_state = 5, .external_lex_state = 3},
  [1253] = {.lex_state = 5, .external_lex_state = 3},
  [1254] = {.lex_state = 5, .external_lex_state = 3},
  [1255] = {.lex_state = 5, .external_lex_state = 2},
  [1256] = {.lex_state = 5, .external_lex_state = 2},
  [1257] = {.lex_state = 5, .external_lex_state = 2},
  [1258] = {.lex_state = 5, .external_lex_state = 3},
  [1259] = {.lex_state = 5, .external_lex_state = 3},
  [1260] = {.lex_state = 5, .external_lex_state = 2},
  [1261] = {.lex_state = 5, .external_lex_state = 3},
  [1262] = {.lex_state = 5, .external_lex_state = 3},
  [1263] = {.lex_state = 5, .external_lex_state = 3},
  [1264] = {.lex_state = 5, .external_lex_state = 2},
  [1265] = {.lex_state = 5, .external_lex_state = 2},
  [1266] = {.lex_state = 5, .external_lex_state = 3},
  [1267] = {.lex_state = 5, .external_lex_state = 3},
  [1268] = {.lex_state = 5, .external_lex_state = 2},
  [1269] = {.lex_state = 5, .external_lex_state = 2},
  [1270] = {.lex_state = 5, .external_lex_state = 3},
  [1271] = {.lex_state = 5, .external_lex_state = 3},
  [1272] = {.lex_state = 5, .external_lex_state = 2},
  [1273] = {.lex_state = 5, .external_lex_state = 3},
  [1274] = {.lex_state = 5, .external_lex_state = 3},
  [1275] = {.lex_state = 5, .external_lex_state = 3},
  [1276] = {.lex_state = 5, .external_lex_state = 2},
  [1277] = {.lex_state = 5, .external_lex_state = 3},
  [1278] = {.lex_state = 5, .external_lex_state = 3},
  [1279] = {.lex_state = 5, .external_lex_state = 3},
  [1280] = {.lex_state = 5, .external_lex_state = 2},
  [1281] = {.lex_state = 5, .external_lex_state = 3},
  [1282] = {.lex_state = 5, .external_lex_state = 2},
  [1283] = {.lex_state = 5, .external_lex_state = 3},
  [1284] = {.lex_state = 5, .external_lex_state = 3},
  [1285] = {.lex_state = 5, .external_lex_state = 2},
  [1286] = {.lex_state = 5, .external_lex_state = 3},
  [1287] = {.lex_state = 5, .external_lex_state = 2},
  [1288] = {.lex_state = 5, .external_lex_state = 2},
  [1289] = {.lex_state = 5, .external_lex_state = 3},
  [1290] = {.lex_state = 5, .external_lex_state = 2},
  [1291] = {.lex_state = 12},
  [1292] = {.lex_state = 12},
  [1293] = {.lex_state = 5, .external_lex_state = 2},
  [1294] = {.lex_state = 5, .external_lex_state = 2},
  [1295] = {.lex_state = 5, .external_lex_state = 2},
  [1296] = {.lex_state = 5, .external_lex_state = 2},
  [1297] = {.lex_state = 12},
  [1298] = {.lex_state = 12},
  [1299] = {.lex_state = 12},
  [1300] = {.lex_state = 5, .external_lex_state = 3},
  [1301] = {.lex_state = 5, .external_lex_state = 2},
  [1302] = {.lex_state = 5, .external_lex_state = 2},
  [1303] = {.lex_state = 5, .external_lex_state = 2},
  [1304] = {.lex_state = 5, .external_lex_state = 3},
  [1305] = {.lex_state = 5, .external_lex_state = 2},
  [1306] = {.lex_state = 5, .external_lex_state = 3},
  [1307] = {.lex_state = 12},
  [1308] = {.lex_state = 5, .external_lex_state = 2},
  [1309] = {.lex_state = 12},
  [1310] = {.lex_state = 5, .external_lex_state = 3},
  [1311] = {.lex_state = 5, .external_lex_state = 3},
  [1312] = {.lex_state = 12},
  [1313] = {.lex_state = 5, .external_lex_state = 2},
  [1314] = {.lex_state = 5, .external_lex_state = 2},
  [1315] = {.lex_state = 5, .external_lex_state = 2},
  [1316] = {.lex_state = 5, .external_lex_state = 3},
  [1317] = {.lex_state = 5, .external_lex_state = 2},
  [1318] = {.lex_state = 5, .external_lex_state = 2},
  [1319] = {.lex_state = 5, .external_lex_state = 3},
  [1320] = {.lex_state = 5, .external_lex_state = 2},
  [1321] = {.lex_state = 5, .external_lex_state = 3},
  [1322] = {.lex_state = 5, .external_lex_state = 2},
  [1323] = {.lex_state = 5, .external_lex_state = 2},
  [1324] = {.lex_state = 5, .external_lex_state = 2},
  [1325] = {.lex_state = 5, .external_lex_state = 2},
  [1326] = {.lex_state = 5, .external_lex_state = 2},
  [1327] = {.lex_state = 5, .external_lex_state = 3},
  [1328] = {.lex_state = 11},
  [1329] = {.lex_state = 11},
  [1330] = {.lex_state = 5, .external_lex_state = 2},
  [1331] = {.lex_state = 5, .external_lex_state = 2},
  [1332] = {.lex_state = 5, .external_lex_state = 2},
  [1333] = {.lex_state = 5, .external_lex_state = 2},
  [1334] = {.lex_state = 5, .external_lex_state = 2},
  [1335] = {.lex_state = 5, .external_lex_state = 2},
  [1336] = {.lex_state = 5, .external_lex_state = 2},
  [1337] = {.lex_state = 11},
  [1338] = {.lex_state = 5, .external_lex_state = 2},
  [1339] = {.lex_state = 11},
  [1340] = {.lex_state = 11},
  [1341] = {.lex_state = 5, .external_lex_state = 2},
  [1342] = {.lex_state = 5, .external_lex_state = 2},
  [1343] = {.lex_state = 11},
  [1344] = {.lex_state = 5, .external_lex_state = 2},
  [1345] = {.lex_state = 5, .external_lex_state = 3},
  [1346] = {.lex_state = 5, .external_lex_state = 2},
  [1347] = {.lex_state = 5, .external_lex_state = 2},
  [1348] = {.lex_state = 5, .external_lex_state = 2},
  [1349] = {.lex_state = 11},
  [1350] = {.lex_state = 5, .external_lex_state = 2},
  [1351] = {.lex_state = 5, .external_lex_state = 2},
  [1352] = {.lex_state = 5, .external_lex_state = 2},
  [1353] = {.lex_state = 5, .external_lex_state = 2},
  [1354] = {.lex_state = 5, .external_lex_state = 2},
  [1355] = {.lex_state = 5, .external_lex_state = 2},
  [1356] = {.lex_state = 5, .external_lex_state = 2},
  [1357] = {.lex_state = 93},
  [1358] = {.lex_state = 93},
  [1359] = {.lex_state = 11},
  [1360] = {.lex_state = 93},
  [1361] = {.lex_state = 93},
  [1362] = {.lex_state = 93},
  [1363] = {.lex_state = 16, .external_lex_state = 4},
  [1364] = {.lex_state = 16, .external_lex_state = 4},
  [1365] = {.lex_state = 16},
  [1366] = {.lex_state = 16},
  [1367] = {.lex_state = 16, .external_lex_state = 4},
  [1368] = {.lex_state = 16, .external_lex_state = 4},
  [1369] = {.lex_state = 16, .external_lex_state = 4},
  [1370] = {.lex_state = 16, .external_lex_state = 4},
  [1371] = {.lex_state = 12, .external_lex_state = 4},
  [1372] = {.lex_state = 12},
  [1373] = {.lex_state = 12},
  [1374] = {.lex_state = 12},
  [1375] = {.lex_state = 12},
  [1376] = {.lex_state = 12},
  [1377] = {.lex_state = 12},
  [1378] = {.lex_state = 12},
  [1379] = {.lex_state = 12},
  [1380] = {.lex_state = 12, .external_lex_state = 4},
  [1381] = {.lex_state = 12},
  [1382] = {.lex_state = 12, .external_lex_state = 4},
  [1383] = {.lex_state = 12, .external_lex_state = 4},
  [1384] = {.lex_state = 12},
  [1385] = {.lex_state = 12},
  [1386] = {.lex_state = 12, .external_lex_state = 4},
  [1387] = {.lex_state = 12},
  [1388] = {.lex_state = 12, .external_lex_state = 4},
  [1389] = {.lex_state = 12},
  [1390] = {.lex_state = 12},
  [1391] = {.lex_state = 7, .external_lex_state = 3},
  [1392] = {.lex_state = 12},
  [1393] = {.lex_state = 12},
  [1394] = {.lex_state = 7, .external_lex_state = 3},
  [1395] = {.lex_state = 12},
  [1396] = {.lex_state = 12, .external_lex_state = 4},
  [1397] = {.lex_state = 12, .external_lex_state = 4},
  [1398] = {.lex_state = 12, .external_lex_state = 4},
  [1399] = {.lex_state = 12, .external_lex_state = 4},
  [1400] = {.lex_state = 12, .external_lex_state = 4},
  [1401] = {.lex_state = 12, .external_lex_state = 4},
  [1402] = {.lex_state = 12, .external_lex_state = 4},
  [1403] = {.lex_state = 12, .external_lex_state = 4},
  [1404] = {.lex_state = 12, .external_lex_state = 4},
  [1405] = {.lex_state = 12, .external_lex_state = 4},
  [1406] = {.lex_state = 16, .external_lex_state = 4},
  [1407] = {.lex_state = 93},
  [1408] = {.lex_state = 16, .external_lex_state = 4},
  [1409] = {.lex_state = 12, .external_lex_state = 4},
  [1410] = {.lex_state = 12, .external_lex_state = 4},
  [1411] = {.lex_state = 12, .external_lex_state = 4},
  [1412] = {.lex_state = 7, .external_lex_state = 3},
  [1413] = {.lex_state = 7, .external_lex_state = 3},
  [1414] = {.lex_state = 12, .external_lex_state = 4},
  [1415] = {.lex_state = 12, .external_lex_state = 4},
  [1416] = {.lex_state = 12, .external_lex_state = 4},
  [1417] = {.lex_state = 12, .external_lex_state = 4},
  [1418] = {.lex_state = 12, .external_lex_state = 4},
  [1419] = {.lex_state = 12, .external_lex_state = 4},
  [1420] = {.lex_state = 12, .external_lex_state = 4},
  [1421] = {.lex_state = 12, .external_lex_state = 4},
  [1422] = {.lex_state = 12, .external_lex_state = 4},
  [1423] = {.lex_state = 12, .external_lex_state = 4},
  [1424] = {.lex_state = 12, .external_lex_state = 4},
  [1425] = {.lex_state = 12, .external_lex_state = 4},
  [1426] = {.lex_state = 12},
  [1427] = {.lex_state = 12, .external_lex_state = 4},
  [1428] = {.lex_state = 11},
  [1429] = {.lex_state = 12},
  [1430] = {.lex_state = 12, .external_lex_state = 4},
  [1431] = {.lex_state = 11},
  [1432] = {.lex_state = 12},
  [1433] = {.lex_state = 12, .external_lex_state = 4},
  [1434] = {.lex_state = 7, .external_lex_state = 2},
  [1435] = {.lex_state = 7, .external_lex_state = 2},
  [1436] = {.lex_state = 12},
  [1437] = {.lex_state = 12, .external_lex_state = 4},
  [1438] = {.lex_state = 12, .external_lex_state = 4},
  [1439] = {.lex_state = 12, .external_lex_state = 4},
  [1440] = {.lex_state = 12},
  [1441] = {.lex_state = 12},
  [1442] = {.lex_state = 12, .external_lex_state = 4},
  [1443] = {.lex_state = 12},
  [1444] = {.lex_state = 12, .external_lex_state = 4},
  [1445] = {.lex_state = 12, .external_lex_state = 4},
  [1446] = {.lex_state = 7, .external_lex_state = 3},
  [1447] = {.lex_state = 12, .external_lex_state = 4},
  [1448] = {.lex_state = 12, .external_lex_state = 4},
  [1449] = {.lex_state = 12, .external_lex_state = 4},
  [1450] = {.lex_state = 7, .external_lex_state = 2},
  [1451] = {.lex_state = 12, .external_lex_state = 4},
  [1452] = {.lex_state = 12, .external_lex_state = 4},
  [1453] = {.lex_state = 12},
  [1454] = {.lex_state = 12, .external_lex_state = 4},
  [1455] = {.lex_state = 12, .external_lex_state = 4},
  [1456] = {.lex_state = 7, .external_lex_state = 2},
  [1457] = {.lex_state = 12},
  [1458] = {.lex_state = 12, .external_lex_state = 4},
  [1459] = {.lex_state = 7, .external_lex_state = 3},
  [1460] = {.lex_state = 12, .external_lex_state = 4},
  [1461] = {.lex_state = 7, .external_lex_state = 2},
  [1462] = {.lex_state = 12, .external_lex_state = 4},
  [1463] = {.lex_state = 12, .external_lex_state = 4},
  [1464] = {.lex_state = 12, .external_lex_state = 4},
  [1465] = {.lex_state = 7, .external_lex_state = 2},
  [1466] = {.lex_state = 12, .external_lex_state = 4},
  [1467] = {.lex_state = 12, .external_lex_state = 4},
  [1468] = {.lex_state = 7, .external_lex_state = 2},
  [1469] = {.lex_state = 11},
  [1470] = {.lex_state = 12, .external_lex_state = 4},
  [1471] = {.lex_state = 12, .external_lex_state = 4},
  [1472] = {.lex_state = 7, .external_lex_state = 2},
  [1473] = {.lex_state = 7, .external_lex_state = 2},
  [1474] = {.lex_state = 12, .external_lex_state = 4},
  [1475] = {.lex_state = 12},
  [1476] = {.lex_state = 12, .external_lex_state = 4},
  [1477] = {.lex_state = 12, .external_lex_state = 4},
  [1478] = {.lex_state = 12, .external_lex_state = 4},
  [1479] = {.lex_state = 12, .external_lex_state = 4},
  [1480] = {.lex_state = 12, .external_lex_state = 4},
  [1481] = {.lex_state = 12, .external_lex_state = 4},
  [1482] = {.lex_state = 12, .external_lex_state = 4},
  [1483] = {.lex_state = 12, .external_lex_state = 4},
  [1484] = {.lex_state = 12, .external_lex_state = 4},
  [1485] = {.lex_state = 7, .external_lex_state = 3},
  [1486] = {.lex_state = 12, .external_lex_state = 4},
  [1487] = {.lex_state = 12},
  [1488] = {.lex_state = 12},
  [1489] = {.lex_state = 12},
  [1490] = {.lex_state = 12},
  [1491] = {.lex_state = 12},
  [1492] = {.lex_state = 12, .external_lex_state = 4},
  [1493] = {.lex_state = 12, .external_lex_state = 4},
  [1494] = {.lex_state = 12},
  [1495] = {.lex_state = 12},
  [1496] = {.lex_state = 7, .external_lex_state = 2},
  [1497] = {.lex_state = 12},
  [1498] = {.lex_state = 12, .external_lex_state = 4},
  [1499] = {.lex_state = 12, .external_lex_state = 4},
  [1500] = {.lex_state = 12, .external_lex_state = 4},
  [1501] = {.lex_state = 12, .external_lex_state = 4},
  [1502] = {.lex_state = 12},
  [1503] = {.lex_state = 12},
  [1504] = {.lex_state = 12, .external_lex_state = 4},
  [1505] = {.lex_state = 12, .external_lex_state = 4},
  [1506] = {.lex_state = 12, .external_lex_state = 4},
  [1507] = {.lex_state = 12, .external_lex_state = 4},
  [1508] = {.lex_state = 7, .external_lex_state = 2},
  [1509] = {.lex_state = 7, .external_lex_state = 2},
  [1510] = {.lex_state = 12},
  [1511] = {.lex_state = 12, .external_lex_state = 4},
  [1512] = {.lex_state = 7, .external_lex_state = 2},
  [1513] = {.lex_state = 7, .external_lex_state = 2},
  [1514] = {.lex_state = 7, .external_lex_state = 2},
  [1515] = {.lex_state = 7, .external_lex_state = 2},
  [1516] = {.lex_state = 7, .external_lex_state = 2},
  [1517] = {.lex_state = 7, .external_lex_state = 2},
  [1518] = {.lex_state = 7, .external_lex_state = 2},
  [1519] = {.lex_state = 7, .external_lex_state = 2},
  [1520] = {.lex_state = 7, .external_lex_state = 2},
  [1521] = {.lex_state = 7, .external_lex_state = 2},
  [1522] = {.lex_state = 12, .external_lex_state = 4},
  [1523] = {.lex_state = 7, .external_lex_state = 2},
  [1524] = {.lex_state = 7, .external_lex_state = 2},
  [1525] = {.lex_state = 7, .external_lex_state = 2},
  [1526] = {.lex_state = 7, .external_lex_state = 2},
  [1527] = {.lex_state = 7, .external_lex_state = 2},
  [1528] = {.lex_state = 7, .external_lex_state = 2},
  [1529] = {.lex_state = 7, .external_lex_state = 2},
  [1530] = {.lex_state = 7, .external_lex_state = 2},
  [1531] = {.lex_state = 7, .external_lex_state = 2},
  [1532] = {.lex_state = 7, .external_lex_state = 2},
  [1533] = {.lex_state = 7, .external_lex_state = 2},
  [1534] = {.lex_state = 7, .external_lex_state = 2},
  [1535] = {.lex_state = 7, .external_lex_state = 2},
  [1536] = {.lex_state = 7, .external_lex_state = 2},
  [1537] = {.lex_state = 7, .external_lex_state = 2},
  [1538] = {.lex_state = 7, .external_lex_state = 2},
  [1539] = {.lex_state = 7, .external_lex_state = 2},
  [1540] = {.lex_state = 7, .external_lex_state = 2},
  [1541] = {.lex_state = 7, .external_lex_state = 2},
  [1542] = {.lex_state = 12, .external_lex_state = 4},
  [1543] = {.lex_state = 7, .external_lex_state = 2},
  [1544] = {.lex_state = 7, .external_lex_state = 2},
  [1545] = {.lex_state = 7, .external_lex_state = 2},
  [1546] = {.lex_state = 12, .external_lex_state = 4},
  [1547] = {.lex_state = 7, .external_lex_state = 2},
  [1548] = {.lex_state = 12, .external_lex_state = 4},
  [1549] = {.lex_state = 12, .external_lex_state = 4},
  [1550] = {.lex_state = 12, .external_lex_state = 4},
  [1551] = {.lex_state = 7, .external_lex_state = 3},
  [1552] = {.lex_state = 7, .external_lex_state = 3},
  [1553] = {.lex_state = 7, .external_lex_state = 2},
  [1554] = {.lex_state = 12},
  [1555] = {.lex_state = 7, .external_lex_state = 2},
  [1556] = {.lex_state = 7, .external_lex_state = 2},
  [1557] = {.lex_state = 7, .external_lex_state = 2},
  [1558] = {.lex_state = 7, .external_lex_state = 2},
  [1559] = {.lex_state = 7, .external_lex_state = 2},
  [1560] = {.lex_state = 7, .external_lex_state = 2},
  [1561] = {.lex_state = 12, .external_lex_state = 4},
  [1562] = {.lex_state = 7, .external_lex_state = 2},
  [1563] = {.lex_state = 7, .external_lex_state = 2},
  [1564] = {.lex_state = 12, .external_lex_state = 4},
  [1565] = {.lex_state = 12, .external_lex_state = 4},
  [1566] = {.lex_state = 7, .external_lex_state = 2},
  [1567] = {.lex_state = 11},
  [1568] = {.lex_state = 12},
  [1569] = {.lex_state = 12, .external_lex_state = 4},
  [1570] = {.lex_state = 12},
  [1571] = {.lex_state = 12, .external_lex_state = 4},
  [1572] = {.lex_state = 12},
  [1573] = {.lex_state = 7, .external_lex_state = 2},
  [1574] = {.lex_state = 12, .external_lex_state = 4},
  [1575] = {.lex_state = 12, .external_lex_state = 4},
  [1576] = {.lex_state = 12, .external_lex_state = 4},
  [1577] = {.lex_state = 7, .external_lex_state = 3},
  [1578] = {.lex_state = 12},
  [1579] = {.lex_state = 12},
  [1580] = {.lex_state = 7, .external_lex_state = 2},
  [1581] = {.lex_state = 7, .external_lex_state = 2},
  [1582] = {.lex_state = 12},
  [1583] = {.lex_state = 7, .external_lex_state = 2},
  [1584] = {.lex_state = 12},
  [1585] = {.lex_state = 7, .external_lex_state = 2},
  [1586] = {.lex_state = 7, .external_lex_state = 2},
  [1587] = {.lex_state = 12, .external_lex_state = 4},
  [1588] = {.lex_state = 7, .external_lex_state = 2},
  [1589] = {.lex_state = 7, .external_lex_state = 2},
  [1590] = {.lex_state = 7, .external_lex_state = 2},
  [1591] = {.lex_state = 7, .external_lex_state = 2},
  [1592] = {.lex_state = 7, .external_lex_state = 2},
  [1593] = {.lex_state = 7, .external_lex_state = 2},
  [1594] = {.lex_state = 7, .external_lex_state = 2},
  [1595] = {.lex_state = 7, .external_lex_state = 2},
  [1596] = {.lex_state = 7, .external_lex_state = 2},
  [1597] = {.lex_state = 12, .external_lex_state = 4},
  [1598] = {.lex_state = 7, .external_lex_state = 2},
  [1599] = {.lex_state = 12, .external_lex_state = 4},
  [1600] = {.lex_state = 7, .external_lex_state = 2},
  [1601] = {.lex_state = 7, .external_lex_state = 2},
  [1602] = {.lex_state = 7, .external_lex_state = 2},
  [1603] = {.lex_state = 7, .external_lex_state = 2},
  [1604] = {.lex_state = 7, .external_lex_state = 2},
  [1605] = {.lex_state = 7, .external_lex_state = 2},
  [1606] = {.lex_state = 7, .external_lex_state = 2},
  [1607] = {.lex_state = 7, .external_lex_state = 2},
  [1608] = {.lex_state = 7, .external_lex_state = 2},
  [1609] = {.lex_state = 7, .external_lex_state = 2},
  [1610] = {.lex_state = 7, .external_lex_state = 2},
  [1611] = {.lex_state = 7, .external_lex_state = 2},
  [1612] = {.lex_state = 7, .external_lex_state = 2},
  [1613] = {.lex_state = 7, .external_lex_state = 2},
  [1614] = {.lex_state = 7, .external_lex_state = 2},
  [1615] = {.lex_state = 7, .external_lex_state = 2},
  [1616] = {.lex_state = 7, .external_lex_state = 2},
  [1617] = {.lex_state = 7, .external_lex_state = 2},
  [1618] = {.lex_state = 7, .external_lex_state = 2},
  [1619] = {.lex_state = 7, .external_lex_state = 2},
  [1620] = {.lex_state = 7, .external_lex_state = 2},
  [1621] = {.lex_state = 7, .external_lex_state = 2},
  [1622] = {.lex_state = 7, .external_lex_state = 2},
  [1623] = {.lex_state = 7, .external_lex_state = 2},
  [1624] = {.lex_state = 7, .external_lex_state = 2},
  [1625] = {.lex_state = 7, .external_lex_state = 2},
  [1626] = {.lex_state = 7, .external_lex_state = 2},
  [1627] = {.lex_state = 7, .external_lex_state = 2},
  [1628] = {.lex_state = 7, .external_lex_state = 2},
  [1629] = {.lex_state = 7, .external_lex_state = 2},
  [1630] = {.lex_state = 7, .external_lex_state = 2},
  [1631] = {.lex_state = 7, .external_lex_state = 2},
  [1632] = {.lex_state = 7, .external_lex_state = 2},
  [1633] = {.lex_state = 7, .external_lex_state = 2},
  [1634] = {.lex_state = 7, .external_lex_state = 2},
  [1635] = {.lex_state = 7, .external_lex_state = 2},
  [1636] = {.lex_state = 7, .external_lex_state = 2},
  [1637] = {.lex_state = 7, .external_lex_state = 2},
  [1638] = {.lex_state = 7, .external_lex_state = 2},
  [1639] = {.lex_state = 7, .external_lex_state = 2},
  [1640] = {.lex_state = 7, .external_lex_state = 2},
  [1641] = {.lex_state = 7, .external_lex_state = 2},
  [1642] = {.lex_state = 7, .external_lex_state = 2},
  [1643] = {.lex_state = 7, .external_lex_state = 2},
  [1644] = {.lex_state = 7, .external_lex_state = 2},
  [1645] = {.lex_state = 7, .external_lex_state = 2},
  [1646] = {.lex_state = 7, .external_lex_state = 2},
  [1647] = {.lex_state = 7, .external_lex_state = 2},
  [1648] = {.lex_state = 7, .external_lex_state = 2},
  [1649] = {.lex_state = 7, .external_lex_state = 2},
  [1650] = {.lex_state = 7, .external_lex_state = 2},
  [1651] = {.lex_state = 7, .external_lex_state = 2},
  [1652] = {.lex_state = 7, .external_lex_state = 2},
  [1653] = {.lex_state = 7, .external_lex_state = 2},
  [1654] = {.lex_state = 7, .external_lex_state = 2},
  [1655] = {.lex_state = 7, .external_lex_state = 2},
  [1656] = {.lex_state = 7, .external_lex_state = 2},
  [1657] = {.lex_state = 7, .external_lex_state = 2},
  [1658] = {.lex_state = 7, .external_lex_state = 2},
  [1659] = {.lex_state = 7, .external_lex_state = 2},
  [1660] = {.lex_state = 7, .external_lex_state = 2},
  [1661] = {.lex_state = 7, .external_lex_state = 2},
  [1662] = {.lex_state = 7, .external_lex_state = 2},
  [1663] = {.lex_state = 7, .external_lex_state = 2},
  [1664] = {.lex_state = 12, .external_lex_state = 4},
  [1665] = {.lex_state = 7, .external_lex_state = 2},
  [1666] = {.lex_state = 7, .external_lex_state = 2},
  [1667] = {.lex_state = 7, .external_lex_state = 2},
  [1668] = {.lex_state = 7, .external_lex_state = 2},
  [1669] = {.lex_state = 7, .external_lex_state = 3},
  [1670] = {.lex_state = 7, .external_lex_state = 3},
  [1671] = {.lex_state = 7, .external_lex_state = 3},
  [1672] = {.lex_state = 7, .external_lex_state = 2},
  [1673] = {.lex_state = 7, .external_lex_state = 3},
  [1674] = {.lex_state = 7, .external_lex_state = 3},
  [1675] = {.lex_state = 7, .external_lex_state = 3},
  [1676] = {.lex_state = 7, .external_lex_state = 2},
  [1677] = {.lex_state = 7, .external_lex_state = 2},
  [1678] = {.lex_state = 12, .external_lex_state = 4},
  [1679] = {.lex_state = 12, .external_lex_state = 4},
  [1680] = {.lex_state = 7, .external_lex_state = 2},
  [1681] = {.lex_state = 7, .external_lex_state = 3},
  [1682] = {.lex_state = 7, .external_lex_state = 2},
  [1683] = {.lex_state = 7, .external_lex_state = 2},
  [1684] = {.lex_state = 7, .external_lex_state = 3},
  [1685] = {.lex_state = 7, .external_lex_state = 2},
  [1686] = {.lex_state = 7, .external_lex_state = 3},
  [1687] = {.lex_state = 7, .external_lex_state = 2},
  [1688] = {.lex_state = 7, .external_lex_state = 2},
  [1689] = {.lex_state = 7, .external_lex_state = 2},
  [1690] = {.lex_state = 7, .external_lex_state = 2},
  [1691] = {.lex_state = 7, .external_lex_state = 3},
  [1692] = {.lex_state = 7, .external_lex_state = 3},
  [1693] = {.lex_state = 7, .external_lex_state = 3},
  [1694] = {.lex_state = 7, .external_lex_state = 3},
  [1695] = {.lex_state = 7, .external_lex_state = 3},
  [1696] = {.lex_state = 7, .external_lex_state = 3},
  [1697] = {.lex_state = 11, .external_lex_state = 4},
  [1698] = {.lex_state = 11, .external_lex_state = 4},
  [1699] = {.lex_state = 7, .external_lex_state = 3},
  [1700] = {.lex_state = 7, .external_lex_state = 3},
  [1701] = {.lex_state = 7, .external_lex_state = 3},
  [1702] = {.lex_state = 7, .external_lex_state = 3},
  [1703] = {.lex_state = 7, .external_lex_state = 3},
  [1704] = {.lex_state = 7, .external_lex_state = 3},
  [1705] = {.lex_state = 7, .external_lex_state = 3},
  [1706] = {.lex_state = 7, .external_lex_state = 3},
  [1707] = {.lex_state = 7, .external_lex_state = 3},
  [1708] = {.lex_state = 7, .external_lex_state = 3},
  [1709] = {.lex_state = 7, .external_lex_state = 3},
  [1710] = {.lex_state = 7, .external_lex_state = 2},
  [1711] = {.lex_state = 7, .external_lex_state = 2},
  [1712] = {.lex_state = 7, .external_lex_state = 3},
  [1713] = {.lex_state = 7, .external_lex_state = 3},
  [1714] = {.lex_state = 7, .external_lex_state = 2},
  [1715] = {.lex_state = 7, .external_lex_state = 3},
  [1716] = {.lex_state = 7, .external_lex_state = 2},
  [1717] = {.lex_state = 7, .external_lex_state = 3},
  [1718] = {.lex_state = 7, .external_lex_state = 2},
  [1719] = {.lex_state = 7, .external_lex_state = 2},
  [1720] = {.lex_state = 7, .external_lex_state = 2},
  [1721] = {.lex_state = 7, .external_lex_state = 3},
  [1722] = {.lex_state = 7, .external_lex_state = 3},
  [1723] = {.lex_state = 7, .external_lex_state = 2},
  [1724] = {.lex_state = 7, .external_lex_state = 3},
  [1725] = {.lex_state = 7, .external_lex_state = 2},
  [1726] = {.lex_state = 7, .external_lex_state = 2},
  [1727] = {.lex_state = 7, .external_lex_state = 2},
  [1728] = {.lex_state = 7, .external_lex_state = 2},
  [1729] = {.lex_state = 7, .external_lex_state = 2},
  [1730] = {.lex_state = 7, .external_lex_state = 2},
  [1731] = {.lex_state = 7, .external_lex_state = 2},
  [1732] = {.lex_state = 7, .external_lex_state = 3},
  [1733] = {.lex_state = 7, .external_lex_state = 2},
  [1734] = {.lex_state = 7, .external_lex_state = 3},
  [1735] = {.lex_state = 7, .external_lex_state = 3},
  [1736] = {.lex_state = 7, .external_lex_state = 3},
  [1737] = {.lex_state = 7, .external_lex_state = 3},
  [1738] = {.lex_state = 7, .external_lex_state = 3},
  [1739] = {.lex_state = 7, .external_lex_state = 2},
  [1740] = {.lex_state = 7, .external_lex_state = 2},
  [1741] = {.lex_state = 7, .external_lex_state = 2},
  [1742] = {.lex_state = 7, .external_lex_state = 2},
  [1743] = {.lex_state = 7, .external_lex_state = 2},
  [1744] = {.lex_state = 7, .external_lex_state = 3},
  [1745] = {.lex_state = 7, .external_lex_state = 3},
  [1746] = {.lex_state = 7, .external_lex_state = 2},
  [1747] = {.lex_state = 7, .external_lex_state = 3},
  [1748] = {.lex_state = 7, .external_lex_state = 3},
  [1749] = {.lex_state = 7, .external_lex_state = 2},
  [1750] = {.lex_state = 7, .external_lex_state = 2},
  [1751] = {.lex_state = 7, .external_lex_state = 2},
  [1752] = {.lex_state = 7, .external_lex_state = 2},
  [1753] = {.lex_state = 7, .external_lex_state = 2},
  [1754] = {.lex_state = 7, .external_lex_state = 2},
  [1755] = {.lex_state = 7, .external_lex_state = 3},
  [1756] = {.lex_state = 7, .external_lex_state = 3},
  [1757] = {.lex_state = 7, .external_lex_state = 3},
  [1758] = {.lex_state = 7, .external_lex_state = 2},
  [1759] = {.lex_state = 7, .external_lex_state = 3},
  [1760] = {.lex_state = 7, .external_lex_state = 3},
  [1761] = {.lex_state = 7, .external_lex_state = 2},
  [1762] = {.lex_state = 7, .external_lex_state = 2},
  [1763] = {.lex_state = 7, .external_lex_state = 2},
  [1764] = {.lex_state = 7, .external_lex_state = 2},
  [1765] = {.lex_state = 7, .external_lex_state = 2},
  [1766] = {.lex_state = 7, .external_lex_state = 2},
  [1767] = {.lex_state = 7, .external_lex_state = 2},
  [1768] = {.lex_state = 7, .external_lex_state = 2},
  [1769] = {.lex_state = 7, .external_lex_state = 3},
  [1770] = {.lex_state = 7, .external_lex_state = 3},
  [1771] = {.lex_state = 11, .external_lex_state = 4},
  [1772] = {.lex_state = 7, .external_lex_state = 3},
  [1773] = {.lex_state = 7, .external_lex_state = 3},
  [1774] = {.lex_state = 7, .external_lex_state = 2},
  [1775] = {.lex_state = 7, .external_lex_state = 2},
  [1776] = {.lex_state = 7, .external_lex_state = 2},
  [1777] = {.lex_state = 7, .external_lex_state = 2},
  [1778] = {.lex_state = 7, .external_lex_state = 3},
  [1779] = {.lex_state = 11, .external_lex_state = 4},
  [1780] = {.lex_state = 7, .external_lex_state = 2},
  [1781] = {.lex_state = 7, .external_lex_state = 2},
  [1782] = {.lex_state = 7, .external_lex_state = 3},
  [1783] = {.lex_state = 7, .external_lex_state = 3},
  [1784] = {.lex_state = 7, .external_lex_state = 2},
  [1785] = {.lex_state = 7, .external_lex_state = 2},
  [1786] = {.lex_state = 7, .external_lex_state = 3},
  [1787] = {.lex_state = 7, .external_lex_state = 3},
  [1788] = {.lex_state = 7, .external_lex_state = 2},
  [1789] = {.lex_state = 7, .external_lex_state = 3},
  [1790] = {.lex_state = 7, .external_lex_state = 2},
  [1791] = {.lex_state = 7, .external_lex_state = 3},
  [1792] = {.lex_state = 7, .external_lex_state = 3},
  [1793] = {.lex_state = 7, .external_lex_state = 2},
  [1794] = {.lex_state = 7, .external_lex_state = 3},
  [1795] = {.lex_state = 7, .external_lex_state = 3},
  [1796] = {.lex_state = 7, .external_lex_state = 3},
  [1797] = {.lex_state = 7, .external_lex_state = 2},
  [1798] = {.lex_state = 7, .external_lex_state = 3},
  [1799] = {.lex_state = 12},
  [1800] = {.lex_state = 12},
  [1801] = {.lex_state = 7, .external_lex_state = 2},
  [1802] = {.lex_state = 7, .external_lex_state = 2},
  [1803] = {.lex_state = 7, .external_lex_state = 2},
  [1804] = {.lex_state = 7, .external_lex_state = 2},
  [1805] = {.lex_state = 7, .external_lex_state = 2},
  [1806] = {.lex_state = 7, .external_lex_state = 3},
  [1807] = {.lex_state = 7, .external_lex_state = 2},
  [1808] = {.lex_state = 7, .external_lex_state = 2},
  [1809] = {.lex_state = 7, .external_lex_state = 2},
  [1810] = {.lex_state = 7, .external_lex_state = 3},
  [1811] = {.lex_state = 7, .external_lex_state = 2},
  [1812] = {.lex_state = 7, .external_lex_state = 2},
  [1813] = {.lex_state = 7, .external_lex_state = 3},
  [1814] = {.lex_state = 7, .external_lex_state = 2},
  [1815] = {.lex_state = 7, .external_lex_state = 3},
  [1816] = {.lex_state = 15},
  [1817] = {.lex_state = 12},
  [1818] = {.lex_state = 7, .external_lex_state = 2},
  [1819] = {.lex_state = 7, .external_lex_state = 2},
  [1820] = {.lex_state = 7, .external_lex_state = 3},
  [1821] = {.lex_state = 7, .external_lex_state = 3},
  [1822] = {.lex_state = 7, .external_lex_state = 2},
  [1823] = {.lex_state = 7, .external_lex_state = 3},
  [1824] = {.lex_state = 7, .external_lex_state = 3},
  [1825] = {.lex_state = 7, .external_lex_state = 3},
  [1826] = {.lex_state = 7, .external_lex_state = 2},
  [1827] = {.lex_state = 7, .external_lex_state = 2},
  [1828] = {.lex_state = 7, .external_lex_state = 2},
  [1829] = {.lex_state = 7, .external_lex_state = 2},
  [1830] = {.lex_state = 7, .external_lex_state = 2},
  [1831] = {.lex_state = 7, .external_lex_state = 3},
  [1832] = {.lex_state = 7, .external_lex_state = 2},
  [1833] = {.lex_state = 7, .external_lex_state = 2},
  [1834] = {.lex_state = 7, .external_lex_state = 2},
  [1835] = {.lex_state = 12},
  [1836] = {.lex_state = 12},
  [1837] = {.lex_state = 7, .external_lex_state = 2},
  [1838] = {.lex_state = 7, .external_lex_state = 2},
  [1839] = {.lex_state = 7, .external_lex_state = 2},
  [1840] = {.lex_state = 7, .external_lex_state = 2},
  [1841] = {.lex_state = 7, .external_lex_state = 2},
  [1842] = {.lex_state = 7, .external_lex_state = 2},
  [1843] = {.lex_state = 7, .external_lex_state = 2},
  [1844] = {.lex_state = 7, .external_lex_state = 2},
  [1845] = {.lex_state = 12},
  [1846] = {.lex_state = 7, .external_lex_state = 3},
  [1847] = {.lex_state = 12},
  [1848] = {.lex_state = 7, .external_lex_state = 2},
  [1849] = {.lex_state = 7, .external_lex_state = 2},
  [1850] = {.lex_state = 7, .external_lex_state = 2},
  [1851] = {.lex_state = 7, .external_lex_state = 2},
  [1852] = {.lex_state = 11, .external_lex_state = 4},
  [1853] = {.lex_state = 7, .external_lex_state = 3},
  [1854] = {.lex_state = 7, .external_lex_state = 3},
  [1855] = {.lex_state = 7, .external_lex_state = 3},
  [1856] = {.lex_state = 11, .external_lex_state = 4},
  [1857] = {.lex_state = 7, .external_lex_state = 2},
  [1858] = {.lex_state = 7, .external_lex_state = 3},
  [1859] = {.lex_state = 7, .external_lex_state = 2},
  [1860] = {.lex_state = 7, .external_lex_state = 2},
  [1861] = {.lex_state = 7, .external_lex_state = 2},
  [1862] = {.lex_state = 7, .external_lex_state = 3},
  [1863] = {.lex_state = 7, .external_lex_state = 2},
  [1864] = {.lex_state = 7, .external_lex_state = 2},
  [1865] = {.lex_state = 12},
  [1866] = {.lex_state = 7, .external_lex_state = 3},
  [1867] = {.lex_state = 12},
  [1868] = {.lex_state = 7, .external_lex_state = 3},
  [1869] = {.lex_state = 7, .external_lex_state = 2},
  [1870] = {.lex_state = 12},
  [1871] = {.lex_state = 12},
  [1872] = {.lex_state = 12},
  [1873] = {.lex_state = 7, .external_lex_state = 2},
  [1874] = {.lex_state = 12},
  [1875] = {.lex_state = 12},
  [1876] = {.lex_state = 7, .external_lex_state = 3},
  [1877] = {.lex_state = 7, .external_lex_state = 2},
  [1878] = {.lex_state = 7, .external_lex_state = 2},
  [1879] = {.lex_state = 7, .external_lex_state = 2},
  [1880] = {.lex_state = 7, .external_lex_state = 2},
  [1881] = {.lex_state = 7, .external_lex_state = 2},
  [1882] = {.lex_state = 7, .external_lex_state = 3},
  [1883] = {.lex_state = 7, .external_lex_state = 2},
  [1884] = {.lex_state = 7, .external_lex_state = 2},
  [1885] = {.lex_state = 7, .external_lex_state = 2},
  [1886] = {.lex_state = 12},
  [1887] = {.lex_state = 12},
  [1888] = {.lex_state = 7, .external_lex_state = 2},
  [1889] = {.lex_state = 7, .external_lex_state = 3},
  [1890] = {.lex_state = 7, .external_lex_state = 3},
  [1891] = {.lex_state = 12},
  [1892] = {.lex_state = 7, .external_lex_state = 3},
  [1893] = {.lex_state = 12},
  [1894] = {.lex_state = 7, .external_lex_state = 2},
  [1895] = {.lex_state = 7, .external_lex_state = 2},
  [1896] = {.lex_state = 7, .external_lex_state = 2},
  [1897] = {.lex_state = 7, .external_lex_state = 2},
  [1898] = {.lex_state = 7, .external_lex_state = 3},
  [1899] = {.lex_state = 7, .external_lex_state = 3},
  [1900] = {.lex_state = 7, .external_lex_state = 3},
  [1901] = {.lex_state = 7, .external_lex_state = 3},
  [1902] = {.lex_state = 7, .external_lex_state = 2},
  [1903] = {.lex_state = 7, .external_lex_state = 2},
  [1904] = {.lex_state = 7, .external_lex_state = 3},
  [1905] = {.lex_state = 7, .external_lex_state = 3},
  [1906] = {.lex_state = 7, .external_lex_state = 2},
  [1907] = {.lex_state = 12},
  [1908] = {.lex_state = 12},
  [1909] = {.lex_state = 7, .external_lex_state = 3},
  [1910] = {.lex_state = 7, .external_lex_state = 2},
  [1911] = {.lex_state = 7, .external_lex_state = 2},
  [1912] = {.lex_state = 7, .external_lex_state = 2},
  [1913] = {.lex_state = 7, .external_lex_state = 2},
  [1914] = {.lex_state = 7, .external_lex_state = 3},
  [1915] = {.lex_state = 7, .external_lex_state = 2},
  [1916] = {.lex_state = 7, .external_lex_state = 3},
  [1917] = {.lex_state = 7, .external_lex_state = 3},
  [1918] = {.lex_state = 7, .external_lex_state = 3},
  [1919] = {.lex_state = 7, .external_lex_state = 3},
  [1920] = {.lex_state = 7, .external_lex_state = 3},
  [1921] = {.lex_state = 7, .external_lex_state = 3},
  [1922] = {.lex_state = 7, .external_lex_state = 3},
  [1923] = {.lex_state = 7, .external_lex_state = 3},
  [1924] = {.lex_state = 7, .external_lex_state = 3},
  [1925] = {.lex_state = 7, .external_lex_state = 3},
  [1926] = {.lex_state = 7, .external_lex_state = 3},
  [1927] = {.lex_state = 7, .external_lex_state = 3},
  [1928] = {.lex_state = 7, .external_lex_state = 3},
  [1929] = {.lex_state = 7, .external_lex_state = 3},
  [1930] = {.lex_state = 7, .external_lex_state = 3},
  [1931] = {.lex_state = 7, .external_lex_state = 3},
  [1932] = {.lex_state = 7, .external_lex_state = 3},
  [1933] = {.lex_state = 7, .external_lex_state = 3},
  [1934] = {.lex_state = 7, .external_lex_state = 3},
  [1935] = {.lex_state = 7, .external_lex_state = 3},
  [1936] = {.lex_state = 7, .external_lex_state = 2},
  [1937] = {.lex_state = 7, .external_lex_state = 3},
  [1938] = {.lex_state = 7, .external_lex_state = 3},
  [1939] = {.lex_state = 7, .external_lex_state = 2},
  [1940] = {.lex_state = 7, .external_lex_state = 3},
  [1941] = {.lex_state = 7, .external_lex_state = 3},
  [1942] = {.lex_state = 7, .external_lex_state = 3},
  [1943] = {.lex_state = 7, .external_lex_state = 3},
  [1944] = {.lex_state = 7, .external_lex_state = 3},
  [1945] = {.lex_state = 7, .external_lex_state = 2},
  [1946] = {.lex_state = 7, .external_lex_state = 3},
  [1947] = {.lex_state = 7, .external_lex_state = 3},
  [1948] = {.lex_state = 7, .external_lex_state = 3},
  [1949] = {.lex_state = 7, .external_lex_state = 3},
  [1950] = {.lex_state = 7, .external_lex_state = 3},
  [1951] = {.lex_state = 7, .external_lex_state = 3},
  [1952] = {.lex_state = 7, .external_lex_state = 3},
  [1953] = {.lex_state = 7, .external_lex_state = 3},
  [1954] = {.lex_state = 7, .external_lex_state = 3},
  [1955] = {.lex_state = 7, .external_lex_state = 3},
  [1956] = {.lex_state = 7, .external_lex_state = 3},
  [1957] = {.lex_state = 7, .external_lex_state = 3},
  [1958] = {.lex_state = 7, .external_lex_state = 3},
  [1959] = {.lex_state = 7, .external_lex_state = 3},
  [1960] = {.lex_state = 7, .external_lex_state = 3},
  [1961] = {.lex_state = 7, .external_lex_state = 2},
  [1962] = {.lex_state = 7, .external_lex_state = 3},
  [1963] = {.lex_state = 7, .external_lex_state = 2},
  [1964] = {.lex_state = 7, .external_lex_state = 3},
  [1965] = {.lex_state = 7, .external_lex_state = 3},
  [1966] = {.lex_state = 7, .external_lex_state = 3},
  [1967] = {.lex_state = 7, .external_lex_state = 3},
  [1968] = {.lex_state = 7, .external_lex_state = 3},
  [1969] = {.lex_state = 7, .external_lex_state = 3},
  [1970] = {.lex_state = 7, .external_lex_state = 3},
  [1971] = {.lex_state = 7, .external_lex_state = 3},
  [1972] = {.lex_state = 7, .external_lex_state = 2},
  [1973] = {.lex_state = 7, .external_lex_state = 3},
  [1974] = {.lex_state = 7, .external_lex_state = 3},
  [1975] = {.lex_state = 7, .external_lex_state = 3},
  [1976] = {.lex_state = 7, .external_lex_state = 3},
  [1977] = {.lex_state = 7, .external_lex_state = 3},
  [1978] = {.lex_state = 7, .external_lex_state = 3},
  [1979] = {.lex_state = 7, .external_lex_state = 3},
  [1980] = {.lex_state = 7, .external_lex_state = 3},
  [1981] = {.lex_state = 7, .external_lex_state = 3},
  [1982] = {.lex_state = 7, .external_lex_state = 3},
  [1983] = {.lex_state = 7, .external_lex_state = 3},
  [1984] = {.lex_state = 7, .external_lex_state = 3},
  [1985] = {.lex_state = 7, .external_lex_state = 3},
  [1986] = {.lex_state = 7, .external_lex_state = 3},
  [1987] = {.lex_state = 7, .external_lex_state = 3},
  [1988] = {.lex_state = 7, .external_lex_state = 3},
  [1989] = {.lex_state = 7, .external_lex_state = 3},
  [1990] = {.lex_state = 7, .external_lex_state = 3},
  [1991] = {.lex_state = 7, .external_lex_state = 2},
  [1992] = {.lex_state = 7, .external_lex_state = 2},
  [1993] = {.lex_state = 7, .external_lex_state = 3},
  [1994] = {.lex_state = 7, .external_lex_state = 3},
  [1995] = {.lex_state = 7, .external_lex_state = 3},
  [1996] = {.lex_state = 7, .external_lex_state = 3},
  [1997] = {.lex_state = 7, .external_lex_state = 3},
  [1998] = {.lex_state = 7, .external_lex_state = 3},
  [1999] = {.lex_state = 7, .external_lex_state = 3},
  [2000] = {.lex_state = 7, .external_lex_state = 3},
  [2001] = {.lex_state = 7, .external_lex_state = 3},
  [2002] = {.lex_state = 7, .external_lex_state = 3},
  [2003] = {.lex_state = 7, .external_lex_state = 3},
  [2004] = {.lex_state = 7, .external_lex_state = 3},
  [2005] = {.lex_state = 7, .external_lex_state = 3},
  [2006] = {.lex_state = 7, .external_lex_state = 3},
  [2007] = {.lex_state = 7, .external_lex_state = 3},
  [2008] = {.lex_state = 7, .external_lex_state = 3},
  [2009] = {.lex_state = 7, .external_lex_state = 3},
  [2010] = {.lex_state = 7, .external_lex_state = 3},
  [2011] = {.lex_state = 7, .external_lex_state = 3},
  [2012] = {.lex_state = 7, .external_lex_state = 2},
  [2013] = {.lex_state = 7, .external_lex_state = 3},
  [2014] = {.lex_state = 7, .external_lex_state = 3},
  [2015] = {.lex_state = 7, .external_lex_state = 2},
  [2016] = {.lex_state = 7, .external_lex_state = 3},
  [2017] = {.lex_state = 7, .external_lex_state = 3},
  [2018] = {.lex_state = 7, .external_lex_state = 3},
  [2019] = {.lex_state = 7, .external_lex_state = 2},
  [2020] = {.lex_state = 7, .external_lex_state = 3},
  [2021] = {.lex_state = 8, .external_lex_state = 2},
  [2022] = {.lex_state = 7, .external_lex_state = 3},
  [2023] = {.lex_state = 7, .external_lex_state = 3},
  [2024] = {.lex_state = 7, .external_lex_state = 3},
  [2025] = {.lex_state = 7, .external_lex_state = 3},
  [2026] = {.lex_state = 7, .external_lex_state = 3},
  [2027] = {.lex_state = 7, .external_lex_state = 3},
  [2028] = {.lex_state = 7, .external_lex_state = 3},
  [2029] = {.lex_state = 7, .external_lex_state = 2},
  [2030] = {.lex_state = 7, .external_lex_state = 2},
  [2031] = {.lex_state = 7, .external_lex_state = 3},
  [2032] = {.lex_state = 7, .external_lex_state = 2},
  [2033] = {.lex_state = 7, .external_lex_state = 3},
  [2034] = {.lex_state = 7, .external_lex_state = 3},
  [2035] = {.lex_state = 7, .external_lex_state = 3},
  [2036] = {.lex_state = 7, .external_lex_state = 3},
  [2037] = {.lex_state = 7, .external_lex_state = 3},
  [2038] = {.lex_state = 7, .external_lex_state = 3},
  [2039] = {.lex_state = 7, .external_lex_state = 3},
  [2040] = {.lex_state = 7, .external_lex_state = 2},
  [2041] = {.lex_state = 7, .external_lex_state = 3},
  [2042] = {.lex_state = 7, .external_lex_state = 3},
  [2043] = {.lex_state = 7, .external_lex_state = 2},
  [2044] = {.lex_state = 7, .external_lex_state = 3},
  [2045] = {.lex_state = 7, .external_lex_state = 3},
  [2046] = {.lex_state = 7, .external_lex_state = 2},
  [2047] = {.lex_state = 7, .external_lex_state = 2},
  [2048] = {.lex_state = 7, .external_lex_state = 3},
  [2049] = {.lex_state = 7, .external_lex_state = 2},
  [2050] = {.lex_state = 7, .external_lex_state = 2},
  [2051] = {.lex_state = 7, .external_lex_state = 3},
  [2052] = {.lex_state = 7, .external_lex_state = 3},
  [2053] = {.lex_state = 7, .external_lex_state = 3},
  [2054] = {.lex_state = 7, .external_lex_state = 3},
  [2055] = {.lex_state = 7, .external_lex_state = 3},
  [2056] = {.lex_state = 7, .external_lex_state = 3},
  [2057] = {.lex_state = 7, .external_lex_state = 3},
  [2058] = {.lex_state = 7, .external_lex_state = 3},
  [2059] = {.lex_state = 7, .external_lex_state = 3},
  [2060] = {.lex_state = 7, .external_lex_state = 3},
  [2061] = {.lex_state = 12},
  [2062] = {.lex_state = 7, .external_lex_state = 2},
  [2063] = {.lex_state = 7, .external_lex_state = 3},
  [2064] = {.lex_state = 7, .external_lex_state = 3},
  [2065] = {.lex_state = 7, .external_lex_state = 3},
  [2066] = {.lex_state = 7, .external_lex_state = 2},
  [2067] = {.lex_state = 7, .external_lex_state = 2},
  [2068] = {.lex_state = 7, .external_lex_state = 2},
  [2069] = {.lex_state = 7, .external_lex_state = 2},
  [2070] = {.lex_state = 7, .external_lex_state = 3},
  [2071] = {.lex_state = 7, .external_lex_state = 3},
  [2072] = {.lex_state = 7, .external_lex_state = 2},
  [2073] = {.lex_state = 7, .external_lex_state = 2},
  [2074] = {.lex_state = 7, .external_lex_state = 3},
  [2075] = {.lex_state = 7, .external_lex_state = 3},
  [2076] = {.lex_state = 7, .external_lex_state = 3},
  [2077] = {.lex_state = 7, .external_lex_state = 3},
  [2078] = {.lex_state = 7, .external_lex_state = 2},
  [2079] = {.lex_state = 7, .external_lex_state = 3},
  [2080] = {.lex_state = 7, .external_lex_state = 3},
  [2081] = {.lex_state = 7, .external_lex_state = 3},
  [2082] = {.lex_state = 7, .external_lex_state = 3},
  [2083] = {.lex_state = 7, .external_lex_state = 3},
  [2084] = {.lex_state = 7, .external_lex_state = 3},
  [2085] = {.lex_state = 7, .external_lex_state = 3},
  [2086] = {.lex_state = 7, .external_lex_state = 2},
  [2087] = {.lex_state = 7, .external_lex_state = 3},
  [2088] = {.lex_state = 7, .external_lex_state = 2},
  [2089] = {.lex_state = 7, .external_lex_state = 2},
  [2090] = {.lex_state = 7, .external_lex_state = 3},
  [2091] = {.lex_state = 7, .external_lex_state = 3},
  [2092] = {.lex_state = 7, .external_lex_state = 2},
  [2093] = {.lex_state = 7, .external_lex_state = 2},
  [2094] = {.lex_state = 7, .external_lex_state = 3},
  [2095] = {.lex_state = 12},
  [2096] = {.lex_state = 7, .external_lex_state = 2},
  [2097] = {.lex_state = 7, .external_lex_state = 2},
  [2098] = {.lex_state = 7, .external_lex_state = 3},
  [2099] = {.lex_state = 7, .external_lex_state = 3},
  [2100] = {.lex_state = 7, .external_lex_state = 2},
  [2101] = {.lex_state = 7, .external_lex_state = 3},
  [2102] = {.lex_state = 7, .external_lex_state = 3},
  [2103] = {.lex_state = 7, .external_lex_state = 3},
  [2104] = {.lex_state = 7, .external_lex_state = 2},
  [2105] = {.lex_state = 7, .external_lex_state = 2},
  [2106] = {.lex_state = 7, .external_lex_state = 3},
  [2107] = {.lex_state = 7, .external_lex_state = 2},
  [2108] = {.lex_state = 7, .external_lex_state = 2},
  [2109] = {.lex_state = 7, .external_lex_state = 3},
  [2110] = {.lex_state = 7, .external_lex_state = 3},
  [2111] = {.lex_state = 7, .external_lex_state = 3},
  [2112] = {.lex_state = 7, .external_lex_state = 3},
  [2113] = {.lex_state = 7, .external_lex_state = 3},
  [2114] = {.lex_state = 7, .external_lex_state = 3},
  [2115] = {.lex_state = 7, .external_lex_state = 3},
  [2116] = {.lex_state = 7, .external_lex_state = 2},
  [2117] = {.lex_state = 7, .external_lex_state = 2},
  [2118] = {.lex_state = 7, .external_lex_state = 2},
  [2119] = {.lex_state = 7, .external_lex_state = 3},
  [2120] = {.lex_state = 7, .external_lex_state = 2},
  [2121] = {.lex_state = 7, .external_lex_state = 2},
  [2122] = {.lex_state = 7, .external_lex_state = 3},
  [2123] = {.lex_state = 7, .external_lex_state = 3},
  [2124] = {.lex_state = 7, .external_lex_state = 2},
  [2125] = {.lex_state = 7, .external_lex_state = 2},
  [2126] = {.lex_state = 7, .external_lex_state = 2},
  [2127] = {.lex_state = 7, .external_lex_state = 2},
  [2128] = {.lex_state = 7, .external_lex_state = 3},
  [2129] = {.lex_state = 7, .external_lex_state = 2},
  [2130] = {.lex_state = 7, .external_lex_state = 2},
  [2131] = {.lex_state = 7, .external_lex_state = 3},
  [2132] = {.lex_state = 7, .external_lex_state = 3},
  [2133] = {.lex_state = 7, .external_lex_state = 2},
  [2134] = {.lex_state = 7, .external_lex_state = 2},
  [2135] = {.lex_state = 7, .external_lex_state = 2},
  [2136] = {.lex_state = 7, .external_lex_state = 2},
  [2137] = {.lex_state = 7, .external_lex_state = 2},
  [2138] = {.lex_state = 7, .external_lex_state = 3},
  [2139] = {.lex_state = 7, .external_lex_state = 3},
  [2140] = {.lex_state = 7, .external_lex_state = 2},
  [2141] = {.lex_state = 7, .external_lex_state = 2},
  [2142] = {.lex_state = 7, .external_lex_state = 2},
  [2143] = {.lex_state = 7, .external_lex_state = 3},
  [2144] = {.lex_state = 7, .external_lex_state = 3},
  [2145] = {.lex_state = 7, .external_lex_state = 3},
  [2146] = {.lex_state = 7, .external_lex_state = 2},
  [2147] = {.lex_state = 8, .external_lex_state = 3},
  [2148] = {.lex_state = 7, .external_lex_state = 3},
  [2149] = {.lex_state = 7, .external_lex_state = 3},
  [2150] = {.lex_state = 7, .external_lex_state = 2},
  [2151] = {.lex_state = 7, .external_lex_state = 3},
  [2152] = {.lex_state = 7, .external_lex_state = 3},
  [2153] = {.lex_state = 7, .external_lex_state = 3},
  [2154] = {.lex_state = 7, .external_lex_state = 3},
  [2155] = {.lex_state = 7, .external_lex_state = 3},
  [2156] = {.lex_state = 7, .external_lex_state = 3},
  [2157] = {.lex_state = 7, .external_lex_state = 3},
  [2158] = {.lex_state = 7, .external_lex_state = 3},
  [2159] = {.lex_state = 7, .external_lex_state = 3},
  [2160] = {.lex_state = 7, .external_lex_state = 2},
  [2161] = {.lex_state = 7, .external_lex_state = 2},
  [2162] = {.lex_state = 7, .external_lex_state = 2},
  [2163] = {.lex_state = 7, .external_lex_state = 3},
  [2164] = {.lex_state = 7, .external_lex_state = 2},
  [2165] = {.lex_state = 7, .external_lex_state = 3},
  [2166] = {.lex_state = 7, .external_lex_state = 3},
  [2167] = {.lex_state = 7, .external_lex_state = 3},
  [2168] = {.lex_state = 7, .external_lex_state = 3},
  [2169] = {.lex_state = 7, .external_lex_state = 2},
  [2170] = {.lex_state = 7, .external_lex_state = 2},
  [2171] = {.lex_state = 7, .external_lex_state = 2},
  [2172] = {.lex_state = 7, .external_lex_state = 2},
  [2173] = {.lex_state = 12},
  [2174] = {.lex_state = 7, .external_lex_state = 2},
  [2175] = {.lex_state = 12},
  [2176] = {.lex_state = 7, .external_lex_state = 2},
  [2177] = {.lex_state = 7, .external_lex_state = 2},
  [2178] = {.lex_state = 7, .external_lex_state = 3},
  [2179] = {.lex_state = 7, .external_lex_state = 3},
  [2180] = {.lex_state = 7, .external_lex_state = 3},
  [2181] = {.lex_state = 7, .external_lex_state = 2},
  [2182] = {.lex_state = 7, .external_lex_state = 3},
  [2183] = {.lex_state = 7, .external_lex_state = 2},
  [2184] = {.lex_state = 7, .external_lex_state = 3},
  [2185] = {.lex_state = 7, .external_lex_state = 3},
  [2186] = {.lex_state = 7, .external_lex_state = 3},
  [2187] = {.lex_state = 12},
  [2188] = {.lex_state = 7, .external_lex_state = 3},
  [2189] = {.lex_state = 7, .external_lex_state = 2},
  [2190] = {.lex_state = 7, .external_lex_state = 2},
  [2191] = {.lex_state = 7, .external_lex_state = 3},
  [2192] = {.lex_state = 7, .external_lex_state = 2},
  [2193] = {.lex_state = 7, .external_lex_state = 2},
  [2194] = {.lex_state = 7, .external_lex_state = 2},
  [2195] = {.lex_state = 7, .external_lex_state = 3},
  [2196] = {.lex_state = 7, .external_lex_state = 3},
  [2197] = {.lex_state = 7, .external_lex_state = 2},
  [2198] = {.lex_state = 7, .external_lex_state = 3},
  [2199] = {.lex_state = 7, .external_lex_state = 3},
  [2200] = {.lex_state = 7, .external_lex_state = 3},
  [2201] = {.lex_state = 7, .external_lex_state = 3},
  [2202] = {.lex_state = 7, .external_lex_state = 3},
  [2203] = {.lex_state = 7, .external_lex_state = 3},
  [2204] = {.lex_state = 7, .external_lex_state = 3},
  [2205] = {.lex_state = 7, .external_lex_state = 3},
  [2206] = {.lex_state = 7, .external_lex_state = 2},
  [2207] = {.lex_state = 7, .external_lex_state = 3},
  [2208] = {.lex_state = 8, .external_lex_state = 3},
  [2209] = {.lex_state = 7, .external_lex_state = 3},
  [2210] = {.lex_state = 7, .external_lex_state = 3},
  [2211] = {.lex_state = 7, .external_lex_state = 3},
  [2212] = {.lex_state = 7, .external_lex_state = 3},
  [2213] = {.lex_state = 7, .external_lex_state = 3},
  [2214] = {.lex_state = 7, .external_lex_state = 3},
  [2215] = {.lex_state = 7, .external_lex_state = 3},
  [2216] = {.lex_state = 7, .external_lex_state = 2},
  [2217] = {.lex_state = 7, .external_lex_state = 3},
  [2218] = {.lex_state = 7, .external_lex_state = 2},
  [2219] = {.lex_state = 7, .external_lex_state = 3},
  [2220] = {.lex_state = 7, .external_lex_state = 2},
  [2221] = {.lex_state = 7, .external_lex_state = 2},
  [2222] = {.lex_state = 7, .external_lex_state = 2},
  [2223] = {.lex_state = 7, .external_lex_state = 2},
  [2224] = {.lex_state = 7, .external_lex_state = 2},
  [2225] = {.lex_state = 7, .external_lex_state = 2},
  [2226] = {.lex_state = 7, .external_lex_state = 2},
  [2227] = {.lex_state = 7, .external_lex_state = 2},
  [2228] = {.lex_state = 7, .external_lex_state = 2},
  [2229] = {.lex_state = 7, .external_lex_state = 2},
  [2230] = {.lex_state = 7, .external_lex_state = 3},
  [2231] = {.lex_state = 7, .external_lex_state = 2},
  [2232] = {.lex_state = 7, .external_lex_state = 3},
  [2233] = {.lex_state = 7, .external_lex_state = 2},
  [2234] = {.lex_state = 7, .external_lex_state = 2},
  [2235] = {.lex_state = 7, .external_lex_state = 3},
  [2236] = {.lex_state = 7, .external_lex_state = 3},
  [2237] = {.lex_state = 7, .external_lex_state = 3},
  [2238] = {.lex_state = 7, .external_lex_state = 2},
  [2239] = {.lex_state = 7, .external_lex_state = 3},
  [2240] = {.lex_state = 7, .external_lex_state = 3},
  [2241] = {.lex_state = 7, .external_lex_state = 3},
  [2242] = {.lex_state = 7, .external_lex_state = 3},
  [2243] = {.lex_state = 7, .external_lex_state = 2},
  [2244] = {.lex_state = 7, .external_lex_state = 2},
  [2245] = {.lex_state = 7, .external_lex_state = 2},
  [2246] = {.lex_state = 7, .external_lex_state = 2},
  [2247] = {.lex_state = 7, .external_lex_state = 3},
  [2248] = {.lex_state = 7, .external_lex_state = 3},
  [2249] = {.lex_state = 7, .external_lex_state = 2},
  [2250] = {.lex_state = 7, .external_lex_state = 2},
  [2251] = {.lex_state = 7, .external_lex_state = 2},
  [2252] = {.lex_state = 7, .external_lex_state = 3},
  [2253] = {.lex_state = 7, .external_lex_state = 3},
  [2254] = {.lex_state = 7, .external_lex_state = 3},
  [2255] = {.lex_state = 7, .external_lex_state = 3},
  [2256] = {.lex_state = 7, .external_lex_state = 3},
  [2257] = {.lex_state = 7, .external_lex_state = 2},
  [2258] = {.lex_state = 7, .external_lex_state = 2},
  [2259] = {.lex_state = 7, .external_lex_state = 2},
  [2260] = {.lex_state = 7, .external_lex_state = 2},
  [2261] = {.lex_state = 7, .external_lex_state = 2},
  [2262] = {.lex_state = 7, .external_lex_state = 2},
  [2263] = {.lex_state = 7, .external_lex_state = 2},
  [2264] = {.lex_state = 7, .external_lex_state = 2},
  [2265] = {.lex_state = 7, .external_lex_state = 3},
  [2266] = {.lex_state = 7, .external_lex_state = 2},
  [2267] = {.lex_state = 7, .external_lex_state = 2},
  [2268] = {.lex_state = 7, .external_lex_state = 2},
  [2269] = {.lex_state = 7, .external_lex_state = 2},
  [2270] = {.lex_state = 7, .external_lex_state = 3},
  [2271] = {.lex_state = 7, .external_lex_state = 2},
  [2272] = {.lex_state = 7, .external_lex_state = 2},
  [2273] = {.lex_state = 7, .external_lex_state = 2},
  [2274] = {.lex_state = 7, .external_lex_state = 2},
  [2275] = {.lex_state = 7, .external_lex_state = 2},
  [2276] = {.lex_state = 7, .external_lex_state = 2},
  [2277] = {.lex_state = 7, .external_lex_state = 2},
  [2278] = {.lex_state = 7, .external_lex_state = 3},
  [2279] = {.lex_state = 7, .external_lex_state = 2},
  [2280] = {.lex_state = 7, .external_lex_state = 2},
  [2281] = {.lex_state = 7, .external_lex_state = 2},
  [2282] = {.lex_state = 7, .external_lex_state = 2},
  [2283] = {.lex_state = 7, .external_lex_state = 2},
  [2284] = {.lex_state = 7, .external_lex_state = 2},
  [2285] = {.lex_state = 7, .external_lex_state = 2},
  [2286] = {.lex_state = 7, .external_lex_state = 2},
  [2287] = {.lex_state = 7, .external_lex_state = 2},
  [2288] = {.lex_state = 7, .external_lex_state = 2},
  [2289] = {.lex_state = 7, .external_lex_state = 2},
  [2290] = {.lex_state = 7, .external_lex_state = 2},
  [2291] = {.lex_state = 7, .external_lex_state = 2},
  [2292] = {.lex_state = 7, .external_lex_state = 2},
  [2293] = {.lex_state = 7, .external_lex_state = 2},
  [2294] = {.lex_state = 7, .external_lex_state = 2},
  [2295] = {.lex_state = 7, .external_lex_state = 2},
  [2296] = {.lex_state = 7, .external_lex_state = 2},
  [2297] = {.lex_state = 7, .external_lex_state = 2},
  [2298] = {.lex_state = 7, .external_lex_state = 2},
  [2299] = {.lex_state = 7, .external_lex_state = 2},
  [2300] = {.lex_state = 7, .external_lex_state = 2},
  [2301] = {.lex_state = 7, .external_lex_state = 2},
  [2302] = {.lex_state = 7, .external_lex_state = 2},
  [2303] = {.lex_state = 7, .external_lex_state = 2},
  [2304] = {.lex_state = 7, .external_lex_state = 2},
  [2305] = {.lex_state = 7, .external_lex_state = 2},
  [2306] = {.lex_state = 7, .external_lex_state = 2},
  [2307] = {.lex_state = 7, .external_lex_state = 2},
  [2308] = {.lex_state = 7, .external_lex_state = 2},
  [2309] = {.lex_state = 7, .external_lex_state = 2},
  [2310] = {.lex_state = 7, .external_lex_state = 2},
  [2311] = {.lex_state = 7, .external_lex_state = 2},
  [2312] = {.lex_state = 7, .external_lex_state = 2},
  [2313] = {.lex_state = 7, .external_lex_state = 2},
  [2314] = {.lex_state = 7, .external_lex_state = 2},
  [2315] = {.lex_state = 7, .external_lex_state = 2},
  [2316] = {.lex_state = 7, .external_lex_state = 2},
  [2317] = {.lex_state = 12, .external_lex_state = 4},
  [2318] = {.lex_state = 12, .external_lex_state = 4},
  [2319] = {.lex_state = 7, .external_lex_state = 2},
  [2320] = {.lex_state = 12},
  [2321] = {.lex_state = 12, .external_lex_state = 4},
  [2322] = {.lex_state = 7, .external_lex_state = 3},
  [2323] = {.lex_state = 93, .external_lex_state = 4},
  [2324] = {.lex_state = 12, .external_lex_state = 4},
  [2325] = {.lex_state = 93, .external_lex_state = 4},
  [2326] = {.lex_state = 12, .external_lex_state = 4},
  [2327] = {.lex_state = 7, .external_lex_state = 2},
  [2328] = {.lex_state = 12, .external_lex_state = 4},
  [2329] = {.lex_state = 12, .external_lex_state = 4},
  [2330] = {.lex_state = 12},
  [2331] = {.lex_state = 7, .external_lex_state = 3},
  [2332] = {.lex_state = 12, .external_lex_state = 4},
  [2333] = {.lex_state = 7, .external_lex_state = 2},
  [2334] = {.lex_state = 7, .external_lex_state = 2},
  [2335] = {.lex_state = 12, .external_lex_state = 4},
  [2336] = {.lex_state = 12},
  [2337] = {.lex_state = 7, .external_lex_state = 2},
  [2338] = {.lex_state = 7, .external_lex_state = 2},
  [2339] = {.lex_state = 12, .external_lex_state = 4},
  [2340] = {.lex_state = 12, .external_lex_state = 4},
  [2341] = {.lex_state = 12},
  [2342] = {.lex_state = 12, .external_lex_state = 4},
  [2343] = {.lex_state = 7, .external_lex_state = 2},
  [2344] = {.lex_state = 7, .external_lex_state = 2},
  [2345] = {.lex_state = 12},
  [2346] = {.lex_state = 12},
  [2347] = {.lex_state = 12, .external_lex_state = 4},
  [2348] = {.lex_state = 8, .external_lex_state = 2},
  [2349] = {.lex_state = 7, .external_lex_state = 2},
  [2350] = {.lex_state = 12, .external_lex_state = 4},
  [2351] = {.lex_state = 7, .external_lex_state = 2},
  [2352] = {.lex_state = 7, .external_lex_state = 2},
  [2353] = {.lex_state = 7, .external_lex_state = 2},
  [2354] = {.lex_state = 7, .external_lex_state = 2},
  [2355] = {.lex_state = 7, .external_lex_state = 2},
  [2356] = {.lex_state = 7, .external_lex_state = 2},
  [2357] = {.lex_state = 7, .external_lex_state = 2},
  [2358] = {.lex_state = 93},
  [2359] = {.lex_state = 7, .external_lex_state = 2},
  [2360] = {.lex_state = 12, .external_lex_state = 4},
  [2361] = {.lex_state = 12},
  [2362] = {.lex_state = 7, .external_lex_state = 3},
  [2363] = {.lex_state = 7, .external_lex_state = 2},
  [2364] = {.lex_state = 12, .external_lex_state = 4},
  [2365] = {.lex_state = 7, .external_lex_state = 2},
  [2366] = {.lex_state = 7, .external_lex_state = 2},
  [2367] = {.lex_state = 12},
  [2368] = {.lex_state = 12, .external_lex_state = 4},
  [2369] = {.lex_state = 7, .external_lex_state = 2},
  [2370] = {.lex_state = 7, .external_lex_state = 2},
  [2371] = {.lex_state = 7, .external_lex_state = 2},
  [2372] = {.lex_state = 7, .external_lex_state = 2},
  [2373] = {.lex_state = 7, .external_lex_state = 2},
  [2374] = {.lex_state = 7, .external_lex_state = 2},
  [2375] = {.lex_state = 7, .external_lex_state = 2},
  [2376] = {.lex_state = 12},
  [2377] = {.lex_state = 7, .external_lex_state = 2},
  [2378] = {.lex_state = 7, .external_lex_state = 2},
  [2379] = {.lex_state = 7, .external_lex_state = 2},
  [2380] = {.lex_state = 12, .external_lex_state = 4},
  [2381] = {.lex_state = 7, .external_lex_state = 2},
  [2382] = {.lex_state = 7, .external_lex_state = 2},
  [2383] = {.lex_state = 12, .external_lex_state = 4},
  [2384] = {.lex_state = 7, .external_lex_state = 2},
  [2385] = {.lex_state = 12, .external_lex_state = 4},
  [2386] = {.lex_state = 7, .external_lex_state = 2},
  [2387] = {.lex_state = 12, .external_lex_state = 4},
  [2388] = {.lex_state = 12},
  [2389] = {.lex_state = 12},
  [2390] = {.lex_state = 7, .external_lex_state = 2},
  [2391] = {.lex_state = 12, .external_lex_state = 4},
  [2392] = {.lex_state = 7, .external_lex_state = 2},
  [2393] = {.lex_state = 7, .external_lex_state = 2},
  [2394] = {.lex_state = 7, .external_lex_state = 2},
  [2395] = {.lex_state = 12, .external_lex_state = 4},
  [2396] = {.lex_state = 7, .external_lex_state = 2},
  [2397] = {.lex_state = 7, .external_lex_state = 3},
  [2398] = {.lex_state = 7, .external_lex_state = 2},
  [2399] = {.lex_state = 7, .external_lex_state = 2},
  [2400] = {.lex_state = 12},
  [2401] = {.lex_state = 7, .external_lex_state = 2},
  [2402] = {.lex_state = 12},
  [2403] = {.lex_state = 7, .external_lex_state = 2},
  [2404] = {.lex_state = 93},
  [2405] = {.lex_state = 7, .external_lex_state = 2},
  [2406] = {.lex_state = 12},
  [2407] = {.lex_state = 7, .external_lex_state = 3},
  [2408] = {.lex_state = 12},
  [2409] = {.lex_state = 12},
  [2410] = {.lex_state = 12},
  [2411] = {.lex_state = 12},
  [2412] = {.lex_state = 93},
  [2413] = {.lex_state = 12},
  [2414] = {.lex_state = 12},
  [2415] = {.lex_state = 93},
  [2416] = {.lex_state = 7, .external_lex_state = 2},
  [2417] = {.lex_state = 7, .external_lex_state = 2},
  [2418] = {.lex_state = 7, .external_lex_state = 2},
  [2419] = {.lex_state = 12},
  [2420] = {.lex_state = 93},
  [2421] = {.lex_state = 7, .external_lex_state = 2},
  [2422] = {.lex_state = 12},
  [2423] = {.lex_state = 12},
  [2424] = {.lex_state = 12},
  [2425] = {.lex_state = 12},
  [2426] = {.lex_state = 12},
  [2427] = {.lex_state = 12},
  [2428] = {.lex_state = 7, .external_lex_state = 2},
  [2429] = {.lex_state = 7, .external_lex_state = 2},
  [2430] = {.lex_state = 7, .external_lex_state = 3},
  [2431] = {.lex_state = 12},
  [2432] = {.lex_state = 12},
  [2433] = {.lex_state = 93},
  [2434] = {.lex_state = 12},
  [2435] = {.lex_state = 7, .external_lex_state = 3},
  [2436] = {.lex_state = 12},
  [2437] = {.lex_state = 11},
  [2438] = {.lex_state = 7, .external_lex_state = 2},
  [2439] = {.lex_state = 7, .external_lex_state = 2},
  [2440] = {.lex_state = 7, .external_lex_state = 2},
  [2441] = {.lex_state = 7, .external_lex_state = 2},
  [2442] = {.lex_state = 93},
  [2443] = {.lex_state = 11},
  [2444] = {.lex_state = 12},
  [2445] = {.lex_state = 7, .external_lex_state = 2},
  [2446] = {.lex_state = 5},
  [2447] = {.lex_state = 8, .external_lex_state = 2},
  [2448] = {.lex_state = 12},
  [2449] = {.lex_state = 7, .external_lex_state = 2},
  [2450] = {.lex_state = 93},
  [2451] = {.lex_state = 93},
  [2452] = {.lex_state = 93},
  [2453] = {.lex_state = 93},
  [2454] = {.lex_state = 93},
  [2455] = {.lex_state = 93},
  [2456] = {.lex_state = 93},
  [2457] = {.lex_state = 93},
  [2458] = {.lex_state = 93},
  [2459] = {.lex_state = 93},
  [2460] = {.lex_state = 5},
  [2461] = {.lex_state = 7, .external_lex_state = 2},
  [2462] = {.lex_state = 7, .external_lex_state = 2},
  [2463] = {.lex_state = 11},
  [2464] = {.lex_state = 7, .external_lex_state = 2},
  [2465] = {.lex_state = 12},
  [2466] = {.lex_state = 93},
  [2467] = {.lex_state = 7, .external_lex_state = 2},
  [2468] = {.lex_state = 93},
  [2469] = {.lex_state = 93},
  [2470] = {.lex_state = 12},
  [2471] = {.lex_state = 12},
  [2472] = {.lex_state = 93},
  [2473] = {.lex_state = 93},
  [2474] = {.lex_state = 93},
  [2475] = {.lex_state = 12},
  [2476] = {.lex_state = 11},
  [2477] = {.lex_state = 7, .external_lex_state = 2},
  [2478] = {.lex_state = 93},
  [2479] = {.lex_state = 93},
  [2480] = {.lex_state = 11},
  [2481] = {.lex_state = 93},
  [2482] = {.lex_state = 11},
  [2483] = {.lex_state = 93},
  [2484] = {.lex_state = 93},
  [2485] = {.lex_state = 11},
  [2486] = {.lex_state = 11},
  [2487] = {.lex_state = 11},
  [2488] = {.lex_state = 11},
  [2489] = {.lex_state = 93, .external_lex_state = 4},
  [2490] = {.lex_state = 11},
  [2491] = {.lex_state = 11},
  [2492] = {.lex_state = 11},
  [2493] = {.lex_state = 11},
  [2494] = {.lex_state = 93, .external_lex_state = 4},
  [2495] = {.lex_state = 11},
  [2496] = {.lex_state = 11},
  [2497] = {.lex_state = 11},
  [2498] = {.lex_state = 93},
  [2499] = {.lex_state = 12},
  [2500] = {.lex_state = 93},
  [2501] = {.lex_state = 93},
  [2502] = {.lex_state = 11},
  [2503] = {.lex_state = 93, .external_lex_state = 4},
  [2504] = {.lex_state = 93, .external_lex_state = 4},
  [2505] = {.lex_state = 11},
  [2506] = {.lex_state = 93, .external_lex_state = 4},
  [2507] = {.lex_state = 93},
  [2508] = {.lex_state = 93},
  [2509] = {.lex_state = 93},
  [2510] = {.lex_state = 93},
  [2511] = {.lex_state = 93},
  [2512] = {.lex_state = 93},
  [2513] = {.lex_state = 93},
  [2514] = {.lex_state = 93},
  [2515] = {.lex_state = 93},
  [2516] = {.lex_state = 93},
  [2517] = {.lex_state = 93},
  [2518] = {.lex_state = 93},
  [2519] = {.lex_state = 93, .external_lex_state = 4},
  [2520] = {.lex_state = 93},
  [2521] = {.lex_state = 93},
  [2522] = {.lex_state = 93},
  [2523] = {.lex_state = 93},
  [2524] = {.lex_state = 93},
  [2525] = {.lex_state = 93},
  [2526] = {.lex_state = 93},
  [2527] = {.lex_state = 93, .external_lex_state = 4},
  [2528] = {.lex_state = 93},
  [2529] = {.lex_state = 93},
  [2530] = {.lex_state = 93},
  [2531] = {.lex_state = 93},
  [2532] = {.lex_state = 93},
  [2533] = {.lex_state = 93},
  [2534] = {.lex_state = 93},
  [2535] = {.lex_state = 93},
  [2536] = {.lex_state = 93},
  [2537] = {.lex_state = 93},
  [2538] = {.lex_state = 93, .external_lex_state = 4},
  [2539] = {.lex_state = 93},
  [2540] = {.lex_state = 93, .external_lex_state = 4},
  [2541] = {.lex_state = 93},
  [2542] = {.lex_state = 93},
  [2543] = {.lex_state = 93, .external_lex_state = 4},
  [2544] = {.lex_state = 93},
  [2545] = {.lex_state = 93},
  [2546] = {.lex_state = 93},
  [2547] = {.lex_state = 93},
  [2548] = {.lex_state = 93},
  [2549] = {.lex_state = 93, .external_lex_state = 4},
  [2550] = {.lex_state = 93, .external_lex_state = 4},
  [2551] = {.lex_state = 93},
  [2552] = {.lex_state = 93, .external_lex_state = 4},
  [2553] = {.lex_state = 93},
  [2554] = {.lex_state = 93},
  [2555] = {.lex_state = 93},
  [2556] = {.lex_state = 93, .external_lex_state = 4},
  [2557] = {.lex_state = 93},
  [2558] = {.lex_state = 93},
  [2559] = {.lex_state = 93},
  [2560] = {.lex_state = 93},
  [2561] = {.lex_state = 93},
  [2562] = {.lex_state = 93},
  [2563] = {.lex_state = 93},
  [2564] = {.lex_state = 93},
  [2565] = {.lex_state = 93},
  [2566] = {.lex_state = 93},
  [2567] = {.lex_state = 93},
  [2568] = {.lex_state = 93},
  [2569] = {.lex_state = 93},
  [2570] = {.lex_state = 93},
  [2571] = {.lex_state = 93},
  [2572] = {.lex_state = 93},
  [2573] = {.lex_state = 93},
  [2574] = {.lex_state = 93},
  [2575] = {.lex_state = 93},
  [2576] = {.lex_state = 93},
  [2577] = {.lex_state = 93},
  [2578] = {.lex_state = 93},
  [2579] = {.lex_state = 93},
  [2580] = {.lex_state = 93},
  [2581] = {.lex_state = 93},
  [2582] = {.lex_state = 93},
  [2583] = {.lex_state = 93},
  [2584] = {.lex_state = 93},
  [2585] = {.lex_state = 93},
  [2586] = {.lex_state = 93},
  [2587] = {.lex_state = 93},
  [2588] = {.lex_state = 93},
  [2589] = {.lex_state = 93},
  [2590] = {.lex_state = 93},
  [2591] = {.lex_state = 93},
  [2592] = {.lex_state = 93},
  [2593] = {.lex_state = 93},
  [2594] = {.lex_state = 93},
  [2595] = {.lex_state = 93},
  [2596] = {.lex_state = 93},
  [2597] = {.lex_state = 93},
  [2598] = {.lex_state = 93},
  [2599] = {.lex_state = 93},
  [2600] = {.lex_state = 93},
  [2601] = {.lex_state = 93},
  [2602] = {.lex_state = 93},
  [2603] = {.lex_state = 93},
  [2604] = {.lex_state = 93},
  [2605] = {.lex_state = 93},
  [2606] = {.lex_state = 93},
  [2607] = {.lex_state = 93},
  [2608] = {.lex_state = 93},
  [2609] = {.lex_state = 93},
  [2610] = {.lex_state = 93},
  [2611] = {.lex_state = 93},
  [2612] = {.lex_state = 93},
  [2613] = {.lex_state = 93},
  [2614] = {.lex_state = 93},
  [2615] = {.lex_state = 93},
  [2616] = {.lex_state = 93},
  [2617] = {.lex_state = 93},
  [2618] = {.lex_state = 93},
  [2619] = {.lex_state = 93},
  [2620] = {.lex_state = 93},
  [2621] = {.lex_state = 93},
  [2622] = {.lex_state = 93},
  [2623] = {.lex_state = 93},
  [2624] = {.lex_state = 93},
  [2625] = {.lex_state = 93},
  [2626] = {.lex_state = 93},
  [2627] = {.lex_state = 93},
  [2628] = {.lex_state = 93},
  [2629] = {.lex_state = 93},
  [2630] = {.lex_state = 93},
  [2631] = {.lex_state = 93},
  [2632] = {.lex_state = 93},
  [2633] = {.lex_state = 93},
  [2634] = {.lex_state = 93},
  [2635] = {.lex_state = 93},
  [2636] = {.lex_state = 93},
  [2637] = {.lex_state = 93},
  [2638] = {.lex_state = 93},
  [2639] = {.lex_state = 93},
  [2640] = {.lex_state = 93},
  [2641] = {.lex_state = 93},
  [2642] = {.lex_state = 93},
  [2643] = {.lex_state = 93},
  [2644] = {.lex_state = 93},
  [2645] = {.lex_state = 93},
  [2646] = {.lex_state = 93},
  [2647] = {.lex_state = 93},
  [2648] = {.lex_state = 93},
  [2649] = {.lex_state = 93},
  [2650] = {.lex_state = 93},
  [2651] = {.lex_state = 93},
  [2652] = {.lex_state = 93},
  [2653] = {.lex_state = 93},
  [2654] = {.lex_state = 93},
  [2655] = {.lex_state = 93},
  [2656] = {.lex_state = 93},
  [2657] = {.lex_state = 93},
  [2658] = {.lex_state = 93},
  [2659] = {.lex_state = 93},
  [2660] = {.lex_state = 93},
  [2661] = {.lex_state = 93},
  [2662] = {.lex_state = 93},
  [2663] = {.lex_state = 93},
  [2664] = {.lex_state = 93},
  [2665] = {.lex_state = 93},
  [2666] = {.lex_state = 93},
  [2667] = {.lex_state = 93},
  [2668] = {.lex_state = 93},
  [2669] = {.lex_state = 93},
  [2670] = {.lex_state = 93},
  [2671] = {.lex_state = 93},
  [2672] = {.lex_state = 93},
  [2673] = {.lex_state = 93},
  [2674] = {.lex_state = 93},
  [2675] = {.lex_state = 93},
  [2676] = {.lex_state = 93},
  [2677] = {.lex_state = 93},
  [2678] = {.lex_state = 93},
  [2679] = {.lex_state = 93},
  [2680] = {.lex_state = 93},
  [2681] = {.lex_state = 93},
  [2682] = {.lex_state = 93},
  [2683] = {.lex_state = 93},
  [2684] = {.lex_state = 93},
  [2685] = {.lex_state = 93},
  [2686] = {.lex_state = 93},
  [2687] = {.lex_state = 93},
  [2688] = {.lex_state = 93},
  [2689] = {.lex_state = 93},
  [2690] = {.lex_state = 93},
  [2691] = {.lex_state = 93},
  [2692] = {.lex_state = 93},
  [2693] = {.lex_state = 93},
  [2694] = {.lex_state = 93},
  [2695] = {.lex_state = 93},
  [2696] = {.lex_state = 93},
  [2697] = {.lex_state = 93},
  [2698] = {.lex_state = 93},
  [2699] = {.lex_state = 93},
  [2700] = {.lex_state = 93},
  [2701] = {.lex_state = 93},
  [2702] = {.lex_state = 93},
  [2703] = {.lex_state = 93},
  [2704] = {.lex_state = 93},
  [2705] = {.lex_state = 93},
  [2706] = {.lex_state = 93},
  [2707] = {.lex_state = 93},
  [2708] = {.lex_state = 93},
  [2709] = {.lex_state = 93},
  [2710] = {.lex_state = 93},
  [2711] = {.lex_state = 93},
  [2712] = {.lex_state = 93},
  [2713] = {.lex_state = 93},
  [2714] = {.lex_state = 93},
  [2715] = {.lex_state = 93},
  [2716] = {.lex_state = 93},
  [2717] = {.lex_state = 93},
  [2718] = {.lex_state = 93},
  [2719] = {.lex_state = 93},
  [2720] = {.lex_state = 93},
  [2721] = {.lex_state = 93},
  [2722] = {.lex_state = 93},
  [2723] = {.lex_state = 93},
  [2724] = {.lex_state = 93},
  [2725] = {.lex_state = 93},
  [2726] = {.lex_state = 93},
  [2727] = {.lex_state = 93},
  [2728] = {.lex_state = 93},
  [2729] = {.lex_state = 93},
  [2730] = {.lex_state = 93},
  [2731] = {.lex_state = 93},
  [2732] = {.lex_state = 93},
  [2733] = {.lex_state = 93},
  [2734] = {.lex_state = 93},
  [2735] = {.lex_state = 93},
  [2736] = {.lex_state = 93},
  [2737] = {.lex_state = 93},
  [2738] = {.lex_state = 93},
  [2739] = {.lex_state = 93},
  [2740] = {.lex_state = 93},
  [2741] = {.lex_state = 93},
  [2742] = {.lex_state = 93},
  [2743] = {.lex_state = 93},
  [2744] = {.lex_state = 93},
  [2745] = {.lex_state = 93},
  [2746] = {.lex_state = 93},
  [2747] = {.lex_state = 93},
  [2748] = {.lex_state = 93},
  [2749] = {.lex_state = 93},
  [2750] = {.lex_state = 93},
  [2751] = {.lex_state = 93},
  [2752] = {.lex_state = 93},
  [2753] = {.lex_state = 93},
  [2754] = {.lex_state = 93},
  [2755] = {.lex_state = 93},
  [2756] = {.lex_state = 93},
  [2757] = {.lex_state = 93},
  [2758] = {.lex_state = 93},
  [2759] = {.lex_state = 93},
  [2760] = {.lex_state = 93},
  [2761] = {.lex_state = 93},
  [2762] = {.lex_state = 93},
  [2763] = {.lex_state = 93},
  [2764] = {.lex_state = 93},
  [2765] = {.lex_state = 93},
  [2766] = {.lex_state = 93},
  [2767] = {.lex_state = 5},
  [2768] = {.lex_state = 93},
  [2769] = {.lex_state = 93},
  [2770] = {.lex_state = 93},
  [2771] = {.lex_state = 93},
  [2772] = {.lex_state = 93},
  [2773] = {.lex_state = 93},
  [2774] = {.lex_state = 93},
  [2775] = {.lex_state = 93},
  [2776] = {.lex_state = 93, .external_lex_state = 4},
  [2777] = {.lex_state = 93},
  [2778] = {.lex_state = 93},
  [2779] = {.lex_state = 93},
  [2780] = {.lex_state = 5},
  [2781] = {.lex_state = 93},
  [2782] = {.lex_state = 93},
  [2783] = {.lex_state = 5},
  [2784] = {.lex_state = 93},
  [2785] = {.lex_state = 93},
  [2786] = {.lex_state = 93},
  [2787] = {.lex_state = 93},
  [2788] = {.lex_state = 20},
  [2789] = {.lex_state = 20},
  [2790] = {.lex_state = 20},
  [2791] = {.lex_state = 20},
  [2792] = {.lex_state = 20},
  [2793] = {.lex_state = 20},
  [2794] = {.lex_state = 20},
  [2795] = {.lex_state = 15, .external_lex_state = 4},
  [2796] = {.lex_state = 20},
  [2797] = {.lex_state = 20},
  [2798] = {.lex_state = 20},
  [2799] = {.lex_state = 20},
  [2800] = {.lex_state = 20},
  [2801] = {.lex_state = 20},
  [2802] = {.lex_state = 20},
  [2803] = {.lex_state = 20},
  [2804] = {.lex_state = 20},
  [2805] = {.lex_state = 20},
  [2806] = {.lex_state = 20},
  [2807] = {.lex_state = 20},
  [2808] = {.lex_state = 20},
  [2809] = {.lex_state = 20},
  [2810] = {.lex_state = 20},
  [2811] = {.lex_state = 20},
  [2812] = {.lex_state = 20},
  [2813] = {.lex_state = 20},
  [2814] = {.lex_state = 20},
  [2815] = {.lex_state = 20},
  [2816] = {.lex_state = 20},
  [2817] = {.lex_state = 20},
  [2818] = {.lex_state = 20},
  [2819] = {.lex_state = 20},
  [2820] = {.lex_state = 20},
  [2821] = {.lex_state = 15},
  [2822] = {.lex_state = 20},
  [2823] = {.lex_state = 20},
  [2824] = {.lex_state = 15, .external_lex_state = 4},
  [2825] = {.lex_state = 20},
  [2826] = {.lex_state = 20},
  [2827] = {.lex_state = 20},
  [2828] = {.lex_state = 20},
  [2829] = {.lex_state = 20},
  [2830] = {.lex_state = 20},
  [2831] = {.lex_state = 15},
  [2832] = {.lex_state = 20},
  [2833] = {.lex_state = 20},
  [2834] = {.lex_state = 20},
  [2835] = {.lex_state = 20},
  [2836] = {.lex_state = 11},
  [2837] = {.lex_state = 16},
  [2838] = {.lex_state = 11},
  [2839] = {.lex_state = 11},
  [2840] = {.lex_state = 11},
  [2841] = {.lex_state = 11},
  [2842] = {.lex_state = 93},
  [2843] = {.lex_state = 11},
  [2844] = {.lex_state = 11},
  [2845] = {.lex_state = 11},
  [2846] = {.lex_state = 11},
  [2847] = {.lex_state = 11},
  [2848] = {.lex_state = 11},
  [2849] = {.lex_state = 11},
  [2850] = {.lex_state = 11},
  [2851] = {.lex_state = 11},
  [2852] = {.lex_state = 11},
  [2853] = {.lex_state = 11},
  [2854] = {.lex_state = 11},
  [2855] = {.lex_state = 11},
  [2856] = {.lex_state = 93},
  [2857] = {.lex_state = 11},
  [2858] = {.lex_state = 93},
  [2859] = {.lex_state = 15, .external_lex_state = 4},
  [2860] = {.lex_state = 11},
  [2861] = {.lex_state = 93},
  [2862] = {.lex_state = 11},
  [2863] = {.lex_state = 93},
  [2864] = {.lex_state = 11},
  [2865] = {.lex_state = 93},
  [2866] = {.lex_state = 93},
  [2867] = {.lex_state = 11},
  [2868] = {.lex_state = 11},
  [2869] = {.lex_state = 11},
  [2870] = {.lex_state = 20, .external_lex_state = 4},
  [2871] = {.lex_state = 20, .external_lex_state = 4},
  [2872] = {.lex_state = 20, .external_lex_state = 4},
  [2873] = {.lex_state = 11},
  [2874] = {.lex_state = 11},
  [2875] = {.lex_state = 11},
  [2876] = {.lex_state = 93},
  [2877] = {.lex_state = 11},
  [2878] = {.lex_state = 93},
  [2879] = {.lex_state = 11},
  [2880] = {.lex_state = 11},
  [2881] = {.lex_state = 11},
  [2882] = {.lex_state = 20, .external_lex_state = 4},
  [2883] = {.lex_state = 11},
  [2884] = {.lex_state = 20, .external_lex_state = 4},
  [2885] = {.lex_state = 20, .external_lex_state = 4},
  [2886] = {.lex_state = 20, .external_lex_state = 4},
  [2887] = {.lex_state = 20, .external_lex_state = 4},
  [2888] = {.lex_state = 20, .external_lex_state = 4},
  [2889] = {.lex_state = 20, .external_lex_state = 4},
  [2890] = {.lex_state = 20, .external_lex_state = 4},
  [2891] = {.lex_state = 20, .external_lex_state = 4},
  [2892] = {.lex_state = 20, .external_lex_state = 4},
  [2893] = {.lex_state = 20, .external_lex_state = 4},
  [2894] = {.lex_state = 20, .external_lex_state = 4},
  [2895] = {.lex_state = 20, .external_lex_state = 4},
  [2896] = {.lex_state = 20, .external_lex_state = 4},
  [2897] = {.lex_state = 93},
  [2898] = {.lex_state = 20, .external_lex_state = 4},
  [2899] = {.lex_state = 93},
  [2900] = {.lex_state = 93},
  [2901] = {.lex_state = 15, .external_lex_state = 4},
  [2902] = {.lex_state = 20, .external_lex_state = 4},
  [2903] = {.lex_state = 12, .external_lex_state = 4},
  [2904] = {.lex_state = 11},
  [2905] = {.lex_state = 11},
  [2906] = {.lex_state = 20, .external_lex_state = 4},
  [2907] = {.lex_state = 20, .external_lex_state = 4},
  [2908] = {.lex_state = 12, .external_lex_state = 4},
  [2909] = {.lex_state = 20, .external_lex_state = 4},
  [2910] = {.lex_state = 11},
  [2911] = {.lex_state = 20, .external_lex_state = 4},
  [2912] = {.lex_state = 12, .external_lex_state = 4},
  [2913] = {.lex_state = 11},
  [2914] = {.lex_state = 11},
  [2915] = {.lex_state = 93},
  [2916] = {.lex_state = 93},
  [2917] = {.lex_state = 93},
  [2918] = {.lex_state = 93},
  [2919] = {.lex_state = 11},
  [2920] = {.lex_state = 11},
  [2921] = {.lex_state = 20, .external_lex_state = 4},
  [2922] = {.lex_state = 12, .external_lex_state = 4},
  [2923] = {.lex_state = 12, .external_lex_state = 4},
  [2924] = {.lex_state = 12, .external_lex_state = 4},
  [2925] = {.lex_state = 20, .external_lex_state = 4},
  [2926] = {.lex_state = 93},
  [2927] = {.lex_state = 93},
  [2928] = {.lex_state = 93},
  [2929] = {.lex_state = 93},
  [2930] = {.lex_state = 20, .external_lex_state = 4},
  [2931] = {.lex_state = 20, .external_lex_state = 4},
  [2932] = {.lex_state = 93},
  [2933] = {.lex_state = 93},
  [2934] = {.lex_state = 93},
  [2935] = {.lex_state = 93},
  [2936] = {.lex_state = 93},
  [2937] = {.lex_state = 12, .external_lex_state = 4},
  [2938] = {.lex_state = 20, .external_lex_state = 4},
  [2939] = {.lex_state = 20, .external_lex_state = 4},
  [2940] = {.lex_state = 20, .external_lex_state = 4},
  [2941] = {.lex_state = 20, .external_lex_state = 4},
  [2942] = {.lex_state = 93},
  [2943] = {.lex_state = 93},
  [2944] = {.lex_state = 93},
  [2945] = {.lex_state = 93},
  [2946] = {.lex_state = 20, .external_lex_state = 4},
  [2947] = {.lex_state = 20, .external_lex_state = 4},
  [2948] = {.lex_state = 20, .external_lex_state = 4},
  [2949] = {.lex_state = 20, .external_lex_state = 4},
  [2950] = {.lex_state = 20, .external_lex_state = 4},
  [2951] = {.lex_state = 20, .external_lex_state = 4},
  [2952] = {.lex_state = 12, .external_lex_state = 4},
  [2953] = {.lex_state = 15, .external_lex_state = 5},
  [2954] = {.lex_state = 15, .external_lex_state = 4},
  [2955] = {.lex_state = 12, .external_lex_state = 4},
  [2956] = {.lex_state = 12, .external_lex_state = 4},
  [2957] = {.lex_state = 12, .external_lex_state = 4},
  [2958] = {.lex_state = 12, .external_lex_state = 4},
  [2959] = {.lex_state = 20, .external_lex_state = 4},
  [2960] = {.lex_state = 20, .external_lex_state = 5},
  [2961] = {.lex_state = 20, .external_lex_state = 5},
  [2962] = {.lex_state = 20, .external_lex_state = 5},
  [2963] = {.lex_state = 93},
  [2964] = {.lex_state = 12, .external_lex_state = 4},
  [2965] = {.lex_state = 20, .external_lex_state = 4},
  [2966] = {.lex_state = 12, .external_lex_state = 4},
  [2967] = {.lex_state = 93},
  [2968] = {.lex_state = 12, .external_lex_state = 4},
  [2969] = {.lex_state = 20, .external_lex_state = 4},
  [2970] = {.lex_state = 15},
  [2971] = {.lex_state = 20, .external_lex_state = 4},
  [2972] = {.lex_state = 12, .external_lex_state = 4},
  [2973] = {.lex_state = 20, .external_lex_state = 4},
  [2974] = {.lex_state = 16, .external_lex_state = 4},
  [2975] = {.lex_state = 20, .external_lex_state = 4},
  [2976] = {.lex_state = 12, .external_lex_state = 4},
  [2977] = {.lex_state = 93},
  [2978] = {.lex_state = 20, .external_lex_state = 4},
  [2979] = {.lex_state = 15, .external_lex_state = 5},
  [2980] = {.lex_state = 20, .external_lex_state = 5},
  [2981] = {.lex_state = 12, .external_lex_state = 4},
  [2982] = {.lex_state = 12, .external_lex_state = 4},
  [2983] = {.lex_state = 12, .external_lex_state = 4},
  [2984] = {.lex_state = 12, .external_lex_state = 4},
  [2985] = {.lex_state = 12, .external_lex_state = 4},
  [2986] = {.lex_state = 12, .external_lex_state = 4},
  [2987] = {.lex_state = 12, .external_lex_state = 4},
  [2988] = {.lex_state = 12, .external_lex_state = 4},
  [2989] = {.lex_state = 12, .external_lex_state = 4},
  [2990] = {.lex_state = 12, .external_lex_state = 4},
  [2991] = {.lex_state = 12, .external_lex_state = 4},
  [2992] = {.lex_state = 12, .external_lex_state = 4},
  [2993] = {.lex_state = 12, .external_lex_state = 4},
  [2994] = {.lex_state = 20, .external_lex_state = 5},
  [2995] = {.lex_state = 20, .external_lex_state = 5},
  [2996] = {.lex_state = 20, .external_lex_state = 5},
  [2997] = {.lex_state = 11, .external_lex_state = 4},
  [2998] = {.lex_state = 20, .external_lex_state = 5},
  [2999] = {.lex_state = 20, .external_lex_state = 5},
  [3000] = {.lex_state = 20, .external_lex_state = 5},
  [3001] = {.lex_state = 20, .external_lex_state = 5},
  [3002] = {.lex_state = 12, .external_lex_state = 4},
  [3003] = {.lex_state = 11, .external_lex_state = 4},
  [3004] = {.lex_state = 20, .external_lex_state = 5},
  [3005] = {.lex_state = 20, .external_lex_state = 5},
  [3006] = {.lex_state = 20, .external_lex_state = 5},
  [3007] = {.lex_state = 20, .external_lex_state = 5},
  [3008] = {.lex_state = 20, .external_lex_state = 5},
  [3009] = {.lex_state = 15},
  [3010] = {.lex_state = 12, .external_lex_state = 4},
  [3011] = {.lex_state = 11, .external_lex_state = 4},
  [3012] = {.lex_state = 12, .external_lex_state = 4},
  [3013] = {.lex_state = 20, .external_lex_state = 5},
  [3014] = {.lex_state = 20, .external_lex_state = 5},
  [3015] = {.lex_state = 20, .external_lex_state = 5},
  [3016] = {.lex_state = 12, .external_lex_state = 4},
  [3017] = {.lex_state = 20, .external_lex_state = 5},
  [3018] = {.lex_state = 20, .external_lex_state = 5},
  [3019] = {.lex_state = 12, .external_lex_state = 4},
  [3020] = {.lex_state = 20, .external_lex_state = 5},
  [3021] = {.lex_state = 20, .external_lex_state = 5},
  [3022] = {.lex_state = 20, .external_lex_state = 5},
  [3023] = {.lex_state = 20, .external_lex_state = 5},
  [3024] = {.lex_state = 20, .external_lex_state = 5},
  [3025] = {.lex_state = 20, .external_lex_state = 5},
  [3026] = {.lex_state = 20, .external_lex_state = 5},
  [3027] = {.lex_state = 20, .external_lex_state = 5},
  [3028] = {.lex_state = 20, .external_lex_state = 5},
  [3029] = {.lex_state = 20, .external_lex_state = 5},
  [3030] = {.lex_state = 12, .external_lex_state = 4},
  [3031] = {.lex_state = 20, .external_lex_state = 5},
  [3032] = {.lex_state = 20, .external_lex_state = 5},
  [3033] = {.lex_state = 20, .external_lex_state = 5},
  [3034] = {.lex_state = 12, .external_lex_state = 4},
  [3035] = {.lex_state = 20, .external_lex_state = 5},
  [3036] = {.lex_state = 20, .external_lex_state = 5},
  [3037] = {.lex_state = 12, .external_lex_state = 4},
  [3038] = {.lex_state = 12, .external_lex_state = 4},
  [3039] = {.lex_state = 12, .external_lex_state = 4},
  [3040] = {.lex_state = 20, .external_lex_state = 5},
  [3041] = {.lex_state = 11, .external_lex_state = 4},
  [3042] = {.lex_state = 11, .external_lex_state = 4},
  [3043] = {.lex_state = 11, .external_lex_state = 4},
  [3044] = {.lex_state = 12, .external_lex_state = 4},
  [3045] = {.lex_state = 11, .external_lex_state = 4},
  [3046] = {.lex_state = 11, .external_lex_state = 4},
  [3047] = {.lex_state = 11, .external_lex_state = 4},
  [3048] = {.lex_state = 11, .external_lex_state = 4},
  [3049] = {.lex_state = 20, .external_lex_state = 5},
  [3050] = {.lex_state = 11, .external_lex_state = 4},
  [3051] = {.lex_state = 11, .external_lex_state = 4},
  [3052] = {.lex_state = 11, .external_lex_state = 4},
  [3053] = {.lex_state = 11, .external_lex_state = 4},
  [3054] = {.lex_state = 11, .external_lex_state = 4},
  [3055] = {.lex_state = 11, .external_lex_state = 4},
  [3056] = {.lex_state = 16, .external_lex_state = 5},
  [3057] = {.lex_state = 11, .external_lex_state = 4},
  [3058] = {.lex_state = 11, .external_lex_state = 4},
  [3059] = {.lex_state = 11, .external_lex_state = 4},
  [3060] = {.lex_state = 11, .external_lex_state = 4},
  [3061] = {.lex_state = 11, .external_lex_state = 4},
  [3062] = {.lex_state = 15, .external_lex_state = 5},
  [3063] = {.lex_state = 11, .external_lex_state = 4},
  [3064] = {.lex_state = 11, .external_lex_state = 4},
  [3065] = {.lex_state = 11, .external_lex_state = 4},
  [3066] = {.lex_state = 11, .external_lex_state = 4},
  [3067] = {.lex_state = 11, .external_lex_state = 4},
  [3068] = {.lex_state = 11, .external_lex_state = 4},
  [3069] = {.lex_state = 11, .external_lex_state = 4},
  [3070] = {.lex_state = 11, .external_lex_state = 4},
  [3071] = {.lex_state = 11, .external_lex_state = 4},
  [3072] = {.lex_state = 20, .external_lex_state = 5},
  [3073] = {.lex_state = 11, .external_lex_state = 4},
  [3074] = {.lex_state = 11, .external_lex_state = 4},
  [3075] = {.lex_state = 21},
  [3076] = {.lex_state = 11, .external_lex_state = 4},
  [3077] = {.lex_state = 20, .external_lex_state = 5},
  [3078] = {.lex_state = 11, .external_lex_state = 4},
  [3079] = {.lex_state = 11, .external_lex_state = 4},
  [3080] = {.lex_state = 11, .external_lex_state = 4},
  [3081] = {.lex_state = 20, .external_lex_state = 5},
  [3082] = {.lex_state = 20, .external_lex_state = 5},
  [3083] = {.lex_state = 20, .external_lex_state = 5},
  [3084] = {.lex_state = 11, .external_lex_state = 4},
  [3085] = {.lex_state = 11, .external_lex_state = 4},
  [3086] = {.lex_state = 11, .external_lex_state = 4},
  [3087] = {.lex_state = 11, .external_lex_state = 4},
  [3088] = {.lex_state = 11, .external_lex_state = 4},
  [3089] = {.lex_state = 11, .external_lex_state = 4},
  [3090] = {.lex_state = 11, .external_lex_state = 4},
  [3091] = {.lex_state = 20, .external_lex_state = 5},
  [3092] = {.lex_state = 11, .external_lex_state = 4},
  [3093] = {.lex_state = 11, .external_lex_state = 4},
  [3094] = {.lex_state = 11, .external_lex_state = 4},
  [3095] = {.lex_state = 11, .external_lex_state = 4},
  [3096] = {.lex_state = 11, .external_lex_state = 4},
  [3097] = {.lex_state = 12, .external_lex_state = 4},
  [3098] = {.lex_state = 11, .external_lex_state = 4},
  [3099] = {.lex_state = 16},
  [3100] = {.lex_state = 5},
  [3101] = {.lex_state = 11, .external_lex_state = 4},
  [3102] = {.lex_state = 15},
  [3103] = {.lex_state = 11, .external_lex_state = 4},
  [3104] = {.lex_state = 16},
  [3105] = {.lex_state = 16},
  [3106] = {.lex_state = 11, .external_lex_state = 5},
  [3107] = {.lex_state = 11, .external_lex_state = 5},
  [3108] = {.lex_state = 16},
  [3109] = {.lex_state = 11, .external_lex_state = 4},
  [3110] = {.lex_state = 12, .external_lex_state = 4},
  [3111] = {.lex_state = 16},
  [3112] = {.lex_state = 16},
  [3113] = {.lex_state = 16},
  [3114] = {.lex_state = 16},
  [3115] = {.lex_state = 16},
  [3116] = {.lex_state = 11},
  [3117] = {.lex_state = 11},
  [3118] = {.lex_state = 16},
  [3119] = {.lex_state = 16},
  [3120] = {.lex_state = 16},
  [3121] = {.lex_state = 16},
  [3122] = {.lex_state = 11, .external_lex_state = 4},
  [3123] = {.lex_state = 11, .external_lex_state = 5},
  [3124] = {.lex_state = 16},
  [3125] = {.lex_state = 16},
  [3126] = {.lex_state = 16},
  [3127] = {.lex_state = 11, .external_lex_state = 5},
  [3128] = {.lex_state = 16},
  [3129] = {.lex_state = 11, .external_lex_state = 4},
  [3130] = {.lex_state = 11, .external_lex_state = 5},
  [3131] = {.lex_state = 11, .external_lex_state = 5},
  [3132] = {.lex_state = 11, .external_lex_state = 5},
  [3133] = {.lex_state = 11, .external_lex_state = 5},
  [3134] = {.lex_state = 11, .external_lex_state = 5},
  [3135] = {.lex_state = 11, .external_lex_state = 5},
  [3136] = {.lex_state = 11},
  [3137] = {.lex_state = 16},
  [3138] = {.lex_state = 11, .external_lex_state = 5},
  [3139] = {.lex_state = 11, .external_lex_state = 5},
  [3140] = {.lex_state = 11, .external_lex_state = 5},
  [3141] = {.lex_state = 11},
  [3142] = {.lex_state = 11, .external_lex_state = 5},
  [3143] = {.lex_state = 11, .external_lex_state = 5},
  [3144] = {.lex_state = 11, .external_lex_state = 5},
  [3145] = {.lex_state = 11, .external_lex_state = 5},
  [3146] = {.lex_state = 14},
  [3147] = {.lex_state = 11, .external_lex_state = 5},
  [3148] = {.lex_state = 11, .external_lex_state = 5},
  [3149] = {.lex_state = 11, .external_lex_state = 5},
  [3150] = {.lex_state = 11, .external_lex_state = 5},
  [3151] = {.lex_state = 11, .external_lex_state = 5},
  [3152] = {.lex_state = 11, .external_lex_state = 5},
  [3153] = {.lex_state = 16},
  [3154] = {.lex_state = 11, .external_lex_state = 5},
  [3155] = {.lex_state = 16},
  [3156] = {.lex_state = 16},
  [3157] = {.lex_state = 16},
  [3158] = {.lex_state = 16},
  [3159] = {.lex_state = 16},
  [3160] = {.lex_state = 16},
  [3161] = {.lex_state = 11, .external_lex_state = 5},
  [3162] = {.lex_state = 11, .external_lex_state = 5},
  [3163] = {.lex_state = 11, .external_lex_state = 5},
  [3164] = {.lex_state = 12},
  [3165] = {.lex_state = 11, .external_lex_state = 5},
  [3166] = {.lex_state = 11, .external_lex_state = 4},
  [3167] = {.lex_state = 16},
  [3168] = {.lex_state = 11, .external_lex_state = 5},
  [3169] = {.lex_state = 16},
  [3170] = {.lex_state = 11, .external_lex_state = 5},
  [3171] = {.lex_state = 16},
  [3172] = {.lex_state = 11, .external_lex_state = 5},
  [3173] = {.lex_state = 16},
  [3174] = {.lex_state = 16},
  [3175] = {.lex_state = 5},
  [3176] = {.lex_state = 11, .external_lex_state = 5},
  [3177] = {.lex_state = 16},
  [3178] = {.lex_state = 11, .external_lex_state = 5},
  [3179] = {.lex_state = 16},
  [3180] = {.lex_state = 16},
  [3181] = {.lex_state = 11, .external_lex_state = 5},
  [3182] = {.lex_state = 11, .external_lex_state = 5},
  [3183] = {.lex_state = 11, .external_lex_state = 5},
  [3184] = {.lex_state = 12},
  [3185] = {.lex_state = 11, .external_lex_state = 5},
  [3186] = {.lex_state = 11},
  [3187] = {.lex_state = 16},
  [3188] = {.lex_state = 12},
  [3189] = {.lex_state = 16},
  [3190] = {.lex_state = 14},
  [3191] = {.lex_state = 12},
  [3192] = {.lex_state = 11, .external_lex_state = 5},
  [3193] = {.lex_state = 11, .external_lex_state = 4},
  [3194] = {.lex_state = 11, .external_lex_state = 4},
  [3195] = {.lex_state = 11, .external_lex_state = 5},
  [3196] = {.lex_state = 12},
  [3197] = {.lex_state = 11, .external_lex_state = 5},
  [3198] = {.lex_state = 12},
  [3199] = {.lex_state = 16},
  [3200] = {.lex_state = 16},
  [3201] = {.lex_state = 11},
  [3202] = {.lex_state = 11},
  [3203] = {.lex_state = 11, .external_lex_state = 5},
  [3204] = {.lex_state = 11, .external_lex_state = 5},
  [3205] = {.lex_state = 11},
  [3206] = {.lex_state = 12},
  [3207] = {.lex_state = 11, .external_lex_state = 5},
  [3208] = {.lex_state = 11, .external_lex_state = 5},
  [3209] = {.lex_state = 11, .external_lex_state = 5},
  [3210] = {.lex_state = 11, .external_lex_state = 4},
  [3211] = {.lex_state = 5, .external_lex_state = 4},
  [3212] = {.lex_state = 11, .external_lex_state = 5},
  [3213] = {.lex_state = 11, .external_lex_state = 5},
  [3214] = {.lex_state = 16},
  [3215] = {.lex_state = 15},
  [3216] = {.lex_state = 93, .external_lex_state = 4},
  [3217] = {.lex_state = 11, .external_lex_state = 5},
  [3218] = {.lex_state = 11, .external_lex_state = 5},
  [3219] = {.lex_state = 11, .external_lex_state = 5},
  [3220] = {.lex_state = 93, .external_lex_state = 4},
  [3221] = {.lex_state = 11, .external_lex_state = 5},
  [3222] = {.lex_state = 11, .external_lex_state = 5},
  [3223] = {.lex_state = 14},
  [3224] = {.lex_state = 5, .external_lex_state = 4},
  [3225] = {.lex_state = 18, .external_lex_state = 6},
  [3226] = {.lex_state = 18, .external_lex_state = 6},
  [3227] = {.lex_state = 18, .external_lex_state = 6},
  [3228] = {.lex_state = 11, .external_lex_state = 4},
  [3229] = {.lex_state = 11},
  [3230] = {.lex_state = 18, .external_lex_state = 6},
  [3231] = {.lex_state = 11},
  [3232] = {.lex_state = 18, .external_lex_state = 6},
  [3233] = {.lex_state = 11, .external_lex_state = 4},
  [3234] = {.lex_state = 18, .external_lex_state = 6},
  [3235] = {.lex_state = 11, .external_lex_state = 5},
  [3236] = {.lex_state = 12},
  [3237] = {.lex_state = 11, .external_lex_state = 4},
  [3238] = {.lex_state = 11},
  [3239] = {.lex_state = 11},
  [3240] = {.lex_state = 18, .external_lex_state = 6},
  [3241] = {.lex_state = 18, .external_lex_state = 6},
  [3242] = {.lex_state = 11},
  [3243] = {.lex_state = 11},
  [3244] = {.lex_state = 0, .external_lex_state = 4},
  [3245] = {.lex_state = 12},
  [3246] = {.lex_state = 12},
  [3247] = {.lex_state = 11},
  [3248] = {.lex_state = 11, .external_lex_state = 4},
  [3249] = {.lex_state = 93, .external_lex_state = 4},
  [3250] = {.lex_state = 11},
  [3251] = {.lex_state = 11},
  [3252] = {.lex_state = 12},
  [3253] = {.lex_state = 11, .external_lex_state = 4},
  [3254] = {.lex_state = 11, .external_lex_state = 4},
  [3255] = {.lex_state = 11, .external_lex_state = 4},
  [3256] = {.lex_state = 12},
  [3257] = {.lex_state = 11, .external_lex_state = 4},
  [3258] = {.lex_state = 11},
  [3259] = {.lex_state = 11},
  [3260] = {.lex_state = 11},
  [3261] = {.lex_state = 11},
  [3262] = {.lex_state = 11},
  [3263] = {.lex_state = 11},
  [3264] = {.lex_state = 11},
  [3265] = {.lex_state = 11},
  [3266] = {.lex_state = 11},
  [3267] = {.lex_state = 11},
  [3268] = {.lex_state = 11},
  [3269] = {.lex_state = 0, .external_lex_state = 4},
  [3270] = {.lex_state = 0, .external_lex_state = 4},
  [3271] = {.lex_state = 11},
  [3272] = {.lex_state = 11, .external_lex_state = 4},
  [3273] = {.lex_state = 11, .external_lex_state = 4},
  [3274] = {.lex_state = 11, .external_lex_state = 4},
  [3275] = {.lex_state = 12},
  [3276] = {.lex_state = 12},
  [3277] = {.lex_state = 0, .external_lex_state = 4},
  [3278] = {.lex_state = 12},
  [3279] = {.lex_state = 93, .external_lex_state = 4},
  [3280] = {.lex_state = 11},
  [3281] = {.lex_state = 11, .external_lex_state = 4},
  [3282] = {.lex_state = 93, .external_lex_state = 4},
  [3283] = {.lex_state = 11},
  [3284] = {.lex_state = 93, .external_lex_state = 4},
  [3285] = {.lex_state = 11},
  [3286] = {.lex_state = 11, .external_lex_state = 4},
  [3287] = {.lex_state = 11},
  [3288] = {.lex_state = 11, .external_lex_state = 4},
  [3289] = {.lex_state = 11, .external_lex_state = 4},
  [3290] = {.lex_state = 11},
  [3291] = {.lex_state = 11, .external_lex_state = 4},
  [3292] = {.lex_state = 11, .external_lex_state = 4},
  [3293] = {.lex_state = 93, .external_lex_state = 4},
  [3294] = {.lex_state = 11, .external_lex_state = 4},
  [3295] = {.lex_state = 21},
  [3296] = {.lex_state = 11},
  [3297] = {.lex_state = 0, .external_lex_state = 4},
  [3298] = {.lex_state = 11},
  [3299] = {.lex_state = 11},
  [3300] = {.lex_state = 12},
  [3301] = {.lex_state = 11},
  [3302] = {.lex_state = 0, .external_lex_state = 4},
  [3303] = {.lex_state = 12},
  [3304] = {.lex_state = 11, .external_lex_state = 4},
  [3305] = {.lex_state = 93, .external_lex_state = 4},
  [3306] = {.lex_state = 93, .external_lex_state = 4},
  [3307] = {.lex_state = 11, .external_lex_state = 4},
  [3308] = {.lex_state = 11},
  [3309] = {.lex_state = 11},
  [3310] = {.lex_state = 11},
  [3311] = {.lex_state = 93, .external_lex_state = 4},
  [3312] = {.lex_state = 11, .external_lex_state = 4},
  [3313] = {.lex_state = 11},
  [3314] = {.lex_state = 11, .external_lex_state = 4},
  [3315] = {.lex_state = 5},
  [3316] = {.lex_state = 11},
  [3317] = {.lex_state = 11},
  [3318] = {.lex_state = 11},
  [3319] = {.lex_state = 0, .external_lex_state = 4},
  [3320] = {.lex_state = 11},
  [3321] = {.lex_state = 12},
  [3322] = {.lex_state = 12},
  [3323] = {.lex_state = 5},
  [3324] = {.lex_state = 12},
  [3325] = {.lex_state = 11},
  [3326] = {.lex_state = 11},
  [3327] = {.lex_state = 12},
  [3328] = {.lex_state = 11},
  [3329] = {.lex_state = 11, .external_lex_state = 4},
  [3330] = {.lex_state = 11, .external_lex_state = 4},
  [3331] = {.lex_state = 5},
  [3332] = {.lex_state = 11},
  [3333] = {.lex_state = 11, .external_lex_state = 4},
  [3334] = {.lex_state = 5},
  [3335] = {.lex_state = 12},
  [3336] = {.lex_state = 11, .external_lex_state = 4},
  [3337] = {.lex_state = 11, .external_lex_state = 4},
  [3338] = {.lex_state = 12},
  [3339] = {.lex_state = 0, .external_lex_state = 4},
  [3340] = {.lex_state = 11, .external_lex_state = 4},
  [3341] = {.lex_state = 11, .external_lex_state = 4},
  [3342] = {.lex_state = 11, .external_lex_state = 4},
  [3343] = {.lex_state = 11, .external_lex_state = 4},
  [3344] = {.lex_state = 0, .external_lex_state = 4},
  [3345] = {.lex_state = 0, .external_lex_state = 4},
  [3346] = {.lex_state = 12},
  [3347] = {.lex_state = 11},
  [3348] = {.lex_state = 11},
  [3349] = {.lex_state = 0, .external_lex_state = 4},
  [3350] = {.lex_state = 12},
  [3351] = {.lex_state = 12},
  [3352] = {.lex_state = 12},
  [3353] = {.lex_state = 11},
  [3354] = {.lex_state = 5},
  [3355] = {.lex_state = 12},
  [3356] = {.lex_state = 11},
  [3357] = {.lex_state = 11},
  [3358] = {.lex_state = 11},
  [3359] = {.lex_state = 11},
  [3360] = {.lex_state = 12},
  [3361] = {.lex_state = 11},
  [3362] = {.lex_state = 11},
  [3363] = {.lex_state = 11},
  [3364] = {.lex_state = 21},
  [3365] = {.lex_state = 93},
  [3366] = {.lex_state = 11, .external_lex_state = 5},
  [3367] = {.lex_state = 11, .external_lex_state = 5},
  [3368] = {.lex_state = 12},
  [3369] = {.lex_state = 11},
  [3370] = {.lex_state = 0, .external_lex_state = 4},
  [3371] = {.lex_state = 11},
  [3372] = {.lex_state = 93},
  [3373] = {.lex_state = 21},
  [3374] = {.lex_state = 93},
  [3375] = {.lex_state = 93},
  [3376] = {.lex_state = 93},
  [3377] = {.lex_state = 0, .external_lex_state = 4},
  [3378] = {.lex_state = 0, .external_lex_state = 4},
  [3379] = {.lex_state = 11, .external_lex_state = 5},
  [3380] = {.lex_state = 18, .external_lex_state = 6},
  [3381] = {.lex_state = 18, .external_lex_state = 6},
  [3382] = {.lex_state = 0, .external_lex_state = 4},
  [3383] = {.lex_state = 11, .external_lex_state = 5},
  [3384] = {.lex_state = 11, .external_lex_state = 5},
  [3385] = {.lex_state = 0, .external_lex_state = 4},
  [3386] = {.lex_state = 12},
  [3387] = {.lex_state = 0, .external_lex_state = 4},
  [3388] = {.lex_state = 12},
  [3389] = {.lex_state = 11},
  [3390] = {.lex_state = 0, .external_lex_state = 4},
  [3391] = {.lex_state = 12},
  [3392] = {.lex_state = 11, .external_lex_state = 5},
  [3393] = {.lex_state = 12},
  [3394] = {.lex_state = 11, .external_lex_state = 5},
  [3395] = {.lex_state = 11},
  [3396] = {.lex_state = 11},
  [3397] = {.lex_state = 11, .external_lex_state = 5},
  [3398] = {.lex_state = 0, .external_lex_state = 4},
  [3399] = {.lex_state = 21},
  [3400] = {.lex_state = 11, .external_lex_state = 4},
  [3401] = {.lex_state = 0, .external_lex_state = 4},
  [3402] = {.lex_state = 5},
  [3403] = {.lex_state = 11},
  [3404] = {.lex_state = 11, .external_lex_state = 5},
  [3405] = {.lex_state = 12},
  [3406] = {.lex_state = 12},
  [3407] = {.lex_state = 93},
  [3408] = {.lex_state = 21},
  [3409] = {.lex_state = 93},
  [3410] = {.lex_state = 93},
  [3411] = {.lex_state = 93},
  [3412] = {.lex_state = 11},
  [3413] = {.lex_state = 12},
  [3414] = {.lex_state = 21},
  [3415] = {.lex_state = 12},
  [3416] = {.lex_state = 0, .external_lex_state = 4},
  [3417] = {.lex_state = 12},
  [3418] = {.lex_state = 11},
  [3419] = {.lex_state = 11},
  [3420] = {.lex_state = 21},
  [3421] = {.lex_state = 12},
  [3422] = {.lex_state = 11},
  [3423] = {.lex_state = 93},
  [3424] = {.lex_state = 11, .external_lex_state = 5},
  [3425] = {.lex_state = 12},
  [3426] = {.lex_state = 21},
  [3427] = {.lex_state = 93},
  [3428] = {.lex_state = 12},
  [3429] = {.lex_state = 93},
  [3430] = {.lex_state = 93},
  [3431] = {.lex_state = 0, .external_lex_state = 4},
  [3432] = {.lex_state = 11},
  [3433] = {.lex_state = 11, .external_lex_state = 5},
  [3434] = {.lex_state = 93},
  [3435] = {.lex_state = 11, .external_lex_state = 5},
  [3436] = {.lex_state = 93},
  [3437] = {.lex_state = 11, .external_lex_state = 5},
  [3438] = {.lex_state = 93},
  [3439] = {.lex_state = 11, .external_lex_state = 5},
  [3440] = {.lex_state = 11, .external_lex_state = 5},
  [3441] = {.lex_state = 93},
  [3442] = {.lex_state = 93},
  [3443] = {.lex_state = 11, .external_lex_state = 4},
  [3444] = {.lex_state = 12},
  [3445] = {.lex_state = 11, .external_lex_state = 5},
  [3446] = {.lex_state = 0, .external_lex_state = 4},
  [3447] = {.lex_state = 0, .external_lex_state = 4},
  [3448] = {.lex_state = 11, .external_lex_state = 5},
  [3449] = {.lex_state = 11, .external_lex_state = 5},
  [3450] = {.lex_state = 0, .external_lex_state = 4},
  [3451] = {.lex_state = 93},
  [3452] = {.lex_state = 12},
  [3453] = {.lex_state = 0},
  [3454] = {.lex_state = 12},
  [3455] = {.lex_state = 0, .external_lex_state = 4},
  [3456] = {.lex_state = 0, .external_lex_state = 4},
  [3457] = {.lex_state = 11, .external_lex_state = 5},
  [3458] = {.lex_state = 12},
  [3459] = {.lex_state = 0, .external_lex_state = 4},
  [3460] = {.lex_state = 12},
  [3461] = {.lex_state = 11, .external_lex_state = 5},
  [3462] = {.lex_state = 12},
  [3463] = {.lex_state = 12},
  [3464] = {.lex_state = 11, .external_lex_state = 5},
  [3465] = {.lex_state = 12},
  [3466] = {.lex_state = 11, .external_lex_state = 5},
  [3467] = {.lex_state = 12},
  [3468] = {.lex_state = 18, .external_lex_state = 6},
  [3469] = {.lex_state = 11},
  [3470] = {.lex_state = 11, .external_lex_state = 5},
  [3471] = {.lex_state = 11, .external_lex_state = 5},
  [3472] = {.lex_state = 0, .external_lex_state = 4},
  [3473] = {.lex_state = 21},
  [3474] = {.lex_state = 12},
  [3475] = {.lex_state = 11},
  [3476] = {.lex_state = 21},
  [3477] = {.lex_state = 11},
  [3478] = {.lex_state = 12},
  [3479] = {.lex_state = 11},
  [3480] = {.lex_state = 11},
  [3481] = {.lex_state = 18, .external_lex_state = 6},
  [3482] = {.lex_state = 18, .external_lex_state = 6},
  [3483] = {.lex_state = 93},
  [3484] = {.lex_state = 11, .external_lex_state = 5},
  [3485] = {.lex_state = 93},
  [3486] = {.lex_state = 21},
  [3487] = {.lex_state = 93},
  [3488] = {.lex_state = 12},
  [3489] = {.lex_state = 12},
  [3490] = {.lex_state = 12},
  [3491] = {.lex_state = 12},
  [3492] = {.lex_state = 93},
  [3493] = {.lex_state = 11},
  [3494] = {.lex_state = 12},
  [3495] = {.lex_state = 93},
  [3496] = {.lex_state = 11},
  [3497] = {.lex_state = 0, .external_lex_state = 4},
  [3498] = {.lex_state = 12},
  [3499] = {.lex_state = 12},
  [3500] = {.lex_state = 12},
  [3501] = {.lex_state = 0, .external_lex_state = 4},
  [3502] = {.lex_state = 11},
  [3503] = {.lex_state = 0, .external_lex_state = 4},
  [3504] = {.lex_state = 11, .external_lex_state = 5},
  [3505] = {.lex_state = 0, .external_lex_state = 4},
  [3506] = {.lex_state = 11},
  [3507] = {.lex_state = 0, .external_lex_state = 4},
  [3508] = {.lex_state = 93},
  [3509] = {.lex_state = 5},
  [3510] = {.lex_state = 11},
  [3511] = {.lex_state = 0, .external_lex_state = 4},
  [3512] = {.lex_state = 5},
  [3513] = {.lex_state = 12},
  [3514] = {.lex_state = 11},
  [3515] = {.lex_state = 12},
  [3516] = {.lex_state = 12},
  [3517] = {.lex_state = 0, .external_lex_state = 4},
  [3518] = {.lex_state = 5},
  [3519] = {.lex_state = 11},
  [3520] = {.lex_state = 11},
  [3521] = {.lex_state = 11},
  [3522] = {.lex_state = 0, .external_lex_state = 4},
  [3523] = {.lex_state = 11},
  [3524] = {.lex_state = 11},
  [3525] = {.lex_state = 11, .external_lex_state = 4},
  [3526] = {.lex_state = 11},
  [3527] = {.lex_state = 11, .external_lex_state = 4},
  [3528] = {.lex_state = 11},
  [3529] = {.lex_state = 11},
  [3530] = {.lex_state = 0, .external_lex_state = 4},
  [3531] = {.lex_state = 12},
  [3532] = {.lex_state = 12},
  [3533] = {.lex_state = 5, .external_lex_state = 4},
  [3534] = {.lex_state = 11},
  [3535] = {.lex_state = 12},
  [3536] = {.lex_state = 11, .external_lex_state = 5},
  [3537] = {.lex_state = 12},
  [3538] = {.lex_state = 93},
  [3539] = {.lex_state = 12},
  [3540] = {.lex_state = 0, .external_lex_state = 4},
  [3541] = {.lex_state = 12},
  [3542] = {.lex_state = 0, .external_lex_state = 4},
  [3543] = {.lex_state = 0, .external_lex_state = 4},
  [3544] = {.lex_state = 0},
  [3545] = {.lex_state = 12},
  [3546] = {.lex_state = 12},
  [3547] = {.lex_state = 93},
  [3548] = {.lex_state = 93},
  [3549] = {.lex_state = 11, .external_lex_state = 5},
  [3550] = {.lex_state = 0, .external_lex_state = 4},
  [3551] = {.lex_state = 93},
  [3552] = {.lex_state = 18, .external_lex_state = 6},
  [3553] = {.lex_state = 18, .external_lex_state = 6},
  [3554] = {.lex_state = 12},
  [3555] = {.lex_state = 93},
  [3556] = {.lex_state = 12},
  [3557] = {.lex_state = 12},
  [3558] = {.lex_state = 12},
  [3559] = {.lex_state = 0, .external_lex_state = 4},
  [3560] = {.lex_state = 0, .external_lex_state = 4},
  [3561] = {.lex_state = 0, .external_lex_state = 4},
  [3562] = {.lex_state = 12},
  [3563] = {.lex_state = 11, .external_lex_state = 5},
  [3564] = {.lex_state = 0},
  [3565] = {.lex_state = 0},
  [3566] = {.lex_state = 11},
  [3567] = {.lex_state = 12},
  [3568] = {.lex_state = 11, .external_lex_state = 5},
  [3569] = {.lex_state = 11, .external_lex_state = 5},
  [3570] = {.lex_state = 12},
  [3571] = {.lex_state = 0, .external_lex_state = 4},
  [3572] = {.lex_state = 11, .external_lex_state = 5},
  [3573] = {.lex_state = 18, .external_lex_state = 6},
  [3574] = {.lex_state = 12},
  [3575] = {.lex_state = 0, .external_lex_state = 4},
  [3576] = {.lex_state = 0, .external_lex_state = 4},
  [3577] = {.lex_state = 12},
  [3578] = {.lex_state = 11},
  [3579] = {.lex_state = 12},
  [3580] = {.lex_state = 11, .external_lex_state = 4},
  [3581] = {.lex_state = 11},
  [3582] = {.lex_state = 0, .external_lex_state = 4},
  [3583] = {.lex_state = 11, .external_lex_state = 4},
  [3584] = {.lex_state = 0, .external_lex_state = 4},
  [3585] = {.lex_state = 5, .external_lex_state = 4},
  [3586] = {.lex_state = 0, .external_lex_state = 4},
  [3587] = {.lex_state = 0, .external_lex_state = 4},
  [3588] = {.lex_state = 0, .external_lex_state = 4},
  [3589] = {.lex_state = 0, .external_lex_state = 4},
  [3590] = {.lex_state = 93},
  [3591] = {.lex_state = 0, .external_lex_state = 4},
  [3592] = {.lex_state = 0, .external_lex_state = 4},
  [3593] = {.lex_state = 11, .external_lex_state = 4},
  [3594] = {.lex_state = 11, .external_lex_state = 5},
  [3595] = {.lex_state = 93},
  [3596] = {.lex_state = 11, .external_lex_state = 4},
  [3597] = {.lex_state = 0, .external_lex_state = 4},
  [3598] = {.lex_state = 12},
  [3599] = {.lex_state = 12},
  [3600] = {.lex_state = 0, .external_lex_state = 4},
  [3601] = {.lex_state = 93},
  [3602] = {.lex_state = 11, .external_lex_state = 5},
  [3603] = {.lex_state = 5},
  [3604] = {.lex_state = 12},
  [3605] = {.lex_state = 93, .external_lex_state = 4},
  [3606] = {.lex_state = 0, .external_lex_state = 4},
  [3607] = {.lex_state = 0},
  [3608] = {.lex_state = 0, .external_lex_state = 4},
  [3609] = {.lex_state = 93, .external_lex_state = 4},
  [3610] = {.lex_state = 0, .external_lex_state = 4},
  [3611] = {.lex_state = 5},
  [3612] = {.lex_state = 12},
  [3613] = {.lex_state = 0, .external_lex_state = 4},
  [3614] = {.lex_state = 0, .external_lex_state = 4},
  [3615] = {.lex_state = 12},
  [3616] = {.lex_state = 0, .external_lex_state = 4},
  [3617] = {.lex_state = 0, .external_lex_state = 4},
  [3618] = {.lex_state = 12},
  [3619] = {.lex_state = 0, .external_lex_state = 4},
  [3620] = {.lex_state = 0, .external_lex_state = 4},
  [3621] = {.lex_state = 0, .external_lex_state = 4},
  [3622] = {.lex_state = 11, .external_lex_state = 4},
  [3623] = {.lex_state = 0, .external_lex_state = 4},
  [3624] = {.lex_state = 0, .external_lex_state = 4},
  [3625] = {.lex_state = 0},
  [3626] = {.lex_state = 0, .external_lex_state = 4},
  [3627] = {.lex_state = 93},
  [3628] = {.lex_state = 0, .external_lex_state = 4},
  [3629] = {.lex_state = 0, .external_lex_state = 4},
  [3630] = {.lex_state = 12},
  [3631] = {.lex_state = 12},
  [3632] = {.lex_state = 0, .external_lex_state = 4},
  [3633] = {.lex_state = 11, .external_lex_state = 4},
  [3634] = {.lex_state = 0, .external_lex_state = 4},
  [3635] = {.lex_state = 12},
  [3636] = {.lex_state = 18, .external_lex_state = 6},
  [3637] = {.lex_state = 11, .external_lex_state = 5},
  [3638] = {.lex_state = 11},
  [3639] = {.lex_state = 11, .external_lex_state = 5},
  [3640] = {.lex_state = 11},
  [3641] = {.lex_state = 0, .external_lex_state = 4},
  [3642] = {.lex_state = 11, .external_lex_state = 4},
  [3643] = {.lex_state = 0, .external_lex_state = 4},
  [3644] = {.lex_state = 11},
  [3645] = {.lex_state = 0, .external_lex_state = 4},
  [3646] = {.lex_state = 0, .external_lex_state = 4},
  [3647] = {.lex_state = 0, .external_lex_state = 4},
  [3648] = {.lex_state = 0, .external_lex_state = 4},
  [3649] = {.lex_state = 12},
  [3650] = {.lex_state = 0, .external_lex_state = 4},
  [3651] = {.lex_state = 0, .external_lex_state = 4},
  [3652] = {.lex_state = 0, .external_lex_state = 4},
  [3653] = {.lex_state = 12},
  [3654] = {.lex_state = 0, .external_lex_state = 4},
  [3655] = {.lex_state = 11},
  [3656] = {.lex_state = 0, .external_lex_state = 4},
  [3657] = {.lex_state = 0, .external_lex_state = 4},
  [3658] = {.lex_state = 11},
  [3659] = {.lex_state = 11, .external_lex_state = 5},
  [3660] = {.lex_state = 0, .external_lex_state = 4},
  [3661] = {.lex_state = 0, .external_lex_state = 4},
  [3662] = {.lex_state = 0, .external_lex_state = 4},
  [3663] = {.lex_state = 93},
  [3664] = {.lex_state = 12},
  [3665] = {.lex_state = 93},
  [3666] = {.lex_state = 93},
  [3667] = {.lex_state = 0},
  [3668] = {.lex_state = 12},
  [3669] = {.lex_state = 12},
  [3670] = {.lex_state = 12},
  [3671] = {.lex_state = 11, .external_lex_state = 4},
  [3672] = {.lex_state = 0, .external_lex_state = 4},
  [3673] = {.lex_state = 12},
  [3674] = {.lex_state = 0, .external_lex_state = 4},
  [3675] = {.lex_state = 0, .external_lex_state = 4},
  [3676] = {.lex_state = 0, .external_lex_state = 4},
  [3677] = {.lex_state = 12},
  [3678] = {.lex_state = 0, .external_lex_state = 4},
  [3679] = {.lex_state = 0, .external_lex_state = 4},
  [3680] = {.lex_state = 12},
  [3681] = {.lex_state = 0, .external_lex_state = 4},
  [3682] = {.lex_state = 12},
  [3683] = {.lex_state = 0, .external_lex_state = 4},
  [3684] = {.lex_state = 12},
  [3685] = {.lex_state = 0, .external_lex_state = 4},
  [3686] = {.lex_state = 0, .external_lex_state = 4},
  [3687] = {.lex_state = 0, .external_lex_state = 4},
  [3688] = {.lex_state = 0, .external_lex_state = 4},
  [3689] = {.lex_state = 0, .external_lex_state = 4},
  [3690] = {.lex_state = 12},
  [3691] = {.lex_state = 12},
  [3692] = {.lex_state = 93},
  [3693] = {.lex_state = 0, .external_lex_state = 4},
  [3694] = {.lex_state = 0, .external_lex_state = 4},
  [3695] = {.lex_state = 93},
  [3696] = {.lex_state = 0, .external_lex_state = 4},
  [3697] = {.lex_state = 0, .external_lex_state = 4},
  [3698] = {.lex_state = 12},
  [3699] = {.lex_state = 0, .external_lex_state = 4},
  [3700] = {.lex_state = 0, .external_lex_state = 4},
  [3701] = {.lex_state = 11, .external_lex_state = 5},
  [3702] = {.lex_state = 0, .external_lex_state = 4},
  [3703] = {.lex_state = 12},
  [3704] = {.lex_state = 0, .external_lex_state = 4},
  [3705] = {.lex_state = 0, .external_lex_state = 4},
  [3706] = {.lex_state = 0, .external_lex_state = 4},
  [3707] = {.lex_state = 12},
  [3708] = {.lex_state = 12},
  [3709] = {.lex_state = 0, .external_lex_state = 4},
  [3710] = {.lex_state = 12},
  [3711] = {.lex_state = 11, .external_lex_state = 4},
  [3712] = {.lex_state = 0, .external_lex_state = 4},
  [3713] = {.lex_state = 0, .external_lex_state = 4},
  [3714] = {.lex_state = 11, .external_lex_state = 5},
  [3715] = {.lex_state = 0, .external_lex_state = 4},
  [3716] = {.lex_state = 0, .external_lex_state = 4},
  [3717] = {.lex_state = 11, .external_lex_state = 5},
  [3718] = {.lex_state = 0, .external_lex_state = 4},
  [3719] = {.lex_state = 12},
  [3720] = {.lex_state = 0},
  [3721] = {.lex_state = 0},
  [3722] = {.lex_state = 12},
  [3723] = {.lex_state = 11, .external_lex_state = 5},
  [3724] = {.lex_state = 93},
  [3725] = {.lex_state = 0, .external_lex_state = 4},
  [3726] = {.lex_state = 12},
  [3727] = {.lex_state = 12},
  [3728] = {.lex_state = 11},
  [3729] = {.lex_state = 12},
  [3730] = {.lex_state = 12},
  [3731] = {.lex_state = 18, .external_lex_state = 6},
  [3732] = {.lex_state = 18, .external_lex_state = 6},
  [3733] = {.lex_state = 12},
  [3734] = {.lex_state = 12},
  [3735] = {.lex_state = 93},
  [3736] = {.lex_state = 12},
  [3737] = {.lex_state = 12},
  [3738] = {.lex_state = 11, .external_lex_state = 5},
  [3739] = {.lex_state = 0},
  [3740] = {.lex_state = 0},
  [3741] = {.lex_state = 0, .external_lex_state = 4},
  [3742] = {.lex_state = 0, .external_lex_state = 4},
  [3743] = {.lex_state = 12},
  [3744] = {.lex_state = 0, .external_lex_state = 4},
  [3745] = {.lex_state = 0, .external_lex_state = 4},
  [3746] = {.lex_state = 0, .external_lex_state = 4},
  [3747] = {.lex_state = 0, .external_lex_state = 4},
  [3748] = {.lex_state = 12},
  [3749] = {.lex_state = 93},
  [3750] = {.lex_state = 93},
  [3751] = {.lex_state = 93},
  [3752] = {.lex_state = 11, .external_lex_state = 5},
  [3753] = {.lex_state = 0},
  [3754] = {.lex_state = 0, .external_lex_state = 4},
  [3755] = {.lex_state = 0, .external_lex_state = 4},
  [3756] = {.lex_state = 0, .external_lex_state = 4},
  [3757] = {.lex_state = 11, .external_lex_state = 5},
  [3758] = {.lex_state = 0},
  [3759] = {.lex_state = 11},
  [3760] = {.lex_state = 11},
  [3761] = {.lex_state = 11, .external_lex_state = 5},
  [3762] = {.lex_state = 0, .external_lex_state = 4},
  [3763] = {.lex_state = 0, .external_lex_state = 4},
  [3764] = {.lex_state = 0, .external_lex_state = 4},
  [3765] = {.lex_state = 0, .external_lex_state = 4},
  [3766] = {.lex_state = 11},
  [3767] = {.lex_state = 0, .external_lex_state = 4},
  [3768] = {.lex_state = 0, .external_lex_state = 4},
  [3769] = {.lex_state = 0, .external_lex_state = 4},
  [3770] = {.lex_state = 12},
  [3771] = {.lex_state = 0, .external_lex_state = 4},
  [3772] = {.lex_state = 0, .external_lex_state = 4},
  [3773] = {.lex_state = 12},
  [3774] = {.lex_state = 11},
  [3775] = {.lex_state = 11},
  [3776] = {.lex_state = 0, .external_lex_state = 4},
  [3777] = {.lex_state = 12},
  [3778] = {.lex_state = 0, .external_lex_state = 4},
  [3779] = {.lex_state = 0, .external_lex_state = 4},
  [3780] = {.lex_state = 0, .external_lex_state = 4},
  [3781] = {.lex_state = 0, .external_lex_state = 4},
  [3782] = {.lex_state = 93},
  [3783] = {.lex_state = 0, .external_lex_state = 4},
  [3784] = {.lex_state = 11, .external_lex_state = 5},
  [3785] = {.lex_state = 0, .external_lex_state = 4},
  [3786] = {.lex_state = 12},
  [3787] = {.lex_state = 0},
  [3788] = {.lex_state = 11, .external_lex_state = 5},
  [3789] = {.lex_state = 0, .external_lex_state = 4},
  [3790] = {.lex_state = 0, .external_lex_state = 4},
  [3791] = {.lex_state = 0, .external_lex_state = 4},
  [3792] = {.lex_state = 0, .external_lex_state = 4},
  [3793] = {.lex_state = 0, .external_lex_state = 4},
  [3794] = {.lex_state = 0, .external_lex_state = 4},
  [3795] = {.lex_state = 18, .external_lex_state = 6},
  [3796] = {.lex_state = 0, .external_lex_state = 4},
  [3797] = {.lex_state = 12},
  [3798] = {.lex_state = 18, .external_lex_state = 6},
  [3799] = {.lex_state = 0, .external_lex_state = 4},
  [3800] = {.lex_state = 0, .external_lex_state = 4},
  [3801] = {.lex_state = 0, .external_lex_state = 4},
  [3802] = {.lex_state = 0, .external_lex_state = 4},
  [3803] = {.lex_state = 11},
  [3804] = {.lex_state = 12},
  [3805] = {.lex_state = 0, .external_lex_state = 4},
  [3806] = {.lex_state = 0, .external_lex_state = 4},
  [3807] = {.lex_state = 0, .external_lex_state = 4},
  [3808] = {.lex_state = 18, .external_lex_state = 6},
  [3809] = {.lex_state = 0, .external_lex_state = 4},
  [3810] = {.lex_state = 0, .external_lex_state = 4},
  [3811] = {.lex_state = 0, .external_lex_state = 4},
  [3812] = {.lex_state = 18, .external_lex_state = 6},
  [3813] = {.lex_state = 0, .external_lex_state = 4},
  [3814] = {.lex_state = 0, .external_lex_state = 4},
  [3815] = {.lex_state = 0, .external_lex_state = 4},
  [3816] = {.lex_state = 0, .external_lex_state = 4},
  [3817] = {.lex_state = 11},
  [3818] = {.lex_state = 12},
  [3819] = {.lex_state = 12},
  [3820] = {.lex_state = 12},
  [3821] = {.lex_state = 12},
  [3822] = {.lex_state = 12},
  [3823] = {.lex_state = 11},
  [3824] = {.lex_state = 0, .external_lex_state = 4},
  [3825] = {.lex_state = 12},
  [3826] = {.lex_state = 0, .external_lex_state = 4},
  [3827] = {.lex_state = 93},
  [3828] = {.lex_state = 0, .external_lex_state = 4},
  [3829] = {.lex_state = 0, .external_lex_state = 4},
  [3830] = {.lex_state = 0, .external_lex_state = 4},
  [3831] = {.lex_state = 12},
  [3832] = {.lex_state = 18, .external_lex_state = 6},
  [3833] = {.lex_state = 12},
  [3834] = {.lex_state = 0, .external_lex_state = 4},
  [3835] = {.lex_state = 0},
  [3836] = {.lex_state = 12},
  [3837] = {.lex_state = 11},
  [3838] = {.lex_state = 0, .external_lex_state = 4},
  [3839] = {.lex_state = 12},
  [3840] = {.lex_state = 0, .external_lex_state = 4},
  [3841] = {.lex_state = 0, .external_lex_state = 4},
  [3842] = {.lex_state = 0, .external_lex_state = 4},
  [3843] = {.lex_state = 0, .external_lex_state = 4},
  [3844] = {.lex_state = 11},
  [3845] = {.lex_state = 5},
  [3846] = {.lex_state = 0},
  [3847] = {.lex_state = 12},
  [3848] = {.lex_state = 0, .external_lex_state = 4},
  [3849] = {.lex_state = 17},
  [3850] = {.lex_state = 17},
  [3851] = {.lex_state = 0},
  [3852] = {.lex_state = 22},
  [3853] = {.lex_state = 11},
  [3854] = {.lex_state = 11},
  [3855] = {.lex_state = 0, .external_lex_state = 4},
  [3856] = {.lex_state = 12},
  [3857] = {.lex_state = 93, .external_lex_state = 4},
  [3858] = {.lex_state = 0, .external_lex_state = 4},
  [3859] = {.lex_state = 0, .external_lex_state = 4},
  [3860] = {.lex_state = 11},
  [3861] = {.lex_state = 11},
  [3862] = {.lex_state = 12},
  [3863] = {.lex_state = 0, .external_lex_state = 4},
  [3864] = {.lex_state = 11},
  [3865] = {.lex_state = 11},
  [3866] = {.lex_state = 93},
  [3867] = {.lex_state = 11},
  [3868] = {.lex_state = 17},
  [3869] = {.lex_state = 22},
  [3870] = {.lex_state = 12},
  [3871] = {.lex_state = 11},
  [3872] = {.lex_state = 93},
  [3873] = {.lex_state = 0},
  [3874] = {.lex_state = 1},
  [3875] = {.lex_state = 93, .external_lex_state = 4},
  [3876] = {.lex_state = 0, .external_lex_state = 4},
  [3877] = {.lex_state = 11},
  [3878] = {.lex_state = 0},
  [3879] = {.lex_state = 0, .external_lex_state = 4},
  [3880] = {.lex_state = 12},
  [3881] = {.lex_state = 0},
  [3882] = {.lex_state = 0},
  [3883] = {.lex_state = 22},
  [3884] = {.lex_state = 11},
  [3885] = {.lex_state = 0, .external_lex_state = 4},
  [3886] = {.lex_state = 17},
  [3887] = {.lex_state = 93},
  [3888] = {.lex_state = 22},
  [3889] = {.lex_state = 1},
  [3890] = {.lex_state = 17},
  [3891] = {.lex_state = 1},
  [3892] = {.lex_state = 18, .external_lex_state = 6},
  [3893] = {.lex_state = 0, .external_lex_state = 4},
  [3894] = {.lex_state = 22},
  [3895] = {.lex_state = 12},
  [3896] = {.lex_state = 22},
  [3897] = {.lex_state = 17},
  [3898] = {.lex_state = 11},
  [3899] = {.lex_state = 11},
  [3900] = {.lex_state = 1},
  [3901] = {.lex_state = 93},
  [3902] = {.lex_state = 12},
  [3903] = {.lex_state = 12},
  [3904] = {.lex_state = 0, .external_lex_state = 5},
  [3905] = {.lex_state = 93, .external_lex_state = 4},
  [3906] = {.lex_state = 12},
  [3907] = {.lex_state = 11},
  [3908] = {.lex_state = 0},
  [3909] = {.lex_state = 11},
  [3910] = {.lex_state = 12},
  [3911] = {.lex_state = 93},
  [3912] = {.lex_state = 22},
  [3913] = {.lex_state = 17},
  [3914] = {.lex_state = 22},
  [3915] = {.lex_state = 17},
  [3916] = {.lex_state = 12},
  [3917] = {.lex_state = 93, .external_lex_state = 4},
  [3918] = {.lex_state = 0},
  [3919] = {.lex_state = 12},
  [3920] = {.lex_state = 22},
  [3921] = {.lex_state = 17},
  [3922] = {.lex_state = 11},
  [3923] = {.lex_state = 93, .external_lex_state = 4},
  [3924] = {.lex_state = 0, .external_lex_state = 4},
  [3925] = {.lex_state = 11},
  [3926] = {.lex_state = 22},
  [3927] = {.lex_state = 11},
  [3928] = {.lex_state = 17},
  [3929] = {.lex_state = 93},
  [3930] = {.lex_state = 93},
  [3931] = {.lex_state = 22},
  [3932] = {.lex_state = 18, .external_lex_state = 6},
  [3933] = {.lex_state = 12},
  [3934] = {.lex_state = 12},
  [3935] = {.lex_state = 17},
  [3936] = {.lex_state = 11},
  [3937] = {.lex_state = 12},
  [3938] = {.lex_state = 11},
  [3939] = {.lex_state = 0, .external_lex_state = 4},
  [3940] = {.lex_state = 0, .external_lex_state = 4},
  [3941] = {.lex_state = 11},
  [3942] = {.lex_state = 11},
  [3943] = {.lex_state = 5},
  [3944] = {.lex_state = 11},
  [3945] = {.lex_state = 11},
  [3946] = {.lex_state = 5, .external_lex_state = 4},
  [3947] = {.lex_state = 22},
  [3948] = {.lex_state = 17},
  [3949] = {.lex_state = 11},
  [3950] = {.lex_state = 5},
  [3951] = {.lex_state = 11},
  [3952] = {.lex_state = 17},
  [3953] = {.lex_state = 12},
  [3954] = {.lex_state = 0},
  [3955] = {.lex_state = 0},
  [3956] = {.lex_state = 0},
  [3957] = {.lex_state = 93},
  [3958] = {.lex_state = 11},
  [3959] = {.lex_state = 93},
  [3960] = {.lex_state = 0},
  [3961] = {.lex_state = 93, .external_lex_state = 4},
  [3962] = {.lex_state = 0},
  [3963] = {.lex_state = 22},
  [3964] = {.lex_state = 11},
  [3965] = {.lex_state = 17},
  [3966] = {.lex_state = 93},
  [3967] = {.lex_state = 22},
  [3968] = {.lex_state = 0, .external_lex_state = 4},
  [3969] = {.lex_state = 17},
  [3970] = {.lex_state = 22},
  [3971] = {.lex_state = 12},
  [3972] = {.lex_state = 11},
  [3973] = {.lex_state = 17},
  [3974] = {.lex_state = 11},
  [3975] = {.lex_state = 22},
  [3976] = {.lex_state = 0},
  [3977] = {.lex_state = 22},
  [3978] = {.lex_state = 0},
  [3979] = {.lex_state = 17},
  [3980] = {.lex_state = 17},
  [3981] = {.lex_state = 11},
  [3982] = {.lex_state = 17},
  [3983] = {.lex_state = 22},
  [3984] = {.lex_state = 11},
  [3985] = {.lex_state = 11},
  [3986] = {.lex_state = 11},
  [3987] = {.lex_state = 11},
  [3988] = {.lex_state = 0, .external_lex_state = 4},
  [3989] = {.lex_state = 11},
  [3990] = {.lex_state = 0, .external_lex_state = 4},
  [3991] = {.lex_state = 11},
  [3992] = {.lex_state = 0},
  [3993] = {.lex_state = 0},
  [3994] = {.lex_state = 22},
  [3995] = {.lex_state = 11},
  [3996] = {.lex_state = 0},
  [3997] = {.lex_state = 0},
  [3998] = {.lex_state = 0},
  [3999] = {.lex_state = 0},
  [4000] = {.lex_state = 0},
  [4001] = {.lex_state = 18, .external_lex_state = 6},
  [4002] = {.lex_state = 11},
  [4003] = {.lex_state = 12},
  [4004] = {.lex_state = 93},
  [4005] = {.lex_state = 0},
  [4006] = {.lex_state = 11},
  [4007] = {.lex_state = 0, .external_lex_state = 4},
  [4008] = {.lex_state = 0},
  [4009] = {.lex_state = 0, .external_lex_state = 4},
  [4010] = {.lex_state = 0},
  [4011] = {.lex_state = 0},
  [4012] = {.lex_state = 0, .external_lex_state = 4},
  [4013] = {.lex_state = 0},
  [4014] = {.lex_state = 0},
  [4015] = {.lex_state = 0},
  [4016] = {.lex_state = 0},
  [4017] = {.lex_state = 0},
  [4018] = {.lex_state = 0, .external_lex_state = 4},
  [4019] = {.lex_state = 0},
  [4020] = {.lex_state = 0},
  [4021] = {.lex_state = 0},
  [4022] = {.lex_state = 11},
  [4023] = {.lex_state = 0},
  [4024] = {.lex_state = 0, .external_lex_state = 4},
  [4025] = {.lex_state = 0},
  [4026] = {.lex_state = 0, .external_lex_state = 4},
  [4027] = {.lex_state = 0},
  [4028] = {.lex_state = 0, .external_lex_state = 4},
  [4029] = {.lex_state = 0, .external_lex_state = 4},
  [4030] = {.lex_state = 0},
  [4031] = {.lex_state = 0},
  [4032] = {.lex_state = 11},
  [4033] = {.lex_state = 11},
  [4034] = {.lex_state = 0},
  [4035] = {.lex_state = 93, .external_lex_state = 4},
  [4036] = {.lex_state = 0},
  [4037] = {.lex_state = 0},
  [4038] = {.lex_state = 93, .external_lex_state = 4},
  [4039] = {.lex_state = 93},
  [4040] = {.lex_state = 0},
  [4041] = {.lex_state = 0},
  [4042] = {.lex_state = 93, .external_lex_state = 4},
  [4043] = {.lex_state = 0, .external_lex_state = 4},
  [4044] = {.lex_state = 0},
  [4045] = {.lex_state = 0, .external_lex_state = 4},
  [4046] = {.lex_state = 11},
  [4047] = {.lex_state = 0},
  [4048] = {.lex_state = 11},
  [4049] = {.lex_state = 11},
  [4050] = {.lex_state = 0},
  [4051] = {.lex_state = 93},
  [4052] = {.lex_state = 0},
  [4053] = {.lex_state = 0, .external_lex_state = 4},
  [4054] = {.lex_state = 93},
  [4055] = {.lex_state = 0, .external_lex_state = 4},
  [4056] = {.lex_state = 0, .external_lex_state = 4},
  [4057] = {.lex_state = 5, .external_lex_state = 4},
  [4058] = {.lex_state = 5},
  [4059] = {.lex_state = 5},
  [4060] = {.lex_state = 0, .external_lex_state = 4},
  [4061] = {.lex_state = 93, .external_lex_state = 4},
  [4062] = {.lex_state = 0},
  [4063] = {.lex_state = 0, .external_lex_state = 4},
  [4064] = {.lex_state = 0, .external_lex_state = 4},
  [4065] = {.lex_state = 0},
  [4066] = {.lex_state = 0, .external_lex_state = 4},
  [4067] = {.lex_state = 0, .external_lex_state = 4},
  [4068] = {.lex_state = 0, .external_lex_state = 4},
  [4069] = {.lex_state = 0, .external_lex_state = 4},
  [4070] = {.lex_state = 0, .external_lex_state = 4},
  [4071] = {.lex_state = 93},
  [4072] = {.lex_state = 11},
  [4073] = {.lex_state = 0},
  [4074] = {.lex_state = 93, .external_lex_state = 4},
  [4075] = {.lex_state = 93},
  [4076] = {.lex_state = 0, .external_lex_state = 4},
  [4077] = {.lex_state = 0, .external_lex_state = 4},
  [4078] = {.lex_state = 0, .external_lex_state = 4},
  [4079] = {.lex_state = 0},
  [4080] = {.lex_state = 0, .external_lex_state = 4},
  [4081] = {.lex_state = 0},
  [4082] = {.lex_state = 93, .external_lex_state = 4},
  [4083] = {.lex_state = 11},
  [4084] = {.lex_state = 0},
  [4085] = {.lex_state = 0},
  [4086] = {.lex_state = 0},
  [4087] = {.lex_state = 93, .external_lex_state = 4},
  [4088] = {.lex_state = 11},
  [4089] = {.lex_state = 0, .external_lex_state = 4},
  [4090] = {.lex_state = 93},
  [4091] = {.lex_state = 0, .external_lex_state = 4},
  [4092] = {.lex_state = 0, .external_lex_state = 4},
  [4093] = {.lex_state = 0, .external_lex_state = 4},
  [4094] = {.lex_state = 11},
  [4095] = {.lex_state = 93},
  [4096] = {.lex_state = 93},
  [4097] = {.lex_state = 0},
  [4098] = {.lex_state = 11},
  [4099] = {.lex_state = 0, .external_lex_state = 4},
  [4100] = {.lex_state = 0},
  [4101] = {.lex_state = 0},
  [4102] = {.lex_state = 0},
  [4103] = {.lex_state = 0},
  [4104] = {.lex_state = 11},
  [4105] = {.lex_state = 0},
  [4106] = {.lex_state = 93},
  [4107] = {.lex_state = 5},
  [4108] = {.lex_state = 11},
  [4109] = {.lex_state = 0},
  [4110] = {.lex_state = 93},
  [4111] = {.lex_state = 93},
  [4112] = {.lex_state = 0},
  [4113] = {.lex_state = 0, .external_lex_state = 4},
  [4114] = {.lex_state = 0},
  [4115] = {.lex_state = 0},
  [4116] = {.lex_state = 11},
  [4117] = {.lex_state = 93},
  [4118] = {.lex_state = 11},
  [4119] = {.lex_state = 0},
  [4120] = {.lex_state = 93},
  [4121] = {.lex_state = 0, .external_lex_state = 4},
  [4122] = {.lex_state = 93},
  [4123] = {.lex_state = 0},
  [4124] = {.lex_state = 0},
  [4125] = {.lex_state = 0},
  [4126] = {.lex_state = 0},
  [4127] = {.lex_state = 0, .external_lex_state = 4},
  [4128] = {.lex_state = 11},
  [4129] = {.lex_state = 0},
  [4130] = {.lex_state = 93},
  [4131] = {.lex_state = 0},
  [4132] = {.lex_state = 93},
  [4133] = {.lex_state = 5},
  [4134] = {.lex_state = 0},
  [4135] = {.lex_state = 5},
  [4136] = {.lex_state = 11},
  [4137] = {.lex_state = 0, .external_lex_state = 4},
  [4138] = {.lex_state = 0},
  [4139] = {.lex_state = 0, .external_lex_state = 4},
  [4140] = {.lex_state = 0, .external_lex_state = 4},
  [4141] = {.lex_state = 0, .external_lex_state = 4},
  [4142] = {.lex_state = 0},
  [4143] = {.lex_state = 11},
  [4144] = {.lex_state = 0, .external_lex_state = 4},
  [4145] = {.lex_state = 0},
  [4146] = {.lex_state = 0},
  [4147] = {.lex_state = 0},
  [4148] = {.lex_state = 0},
  [4149] = {.lex_state = 11},
  [4150] = {.lex_state = 0},
  [4151] = {.lex_state = 0},
  [4152] = {.lex_state = 93},
  [4153] = {.lex_state = 11},
  [4154] = {.lex_state = 0},
  [4155] = {.lex_state = 0},
  [4156] = {.lex_state = 11},
  [4157] = {.lex_state = 12},
  [4158] = {.lex_state = 0},
  [4159] = {.lex_state = 0},
  [4160] = {.lex_state = 0},
  [4161] = {.lex_state = 0, .external_lex_state = 4},
  [4162] = {.lex_state = 0},
  [4163] = {.lex_state = 0, .external_lex_state = 4},
  [4164] = {.lex_state = 0},
  [4165] = {.lex_state = 0},
  [4166] = {.lex_state = 93, .external_lex_state = 4},
  [4167] = {.lex_state = 0},
  [4168] = {.lex_state = 0},
  [4169] = {.lex_state = 0},
  [4170] = {.lex_state = 0},
  [4171] = {.lex_state = 0},
  [4172] = {.lex_state = 0},
  [4173] = {.lex_state = 0},
  [4174] = {.lex_state = 0},
  [4175] = {.lex_state = 11},
  [4176] = {.lex_state = 11},
  [4177] = {.lex_state = 0, .external_lex_state = 4},
  [4178] = {.lex_state = 11},
  [4179] = {.lex_state = 0, .external_lex_state = 4},
  [4180] = {.lex_state = 0},
  [4181] = {.lex_state = 11},
  [4182] = {.lex_state = 0},
  [4183] = {.lex_state = 0},
  [4184] = {.lex_state = 0},
  [4185] = {.lex_state = 0, .external_lex_state = 4},
  [4186] = {.lex_state = 0},
  [4187] = {.lex_state = 0, .external_lex_state = 4},
  [4188] = {.lex_state = 0},
  [4189] = {.lex_state = 93},
  [4190] = {.lex_state = 0},
  [4191] = {.lex_state = 0},
  [4192] = {.lex_state = 0, .external_lex_state = 4},
  [4193] = {.lex_state = 11},
  [4194] = {.lex_state = 5, .external_lex_state = 4},
  [4195] = {.lex_state = 0},
  [4196] = {.lex_state = 93},
  [4197] = {.lex_state = 0},
  [4198] = {.lex_state = 93},
  [4199] = {.lex_state = 0},
  [4200] = {.lex_state = 0},
  [4201] = {.lex_state = 0},
  [4202] = {.lex_state = 0},
  [4203] = {.lex_state = 0},
  [4204] = {.lex_state = 5},
  [4205] = {.lex_state = 12},
  [4206] = {.lex_state = 0, .external_lex_state = 4},
  [4207] = {.lex_state = 93},
  [4208] = {.lex_state = 93},
  [4209] = {.lex_state = 93},
  [4210] = {.lex_state = 0},
  [4211] = {.lex_state = 0},
  [4212] = {.lex_state = 93},
  [4213] = {.lex_state = 93, .external_lex_state = 4},
  [4214] = {.lex_state = 93},
  [4215] = {.lex_state = 11},
  [4216] = {.lex_state = 0},
  [4217] = {.lex_state = 0},
  [4218] = {.lex_state = 93, .external_lex_state = 4},
  [4219] = {.lex_state = 0},
  [4220] = {.lex_state = 0},
  [4221] = {.lex_state = 0, .external_lex_state = 4},
  [4222] = {.lex_state = 0},
  [4223] = {.lex_state = 0, .external_lex_state = 4},
  [4224] = {.lex_state = 0, .external_lex_state = 4},
  [4225] = {.lex_state = 93},
  [4226] = {.lex_state = 0, .external_lex_state = 4},
  [4227] = {.lex_state = 0},
  [4228] = {.lex_state = 93},
  [4229] = {.lex_state = 5},
  [4230] = {.lex_state = 0, .external_lex_state = 4},
  [4231] = {.lex_state = 5, .external_lex_state = 4},
  [4232] = {.lex_state = 0, .external_lex_state = 4},
  [4233] = {.lex_state = 5},
  [4234] = {.lex_state = 12},
  [4235] = {.lex_state = 0},
  [4236] = {.lex_state = 93},
  [4237] = {.lex_state = 11},
  [4238] = {.lex_state = 93},
  [4239] = {.lex_state = 0},
  [4240] = {.lex_state = 0},
  [4241] = {.lex_state = 11},
  [4242] = {.lex_state = 0, .external_lex_state = 4},
  [4243] = {.lex_state = 0},
  [4244] = {.lex_state = 0, .external_lex_state = 4},
  [4245] = {.lex_state = 93},
  [4246] = {.lex_state = 1},
  [4247] = {.lex_state = 0, .external_lex_state = 4},
  [4248] = {.lex_state = 93},
  [4249] = {.lex_state = 93, .external_lex_state = 4},
  [4250] = {.lex_state = 0, .external_lex_state = 4},
  [4251] = {.lex_state = 0, .external_lex_state = 4},
  [4252] = {.lex_state = 93},
  [4253] = {.lex_state = 93},
  [4254] = {.lex_state = 0},
  [4255] = {.lex_state = 93},
  [4256] = {.lex_state = 0, .external_lex_state = 4},
  [4257] = {.lex_state = 11},
  [4258] = {.lex_state = 0, .external_lex_state = 4},
  [4259] = {.lex_state = 11},
  [4260] = {.lex_state = 0},
  [4261] = {.lex_state = 5},
  [4262] = {.lex_state = 0},
  [4263] = {.lex_state = 0},
  [4264] = {.lex_state = 93, .external_lex_state = 4},
  [4265] = {.lex_state = 93},
  [4266] = {.lex_state = 93},
  [4267] = {.lex_state = 93},
  [4268] = {.lex_state = 93},
  [4269] = {.lex_state = 0},
  [4270] = {.lex_state = 5},
  [4271] = {.lex_state = 0},
  [4272] = {.lex_state = 0, .external_lex_state = 4},
  [4273] = {.lex_state = 0},
  [4274] = {.lex_state = 0},
  [4275] = {.lex_state = 0, .external_lex_state = 4},
  [4276] = {.lex_state = 0, .external_lex_state = 4},
  [4277] = {.lex_state = 11},
  [4278] = {.lex_state = 0},
  [4279] = {.lex_state = 93},
  [4280] = {.lex_state = 93},
  [4281] = {.lex_state = 93},
  [4282] = {.lex_state = 11},
  [4283] = {.lex_state = 93},
  [4284] = {.lex_state = 0},
  [4285] = {.lex_state = 93},
  [4286] = {.lex_state = 11},
  [4287] = {.lex_state = 0, .external_lex_state = 4},
  [4288] = {.lex_state = 0, .external_lex_state = 4},
  [4289] = {.lex_state = 93},
  [4290] = {.lex_state = 0},
  [4291] = {.lex_state = 0, .external_lex_state = 4},
  [4292] = {.lex_state = 93},
  [4293] = {.lex_state = 93},
  [4294] = {.lex_state = 93},
  [4295] = {.lex_state = 0},
  [4296] = {.lex_state = 93},
  [4297] = {.lex_state = 11},
  [4298] = {.lex_state = 0},
  [4299] = {.lex_state = 11},
  [4300] = {.lex_state = 11},
  [4301] = {.lex_state = 11},
  [4302] = {.lex_state = 11},
  [4303] = {.lex_state = 11},
  [4304] = {.lex_state = 11},
  [4305] = {.lex_state = 93},
  [4306] = {.lex_state = 11},
  [4307] = {.lex_state = 11},
  [4308] = {.lex_state = 11},
  [4309] = {.lex_state = 0, .external_lex_state = 4},
  [4310] = {.lex_state = 11},
  [4311] = {.lex_state = 15},
  [4312] = {.lex_state = 11},
  [4313] = {.lex_state = 0, .external_lex_state = 4},
  [4314] = {.lex_state = 11},
  [4315] = {.lex_state = 0, .external_lex_state = 4},
  [4316] = {.lex_state = 0, .external_lex_state = 4},
  [4317] = {.lex_state = 11},
  [4318] = {.lex_state = 11},
  [4319] = {.lex_state = 0},
  [4320] = {.lex_state = 11},
  [4321] = {.lex_state = 0, .external_lex_state = 4},
  [4322] = {.lex_state = 0},
  [4323] = {.lex_state = 0, .external_lex_state = 4},
  [4324] = {.lex_state = 0, .external_lex_state = 4},
  [4325] = {.lex_state = 11},
  [4326] = {.lex_state = 11},
  [4327] = {.lex_state = 11},
  [4328] = {.lex_state = 11},
  [4329] = {.lex_state = 0, .external_lex_state = 4},
  [4330] = {.lex_state = 11},
  [4331] = {.lex_state = 11},
  [4332] = {.lex_state = 0, .external_lex_state = 4},
  [4333] = {.lex_state = 93},
  [4334] = {.lex_state = 11},
  [4335] = {.lex_state = 0},
  [4336] = {.lex_state = 93},
  [4337] = {.lex_state = 11},
  [4338] = {.lex_state = 11},
  [4339] = {.lex_state = 11},
  [4340] = {.lex_state = 0},
  [4341] = {.lex_state = 11},
  [4342] = {.lex_state = 11},
  [4343] = {.lex_state = 0},
  [4344] = {.lex_state = 11},
  [4345] = {.lex_state = 11},
  [4346] = {.lex_state = 11},
  [4347] = {.lex_state = 0},
  [4348] = {.lex_state = 0},
  [4349] = {.lex_state = 0},
  [4350] = {.lex_state = 0, .external_lex_state = 4},
  [4351] = {.lex_state = 11},
  [4352] = {.lex_state = 11},
  [4353] = {.lex_state = 11},
  [4354] = {.lex_state = 11},
  [4355] = {.lex_state = 0},
  [4356] = {.lex_state = 0, .external_lex_state = 4},
  [4357] = {.lex_state = 0},
  [4358] = {.lex_state = 0, .external_lex_state = 4},
  [4359] = {.lex_state = 93},
  [4360] = {.lex_state = 11},
  [4361] = {.lex_state = 0},
  [4362] = {.lex_state = 11},
  [4363] = {.lex_state = 11},
  [4364] = {.lex_state = 93},
  [4365] = {.lex_state = 0},
  [4366] = {.lex_state = 11},
  [4367] = {.lex_state = 11},
  [4368] = {.lex_state = 11},
  [4369] = {.lex_state = 11},
  [4370] = {.lex_state = 0, .external_lex_state = 4},
  [4371] = {.lex_state = 11},
  [4372] = {.lex_state = 11},
  [4373] = {.lex_state = 11},
  [4374] = {.lex_state = 11},
  [4375] = {.lex_state = 11},
  [4376] = {.lex_state = 0, .external_lex_state = 4},
  [4377] = {.lex_state = 11},
  [4378] = {.lex_state = 11},
  [4379] = {.lex_state = 11},
  [4380] = {.lex_state = 11},
  [4381] = {.lex_state = 0},
  [4382] = {.lex_state = 11},
  [4383] = {.lex_state = 0},
  [4384] = {.lex_state = 0, .external_lex_state = 4},
  [4385] = {.lex_state = 0},
  [4386] = {.lex_state = 0},
  [4387] = {.lex_state = 93},
  [4388] = {.lex_state = 11},
  [4389] = {.lex_state = 11},
  [4390] = {.lex_state = 11},
  [4391] = {.lex_state = 0},
  [4392] = {.lex_state = 0},
  [4393] = {.lex_state = 11},
  [4394] = {.lex_state = 0, .external_lex_state = 4},
  [4395] = {.lex_state = 0, .external_lex_state = 4},
  [4396] = {.lex_state = 0},
  [4397] = {.lex_state = 11},
  [4398] = {.lex_state = 0, .external_lex_state = 4},
  [4399] = {.lex_state = 0},
  [4400] = {.lex_state = 0},
  [4401] = {.lex_state = 0},
  [4402] = {.lex_state = 11},
  [4403] = {.lex_state = 0},
  [4404] = {.lex_state = 11},
  [4405] = {.lex_state = 11},
  [4406] = {.lex_state = 93},
  [4407] = {.lex_state = 11},
  [4408] = {.lex_state = 11},
  [4409] = {.lex_state = 0},
  [4410] = {.lex_state = 93},
  [4411] = {.lex_state = 93},
  [4412] = {.lex_state = 93},
  [4413] = {.lex_state = 93},
  [4414] = {.lex_state = 0},
  [4415] = {.lex_state = 11},
  [4416] = {.lex_state = 11},
  [4417] = {.lex_state = 11},
  [4418] = {.lex_state = 11},
  [4419] = {.lex_state = 0, .external_lex_state = 4},
  [4420] = {.lex_state = 0},
  [4421] = {.lex_state = 0},
  [4422] = {.lex_state = 0, .external_lex_state = 4},
  [4423] = {.lex_state = 11},
  [4424] = {.lex_state = 0, .external_lex_state = 4},
  [4425] = {.lex_state = 93},
  [4426] = {.lex_state = 0, .external_lex_state = 4},
  [4427] = {.lex_state = 93},
  [4428] = {.lex_state = 0, .external_lex_state = 4},
  [4429] = {.lex_state = 11},
  [4430] = {.lex_state = 0, .external_lex_state = 4},
  [4431] = {.lex_state = 0, .external_lex_state = 4},
  [4432] = {.lex_state = 0, .external_lex_state = 4},
  [4433] = {.lex_state = 93},
  [4434] = {.lex_state = 0},
  [4435] = {.lex_state = 0},
  [4436] = {.lex_state = 0, .external_lex_state = 4},
  [4437] = {.lex_state = 0},
  [4438] = {.lex_state = 0},
  [4439] = {.lex_state = 11},
  [4440] = {.lex_state = 0, .external_lex_state = 4},
  [4441] = {.lex_state = 0},
  [4442] = {.lex_state = 0},
  [4443] = {.lex_state = 11},
  [4444] = {.lex_state = 11},
  [4445] = {.lex_state = 93},
  [4446] = {.lex_state = 11},
  [4447] = {.lex_state = 11},
  [4448] = {.lex_state = 11},
  [4449] = {.lex_state = 0, .external_lex_state = 4},
  [4450] = {.lex_state = 11},
  [4451] = {.lex_state = 11},
  [4452] = {.lex_state = 11},
  [4453] = {.lex_state = 11},
  [4454] = {.lex_state = 11},
  [4455] = {.lex_state = 11},
  [4456] = {.lex_state = 0},
  [4457] = {.lex_state = 0},
  [4458] = {.lex_state = 11},
  [4459] = {.lex_state = 0, .external_lex_state = 4},
  [4460] = {.lex_state = 0, .external_lex_state = 4},
  [4461] = {.lex_state = 0},
  [4462] = {.lex_state = 0, .external_lex_state = 4},
  [4463] = {.lex_state = 11},
  [4464] = {.lex_state = 0},
  [4465] = {.lex_state = 11},
  [4466] = {.lex_state = 0, .external_lex_state = 4},
  [4467] = {.lex_state = 11},
  [4468] = {.lex_state = 0},
  [4469] = {.lex_state = 0},
  [4470] = {.lex_state = 0, .external_lex_state = 4},
  [4471] = {.lex_state = 0},
  [4472] = {.lex_state = 0},
  [4473] = {.lex_state = 11},
  [4474] = {.lex_state = 11},
  [4475] = {.lex_state = 0, .external_lex_state = 4},
  [4476] = {.lex_state = 11},
  [4477] = {.lex_state = 0},
  [4478] = {.lex_state = 0},
  [4479] = {.lex_state = 0, .external_lex_state = 4},
  [4480] = {.lex_state = 0},
  [4481] = {.lex_state = 11},
  [4482] = {.lex_state = 0, .external_lex_state = 4},
  [4483] = {.lex_state = 0},
  [4484] = {.lex_state = 0},
  [4485] = {.lex_state = 0},
  [4486] = {.lex_state = 0},
  [4487] = {.lex_state = 0},
  [4488] = {.lex_state = 11},
  [4489] = {.lex_state = 0},
  [4490] = {.lex_state = 0},
  [4491] = {.lex_state = 11},
  [4492] = {.lex_state = 0, .external_lex_state = 4},
  [4493] = {.lex_state = 11},
  [4494] = {.lex_state = 11},
  [4495] = {.lex_state = 0},
  [4496] = {.lex_state = 0},
  [4497] = {.lex_state = 11},
  [4498] = {.lex_state = 93},
  [4499] = {.lex_state = 0},
  [4500] = {.lex_state = 93},
  [4501] = {.lex_state = 11},
  [4502] = {.lex_state = 1},
  [4503] = {.lex_state = 11},
  [4504] = {.lex_state = 0},
  [4505] = {.lex_state = 11},
  [4506] = {.lex_state = 11},
  [4507] = {.lex_state = 0},
  [4508] = {.lex_state = 11},
  [4509] = {.lex_state = 0},
  [4510] = {.lex_state = 11},
  [4511] = {.lex_state = 11},
  [4512] = {.lex_state = 0},
  [4513] = {.lex_state = 11},
  [4514] = {.lex_state = 0, .external_lex_state = 4},
  [4515] = {.lex_state = 0},
  [4516] = {.lex_state = 11},
  [4517] = {.lex_state = 0},
  [4518] = {.lex_state = 0, .external_lex_state = 4},
  [4519] = {.lex_state = 11},
  [4520] = {.lex_state = 0},
  [4521] = {.lex_state = 11},
  [4522] = {.lex_state = 0},
  [4523] = {.lex_state = 0},
  [4524] = {.lex_state = 0},
  [4525] = {.lex_state = 11},
  [4526] = {.lex_state = 11},
  [4527] = {.lex_state = 93},
  [4528] = {.lex_state = 0, .external_lex_state = 4},
  [4529] = {.lex_state = 0},
  [4530] = {.lex_state = 11},
  [4531] = {.lex_state = 11},
  [4532] = {.lex_state = 93},
  [4533] = {.lex_state = 11},
  [4534] = {.lex_state = 11},
  [4535] = {.lex_state = 0},
  [4536] = {.lex_state = 0},
  [4537] = {.lex_state = 0},
  [4538] = {.lex_state = 11},
  [4539] = {.lex_state = 0},
  [4540] = {.lex_state = 0},
  [4541] = {.lex_state = 0},
  [4542] = {.lex_state = 0, .external_lex_state = 4},
  [4543] = {.lex_state = 0},
  [4544] = {.lex_state = 0},
  [4545] = {.lex_state = 11},
  [4546] = {.lex_state = 11},
  [4547] = {.lex_state = 0},
  [4548] = {.lex_state = 0},
  [4549] = {.lex_state = 0, .external_lex_state = 4},
  [4550] = {.lex_state = 93},
  [4551] = {.lex_state = 0, .external_lex_state = 4},
  [4552] = {.lex_state = 0, .external_lex_state = 4},
  [4553] = {.lex_state = 11},
  [4554] = {.lex_state = 0, .external_lex_state = 4},
  [4555] = {.lex_state = 11},
  [4556] = {.lex_state = 0, .external_lex_state = 4},
  [4557] = {.lex_state = 0, .external_lex_state = 4},
  [4558] = {.lex_state = 0, .external_lex_state = 4},
  [4559] = {.lex_state = 0},
  [4560] = {.lex_state = 0},
  [4561] = {.lex_state = 93},
  [4562] = {.lex_state = 0},
  [4563] = {.lex_state = 93},
  [4564] = {.lex_state = 0},
  [4565] = {.lex_state = 0, .external_lex_state = 4},
  [4566] = {.lex_state = 0},
  [4567] = {.lex_state = 0},
  [4568] = {.lex_state = 0},
  [4569] = {.lex_state = 0, .external_lex_state = 4},
  [4570] = {.lex_state = 0, .external_lex_state = 4},
  [4571] = {.lex_state = 0},
  [4572] = {.lex_state = 0, .external_lex_state = 4},
  [4573] = {.lex_state = 11},
  [4574] = {.lex_state = 11},
  [4575] = {.lex_state = 11},
  [4576] = {.lex_state = 11},
  [4577] = {.lex_state = 0},
  [4578] = {.lex_state = 0, .external_lex_state = 4},
  [4579] = {.lex_state = 11},
  [4580] = {.lex_state = 11},
  [4581] = {.lex_state = 11},
  [4582] = {.lex_state = 0},
  [4583] = {.lex_state = 0},
  [4584] = {.lex_state = 11},
  [4585] = {.lex_state = 11},
  [4586] = {.lex_state = 11},
  [4587] = {.lex_state = 11},
  [4588] = {.lex_state = 93},
  [4589] = {.lex_state = 11},
  [4590] = {.lex_state = 11},
  [4591] = {.lex_state = 0},
  [4592] = {.lex_state = 0},
  [4593] = {.lex_state = 11},
  [4594] = {.lex_state = 0},
  [4595] = {.lex_state = 0, .external_lex_state = 4},
  [4596] = {.lex_state = 11},
  [4597] = {.lex_state = 11},
  [4598] = {.lex_state = 0},
  [4599] = {.lex_state = 0},
  [4600] = {.lex_state = 0},
  [4601] = {.lex_state = 0},
  [4602] = {.lex_state = 0},
  [4603] = {.lex_state = 93},
  [4604] = {.lex_state = 0, .external_lex_state = 4},
  [4605] = {.lex_state = 0, .external_lex_state = 4},
  [4606] = {.lex_state = 0, .external_lex_state = 4},
  [4607] = {.lex_state = 0},
  [4608] = {.lex_state = 0, .external_lex_state = 4},
  [4609] = {.lex_state = 0, .external_lex_state = 4},
  [4610] = {.lex_state = 11},
  [4611] = {.lex_state = 93},
  [4612] = {.lex_state = 11},
  [4613] = {.lex_state = 93},
  [4614] = {.lex_state = 0},
  [4615] = {.lex_state = 0, .external_lex_state = 4},
  [4616] = {.lex_state = 0},
  [4617] = {.lex_state = 11},
  [4618] = {.lex_state = 11},
  [4619] = {.lex_state = 11},
  [4620] = {.lex_state = 93},
  [4621] = {.lex_state = 11},
  [4622] = {.lex_state = 93},
  [4623] = {.lex_state = 11},
  [4624] = {.lex_state = 11},
  [4625] = {.lex_state = 93},
  [4626] = {.lex_state = 93},
  [4627] = {.lex_state = 11},
  [4628] = {.lex_state = 0},
  [4629] = {.lex_state = 0, .external_lex_state = 4},
  [4630] = {.lex_state = 0, .external_lex_state = 4},
  [4631] = {.lex_state = 0, .external_lex_state = 4},
  [4632] = {.lex_state = 93},
  [4633] = {.lex_state = 11},
  [4634] = {.lex_state = 5},
  [4635] = {.lex_state = 0},
  [4636] = {.lex_state = 0},
  [4637] = {.lex_state = 0},
  [4638] = {.lex_state = 0},
  [4639] = {.lex_state = 93},
  [4640] = {.lex_state = 0},
  [4641] = {.lex_state = 0},
  [4642] = {.lex_state = 0},
  [4643] = {.lex_state = 93},
  [4644] = {.lex_state = 93},
  [4645] = {.lex_state = 93},
  [4646] = {.lex_state = 0},
  [4647] = {.lex_state = 0},
  [4648] = {.lex_state = 93},
  [4649] = {.lex_state = 0},
  [4650] = {.lex_state = 0},
  [4651] = {.lex_state = 0},
  [4652] = {.lex_state = 0},
  [4653] = {.lex_state = 0},
  [4654] = {.lex_state = 0},
  [4655] = {.lex_state = 0},
  [4656] = {.lex_state = 0},
  [4657] = {.lex_state = 0},
  [4658] = {.lex_state = 0},
  [4659] = {.lex_state = 0},
  [4660] = {.lex_state = 0},
  [4661] = {.lex_state = 0},
  [4662] = {.lex_state = 93},
  [4663] = {.lex_state = 93},
  [4664] = {.lex_state = 0},
  [4665] = {.lex_state = 5},
  [4666] = {.lex_state = 2},
  [4667] = {.lex_state = 0},
  [4668] = {.lex_state = 0},
  [4669] = {.lex_state = 0},
  [4670] = {.lex_state = 0},
  [4671] = {.lex_state = 93},
  [4672] = {.lex_state = 93},
  [4673] = {.lex_state = 0},
  [4674] = {.lex_state = 0},
  [4675] = {.lex_state = 0},
  [4676] = {.lex_state = 93},
  [4677] = {.lex_state = 93},
  [4678] = {.lex_state = 0},
  [4679] = {.lex_state = 93},
  [4680] = {.lex_state = 93},
  [4681] = {.lex_state = 0},
  [4682] = {.lex_state = 93},
  [4683] = {.lex_state = 0},
  [4684] = {.lex_state = 93},
  [4685] = {.lex_state = 0},
  [4686] = {.lex_state = 0},
  [4687] = {.lex_state = 0},
  [4688] = {.lex_state = 93},
  [4689] = {.lex_state = 0},
  [4690] = {.lex_state = 93},
  [4691] = {.lex_state = 0},
  [4692] = {.lex_state = 93},
  [4693] = {.lex_state = 0},
  [4694] = {.lex_state = 0},
  [4695] = {.lex_state = 0},
  [4696] = {.lex_state = 0},
  [4697] = {.lex_state = 93},
  [4698] = {.lex_state = 0},
  [4699] = {.lex_state = 0},
  [4700] = {.lex_state = 0},
  [4701] = {.lex_state = 0},
  [4702] = {.lex_state = 0},
  [4703] = {.lex_state = 0},
  [4704] = {.lex_state = 0},
  [4705] = {.lex_state = 0},
  [4706] = {.lex_state = 12},
  [4707] = {.lex_state = 0},
  [4708] = {.lex_state = 0},
  [4709] = {.lex_state = 93},
  [4710] = {.lex_state = 93},
  [4711] = {.lex_state = 0},
  [4712] = {.lex_state = 0},
  [4713] = {.lex_state = 0},
  [4714] = {.lex_state = 0},
  [4715] = {.lex_state = 0},
  [4716] = {.lex_state = 0},
  [4717] = {.lex_state = 0},
  [4718] = {.lex_state = 0},
  [4719] = {.lex_state = 93},
  [4720] = {.lex_state = 93},
  [4721] = {.lex_state = 0},
  [4722] = {.lex_state = 0},
  [4723] = {.lex_state = 93},
  [4724] = {.lex_state = 0},
  [4725] = {.lex_state = 93},
  [4726] = {.lex_state = 0},
  [4727] = {.lex_state = 93},
  [4728] = {.lex_state = 0},
  [4729] = {.lex_state = 93},
  [4730] = {.lex_state = 0},
  [4731] = {.lex_state = 0},
  [4732] = {.lex_state = 0},
  [4733] = {.lex_state = 0},
  [4734] = {.lex_state = 0},
  [4735] = {.lex_state = 93},
  [4736] = {.lex_state = 0},
  [4737] = {.lex_state = 0},
  [4738] = {.lex_state = 93},
  [4739] = {.lex_state = 0},
  [4740] = {.lex_state = 0},
  [4741] = {.lex_state = 93},
  [4742] = {.lex_state = 0},
  [4743] = {.lex_state = 93},
  [4744] = {.lex_state = 93},
  [4745] = {.lex_state = 93},
  [4746] = {.lex_state = 0},
  [4747] = {.lex_state = 0},
  [4748] = {.lex_state = 0},
  [4749] = {.lex_state = 0},
  [4750] = {.lex_state = 0},
  [4751] = {.lex_state = 0},
  [4752] = {.lex_state = 2},
  [4753] = {.lex_state = 12},
  [4754] = {.lex_state = 93},
  [4755] = {.lex_state = 0},
  [4756] = {.lex_state = 0},
  [4757] = {.lex_state = 93},
  [4758] = {.lex_state = 5},
  [4759] = {.lex_state = 2},
  [4760] = {.lex_state = 0},
  [4761] = {.lex_state = 93},
  [4762] = {.lex_state = 93},
  [4763] = {.lex_state = 93},
  [4764] = {.lex_state = 93},
  [4765] = {.lex_state = 93},
  [4766] = {.lex_state = 93},
  [4767] = {.lex_state = 0},
  [4768] = {.lex_state = 0},
  [4769] = {.lex_state = 93},
  [4770] = {.lex_state = 0},
  [4771] = {.lex_state = 0},
  [4772] = {.lex_state = 0},
  [4773] = {.lex_state = 0},
  [4774] = {.lex_state = 0},
  [4775] = {.lex_state = 0},
  [4776] = {.lex_state = 0},
  [4777] = {.lex_state = 12},
  [4778] = {.lex_state = 93},
  [4779] = {.lex_state = 0},
  [4780] = {.lex_state = 93},
  [4781] = {.lex_state = 0},
  [4782] = {.lex_state = 0},
  [4783] = {.lex_state = 93},
  [4784] = {.lex_state = 0},
  [4785] = {.lex_state = 0},
  [4786] = {.lex_state = 0},
  [4787] = {.lex_state = 0},
  [4788] = {.lex_state = 12},
  [4789] = {.lex_state = 5},
  [4790] = {.lex_state = 2},
  [4791] = {.lex_state = 5},
  [4792] = {.lex_state = 11},
  [4793] = {.lex_state = 0},
  [4794] = {.lex_state = 0},
  [4795] = {.lex_state = 0},
  [4796] = {.lex_state = 11},
  [4797] = {.lex_state = 0},
  [4798] = {.lex_state = 0},
  [4799] = {.lex_state = 93},
  [4800] = {.lex_state = 93},
  [4801] = {.lex_state = 93},
  [4802] = {.lex_state = 0},
  [4803] = {.lex_state = 0},
  [4804] = {.lex_state = 0},
  [4805] = {.lex_state = 0},
  [4806] = {.lex_state = 0},
  [4807] = {.lex_state = 0},
  [4808] = {.lex_state = 0},
  [4809] = {.lex_state = 93},
  [4810] = {.lex_state = 93},
  [4811] = {.lex_state = 5},
  [4812] = {.lex_state = 93},
  [4813] = {.lex_state = 93},
  [4814] = {.lex_state = 0},
  [4815] = {.lex_state = 93},
  [4816] = {.lex_state = 93},
  [4817] = {.lex_state = 0},
  [4818] = {.lex_state = 2},
  [4819] = {.lex_state = 93},
  [4820] = {.lex_state = 93},
  [4821] = {.lex_state = 0},
  [4822] = {.lex_state = 0},
  [4823] = {.lex_state = 0},
  [4824] = {.lex_state = 0},
  [4825] = {.lex_state = 93},
  [4826] = {.lex_state = 0},
  [4827] = {.lex_state = 0},
  [4828] = {.lex_state = 0},
  [4829] = {.lex_state = 93},
  [4830] = {.lex_state = 0},
  [4831] = {.lex_state = 93},
  [4832] = {.lex_state = 0},
  [4833] = {.lex_state = 93},
  [4834] = {.lex_state = 93},
  [4835] = {.lex_state = 93},
  [4836] = {.lex_state = 93},
  [4837] = {.lex_state = 93},
  [4838] = {.lex_state = 0},
  [4839] = {.lex_state = 0},
  [4840] = {.lex_state = 0},
  [4841] = {.lex_state = 0},
  [4842] = {.lex_state = 93},
  [4843] = {.lex_state = 93},
  [4844] = {.lex_state = 93},
  [4845] = {.lex_state = 0},
  [4846] = {.lex_state = 0},
  [4847] = {.lex_state = 0},
  [4848] = {.lex_state = 0},
  [4849] = {.lex_state = 93},
  [4850] = {.lex_state = 0},
  [4851] = {.lex_state = 0},
  [4852] = {.lex_state = 93},
  [4853] = {.lex_state = 93},
  [4854] = {.lex_state = 0},
  [4855] = {.lex_state = 0},
  [4856] = {.lex_state = 0},
  [4857] = {.lex_state = 0},
  [4858] = {.lex_state = 0},
  [4859] = {.lex_state = 0},
  [4860] = {.lex_state = 0},
  [4861] = {.lex_state = 0},
  [4862] = {.lex_state = 0},
  [4863] = {.lex_state = 0},
  [4864] = {.lex_state = 0},
  [4865] = {.lex_state = 0},
  [4866] = {.lex_state = 0},
  [4867] = {.lex_state = 0},
  [4868] = {.lex_state = 0},
  [4869] = {.lex_state = 93},
  [4870] = {.lex_state = 5},
  [4871] = {.lex_state = 12},
  [4872] = {.lex_state = 0},
  [4873] = {.lex_state = 0},
  [4874] = {.lex_state = 0},
  [4875] = {.lex_state = 93},
  [4876] = {.lex_state = 0},
  [4877] = {.lex_state = 0},
  [4878] = {.lex_state = 0},
  [4879] = {.lex_state = 0},
  [4880] = {.lex_state = 93},
  [4881] = {.lex_state = 93},
  [4882] = {.lex_state = 0},
  [4883] = {.lex_state = 0},
  [4884] = {.lex_state = 0},
  [4885] = {.lex_state = 0},
  [4886] = {.lex_state = 0},
  [4887] = {.lex_state = 93},
  [4888] = {.lex_state = 93},
  [4889] = {.lex_state = 0},
  [4890] = {.lex_state = 0},
  [4891] = {.lex_state = 0},
  [4892] = {.lex_state = 0},
  [4893] = {.lex_state = 0},
  [4894] = {.lex_state = 0},
  [4895] = {.lex_state = 0},
  [4896] = {.lex_state = 0},
  [4897] = {.lex_state = 0},
  [4898] = {.lex_state = 93},
  [4899] = {.lex_state = 93},
  [4900] = {.lex_state = 93},
  [4901] = {.lex_state = 0},
  [4902] = {.lex_state = 0},
  [4903] = {.lex_state = 0},
  [4904] = {.lex_state = 0},
  [4905] = {.lex_state = 0},
  [4906] = {.lex_state = 0},
  [4907] = {.lex_state = 0},
  [4908] = {.lex_state = 0},
  [4909] = {.lex_state = 0},
  [4910] = {.lex_state = 0},
  [4911] = {.lex_state = 0},
  [4912] = {.lex_state = 0},
  [4913] = {.lex_state = 0},
  [4914] = {.lex_state = 0},
  [4915] = {.lex_state = 93},
  [4916] = {.lex_state = 0},
  [4917] = {.lex_state = 93},
  [4918] = {.lex_state = 93},
  [4919] = {.lex_state = 93},
  [4920] = {.lex_state = 93},
  [4921] = {.lex_state = 93},
  [4922] = {.lex_state = 0},
  [4923] = {.lex_state = 0},
  [4924] = {.lex_state = 0},
  [4925] = {.lex_state = 93},
  [4926] = {.lex_state = 0},
  [4927] = {.lex_state = 93},
  [4928] = {.lex_state = 93},
  [4929] = {.lex_state = 93},
  [4930] = {.lex_state = 93},
  [4931] = {.lex_state = 93},
  [4932] = {.lex_state = 0},
  [4933] = {.lex_state = 93},
  [4934] = {.lex_state = 0},
  [4935] = {.lex_state = 0},
  [4936] = {.lex_state = 0},
  [4937] = {.lex_state = 0},
  [4938] = {.lex_state = 0},
  [4939] = {.lex_state = 12},
  [4940] = {.lex_state = 0},
  [4941] = {.lex_state = 0},
  [4942] = {.lex_state = 0},
  [4943] = {.lex_state = 0},
  [4944] = {.lex_state = 0},
  [4945] = {.lex_state = 93},
  [4946] = {.lex_state = 0},
  [4947] = {.lex_state = 0},
  [4948] = {.lex_state = 0},
  [4949] = {.lex_state = 93},
  [4950] = {.lex_state = 0},
  [4951] = {.lex_state = 0},
  [4952] = {.lex_state = 0},
  [4953] = {.lex_state = 0},
  [4954] = {.lex_state = 93},
  [4955] = {.lex_state = 93},
  [4956] = {.lex_state = 93},
  [4957] = {.lex_state = 0},
  [4958] = {.lex_state = 0},
  [4959] = {.lex_state = 0},
  [4960] = {.lex_state = 93},
  [4961] = {.lex_state = 0},
  [4962] = {.lex_state = 0},
  [4963] = {.lex_state = 93},
  [4964] = {.lex_state = 93},
  [4965] = {.lex_state = 0},
  [4966] = {.lex_state = 93},
  [4967] = {.lex_state = 0},
  [4968] = {.lex_state = 0},
  [4969] = {.lex_state = 0},
  [4970] = {.lex_state = 93},
  [4971] = {.lex_state = 0},
  [4972] = {.lex_state = 0},
  [4973] = {.lex_state = 0},
  [4974] = {.lex_state = 0},
  [4975] = {.lex_state = 0},
  [4976] = {.lex_state = 93},
  [4977] = {.lex_state = 0},
  [4978] = {.lex_state = 0},
  [4979] = {.lex_state = 0},
  [4980] = {.lex_state = 93},
  [4981] = {.lex_state = 0},
  [4982] = {.lex_state = 0},
  [4983] = {.lex_state = 0},
  [4984] = {.lex_state = 0},
  [4985] = {.lex_state = 0},
  [4986] = {.lex_state = 0},
  [4987] = {.lex_state = 0},
  [4988] = {.lex_state = 93},
  [4989] = {.lex_state = 11},
  [4990] = {.lex_state = 93},
  [4991] = {.lex_state = 93},
  [4992] = {.lex_state = 0},
  [4993] = {.lex_state = 93},
  [4994] = {.lex_state = 0},
  [4995] = {.lex_state = 93},
  [4996] = {.lex_state = 93},
  [4997] = {.lex_state = 0},
  [4998] = {.lex_state = 0},
  [4999] = {.lex_state = 93},
  [5000] = {.lex_state = 0},
  [5001] = {.lex_state = 0},
  [5002] = {.lex_state = 0},
  [5003] = {.lex_state = 93},
  [5004] = {.lex_state = 93},
  [5005] = {.lex_state = 93},
  [5006] = {.lex_state = 0},
  [5007] = {.lex_state = 0},
  [5008] = {.lex_state = 93},
  [5009] = {.lex_state = 93},
  [5010] = {.lex_state = 93},
  [5011] = {.lex_state = 0},
  [5012] = {.lex_state = 0},
};

enum {
  ts_external_token__automatic_semicolon = 0,
  ts_external_token__template_chars = 1,
  ts_external_token__ternary_qmark = 2,
  ts_external_token_PIPE_PIPE = 3,
  ts_external_token__function_signature_automatic_semicolon = 4,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__automatic_semicolon] = sym__automatic_semicolon,
  [ts_external_token__template_chars] = sym__template_chars,
  [ts_external_token__ternary_qmark] = sym__ternary_qmark,
  [ts_external_token_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [ts_external_token__function_signature_automatic_semicolon] = sym__function_signature_automatic_semicolon,
};

static const bool ts_external_scanner_states[7][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__template_chars] = true,
    [ts_external_token__ternary_qmark] = true,
    [ts_external_token_PIPE_PIPE] = true,
    [ts_external_token__function_signature_automatic_semicolon] = true,
  },
  [2] = {
    [ts_external_token__ternary_qmark] = true,
    [ts_external_token_PIPE_PIPE] = true,
  },
  [3] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__ternary_qmark] = true,
    [ts_external_token_PIPE_PIPE] = true,
  },
  [4] = {
    [ts_external_token__automatic_semicolon] = true,
  },
  [5] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__function_signature_automatic_semicolon] = true,
  },
  [6] = {
    [ts_external_token__template_chars] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_namespace] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_debugger] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LTtemplate_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_QMARK_DOT] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_private_property_identifier] = ACTIONS(1),
    [anon_sym_target] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_undefined] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_readonly] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_declare] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [anon_sym_override] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_any] = ACTIONS(1),
    [anon_sym_number] = ACTIONS(1),
    [anon_sym_boolean] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_symbol] = ACTIONS(1),
    [anon_sym_property] = ACTIONS(1),
    [anon_sym_signal] = ACTIONS(1),
    [anon_sym_on] = ACTIONS(1),
    [anon_sym_required] = ACTIONS(1),
    [anon_sym_component] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_require] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_DASH_QMARK_COLON] = ACTIONS(1),
    [anon_sym_asserts] = ACTIONS(1),
    [anon_sym_infer] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_keyof] = ACTIONS(1),
    [anon_sym_unknown] = ACTIONS(1),
    [anon_sym_never] = ACTIONS(1),
    [anon_sym_object] = ACTIONS(1),
    [anon_sym_LBRACE_PIPE] = ACTIONS(1),
    [anon_sym_PIPE_RBRACE] = ACTIONS(1),
    [anon_sym_pragma] = ACTIONS(1),
    [aux_sym_ui_version_specifier_token1] = ACTIONS(1),
    [anon_sym_list] = ACTIONS(1),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars] = ACTIONS(1),
    [sym__ternary_qmark] = ACTIONS(1),
    [sym__function_signature_automatic_semicolon] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(5001),
    [sym_ui_pragma] = STATE(2433),
    [sym_ui_import] = STATE(2433),
    [sym_ui_object_definition] = STATE(4997),
    [sym_ui_annotated_object] = STATE(4997),
    [sym_ui_annotation] = STATE(2769),
    [sym_ui_nested_identifier] = STATE(4261),
    [aux_sym_program_repeat1] = STATE(2433),
    [aux_sym_ui_annotated_object_repeat1] = STATE(2768),
    [sym_identifier] = ACTIONS(5),
    [sym_hash_bang_line] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(9),
    [anon_sym_type] = ACTIONS(9),
    [anon_sym_namespace] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(9),
    [anon_sym_of] = ACTIONS(9),
    [anon_sym_async] = ACTIONS(9),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_static] = ACTIONS(9),
    [anon_sym_readonly] = ACTIONS(9),
    [anon_sym_get] = ACTIONS(9),
    [anon_sym_set] = ACTIONS(9),
    [anon_sym_declare] = ACTIONS(9),
    [anon_sym_public] = ACTIONS(9),
    [anon_sym_private] = ACTIONS(9),
    [anon_sym_protected] = ACTIONS(9),
    [anon_sym_override] = ACTIONS(9),
    [anon_sym_module] = ACTIONS(9),
    [anon_sym_any] = ACTIONS(9),
    [anon_sym_number] = ACTIONS(9),
    [anon_sym_boolean] = ACTIONS(9),
    [anon_sym_string] = ACTIONS(9),
    [anon_sym_symbol] = ACTIONS(9),
    [anon_sym_property] = ACTIONS(9),
    [anon_sym_signal] = ACTIONS(9),
    [anon_sym_on] = ACTIONS(9),
    [anon_sym_required] = ACTIONS(9),
    [anon_sym_component] = ACTIONS(9),
    [anon_sym_pragma] = ACTIONS(15),
  },
  [2] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1175),
    [sym_expression] = STATE(2338),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3296),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3296),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_nested_identifier] = STATE(4870),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4895),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1240),
    [sym_subscript_expression] = STATE(1240),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2865),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3296),
    [sym_ternary_expression] = STATE(1751),
    [sym_binary_expression] = STATE(1751),
    [sym_unary_expression] = STATE(1751),
    [sym_update_expression] = STATE(1751),
    [sym_string] = STATE(2176),
    [sym_template_string] = STATE(1752),
    [sym_regex] = STATE(1752),
    [sym_meta_property] = STATE(1752),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3846),
    [sym_pattern] = STATE(3581),
    [sym_rest_pattern] = STATE(3298),
    [sym_non_null_expression] = STATE(1240),
    [sym_type_assertion] = STATE(1751),
    [sym_as_expression] = STATE(1751),
    [sym_internal_module] = STATE(1751),
    [sym_nested_type_identifier] = STATE(2837),
    [sym__type] = STATE(2919),
    [sym_constructor_type] = STATE(2919),
    [sym__primary_type] = STATE(2839),
    [sym_template_literal_type] = STATE(2840),
    [sym_infer_type] = STATE(2919),
    [sym_conditional_type] = STATE(2840),
    [sym_generic_type] = STATE(2840),
    [sym_type_query] = STATE(2840),
    [sym_index_type_query] = STATE(2840),
    [sym_lookup_type] = STATE(2840),
    [sym_literal_type] = STATE(2840),
    [sym__number] = STATE(2880),
    [sym_existential_type] = STATE(2840),
    [sym_flow_maybe_type] = STATE(2840),
    [sym_parenthesized_type] = STATE(2840),
    [sym_predefined_type] = STATE(2840),
    [sym_type_arguments] = STATE(463),
    [sym_object_type] = STATE(2840),
    [sym_type_parameters] = STATE(4567),
    [sym_array_type] = STATE(2840),
    [sym_tuple_type] = STATE(2840),
    [sym_readonly_type] = STATE(2919),
    [sym_union_type] = STATE(2840),
    [sym_intersection_type] = STATE(2840),
    [sym_function_type] = STATE(2919),
    [aux_sym_export_statement_repeat1] = STATE(3866),
    [sym_identifier] = ACTIONS(17),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_EQ] = ACTIONS(23),
    [anon_sym_as] = ACTIONS(26),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(30),
    [anon_sym_COMMA] = ACTIONS(32),
    [anon_sym_typeof] = ACTIONS(34),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(38),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(32),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_in] = ACTIONS(26),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_COLON] = ACTIONS(32),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(26),
    [anon_sym_SLASH] = ACTIONS(53),
    [anon_sym_DOT] = ACTIONS(26),
    [anon_sym_class] = ACTIONS(56),
    [anon_sym_async] = ACTIONS(58),
    [anon_sym_function] = ACTIONS(60),
    [anon_sym_EQ_GT] = ACTIONS(62),
    [anon_sym_QMARK_DOT] = ACTIONS(64),
    [anon_sym_new] = ACTIONS(66),
    [anon_sym_PLUS_EQ] = ACTIONS(68),
    [anon_sym_DASH_EQ] = ACTIONS(68),
    [anon_sym_STAR_EQ] = ACTIONS(68),
    [anon_sym_SLASH_EQ] = ACTIONS(68),
    [anon_sym_PERCENT_EQ] = ACTIONS(68),
    [anon_sym_CARET_EQ] = ACTIONS(68),
    [anon_sym_AMP_EQ] = ACTIONS(68),
    [anon_sym_PIPE_EQ] = ACTIONS(68),
    [anon_sym_GT_GT_EQ] = ACTIONS(68),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(68),
    [anon_sym_LT_LT_EQ] = ACTIONS(68),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(68),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(68),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(68),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(68),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(70),
    [anon_sym_AMP_AMP] = ACTIONS(26),
    [anon_sym_PIPE_PIPE] = ACTIONS(26),
    [anon_sym_GT_GT] = ACTIONS(26),
    [anon_sym_GT_GT_GT] = ACTIONS(26),
    [anon_sym_LT_LT] = ACTIONS(26),
    [anon_sym_AMP] = ACTIONS(72),
    [anon_sym_CARET] = ACTIONS(26),
    [anon_sym_PIPE] = ACTIONS(74),
    [anon_sym_PLUS] = ACTIONS(76),
    [anon_sym_DASH] = ACTIONS(76),
    [anon_sym_PERCENT] = ACTIONS(26),
    [anon_sym_STAR_STAR] = ACTIONS(26),
    [anon_sym_LT_EQ] = ACTIONS(64),
    [anon_sym_EQ_EQ] = ACTIONS(26),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(64),
    [anon_sym_BANG_EQ] = ACTIONS(26),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(64),
    [anon_sym_QMARK_QMARK] = ACTIONS(26),
    [anon_sym_instanceof] = ACTIONS(26),
    [anon_sym_TILDE] = ACTIONS(78),
    [anon_sym_void] = ACTIONS(80),
    [anon_sym_delete] = ACTIONS(82),
    [anon_sym_PLUS_PLUS] = ACTIONS(84),
    [anon_sym_DASH_DASH] = ACTIONS(84),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_SQUOTE] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(91),
    [sym_number] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(97),
    [sym_true] = ACTIONS(99),
    [sym_false] = ACTIONS(99),
    [sym_null] = ACTIONS(99),
    [sym_undefined] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(107),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(19),
    [anon_sym_private] = ACTIONS(19),
    [anon_sym_protected] = ACTIONS(19),
    [anon_sym_override] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(109),
    [anon_sym_number] = ACTIONS(109),
    [anon_sym_boolean] = ACTIONS(109),
    [anon_sym_string] = ACTIONS(109),
    [anon_sym_symbol] = ACTIONS(109),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [anon_sym_abstract] = ACTIONS(111),
    [anon_sym_infer] = ACTIONS(113),
    [anon_sym_keyof] = ACTIONS(115),
    [anon_sym_unknown] = ACTIONS(117),
    [anon_sym_never] = ACTIONS(117),
    [anon_sym_object] = ACTIONS(117),
    [anon_sym_LBRACE_PIPE] = ACTIONS(119),
    [sym__ternary_qmark] = ACTIONS(64),
  },
  [3] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1175),
    [sym_expression] = STATE(2338),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3296),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3296),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_nested_identifier] = STATE(4870),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4895),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1240),
    [sym_subscript_expression] = STATE(1240),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2865),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3296),
    [sym_ternary_expression] = STATE(1751),
    [sym_binary_expression] = STATE(1751),
    [sym_unary_expression] = STATE(1751),
    [sym_update_expression] = STATE(1751),
    [sym_string] = STATE(2176),
    [sym_template_string] = STATE(1752),
    [sym_regex] = STATE(1752),
    [sym_meta_property] = STATE(1752),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3846),
    [sym_pattern] = STATE(3581),
    [sym_rest_pattern] = STATE(3298),
    [sym_non_null_expression] = STATE(1240),
    [sym_type_assertion] = STATE(1751),
    [sym_as_expression] = STATE(1751),
    [sym_internal_module] = STATE(1751),
    [sym_nested_type_identifier] = STATE(2837),
    [sym__type] = STATE(2919),
    [sym_constructor_type] = STATE(2919),
    [sym__primary_type] = STATE(2839),
    [sym_template_literal_type] = STATE(2840),
    [sym_infer_type] = STATE(2919),
    [sym_conditional_type] = STATE(2840),
    [sym_generic_type] = STATE(2840),
    [sym_type_query] = STATE(2840),
    [sym_index_type_query] = STATE(2840),
    [sym_lookup_type] = STATE(2840),
    [sym_literal_type] = STATE(2840),
    [sym__number] = STATE(2880),
    [sym_existential_type] = STATE(2840),
    [sym_flow_maybe_type] = STATE(2840),
    [sym_parenthesized_type] = STATE(2840),
    [sym_predefined_type] = STATE(2840),
    [sym_type_arguments] = STATE(463),
    [sym_object_type] = STATE(2840),
    [sym_type_parameters] = STATE(4567),
    [sym_array_type] = STATE(2840),
    [sym_tuple_type] = STATE(2840),
    [sym_readonly_type] = STATE(2919),
    [sym_union_type] = STATE(2840),
    [sym_intersection_type] = STATE(2840),
    [sym_function_type] = STATE(2919),
    [aux_sym_export_statement_repeat1] = STATE(3866),
    [sym_identifier] = ACTIONS(17),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_EQ] = ACTIONS(121),
    [anon_sym_as] = ACTIONS(26),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(30),
    [anon_sym_COMMA] = ACTIONS(124),
    [anon_sym_typeof] = ACTIONS(34),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(38),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(124),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_in] = ACTIONS(26),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_COLON] = ACTIONS(124),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(26),
    [anon_sym_SLASH] = ACTIONS(53),
    [anon_sym_DOT] = ACTIONS(26),
    [anon_sym_class] = ACTIONS(56),
    [anon_sym_async] = ACTIONS(58),
    [anon_sym_function] = ACTIONS(60),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_QMARK_DOT] = ACTIONS(64),
    [anon_sym_new] = ACTIONS(66),
    [anon_sym_PLUS_EQ] = ACTIONS(68),
    [anon_sym_DASH_EQ] = ACTIONS(68),
    [anon_sym_STAR_EQ] = ACTIONS(68),
    [anon_sym_SLASH_EQ] = ACTIONS(68),
    [anon_sym_PERCENT_EQ] = ACTIONS(68),
    [anon_sym_CARET_EQ] = ACTIONS(68),
    [anon_sym_AMP_EQ] = ACTIONS(68),
    [anon_sym_PIPE_EQ] = ACTIONS(68),
    [anon_sym_GT_GT_EQ] = ACTIONS(68),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(68),
    [anon_sym_LT_LT_EQ] = ACTIONS(68),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(68),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(68),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(68),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(68),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(70),
    [anon_sym_AMP_AMP] = ACTIONS(26),
    [anon_sym_PIPE_PIPE] = ACTIONS(26),
    [anon_sym_GT_GT] = ACTIONS(26),
    [anon_sym_GT_GT_GT] = ACTIONS(26),
    [anon_sym_LT_LT] = ACTIONS(26),
    [anon_sym_AMP] = ACTIONS(72),
    [anon_sym_CARET] = ACTIONS(26),
    [anon_sym_PIPE] = ACTIONS(74),
    [anon_sym_PLUS] = ACTIONS(76),
    [anon_sym_DASH] = ACTIONS(76),
    [anon_sym_PERCENT] = ACTIONS(26),
    [anon_sym_STAR_STAR] = ACTIONS(26),
    [anon_sym_LT_EQ] = ACTIONS(64),
    [anon_sym_EQ_EQ] = ACTIONS(26),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(64),
    [anon_sym_BANG_EQ] = ACTIONS(26),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(64),
    [anon_sym_QMARK_QMARK] = ACTIONS(26),
    [anon_sym_instanceof] = ACTIONS(26),
    [anon_sym_TILDE] = ACTIONS(78),
    [anon_sym_void] = ACTIONS(80),
    [anon_sym_delete] = ACTIONS(82),
    [anon_sym_PLUS_PLUS] = ACTIONS(84),
    [anon_sym_DASH_DASH] = ACTIONS(84),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_SQUOTE] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(91),
    [sym_number] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(97),
    [sym_true] = ACTIONS(99),
    [sym_false] = ACTIONS(99),
    [sym_null] = ACTIONS(99),
    [sym_undefined] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(107),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(19),
    [anon_sym_private] = ACTIONS(19),
    [anon_sym_protected] = ACTIONS(19),
    [anon_sym_override] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(109),
    [anon_sym_number] = ACTIONS(109),
    [anon_sym_boolean] = ACTIONS(109),
    [anon_sym_string] = ACTIONS(109),
    [anon_sym_symbol] = ACTIONS(109),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [anon_sym_abstract] = ACTIONS(111),
    [anon_sym_infer] = ACTIONS(113),
    [anon_sym_keyof] = ACTIONS(115),
    [anon_sym_unknown] = ACTIONS(117),
    [anon_sym_never] = ACTIONS(117),
    [anon_sym_object] = ACTIONS(117),
    [anon_sym_LBRACE_PIPE] = ACTIONS(119),
    [sym__ternary_qmark] = ACTIONS(64),
  },
  [4] = {
    [sym_export_statement] = STATE(27),
    [sym_declaration] = STATE(27),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(27),
    [sym_expression_statement] = STATE(27),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(27),
    [sym_if_statement] = STATE(27),
    [sym_switch_statement] = STATE(27),
    [sym_for_statement] = STATE(27),
    [sym_for_in_statement] = STATE(27),
    [sym_while_statement] = STATE(27),
    [sym_do_statement] = STATE(27),
    [sym_try_statement] = STATE(27),
    [sym_with_statement] = STATE(27),
    [sym_break_statement] = STATE(27),
    [sym_continue_statement] = STATE(27),
    [sym_debugger_statement] = STATE(27),
    [sym_return_statement] = STATE(27),
    [sym_throw_statement] = STATE(27),
    [sym_empty_statement] = STATE(27),
    [sym_labeled_statement] = STATE(27),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4681),
    [sym_object_assignment_pattern] = STATE(4148),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4681),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4681),
    [sym_spread_element] = STATE(4034),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2230),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_rest_pattern] = STATE(4148),
    [sym_method_definition] = STATE(4034),
    [sym_pair] = STATE(4034),
    [sym_pair_pattern] = STATE(4148),
    [sym__property_name] = STATE(3324),
    [sym_computed_property_name] = STATE(3324),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_accessibility_modifier] = STATE(2476),
    [sym_override_modifier] = STATE(2491),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(27),
    [aux_sym_object_repeat1] = STATE(4031),
    [aux_sym_object_pattern_repeat1] = STATE(4142),
    [sym_identifier] = ACTIONS(129),
    [anon_sym_export] = ACTIONS(131),
    [anon_sym_STAR] = ACTIONS(133),
    [anon_sym_type] = ACTIONS(135),
    [anon_sym_namespace] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_RBRACE] = ACTIONS(143),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(149),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(191),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(197),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(203),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(213),
    [sym_private_property_identifier] = ACTIONS(215),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(221),
    [anon_sym_readonly] = ACTIONS(223),
    [anon_sym_get] = ACTIONS(225),
    [anon_sym_set] = ACTIONS(225),
    [anon_sym_declare] = ACTIONS(227),
    [anon_sym_public] = ACTIONS(229),
    [anon_sym_private] = ACTIONS(229),
    [anon_sym_protected] = ACTIONS(229),
    [anon_sym_override] = ACTIONS(231),
    [anon_sym_module] = ACTIONS(233),
    [anon_sym_any] = ACTIONS(149),
    [anon_sym_number] = ACTIONS(149),
    [anon_sym_boolean] = ACTIONS(149),
    [anon_sym_string] = ACTIONS(149),
    [anon_sym_symbol] = ACTIONS(149),
    [anon_sym_property] = ACTIONS(149),
    [anon_sym_signal] = ACTIONS(149),
    [anon_sym_on] = ACTIONS(149),
    [anon_sym_required] = ACTIONS(149),
    [anon_sym_component] = ACTIONS(149),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [5] = {
    [sym_export_statement] = STATE(22),
    [sym_declaration] = STATE(22),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_for_in_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_try_statement] = STATE(22),
    [sym_with_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_debugger_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_throw_statement] = STATE(22),
    [sym_empty_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4681),
    [sym_object_assignment_pattern] = STATE(4148),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4681),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4681),
    [sym_spread_element] = STATE(4034),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2230),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_rest_pattern] = STATE(4148),
    [sym_method_definition] = STATE(4034),
    [sym_pair] = STATE(4034),
    [sym_pair_pattern] = STATE(4148),
    [sym__property_name] = STATE(3324),
    [sym_computed_property_name] = STATE(3324),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_accessibility_modifier] = STATE(2476),
    [sym_override_modifier] = STATE(2491),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(22),
    [aux_sym_object_repeat1] = STATE(4031),
    [aux_sym_object_pattern_repeat1] = STATE(4142),
    [sym_identifier] = ACTIONS(129),
    [anon_sym_export] = ACTIONS(131),
    [anon_sym_STAR] = ACTIONS(133),
    [anon_sym_type] = ACTIONS(135),
    [anon_sym_namespace] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_RBRACE] = ACTIONS(241),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(149),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(191),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(197),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(203),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(213),
    [sym_private_property_identifier] = ACTIONS(215),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(221),
    [anon_sym_readonly] = ACTIONS(223),
    [anon_sym_get] = ACTIONS(225),
    [anon_sym_set] = ACTIONS(225),
    [anon_sym_declare] = ACTIONS(227),
    [anon_sym_public] = ACTIONS(229),
    [anon_sym_private] = ACTIONS(229),
    [anon_sym_protected] = ACTIONS(229),
    [anon_sym_override] = ACTIONS(231),
    [anon_sym_module] = ACTIONS(233),
    [anon_sym_any] = ACTIONS(149),
    [anon_sym_number] = ACTIONS(149),
    [anon_sym_boolean] = ACTIONS(149),
    [anon_sym_string] = ACTIONS(149),
    [anon_sym_symbol] = ACTIONS(149),
    [anon_sym_property] = ACTIONS(149),
    [anon_sym_signal] = ACTIONS(149),
    [anon_sym_on] = ACTIONS(149),
    [anon_sym_required] = ACTIONS(149),
    [anon_sym_component] = ACTIONS(149),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [6] = {
    [sym_export_statement] = STATE(19),
    [sym_declaration] = STATE(19),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(19),
    [sym_expression_statement] = STATE(19),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(19),
    [sym_if_statement] = STATE(19),
    [sym_switch_statement] = STATE(19),
    [sym_for_statement] = STATE(19),
    [sym_for_in_statement] = STATE(19),
    [sym_while_statement] = STATE(19),
    [sym_do_statement] = STATE(19),
    [sym_try_statement] = STATE(19),
    [sym_with_statement] = STATE(19),
    [sym_break_statement] = STATE(19),
    [sym_continue_statement] = STATE(19),
    [sym_debugger_statement] = STATE(19),
    [sym_return_statement] = STATE(19),
    [sym_throw_statement] = STATE(19),
    [sym_empty_statement] = STATE(19),
    [sym_labeled_statement] = STATE(19),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4681),
    [sym_object_assignment_pattern] = STATE(4148),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4681),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4681),
    [sym_spread_element] = STATE(4034),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2230),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_rest_pattern] = STATE(4148),
    [sym_method_definition] = STATE(4034),
    [sym_pair] = STATE(4034),
    [sym_pair_pattern] = STATE(4148),
    [sym__property_name] = STATE(3324),
    [sym_computed_property_name] = STATE(3324),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_accessibility_modifier] = STATE(2476),
    [sym_override_modifier] = STATE(2491),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(19),
    [aux_sym_object_repeat1] = STATE(4031),
    [aux_sym_object_pattern_repeat1] = STATE(4142),
    [sym_identifier] = ACTIONS(129),
    [anon_sym_export] = ACTIONS(131),
    [anon_sym_STAR] = ACTIONS(133),
    [anon_sym_type] = ACTIONS(135),
    [anon_sym_namespace] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_RBRACE] = ACTIONS(243),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(149),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(191),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(197),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(203),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(213),
    [sym_private_property_identifier] = ACTIONS(215),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(221),
    [anon_sym_readonly] = ACTIONS(223),
    [anon_sym_get] = ACTIONS(225),
    [anon_sym_set] = ACTIONS(225),
    [anon_sym_declare] = ACTIONS(227),
    [anon_sym_public] = ACTIONS(229),
    [anon_sym_private] = ACTIONS(229),
    [anon_sym_protected] = ACTIONS(229),
    [anon_sym_override] = ACTIONS(231),
    [anon_sym_module] = ACTIONS(233),
    [anon_sym_any] = ACTIONS(149),
    [anon_sym_number] = ACTIONS(149),
    [anon_sym_boolean] = ACTIONS(149),
    [anon_sym_string] = ACTIONS(149),
    [anon_sym_symbol] = ACTIONS(149),
    [anon_sym_property] = ACTIONS(149),
    [anon_sym_signal] = ACTIONS(149),
    [anon_sym_on] = ACTIONS(149),
    [anon_sym_required] = ACTIONS(149),
    [anon_sym_component] = ACTIONS(149),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [7] = {
    [sym_export_statement] = STATE(19),
    [sym_declaration] = STATE(19),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(19),
    [sym_expression_statement] = STATE(19),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(19),
    [sym_if_statement] = STATE(19),
    [sym_switch_statement] = STATE(19),
    [sym_for_statement] = STATE(19),
    [sym_for_in_statement] = STATE(19),
    [sym_while_statement] = STATE(19),
    [sym_do_statement] = STATE(19),
    [sym_try_statement] = STATE(19),
    [sym_with_statement] = STATE(19),
    [sym_break_statement] = STATE(19),
    [sym_continue_statement] = STATE(19),
    [sym_debugger_statement] = STATE(19),
    [sym_return_statement] = STATE(19),
    [sym_throw_statement] = STATE(19),
    [sym_empty_statement] = STATE(19),
    [sym_labeled_statement] = STATE(19),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4681),
    [sym_object_assignment_pattern] = STATE(4148),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4681),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4681),
    [sym_spread_element] = STATE(4034),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2230),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_rest_pattern] = STATE(4148),
    [sym_method_definition] = STATE(4034),
    [sym_pair] = STATE(4034),
    [sym_pair_pattern] = STATE(4148),
    [sym__property_name] = STATE(3324),
    [sym_computed_property_name] = STATE(3324),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_accessibility_modifier] = STATE(2476),
    [sym_override_modifier] = STATE(2491),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(19),
    [aux_sym_object_repeat1] = STATE(4031),
    [aux_sym_object_pattern_repeat1] = STATE(4142),
    [sym_identifier] = ACTIONS(129),
    [anon_sym_export] = ACTIONS(131),
    [anon_sym_STAR] = ACTIONS(133),
    [anon_sym_type] = ACTIONS(135),
    [anon_sym_namespace] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_RBRACE] = ACTIONS(245),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(149),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(191),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(197),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(203),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(213),
    [sym_private_property_identifier] = ACTIONS(215),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(221),
    [anon_sym_readonly] = ACTIONS(223),
    [anon_sym_get] = ACTIONS(225),
    [anon_sym_set] = ACTIONS(225),
    [anon_sym_declare] = ACTIONS(227),
    [anon_sym_public] = ACTIONS(229),
    [anon_sym_private] = ACTIONS(229),
    [anon_sym_protected] = ACTIONS(229),
    [anon_sym_override] = ACTIONS(231),
    [anon_sym_module] = ACTIONS(233),
    [anon_sym_any] = ACTIONS(149),
    [anon_sym_number] = ACTIONS(149),
    [anon_sym_boolean] = ACTIONS(149),
    [anon_sym_string] = ACTIONS(149),
    [anon_sym_symbol] = ACTIONS(149),
    [anon_sym_property] = ACTIONS(149),
    [anon_sym_signal] = ACTIONS(149),
    [anon_sym_on] = ACTIONS(149),
    [anon_sym_required] = ACTIONS(149),
    [anon_sym_component] = ACTIONS(149),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [8] = {
    [sym_export_statement] = STATE(23),
    [sym_declaration] = STATE(23),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(23),
    [sym_expression_statement] = STATE(23),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(23),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_for_in_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_do_statement] = STATE(23),
    [sym_try_statement] = STATE(23),
    [sym_with_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_debugger_statement] = STATE(23),
    [sym_return_statement] = STATE(23),
    [sym_throw_statement] = STATE(23),
    [sym_empty_statement] = STATE(23),
    [sym_labeled_statement] = STATE(23),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4681),
    [sym_object_assignment_pattern] = STATE(4148),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4681),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4681),
    [sym_spread_element] = STATE(4052),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2230),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_rest_pattern] = STATE(4148),
    [sym_method_definition] = STATE(4052),
    [sym_pair] = STATE(4052),
    [sym_pair_pattern] = STATE(4148),
    [sym__property_name] = STATE(3324),
    [sym_computed_property_name] = STATE(3324),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_accessibility_modifier] = STATE(2476),
    [sym_override_modifier] = STATE(2491),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(23),
    [aux_sym_object_repeat1] = STATE(4037),
    [aux_sym_object_pattern_repeat1] = STATE(4142),
    [sym_identifier] = ACTIONS(247),
    [anon_sym_export] = ACTIONS(249),
    [anon_sym_STAR] = ACTIONS(133),
    [anon_sym_type] = ACTIONS(251),
    [anon_sym_namespace] = ACTIONS(253),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_RBRACE] = ACTIONS(255),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(257),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(257),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(191),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(259),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(203),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(213),
    [sym_private_property_identifier] = ACTIONS(215),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(261),
    [anon_sym_readonly] = ACTIONS(263),
    [anon_sym_get] = ACTIONS(265),
    [anon_sym_set] = ACTIONS(265),
    [anon_sym_declare] = ACTIONS(267),
    [anon_sym_public] = ACTIONS(269),
    [anon_sym_private] = ACTIONS(269),
    [anon_sym_protected] = ACTIONS(269),
    [anon_sym_override] = ACTIONS(271),
    [anon_sym_module] = ACTIONS(273),
    [anon_sym_any] = ACTIONS(257),
    [anon_sym_number] = ACTIONS(257),
    [anon_sym_boolean] = ACTIONS(257),
    [anon_sym_string] = ACTIONS(257),
    [anon_sym_symbol] = ACTIONS(257),
    [anon_sym_property] = ACTIONS(257),
    [anon_sym_signal] = ACTIONS(257),
    [anon_sym_on] = ACTIONS(257),
    [anon_sym_required] = ACTIONS(257),
    [anon_sym_component] = ACTIONS(257),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [9] = {
    [sym_export_statement] = STATE(23),
    [sym_declaration] = STATE(23),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(23),
    [sym_expression_statement] = STATE(23),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(23),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_for_in_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_do_statement] = STATE(23),
    [sym_try_statement] = STATE(23),
    [sym_with_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_debugger_statement] = STATE(23),
    [sym_return_statement] = STATE(23),
    [sym_throw_statement] = STATE(23),
    [sym_empty_statement] = STATE(23),
    [sym_labeled_statement] = STATE(23),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4681),
    [sym_object_assignment_pattern] = STATE(4148),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4681),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4681),
    [sym_spread_element] = STATE(4052),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2230),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_rest_pattern] = STATE(4148),
    [sym_method_definition] = STATE(4052),
    [sym_pair] = STATE(4052),
    [sym_pair_pattern] = STATE(4148),
    [sym__property_name] = STATE(3324),
    [sym_computed_property_name] = STATE(3324),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_accessibility_modifier] = STATE(2476),
    [sym_override_modifier] = STATE(2491),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(23),
    [aux_sym_object_repeat1] = STATE(4037),
    [aux_sym_object_pattern_repeat1] = STATE(4142),
    [sym_identifier] = ACTIONS(275),
    [anon_sym_export] = ACTIONS(277),
    [anon_sym_STAR] = ACTIONS(133),
    [anon_sym_type] = ACTIONS(279),
    [anon_sym_namespace] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_RBRACE] = ACTIONS(255),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(283),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(283),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(191),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(285),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(203),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(213),
    [sym_private_property_identifier] = ACTIONS(215),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(287),
    [anon_sym_readonly] = ACTIONS(289),
    [anon_sym_get] = ACTIONS(291),
    [anon_sym_set] = ACTIONS(291),
    [anon_sym_declare] = ACTIONS(293),
    [anon_sym_public] = ACTIONS(295),
    [anon_sym_private] = ACTIONS(295),
    [anon_sym_protected] = ACTIONS(295),
    [anon_sym_override] = ACTIONS(297),
    [anon_sym_module] = ACTIONS(299),
    [anon_sym_any] = ACTIONS(283),
    [anon_sym_number] = ACTIONS(283),
    [anon_sym_boolean] = ACTIONS(283),
    [anon_sym_string] = ACTIONS(283),
    [anon_sym_symbol] = ACTIONS(283),
    [anon_sym_property] = ACTIONS(283),
    [anon_sym_signal] = ACTIONS(283),
    [anon_sym_on] = ACTIONS(283),
    [anon_sym_required] = ACTIONS(283),
    [anon_sym_component] = ACTIONS(283),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [10] = {
    [sym_export_statement] = STATE(23),
    [sym_declaration] = STATE(23),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(23),
    [sym_expression_statement] = STATE(23),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(23),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_for_in_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_do_statement] = STATE(23),
    [sym_try_statement] = STATE(23),
    [sym_with_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_debugger_statement] = STATE(23),
    [sym_return_statement] = STATE(23),
    [sym_throw_statement] = STATE(23),
    [sym_empty_statement] = STATE(23),
    [sym_labeled_statement] = STATE(23),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4681),
    [sym_object_assignment_pattern] = STATE(4148),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4681),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4681),
    [sym_spread_element] = STATE(4052),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2230),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_rest_pattern] = STATE(4148),
    [sym_method_definition] = STATE(4052),
    [sym_pair] = STATE(4052),
    [sym_pair_pattern] = STATE(4148),
    [sym__property_name] = STATE(3324),
    [sym_computed_property_name] = STATE(3324),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_accessibility_modifier] = STATE(2476),
    [sym_override_modifier] = STATE(2491),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(23),
    [aux_sym_object_repeat1] = STATE(4037),
    [aux_sym_object_pattern_repeat1] = STATE(4142),
    [sym_identifier] = ACTIONS(301),
    [anon_sym_export] = ACTIONS(303),
    [anon_sym_STAR] = ACTIONS(133),
    [anon_sym_type] = ACTIONS(305),
    [anon_sym_namespace] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_RBRACE] = ACTIONS(255),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(309),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(309),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(191),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(311),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(203),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(213),
    [sym_private_property_identifier] = ACTIONS(215),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(313),
    [anon_sym_readonly] = ACTIONS(315),
    [anon_sym_get] = ACTIONS(317),
    [anon_sym_set] = ACTIONS(317),
    [anon_sym_declare] = ACTIONS(319),
    [anon_sym_public] = ACTIONS(321),
    [anon_sym_private] = ACTIONS(321),
    [anon_sym_protected] = ACTIONS(321),
    [anon_sym_override] = ACTIONS(323),
    [anon_sym_module] = ACTIONS(325),
    [anon_sym_any] = ACTIONS(309),
    [anon_sym_number] = ACTIONS(309),
    [anon_sym_boolean] = ACTIONS(309),
    [anon_sym_string] = ACTIONS(309),
    [anon_sym_symbol] = ACTIONS(309),
    [anon_sym_property] = ACTIONS(309),
    [anon_sym_signal] = ACTIONS(309),
    [anon_sym_on] = ACTIONS(309),
    [anon_sym_required] = ACTIONS(309),
    [anon_sym_component] = ACTIONS(309),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [11] = {
    [sym_export_statement] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(12),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_default] = ACTIONS(331),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(337),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_case] = ACTIONS(331),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [12] = {
    [sym_export_statement] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(12),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(354),
    [anon_sym_default] = ACTIONS(357),
    [anon_sym_type] = ACTIONS(359),
    [anon_sym_namespace] = ACTIONS(362),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_RBRACE] = ACTIONS(368),
    [anon_sym_typeof] = ACTIONS(370),
    [anon_sym_import] = ACTIONS(373),
    [anon_sym_from] = ACTIONS(376),
    [anon_sym_var] = ACTIONS(379),
    [anon_sym_let] = ACTIONS(382),
    [anon_sym_const] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(388),
    [anon_sym_if] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(394),
    [anon_sym_for] = ACTIONS(397),
    [anon_sym_LPAREN] = ACTIONS(400),
    [anon_sym_await] = ACTIONS(403),
    [anon_sym_of] = ACTIONS(376),
    [anon_sym_while] = ACTIONS(406),
    [anon_sym_do] = ACTIONS(409),
    [anon_sym_try] = ACTIONS(412),
    [anon_sym_with] = ACTIONS(415),
    [anon_sym_break] = ACTIONS(418),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_debugger] = ACTIONS(424),
    [anon_sym_return] = ACTIONS(427),
    [anon_sym_throw] = ACTIONS(430),
    [anon_sym_SEMI] = ACTIONS(433),
    [anon_sym_case] = ACTIONS(357),
    [anon_sym_yield] = ACTIONS(436),
    [anon_sym_LBRACK] = ACTIONS(439),
    [anon_sym_LTtemplate_GT] = ACTIONS(442),
    [anon_sym_LT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(448),
    [anon_sym_class] = ACTIONS(451),
    [anon_sym_async] = ACTIONS(454),
    [anon_sym_function] = ACTIONS(457),
    [anon_sym_new] = ACTIONS(460),
    [anon_sym_PLUS] = ACTIONS(370),
    [anon_sym_DASH] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(388),
    [anon_sym_void] = ACTIONS(370),
    [anon_sym_delete] = ACTIONS(370),
    [anon_sym_PLUS_PLUS] = ACTIONS(463),
    [anon_sym_DASH_DASH] = ACTIONS(463),
    [anon_sym_DQUOTE] = ACTIONS(466),
    [anon_sym_SQUOTE] = ACTIONS(469),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(472),
    [sym_number] = ACTIONS(475),
    [sym_this] = ACTIONS(478),
    [sym_super] = ACTIONS(478),
    [sym_true] = ACTIONS(478),
    [sym_false] = ACTIONS(478),
    [sym_null] = ACTIONS(478),
    [sym_undefined] = ACTIONS(481),
    [anon_sym_AT] = ACTIONS(484),
    [anon_sym_static] = ACTIONS(376),
    [anon_sym_readonly] = ACTIONS(376),
    [anon_sym_get] = ACTIONS(376),
    [anon_sym_set] = ACTIONS(376),
    [anon_sym_declare] = ACTIONS(487),
    [anon_sym_public] = ACTIONS(376),
    [anon_sym_private] = ACTIONS(376),
    [anon_sym_protected] = ACTIONS(376),
    [anon_sym_override] = ACTIONS(376),
    [anon_sym_module] = ACTIONS(490),
    [anon_sym_any] = ACTIONS(376),
    [anon_sym_number] = ACTIONS(376),
    [anon_sym_boolean] = ACTIONS(376),
    [anon_sym_string] = ACTIONS(376),
    [anon_sym_symbol] = ACTIONS(376),
    [anon_sym_property] = ACTIONS(376),
    [anon_sym_signal] = ACTIONS(376),
    [anon_sym_on] = ACTIONS(376),
    [anon_sym_required] = ACTIONS(376),
    [anon_sym_component] = ACTIONS(376),
    [anon_sym_abstract] = ACTIONS(493),
    [anon_sym_interface] = ACTIONS(496),
    [anon_sym_enum] = ACTIONS(499),
  },
  [13] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(11),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_default] = ACTIONS(502),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(504),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_case] = ACTIONS(502),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [14] = {
    [sym_export_statement] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(12),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_default] = ACTIONS(506),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(508),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_case] = ACTIONS(506),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [15] = {
    [sym_export_statement] = STATE(14),
    [sym_declaration] = STATE(14),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(14),
    [sym_expression_statement] = STATE(14),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(14),
    [sym_if_statement] = STATE(14),
    [sym_switch_statement] = STATE(14),
    [sym_for_statement] = STATE(14),
    [sym_for_in_statement] = STATE(14),
    [sym_while_statement] = STATE(14),
    [sym_do_statement] = STATE(14),
    [sym_try_statement] = STATE(14),
    [sym_with_statement] = STATE(14),
    [sym_break_statement] = STATE(14),
    [sym_continue_statement] = STATE(14),
    [sym_debugger_statement] = STATE(14),
    [sym_return_statement] = STATE(14),
    [sym_throw_statement] = STATE(14),
    [sym_empty_statement] = STATE(14),
    [sym_labeled_statement] = STATE(14),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(14),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_default] = ACTIONS(510),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(512),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_case] = ACTIONS(510),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [16] = {
    [sym_export_statement] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(12),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(514),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [17] = {
    [sym_export_statement] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(12),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(516),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [18] = {
    [sym_export_statement] = STATE(22),
    [sym_declaration] = STATE(22),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_for_in_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_try_statement] = STATE(22),
    [sym_with_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_debugger_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_throw_statement] = STATE(22),
    [sym_empty_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(22),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(518),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [19] = {
    [sym_export_statement] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(12),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(520),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [20] = {
    [sym_export_statement] = STATE(27),
    [sym_declaration] = STATE(27),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(27),
    [sym_expression_statement] = STATE(27),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(27),
    [sym_if_statement] = STATE(27),
    [sym_switch_statement] = STATE(27),
    [sym_for_statement] = STATE(27),
    [sym_for_in_statement] = STATE(27),
    [sym_while_statement] = STATE(27),
    [sym_do_statement] = STATE(27),
    [sym_try_statement] = STATE(27),
    [sym_with_statement] = STATE(27),
    [sym_break_statement] = STATE(27),
    [sym_continue_statement] = STATE(27),
    [sym_debugger_statement] = STATE(27),
    [sym_return_statement] = STATE(27),
    [sym_throw_statement] = STATE(27),
    [sym_empty_statement] = STATE(27),
    [sym_labeled_statement] = STATE(27),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(27),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(522),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [21] = {
    [sym_export_statement] = STATE(23),
    [sym_declaration] = STATE(23),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(23),
    [sym_expression_statement] = STATE(23),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(23),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_for_in_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_do_statement] = STATE(23),
    [sym_try_statement] = STATE(23),
    [sym_with_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_debugger_statement] = STATE(23),
    [sym_return_statement] = STATE(23),
    [sym_throw_statement] = STATE(23),
    [sym_empty_statement] = STATE(23),
    [sym_labeled_statement] = STATE(23),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(23),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(524),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [22] = {
    [sym_export_statement] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(12),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(526),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [23] = {
    [sym_export_statement] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(12),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(528),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [24] = {
    [sym_export_statement] = STATE(25),
    [sym_declaration] = STATE(25),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(25),
    [sym_expression_statement] = STATE(25),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(25),
    [sym_if_statement] = STATE(25),
    [sym_switch_statement] = STATE(25),
    [sym_for_statement] = STATE(25),
    [sym_for_in_statement] = STATE(25),
    [sym_while_statement] = STATE(25),
    [sym_do_statement] = STATE(25),
    [sym_try_statement] = STATE(25),
    [sym_with_statement] = STATE(25),
    [sym_break_statement] = STATE(25),
    [sym_continue_statement] = STATE(25),
    [sym_debugger_statement] = STATE(25),
    [sym_return_statement] = STATE(25),
    [sym_throw_statement] = STATE(25),
    [sym_empty_statement] = STATE(25),
    [sym_labeled_statement] = STATE(25),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(25),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(530),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [25] = {
    [sym_export_statement] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(12),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(532),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [26] = {
    [sym_export_statement] = STATE(17),
    [sym_declaration] = STATE(17),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(17),
    [sym_expression_statement] = STATE(17),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(17),
    [sym_if_statement] = STATE(17),
    [sym_switch_statement] = STATE(17),
    [sym_for_statement] = STATE(17),
    [sym_for_in_statement] = STATE(17),
    [sym_while_statement] = STATE(17),
    [sym_do_statement] = STATE(17),
    [sym_try_statement] = STATE(17),
    [sym_with_statement] = STATE(17),
    [sym_break_statement] = STATE(17),
    [sym_continue_statement] = STATE(17),
    [sym_debugger_statement] = STATE(17),
    [sym_return_statement] = STATE(17),
    [sym_throw_statement] = STATE(17),
    [sym_empty_statement] = STATE(17),
    [sym_labeled_statement] = STATE(17),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(17),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(534),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [27] = {
    [sym_export_statement] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(12),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(536),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [28] = {
    [sym_export_statement] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(12),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(538),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [29] = {
    [sym_export_statement] = STATE(19),
    [sym_declaration] = STATE(19),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(19),
    [sym_expression_statement] = STATE(19),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(19),
    [sym_if_statement] = STATE(19),
    [sym_switch_statement] = STATE(19),
    [sym_for_statement] = STATE(19),
    [sym_for_in_statement] = STATE(19),
    [sym_while_statement] = STATE(19),
    [sym_do_statement] = STATE(19),
    [sym_try_statement] = STATE(19),
    [sym_with_statement] = STATE(19),
    [sym_break_statement] = STATE(19),
    [sym_continue_statement] = STATE(19),
    [sym_debugger_statement] = STATE(19),
    [sym_return_statement] = STATE(19),
    [sym_throw_statement] = STATE(19),
    [sym_empty_statement] = STATE(19),
    [sym_labeled_statement] = STATE(19),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(19),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(540),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [30] = {
    [sym_export_statement] = STATE(16),
    [sym_declaration] = STATE(16),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(16),
    [sym_expression_statement] = STATE(16),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(16),
    [sym_if_statement] = STATE(16),
    [sym_switch_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_for_in_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_do_statement] = STATE(16),
    [sym_try_statement] = STATE(16),
    [sym_with_statement] = STATE(16),
    [sym_break_statement] = STATE(16),
    [sym_continue_statement] = STATE(16),
    [sym_debugger_statement] = STATE(16),
    [sym_return_statement] = STATE(16),
    [sym_throw_statement] = STATE(16),
    [sym_empty_statement] = STATE(16),
    [sym_labeled_statement] = STATE(16),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(16),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(542),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [31] = {
    [sym_export_statement] = STATE(28),
    [sym_declaration] = STATE(28),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(28),
    [sym_expression_statement] = STATE(28),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(28),
    [sym_if_statement] = STATE(28),
    [sym_switch_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_for_in_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_do_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_with_statement] = STATE(28),
    [sym_break_statement] = STATE(28),
    [sym_continue_statement] = STATE(28),
    [sym_debugger_statement] = STATE(28),
    [sym_return_statement] = STATE(28),
    [sym_throw_statement] = STATE(28),
    [sym_empty_statement] = STATE(28),
    [sym_labeled_statement] = STATE(28),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [aux_sym_statement_block_repeat1] = STATE(28),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(544),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [32] = {
    [sym_export_statement] = STATE(4849),
    [sym_declaration] = STATE(4849),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(4849),
    [sym_expression_statement] = STATE(4849),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(4849),
    [sym_if_statement] = STATE(4849),
    [sym_switch_statement] = STATE(4849),
    [sym_for_statement] = STATE(4849),
    [sym_for_in_statement] = STATE(4849),
    [sym_while_statement] = STATE(4849),
    [sym_do_statement] = STATE(4849),
    [sym_try_statement] = STATE(4849),
    [sym_with_statement] = STATE(4849),
    [sym_break_statement] = STATE(4849),
    [sym_continue_statement] = STATE(4849),
    [sym_debugger_statement] = STATE(4849),
    [sym_return_statement] = STATE(4849),
    [sym_throw_statement] = STATE(4849),
    [sym_empty_statement] = STATE(4849),
    [sym_labeled_statement] = STATE(4849),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1862),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4514),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(2191),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3374),
    [sym_identifier] = ACTIONS(546),
    [anon_sym_export] = ACTIONS(548),
    [anon_sym_type] = ACTIONS(550),
    [anon_sym_namespace] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(556),
    [anon_sym_var] = ACTIONS(558),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(560),
    [anon_sym_switch] = ACTIONS(562),
    [anon_sym_for] = ACTIONS(564),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(556),
    [anon_sym_while] = ACTIONS(566),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_with] = ACTIONS(570),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(574),
    [anon_sym_async] = ACTIONS(576),
    [anon_sym_function] = ACTIONS(578),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(556),
    [anon_sym_readonly] = ACTIONS(556),
    [anon_sym_get] = ACTIONS(556),
    [anon_sym_set] = ACTIONS(556),
    [anon_sym_declare] = ACTIONS(580),
    [anon_sym_public] = ACTIONS(556),
    [anon_sym_private] = ACTIONS(556),
    [anon_sym_protected] = ACTIONS(556),
    [anon_sym_override] = ACTIONS(556),
    [anon_sym_module] = ACTIONS(582),
    [anon_sym_any] = ACTIONS(556),
    [anon_sym_number] = ACTIONS(556),
    [anon_sym_boolean] = ACTIONS(556),
    [anon_sym_string] = ACTIONS(556),
    [anon_sym_symbol] = ACTIONS(556),
    [anon_sym_property] = ACTIONS(556),
    [anon_sym_signal] = ACTIONS(556),
    [anon_sym_on] = ACTIONS(556),
    [anon_sym_required] = ACTIONS(556),
    [anon_sym_component] = ACTIONS(556),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [33] = {
    [sym_export_statement] = STATE(2696),
    [sym_declaration] = STATE(2696),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(2696),
    [sym_expression_statement] = STATE(2696),
    [sym_variable_declaration] = STATE(2592),
    [sym_lexical_declaration] = STATE(2592),
    [sym_statement_block] = STATE(2696),
    [sym_if_statement] = STATE(2696),
    [sym_switch_statement] = STATE(2696),
    [sym_for_statement] = STATE(2696),
    [sym_for_in_statement] = STATE(2696),
    [sym_while_statement] = STATE(2696),
    [sym_do_statement] = STATE(2696),
    [sym_try_statement] = STATE(2696),
    [sym_with_statement] = STATE(2696),
    [sym_break_statement] = STATE(2696),
    [sym_continue_statement] = STATE(2696),
    [sym_debugger_statement] = STATE(2696),
    [sym_return_statement] = STATE(2696),
    [sym_throw_statement] = STATE(2696),
    [sym_empty_statement] = STATE(2696),
    [sym_labeled_statement] = STATE(2696),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1862),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(2592),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(2592),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(2592),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4514),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(2592),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(2592),
    [sym_abstract_class_declaration] = STATE(2592),
    [sym_module] = STATE(2592),
    [sym_internal_module] = STATE(876),
    [sym_import_alias] = STATE(2592),
    [sym_interface_declaration] = STATE(2592),
    [sym_enum_declaration] = STATE(2592),
    [sym_type_alias_declaration] = STATE(2592),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3365),
    [sym_identifier] = ACTIONS(584),
    [anon_sym_export] = ACTIONS(586),
    [anon_sym_type] = ACTIONS(588),
    [anon_sym_namespace] = ACTIONS(590),
    [anon_sym_LBRACE] = ACTIONS(592),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(594),
    [anon_sym_from] = ACTIONS(596),
    [anon_sym_var] = ACTIONS(558),
    [anon_sym_let] = ACTIONS(598),
    [anon_sym_const] = ACTIONS(600),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(602),
    [anon_sym_switch] = ACTIONS(562),
    [anon_sym_for] = ACTIONS(604),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(596),
    [anon_sym_while] = ACTIONS(606),
    [anon_sym_do] = ACTIONS(608),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_with] = ACTIONS(610),
    [anon_sym_break] = ACTIONS(612),
    [anon_sym_continue] = ACTIONS(614),
    [anon_sym_debugger] = ACTIONS(616),
    [anon_sym_return] = ACTIONS(618),
    [anon_sym_throw] = ACTIONS(620),
    [anon_sym_SEMI] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(622),
    [anon_sym_async] = ACTIONS(624),
    [anon_sym_function] = ACTIONS(626),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(596),
    [anon_sym_readonly] = ACTIONS(596),
    [anon_sym_get] = ACTIONS(596),
    [anon_sym_set] = ACTIONS(596),
    [anon_sym_declare] = ACTIONS(628),
    [anon_sym_public] = ACTIONS(596),
    [anon_sym_private] = ACTIONS(596),
    [anon_sym_protected] = ACTIONS(596),
    [anon_sym_override] = ACTIONS(596),
    [anon_sym_module] = ACTIONS(630),
    [anon_sym_any] = ACTIONS(596),
    [anon_sym_number] = ACTIONS(596),
    [anon_sym_boolean] = ACTIONS(596),
    [anon_sym_string] = ACTIONS(596),
    [anon_sym_symbol] = ACTIONS(596),
    [anon_sym_property] = ACTIONS(596),
    [anon_sym_signal] = ACTIONS(596),
    [anon_sym_on] = ACTIONS(596),
    [anon_sym_required] = ACTIONS(596),
    [anon_sym_component] = ACTIONS(596),
    [anon_sym_abstract] = ACTIONS(632),
    [anon_sym_interface] = ACTIONS(634),
    [anon_sym_enum] = ACTIONS(636),
  },
  [34] = {
    [sym_export_statement] = STATE(843),
    [sym_declaration] = STATE(843),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(843),
    [sym_expression_statement] = STATE(843),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(843),
    [sym_if_statement] = STATE(843),
    [sym_switch_statement] = STATE(843),
    [sym_for_statement] = STATE(843),
    [sym_for_in_statement] = STATE(843),
    [sym_while_statement] = STATE(843),
    [sym_do_statement] = STATE(843),
    [sym_try_statement] = STATE(843),
    [sym_with_statement] = STATE(843),
    [sym_break_statement] = STATE(843),
    [sym_continue_statement] = STATE(843),
    [sym_debugger_statement] = STATE(843),
    [sym_return_statement] = STATE(843),
    [sym_throw_statement] = STATE(843),
    [sym_empty_statement] = STATE(843),
    [sym_labeled_statement] = STATE(843),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1862),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4514),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(2191),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3374),
    [sym_identifier] = ACTIONS(546),
    [anon_sym_export] = ACTIONS(548),
    [anon_sym_type] = ACTIONS(550),
    [anon_sym_namespace] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(556),
    [anon_sym_var] = ACTIONS(558),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(560),
    [anon_sym_switch] = ACTIONS(562),
    [anon_sym_for] = ACTIONS(564),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(556),
    [anon_sym_while] = ACTIONS(566),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_with] = ACTIONS(570),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(574),
    [anon_sym_async] = ACTIONS(576),
    [anon_sym_function] = ACTIONS(578),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(556),
    [anon_sym_readonly] = ACTIONS(556),
    [anon_sym_get] = ACTIONS(556),
    [anon_sym_set] = ACTIONS(556),
    [anon_sym_declare] = ACTIONS(580),
    [anon_sym_public] = ACTIONS(556),
    [anon_sym_private] = ACTIONS(556),
    [anon_sym_protected] = ACTIONS(556),
    [anon_sym_override] = ACTIONS(556),
    [anon_sym_module] = ACTIONS(582),
    [anon_sym_any] = ACTIONS(556),
    [anon_sym_number] = ACTIONS(556),
    [anon_sym_boolean] = ACTIONS(556),
    [anon_sym_string] = ACTIONS(556),
    [anon_sym_symbol] = ACTIONS(556),
    [anon_sym_property] = ACTIONS(556),
    [anon_sym_signal] = ACTIONS(556),
    [anon_sym_on] = ACTIONS(556),
    [anon_sym_required] = ACTIONS(556),
    [anon_sym_component] = ACTIONS(556),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [35] = {
    [sym_export_statement] = STATE(788),
    [sym_declaration] = STATE(786),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(785),
    [sym_expression_statement] = STATE(705),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(784),
    [sym_if_statement] = STATE(783),
    [sym_switch_statement] = STATE(782),
    [sym_for_statement] = STATE(781),
    [sym_for_in_statement] = STATE(780),
    [sym_while_statement] = STATE(779),
    [sym_do_statement] = STATE(778),
    [sym_try_statement] = STATE(777),
    [sym_with_statement] = STATE(775),
    [sym_break_statement] = STATE(772),
    [sym_continue_statement] = STATE(770),
    [sym_debugger_statement] = STATE(768),
    [sym_return_statement] = STATE(767),
    [sym_throw_statement] = STATE(766),
    [sym_empty_statement] = STATE(765),
    [sym_labeled_statement] = STATE(763),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1862),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4514),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(2191),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3374),
    [sym_identifier] = ACTIONS(546),
    [anon_sym_export] = ACTIONS(548),
    [anon_sym_type] = ACTIONS(550),
    [anon_sym_namespace] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(556),
    [anon_sym_var] = ACTIONS(558),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(560),
    [anon_sym_switch] = ACTIONS(562),
    [anon_sym_for] = ACTIONS(564),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(556),
    [anon_sym_while] = ACTIONS(566),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_with] = ACTIONS(570),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(574),
    [anon_sym_async] = ACTIONS(576),
    [anon_sym_function] = ACTIONS(578),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(556),
    [anon_sym_readonly] = ACTIONS(556),
    [anon_sym_get] = ACTIONS(556),
    [anon_sym_set] = ACTIONS(556),
    [anon_sym_declare] = ACTIONS(580),
    [anon_sym_public] = ACTIONS(556),
    [anon_sym_private] = ACTIONS(556),
    [anon_sym_protected] = ACTIONS(556),
    [anon_sym_override] = ACTIONS(556),
    [anon_sym_module] = ACTIONS(582),
    [anon_sym_any] = ACTIONS(556),
    [anon_sym_number] = ACTIONS(556),
    [anon_sym_boolean] = ACTIONS(556),
    [anon_sym_string] = ACTIONS(556),
    [anon_sym_symbol] = ACTIONS(556),
    [anon_sym_property] = ACTIONS(556),
    [anon_sym_signal] = ACTIONS(556),
    [anon_sym_on] = ACTIONS(556),
    [anon_sym_required] = ACTIONS(556),
    [anon_sym_component] = ACTIONS(556),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [36] = {
    [sym_export_statement] = STATE(762),
    [sym_declaration] = STATE(762),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(762),
    [sym_expression_statement] = STATE(762),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(762),
    [sym_if_statement] = STATE(762),
    [sym_switch_statement] = STATE(762),
    [sym_for_statement] = STATE(762),
    [sym_for_in_statement] = STATE(762),
    [sym_while_statement] = STATE(762),
    [sym_do_statement] = STATE(762),
    [sym_try_statement] = STATE(762),
    [sym_with_statement] = STATE(762),
    [sym_break_statement] = STATE(762),
    [sym_continue_statement] = STATE(762),
    [sym_debugger_statement] = STATE(762),
    [sym_return_statement] = STATE(762),
    [sym_throw_statement] = STATE(762),
    [sym_empty_statement] = STATE(762),
    [sym_labeled_statement] = STATE(762),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1862),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4514),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(2191),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3374),
    [sym_identifier] = ACTIONS(546),
    [anon_sym_export] = ACTIONS(548),
    [anon_sym_type] = ACTIONS(550),
    [anon_sym_namespace] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(556),
    [anon_sym_var] = ACTIONS(558),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(560),
    [anon_sym_switch] = ACTIONS(562),
    [anon_sym_for] = ACTIONS(564),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(556),
    [anon_sym_while] = ACTIONS(566),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_with] = ACTIONS(570),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(574),
    [anon_sym_async] = ACTIONS(576),
    [anon_sym_function] = ACTIONS(578),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(556),
    [anon_sym_readonly] = ACTIONS(556),
    [anon_sym_get] = ACTIONS(556),
    [anon_sym_set] = ACTIONS(556),
    [anon_sym_declare] = ACTIONS(580),
    [anon_sym_public] = ACTIONS(556),
    [anon_sym_private] = ACTIONS(556),
    [anon_sym_protected] = ACTIONS(556),
    [anon_sym_override] = ACTIONS(556),
    [anon_sym_module] = ACTIONS(582),
    [anon_sym_any] = ACTIONS(556),
    [anon_sym_number] = ACTIONS(556),
    [anon_sym_boolean] = ACTIONS(556),
    [anon_sym_string] = ACTIONS(556),
    [anon_sym_symbol] = ACTIONS(556),
    [anon_sym_property] = ACTIONS(556),
    [anon_sym_signal] = ACTIONS(556),
    [anon_sym_on] = ACTIONS(556),
    [anon_sym_required] = ACTIONS(556),
    [anon_sym_component] = ACTIONS(556),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [37] = {
    [sym_export_statement] = STATE(788),
    [sym_declaration] = STATE(786),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(785),
    [sym_expression_statement] = STATE(705),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(784),
    [sym_if_statement] = STATE(783),
    [sym_switch_statement] = STATE(782),
    [sym_for_statement] = STATE(781),
    [sym_for_in_statement] = STATE(780),
    [sym_while_statement] = STATE(779),
    [sym_do_statement] = STATE(778),
    [sym_try_statement] = STATE(777),
    [sym_with_statement] = STATE(775),
    [sym_break_statement] = STATE(772),
    [sym_continue_statement] = STATE(770),
    [sym_debugger_statement] = STATE(768),
    [sym_return_statement] = STATE(767),
    [sym_throw_statement] = STATE(766),
    [sym_empty_statement] = STATE(765),
    [sym_labeled_statement] = STATE(763),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [38] = {
    [sym_export_statement] = STATE(2663),
    [sym_declaration] = STATE(2663),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(2663),
    [sym_expression_statement] = STATE(2663),
    [sym_variable_declaration] = STATE(2592),
    [sym_lexical_declaration] = STATE(2592),
    [sym_statement_block] = STATE(2663),
    [sym_if_statement] = STATE(2663),
    [sym_switch_statement] = STATE(2663),
    [sym_for_statement] = STATE(2663),
    [sym_for_in_statement] = STATE(2663),
    [sym_while_statement] = STATE(2663),
    [sym_do_statement] = STATE(2663),
    [sym_try_statement] = STATE(2663),
    [sym_with_statement] = STATE(2663),
    [sym_break_statement] = STATE(2663),
    [sym_continue_statement] = STATE(2663),
    [sym_debugger_statement] = STATE(2663),
    [sym_return_statement] = STATE(2663),
    [sym_throw_statement] = STATE(2663),
    [sym_empty_statement] = STATE(2663),
    [sym_labeled_statement] = STATE(2663),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1862),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(2592),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(2592),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(2592),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4514),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(2592),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(2592),
    [sym_abstract_class_declaration] = STATE(2592),
    [sym_module] = STATE(2592),
    [sym_internal_module] = STATE(876),
    [sym_import_alias] = STATE(2592),
    [sym_interface_declaration] = STATE(2592),
    [sym_enum_declaration] = STATE(2592),
    [sym_type_alias_declaration] = STATE(2592),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3365),
    [sym_identifier] = ACTIONS(584),
    [anon_sym_export] = ACTIONS(586),
    [anon_sym_type] = ACTIONS(588),
    [anon_sym_namespace] = ACTIONS(590),
    [anon_sym_LBRACE] = ACTIONS(592),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(594),
    [anon_sym_from] = ACTIONS(596),
    [anon_sym_var] = ACTIONS(558),
    [anon_sym_let] = ACTIONS(598),
    [anon_sym_const] = ACTIONS(600),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(602),
    [anon_sym_switch] = ACTIONS(562),
    [anon_sym_for] = ACTIONS(604),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(596),
    [anon_sym_while] = ACTIONS(606),
    [anon_sym_do] = ACTIONS(608),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_with] = ACTIONS(610),
    [anon_sym_break] = ACTIONS(612),
    [anon_sym_continue] = ACTIONS(614),
    [anon_sym_debugger] = ACTIONS(616),
    [anon_sym_return] = ACTIONS(618),
    [anon_sym_throw] = ACTIONS(620),
    [anon_sym_SEMI] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(622),
    [anon_sym_async] = ACTIONS(624),
    [anon_sym_function] = ACTIONS(626),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(596),
    [anon_sym_readonly] = ACTIONS(596),
    [anon_sym_get] = ACTIONS(596),
    [anon_sym_set] = ACTIONS(596),
    [anon_sym_declare] = ACTIONS(628),
    [anon_sym_public] = ACTIONS(596),
    [anon_sym_private] = ACTIONS(596),
    [anon_sym_protected] = ACTIONS(596),
    [anon_sym_override] = ACTIONS(596),
    [anon_sym_module] = ACTIONS(630),
    [anon_sym_any] = ACTIONS(596),
    [anon_sym_number] = ACTIONS(596),
    [anon_sym_boolean] = ACTIONS(596),
    [anon_sym_string] = ACTIONS(596),
    [anon_sym_symbol] = ACTIONS(596),
    [anon_sym_property] = ACTIONS(596),
    [anon_sym_signal] = ACTIONS(596),
    [anon_sym_on] = ACTIONS(596),
    [anon_sym_required] = ACTIONS(596),
    [anon_sym_component] = ACTIONS(596),
    [anon_sym_abstract] = ACTIONS(632),
    [anon_sym_interface] = ACTIONS(634),
    [anon_sym_enum] = ACTIONS(636),
  },
  [39] = {
    [sym_export_statement] = STATE(812),
    [sym_declaration] = STATE(812),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(812),
    [sym_expression_statement] = STATE(812),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(812),
    [sym_if_statement] = STATE(812),
    [sym_switch_statement] = STATE(812),
    [sym_for_statement] = STATE(812),
    [sym_for_in_statement] = STATE(812),
    [sym_while_statement] = STATE(812),
    [sym_do_statement] = STATE(812),
    [sym_try_statement] = STATE(812),
    [sym_with_statement] = STATE(812),
    [sym_break_statement] = STATE(812),
    [sym_continue_statement] = STATE(812),
    [sym_debugger_statement] = STATE(812),
    [sym_return_statement] = STATE(812),
    [sym_throw_statement] = STATE(812),
    [sym_empty_statement] = STATE(812),
    [sym_labeled_statement] = STATE(812),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [40] = {
    [sym_export_statement] = STATE(2599),
    [sym_declaration] = STATE(2600),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(2601),
    [sym_expression_statement] = STATE(2603),
    [sym_variable_declaration] = STATE(2592),
    [sym_lexical_declaration] = STATE(2592),
    [sym_statement_block] = STATE(2604),
    [sym_if_statement] = STATE(2639),
    [sym_switch_statement] = STATE(2607),
    [sym_for_statement] = STATE(2608),
    [sym_for_in_statement] = STATE(2609),
    [sym_while_statement] = STATE(2610),
    [sym_do_statement] = STATE(2614),
    [sym_try_statement] = STATE(2615),
    [sym_with_statement] = STATE(2617),
    [sym_break_statement] = STATE(2618),
    [sym_continue_statement] = STATE(2620),
    [sym_debugger_statement] = STATE(2621),
    [sym_return_statement] = STATE(2622),
    [sym_throw_statement] = STATE(2623),
    [sym_empty_statement] = STATE(2624),
    [sym_labeled_statement] = STATE(2662),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1862),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(2592),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(2592),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(2592),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4514),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(2592),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(2592),
    [sym_abstract_class_declaration] = STATE(2592),
    [sym_module] = STATE(2592),
    [sym_internal_module] = STATE(876),
    [sym_import_alias] = STATE(2592),
    [sym_interface_declaration] = STATE(2592),
    [sym_enum_declaration] = STATE(2592),
    [sym_type_alias_declaration] = STATE(2592),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3365),
    [sym_identifier] = ACTIONS(584),
    [anon_sym_export] = ACTIONS(586),
    [anon_sym_type] = ACTIONS(588),
    [anon_sym_namespace] = ACTIONS(590),
    [anon_sym_LBRACE] = ACTIONS(592),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(594),
    [anon_sym_from] = ACTIONS(596),
    [anon_sym_var] = ACTIONS(558),
    [anon_sym_let] = ACTIONS(598),
    [anon_sym_const] = ACTIONS(600),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(602),
    [anon_sym_switch] = ACTIONS(562),
    [anon_sym_for] = ACTIONS(604),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(596),
    [anon_sym_while] = ACTIONS(606),
    [anon_sym_do] = ACTIONS(608),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_with] = ACTIONS(610),
    [anon_sym_break] = ACTIONS(612),
    [anon_sym_continue] = ACTIONS(614),
    [anon_sym_debugger] = ACTIONS(616),
    [anon_sym_return] = ACTIONS(618),
    [anon_sym_throw] = ACTIONS(620),
    [anon_sym_SEMI] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(622),
    [anon_sym_async] = ACTIONS(624),
    [anon_sym_function] = ACTIONS(626),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(596),
    [anon_sym_readonly] = ACTIONS(596),
    [anon_sym_get] = ACTIONS(596),
    [anon_sym_set] = ACTIONS(596),
    [anon_sym_declare] = ACTIONS(628),
    [anon_sym_public] = ACTIONS(596),
    [anon_sym_private] = ACTIONS(596),
    [anon_sym_protected] = ACTIONS(596),
    [anon_sym_override] = ACTIONS(596),
    [anon_sym_module] = ACTIONS(630),
    [anon_sym_any] = ACTIONS(596),
    [anon_sym_number] = ACTIONS(596),
    [anon_sym_boolean] = ACTIONS(596),
    [anon_sym_string] = ACTIONS(596),
    [anon_sym_symbol] = ACTIONS(596),
    [anon_sym_property] = ACTIONS(596),
    [anon_sym_signal] = ACTIONS(596),
    [anon_sym_on] = ACTIONS(596),
    [anon_sym_required] = ACTIONS(596),
    [anon_sym_component] = ACTIONS(596),
    [anon_sym_abstract] = ACTIONS(632),
    [anon_sym_interface] = ACTIONS(634),
    [anon_sym_enum] = ACTIONS(636),
  },
  [41] = {
    [sym_export_statement] = STATE(762),
    [sym_declaration] = STATE(762),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(762),
    [sym_expression_statement] = STATE(762),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(762),
    [sym_if_statement] = STATE(762),
    [sym_switch_statement] = STATE(762),
    [sym_for_statement] = STATE(762),
    [sym_for_in_statement] = STATE(762),
    [sym_while_statement] = STATE(762),
    [sym_do_statement] = STATE(762),
    [sym_try_statement] = STATE(762),
    [sym_with_statement] = STATE(762),
    [sym_break_statement] = STATE(762),
    [sym_continue_statement] = STATE(762),
    [sym_debugger_statement] = STATE(762),
    [sym_return_statement] = STATE(762),
    [sym_throw_statement] = STATE(762),
    [sym_empty_statement] = STATE(762),
    [sym_labeled_statement] = STATE(762),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [42] = {
    [sym_export_statement] = STATE(682),
    [sym_declaration] = STATE(682),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(682),
    [sym_expression_statement] = STATE(682),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(682),
    [sym_if_statement] = STATE(682),
    [sym_switch_statement] = STATE(682),
    [sym_for_statement] = STATE(682),
    [sym_for_in_statement] = STATE(682),
    [sym_while_statement] = STATE(682),
    [sym_do_statement] = STATE(682),
    [sym_try_statement] = STATE(682),
    [sym_with_statement] = STATE(682),
    [sym_break_statement] = STATE(682),
    [sym_continue_statement] = STATE(682),
    [sym_debugger_statement] = STATE(682),
    [sym_return_statement] = STATE(682),
    [sym_throw_statement] = STATE(682),
    [sym_empty_statement] = STATE(682),
    [sym_labeled_statement] = STATE(682),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [43] = {
    [sym_export_statement] = STATE(711),
    [sym_declaration] = STATE(711),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(711),
    [sym_expression_statement] = STATE(711),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(711),
    [sym_if_statement] = STATE(711),
    [sym_switch_statement] = STATE(711),
    [sym_for_statement] = STATE(711),
    [sym_for_in_statement] = STATE(711),
    [sym_while_statement] = STATE(711),
    [sym_do_statement] = STATE(711),
    [sym_try_statement] = STATE(711),
    [sym_with_statement] = STATE(711),
    [sym_break_statement] = STATE(711),
    [sym_continue_statement] = STATE(711),
    [sym_debugger_statement] = STATE(711),
    [sym_return_statement] = STATE(711),
    [sym_throw_statement] = STATE(711),
    [sym_empty_statement] = STATE(711),
    [sym_labeled_statement] = STATE(711),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [44] = {
    [sym_export_statement] = STATE(2558),
    [sym_declaration] = STATE(2558),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(2558),
    [sym_expression_statement] = STATE(2558),
    [sym_variable_declaration] = STATE(2592),
    [sym_lexical_declaration] = STATE(2592),
    [sym_statement_block] = STATE(2558),
    [sym_if_statement] = STATE(2558),
    [sym_switch_statement] = STATE(2558),
    [sym_for_statement] = STATE(2558),
    [sym_for_in_statement] = STATE(2558),
    [sym_while_statement] = STATE(2558),
    [sym_do_statement] = STATE(2558),
    [sym_try_statement] = STATE(2558),
    [sym_with_statement] = STATE(2558),
    [sym_break_statement] = STATE(2558),
    [sym_continue_statement] = STATE(2558),
    [sym_debugger_statement] = STATE(2558),
    [sym_return_statement] = STATE(2558),
    [sym_throw_statement] = STATE(2558),
    [sym_empty_statement] = STATE(2558),
    [sym_labeled_statement] = STATE(2558),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1862),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(2592),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(2592),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(2592),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4514),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(2592),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(2592),
    [sym_abstract_class_declaration] = STATE(2592),
    [sym_module] = STATE(2592),
    [sym_internal_module] = STATE(876),
    [sym_import_alias] = STATE(2592),
    [sym_interface_declaration] = STATE(2592),
    [sym_enum_declaration] = STATE(2592),
    [sym_type_alias_declaration] = STATE(2592),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3365),
    [sym_identifier] = ACTIONS(584),
    [anon_sym_export] = ACTIONS(586),
    [anon_sym_type] = ACTIONS(588),
    [anon_sym_namespace] = ACTIONS(590),
    [anon_sym_LBRACE] = ACTIONS(592),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(594),
    [anon_sym_from] = ACTIONS(596),
    [anon_sym_var] = ACTIONS(558),
    [anon_sym_let] = ACTIONS(598),
    [anon_sym_const] = ACTIONS(600),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(602),
    [anon_sym_switch] = ACTIONS(562),
    [anon_sym_for] = ACTIONS(604),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(596),
    [anon_sym_while] = ACTIONS(606),
    [anon_sym_do] = ACTIONS(608),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_with] = ACTIONS(610),
    [anon_sym_break] = ACTIONS(612),
    [anon_sym_continue] = ACTIONS(614),
    [anon_sym_debugger] = ACTIONS(616),
    [anon_sym_return] = ACTIONS(618),
    [anon_sym_throw] = ACTIONS(620),
    [anon_sym_SEMI] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(622),
    [anon_sym_async] = ACTIONS(624),
    [anon_sym_function] = ACTIONS(626),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(596),
    [anon_sym_readonly] = ACTIONS(596),
    [anon_sym_get] = ACTIONS(596),
    [anon_sym_set] = ACTIONS(596),
    [anon_sym_declare] = ACTIONS(628),
    [anon_sym_public] = ACTIONS(596),
    [anon_sym_private] = ACTIONS(596),
    [anon_sym_protected] = ACTIONS(596),
    [anon_sym_override] = ACTIONS(596),
    [anon_sym_module] = ACTIONS(630),
    [anon_sym_any] = ACTIONS(596),
    [anon_sym_number] = ACTIONS(596),
    [anon_sym_boolean] = ACTIONS(596),
    [anon_sym_string] = ACTIONS(596),
    [anon_sym_symbol] = ACTIONS(596),
    [anon_sym_property] = ACTIONS(596),
    [anon_sym_signal] = ACTIONS(596),
    [anon_sym_on] = ACTIONS(596),
    [anon_sym_required] = ACTIONS(596),
    [anon_sym_component] = ACTIONS(596),
    [anon_sym_abstract] = ACTIONS(632),
    [anon_sym_interface] = ACTIONS(634),
    [anon_sym_enum] = ACTIONS(636),
  },
  [45] = {
    [sym_export_statement] = STATE(2529),
    [sym_declaration] = STATE(2529),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(2529),
    [sym_expression_statement] = STATE(2529),
    [sym_variable_declaration] = STATE(2592),
    [sym_lexical_declaration] = STATE(2592),
    [sym_statement_block] = STATE(2529),
    [sym_if_statement] = STATE(2529),
    [sym_switch_statement] = STATE(2529),
    [sym_for_statement] = STATE(2529),
    [sym_for_in_statement] = STATE(2529),
    [sym_while_statement] = STATE(2529),
    [sym_do_statement] = STATE(2529),
    [sym_try_statement] = STATE(2529),
    [sym_with_statement] = STATE(2529),
    [sym_break_statement] = STATE(2529),
    [sym_continue_statement] = STATE(2529),
    [sym_debugger_statement] = STATE(2529),
    [sym_return_statement] = STATE(2529),
    [sym_throw_statement] = STATE(2529),
    [sym_empty_statement] = STATE(2529),
    [sym_labeled_statement] = STATE(2529),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1862),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(2592),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(2592),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(2592),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4514),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(2592),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(2592),
    [sym_abstract_class_declaration] = STATE(2592),
    [sym_module] = STATE(2592),
    [sym_internal_module] = STATE(876),
    [sym_import_alias] = STATE(2592),
    [sym_interface_declaration] = STATE(2592),
    [sym_enum_declaration] = STATE(2592),
    [sym_type_alias_declaration] = STATE(2592),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3365),
    [sym_identifier] = ACTIONS(584),
    [anon_sym_export] = ACTIONS(586),
    [anon_sym_type] = ACTIONS(588),
    [anon_sym_namespace] = ACTIONS(590),
    [anon_sym_LBRACE] = ACTIONS(592),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(594),
    [anon_sym_from] = ACTIONS(596),
    [anon_sym_var] = ACTIONS(558),
    [anon_sym_let] = ACTIONS(598),
    [anon_sym_const] = ACTIONS(600),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(602),
    [anon_sym_switch] = ACTIONS(562),
    [anon_sym_for] = ACTIONS(604),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(596),
    [anon_sym_while] = ACTIONS(606),
    [anon_sym_do] = ACTIONS(608),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_with] = ACTIONS(610),
    [anon_sym_break] = ACTIONS(612),
    [anon_sym_continue] = ACTIONS(614),
    [anon_sym_debugger] = ACTIONS(616),
    [anon_sym_return] = ACTIONS(618),
    [anon_sym_throw] = ACTIONS(620),
    [anon_sym_SEMI] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(622),
    [anon_sym_async] = ACTIONS(624),
    [anon_sym_function] = ACTIONS(626),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(596),
    [anon_sym_readonly] = ACTIONS(596),
    [anon_sym_get] = ACTIONS(596),
    [anon_sym_set] = ACTIONS(596),
    [anon_sym_declare] = ACTIONS(628),
    [anon_sym_public] = ACTIONS(596),
    [anon_sym_private] = ACTIONS(596),
    [anon_sym_protected] = ACTIONS(596),
    [anon_sym_override] = ACTIONS(596),
    [anon_sym_module] = ACTIONS(630),
    [anon_sym_any] = ACTIONS(596),
    [anon_sym_number] = ACTIONS(596),
    [anon_sym_boolean] = ACTIONS(596),
    [anon_sym_string] = ACTIONS(596),
    [anon_sym_symbol] = ACTIONS(596),
    [anon_sym_property] = ACTIONS(596),
    [anon_sym_signal] = ACTIONS(596),
    [anon_sym_on] = ACTIONS(596),
    [anon_sym_required] = ACTIONS(596),
    [anon_sym_component] = ACTIONS(596),
    [anon_sym_abstract] = ACTIONS(632),
    [anon_sym_interface] = ACTIONS(634),
    [anon_sym_enum] = ACTIONS(636),
  },
  [46] = {
    [sym_export_statement] = STATE(843),
    [sym_declaration] = STATE(843),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(843),
    [sym_expression_statement] = STATE(843),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(843),
    [sym_if_statement] = STATE(843),
    [sym_switch_statement] = STATE(843),
    [sym_for_statement] = STATE(843),
    [sym_for_in_statement] = STATE(843),
    [sym_while_statement] = STATE(843),
    [sym_do_statement] = STATE(843),
    [sym_try_statement] = STATE(843),
    [sym_with_statement] = STATE(843),
    [sym_break_statement] = STATE(843),
    [sym_continue_statement] = STATE(843),
    [sym_debugger_statement] = STATE(843),
    [sym_return_statement] = STATE(843),
    [sym_throw_statement] = STATE(843),
    [sym_empty_statement] = STATE(843),
    [sym_labeled_statement] = STATE(843),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [47] = {
    [sym_export_statement] = STATE(755),
    [sym_declaration] = STATE(755),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(755),
    [sym_expression_statement] = STATE(755),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(755),
    [sym_if_statement] = STATE(755),
    [sym_switch_statement] = STATE(755),
    [sym_for_statement] = STATE(755),
    [sym_for_in_statement] = STATE(755),
    [sym_while_statement] = STATE(755),
    [sym_do_statement] = STATE(755),
    [sym_try_statement] = STATE(755),
    [sym_with_statement] = STATE(755),
    [sym_break_statement] = STATE(755),
    [sym_continue_statement] = STATE(755),
    [sym_debugger_statement] = STATE(755),
    [sym_return_statement] = STATE(755),
    [sym_throw_statement] = STATE(755),
    [sym_empty_statement] = STATE(755),
    [sym_labeled_statement] = STATE(755),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [48] = {
    [sym_export_statement] = STATE(2558),
    [sym_declaration] = STATE(2558),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(2558),
    [sym_expression_statement] = STATE(2558),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(2558),
    [sym_if_statement] = STATE(2558),
    [sym_switch_statement] = STATE(2558),
    [sym_for_statement] = STATE(2558),
    [sym_for_in_statement] = STATE(2558),
    [sym_while_statement] = STATE(2558),
    [sym_do_statement] = STATE(2558),
    [sym_try_statement] = STATE(2558),
    [sym_with_statement] = STATE(2558),
    [sym_break_statement] = STATE(2558),
    [sym_continue_statement] = STATE(2558),
    [sym_debugger_statement] = STATE(2558),
    [sym_return_statement] = STATE(2558),
    [sym_throw_statement] = STATE(2558),
    [sym_empty_statement] = STATE(2558),
    [sym_labeled_statement] = STATE(2558),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1862),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4514),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(2191),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3374),
    [sym_identifier] = ACTIONS(546),
    [anon_sym_export] = ACTIONS(548),
    [anon_sym_type] = ACTIONS(550),
    [anon_sym_namespace] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(556),
    [anon_sym_var] = ACTIONS(558),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(560),
    [anon_sym_switch] = ACTIONS(562),
    [anon_sym_for] = ACTIONS(564),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(556),
    [anon_sym_while] = ACTIONS(566),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_with] = ACTIONS(570),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(574),
    [anon_sym_async] = ACTIONS(576),
    [anon_sym_function] = ACTIONS(578),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(556),
    [anon_sym_readonly] = ACTIONS(556),
    [anon_sym_get] = ACTIONS(556),
    [anon_sym_set] = ACTIONS(556),
    [anon_sym_declare] = ACTIONS(580),
    [anon_sym_public] = ACTIONS(556),
    [anon_sym_private] = ACTIONS(556),
    [anon_sym_protected] = ACTIONS(556),
    [anon_sym_override] = ACTIONS(556),
    [anon_sym_module] = ACTIONS(582),
    [anon_sym_any] = ACTIONS(556),
    [anon_sym_number] = ACTIONS(556),
    [anon_sym_boolean] = ACTIONS(556),
    [anon_sym_string] = ACTIONS(556),
    [anon_sym_symbol] = ACTIONS(556),
    [anon_sym_property] = ACTIONS(556),
    [anon_sym_signal] = ACTIONS(556),
    [anon_sym_on] = ACTIONS(556),
    [anon_sym_required] = ACTIONS(556),
    [anon_sym_component] = ACTIONS(556),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [49] = {
    [sym_export_statement] = STATE(711),
    [sym_declaration] = STATE(711),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(711),
    [sym_expression_statement] = STATE(711),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(711),
    [sym_if_statement] = STATE(711),
    [sym_switch_statement] = STATE(711),
    [sym_for_statement] = STATE(711),
    [sym_for_in_statement] = STATE(711),
    [sym_while_statement] = STATE(711),
    [sym_do_statement] = STATE(711),
    [sym_try_statement] = STATE(711),
    [sym_with_statement] = STATE(711),
    [sym_break_statement] = STATE(711),
    [sym_continue_statement] = STATE(711),
    [sym_debugger_statement] = STATE(711),
    [sym_return_statement] = STATE(711),
    [sym_throw_statement] = STATE(711),
    [sym_empty_statement] = STATE(711),
    [sym_labeled_statement] = STATE(711),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1862),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4514),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(2191),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3374),
    [sym_identifier] = ACTIONS(546),
    [anon_sym_export] = ACTIONS(548),
    [anon_sym_type] = ACTIONS(550),
    [anon_sym_namespace] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(556),
    [anon_sym_var] = ACTIONS(558),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(560),
    [anon_sym_switch] = ACTIONS(562),
    [anon_sym_for] = ACTIONS(564),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(556),
    [anon_sym_while] = ACTIONS(566),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_with] = ACTIONS(570),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(574),
    [anon_sym_async] = ACTIONS(576),
    [anon_sym_function] = ACTIONS(578),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(556),
    [anon_sym_readonly] = ACTIONS(556),
    [anon_sym_get] = ACTIONS(556),
    [anon_sym_set] = ACTIONS(556),
    [anon_sym_declare] = ACTIONS(580),
    [anon_sym_public] = ACTIONS(556),
    [anon_sym_private] = ACTIONS(556),
    [anon_sym_protected] = ACTIONS(556),
    [anon_sym_override] = ACTIONS(556),
    [anon_sym_module] = ACTIONS(582),
    [anon_sym_any] = ACTIONS(556),
    [anon_sym_number] = ACTIONS(556),
    [anon_sym_boolean] = ACTIONS(556),
    [anon_sym_string] = ACTIONS(556),
    [anon_sym_symbol] = ACTIONS(556),
    [anon_sym_property] = ACTIONS(556),
    [anon_sym_signal] = ACTIONS(556),
    [anon_sym_on] = ACTIONS(556),
    [anon_sym_required] = ACTIONS(556),
    [anon_sym_component] = ACTIONS(556),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [50] = {
    [sym_export_statement] = STATE(2677),
    [sym_declaration] = STATE(2673),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(2672),
    [sym_expression_statement] = STATE(2670),
    [sym_variable_declaration] = STATE(2592),
    [sym_lexical_declaration] = STATE(2592),
    [sym_statement_block] = STATE(2669),
    [sym_if_statement] = STATE(2667),
    [sym_switch_statement] = STATE(2666),
    [sym_for_statement] = STATE(2664),
    [sym_for_in_statement] = STATE(2626),
    [sym_while_statement] = STATE(2661),
    [sym_do_statement] = STATE(2656),
    [sym_try_statement] = STATE(2655),
    [sym_with_statement] = STATE(2654),
    [sym_break_statement] = STATE(2653),
    [sym_continue_statement] = STATE(2652),
    [sym_debugger_statement] = STATE(2648),
    [sym_return_statement] = STATE(2641),
    [sym_throw_statement] = STATE(2638),
    [sym_empty_statement] = STATE(2637),
    [sym_labeled_statement] = STATE(2567),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1862),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(2592),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(2592),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(2592),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4514),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(2592),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(2592),
    [sym_abstract_class_declaration] = STATE(2592),
    [sym_module] = STATE(2592),
    [sym_internal_module] = STATE(876),
    [sym_import_alias] = STATE(2592),
    [sym_interface_declaration] = STATE(2592),
    [sym_enum_declaration] = STATE(2592),
    [sym_type_alias_declaration] = STATE(2592),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3365),
    [sym_identifier] = ACTIONS(584),
    [anon_sym_export] = ACTIONS(586),
    [anon_sym_type] = ACTIONS(588),
    [anon_sym_namespace] = ACTIONS(590),
    [anon_sym_LBRACE] = ACTIONS(592),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(594),
    [anon_sym_from] = ACTIONS(596),
    [anon_sym_var] = ACTIONS(558),
    [anon_sym_let] = ACTIONS(598),
    [anon_sym_const] = ACTIONS(600),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(602),
    [anon_sym_switch] = ACTIONS(562),
    [anon_sym_for] = ACTIONS(604),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(596),
    [anon_sym_while] = ACTIONS(606),
    [anon_sym_do] = ACTIONS(608),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_with] = ACTIONS(610),
    [anon_sym_break] = ACTIONS(612),
    [anon_sym_continue] = ACTIONS(614),
    [anon_sym_debugger] = ACTIONS(616),
    [anon_sym_return] = ACTIONS(618),
    [anon_sym_throw] = ACTIONS(620),
    [anon_sym_SEMI] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(622),
    [anon_sym_async] = ACTIONS(624),
    [anon_sym_function] = ACTIONS(626),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(596),
    [anon_sym_readonly] = ACTIONS(596),
    [anon_sym_get] = ACTIONS(596),
    [anon_sym_set] = ACTIONS(596),
    [anon_sym_declare] = ACTIONS(628),
    [anon_sym_public] = ACTIONS(596),
    [anon_sym_private] = ACTIONS(596),
    [anon_sym_protected] = ACTIONS(596),
    [anon_sym_override] = ACTIONS(596),
    [anon_sym_module] = ACTIONS(630),
    [anon_sym_any] = ACTIONS(596),
    [anon_sym_number] = ACTIONS(596),
    [anon_sym_boolean] = ACTIONS(596),
    [anon_sym_string] = ACTIONS(596),
    [anon_sym_symbol] = ACTIONS(596),
    [anon_sym_property] = ACTIONS(596),
    [anon_sym_signal] = ACTIONS(596),
    [anon_sym_on] = ACTIONS(596),
    [anon_sym_required] = ACTIONS(596),
    [anon_sym_component] = ACTIONS(596),
    [anon_sym_abstract] = ACTIONS(632),
    [anon_sym_interface] = ACTIONS(634),
    [anon_sym_enum] = ACTIONS(636),
  },
  [51] = {
    [sym_export_statement] = STATE(2594),
    [sym_declaration] = STATE(2594),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(2594),
    [sym_expression_statement] = STATE(2594),
    [sym_variable_declaration] = STATE(2592),
    [sym_lexical_declaration] = STATE(2592),
    [sym_statement_block] = STATE(2594),
    [sym_if_statement] = STATE(2594),
    [sym_switch_statement] = STATE(2594),
    [sym_for_statement] = STATE(2594),
    [sym_for_in_statement] = STATE(2594),
    [sym_while_statement] = STATE(2594),
    [sym_do_statement] = STATE(2594),
    [sym_try_statement] = STATE(2594),
    [sym_with_statement] = STATE(2594),
    [sym_break_statement] = STATE(2594),
    [sym_continue_statement] = STATE(2594),
    [sym_debugger_statement] = STATE(2594),
    [sym_return_statement] = STATE(2594),
    [sym_throw_statement] = STATE(2594),
    [sym_empty_statement] = STATE(2594),
    [sym_labeled_statement] = STATE(2594),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1862),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(2592),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(2592),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(2592),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4514),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(2592),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(2592),
    [sym_abstract_class_declaration] = STATE(2592),
    [sym_module] = STATE(2592),
    [sym_internal_module] = STATE(876),
    [sym_import_alias] = STATE(2592),
    [sym_interface_declaration] = STATE(2592),
    [sym_enum_declaration] = STATE(2592),
    [sym_type_alias_declaration] = STATE(2592),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3365),
    [sym_identifier] = ACTIONS(584),
    [anon_sym_export] = ACTIONS(586),
    [anon_sym_type] = ACTIONS(588),
    [anon_sym_namespace] = ACTIONS(590),
    [anon_sym_LBRACE] = ACTIONS(592),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(594),
    [anon_sym_from] = ACTIONS(596),
    [anon_sym_var] = ACTIONS(558),
    [anon_sym_let] = ACTIONS(598),
    [anon_sym_const] = ACTIONS(600),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(602),
    [anon_sym_switch] = ACTIONS(562),
    [anon_sym_for] = ACTIONS(604),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(596),
    [anon_sym_while] = ACTIONS(606),
    [anon_sym_do] = ACTIONS(608),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_with] = ACTIONS(610),
    [anon_sym_break] = ACTIONS(612),
    [anon_sym_continue] = ACTIONS(614),
    [anon_sym_debugger] = ACTIONS(616),
    [anon_sym_return] = ACTIONS(618),
    [anon_sym_throw] = ACTIONS(620),
    [anon_sym_SEMI] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(622),
    [anon_sym_async] = ACTIONS(624),
    [anon_sym_function] = ACTIONS(626),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(596),
    [anon_sym_readonly] = ACTIONS(596),
    [anon_sym_get] = ACTIONS(596),
    [anon_sym_set] = ACTIONS(596),
    [anon_sym_declare] = ACTIONS(628),
    [anon_sym_public] = ACTIONS(596),
    [anon_sym_private] = ACTIONS(596),
    [anon_sym_protected] = ACTIONS(596),
    [anon_sym_override] = ACTIONS(596),
    [anon_sym_module] = ACTIONS(630),
    [anon_sym_any] = ACTIONS(596),
    [anon_sym_number] = ACTIONS(596),
    [anon_sym_boolean] = ACTIONS(596),
    [anon_sym_string] = ACTIONS(596),
    [anon_sym_symbol] = ACTIONS(596),
    [anon_sym_property] = ACTIONS(596),
    [anon_sym_signal] = ACTIONS(596),
    [anon_sym_on] = ACTIONS(596),
    [anon_sym_required] = ACTIONS(596),
    [anon_sym_component] = ACTIONS(596),
    [anon_sym_abstract] = ACTIONS(632),
    [anon_sym_interface] = ACTIONS(634),
    [anon_sym_enum] = ACTIONS(636),
  },
  [52] = {
    [sym_export_statement] = STATE(716),
    [sym_declaration] = STATE(716),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(716),
    [sym_expression_statement] = STATE(716),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(716),
    [sym_if_statement] = STATE(716),
    [sym_switch_statement] = STATE(716),
    [sym_for_statement] = STATE(716),
    [sym_for_in_statement] = STATE(716),
    [sym_while_statement] = STATE(716),
    [sym_do_statement] = STATE(716),
    [sym_try_statement] = STATE(716),
    [sym_with_statement] = STATE(716),
    [sym_break_statement] = STATE(716),
    [sym_continue_statement] = STATE(716),
    [sym_debugger_statement] = STATE(716),
    [sym_return_statement] = STATE(716),
    [sym_throw_statement] = STATE(716),
    [sym_empty_statement] = STATE(716),
    [sym_labeled_statement] = STATE(716),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [53] = {
    [sym_export_statement] = STATE(755),
    [sym_declaration] = STATE(755),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(755),
    [sym_expression_statement] = STATE(755),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(755),
    [sym_if_statement] = STATE(755),
    [sym_switch_statement] = STATE(755),
    [sym_for_statement] = STATE(755),
    [sym_for_in_statement] = STATE(755),
    [sym_while_statement] = STATE(755),
    [sym_do_statement] = STATE(755),
    [sym_try_statement] = STATE(755),
    [sym_with_statement] = STATE(755),
    [sym_break_statement] = STATE(755),
    [sym_continue_statement] = STATE(755),
    [sym_debugger_statement] = STATE(755),
    [sym_return_statement] = STATE(755),
    [sym_throw_statement] = STATE(755),
    [sym_empty_statement] = STATE(755),
    [sym_labeled_statement] = STATE(755),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1862),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4514),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(2191),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3374),
    [sym_identifier] = ACTIONS(546),
    [anon_sym_export] = ACTIONS(548),
    [anon_sym_type] = ACTIONS(550),
    [anon_sym_namespace] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(556),
    [anon_sym_var] = ACTIONS(558),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(560),
    [anon_sym_switch] = ACTIONS(562),
    [anon_sym_for] = ACTIONS(564),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(556),
    [anon_sym_while] = ACTIONS(566),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_with] = ACTIONS(570),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(574),
    [anon_sym_async] = ACTIONS(576),
    [anon_sym_function] = ACTIONS(578),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(556),
    [anon_sym_readonly] = ACTIONS(556),
    [anon_sym_get] = ACTIONS(556),
    [anon_sym_set] = ACTIONS(556),
    [anon_sym_declare] = ACTIONS(580),
    [anon_sym_public] = ACTIONS(556),
    [anon_sym_private] = ACTIONS(556),
    [anon_sym_protected] = ACTIONS(556),
    [anon_sym_override] = ACTIONS(556),
    [anon_sym_module] = ACTIONS(582),
    [anon_sym_any] = ACTIONS(556),
    [anon_sym_number] = ACTIONS(556),
    [anon_sym_boolean] = ACTIONS(556),
    [anon_sym_string] = ACTIONS(556),
    [anon_sym_symbol] = ACTIONS(556),
    [anon_sym_property] = ACTIONS(556),
    [anon_sym_signal] = ACTIONS(556),
    [anon_sym_on] = ACTIONS(556),
    [anon_sym_required] = ACTIONS(556),
    [anon_sym_component] = ACTIONS(556),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [54] = {
    [sym_export_statement] = STATE(827),
    [sym_declaration] = STATE(828),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(829),
    [sym_expression_statement] = STATE(831),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(832),
    [sym_if_statement] = STATE(833),
    [sym_switch_statement] = STATE(838),
    [sym_for_statement] = STATE(841),
    [sym_for_in_statement] = STATE(846),
    [sym_while_statement] = STATE(847),
    [sym_do_statement] = STATE(848),
    [sym_try_statement] = STATE(850),
    [sym_with_statement] = STATE(849),
    [sym_break_statement] = STATE(842),
    [sym_continue_statement] = STATE(836),
    [sym_debugger_statement] = STATE(834),
    [sym_return_statement] = STATE(830),
    [sym_throw_statement] = STATE(824),
    [sym_empty_statement] = STATE(823),
    [sym_labeled_statement] = STATE(821),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1825),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4376),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(168),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3427),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(151),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(173),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [55] = {
    [sym_export_statement] = STATE(4132),
    [sym_declaration] = STATE(4132),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(4132),
    [sym_expression_statement] = STATE(4132),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(4132),
    [sym_if_statement] = STATE(4132),
    [sym_switch_statement] = STATE(4132),
    [sym_for_statement] = STATE(4132),
    [sym_for_in_statement] = STATE(4132),
    [sym_while_statement] = STATE(4132),
    [sym_do_statement] = STATE(4132),
    [sym_try_statement] = STATE(4132),
    [sym_with_statement] = STATE(4132),
    [sym_break_statement] = STATE(4132),
    [sym_continue_statement] = STATE(4132),
    [sym_debugger_statement] = STATE(4132),
    [sym_return_statement] = STATE(4132),
    [sym_throw_statement] = STATE(4132),
    [sym_empty_statement] = STATE(4132),
    [sym_labeled_statement] = STATE(4132),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1862),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4514),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(2191),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3374),
    [sym_identifier] = ACTIONS(546),
    [anon_sym_export] = ACTIONS(548),
    [anon_sym_type] = ACTIONS(550),
    [anon_sym_namespace] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(556),
    [anon_sym_var] = ACTIONS(558),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(560),
    [anon_sym_switch] = ACTIONS(562),
    [anon_sym_for] = ACTIONS(564),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(556),
    [anon_sym_while] = ACTIONS(566),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_with] = ACTIONS(570),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(574),
    [anon_sym_async] = ACTIONS(576),
    [anon_sym_function] = ACTIONS(578),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(556),
    [anon_sym_readonly] = ACTIONS(556),
    [anon_sym_get] = ACTIONS(556),
    [anon_sym_set] = ACTIONS(556),
    [anon_sym_declare] = ACTIONS(580),
    [anon_sym_public] = ACTIONS(556),
    [anon_sym_private] = ACTIONS(556),
    [anon_sym_protected] = ACTIONS(556),
    [anon_sym_override] = ACTIONS(556),
    [anon_sym_module] = ACTIONS(582),
    [anon_sym_any] = ACTIONS(556),
    [anon_sym_number] = ACTIONS(556),
    [anon_sym_boolean] = ACTIONS(556),
    [anon_sym_string] = ACTIONS(556),
    [anon_sym_symbol] = ACTIONS(556),
    [anon_sym_property] = ACTIONS(556),
    [anon_sym_signal] = ACTIONS(556),
    [anon_sym_on] = ACTIONS(556),
    [anon_sym_required] = ACTIONS(556),
    [anon_sym_component] = ACTIONS(556),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [56] = {
    [sym_export_statement] = STATE(4799),
    [sym_declaration] = STATE(4799),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(4799),
    [sym_expression_statement] = STATE(4799),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(4799),
    [sym_if_statement] = STATE(4799),
    [sym_switch_statement] = STATE(4799),
    [sym_for_statement] = STATE(4799),
    [sym_for_in_statement] = STATE(4799),
    [sym_while_statement] = STATE(4799),
    [sym_do_statement] = STATE(4799),
    [sym_try_statement] = STATE(4799),
    [sym_with_statement] = STATE(4799),
    [sym_break_statement] = STATE(4799),
    [sym_continue_statement] = STATE(4799),
    [sym_debugger_statement] = STATE(4799),
    [sym_return_statement] = STATE(4799),
    [sym_throw_statement] = STATE(4799),
    [sym_empty_statement] = STATE(4799),
    [sym_labeled_statement] = STATE(4799),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1862),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4514),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(2191),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3374),
    [sym_identifier] = ACTIONS(546),
    [anon_sym_export] = ACTIONS(548),
    [anon_sym_type] = ACTIONS(550),
    [anon_sym_namespace] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(556),
    [anon_sym_var] = ACTIONS(558),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(560),
    [anon_sym_switch] = ACTIONS(562),
    [anon_sym_for] = ACTIONS(564),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(556),
    [anon_sym_while] = ACTIONS(566),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_with] = ACTIONS(570),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(574),
    [anon_sym_async] = ACTIONS(576),
    [anon_sym_function] = ACTIONS(578),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(556),
    [anon_sym_readonly] = ACTIONS(556),
    [anon_sym_get] = ACTIONS(556),
    [anon_sym_set] = ACTIONS(556),
    [anon_sym_declare] = ACTIONS(580),
    [anon_sym_public] = ACTIONS(556),
    [anon_sym_private] = ACTIONS(556),
    [anon_sym_protected] = ACTIONS(556),
    [anon_sym_override] = ACTIONS(556),
    [anon_sym_module] = ACTIONS(582),
    [anon_sym_any] = ACTIONS(556),
    [anon_sym_number] = ACTIONS(556),
    [anon_sym_boolean] = ACTIONS(556),
    [anon_sym_string] = ACTIONS(556),
    [anon_sym_symbol] = ACTIONS(556),
    [anon_sym_property] = ACTIONS(556),
    [anon_sym_signal] = ACTIONS(556),
    [anon_sym_on] = ACTIONS(556),
    [anon_sym_required] = ACTIONS(556),
    [anon_sym_component] = ACTIONS(556),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [57] = {
    [sym_export_statement] = STATE(2659),
    [sym_declaration] = STATE(2659),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(2659),
    [sym_expression_statement] = STATE(2659),
    [sym_variable_declaration] = STATE(2592),
    [sym_lexical_declaration] = STATE(2592),
    [sym_statement_block] = STATE(2659),
    [sym_if_statement] = STATE(2659),
    [sym_switch_statement] = STATE(2659),
    [sym_for_statement] = STATE(2659),
    [sym_for_in_statement] = STATE(2659),
    [sym_while_statement] = STATE(2659),
    [sym_do_statement] = STATE(2659),
    [sym_try_statement] = STATE(2659),
    [sym_with_statement] = STATE(2659),
    [sym_break_statement] = STATE(2659),
    [sym_continue_statement] = STATE(2659),
    [sym_debugger_statement] = STATE(2659),
    [sym_return_statement] = STATE(2659),
    [sym_throw_statement] = STATE(2659),
    [sym_empty_statement] = STATE(2659),
    [sym_labeled_statement] = STATE(2659),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1862),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(2592),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(2592),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(2592),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4514),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(2592),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(2592),
    [sym_abstract_class_declaration] = STATE(2592),
    [sym_module] = STATE(2592),
    [sym_internal_module] = STATE(876),
    [sym_import_alias] = STATE(2592),
    [sym_interface_declaration] = STATE(2592),
    [sym_enum_declaration] = STATE(2592),
    [sym_type_alias_declaration] = STATE(2592),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3365),
    [sym_identifier] = ACTIONS(584),
    [anon_sym_export] = ACTIONS(586),
    [anon_sym_type] = ACTIONS(588),
    [anon_sym_namespace] = ACTIONS(590),
    [anon_sym_LBRACE] = ACTIONS(592),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(594),
    [anon_sym_from] = ACTIONS(596),
    [anon_sym_var] = ACTIONS(558),
    [anon_sym_let] = ACTIONS(598),
    [anon_sym_const] = ACTIONS(600),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(602),
    [anon_sym_switch] = ACTIONS(562),
    [anon_sym_for] = ACTIONS(604),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(596),
    [anon_sym_while] = ACTIONS(606),
    [anon_sym_do] = ACTIONS(608),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_with] = ACTIONS(610),
    [anon_sym_break] = ACTIONS(612),
    [anon_sym_continue] = ACTIONS(614),
    [anon_sym_debugger] = ACTIONS(616),
    [anon_sym_return] = ACTIONS(618),
    [anon_sym_throw] = ACTIONS(620),
    [anon_sym_SEMI] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(622),
    [anon_sym_async] = ACTIONS(624),
    [anon_sym_function] = ACTIONS(626),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(596),
    [anon_sym_readonly] = ACTIONS(596),
    [anon_sym_get] = ACTIONS(596),
    [anon_sym_set] = ACTIONS(596),
    [anon_sym_declare] = ACTIONS(628),
    [anon_sym_public] = ACTIONS(596),
    [anon_sym_private] = ACTIONS(596),
    [anon_sym_protected] = ACTIONS(596),
    [anon_sym_override] = ACTIONS(596),
    [anon_sym_module] = ACTIONS(630),
    [anon_sym_any] = ACTIONS(596),
    [anon_sym_number] = ACTIONS(596),
    [anon_sym_boolean] = ACTIONS(596),
    [anon_sym_string] = ACTIONS(596),
    [anon_sym_symbol] = ACTIONS(596),
    [anon_sym_property] = ACTIONS(596),
    [anon_sym_signal] = ACTIONS(596),
    [anon_sym_on] = ACTIONS(596),
    [anon_sym_required] = ACTIONS(596),
    [anon_sym_component] = ACTIONS(596),
    [anon_sym_abstract] = ACTIONS(632),
    [anon_sym_interface] = ACTIONS(634),
    [anon_sym_enum] = ACTIONS(636),
  },
  [58] = {
    [sym_export_statement] = STATE(2529),
    [sym_declaration] = STATE(2529),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(2529),
    [sym_expression_statement] = STATE(2529),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(2529),
    [sym_if_statement] = STATE(2529),
    [sym_switch_statement] = STATE(2529),
    [sym_for_statement] = STATE(2529),
    [sym_for_in_statement] = STATE(2529),
    [sym_while_statement] = STATE(2529),
    [sym_do_statement] = STATE(2529),
    [sym_try_statement] = STATE(2529),
    [sym_with_statement] = STATE(2529),
    [sym_break_statement] = STATE(2529),
    [sym_continue_statement] = STATE(2529),
    [sym_debugger_statement] = STATE(2529),
    [sym_return_statement] = STATE(2529),
    [sym_throw_statement] = STATE(2529),
    [sym_empty_statement] = STATE(2529),
    [sym_labeled_statement] = STATE(2529),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1862),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4514),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(2191),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3374),
    [sym_identifier] = ACTIONS(546),
    [anon_sym_export] = ACTIONS(548),
    [anon_sym_type] = ACTIONS(550),
    [anon_sym_namespace] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(556),
    [anon_sym_var] = ACTIONS(558),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(560),
    [anon_sym_switch] = ACTIONS(562),
    [anon_sym_for] = ACTIONS(564),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(556),
    [anon_sym_while] = ACTIONS(566),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_with] = ACTIONS(570),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(574),
    [anon_sym_async] = ACTIONS(576),
    [anon_sym_function] = ACTIONS(578),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(556),
    [anon_sym_readonly] = ACTIONS(556),
    [anon_sym_get] = ACTIONS(556),
    [anon_sym_set] = ACTIONS(556),
    [anon_sym_declare] = ACTIONS(580),
    [anon_sym_public] = ACTIONS(556),
    [anon_sym_private] = ACTIONS(556),
    [anon_sym_protected] = ACTIONS(556),
    [anon_sym_override] = ACTIONS(556),
    [anon_sym_module] = ACTIONS(582),
    [anon_sym_any] = ACTIONS(556),
    [anon_sym_number] = ACTIONS(556),
    [anon_sym_boolean] = ACTIONS(556),
    [anon_sym_string] = ACTIONS(556),
    [anon_sym_symbol] = ACTIONS(556),
    [anon_sym_property] = ACTIONS(556),
    [anon_sym_signal] = ACTIONS(556),
    [anon_sym_on] = ACTIONS(556),
    [anon_sym_required] = ACTIONS(556),
    [anon_sym_component] = ACTIONS(556),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [59] = {
    [sym_export_statement] = STATE(827),
    [sym_declaration] = STATE(828),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(829),
    [sym_expression_statement] = STATE(831),
    [sym_variable_declaration] = STATE(826),
    [sym_lexical_declaration] = STATE(826),
    [sym_statement_block] = STATE(832),
    [sym_if_statement] = STATE(833),
    [sym_switch_statement] = STATE(838),
    [sym_for_statement] = STATE(841),
    [sym_for_in_statement] = STATE(846),
    [sym_while_statement] = STATE(847),
    [sym_do_statement] = STATE(848),
    [sym_try_statement] = STATE(850),
    [sym_with_statement] = STATE(849),
    [sym_break_statement] = STATE(842),
    [sym_continue_statement] = STATE(836),
    [sym_debugger_statement] = STATE(834),
    [sym_return_statement] = STATE(830),
    [sym_throw_statement] = STATE(824),
    [sym_empty_statement] = STATE(823),
    [sym_labeled_statement] = STATE(821),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1862),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(826),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(826),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(826),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4514),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(826),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(826),
    [sym_abstract_class_declaration] = STATE(826),
    [sym_module] = STATE(826),
    [sym_internal_module] = STATE(2191),
    [sym_import_alias] = STATE(826),
    [sym_interface_declaration] = STATE(826),
    [sym_enum_declaration] = STATE(826),
    [sym_type_alias_declaration] = STATE(826),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3374),
    [sym_identifier] = ACTIONS(546),
    [anon_sym_export] = ACTIONS(548),
    [anon_sym_type] = ACTIONS(550),
    [anon_sym_namespace] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(556),
    [anon_sym_var] = ACTIONS(558),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(560),
    [anon_sym_switch] = ACTIONS(562),
    [anon_sym_for] = ACTIONS(564),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(556),
    [anon_sym_while] = ACTIONS(566),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_with] = ACTIONS(570),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_debugger] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(574),
    [anon_sym_async] = ACTIONS(576),
    [anon_sym_function] = ACTIONS(578),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(556),
    [anon_sym_readonly] = ACTIONS(556),
    [anon_sym_get] = ACTIONS(556),
    [anon_sym_set] = ACTIONS(556),
    [anon_sym_declare] = ACTIONS(580),
    [anon_sym_public] = ACTIONS(556),
    [anon_sym_private] = ACTIONS(556),
    [anon_sym_protected] = ACTIONS(556),
    [anon_sym_override] = ACTIONS(556),
    [anon_sym_module] = ACTIONS(582),
    [anon_sym_any] = ACTIONS(556),
    [anon_sym_number] = ACTIONS(556),
    [anon_sym_boolean] = ACTIONS(556),
    [anon_sym_string] = ACTIONS(556),
    [anon_sym_symbol] = ACTIONS(556),
    [anon_sym_property] = ACTIONS(556),
    [anon_sym_signal] = ACTIONS(556),
    [anon_sym_on] = ACTIONS(556),
    [anon_sym_required] = ACTIONS(556),
    [anon_sym_component] = ACTIONS(556),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [60] = {
    [sym_export_statement] = STATE(2510),
    [sym_declaration] = STATE(2510),
    [sym_import] = STATE(2236),
    [sym_import_statement] = STATE(2510),
    [sym_expression_statement] = STATE(2510),
    [sym_variable_declaration] = STATE(2592),
    [sym_lexical_declaration] = STATE(2592),
    [sym_statement_block] = STATE(2510),
    [sym_if_statement] = STATE(2510),
    [sym_switch_statement] = STATE(2510),
    [sym_for_statement] = STATE(2510),
    [sym_for_in_statement] = STATE(2510),
    [sym_while_statement] = STATE(2510),
    [sym_do_statement] = STATE(2510),
    [sym_try_statement] = STATE(2510),
    [sym_with_statement] = STATE(2510),
    [sym_break_statement] = STATE(2510),
    [sym_continue_statement] = STATE(2510),
    [sym_debugger_statement] = STATE(2510),
    [sym_return_statement] = STATE(2510),
    [sym_throw_statement] = STATE(2510),
    [sym_empty_statement] = STATE(2510),
    [sym_labeled_statement] = STATE(2510),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1862),
    [sym_primary_expression] = STATE(1969),
    [sym_yield_expression] = STATE(2210),
    [sym_object] = STATE(2236),
    [sym_object_pattern] = STATE(4732),
    [sym_array] = STATE(2236),
    [sym_array_pattern] = STATE(4732),
    [sym_glimmer_template] = STATE(2210),
    [sym_glimmer_opening_tag] = STATE(3889),
    [sym_class] = STATE(2236),
    [sym_class_declaration] = STATE(2592),
    [sym_function] = STATE(2236),
    [sym_function_declaration] = STATE(2592),
    [sym_generator_function] = STATE(2236),
    [sym_generator_function_declaration] = STATE(2592),
    [sym_arrow_function] = STATE(2236),
    [sym__call_signature] = STATE(4734),
    [sym_call_expression] = STATE(2236),
    [sym_new_expression] = STATE(2210),
    [sym_await_expression] = STATE(2210),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2210),
    [sym__augmented_assignment_lhs] = STATE(2876),
    [sym_augmented_assignment_expression] = STATE(2210),
    [sym__destructuring_pattern] = STATE(4732),
    [sym_ternary_expression] = STATE(2210),
    [sym_binary_expression] = STATE(2210),
    [sym_unary_expression] = STATE(2210),
    [sym_update_expression] = STATE(2210),
    [sym_sequence_expression] = STATE(4514),
    [sym_string] = STATE(2236),
    [sym_template_string] = STATE(2236),
    [sym_regex] = STATE(2236),
    [sym_meta_property] = STATE(2236),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_non_null_expression] = STATE(1304),
    [sym_function_signature] = STATE(2592),
    [sym_type_assertion] = STATE(2210),
    [sym_as_expression] = STATE(2210),
    [sym_ambient_declaration] = STATE(2592),
    [sym_abstract_class_declaration] = STATE(2592),
    [sym_module] = STATE(2592),
    [sym_internal_module] = STATE(876),
    [sym_import_alias] = STATE(2592),
    [sym_interface_declaration] = STATE(2592),
    [sym_enum_declaration] = STATE(2592),
    [sym_type_alias_declaration] = STATE(2592),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3365),
    [sym_identifier] = ACTIONS(584),
    [anon_sym_export] = ACTIONS(586),
    [anon_sym_type] = ACTIONS(588),
    [anon_sym_namespace] = ACTIONS(590),
    [anon_sym_LBRACE] = ACTIONS(592),
    [anon_sym_typeof] = ACTIONS(145),
    [anon_sym_import] = ACTIONS(594),
    [anon_sym_from] = ACTIONS(596),
    [anon_sym_var] = ACTIONS(558),
    [anon_sym_let] = ACTIONS(598),
    [anon_sym_const] = ACTIONS(600),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(602),
    [anon_sym_switch] = ACTIONS(562),
    [anon_sym_for] = ACTIONS(604),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_await] = ACTIONS(167),
    [anon_sym_of] = ACTIONS(596),
    [anon_sym_while] = ACTIONS(606),
    [anon_sym_do] = ACTIONS(608),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_with] = ACTIONS(610),
    [anon_sym_break] = ACTIONS(612),
    [anon_sym_continue] = ACTIONS(614),
    [anon_sym_debugger] = ACTIONS(616),
    [anon_sym_return] = ACTIONS(618),
    [anon_sym_throw] = ACTIONS(620),
    [anon_sym_SEMI] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(622),
    [anon_sym_async] = ACTIONS(624),
    [anon_sym_function] = ACTIONS(626),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_void] = ACTIONS(145),
    [anon_sym_delete] = ACTIONS(145),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(596),
    [anon_sym_readonly] = ACTIONS(596),
    [anon_sym_get] = ACTIONS(596),
    [anon_sym_set] = ACTIONS(596),
    [anon_sym_declare] = ACTIONS(628),
    [anon_sym_public] = ACTIONS(596),
    [anon_sym_private] = ACTIONS(596),
    [anon_sym_protected] = ACTIONS(596),
    [anon_sym_override] = ACTIONS(596),
    [anon_sym_module] = ACTIONS(630),
    [anon_sym_any] = ACTIONS(596),
    [anon_sym_number] = ACTIONS(596),
    [anon_sym_boolean] = ACTIONS(596),
    [anon_sym_string] = ACTIONS(596),
    [anon_sym_symbol] = ACTIONS(596),
    [anon_sym_property] = ACTIONS(596),
    [anon_sym_signal] = ACTIONS(596),
    [anon_sym_on] = ACTIONS(596),
    [anon_sym_required] = ACTIONS(596),
    [anon_sym_component] = ACTIONS(596),
    [anon_sym_abstract] = ACTIONS(632),
    [anon_sym_interface] = ACTIONS(634),
    [anon_sym_enum] = ACTIONS(636),
  },
  [61] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_expression] = STATE(1888),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3363),
    [sym_assignment_pattern] = STATE(4134),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3363),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_nested_identifier] = STATE(4870),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4737),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1242),
    [sym_subscript_expression] = STATE(1242),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2861),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3363),
    [sym_spread_element] = STATE(4008),
    [sym_ternary_expression] = STATE(1751),
    [sym_binary_expression] = STATE(1751),
    [sym_unary_expression] = STATE(1751),
    [sym_update_expression] = STATE(1751),
    [sym_string] = STATE(2176),
    [sym_template_string] = STATE(1752),
    [sym_regex] = STATE(1752),
    [sym_meta_property] = STATE(1752),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3846),
    [sym_pattern] = STATE(3881),
    [sym_rest_pattern] = STATE(3720),
    [sym_non_null_expression] = STATE(1242),
    [sym_type_assertion] = STATE(1751),
    [sym_as_expression] = STATE(1751),
    [sym_internal_module] = STATE(1751),
    [sym_nested_type_identifier] = STATE(2837),
    [sym__type] = STATE(3419),
    [sym_tuple_parameter] = STATE(4115),
    [sym_optional_tuple_parameter] = STATE(4115),
    [sym_optional_type] = STATE(4115),
    [sym_rest_type] = STATE(4115),
    [sym__tuple_type_member] = STATE(4115),
    [sym_constructor_type] = STATE(3419),
    [sym__primary_type] = STATE(2839),
    [sym_template_literal_type] = STATE(2840),
    [sym_infer_type] = STATE(3419),
    [sym_conditional_type] = STATE(2840),
    [sym_generic_type] = STATE(2840),
    [sym_type_query] = STATE(2840),
    [sym_index_type_query] = STATE(2840),
    [sym_lookup_type] = STATE(2840),
    [sym_literal_type] = STATE(2840),
    [sym__number] = STATE(2880),
    [sym_existential_type] = STATE(2840),
    [sym_flow_maybe_type] = STATE(2840),
    [sym_parenthesized_type] = STATE(2840),
    [sym_predefined_type] = STATE(2840),
    [sym_type_arguments] = STATE(516),
    [sym_object_type] = STATE(2840),
    [sym_type_parameters] = STATE(4567),
    [sym_array_type] = STATE(2840),
    [sym_tuple_type] = STATE(2840),
    [sym_readonly_type] = STATE(3419),
    [sym_union_type] = STATE(2840),
    [sym_intersection_type] = STATE(2840),
    [sym_function_type] = STATE(3419),
    [aux_sym_export_statement_repeat1] = STATE(3866),
    [aux_sym_array_repeat1] = STATE(4016),
    [aux_sym_array_pattern_repeat1] = STATE(4131),
    [sym_identifier] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(640),
    [anon_sym_STAR] = ACTIONS(642),
    [anon_sym_type] = ACTIONS(640),
    [anon_sym_namespace] = ACTIONS(644),
    [anon_sym_LBRACE] = ACTIONS(646),
    [anon_sym_COMMA] = ACTIONS(648),
    [anon_sym_typeof] = ACTIONS(650),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(640),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(654),
    [anon_sym_of] = ACTIONS(640),
    [anon_sym_yield] = ACTIONS(656),
    [anon_sym_LBRACK] = ACTIONS(658),
    [anon_sym_RBRACK] = ACTIONS(660),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(662),
    [anon_sym_class] = ACTIONS(56),
    [anon_sym_async] = ACTIONS(664),
    [anon_sym_function] = ACTIONS(60),
    [anon_sym_new] = ACTIONS(666),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(668),
    [anon_sym_AMP] = ACTIONS(670),
    [anon_sym_PIPE] = ACTIONS(672),
    [anon_sym_PLUS] = ACTIONS(674),
    [anon_sym_DASH] = ACTIONS(674),
    [anon_sym_TILDE] = ACTIONS(652),
    [anon_sym_void] = ACTIONS(676),
    [anon_sym_delete] = ACTIONS(678),
    [anon_sym_PLUS_PLUS] = ACTIONS(680),
    [anon_sym_DASH_DASH] = ACTIONS(680),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_SQUOTE] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(91),
    [sym_number] = ACTIONS(93),
    [sym_this] = ACTIONS(682),
    [sym_super] = ACTIONS(97),
    [sym_true] = ACTIONS(99),
    [sym_false] = ACTIONS(99),
    [sym_null] = ACTIONS(99),
    [sym_undefined] = ACTIONS(684),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(640),
    [anon_sym_readonly] = ACTIONS(686),
    [anon_sym_get] = ACTIONS(640),
    [anon_sym_set] = ACTIONS(640),
    [anon_sym_QMARK] = ACTIONS(688),
    [anon_sym_declare] = ACTIONS(640),
    [anon_sym_public] = ACTIONS(640),
    [anon_sym_private] = ACTIONS(640),
    [anon_sym_protected] = ACTIONS(640),
    [anon_sym_override] = ACTIONS(640),
    [anon_sym_module] = ACTIONS(640),
    [anon_sym_any] = ACTIONS(690),
    [anon_sym_number] = ACTIONS(690),
    [anon_sym_boolean] = ACTIONS(690),
    [anon_sym_string] = ACTIONS(690),
    [anon_sym_symbol] = ACTIONS(690),
    [anon_sym_property] = ACTIONS(640),
    [anon_sym_signal] = ACTIONS(640),
    [anon_sym_on] = ACTIONS(640),
    [anon_sym_required] = ACTIONS(640),
    [anon_sym_component] = ACTIONS(640),
    [anon_sym_abstract] = ACTIONS(111),
    [anon_sym_infer] = ACTIONS(113),
    [anon_sym_keyof] = ACTIONS(115),
    [anon_sym_unknown] = ACTIONS(117),
    [anon_sym_never] = ACTIONS(117),
    [anon_sym_object] = ACTIONS(117),
    [anon_sym_LBRACE_PIPE] = ACTIONS(119),
  },
  [62] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_expression] = STATE(1894),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3363),
    [sym_assignment_pattern] = STATE(4134),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3363),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_nested_identifier] = STATE(4870),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4737),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1242),
    [sym_subscript_expression] = STATE(1242),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2861),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3363),
    [sym_spread_element] = STATE(4021),
    [sym_ternary_expression] = STATE(1751),
    [sym_binary_expression] = STATE(1751),
    [sym_unary_expression] = STATE(1751),
    [sym_update_expression] = STATE(1751),
    [sym_string] = STATE(2176),
    [sym_template_string] = STATE(1752),
    [sym_regex] = STATE(1752),
    [sym_meta_property] = STATE(1752),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3846),
    [sym_pattern] = STATE(3881),
    [sym_rest_pattern] = STATE(3720),
    [sym_non_null_expression] = STATE(1242),
    [sym_type_assertion] = STATE(1751),
    [sym_as_expression] = STATE(1751),
    [sym_internal_module] = STATE(1751),
    [sym_nested_type_identifier] = STATE(2837),
    [sym__type] = STATE(3419),
    [sym_tuple_parameter] = STATE(4115),
    [sym_optional_tuple_parameter] = STATE(4115),
    [sym_optional_type] = STATE(4115),
    [sym_rest_type] = STATE(4115),
    [sym__tuple_type_member] = STATE(4115),
    [sym_constructor_type] = STATE(3419),
    [sym__primary_type] = STATE(2839),
    [sym_template_literal_type] = STATE(2840),
    [sym_infer_type] = STATE(3419),
    [sym_conditional_type] = STATE(2840),
    [sym_generic_type] = STATE(2840),
    [sym_type_query] = STATE(2840),
    [sym_index_type_query] = STATE(2840),
    [sym_lookup_type] = STATE(2840),
    [sym_literal_type] = STATE(2840),
    [sym__number] = STATE(2880),
    [sym_existential_type] = STATE(2840),
    [sym_flow_maybe_type] = STATE(2840),
    [sym_parenthesized_type] = STATE(2840),
    [sym_predefined_type] = STATE(2840),
    [sym_type_arguments] = STATE(516),
    [sym_object_type] = STATE(2840),
    [sym_type_parameters] = STATE(4567),
    [sym_array_type] = STATE(2840),
    [sym_tuple_type] = STATE(2840),
    [sym_readonly_type] = STATE(3419),
    [sym_union_type] = STATE(2840),
    [sym_intersection_type] = STATE(2840),
    [sym_function_type] = STATE(3419),
    [aux_sym_export_statement_repeat1] = STATE(3866),
    [aux_sym_array_repeat1] = STATE(4013),
    [aux_sym_array_pattern_repeat1] = STATE(4131),
    [sym_identifier] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(640),
    [anon_sym_STAR] = ACTIONS(642),
    [anon_sym_type] = ACTIONS(640),
    [anon_sym_namespace] = ACTIONS(644),
    [anon_sym_LBRACE] = ACTIONS(646),
    [anon_sym_COMMA] = ACTIONS(648),
    [anon_sym_typeof] = ACTIONS(650),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(640),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(654),
    [anon_sym_of] = ACTIONS(640),
    [anon_sym_yield] = ACTIONS(656),
    [anon_sym_LBRACK] = ACTIONS(658),
    [anon_sym_RBRACK] = ACTIONS(692),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(662),
    [anon_sym_class] = ACTIONS(56),
    [anon_sym_async] = ACTIONS(664),
    [anon_sym_function] = ACTIONS(60),
    [anon_sym_new] = ACTIONS(666),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(668),
    [anon_sym_AMP] = ACTIONS(670),
    [anon_sym_PIPE] = ACTIONS(672),
    [anon_sym_PLUS] = ACTIONS(674),
    [anon_sym_DASH] = ACTIONS(674),
    [anon_sym_TILDE] = ACTIONS(652),
    [anon_sym_void] = ACTIONS(676),
    [anon_sym_delete] = ACTIONS(678),
    [anon_sym_PLUS_PLUS] = ACTIONS(680),
    [anon_sym_DASH_DASH] = ACTIONS(680),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_SQUOTE] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(91),
    [sym_number] = ACTIONS(93),
    [sym_this] = ACTIONS(682),
    [sym_super] = ACTIONS(97),
    [sym_true] = ACTIONS(99),
    [sym_false] = ACTIONS(99),
    [sym_null] = ACTIONS(99),
    [sym_undefined] = ACTIONS(684),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(640),
    [anon_sym_readonly] = ACTIONS(686),
    [anon_sym_get] = ACTIONS(640),
    [anon_sym_set] = ACTIONS(640),
    [anon_sym_QMARK] = ACTIONS(688),
    [anon_sym_declare] = ACTIONS(640),
    [anon_sym_public] = ACTIONS(640),
    [anon_sym_private] = ACTIONS(640),
    [anon_sym_protected] = ACTIONS(640),
    [anon_sym_override] = ACTIONS(640),
    [anon_sym_module] = ACTIONS(640),
    [anon_sym_any] = ACTIONS(690),
    [anon_sym_number] = ACTIONS(690),
    [anon_sym_boolean] = ACTIONS(690),
    [anon_sym_string] = ACTIONS(690),
    [anon_sym_symbol] = ACTIONS(690),
    [anon_sym_property] = ACTIONS(640),
    [anon_sym_signal] = ACTIONS(640),
    [anon_sym_on] = ACTIONS(640),
    [anon_sym_required] = ACTIONS(640),
    [anon_sym_component] = ACTIONS(640),
    [anon_sym_abstract] = ACTIONS(111),
    [anon_sym_infer] = ACTIONS(113),
    [anon_sym_keyof] = ACTIONS(115),
    [anon_sym_unknown] = ACTIONS(117),
    [anon_sym_never] = ACTIONS(117),
    [anon_sym_object] = ACTIONS(117),
    [anon_sym_LBRACE_PIPE] = ACTIONS(119),
  },
  [63] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_expression] = STATE(1894),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3363),
    [sym_assignment_pattern] = STATE(4134),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3363),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_nested_identifier] = STATE(4870),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4737),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1242),
    [sym_subscript_expression] = STATE(1242),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2861),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3363),
    [sym_spread_element] = STATE(4021),
    [sym_ternary_expression] = STATE(1751),
    [sym_binary_expression] = STATE(1751),
    [sym_unary_expression] = STATE(1751),
    [sym_update_expression] = STATE(1751),
    [sym_string] = STATE(2176),
    [sym_template_string] = STATE(1752),
    [sym_regex] = STATE(1752),
    [sym_meta_property] = STATE(1752),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3846),
    [sym_pattern] = STATE(3881),
    [sym_rest_pattern] = STATE(3720),
    [sym_non_null_expression] = STATE(1242),
    [sym_type_assertion] = STATE(1751),
    [sym_as_expression] = STATE(1751),
    [sym_internal_module] = STATE(1751),
    [sym_nested_type_identifier] = STATE(2837),
    [sym__type] = STATE(3419),
    [sym_tuple_parameter] = STATE(4174),
    [sym_optional_tuple_parameter] = STATE(4174),
    [sym_optional_type] = STATE(4174),
    [sym_rest_type] = STATE(4174),
    [sym__tuple_type_member] = STATE(4174),
    [sym_constructor_type] = STATE(3419),
    [sym__primary_type] = STATE(2839),
    [sym_template_literal_type] = STATE(2840),
    [sym_infer_type] = STATE(3419),
    [sym_conditional_type] = STATE(2840),
    [sym_generic_type] = STATE(2840),
    [sym_type_query] = STATE(2840),
    [sym_index_type_query] = STATE(2840),
    [sym_lookup_type] = STATE(2840),
    [sym_literal_type] = STATE(2840),
    [sym__number] = STATE(2880),
    [sym_existential_type] = STATE(2840),
    [sym_flow_maybe_type] = STATE(2840),
    [sym_parenthesized_type] = STATE(2840),
    [sym_predefined_type] = STATE(2840),
    [sym_type_arguments] = STATE(516),
    [sym_object_type] = STATE(2840),
    [sym_type_parameters] = STATE(4567),
    [sym_array_type] = STATE(2840),
    [sym_tuple_type] = STATE(2840),
    [sym_readonly_type] = STATE(3419),
    [sym_union_type] = STATE(2840),
    [sym_intersection_type] = STATE(2840),
    [sym_function_type] = STATE(3419),
    [aux_sym_export_statement_repeat1] = STATE(3866),
    [aux_sym_array_repeat1] = STATE(4013),
    [aux_sym_array_pattern_repeat1] = STATE(4131),
    [sym_identifier] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(640),
    [anon_sym_STAR] = ACTIONS(642),
    [anon_sym_type] = ACTIONS(640),
    [anon_sym_namespace] = ACTIONS(644),
    [anon_sym_LBRACE] = ACTIONS(646),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_typeof] = ACTIONS(650),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(640),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(654),
    [anon_sym_of] = ACTIONS(640),
    [anon_sym_yield] = ACTIONS(656),
    [anon_sym_LBRACK] = ACTIONS(658),
    [anon_sym_RBRACK] = ACTIONS(696),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(662),
    [anon_sym_class] = ACTIONS(56),
    [anon_sym_async] = ACTIONS(664),
    [anon_sym_function] = ACTIONS(60),
    [anon_sym_new] = ACTIONS(666),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(668),
    [anon_sym_AMP] = ACTIONS(670),
    [anon_sym_PIPE] = ACTIONS(672),
    [anon_sym_PLUS] = ACTIONS(674),
    [anon_sym_DASH] = ACTIONS(674),
    [anon_sym_TILDE] = ACTIONS(652),
    [anon_sym_void] = ACTIONS(676),
    [anon_sym_delete] = ACTIONS(678),
    [anon_sym_PLUS_PLUS] = ACTIONS(680),
    [anon_sym_DASH_DASH] = ACTIONS(680),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_SQUOTE] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(91),
    [sym_number] = ACTIONS(93),
    [sym_this] = ACTIONS(682),
    [sym_super] = ACTIONS(97),
    [sym_true] = ACTIONS(99),
    [sym_false] = ACTIONS(99),
    [sym_null] = ACTIONS(99),
    [sym_undefined] = ACTIONS(684),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(640),
    [anon_sym_readonly] = ACTIONS(686),
    [anon_sym_get] = ACTIONS(640),
    [anon_sym_set] = ACTIONS(640),
    [anon_sym_QMARK] = ACTIONS(688),
    [anon_sym_declare] = ACTIONS(640),
    [anon_sym_public] = ACTIONS(640),
    [anon_sym_private] = ACTIONS(640),
    [anon_sym_protected] = ACTIONS(640),
    [anon_sym_override] = ACTIONS(640),
    [anon_sym_module] = ACTIONS(640),
    [anon_sym_any] = ACTIONS(690),
    [anon_sym_number] = ACTIONS(690),
    [anon_sym_boolean] = ACTIONS(690),
    [anon_sym_string] = ACTIONS(690),
    [anon_sym_symbol] = ACTIONS(690),
    [anon_sym_property] = ACTIONS(640),
    [anon_sym_signal] = ACTIONS(640),
    [anon_sym_on] = ACTIONS(640),
    [anon_sym_required] = ACTIONS(640),
    [anon_sym_component] = ACTIONS(640),
    [anon_sym_abstract] = ACTIONS(111),
    [anon_sym_infer] = ACTIONS(113),
    [anon_sym_keyof] = ACTIONS(115),
    [anon_sym_unknown] = ACTIONS(117),
    [anon_sym_never] = ACTIONS(117),
    [anon_sym_object] = ACTIONS(117),
    [anon_sym_LBRACE_PIPE] = ACTIONS(119),
  },
  [64] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_expression] = STATE(1894),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3363),
    [sym_assignment_pattern] = STATE(4134),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3363),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_nested_identifier] = STATE(4870),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4737),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1242),
    [sym_subscript_expression] = STATE(1242),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2861),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3363),
    [sym_spread_element] = STATE(4021),
    [sym_ternary_expression] = STATE(1751),
    [sym_binary_expression] = STATE(1751),
    [sym_unary_expression] = STATE(1751),
    [sym_update_expression] = STATE(1751),
    [sym_string] = STATE(2176),
    [sym_template_string] = STATE(1752),
    [sym_regex] = STATE(1752),
    [sym_meta_property] = STATE(1752),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3846),
    [sym_pattern] = STATE(3881),
    [sym_rest_pattern] = STATE(3720),
    [sym_non_null_expression] = STATE(1242),
    [sym_type_assertion] = STATE(1751),
    [sym_as_expression] = STATE(1751),
    [sym_internal_module] = STATE(1751),
    [sym_nested_type_identifier] = STATE(2837),
    [sym__type] = STATE(3419),
    [sym_tuple_parameter] = STATE(4115),
    [sym_optional_tuple_parameter] = STATE(4115),
    [sym_optional_type] = STATE(4115),
    [sym_rest_type] = STATE(4115),
    [sym__tuple_type_member] = STATE(4115),
    [sym_constructor_type] = STATE(3419),
    [sym__primary_type] = STATE(2839),
    [sym_template_literal_type] = STATE(2840),
    [sym_infer_type] = STATE(3419),
    [sym_conditional_type] = STATE(2840),
    [sym_generic_type] = STATE(2840),
    [sym_type_query] = STATE(2840),
    [sym_index_type_query] = STATE(2840),
    [sym_lookup_type] = STATE(2840),
    [sym_literal_type] = STATE(2840),
    [sym__number] = STATE(2880),
    [sym_existential_type] = STATE(2840),
    [sym_flow_maybe_type] = STATE(2840),
    [sym_parenthesized_type] = STATE(2840),
    [sym_predefined_type] = STATE(2840),
    [sym_type_arguments] = STATE(516),
    [sym_object_type] = STATE(2840),
    [sym_type_parameters] = STATE(4567),
    [sym_array_type] = STATE(2840),
    [sym_tuple_type] = STATE(2840),
    [sym_readonly_type] = STATE(3419),
    [sym_union_type] = STATE(2840),
    [sym_intersection_type] = STATE(2840),
    [sym_function_type] = STATE(3419),
    [aux_sym_export_statement_repeat1] = STATE(3866),
    [aux_sym_array_repeat1] = STATE(4013),
    [aux_sym_array_pattern_repeat1] = STATE(4131),
    [sym_identifier] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(640),
    [anon_sym_STAR] = ACTIONS(642),
    [anon_sym_type] = ACTIONS(640),
    [anon_sym_namespace] = ACTIONS(644),
    [anon_sym_LBRACE] = ACTIONS(646),
    [anon_sym_COMMA] = ACTIONS(648),
    [anon_sym_typeof] = ACTIONS(650),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(640),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(654),
    [anon_sym_of] = ACTIONS(640),
    [anon_sym_yield] = ACTIONS(656),
    [anon_sym_LBRACK] = ACTIONS(658),
    [anon_sym_RBRACK] = ACTIONS(698),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(662),
    [anon_sym_class] = ACTIONS(56),
    [anon_sym_async] = ACTIONS(664),
    [anon_sym_function] = ACTIONS(60),
    [anon_sym_new] = ACTIONS(666),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(668),
    [anon_sym_AMP] = ACTIONS(670),
    [anon_sym_PIPE] = ACTIONS(672),
    [anon_sym_PLUS] = ACTIONS(674),
    [anon_sym_DASH] = ACTIONS(674),
    [anon_sym_TILDE] = ACTIONS(652),
    [anon_sym_void] = ACTIONS(676),
    [anon_sym_delete] = ACTIONS(678),
    [anon_sym_PLUS_PLUS] = ACTIONS(680),
    [anon_sym_DASH_DASH] = ACTIONS(680),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_SQUOTE] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(91),
    [sym_number] = ACTIONS(93),
    [sym_this] = ACTIONS(682),
    [sym_super] = ACTIONS(97),
    [sym_true] = ACTIONS(99),
    [sym_false] = ACTIONS(99),
    [sym_null] = ACTIONS(99),
    [sym_undefined] = ACTIONS(684),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(640),
    [anon_sym_readonly] = ACTIONS(686),
    [anon_sym_get] = ACTIONS(640),
    [anon_sym_set] = ACTIONS(640),
    [anon_sym_QMARK] = ACTIONS(688),
    [anon_sym_declare] = ACTIONS(640),
    [anon_sym_public] = ACTIONS(640),
    [anon_sym_private] = ACTIONS(640),
    [anon_sym_protected] = ACTIONS(640),
    [anon_sym_override] = ACTIONS(640),
    [anon_sym_module] = ACTIONS(640),
    [anon_sym_any] = ACTIONS(690),
    [anon_sym_number] = ACTIONS(690),
    [anon_sym_boolean] = ACTIONS(690),
    [anon_sym_string] = ACTIONS(690),
    [anon_sym_symbol] = ACTIONS(690),
    [anon_sym_property] = ACTIONS(640),
    [anon_sym_signal] = ACTIONS(640),
    [anon_sym_on] = ACTIONS(640),
    [anon_sym_required] = ACTIONS(640),
    [anon_sym_component] = ACTIONS(640),
    [anon_sym_abstract] = ACTIONS(111),
    [anon_sym_infer] = ACTIONS(113),
    [anon_sym_keyof] = ACTIONS(115),
    [anon_sym_unknown] = ACTIONS(117),
    [anon_sym_never] = ACTIONS(117),
    [anon_sym_object] = ACTIONS(117),
    [anon_sym_LBRACE_PIPE] = ACTIONS(119),
  },
  [65] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_expression] = STATE(1888),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3363),
    [sym_assignment_pattern] = STATE(4134),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3363),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_nested_identifier] = STATE(4870),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4737),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1242),
    [sym_subscript_expression] = STATE(1242),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2861),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3363),
    [sym_spread_element] = STATE(4008),
    [sym_ternary_expression] = STATE(1751),
    [sym_binary_expression] = STATE(1751),
    [sym_unary_expression] = STATE(1751),
    [sym_update_expression] = STATE(1751),
    [sym_string] = STATE(2176),
    [sym_template_string] = STATE(1752),
    [sym_regex] = STATE(1752),
    [sym_meta_property] = STATE(1752),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3846),
    [sym_pattern] = STATE(3881),
    [sym_rest_pattern] = STATE(3720),
    [sym_non_null_expression] = STATE(1242),
    [sym_type_assertion] = STATE(1751),
    [sym_as_expression] = STATE(1751),
    [sym_internal_module] = STATE(1751),
    [sym_nested_type_identifier] = STATE(2837),
    [sym__type] = STATE(3419),
    [sym_tuple_parameter] = STATE(4115),
    [sym_optional_tuple_parameter] = STATE(4115),
    [sym_optional_type] = STATE(4115),
    [sym_rest_type] = STATE(4115),
    [sym__tuple_type_member] = STATE(4115),
    [sym_constructor_type] = STATE(3419),
    [sym__primary_type] = STATE(2839),
    [sym_template_literal_type] = STATE(2840),
    [sym_infer_type] = STATE(3419),
    [sym_conditional_type] = STATE(2840),
    [sym_generic_type] = STATE(2840),
    [sym_type_query] = STATE(2840),
    [sym_index_type_query] = STATE(2840),
    [sym_lookup_type] = STATE(2840),
    [sym_literal_type] = STATE(2840),
    [sym__number] = STATE(2880),
    [sym_existential_type] = STATE(2840),
    [sym_flow_maybe_type] = STATE(2840),
    [sym_parenthesized_type] = STATE(2840),
    [sym_predefined_type] = STATE(2840),
    [sym_type_arguments] = STATE(516),
    [sym_object_type] = STATE(2840),
    [sym_type_parameters] = STATE(4567),
    [sym_array_type] = STATE(2840),
    [sym_tuple_type] = STATE(2840),
    [sym_readonly_type] = STATE(3419),
    [sym_union_type] = STATE(2840),
    [sym_intersection_type] = STATE(2840),
    [sym_function_type] = STATE(3419),
    [aux_sym_export_statement_repeat1] = STATE(3866),
    [aux_sym_array_repeat1] = STATE(4016),
    [aux_sym_array_pattern_repeat1] = STATE(4131),
    [sym_identifier] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(640),
    [anon_sym_STAR] = ACTIONS(642),
    [anon_sym_type] = ACTIONS(640),
    [anon_sym_namespace] = ACTIONS(644),
    [anon_sym_LBRACE] = ACTIONS(646),
    [anon_sym_COMMA] = ACTIONS(648),
    [anon_sym_typeof] = ACTIONS(650),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(640),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(654),
    [anon_sym_of] = ACTIONS(640),
    [anon_sym_yield] = ACTIONS(656),
    [anon_sym_LBRACK] = ACTIONS(658),
    [anon_sym_RBRACK] = ACTIONS(700),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(662),
    [anon_sym_class] = ACTIONS(56),
    [anon_sym_async] = ACTIONS(664),
    [anon_sym_function] = ACTIONS(60),
    [anon_sym_new] = ACTIONS(666),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(668),
    [anon_sym_AMP] = ACTIONS(670),
    [anon_sym_PIPE] = ACTIONS(672),
    [anon_sym_PLUS] = ACTIONS(674),
    [anon_sym_DASH] = ACTIONS(674),
    [anon_sym_TILDE] = ACTIONS(652),
    [anon_sym_void] = ACTIONS(676),
    [anon_sym_delete] = ACTIONS(678),
    [anon_sym_PLUS_PLUS] = ACTIONS(680),
    [anon_sym_DASH_DASH] = ACTIONS(680),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_SQUOTE] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(91),
    [sym_number] = ACTIONS(93),
    [sym_this] = ACTIONS(682),
    [sym_super] = ACTIONS(97),
    [sym_true] = ACTIONS(99),
    [sym_false] = ACTIONS(99),
    [sym_null] = ACTIONS(99),
    [sym_undefined] = ACTIONS(684),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(640),
    [anon_sym_readonly] = ACTIONS(686),
    [anon_sym_get] = ACTIONS(640),
    [anon_sym_set] = ACTIONS(640),
    [anon_sym_QMARK] = ACTIONS(688),
    [anon_sym_declare] = ACTIONS(640),
    [anon_sym_public] = ACTIONS(640),
    [anon_sym_private] = ACTIONS(640),
    [anon_sym_protected] = ACTIONS(640),
    [anon_sym_override] = ACTIONS(640),
    [anon_sym_module] = ACTIONS(640),
    [anon_sym_any] = ACTIONS(690),
    [anon_sym_number] = ACTIONS(690),
    [anon_sym_boolean] = ACTIONS(690),
    [anon_sym_string] = ACTIONS(690),
    [anon_sym_symbol] = ACTIONS(690),
    [anon_sym_property] = ACTIONS(640),
    [anon_sym_signal] = ACTIONS(640),
    [anon_sym_on] = ACTIONS(640),
    [anon_sym_required] = ACTIONS(640),
    [anon_sym_component] = ACTIONS(640),
    [anon_sym_abstract] = ACTIONS(111),
    [anon_sym_infer] = ACTIONS(113),
    [anon_sym_keyof] = ACTIONS(115),
    [anon_sym_unknown] = ACTIONS(117),
    [anon_sym_never] = ACTIONS(117),
    [anon_sym_object] = ACTIONS(117),
    [anon_sym_LBRACE_PIPE] = ACTIONS(119),
  },
  [66] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_expression] = STATE(1894),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3363),
    [sym_assignment_pattern] = STATE(4134),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3363),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_nested_identifier] = STATE(4870),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4737),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1242),
    [sym_subscript_expression] = STATE(1242),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2861),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3363),
    [sym_spread_element] = STATE(4021),
    [sym_ternary_expression] = STATE(1751),
    [sym_binary_expression] = STATE(1751),
    [sym_unary_expression] = STATE(1751),
    [sym_update_expression] = STATE(1751),
    [sym_string] = STATE(2176),
    [sym_template_string] = STATE(1752),
    [sym_regex] = STATE(1752),
    [sym_meta_property] = STATE(1752),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3846),
    [sym_pattern] = STATE(3881),
    [sym_rest_pattern] = STATE(3720),
    [sym_non_null_expression] = STATE(1242),
    [sym_type_assertion] = STATE(1751),
    [sym_as_expression] = STATE(1751),
    [sym_internal_module] = STATE(1751),
    [sym_nested_type_identifier] = STATE(2837),
    [sym__type] = STATE(3419),
    [sym_tuple_parameter] = STATE(4115),
    [sym_optional_tuple_parameter] = STATE(4115),
    [sym_optional_type] = STATE(4115),
    [sym_rest_type] = STATE(4115),
    [sym__tuple_type_member] = STATE(4115),
    [sym_constructor_type] = STATE(3419),
    [sym__primary_type] = STATE(2839),
    [sym_template_literal_type] = STATE(2840),
    [sym_infer_type] = STATE(3419),
    [sym_conditional_type] = STATE(2840),
    [sym_generic_type] = STATE(2840),
    [sym_type_query] = STATE(2840),
    [sym_index_type_query] = STATE(2840),
    [sym_lookup_type] = STATE(2840),
    [sym_literal_type] = STATE(2840),
    [sym__number] = STATE(2880),
    [sym_existential_type] = STATE(2840),
    [sym_flow_maybe_type] = STATE(2840),
    [sym_parenthesized_type] = STATE(2840),
    [sym_predefined_type] = STATE(2840),
    [sym_type_arguments] = STATE(516),
    [sym_object_type] = STATE(2840),
    [sym_type_parameters] = STATE(4567),
    [sym_array_type] = STATE(2840),
    [sym_tuple_type] = STATE(2840),
    [sym_readonly_type] = STATE(3419),
    [sym_union_type] = STATE(2840),
    [sym_intersection_type] = STATE(2840),
    [sym_function_type] = STATE(3419),
    [aux_sym_export_statement_repeat1] = STATE(3866),
    [aux_sym_array_repeat1] = STATE(4013),
    [aux_sym_array_pattern_repeat1] = STATE(4131),
    [sym_identifier] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(640),
    [anon_sym_STAR] = ACTIONS(642),
    [anon_sym_type] = ACTIONS(640),
    [anon_sym_namespace] = ACTIONS(644),
    [anon_sym_LBRACE] = ACTIONS(646),
    [anon_sym_COMMA] = ACTIONS(648),
    [anon_sym_typeof] = ACTIONS(650),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(640),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(654),
    [anon_sym_of] = ACTIONS(640),
    [anon_sym_yield] = ACTIONS(656),
    [anon_sym_LBRACK] = ACTIONS(658),
    [anon_sym_RBRACK] = ACTIONS(702),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(662),
    [anon_sym_class] = ACTIONS(56),
    [anon_sym_async] = ACTIONS(664),
    [anon_sym_function] = ACTIONS(60),
    [anon_sym_new] = ACTIONS(666),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(668),
    [anon_sym_AMP] = ACTIONS(670),
    [anon_sym_PIPE] = ACTIONS(672),
    [anon_sym_PLUS] = ACTIONS(674),
    [anon_sym_DASH] = ACTIONS(674),
    [anon_sym_TILDE] = ACTIONS(652),
    [anon_sym_void] = ACTIONS(676),
    [anon_sym_delete] = ACTIONS(678),
    [anon_sym_PLUS_PLUS] = ACTIONS(680),
    [anon_sym_DASH_DASH] = ACTIONS(680),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_SQUOTE] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(91),
    [sym_number] = ACTIONS(93),
    [sym_this] = ACTIONS(682),
    [sym_super] = ACTIONS(97),
    [sym_true] = ACTIONS(99),
    [sym_false] = ACTIONS(99),
    [sym_null] = ACTIONS(99),
    [sym_undefined] = ACTIONS(684),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(640),
    [anon_sym_readonly] = ACTIONS(686),
    [anon_sym_get] = ACTIONS(640),
    [anon_sym_set] = ACTIONS(640),
    [anon_sym_QMARK] = ACTIONS(688),
    [anon_sym_declare] = ACTIONS(640),
    [anon_sym_public] = ACTIONS(640),
    [anon_sym_private] = ACTIONS(640),
    [anon_sym_protected] = ACTIONS(640),
    [anon_sym_override] = ACTIONS(640),
    [anon_sym_module] = ACTIONS(640),
    [anon_sym_any] = ACTIONS(690),
    [anon_sym_number] = ACTIONS(690),
    [anon_sym_boolean] = ACTIONS(690),
    [anon_sym_string] = ACTIONS(690),
    [anon_sym_symbol] = ACTIONS(690),
    [anon_sym_property] = ACTIONS(640),
    [anon_sym_signal] = ACTIONS(640),
    [anon_sym_on] = ACTIONS(640),
    [anon_sym_required] = ACTIONS(640),
    [anon_sym_component] = ACTIONS(640),
    [anon_sym_abstract] = ACTIONS(111),
    [anon_sym_infer] = ACTIONS(113),
    [anon_sym_keyof] = ACTIONS(115),
    [anon_sym_unknown] = ACTIONS(117),
    [anon_sym_never] = ACTIONS(117),
    [anon_sym_object] = ACTIONS(117),
    [anon_sym_LBRACE_PIPE] = ACTIONS(119),
  },
  [67] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_expression] = STATE(1894),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3363),
    [sym_assignment_pattern] = STATE(4134),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3363),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_nested_identifier] = STATE(4870),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4737),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1242),
    [sym_subscript_expression] = STATE(1242),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2861),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3363),
    [sym_spread_element] = STATE(4021),
    [sym_ternary_expression] = STATE(1751),
    [sym_binary_expression] = STATE(1751),
    [sym_unary_expression] = STATE(1751),
    [sym_update_expression] = STATE(1751),
    [sym_string] = STATE(2176),
    [sym_template_string] = STATE(1752),
    [sym_regex] = STATE(1752),
    [sym_meta_property] = STATE(1752),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3846),
    [sym_pattern] = STATE(3881),
    [sym_rest_pattern] = STATE(3720),
    [sym_non_null_expression] = STATE(1242),
    [sym_type_assertion] = STATE(1751),
    [sym_as_expression] = STATE(1751),
    [sym_internal_module] = STATE(1751),
    [sym_nested_type_identifier] = STATE(2837),
    [sym__type] = STATE(3419),
    [sym_tuple_parameter] = STATE(4115),
    [sym_optional_tuple_parameter] = STATE(4115),
    [sym_optional_type] = STATE(4115),
    [sym_rest_type] = STATE(4115),
    [sym__tuple_type_member] = STATE(4115),
    [sym_constructor_type] = STATE(3419),
    [sym__primary_type] = STATE(2839),
    [sym_template_literal_type] = STATE(2840),
    [sym_infer_type] = STATE(3419),
    [sym_conditional_type] = STATE(2840),
    [sym_generic_type] = STATE(2840),
    [sym_type_query] = STATE(2840),
    [sym_index_type_query] = STATE(2840),
    [sym_lookup_type] = STATE(2840),
    [sym_literal_type] = STATE(2840),
    [sym__number] = STATE(2880),
    [sym_existential_type] = STATE(2840),
    [sym_flow_maybe_type] = STATE(2840),
    [sym_parenthesized_type] = STATE(2840),
    [sym_predefined_type] = STATE(2840),
    [sym_type_arguments] = STATE(516),
    [sym_object_type] = STATE(2840),
    [sym_type_parameters] = STATE(4567),
    [sym_array_type] = STATE(2840),
    [sym_tuple_type] = STATE(2840),
    [sym_readonly_type] = STATE(3419),
    [sym_union_type] = STATE(2840),
    [sym_intersection_type] = STATE(2840),
    [sym_function_type] = STATE(3419),
    [aux_sym_export_statement_repeat1] = STATE(3866),
    [aux_sym_array_repeat1] = STATE(4013),
    [aux_sym_array_pattern_repeat1] = STATE(4131),
    [sym_identifier] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(640),
    [anon_sym_STAR] = ACTIONS(642),
    [anon_sym_type] = ACTIONS(640),
    [anon_sym_namespace] = ACTIONS(644),
    [anon_sym_LBRACE] = ACTIONS(646),
    [anon_sym_COMMA] = ACTIONS(648),
    [anon_sym_typeof] = ACTIONS(650),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(640),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(654),
    [anon_sym_of] = ACTIONS(640),
    [anon_sym_yield] = ACTIONS(656),
    [anon_sym_LBRACK] = ACTIONS(658),
    [anon_sym_RBRACK] = ACTIONS(704),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(662),
    [anon_sym_class] = ACTIONS(56),
    [anon_sym_async] = ACTIONS(664),
    [anon_sym_function] = ACTIONS(60),
    [anon_sym_new] = ACTIONS(666),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(668),
    [anon_sym_AMP] = ACTIONS(670),
    [anon_sym_PIPE] = ACTIONS(672),
    [anon_sym_PLUS] = ACTIONS(674),
    [anon_sym_DASH] = ACTIONS(674),
    [anon_sym_TILDE] = ACTIONS(652),
    [anon_sym_void] = ACTIONS(676),
    [anon_sym_delete] = ACTIONS(678),
    [anon_sym_PLUS_PLUS] = ACTIONS(680),
    [anon_sym_DASH_DASH] = ACTIONS(680),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_SQUOTE] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(91),
    [sym_number] = ACTIONS(93),
    [sym_this] = ACTIONS(682),
    [sym_super] = ACTIONS(97),
    [sym_true] = ACTIONS(99),
    [sym_false] = ACTIONS(99),
    [sym_null] = ACTIONS(99),
    [sym_undefined] = ACTIONS(684),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(640),
    [anon_sym_readonly] = ACTIONS(686),
    [anon_sym_get] = ACTIONS(640),
    [anon_sym_set] = ACTIONS(640),
    [anon_sym_QMARK] = ACTIONS(688),
    [anon_sym_declare] = ACTIONS(640),
    [anon_sym_public] = ACTIONS(640),
    [anon_sym_private] = ACTIONS(640),
    [anon_sym_protected] = ACTIONS(640),
    [anon_sym_override] = ACTIONS(640),
    [anon_sym_module] = ACTIONS(640),
    [anon_sym_any] = ACTIONS(690),
    [anon_sym_number] = ACTIONS(690),
    [anon_sym_boolean] = ACTIONS(690),
    [anon_sym_string] = ACTIONS(690),
    [anon_sym_symbol] = ACTIONS(690),
    [anon_sym_property] = ACTIONS(640),
    [anon_sym_signal] = ACTIONS(640),
    [anon_sym_on] = ACTIONS(640),
    [anon_sym_required] = ACTIONS(640),
    [anon_sym_component] = ACTIONS(640),
    [anon_sym_abstract] = ACTIONS(111),
    [anon_sym_infer] = ACTIONS(113),
    [anon_sym_keyof] = ACTIONS(115),
    [anon_sym_unknown] = ACTIONS(117),
    [anon_sym_never] = ACTIONS(117),
    [anon_sym_object] = ACTIONS(117),
    [anon_sym_LBRACE_PIPE] = ACTIONS(119),
  },
  [68] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_expression] = STATE(1894),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3363),
    [sym_assignment_pattern] = STATE(4134),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3363),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_nested_identifier] = STATE(4870),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4737),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1242),
    [sym_subscript_expression] = STATE(1242),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2861),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3363),
    [sym_spread_element] = STATE(4021),
    [sym_ternary_expression] = STATE(1751),
    [sym_binary_expression] = STATE(1751),
    [sym_unary_expression] = STATE(1751),
    [sym_update_expression] = STATE(1751),
    [sym_string] = STATE(2176),
    [sym_template_string] = STATE(1752),
    [sym_regex] = STATE(1752),
    [sym_meta_property] = STATE(1752),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3846),
    [sym_pattern] = STATE(3881),
    [sym_rest_pattern] = STATE(3720),
    [sym_non_null_expression] = STATE(1242),
    [sym_type_assertion] = STATE(1751),
    [sym_as_expression] = STATE(1751),
    [sym_internal_module] = STATE(1751),
    [sym_nested_type_identifier] = STATE(2837),
    [sym__type] = STATE(3419),
    [sym_tuple_parameter] = STATE(4115),
    [sym_optional_tuple_parameter] = STATE(4115),
    [sym_optional_type] = STATE(4115),
    [sym_rest_type] = STATE(4115),
    [sym__tuple_type_member] = STATE(4115),
    [sym_constructor_type] = STATE(3419),
    [sym__primary_type] = STATE(2839),
    [sym_template_literal_type] = STATE(2840),
    [sym_infer_type] = STATE(3419),
    [sym_conditional_type] = STATE(2840),
    [sym_generic_type] = STATE(2840),
    [sym_type_query] = STATE(2840),
    [sym_index_type_query] = STATE(2840),
    [sym_lookup_type] = STATE(2840),
    [sym_literal_type] = STATE(2840),
    [sym__number] = STATE(2880),
    [sym_existential_type] = STATE(2840),
    [sym_flow_maybe_type] = STATE(2840),
    [sym_parenthesized_type] = STATE(2840),
    [sym_predefined_type] = STATE(2840),
    [sym_type_arguments] = STATE(516),
    [sym_object_type] = STATE(2840),
    [sym_type_parameters] = STATE(4567),
    [sym_array_type] = STATE(2840),
    [sym_tuple_type] = STATE(2840),
    [sym_readonly_type] = STATE(3419),
    [sym_union_type] = STATE(2840),
    [sym_intersection_type] = STATE(2840),
    [sym_function_type] = STATE(3419),
    [aux_sym_export_statement_repeat1] = STATE(3866),
    [aux_sym_array_repeat1] = STATE(4013),
    [aux_sym_array_pattern_repeat1] = STATE(4131),
    [sym_identifier] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(640),
    [anon_sym_STAR] = ACTIONS(642),
    [anon_sym_type] = ACTIONS(640),
    [anon_sym_namespace] = ACTIONS(644),
    [anon_sym_LBRACE] = ACTIONS(646),
    [anon_sym_COMMA] = ACTIONS(648),
    [anon_sym_typeof] = ACTIONS(650),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(640),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(654),
    [anon_sym_of] = ACTIONS(640),
    [anon_sym_yield] = ACTIONS(656),
    [anon_sym_LBRACK] = ACTIONS(658),
    [anon_sym_RBRACK] = ACTIONS(706),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(662),
    [anon_sym_class] = ACTIONS(56),
    [anon_sym_async] = ACTIONS(664),
    [anon_sym_function] = ACTIONS(60),
    [anon_sym_new] = ACTIONS(666),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(668),
    [anon_sym_AMP] = ACTIONS(670),
    [anon_sym_PIPE] = ACTIONS(672),
    [anon_sym_PLUS] = ACTIONS(674),
    [anon_sym_DASH] = ACTIONS(674),
    [anon_sym_TILDE] = ACTIONS(652),
    [anon_sym_void] = ACTIONS(676),
    [anon_sym_delete] = ACTIONS(678),
    [anon_sym_PLUS_PLUS] = ACTIONS(680),
    [anon_sym_DASH_DASH] = ACTIONS(680),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_SQUOTE] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(91),
    [sym_number] = ACTIONS(93),
    [sym_this] = ACTIONS(682),
    [sym_super] = ACTIONS(97),
    [sym_true] = ACTIONS(99),
    [sym_false] = ACTIONS(99),
    [sym_null] = ACTIONS(99),
    [sym_undefined] = ACTIONS(684),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(640),
    [anon_sym_readonly] = ACTIONS(686),
    [anon_sym_get] = ACTIONS(640),
    [anon_sym_set] = ACTIONS(640),
    [anon_sym_QMARK] = ACTIONS(688),
    [anon_sym_declare] = ACTIONS(640),
    [anon_sym_public] = ACTIONS(640),
    [anon_sym_private] = ACTIONS(640),
    [anon_sym_protected] = ACTIONS(640),
    [anon_sym_override] = ACTIONS(640),
    [anon_sym_module] = ACTIONS(640),
    [anon_sym_any] = ACTIONS(690),
    [anon_sym_number] = ACTIONS(690),
    [anon_sym_boolean] = ACTIONS(690),
    [anon_sym_string] = ACTIONS(690),
    [anon_sym_symbol] = ACTIONS(690),
    [anon_sym_property] = ACTIONS(640),
    [anon_sym_signal] = ACTIONS(640),
    [anon_sym_on] = ACTIONS(640),
    [anon_sym_required] = ACTIONS(640),
    [anon_sym_component] = ACTIONS(640),
    [anon_sym_abstract] = ACTIONS(111),
    [anon_sym_infer] = ACTIONS(113),
    [anon_sym_keyof] = ACTIONS(115),
    [anon_sym_unknown] = ACTIONS(117),
    [anon_sym_never] = ACTIONS(117),
    [anon_sym_object] = ACTIONS(117),
    [anon_sym_LBRACE_PIPE] = ACTIONS(119),
  },
  [69] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_expression] = STATE(1894),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3363),
    [sym_assignment_pattern] = STATE(4134),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3363),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_nested_identifier] = STATE(4870),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4737),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1242),
    [sym_subscript_expression] = STATE(1242),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2861),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3363),
    [sym_spread_element] = STATE(4021),
    [sym_ternary_expression] = STATE(1751),
    [sym_binary_expression] = STATE(1751),
    [sym_unary_expression] = STATE(1751),
    [sym_update_expression] = STATE(1751),
    [sym_string] = STATE(2176),
    [sym_template_string] = STATE(1752),
    [sym_regex] = STATE(1752),
    [sym_meta_property] = STATE(1752),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3846),
    [sym_pattern] = STATE(3881),
    [sym_rest_pattern] = STATE(3720),
    [sym_non_null_expression] = STATE(1242),
    [sym_type_assertion] = STATE(1751),
    [sym_as_expression] = STATE(1751),
    [sym_internal_module] = STATE(1751),
    [sym_nested_type_identifier] = STATE(2837),
    [sym__type] = STATE(3419),
    [sym_tuple_parameter] = STATE(4115),
    [sym_optional_tuple_parameter] = STATE(4115),
    [sym_optional_type] = STATE(4115),
    [sym_rest_type] = STATE(4115),
    [sym__tuple_type_member] = STATE(4115),
    [sym_constructor_type] = STATE(3419),
    [sym__primary_type] = STATE(2839),
    [sym_template_literal_type] = STATE(2840),
    [sym_infer_type] = STATE(3419),
    [sym_conditional_type] = STATE(2840),
    [sym_generic_type] = STATE(2840),
    [sym_type_query] = STATE(2840),
    [sym_index_type_query] = STATE(2840),
    [sym_lookup_type] = STATE(2840),
    [sym_literal_type] = STATE(2840),
    [sym__number] = STATE(2880),
    [sym_existential_type] = STATE(2840),
    [sym_flow_maybe_type] = STATE(2840),
    [sym_parenthesized_type] = STATE(2840),
    [sym_predefined_type] = STATE(2840),
    [sym_type_arguments] = STATE(516),
    [sym_object_type] = STATE(2840),
    [sym_type_parameters] = STATE(4567),
    [sym_array_type] = STATE(2840),
    [sym_tuple_type] = STATE(2840),
    [sym_readonly_type] = STATE(3419),
    [sym_union_type] = STATE(2840),
    [sym_intersection_type] = STATE(2840),
    [sym_function_type] = STATE(3419),
    [aux_sym_export_statement_repeat1] = STATE(3866),
    [aux_sym_array_repeat1] = STATE(4013),
    [aux_sym_array_pattern_repeat1] = STATE(4131),
    [sym_identifier] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(640),
    [anon_sym_STAR] = ACTIONS(642),
    [anon_sym_type] = ACTIONS(640),
    [anon_sym_namespace] = ACTIONS(644),
    [anon_sym_LBRACE] = ACTIONS(646),
    [anon_sym_COMMA] = ACTIONS(648),
    [anon_sym_typeof] = ACTIONS(650),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(640),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(654),
    [anon_sym_of] = ACTIONS(640),
    [anon_sym_yield] = ACTIONS(656),
    [anon_sym_LBRACK] = ACTIONS(658),
    [anon_sym_RBRACK] = ACTIONS(708),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(662),
    [anon_sym_class] = ACTIONS(56),
    [anon_sym_async] = ACTIONS(664),
    [anon_sym_function] = ACTIONS(60),
    [anon_sym_new] = ACTIONS(666),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(668),
    [anon_sym_AMP] = ACTIONS(670),
    [anon_sym_PIPE] = ACTIONS(672),
    [anon_sym_PLUS] = ACTIONS(674),
    [anon_sym_DASH] = ACTIONS(674),
    [anon_sym_TILDE] = ACTIONS(652),
    [anon_sym_void] = ACTIONS(676),
    [anon_sym_delete] = ACTIONS(678),
    [anon_sym_PLUS_PLUS] = ACTIONS(680),
    [anon_sym_DASH_DASH] = ACTIONS(680),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_SQUOTE] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(91),
    [sym_number] = ACTIONS(93),
    [sym_this] = ACTIONS(682),
    [sym_super] = ACTIONS(97),
    [sym_true] = ACTIONS(99),
    [sym_false] = ACTIONS(99),
    [sym_null] = ACTIONS(99),
    [sym_undefined] = ACTIONS(684),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(640),
    [anon_sym_readonly] = ACTIONS(686),
    [anon_sym_get] = ACTIONS(640),
    [anon_sym_set] = ACTIONS(640),
    [anon_sym_QMARK] = ACTIONS(688),
    [anon_sym_declare] = ACTIONS(640),
    [anon_sym_public] = ACTIONS(640),
    [anon_sym_private] = ACTIONS(640),
    [anon_sym_protected] = ACTIONS(640),
    [anon_sym_override] = ACTIONS(640),
    [anon_sym_module] = ACTIONS(640),
    [anon_sym_any] = ACTIONS(690),
    [anon_sym_number] = ACTIONS(690),
    [anon_sym_boolean] = ACTIONS(690),
    [anon_sym_string] = ACTIONS(690),
    [anon_sym_symbol] = ACTIONS(690),
    [anon_sym_property] = ACTIONS(640),
    [anon_sym_signal] = ACTIONS(640),
    [anon_sym_on] = ACTIONS(640),
    [anon_sym_required] = ACTIONS(640),
    [anon_sym_component] = ACTIONS(640),
    [anon_sym_abstract] = ACTIONS(111),
    [anon_sym_infer] = ACTIONS(113),
    [anon_sym_keyof] = ACTIONS(115),
    [anon_sym_unknown] = ACTIONS(117),
    [anon_sym_never] = ACTIONS(117),
    [anon_sym_object] = ACTIONS(117),
    [anon_sym_LBRACE_PIPE] = ACTIONS(119),
  },
  [70] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_expression] = STATE(1894),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3363),
    [sym_assignment_pattern] = STATE(4134),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3363),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_nested_identifier] = STATE(4870),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4737),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1242),
    [sym_subscript_expression] = STATE(1242),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2861),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3363),
    [sym_spread_element] = STATE(4021),
    [sym_ternary_expression] = STATE(1751),
    [sym_binary_expression] = STATE(1751),
    [sym_unary_expression] = STATE(1751),
    [sym_update_expression] = STATE(1751),
    [sym_string] = STATE(2176),
    [sym_template_string] = STATE(1752),
    [sym_regex] = STATE(1752),
    [sym_meta_property] = STATE(1752),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3846),
    [sym_pattern] = STATE(3881),
    [sym_rest_pattern] = STATE(3720),
    [sym_non_null_expression] = STATE(1242),
    [sym_type_assertion] = STATE(1751),
    [sym_as_expression] = STATE(1751),
    [sym_internal_module] = STATE(1751),
    [sym_nested_type_identifier] = STATE(2837),
    [sym__type] = STATE(3419),
    [sym_tuple_parameter] = STATE(4115),
    [sym_optional_tuple_parameter] = STATE(4115),
    [sym_optional_type] = STATE(4115),
    [sym_rest_type] = STATE(4115),
    [sym__tuple_type_member] = STATE(4115),
    [sym_constructor_type] = STATE(3419),
    [sym__primary_type] = STATE(2839),
    [sym_template_literal_type] = STATE(2840),
    [sym_infer_type] = STATE(3419),
    [sym_conditional_type] = STATE(2840),
    [sym_generic_type] = STATE(2840),
    [sym_type_query] = STATE(2840),
    [sym_index_type_query] = STATE(2840),
    [sym_lookup_type] = STATE(2840),
    [sym_literal_type] = STATE(2840),
    [sym__number] = STATE(2880),
    [sym_existential_type] = STATE(2840),
    [sym_flow_maybe_type] = STATE(2840),
    [sym_parenthesized_type] = STATE(2840),
    [sym_predefined_type] = STATE(2840),
    [sym_type_arguments] = STATE(516),
    [sym_object_type] = STATE(2840),
    [sym_type_parameters] = STATE(4567),
    [sym_array_type] = STATE(2840),
    [sym_tuple_type] = STATE(2840),
    [sym_readonly_type] = STATE(3419),
    [sym_union_type] = STATE(2840),
    [sym_intersection_type] = STATE(2840),
    [sym_function_type] = STATE(3419),
    [aux_sym_export_statement_repeat1] = STATE(3866),
    [aux_sym_array_repeat1] = STATE(4013),
    [aux_sym_array_pattern_repeat1] = STATE(4131),
    [sym_identifier] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(640),
    [anon_sym_STAR] = ACTIONS(642),
    [anon_sym_type] = ACTIONS(640),
    [anon_sym_namespace] = ACTIONS(644),
    [anon_sym_LBRACE] = ACTIONS(646),
    [anon_sym_COMMA] = ACTIONS(648),
    [anon_sym_typeof] = ACTIONS(650),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(640),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(654),
    [anon_sym_of] = ACTIONS(640),
    [anon_sym_yield] = ACTIONS(656),
    [anon_sym_LBRACK] = ACTIONS(658),
    [anon_sym_RBRACK] = ACTIONS(710),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(662),
    [anon_sym_class] = ACTIONS(56),
    [anon_sym_async] = ACTIONS(664),
    [anon_sym_function] = ACTIONS(60),
    [anon_sym_new] = ACTIONS(666),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(668),
    [anon_sym_AMP] = ACTIONS(670),
    [anon_sym_PIPE] = ACTIONS(672),
    [anon_sym_PLUS] = ACTIONS(674),
    [anon_sym_DASH] = ACTIONS(674),
    [anon_sym_TILDE] = ACTIONS(652),
    [anon_sym_void] = ACTIONS(676),
    [anon_sym_delete] = ACTIONS(678),
    [anon_sym_PLUS_PLUS] = ACTIONS(680),
    [anon_sym_DASH_DASH] = ACTIONS(680),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_SQUOTE] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(91),
    [sym_number] = ACTIONS(93),
    [sym_this] = ACTIONS(682),
    [sym_super] = ACTIONS(97),
    [sym_true] = ACTIONS(99),
    [sym_false] = ACTIONS(99),
    [sym_null] = ACTIONS(99),
    [sym_undefined] = ACTIONS(684),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(640),
    [anon_sym_readonly] = ACTIONS(686),
    [anon_sym_get] = ACTIONS(640),
    [anon_sym_set] = ACTIONS(640),
    [anon_sym_QMARK] = ACTIONS(688),
    [anon_sym_declare] = ACTIONS(640),
    [anon_sym_public] = ACTIONS(640),
    [anon_sym_private] = ACTIONS(640),
    [anon_sym_protected] = ACTIONS(640),
    [anon_sym_override] = ACTIONS(640),
    [anon_sym_module] = ACTIONS(640),
    [anon_sym_any] = ACTIONS(690),
    [anon_sym_number] = ACTIONS(690),
    [anon_sym_boolean] = ACTIONS(690),
    [anon_sym_string] = ACTIONS(690),
    [anon_sym_symbol] = ACTIONS(690),
    [anon_sym_property] = ACTIONS(640),
    [anon_sym_signal] = ACTIONS(640),
    [anon_sym_on] = ACTIONS(640),
    [anon_sym_required] = ACTIONS(640),
    [anon_sym_component] = ACTIONS(640),
    [anon_sym_abstract] = ACTIONS(111),
    [anon_sym_infer] = ACTIONS(113),
    [anon_sym_keyof] = ACTIONS(115),
    [anon_sym_unknown] = ACTIONS(117),
    [anon_sym_never] = ACTIONS(117),
    [anon_sym_object] = ACTIONS(117),
    [anon_sym_LBRACE_PIPE] = ACTIONS(119),
  },
  [71] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1175),
    [sym_expression] = STATE(2338),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3296),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3296),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4895),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1240),
    [sym_subscript_expression] = STATE(1240),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2865),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3296),
    [sym_ternary_expression] = STATE(1751),
    [sym_binary_expression] = STATE(1751),
    [sym_unary_expression] = STATE(1751),
    [sym_update_expression] = STATE(1751),
    [sym_string] = STATE(1752),
    [sym_template_string] = STATE(1752),
    [sym_regex] = STATE(1752),
    [sym_meta_property] = STATE(1752),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_pattern] = STATE(3775),
    [sym_rest_pattern] = STATE(3298),
    [sym_non_null_expression] = STATE(1240),
    [sym_type_assertion] = STATE(1751),
    [sym_as_expression] = STATE(1751),
    [sym_internal_module] = STATE(1751),
    [sym_type_arguments] = STATE(463),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3866),
    [sym_identifier] = ACTIONS(712),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(26),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_EQ] = ACTIONS(23),
    [anon_sym_as] = ACTIONS(26),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(714),
    [anon_sym_COMMA] = ACTIONS(32),
    [anon_sym_typeof] = ACTIONS(82),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(38),
    [anon_sym_LPAREN] = ACTIONS(716),
    [anon_sym_RPAREN] = ACTIONS(32),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_in] = ACTIONS(26),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_COLON] = ACTIONS(32),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(719),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(722),
    [anon_sym_GT] = ACTIONS(26),
    [anon_sym_SLASH] = ACTIONS(53),
    [anon_sym_DOT] = ACTIONS(26),
    [anon_sym_class] = ACTIONS(56),
    [anon_sym_async] = ACTIONS(58),
    [anon_sym_function] = ACTIONS(60),
    [anon_sym_EQ_GT] = ACTIONS(62),
    [anon_sym_QMARK_DOT] = ACTIONS(64),
    [anon_sym_new] = ACTIONS(725),
    [anon_sym_PLUS_EQ] = ACTIONS(68),
    [anon_sym_DASH_EQ] = ACTIONS(68),
    [anon_sym_STAR_EQ] = ACTIONS(68),
    [anon_sym_SLASH_EQ] = ACTIONS(68),
    [anon_sym_PERCENT_EQ] = ACTIONS(68),
    [anon_sym_CARET_EQ] = ACTIONS(68),
    [anon_sym_AMP_EQ] = ACTIONS(68),
    [anon_sym_PIPE_EQ] = ACTIONS(68),
    [anon_sym_GT_GT_EQ] = ACTIONS(68),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(68),
    [anon_sym_LT_LT_EQ] = ACTIONS(68),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(68),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(68),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(68),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(68),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(70),
    [anon_sym_AMP_AMP] = ACTIONS(26),
    [anon_sym_PIPE_PIPE] = ACTIONS(26),
    [anon_sym_GT_GT] = ACTIONS(26),
    [anon_sym_GT_GT_GT] = ACTIONS(26),
    [anon_sym_LT_LT] = ACTIONS(26),
    [anon_sym_AMP] = ACTIONS(26),
    [anon_sym_CARET] = ACTIONS(26),
    [anon_sym_PIPE] = ACTIONS(26),
    [anon_sym_PLUS] = ACTIONS(38),
    [anon_sym_DASH] = ACTIONS(38),
    [anon_sym_PERCENT] = ACTIONS(26),
    [anon_sym_STAR_STAR] = ACTIONS(26),
    [anon_sym_LT_EQ] = ACTIONS(64),
    [anon_sym_EQ_EQ] = ACTIONS(26),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(64),
    [anon_sym_BANG_EQ] = ACTIONS(26),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(64),
    [anon_sym_QMARK_QMARK] = ACTIONS(26),
    [anon_sym_instanceof] = ACTIONS(26),
    [anon_sym_TILDE] = ACTIONS(78),
    [anon_sym_void] = ACTIONS(82),
    [anon_sym_delete] = ACTIONS(82),
    [anon_sym_PLUS_PLUS] = ACTIONS(84),
    [anon_sym_DASH_DASH] = ACTIONS(84),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_SQUOTE] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(727),
    [sym_number] = ACTIONS(730),
    [sym_this] = ACTIONS(732),
    [sym_super] = ACTIONS(97),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(734),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(19),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(736),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(19),
    [anon_sym_private] = ACTIONS(19),
    [anon_sym_protected] = ACTIONS(19),
    [anon_sym_override] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(19),
    [anon_sym_number] = ACTIONS(19),
    [anon_sym_boolean] = ACTIONS(19),
    [anon_sym_string] = ACTIONS(19),
    [anon_sym_symbol] = ACTIONS(19),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [sym__ternary_qmark] = ACTIONS(64),
  },
  [72] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1175),
    [sym_expression] = STATE(2338),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3296),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3296),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4895),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1240),
    [sym_subscript_expression] = STATE(1240),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2865),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3296),
    [sym_ternary_expression] = STATE(1751),
    [sym_binary_expression] = STATE(1751),
    [sym_unary_expression] = STATE(1751),
    [sym_update_expression] = STATE(1751),
    [sym_string] = STATE(1752),
    [sym_template_string] = STATE(1752),
    [sym_regex] = STATE(1752),
    [sym_meta_property] = STATE(1752),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_pattern] = STATE(3823),
    [sym_rest_pattern] = STATE(3298),
    [sym_non_null_expression] = STATE(1240),
    [sym_type_assertion] = STATE(1751),
    [sym_as_expression] = STATE(1751),
    [sym_internal_module] = STATE(1751),
    [sym_type_arguments] = STATE(463),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3866),
    [sym_identifier] = ACTIONS(712),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(26),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_EQ] = ACTIONS(23),
    [anon_sym_as] = ACTIONS(26),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(714),
    [anon_sym_COMMA] = ACTIONS(32),
    [anon_sym_typeof] = ACTIONS(82),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(38),
    [anon_sym_LPAREN] = ACTIONS(716),
    [anon_sym_RPAREN] = ACTIONS(32),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_in] = ACTIONS(26),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_COLON] = ACTIONS(32),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(719),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(722),
    [anon_sym_GT] = ACTIONS(26),
    [anon_sym_SLASH] = ACTIONS(53),
    [anon_sym_DOT] = ACTIONS(26),
    [anon_sym_class] = ACTIONS(56),
    [anon_sym_async] = ACTIONS(58),
    [anon_sym_function] = ACTIONS(60),
    [anon_sym_EQ_GT] = ACTIONS(62),
    [anon_sym_QMARK_DOT] = ACTIONS(64),
    [anon_sym_new] = ACTIONS(725),
    [anon_sym_PLUS_EQ] = ACTIONS(68),
    [anon_sym_DASH_EQ] = ACTIONS(68),
    [anon_sym_STAR_EQ] = ACTIONS(68),
    [anon_sym_SLASH_EQ] = ACTIONS(68),
    [anon_sym_PERCENT_EQ] = ACTIONS(68),
    [anon_sym_CARET_EQ] = ACTIONS(68),
    [anon_sym_AMP_EQ] = ACTIONS(68),
    [anon_sym_PIPE_EQ] = ACTIONS(68),
    [anon_sym_GT_GT_EQ] = ACTIONS(68),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(68),
    [anon_sym_LT_LT_EQ] = ACTIONS(68),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(68),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(68),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(68),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(68),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(70),
    [anon_sym_AMP_AMP] = ACTIONS(26),
    [anon_sym_PIPE_PIPE] = ACTIONS(26),
    [anon_sym_GT_GT] = ACTIONS(26),
    [anon_sym_GT_GT_GT] = ACTIONS(26),
    [anon_sym_LT_LT] = ACTIONS(26),
    [anon_sym_AMP] = ACTIONS(26),
    [anon_sym_CARET] = ACTIONS(26),
    [anon_sym_PIPE] = ACTIONS(26),
    [anon_sym_PLUS] = ACTIONS(38),
    [anon_sym_DASH] = ACTIONS(38),
    [anon_sym_PERCENT] = ACTIONS(26),
    [anon_sym_STAR_STAR] = ACTIONS(26),
    [anon_sym_LT_EQ] = ACTIONS(64),
    [anon_sym_EQ_EQ] = ACTIONS(26),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(64),
    [anon_sym_BANG_EQ] = ACTIONS(26),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(64),
    [anon_sym_QMARK_QMARK] = ACTIONS(26),
    [anon_sym_instanceof] = ACTIONS(26),
    [anon_sym_TILDE] = ACTIONS(78),
    [anon_sym_void] = ACTIONS(82),
    [anon_sym_delete] = ACTIONS(82),
    [anon_sym_PLUS_PLUS] = ACTIONS(84),
    [anon_sym_DASH_DASH] = ACTIONS(84),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_SQUOTE] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(727),
    [sym_number] = ACTIONS(730),
    [sym_this] = ACTIONS(738),
    [sym_super] = ACTIONS(97),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(734),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(19),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(736),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(19),
    [anon_sym_private] = ACTIONS(19),
    [anon_sym_protected] = ACTIONS(19),
    [anon_sym_override] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(19),
    [anon_sym_number] = ACTIONS(19),
    [anon_sym_boolean] = ACTIONS(19),
    [anon_sym_string] = ACTIONS(19),
    [anon_sym_symbol] = ACTIONS(19),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [sym__ternary_qmark] = ACTIONS(64),
  },
  [73] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1175),
    [sym_expression] = STATE(2338),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3296),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3296),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4895),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1240),
    [sym_subscript_expression] = STATE(1240),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2865),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3296),
    [sym_ternary_expression] = STATE(1751),
    [sym_binary_expression] = STATE(1751),
    [sym_unary_expression] = STATE(1751),
    [sym_update_expression] = STATE(1751),
    [sym_string] = STATE(1752),
    [sym_template_string] = STATE(1752),
    [sym_regex] = STATE(1752),
    [sym_meta_property] = STATE(1752),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_pattern] = STATE(3728),
    [sym_rest_pattern] = STATE(3298),
    [sym_non_null_expression] = STATE(1240),
    [sym_type_assertion] = STATE(1751),
    [sym_as_expression] = STATE(1751),
    [sym_internal_module] = STATE(1751),
    [sym_type_arguments] = STATE(463),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3866),
    [sym_identifier] = ACTIONS(712),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(26),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_EQ] = ACTIONS(23),
    [anon_sym_as] = ACTIONS(26),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(714),
    [anon_sym_COMMA] = ACTIONS(32),
    [anon_sym_typeof] = ACTIONS(82),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(38),
    [anon_sym_LPAREN] = ACTIONS(716),
    [anon_sym_RPAREN] = ACTIONS(32),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_in] = ACTIONS(26),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_COLON] = ACTIONS(32),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(719),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(722),
    [anon_sym_GT] = ACTIONS(26),
    [anon_sym_SLASH] = ACTIONS(53),
    [anon_sym_DOT] = ACTIONS(26),
    [anon_sym_class] = ACTIONS(56),
    [anon_sym_async] = ACTIONS(58),
    [anon_sym_function] = ACTIONS(60),
    [anon_sym_EQ_GT] = ACTIONS(62),
    [anon_sym_QMARK_DOT] = ACTIONS(64),
    [anon_sym_new] = ACTIONS(725),
    [anon_sym_PLUS_EQ] = ACTIONS(68),
    [anon_sym_DASH_EQ] = ACTIONS(68),
    [anon_sym_STAR_EQ] = ACTIONS(68),
    [anon_sym_SLASH_EQ] = ACTIONS(68),
    [anon_sym_PERCENT_EQ] = ACTIONS(68),
    [anon_sym_CARET_EQ] = ACTIONS(68),
    [anon_sym_AMP_EQ] = ACTIONS(68),
    [anon_sym_PIPE_EQ] = ACTIONS(68),
    [anon_sym_GT_GT_EQ] = ACTIONS(68),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(68),
    [anon_sym_LT_LT_EQ] = ACTIONS(68),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(68),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(68),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(68),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(68),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(70),
    [anon_sym_AMP_AMP] = ACTIONS(26),
    [anon_sym_PIPE_PIPE] = ACTIONS(26),
    [anon_sym_GT_GT] = ACTIONS(26),
    [anon_sym_GT_GT_GT] = ACTIONS(26),
    [anon_sym_LT_LT] = ACTIONS(26),
    [anon_sym_AMP] = ACTIONS(26),
    [anon_sym_CARET] = ACTIONS(26),
    [anon_sym_PIPE] = ACTIONS(26),
    [anon_sym_PLUS] = ACTIONS(38),
    [anon_sym_DASH] = ACTIONS(38),
    [anon_sym_PERCENT] = ACTIONS(26),
    [anon_sym_STAR_STAR] = ACTIONS(26),
    [anon_sym_LT_EQ] = ACTIONS(64),
    [anon_sym_EQ_EQ] = ACTIONS(26),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(64),
    [anon_sym_BANG_EQ] = ACTIONS(26),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(64),
    [anon_sym_QMARK_QMARK] = ACTIONS(26),
    [anon_sym_instanceof] = ACTIONS(26),
    [anon_sym_TILDE] = ACTIONS(78),
    [anon_sym_void] = ACTIONS(82),
    [anon_sym_delete] = ACTIONS(82),
    [anon_sym_PLUS_PLUS] = ACTIONS(84),
    [anon_sym_DASH_DASH] = ACTIONS(84),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_SQUOTE] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(727),
    [sym_number] = ACTIONS(730),
    [sym_this] = ACTIONS(740),
    [sym_super] = ACTIONS(97),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(734),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(19),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(736),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(19),
    [anon_sym_private] = ACTIONS(19),
    [anon_sym_protected] = ACTIONS(19),
    [anon_sym_override] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(19),
    [anon_sym_number] = ACTIONS(19),
    [anon_sym_boolean] = ACTIONS(19),
    [anon_sym_string] = ACTIONS(19),
    [anon_sym_symbol] = ACTIONS(19),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [sym__ternary_qmark] = ACTIONS(64),
  },
  [74] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1175),
    [sym_expression] = STATE(2338),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3296),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3296),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4895),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1240),
    [sym_subscript_expression] = STATE(1240),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2865),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3296),
    [sym_ternary_expression] = STATE(1751),
    [sym_binary_expression] = STATE(1751),
    [sym_unary_expression] = STATE(1751),
    [sym_update_expression] = STATE(1751),
    [sym_string] = STATE(1752),
    [sym_template_string] = STATE(1752),
    [sym_regex] = STATE(1752),
    [sym_meta_property] = STATE(1752),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_pattern] = STATE(3644),
    [sym_rest_pattern] = STATE(3298),
    [sym_non_null_expression] = STATE(1240),
    [sym_type_assertion] = STATE(1751),
    [sym_as_expression] = STATE(1751),
    [sym_internal_module] = STATE(1751),
    [sym_type_arguments] = STATE(463),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3866),
    [sym_identifier] = ACTIONS(712),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(26),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_EQ] = ACTIONS(23),
    [anon_sym_as] = ACTIONS(26),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(714),
    [anon_sym_COMMA] = ACTIONS(32),
    [anon_sym_typeof] = ACTIONS(82),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(38),
    [anon_sym_LPAREN] = ACTIONS(716),
    [anon_sym_RPAREN] = ACTIONS(32),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_in] = ACTIONS(26),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_COLON] = ACTIONS(32),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(719),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(722),
    [anon_sym_GT] = ACTIONS(26),
    [anon_sym_SLASH] = ACTIONS(53),
    [anon_sym_DOT] = ACTIONS(26),
    [anon_sym_class] = ACTIONS(56),
    [anon_sym_async] = ACTIONS(58),
    [anon_sym_function] = ACTIONS(60),
    [anon_sym_EQ_GT] = ACTIONS(62),
    [anon_sym_QMARK_DOT] = ACTIONS(64),
    [anon_sym_new] = ACTIONS(725),
    [anon_sym_PLUS_EQ] = ACTIONS(68),
    [anon_sym_DASH_EQ] = ACTIONS(68),
    [anon_sym_STAR_EQ] = ACTIONS(68),
    [anon_sym_SLASH_EQ] = ACTIONS(68),
    [anon_sym_PERCENT_EQ] = ACTIONS(68),
    [anon_sym_CARET_EQ] = ACTIONS(68),
    [anon_sym_AMP_EQ] = ACTIONS(68),
    [anon_sym_PIPE_EQ] = ACTIONS(68),
    [anon_sym_GT_GT_EQ] = ACTIONS(68),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(68),
    [anon_sym_LT_LT_EQ] = ACTIONS(68),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(68),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(68),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(68),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(68),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(70),
    [anon_sym_AMP_AMP] = ACTIONS(26),
    [anon_sym_PIPE_PIPE] = ACTIONS(26),
    [anon_sym_GT_GT] = ACTIONS(26),
    [anon_sym_GT_GT_GT] = ACTIONS(26),
    [anon_sym_LT_LT] = ACTIONS(26),
    [anon_sym_AMP] = ACTIONS(26),
    [anon_sym_CARET] = ACTIONS(26),
    [anon_sym_PIPE] = ACTIONS(26),
    [anon_sym_PLUS] = ACTIONS(38),
    [anon_sym_DASH] = ACTIONS(38),
    [anon_sym_PERCENT] = ACTIONS(26),
    [anon_sym_STAR_STAR] = ACTIONS(26),
    [anon_sym_LT_EQ] = ACTIONS(64),
    [anon_sym_EQ_EQ] = ACTIONS(26),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(64),
    [anon_sym_BANG_EQ] = ACTIONS(26),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(64),
    [anon_sym_QMARK_QMARK] = ACTIONS(26),
    [anon_sym_instanceof] = ACTIONS(26),
    [anon_sym_TILDE] = ACTIONS(78),
    [anon_sym_void] = ACTIONS(82),
    [anon_sym_delete] = ACTIONS(82),
    [anon_sym_PLUS_PLUS] = ACTIONS(84),
    [anon_sym_DASH_DASH] = ACTIONS(84),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_SQUOTE] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(727),
    [sym_number] = ACTIONS(730),
    [sym_this] = ACTIONS(742),
    [sym_super] = ACTIONS(97),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(734),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(19),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(736),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(19),
    [anon_sym_private] = ACTIONS(19),
    [anon_sym_protected] = ACTIONS(19),
    [anon_sym_override] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(19),
    [anon_sym_number] = ACTIONS(19),
    [anon_sym_boolean] = ACTIONS(19),
    [anon_sym_string] = ACTIONS(19),
    [anon_sym_symbol] = ACTIONS(19),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [sym__ternary_qmark] = ACTIONS(64),
  },
  [75] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1175),
    [sym_expression] = STATE(2338),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3296),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3296),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4895),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1240),
    [sym_subscript_expression] = STATE(1240),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2865),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3296),
    [sym_ternary_expression] = STATE(1751),
    [sym_binary_expression] = STATE(1751),
    [sym_unary_expression] = STATE(1751),
    [sym_update_expression] = STATE(1751),
    [sym_string] = STATE(1752),
    [sym_template_string] = STATE(1752),
    [sym_regex] = STATE(1752),
    [sym_meta_property] = STATE(1752),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_pattern] = STATE(3581),
    [sym_rest_pattern] = STATE(3298),
    [sym_non_null_expression] = STATE(1240),
    [sym_type_assertion] = STATE(1751),
    [sym_as_expression] = STATE(1751),
    [sym_internal_module] = STATE(1751),
    [sym_type_arguments] = STATE(463),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3866),
    [sym_identifier] = ACTIONS(712),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(26),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_EQ] = ACTIONS(121),
    [anon_sym_as] = ACTIONS(26),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(714),
    [anon_sym_COMMA] = ACTIONS(124),
    [anon_sym_typeof] = ACTIONS(82),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(38),
    [anon_sym_LPAREN] = ACTIONS(716),
    [anon_sym_RPAREN] = ACTIONS(124),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_in] = ACTIONS(26),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_COLON] = ACTIONS(124),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(719),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(722),
    [anon_sym_GT] = ACTIONS(26),
    [anon_sym_SLASH] = ACTIONS(53),
    [anon_sym_DOT] = ACTIONS(26),
    [anon_sym_class] = ACTIONS(56),
    [anon_sym_async] = ACTIONS(58),
    [anon_sym_function] = ACTIONS(60),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_QMARK_DOT] = ACTIONS(64),
    [anon_sym_new] = ACTIONS(725),
    [anon_sym_PLUS_EQ] = ACTIONS(68),
    [anon_sym_DASH_EQ] = ACTIONS(68),
    [anon_sym_STAR_EQ] = ACTIONS(68),
    [anon_sym_SLASH_EQ] = ACTIONS(68),
    [anon_sym_PERCENT_EQ] = ACTIONS(68),
    [anon_sym_CARET_EQ] = ACTIONS(68),
    [anon_sym_AMP_EQ] = ACTIONS(68),
    [anon_sym_PIPE_EQ] = ACTIONS(68),
    [anon_sym_GT_GT_EQ] = ACTIONS(68),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(68),
    [anon_sym_LT_LT_EQ] = ACTIONS(68),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(68),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(68),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(68),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(68),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(70),
    [anon_sym_AMP_AMP] = ACTIONS(26),
    [anon_sym_PIPE_PIPE] = ACTIONS(26),
    [anon_sym_GT_GT] = ACTIONS(26),
    [anon_sym_GT_GT_GT] = ACTIONS(26),
    [anon_sym_LT_LT] = ACTIONS(26),
    [anon_sym_AMP] = ACTIONS(26),
    [anon_sym_CARET] = ACTIONS(26),
    [anon_sym_PIPE] = ACTIONS(26),
    [anon_sym_PLUS] = ACTIONS(38),
    [anon_sym_DASH] = ACTIONS(38),
    [anon_sym_PERCENT] = ACTIONS(26),
    [anon_sym_STAR_STAR] = ACTIONS(26),
    [anon_sym_LT_EQ] = ACTIONS(64),
    [anon_sym_EQ_EQ] = ACTIONS(26),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(64),
    [anon_sym_BANG_EQ] = ACTIONS(26),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(64),
    [anon_sym_QMARK_QMARK] = ACTIONS(26),
    [anon_sym_instanceof] = ACTIONS(26),
    [anon_sym_TILDE] = ACTIONS(78),
    [anon_sym_void] = ACTIONS(82),
    [anon_sym_delete] = ACTIONS(82),
    [anon_sym_PLUS_PLUS] = ACTIONS(84),
    [anon_sym_DASH_DASH] = ACTIONS(84),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_SQUOTE] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(727),
    [sym_number] = ACTIONS(730),
    [sym_this] = ACTIONS(744),
    [sym_super] = ACTIONS(97),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(734),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(19),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(736),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(19),
    [anon_sym_private] = ACTIONS(19),
    [anon_sym_protected] = ACTIONS(19),
    [anon_sym_override] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(19),
    [anon_sym_number] = ACTIONS(19),
    [anon_sym_boolean] = ACTIONS(19),
    [anon_sym_string] = ACTIONS(19),
    [anon_sym_symbol] = ACTIONS(19),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [sym__ternary_qmark] = ACTIONS(64),
  },
  [76] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1175),
    [sym_expression] = STATE(2338),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3296),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3296),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4895),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1240),
    [sym_subscript_expression] = STATE(1240),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2865),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3296),
    [sym_ternary_expression] = STATE(1751),
    [sym_binary_expression] = STATE(1751),
    [sym_unary_expression] = STATE(1751),
    [sym_update_expression] = STATE(1751),
    [sym_string] = STATE(1752),
    [sym_template_string] = STATE(1752),
    [sym_regex] = STATE(1752),
    [sym_meta_property] = STATE(1752),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_pattern] = STATE(3581),
    [sym_rest_pattern] = STATE(3298),
    [sym_non_null_expression] = STATE(1240),
    [sym_type_assertion] = STATE(1751),
    [sym_as_expression] = STATE(1751),
    [sym_internal_module] = STATE(1751),
    [sym_type_arguments] = STATE(463),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3866),
    [sym_identifier] = ACTIONS(712),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(26),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_EQ] = ACTIONS(23),
    [anon_sym_as] = ACTIONS(26),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(714),
    [anon_sym_COMMA] = ACTIONS(32),
    [anon_sym_typeof] = ACTIONS(82),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(38),
    [anon_sym_LPAREN] = ACTIONS(716),
    [anon_sym_RPAREN] = ACTIONS(32),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_in] = ACTIONS(26),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_COLON] = ACTIONS(32),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(719),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(722),
    [anon_sym_GT] = ACTIONS(26),
    [anon_sym_SLASH] = ACTIONS(53),
    [anon_sym_DOT] = ACTIONS(26),
    [anon_sym_class] = ACTIONS(56),
    [anon_sym_async] = ACTIONS(58),
    [anon_sym_function] = ACTIONS(60),
    [anon_sym_EQ_GT] = ACTIONS(62),
    [anon_sym_QMARK_DOT] = ACTIONS(64),
    [anon_sym_new] = ACTIONS(725),
    [anon_sym_PLUS_EQ] = ACTIONS(68),
    [anon_sym_DASH_EQ] = ACTIONS(68),
    [anon_sym_STAR_EQ] = ACTIONS(68),
    [anon_sym_SLASH_EQ] = ACTIONS(68),
    [anon_sym_PERCENT_EQ] = ACTIONS(68),
    [anon_sym_CARET_EQ] = ACTIONS(68),
    [anon_sym_AMP_EQ] = ACTIONS(68),
    [anon_sym_PIPE_EQ] = ACTIONS(68),
    [anon_sym_GT_GT_EQ] = ACTIONS(68),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(68),
    [anon_sym_LT_LT_EQ] = ACTIONS(68),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(68),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(68),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(68),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(68),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(70),
    [anon_sym_AMP_AMP] = ACTIONS(26),
    [anon_sym_PIPE_PIPE] = ACTIONS(26),
    [anon_sym_GT_GT] = ACTIONS(26),
    [anon_sym_GT_GT_GT] = ACTIONS(26),
    [anon_sym_LT_LT] = ACTIONS(26),
    [anon_sym_AMP] = ACTIONS(26),
    [anon_sym_CARET] = ACTIONS(26),
    [anon_sym_PIPE] = ACTIONS(26),
    [anon_sym_PLUS] = ACTIONS(38),
    [anon_sym_DASH] = ACTIONS(38),
    [anon_sym_PERCENT] = ACTIONS(26),
    [anon_sym_STAR_STAR] = ACTIONS(26),
    [anon_sym_LT_EQ] = ACTIONS(64),
    [anon_sym_EQ_EQ] = ACTIONS(26),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(64),
    [anon_sym_BANG_EQ] = ACTIONS(26),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(64),
    [anon_sym_QMARK_QMARK] = ACTIONS(26),
    [anon_sym_instanceof] = ACTIONS(26),
    [anon_sym_TILDE] = ACTIONS(78),
    [anon_sym_void] = ACTIONS(82),
    [anon_sym_delete] = ACTIONS(82),
    [anon_sym_PLUS_PLUS] = ACTIONS(84),
    [anon_sym_DASH_DASH] = ACTIONS(84),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_SQUOTE] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(727),
    [sym_number] = ACTIONS(730),
    [sym_this] = ACTIONS(744),
    [sym_super] = ACTIONS(97),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(734),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(19),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(736),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(19),
    [anon_sym_private] = ACTIONS(19),
    [anon_sym_protected] = ACTIONS(19),
    [anon_sym_override] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(19),
    [anon_sym_number] = ACTIONS(19),
    [anon_sym_boolean] = ACTIONS(19),
    [anon_sym_string] = ACTIONS(19),
    [anon_sym_symbol] = ACTIONS(19),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [sym__ternary_qmark] = ACTIONS(64),
  },
  [77] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1175),
    [sym_expression] = STATE(2338),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3296),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3296),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4895),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1240),
    [sym_subscript_expression] = STATE(1240),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2865),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3296),
    [sym_ternary_expression] = STATE(1751),
    [sym_binary_expression] = STATE(1751),
    [sym_unary_expression] = STATE(1751),
    [sym_update_expression] = STATE(1751),
    [sym_string] = STATE(1752),
    [sym_template_string] = STATE(1752),
    [sym_regex] = STATE(1752),
    [sym_meta_property] = STATE(1752),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_pattern] = STATE(3803),
    [sym_rest_pattern] = STATE(3298),
    [sym_non_null_expression] = STATE(1240),
    [sym_type_assertion] = STATE(1751),
    [sym_as_expression] = STATE(1751),
    [sym_internal_module] = STATE(1751),
    [sym_type_arguments] = STATE(463),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3866),
    [sym_identifier] = ACTIONS(712),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(26),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_EQ] = ACTIONS(23),
    [anon_sym_as] = ACTIONS(26),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(714),
    [anon_sym_COMMA] = ACTIONS(32),
    [anon_sym_typeof] = ACTIONS(82),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(38),
    [anon_sym_LPAREN] = ACTIONS(716),
    [anon_sym_RPAREN] = ACTIONS(32),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_in] = ACTIONS(26),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_COLON] = ACTIONS(32),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(719),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(722),
    [anon_sym_GT] = ACTIONS(26),
    [anon_sym_SLASH] = ACTIONS(53),
    [anon_sym_DOT] = ACTIONS(26),
    [anon_sym_class] = ACTIONS(56),
    [anon_sym_async] = ACTIONS(58),
    [anon_sym_function] = ACTIONS(60),
    [anon_sym_EQ_GT] = ACTIONS(62),
    [anon_sym_QMARK_DOT] = ACTIONS(64),
    [anon_sym_new] = ACTIONS(725),
    [anon_sym_PLUS_EQ] = ACTIONS(68),
    [anon_sym_DASH_EQ] = ACTIONS(68),
    [anon_sym_STAR_EQ] = ACTIONS(68),
    [anon_sym_SLASH_EQ] = ACTIONS(68),
    [anon_sym_PERCENT_EQ] = ACTIONS(68),
    [anon_sym_CARET_EQ] = ACTIONS(68),
    [anon_sym_AMP_EQ] = ACTIONS(68),
    [anon_sym_PIPE_EQ] = ACTIONS(68),
    [anon_sym_GT_GT_EQ] = ACTIONS(68),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(68),
    [anon_sym_LT_LT_EQ] = ACTIONS(68),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(68),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(68),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(68),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(68),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(70),
    [anon_sym_AMP_AMP] = ACTIONS(26),
    [anon_sym_PIPE_PIPE] = ACTIONS(26),
    [anon_sym_GT_GT] = ACTIONS(26),
    [anon_sym_GT_GT_GT] = ACTIONS(26),
    [anon_sym_LT_LT] = ACTIONS(26),
    [anon_sym_AMP] = ACTIONS(26),
    [anon_sym_CARET] = ACTIONS(26),
    [anon_sym_PIPE] = ACTIONS(26),
    [anon_sym_PLUS] = ACTIONS(38),
    [anon_sym_DASH] = ACTIONS(38),
    [anon_sym_PERCENT] = ACTIONS(26),
    [anon_sym_STAR_STAR] = ACTIONS(26),
    [anon_sym_LT_EQ] = ACTIONS(64),
    [anon_sym_EQ_EQ] = ACTIONS(26),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(64),
    [anon_sym_BANG_EQ] = ACTIONS(26),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(64),
    [anon_sym_QMARK_QMARK] = ACTIONS(26),
    [anon_sym_instanceof] = ACTIONS(26),
    [anon_sym_TILDE] = ACTIONS(78),
    [anon_sym_void] = ACTIONS(82),
    [anon_sym_delete] = ACTIONS(82),
    [anon_sym_PLUS_PLUS] = ACTIONS(84),
    [anon_sym_DASH_DASH] = ACTIONS(84),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_SQUOTE] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(727),
    [sym_number] = ACTIONS(730),
    [sym_this] = ACTIONS(746),
    [sym_super] = ACTIONS(97),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(734),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(19),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(736),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(19),
    [anon_sym_private] = ACTIONS(19),
    [anon_sym_protected] = ACTIONS(19),
    [anon_sym_override] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(19),
    [anon_sym_number] = ACTIONS(19),
    [anon_sym_boolean] = ACTIONS(19),
    [anon_sym_string] = ACTIONS(19),
    [anon_sym_symbol] = ACTIONS(19),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [sym__ternary_qmark] = ACTIONS(64),
  },
  [78] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1175),
    [sym_expression] = STATE(2338),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3296),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3296),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4895),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1240),
    [sym_subscript_expression] = STATE(1240),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2865),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3296),
    [sym_ternary_expression] = STATE(1751),
    [sym_binary_expression] = STATE(1751),
    [sym_unary_expression] = STATE(1751),
    [sym_update_expression] = STATE(1751),
    [sym_string] = STATE(1752),
    [sym_template_string] = STATE(1752),
    [sym_regex] = STATE(1752),
    [sym_meta_property] = STATE(1752),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3479),
    [sym_pattern] = STATE(3759),
    [sym_rest_pattern] = STATE(3298),
    [sym_non_null_expression] = STATE(1240),
    [sym_type_assertion] = STATE(1751),
    [sym_as_expression] = STATE(1751),
    [sym_internal_module] = STATE(1751),
    [sym_type_arguments] = STATE(463),
    [sym_type_parameters] = STATE(4523),
    [aux_sym_export_statement_repeat1] = STATE(3866),
    [sym_identifier] = ACTIONS(712),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(26),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_EQ] = ACTIONS(23),
    [anon_sym_as] = ACTIONS(26),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(714),
    [anon_sym_COMMA] = ACTIONS(32),
    [anon_sym_typeof] = ACTIONS(82),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(38),
    [anon_sym_LPAREN] = ACTIONS(716),
    [anon_sym_RPAREN] = ACTIONS(32),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_in] = ACTIONS(26),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_COLON] = ACTIONS(32),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(719),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(722),
    [anon_sym_GT] = ACTIONS(26),
    [anon_sym_SLASH] = ACTIONS(53),
    [anon_sym_DOT] = ACTIONS(26),
    [anon_sym_class] = ACTIONS(56),
    [anon_sym_async] = ACTIONS(58),
    [anon_sym_function] = ACTIONS(60),
    [anon_sym_EQ_GT] = ACTIONS(62),
    [anon_sym_QMARK_DOT] = ACTIONS(64),
    [anon_sym_new] = ACTIONS(725),
    [anon_sym_PLUS_EQ] = ACTIONS(68),
    [anon_sym_DASH_EQ] = ACTIONS(68),
    [anon_sym_STAR_EQ] = ACTIONS(68),
    [anon_sym_SLASH_EQ] = ACTIONS(68),
    [anon_sym_PERCENT_EQ] = ACTIONS(68),
    [anon_sym_CARET_EQ] = ACTIONS(68),
    [anon_sym_AMP_EQ] = ACTIONS(68),
    [anon_sym_PIPE_EQ] = ACTIONS(68),
    [anon_sym_GT_GT_EQ] = ACTIONS(68),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(68),
    [anon_sym_LT_LT_EQ] = ACTIONS(68),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(68),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(68),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(68),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(68),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(70),
    [anon_sym_AMP_AMP] = ACTIONS(26),
    [anon_sym_PIPE_PIPE] = ACTIONS(26),
    [anon_sym_GT_GT] = ACTIONS(26),
    [anon_sym_GT_GT_GT] = ACTIONS(26),
    [anon_sym_LT_LT] = ACTIONS(26),
    [anon_sym_AMP] = ACTIONS(26),
    [anon_sym_CARET] = ACTIONS(26),
    [anon_sym_PIPE] = ACTIONS(26),
    [anon_sym_PLUS] = ACTIONS(38),
    [anon_sym_DASH] = ACTIONS(38),
    [anon_sym_PERCENT] = ACTIONS(26),
    [anon_sym_STAR_STAR] = ACTIONS(26),
    [anon_sym_LT_EQ] = ACTIONS(64),
    [anon_sym_EQ_EQ] = ACTIONS(26),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(64),
    [anon_sym_BANG_EQ] = ACTIONS(26),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(64),
    [anon_sym_QMARK_QMARK] = ACTIONS(26),
    [anon_sym_instanceof] = ACTIONS(26),
    [anon_sym_TILDE] = ACTIONS(78),
    [anon_sym_void] = ACTIONS(82),
    [anon_sym_delete] = ACTIONS(82),
    [anon_sym_PLUS_PLUS] = ACTIONS(84),
    [anon_sym_DASH_DASH] = ACTIONS(84),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_SQUOTE] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(727),
    [sym_number] = ACTIONS(730),
    [sym_this] = ACTIONS(748),
    [sym_super] = ACTIONS(97),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(734),
    [anon_sym_AT] = ACTIONS(103),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(19),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(736),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(19),
    [anon_sym_private] = ACTIONS(19),
    [anon_sym_protected] = ACTIONS(19),
    [anon_sym_override] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(19),
    [anon_sym_number] = ACTIONS(19),
    [anon_sym_boolean] = ACTIONS(19),
    [anon_sym_string] = ACTIONS(19),
    [anon_sym_symbol] = ACTIONS(19),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [sym__ternary_qmark] = ACTIONS(64),
  },
  [79] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_expression] = STATE(1793),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3363),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3363),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_nested_identifier] = STATE(4870),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4737),
    [sym__formal_parameter] = STATE(3997),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1242),
    [sym_subscript_expression] = STATE(1242),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2861),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3363),
    [sym_ternary_expression] = STATE(1751),
    [sym_binary_expression] = STATE(1751),
    [sym_unary_expression] = STATE(1751),
    [sym_update_expression] = STATE(1751),
    [sym_sequence_expression] = STATE(4730),
    [sym_string] = STATE(2181),
    [sym_template_string] = STATE(1752),
    [sym_regex] = STATE(1752),
    [sym_meta_property] = STATE(1752),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3846),
    [sym_pattern] = STATE(3578),
    [sym_rest_pattern] = STATE(3298),
    [sym_non_null_expression] = STATE(1242),
    [sym_type_assertion] = STATE(1751),
    [sym_as_expression] = STATE(1751),
    [sym_internal_module] = STATE(1751),
    [sym_nested_type_identifier] = STATE(2837),
    [sym_accessibility_modifier] = STATE(229),
    [sym_override_modifier] = STATE(233),
    [sym_required_parameter] = STATE(3997),
    [sym_optional_parameter] = STATE(3997),
    [sym__parameter_name] = STATE(3325),
    [sym__type] = STATE(3860),
    [sym_constructor_type] = STATE(3860),
    [sym__primary_type] = STATE(2839),
    [sym_template_literal_type] = STATE(2840),
    [sym_infer_type] = STATE(3860),
    [sym_conditional_type] = STATE(2840),
    [sym_generic_type] = STATE(2840),
    [sym_type_query] = STATE(2840),
    [sym_index_type_query] = STATE(2840),
    [sym_lookup_type] = STATE(2840),
    [sym_literal_type] = STATE(2840),
    [sym__number] = STATE(2880),
    [sym_existential_type] = STATE(2840),
    [sym_flow_maybe_type] = STATE(2840),
    [sym_parenthesized_type] = STATE(2840),
    [sym_predefined_type] = STATE(2840),
    [sym_type_arguments] = STATE(516),
    [sym_object_type] = STATE(2840),
    [sym_type_parameters] = STATE(4567),
    [sym_array_type] = STATE(2840),
    [sym_tuple_type] = STATE(2840),
    [sym_readonly_type] = STATE(3860),
    [sym_union_type] = STATE(2840),
    [sym_intersection_type] = STATE(2840),
    [sym_function_type] = STATE(3860),
    [aux_sym_export_statement_repeat1] = STATE(218),
    [sym_identifier] = ACTIONS(750),
    [anon_sym_export] = ACTIONS(640),
    [anon_sym_STAR] = ACTIONS(642),
    [anon_sym_type] = ACTIONS(640),
    [anon_sym_namespace] = ACTIONS(644),
    [anon_sym_LBRACE] = ACTIONS(752),
    [anon_sym_typeof] = ACTIONS(754),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(640),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(756),
    [anon_sym_await] = ACTIONS(654),
    [anon_sym_of] = ACTIONS(640),
    [anon_sym_yield] = ACTIONS(656),
    [anon_sym_LBRACK] = ACTIONS(758),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(662),
    [anon_sym_class] = ACTIONS(56),
    [anon_sym_async] = ACTIONS(664),
    [anon_sym_function] = ACTIONS(60),
    [anon_sym_new] = ACTIONS(666),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(70),
    [anon_sym_AMP] = ACTIONS(670),
    [anon_sym_PIPE] = ACTIONS(672),
    [anon_sym_PLUS] = ACTIONS(760),
    [anon_sym_DASH] = ACTIONS(760),
    [anon_sym_TILDE] = ACTIONS(652),
    [anon_sym_void] = ACTIONS(676),
    [anon_sym_delete] = ACTIONS(678),
    [anon_sym_PLUS_PLUS] = ACTIONS(680),
    [anon_sym_DASH_DASH] = ACTIONS(680),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_SQUOTE] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(762),
    [sym_number] = ACTIONS(764),
    [sym_this] = ACTIONS(766),
    [sym_super] = ACTIONS(97),
    [sym_true] = ACTIONS(768),
    [sym_false] = ACTIONS(768),
    [sym_null] = ACTIONS(768),
    [sym_undefined] = ACTIONS(770),
    [anon_sym_AT] = ACTIONS(772),
    [anon_sym_static] = ACTIONS(640),
    [anon_sym_readonly] = ACTIONS(774),
    [anon_sym_get] = ACTIONS(640),
    [anon_sym_set] = ACTIONS(640),
    [anon_sym_QMARK] = ACTIONS(688),
    [anon_sym_declare] = ACTIONS(640),
    [anon_sym_public] = ACTIONS(776),
    [anon_sym_private] = ACTIONS(776),
    [anon_sym_protected] = ACTIONS(776),
    [anon_sym_override] = ACTIONS(778),
    [anon_sym_module] = ACTIONS(640),
    [anon_sym_any] = ACTIONS(780),
    [anon_sym_number] = ACTIONS(780),
    [anon_sym_boolean] = ACTIONS(780),
    [anon_sym_string] = ACTIONS(780),
    [anon_sym_symbol] = ACTIONS(780),
    [anon_sym_property] = ACTIONS(640),
    [anon_sym_signal] = ACTIONS(640),
    [anon_sym_on] = ACTIONS(640),
    [anon_sym_required] = ACTIONS(640),
    [anon_sym_component] = ACTIONS(640),
    [anon_sym_abstract] = ACTIONS(111),
    [anon_sym_infer] = ACTIONS(113),
    [anon_sym_keyof] = ACTIONS(115),
    [anon_sym_unknown] = ACTIONS(117),
    [anon_sym_never] = ACTIONS(117),
    [anon_sym_object] = ACTIONS(117),
    [anon_sym_LBRACE_PIPE] = ACTIONS(119),
  },
  [80] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_expression] = STATE(1733),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3363),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3363),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_nested_identifier] = STATE(4870),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4737),
    [sym__formal_parameter] = STATE(3997),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1242),
    [sym_subscript_expression] = STATE(1242),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2861),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3363),
    [sym_ternary_expression] = STATE(1751),
    [sym_binary_expression] = STATE(1751),
    [sym_unary_expression] = STATE(1751),
    [sym_update_expression] = STATE(1751),
    [sym_sequence_expression] = STATE(4701),
    [sym_string] = STATE(2181),
    [sym_template_string] = STATE(1752),
    [sym_regex] = STATE(1752),
    [sym_meta_property] = STATE(1752),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3846),
    [sym_pattern] = STATE(3578),
    [sym_rest_pattern] = STATE(3298),
    [sym_non_null_expression] = STATE(1242),
    [sym_type_assertion] = STATE(1751),
    [sym_as_expression] = STATE(1751),
    [sym_internal_module] = STATE(1751),
    [sym_nested_type_identifier] = STATE(2837),
    [sym_accessibility_modifier] = STATE(229),
    [sym_override_modifier] = STATE(233),
    [sym_required_parameter] = STATE(3997),
    [sym_optional_parameter] = STATE(3997),
    [sym__parameter_name] = STATE(3325),
    [sym__type] = STATE(3860),
    [sym_constructor_type] = STATE(3860),
    [sym__primary_type] = STATE(2839),
    [sym_template_literal_type] = STATE(2840),
    [sym_infer_type] = STATE(3860),
    [sym_conditional_type] = STATE(2840),
    [sym_generic_type] = STATE(2840),
    [sym_type_query] = STATE(2840),
    [sym_index_type_query] = STATE(2840),
    [sym_lookup_type] = STATE(2840),
    [sym_literal_type] = STATE(2840),
    [sym__number] = STATE(2880),
    [sym_existential_type] = STATE(2840),
    [sym_flow_maybe_type] = STATE(2840),
    [sym_parenthesized_type] = STATE(2840),
    [sym_predefined_type] = STATE(2840),
    [sym_type_arguments] = STATE(516),
    [sym_object_type] = STATE(2840),
    [sym_type_parameters] = STATE(4567),
    [sym_array_type] = STATE(2840),
    [sym_tuple_type] = STATE(2840),
    [sym_readonly_type] = STATE(3860),
    [sym_union_type] = STATE(2840),
    [sym_intersection_type] = STATE(2840),
    [sym_function_type] = STATE(3860),
    [aux_sym_export_statement_repeat1] = STATE(218),
    [sym_identifier] = ACTIONS(750),
    [anon_sym_export] = ACTIONS(640),
    [anon_sym_STAR] = ACTIONS(642),
    [anon_sym_type] = ACTIONS(640),
    [anon_sym_namespace] = ACTIONS(644),
    [anon_sym_LBRACE] = ACTIONS(752),
    [anon_sym_typeof] = ACTIONS(754),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(640),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(756),
    [anon_sym_await] = ACTIONS(654),
    [anon_sym_of] = ACTIONS(640),
    [anon_sym_yield] = ACTIONS(656),
    [anon_sym_LBRACK] = ACTIONS(758),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(662),
    [anon_sym_class] = ACTIONS(56),
    [anon_sym_async] = ACTIONS(664),
    [anon_sym_function] = ACTIONS(60),
    [anon_sym_new] = ACTIONS(666),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(70),
    [anon_sym_AMP] = ACTIONS(670),
    [anon_sym_PIPE] = ACTIONS(672),
    [anon_sym_PLUS] = ACTIONS(760),
    [anon_sym_DASH] = ACTIONS(760),
    [anon_sym_TILDE] = ACTIONS(652),
    [anon_sym_void] = ACTIONS(676),
    [anon_sym_delete] = ACTIONS(678),
    [anon_sym_PLUS_PLUS] = ACTIONS(680),
    [anon_sym_DASH_DASH] = ACTIONS(680),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_SQUOTE] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(762),
    [sym_number] = ACTIONS(764),
    [sym_this] = ACTIONS(766),
    [sym_super] = ACTIONS(97),
    [sym_true] = ACTIONS(768),
    [sym_false] = ACTIONS(768),
    [sym_null] = ACTIONS(768),
    [sym_undefined] = ACTIONS(770),
    [anon_sym_AT] = ACTIONS(772),
    [anon_sym_static] = ACTIONS(640),
    [anon_sym_readonly] = ACTIONS(774),
    [anon_sym_get] = ACTIONS(640),
    [anon_sym_set] = ACTIONS(640),
    [anon_sym_QMARK] = ACTIONS(688),
    [anon_sym_declare] = ACTIONS(640),
    [anon_sym_public] = ACTIONS(776),
    [anon_sym_private] = ACTIONS(776),
    [anon_sym_protected] = ACTIONS(776),
    [anon_sym_override] = ACTIONS(778),
    [anon_sym_module] = ACTIONS(640),
    [anon_sym_any] = ACTIONS(780),
    [anon_sym_number] = ACTIONS(780),
    [anon_sym_boolean] = ACTIONS(780),
    [anon_sym_string] = ACTIONS(780),
    [anon_sym_symbol] = ACTIONS(780),
    [anon_sym_property] = ACTIONS(640),
    [anon_sym_signal] = ACTIONS(640),
    [anon_sym_on] = ACTIONS(640),
    [anon_sym_required] = ACTIONS(640),
    [anon_sym_component] = ACTIONS(640),
    [anon_sym_abstract] = ACTIONS(111),
    [anon_sym_infer] = ACTIONS(113),
    [anon_sym_keyof] = ACTIONS(115),
    [anon_sym_unknown] = ACTIONS(117),
    [anon_sym_never] = ACTIONS(117),
    [anon_sym_object] = ACTIONS(117),
    [anon_sym_LBRACE_PIPE] = ACTIONS(119),
  },
  [81] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_expression] = STATE(1793),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3363),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3363),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_nested_identifier] = STATE(4870),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4737),
    [sym__formal_parameter] = STATE(3997),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1242),
    [sym_subscript_expression] = STATE(1242),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2861),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3363),
    [sym_ternary_expression] = STATE(1751),
    [sym_binary_expression] = STATE(1751),
    [sym_unary_expression] = STATE(1751),
    [sym_update_expression] = STATE(1751),
    [sym_sequence_expression] = STATE(4730),
    [sym_string] = STATE(2181),
    [sym_template_string] = STATE(1752),
    [sym_regex] = STATE(1752),
    [sym_meta_property] = STATE(1752),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3846),
    [sym_pattern] = STATE(3578),
    [sym_rest_pattern] = STATE(3298),
    [sym_non_null_expression] = STATE(1242),
    [sym_type_assertion] = STATE(1751),
    [sym_as_expression] = STATE(1751),
    [sym_internal_module] = STATE(1751),
    [sym_nested_type_identifier] = STATE(2837),
    [sym_accessibility_modifier] = STATE(229),
    [sym_override_modifier] = STATE(233),
    [sym_required_parameter] = STATE(3997),
    [sym_optional_parameter] = STATE(3997),
    [sym__parameter_name] = STATE(3325),
    [sym__type] = STATE(3909),
    [sym_constructor_type] = STATE(3909),
    [sym__primary_type] = STATE(2839),
    [sym_template_literal_type] = STATE(2840),
    [sym_infer_type] = STATE(3909),
    [sym_conditional_type] = STATE(2840),
    [sym_generic_type] = STATE(2840),
    [sym_type_query] = STATE(2840),
    [sym_index_type_query] = STATE(2840),
    [sym_lookup_type] = STATE(2840),
    [sym_literal_type] = STATE(2840),
    [sym__number] = STATE(2880),
    [sym_existential_type] = STATE(2840),
    [sym_flow_maybe_type] = STATE(2840),
    [sym_parenthesized_type] = STATE(2840),
    [sym_predefined_type] = STATE(2840),
    [sym_type_arguments] = STATE(516),
    [sym_object_type] = STATE(2840),
    [sym_type_parameters] = STATE(4567),
    [sym_array_type] = STATE(2840),
    [sym_tuple_type] = STATE(2840),
    [sym_readonly_type] = STATE(3909),
    [sym_union_type] = STATE(2840),
    [sym_intersection_type] = STATE(2840),
    [sym_function_type] = STATE(3909),
    [aux_sym_export_statement_repeat1] = STATE(218),
    [sym_identifier] = ACTIONS(750),
    [anon_sym_export] = ACTIONS(640),
    [anon_sym_STAR] = ACTIONS(642),
    [anon_sym_type] = ACTIONS(640),
    [anon_sym_namespace] = ACTIONS(644),
    [anon_sym_LBRACE] = ACTIONS(752),
    [anon_sym_typeof] = ACTIONS(754),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(640),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(756),
    [anon_sym_await] = ACTIONS(654),
    [anon_sym_of] = ACTIONS(640),
    [anon_sym_yield] = ACTIONS(656),
    [anon_sym_LBRACK] = ACTIONS(758),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(662),
    [anon_sym_class] = ACTIONS(56),
    [anon_sym_async] = ACTIONS(664),
    [anon_sym_function] = ACTIONS(60),
    [anon_sym_new] = ACTIONS(666),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(70),
    [anon_sym_AMP] = ACTIONS(670),
    [anon_sym_PIPE] = ACTIONS(672),
    [anon_sym_PLUS] = ACTIONS(760),
    [anon_sym_DASH] = ACTIONS(760),
    [anon_sym_TILDE] = ACTIONS(652),
    [anon_sym_void] = ACTIONS(676),
    [anon_sym_delete] = ACTIONS(678),
    [anon_sym_PLUS_PLUS] = ACTIONS(680),
    [anon_sym_DASH_DASH] = ACTIONS(680),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_SQUOTE] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(762),
    [sym_number] = ACTIONS(764),
    [sym_this] = ACTIONS(766),
    [sym_super] = ACTIONS(97),
    [sym_true] = ACTIONS(768),
    [sym_false] = ACTIONS(768),
    [sym_null] = ACTIONS(768),
    [sym_undefined] = ACTIONS(770),
    [anon_sym_AT] = ACTIONS(772),
    [anon_sym_static] = ACTIONS(640),
    [anon_sym_readonly] = ACTIONS(774),
    [anon_sym_get] = ACTIONS(640),
    [anon_sym_set] = ACTIONS(640),
    [anon_sym_QMARK] = ACTIONS(688),
    [anon_sym_declare] = ACTIONS(640),
    [anon_sym_public] = ACTIONS(776),
    [anon_sym_private] = ACTIONS(776),
    [anon_sym_protected] = ACTIONS(776),
    [anon_sym_override] = ACTIONS(778),
    [anon_sym_module] = ACTIONS(640),
    [anon_sym_any] = ACTIONS(780),
    [anon_sym_number] = ACTIONS(780),
    [anon_sym_boolean] = ACTIONS(780),
    [anon_sym_string] = ACTIONS(780),
    [anon_sym_symbol] = ACTIONS(780),
    [anon_sym_property] = ACTIONS(640),
    [anon_sym_signal] = ACTIONS(640),
    [anon_sym_on] = ACTIONS(640),
    [anon_sym_required] = ACTIONS(640),
    [anon_sym_component] = ACTIONS(640),
    [anon_sym_abstract] = ACTIONS(111),
    [anon_sym_infer] = ACTIONS(113),
    [anon_sym_keyof] = ACTIONS(115),
    [anon_sym_unknown] = ACTIONS(117),
    [anon_sym_never] = ACTIONS(117),
    [anon_sym_object] = ACTIONS(117),
    [anon_sym_LBRACE_PIPE] = ACTIONS(119),
  },
  [82] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1175),
    [sym_expression] = STATE(2338),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3296),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3296),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_nested_identifier] = STATE(4870),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4895),
    [sym__formal_parameter] = STATE(3997),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1240),
    [sym_subscript_expression] = STATE(1240),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2865),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3296),
    [sym_ternary_expression] = STATE(1751),
    [sym_binary_expression] = STATE(1751),
    [sym_unary_expression] = STATE(1751),
    [sym_update_expression] = STATE(1751),
    [sym_string] = STATE(2176),
    [sym_template_string] = STATE(1752),
    [sym_regex] = STATE(1752),
    [sym_meta_property] = STATE(1752),
    [sym_decorator] = STATE(1128),
    [sym_formal_parameters] = STATE(3846),
    [sym_pattern] = STATE(3578),
    [sym_rest_pattern] = STATE(3298),
    [sym_non_null_expression] = STATE(1240),
    [sym_type_assertion] = STATE(1751),
    [sym_as_expression] = STATE(1751),
    [sym_internal_module] = STATE(1751),
    [sym_nested_type_identifier] = STATE(2837),
    [sym_accessibility_modifier] = STATE(229),
    [sym_override_modifier] = STATE(233),
    [sym_required_parameter] = STATE(3997),
    [sym_optional_parameter] = STATE(3997),
    [sym__parameter_name] = STATE(3325),
    [sym__type] = STATE(3854),
    [sym_constructor_type] = STATE(3854),
    [sym__primary_type] = STATE(2839),
    [sym_template_literal_type] = STATE(2840),
    [sym_infer_type] = STATE(3854),
    [sym_conditional_type] = STATE(2840),
    [sym_generic_type] = STATE(2840),
    [sym_type_query] = STATE(2840),
    [sym_index_type_query] = STATE(2840),
    [sym_lookup_type] = STATE(2840),
    [sym_literal_type] = STATE(2840),
    [sym__number] = STATE(2880),
    [sym_existential_type] = STATE(2840),
    [sym_flow_maybe_type] = STATE(2840),
    [sym_parenthesized_type] = STATE(2840),
    [sym_predefined_type] = STATE(2840),
    [sym_type_arguments] = STATE(463),
    [sym_object_type] = STATE(2840),
    [sym_type_parameters] = STATE(4567),
    [sym_array_type] = STATE(2840),
    [sym_tuple_type] = STATE(2840),
    [sym_readonly_type] = STATE(3854),
    [sym_union_type] = STATE(2840),
    [sym_intersection_type] = STATE(2840),
    [sym_function_type] = STATE(3854),
    [aux_sym_export_statement_repeat1] = STATE(218),
    [sym_identifier] = ACTIONS(17),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(642),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(30),
    [anon_sym_typeof] = ACTIONS(34),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(78),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(756),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_LTtemplate_GT] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(662),
    [anon_sym_class] = ACTIONS(56),
    [anon_sym_async] = ACTIONS(58),
    [anon_sym_function] = ACTIONS(60),
    [anon_sym_new] = ACTIONS(66),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(70),
    [anon_sym_AMP] = ACTIONS(670),
    [anon_sym_PIPE] = ACTIONS(672),
    [anon_sym_PLUS] = ACTIONS(76),
    [anon_sym_DASH] = ACTIONS(76),
    [anon_sym_TILDE] = ACTIONS(78),
    [anon_sym_void] = ACTIONS(80),
    [anon_sym_delete] = ACTIONS(82),
    [anon_sym_PLUS_PLUS] = ACTIONS(782),
    [anon_sym_DASH_DASH] = ACTIONS(782),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_SQUOTE] = ACTIONS(89),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(91),
    [sym_number] = ACTIONS(93),
    [sym_this] = ACTIONS(784),
    [sym_super] = ACTIONS(97),
    [sym_true] = ACTIONS(99),
    [sym_false] = ACTIONS(99),
    [sym_null] = ACTIONS(99),
    [sym_undefined] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(772),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(786),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(688),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(788),
    [anon_sym_private] = ACTIONS(788),
    [anon_sym_protected] = ACTIONS(788),
    [anon_sym_override] = ACTIONS(790),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(109),
    [anon_sym_number] = ACTIONS(109),
    [anon_sym_boolean] = ACTIONS(109),
    [anon_sym_string] = ACTIONS(109),
    [anon_sym_symbol] = ACTIONS(109),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [anon_sym_abstract] = ACTIONS(111),
    [anon_sym_infer] = ACTIONS(113),
    [anon_sym_keyof] = ACTIONS(115),
    [anon_sym_unknown] = ACTIONS(117),
    [anon_sym_never] = ACTIONS(117),
    [anon_sym_object] = ACTIONS(117),
    [anon_sym_LBRACE_PIPE] = ACTIONS(119),
  },
  [83] = {
    [sym_import] = STATE(1752),
    [sym_parenthesized_expression] = STATE(1175),
    [sym_expression] = STATE(2338),
    [sym_primary_expression] = STATE(1562),
    [sym_yield_expression] = STATE(1751),
    [sym_object] = STATE(1752),
    [sym_object_pattern] = STATE(3296),
    [sym_array] = STATE(1752),
    [sym_array_pattern] = STATE(3296),
    [sym_glimmer_template] = STATE(1751),
    [sym_glimmer_opening_tag] = STATE(3874),
    [sym_nested_identifier] = STATE(4870),
    [sym_class] = STATE(1752),
    [sym_function] = STATE(1752),
    [sym_generator_function] = STATE(1752),
    [sym_arrow_function] = STATE(1752),
    [sym__call_signature] = STATE(4895),
    [sym__formal_parameter] = STATE(3997),
    [sym_call_expression] = STATE(1752),
    [sym_new_expression] = STATE(1751),
    [sym_await_expression] = STATE(1751),
    [sym_member_expression] = STATE(1240),
    [sym_subscript_expression] = STATE(1240),
    [sym_assignment_expression] = STATE(1751),
    [sym__augmented_assignment_lhs] = STATE(2865),
    [sym_augmented_assignment_expression] = STATE(1751),
    [sym__destructuring_pattern] = STATE(3296),
    [sym_ternary_expression] = STATE(1751),
    