{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A render node repeating its single child node.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.RepeatNode
    ( 

-- * Exported types
    RepeatNode(..)                          ,
    IsRepeatNode                            ,
    toRepeatNode                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [draw]("GI.Gsk.Objects.RenderNode#g:method:draw"), [ref]("GI.Gsk.Objects.RenderNode#g:method:ref"), [serialize]("GI.Gsk.Objects.RenderNode#g:method:serialize"), [unref]("GI.Gsk.Objects.RenderNode#g:method:unref"), [writeToFile]("GI.Gsk.Objects.RenderNode#g:method:writeToFile").
-- 
-- ==== Getters
-- [getBounds]("GI.Gsk.Objects.RenderNode#g:method:getBounds"), [getChild]("GI.Gsk.Objects.RepeatNode#g:method:getChild"), [getChildBounds]("GI.Gsk.Objects.RepeatNode#g:method:getChildBounds"), [getNodeType]("GI.Gsk.Objects.RenderNode#g:method:getNodeType"), [getOpaqueRect]("GI.Gsk.Objects.RenderNode#g:method:getOpaqueRect").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveRepeatNodeMethod                 ,
#endif

-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    RepeatNodeGetChildMethodInfo            ,
#endif
    repeatNodeGetChild                      ,


-- ** getChildBounds #method:getChildBounds#

#if defined(ENABLE_OVERLOADING)
    RepeatNodeGetChildBoundsMethodInfo      ,
#endif
    repeatNodeGetChildBounds                ,


-- ** new #method:new#

    repeatNodeNew                           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#else
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#endif

-- | Memory-managed wrapper type.
newtype RepeatNode = RepeatNode (SP.ManagedPtr RepeatNode)
    deriving (Eq)

instance SP.ManagedPtrNewtype RepeatNode where
    toManagedPtr (RepeatNode p) = p

foreign import ccall "gsk_repeat_node_get_type"
    c_gsk_repeat_node_get_type :: IO B.Types.GType

instance B.Types.TypedObject RepeatNode where
    glibType = c_gsk_repeat_node_get_type

-- | Type class for types which can be safely cast to t'RepeatNode', for instance with `toRepeatNode`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf RepeatNode o) => IsRepeatNode o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf RepeatNode o) => IsRepeatNode o

instance O.HasParentTypes RepeatNode
type instance O.ParentTypes RepeatNode = '[Gsk.RenderNode.RenderNode]

-- | Cast to t'RepeatNode', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toRepeatNode :: (MIO.MonadIO m, IsRepeatNode o) => o -> m RepeatNode
toRepeatNode = MIO.liftIO . B.ManagedPtr.unsafeCastTo RepeatNode

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveRepeatNodeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveRepeatNodeMethod "draw" o = Gsk.RenderNode.RenderNodeDrawMethodInfo
    ResolveRepeatNodeMethod "ref" o = Gsk.RenderNode.RenderNodeRefMethodInfo
    ResolveRepeatNodeMethod "serialize" o = Gsk.RenderNode.RenderNodeSerializeMethodInfo
    ResolveRepeatNodeMethod "unref" o = Gsk.RenderNode.RenderNodeUnrefMethodInfo
    ResolveRepeatNodeMethod "writeToFile" o = Gsk.RenderNode.RenderNodeWriteToFileMethodInfo
    ResolveRepeatNodeMethod "getBounds" o = Gsk.RenderNode.RenderNodeGetBoundsMethodInfo
    ResolveRepeatNodeMethod "getChild" o = RepeatNodeGetChildMethodInfo
    ResolveRepeatNodeMethod "getChildBounds" o = RepeatNodeGetChildBoundsMethodInfo
    ResolveRepeatNodeMethod "getNodeType" o = Gsk.RenderNode.RenderNodeGetNodeTypeMethodInfo
    ResolveRepeatNodeMethod "getOpaqueRect" o = Gsk.RenderNode.RenderNodeGetOpaqueRectMethodInfo
    ResolveRepeatNodeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveRepeatNodeMethod t RepeatNode, O.OverloadedMethod info RepeatNode p) => OL.IsLabel t (RepeatNode -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveRepeatNodeMethod t RepeatNode, O.OverloadedMethod info RepeatNode p, R.HasField t RepeatNode p) => R.HasField t RepeatNode p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveRepeatNodeMethod t RepeatNode, O.OverloadedMethodInfo info RepeatNode) => OL.IsLabel t (O.MethodProxy info RepeatNode) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr RepeatNode where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method RepeatNode::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "bounds"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The bounds of the area to be painted"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RenderNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The child to repeat"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child_bounds"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The area of the child to repeat or %NULL to\n    use the child's bounds"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "RepeatNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_repeat_node_new" gsk_repeat_node_new :: 
    Ptr Graphene.Rect.Rect ->               -- bounds : TInterface (Name {namespace = "Graphene", name = "Rect"})
    Ptr Gsk.RenderNode.RenderNode ->        -- child : TInterface (Name {namespace = "Gsk", name = "RenderNode"})
    Ptr Graphene.Rect.Rect ->               -- child_bounds : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO (Ptr RepeatNode)

-- | Creates a @GskRenderNode@ that will repeat the drawing of /@child@/ across
-- the given /@bounds@/.
repeatNodeNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gsk.RenderNode.IsRenderNode a) =>
    Graphene.Rect.Rect
    -- ^ /@bounds@/: The bounds of the area to be painted
    -> a
    -- ^ /@child@/: The child to repeat
    -> Maybe (Graphene.Rect.Rect)
    -- ^ /@childBounds@/: The area of the child to repeat or 'P.Nothing' to
    --     use the child\'s bounds
    -> m RepeatNode
    -- ^ __Returns:__ A new @GskRenderNode@
repeatNodeNew bounds child childBounds = liftIO $ do
    bounds' <- unsafeManagedPtrGetPtr bounds
    child' <- unsafeManagedPtrCastPtr child
    maybeChildBounds <- case childBounds of
        Nothing -> return FP.nullPtr
        Just jChildBounds -> do
            jChildBounds' <- unsafeManagedPtrGetPtr jChildBounds
            return jChildBounds'
    result <- gsk_repeat_node_new bounds' child' maybeChildBounds
    checkUnexpectedReturnNULL "repeatNodeNew" result
    result' <- (wrapPtr RepeatNode) result
    touchManagedPtr bounds
    touchManagedPtr child
    whenJust childBounds touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method RepeatNode::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RepeatNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a repeat `GskRenderNode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "RenderNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_repeat_node_get_child" gsk_repeat_node_get_child :: 
    Ptr RepeatNode ->                       -- node : TInterface (Name {namespace = "Gsk", name = "RepeatNode"})
    IO (Ptr Gsk.RenderNode.RenderNode)

-- | Retrieves the child of /@node@/.
repeatNodeGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsRepeatNode a) =>
    a
    -- ^ /@node@/: a repeat @GskRenderNode@
    -> m Gsk.RenderNode.RenderNode
    -- ^ __Returns:__ a @GskRenderNode@
repeatNodeGetChild node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_repeat_node_get_child node'
    checkUnexpectedReturnNULL "repeatNodeGetChild" result
    result' <- (newPtr Gsk.RenderNode.RenderNode) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data RepeatNodeGetChildMethodInfo
instance (signature ~ (m Gsk.RenderNode.RenderNode), MonadIO m, IsRepeatNode a) => O.OverloadedMethod RepeatNodeGetChildMethodInfo a signature where
    overloadedMethod = repeatNodeGetChild

instance O.OverloadedMethodInfo RepeatNodeGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.RepeatNode.repeatNodeGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-RepeatNode.html#v:repeatNodeGetChild"
        })


#endif

-- method RepeatNode::get_child_bounds
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RepeatNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a repeat `GskRenderNode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Rect" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_repeat_node_get_child_bounds" gsk_repeat_node_get_child_bounds :: 
    Ptr RepeatNode ->                       -- node : TInterface (Name {namespace = "Gsk", name = "RepeatNode"})
    IO (Ptr Graphene.Rect.Rect)

-- | Retrieves the bounding rectangle of the child of /@node@/.
repeatNodeGetChildBounds ::
    (B.CallStack.HasCallStack, MonadIO m, IsRepeatNode a) =>
    a
    -- ^ /@node@/: a repeat @GskRenderNode@
    -> m Graphene.Rect.Rect
    -- ^ __Returns:__ a bounding rectangle
repeatNodeGetChildBounds node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_repeat_node_get_child_bounds node'
    checkUnexpectedReturnNULL "repeatNodeGetChildBounds" result
    result' <- (newBoxed Graphene.Rect.Rect) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data RepeatNodeGetChildBoundsMethodInfo
instance (signature ~ (m Graphene.Rect.Rect), MonadIO m, IsRepeatNode a) => O.OverloadedMethod RepeatNodeGetChildBoundsMethodInfo a signature where
    overloadedMethod = repeatNodeGetChildBounds

instance O.OverloadedMethodInfo RepeatNodeGetChildBoundsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.RepeatNode.repeatNodeGetChildBounds",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-RepeatNode.html#v:repeatNodeGetChildBounds"
        })


#endif


