{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A 2D plane that extends infinitely in a 3D volume.
-- 
-- The contents of the @graphene_plane_t@ are private, and should not be
-- modified directly.
-- 
-- /Since: 1.2/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Graphene.Structs.Plane
    ( 

-- * Exported types
    Plane(..)                               ,
    newZeroPlane                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [distance]("GI.Graphene.Structs.Plane#g:method:distance"), [equal]("GI.Graphene.Structs.Plane#g:method:equal"), [free]("GI.Graphene.Structs.Plane#g:method:free"), [init]("GI.Graphene.Structs.Plane#g:method:init"), [initFromPlane]("GI.Graphene.Structs.Plane#g:method:initFromPlane"), [initFromPoint]("GI.Graphene.Structs.Plane#g:method:initFromPoint"), [initFromPoints]("GI.Graphene.Structs.Plane#g:method:initFromPoints"), [initFromVec4]("GI.Graphene.Structs.Plane#g:method:initFromVec4"), [negate]("GI.Graphene.Structs.Plane#g:method:negate"), [normalize]("GI.Graphene.Structs.Plane#g:method:normalize"), [transform]("GI.Graphene.Structs.Plane#g:method:transform").
-- 
-- ==== Getters
-- [getConstant]("GI.Graphene.Structs.Plane#g:method:getConstant"), [getNormal]("GI.Graphene.Structs.Plane#g:method:getNormal").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolvePlaneMethod                      ,
#endif

-- ** alloc #method:alloc#

    planeAlloc                              ,


-- ** distance #method:distance#

#if defined(ENABLE_OVERLOADING)
    PlaneDistanceMethodInfo                 ,
#endif
    planeDistance                           ,


-- ** equal #method:equal#

#if defined(ENABLE_OVERLOADING)
    PlaneEqualMethodInfo                    ,
#endif
    planeEqual                              ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    PlaneFreeMethodInfo                     ,
#endif
    planeFree                               ,


-- ** getConstant #method:getConstant#

#if defined(ENABLE_OVERLOADING)
    PlaneGetConstantMethodInfo              ,
#endif
    planeGetConstant                        ,


-- ** getNormal #method:getNormal#

#if defined(ENABLE_OVERLOADING)
    PlaneGetNormalMethodInfo                ,
#endif
    planeGetNormal                          ,


-- ** init #method:init#

#if defined(ENABLE_OVERLOADING)
    PlaneInitMethodInfo                     ,
#endif
    planeInit                               ,


-- ** initFromPlane #method:initFromPlane#

#if defined(ENABLE_OVERLOADING)
    PlaneInitFromPlaneMethodInfo            ,
#endif
    planeInitFromPlane                      ,


-- ** initFromPoint #method:initFromPoint#

#if defined(ENABLE_OVERLOADING)
    PlaneInitFromPointMethodInfo            ,
#endif
    planeInitFromPoint                      ,


-- ** initFromPoints #method:initFromPoints#

#if defined(ENABLE_OVERLOADING)
    PlaneInitFromPointsMethodInfo           ,
#endif
    planeInitFromPoints                     ,


-- ** initFromVec4 #method:initFromVec4#

#if defined(ENABLE_OVERLOADING)
    PlaneInitFromVec4MethodInfo             ,
#endif
    planeInitFromVec4                       ,


-- ** negate #method:negate#

#if defined(ENABLE_OVERLOADING)
    PlaneNegateMethodInfo                   ,
#endif
    planeNegate                             ,


-- ** normalize #method:normalize#

#if defined(ENABLE_OVERLOADING)
    PlaneNormalizeMethodInfo                ,
#endif
    planeNormalize                          ,


-- ** transform #method:transform#

#if defined(ENABLE_OVERLOADING)
    PlaneTransformMethodInfo                ,
#endif
    planeTransform                          ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Graphene.Enums as Graphene.Enums
import {-# SOURCE #-} qualified GI.Graphene.Structs.Box as Graphene.Box
import {-# SOURCE #-} qualified GI.Graphene.Structs.Euler as Graphene.Euler
import {-# SOURCE #-} qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import {-# SOURCE #-} qualified GI.Graphene.Structs.Point as Graphene.Point
import {-# SOURCE #-} qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import {-# SOURCE #-} qualified GI.Graphene.Structs.Quad as Graphene.Quad
import {-# SOURCE #-} qualified GI.Graphene.Structs.Quaternion as Graphene.Quaternion
import {-# SOURCE #-} qualified GI.Graphene.Structs.Ray as Graphene.Ray
import {-# SOURCE #-} qualified GI.Graphene.Structs.Rect as Graphene.Rect
import {-# SOURCE #-} qualified GI.Graphene.Structs.Size as Graphene.Size
import {-# SOURCE #-} qualified GI.Graphene.Structs.Sphere as Graphene.Sphere
import {-# SOURCE #-} qualified GI.Graphene.Structs.Triangle as Graphene.Triangle
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec2 as Graphene.Vec2
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4

#else
import {-# SOURCE #-} qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import {-# SOURCE #-} qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4

#endif

-- | Memory-managed wrapper type.
newtype Plane = Plane (SP.ManagedPtr Plane)
    deriving (Eq)

instance SP.ManagedPtrNewtype Plane where
    toManagedPtr (Plane p) = p

foreign import ccall "graphene_plane_get_type" c_graphene_plane_get_type :: 
    IO GType

type instance O.ParentTypes Plane = '[]
instance O.HasParentTypes Plane

instance B.Types.TypedObject Plane where
    glibType = c_graphene_plane_get_type

instance B.Types.GBoxed Plane

-- | Convert t'Plane' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Plane) where
    gvalueGType_ = c_graphene_plane_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr Plane)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr Plane)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed Plane ptr
        else return P.Nothing
        
    

-- | Construct a t'Plane' struct initialized to zero.
newZeroPlane :: MonadIO m => m Plane
newZeroPlane = liftIO $ callocBoxedBytes 20 >>= wrapBoxed Plane

instance tag ~ 'AttrSet => Constructible Plane tag where
    new _ attrs = do
        o <- newZeroPlane
        GI.Attributes.set o attrs
        return o



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Plane
type instance O.AttributeList Plane = PlaneAttributeList
type PlaneAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method Plane::alloc
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Plane" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_plane_alloc" graphene_plane_alloc :: 
    IO (Ptr Plane)

-- | Allocates a new t'GI.Graphene.Structs.Plane.Plane' structure.
-- 
-- The contents of the returned structure are undefined.
-- 
-- /Since: 1.2/
planeAlloc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Plane
    -- ^ __Returns:__ the newly allocated t'GI.Graphene.Structs.Plane.Plane'.
    --   Use 'GI.Graphene.Structs.Plane.planeFree' to free the resources allocated by
    --   this function
planeAlloc  = liftIO $ do
    result <- graphene_plane_alloc
    checkUnexpectedReturnNULL "planeAlloc" result
    result' <- (wrapBoxed Plane) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Plane::distance
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Plane" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_plane_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "point"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_plane_distance" graphene_plane_distance :: 
    Ptr Plane ->                            -- p : TInterface (Name {namespace = "Graphene", name = "Plane"})
    Ptr Graphene.Point3D.Point3D ->         -- point : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO CFloat

-- | Computes the distance of /@point@/ from a t'GI.Graphene.Structs.Plane.Plane'.
-- 
-- /Since: 1.2/
planeDistance ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Plane
    -- ^ /@p@/: a t'GI.Graphene.Structs.Plane.Plane'
    -> Graphene.Point3D.Point3D
    -- ^ /@point@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> m Float
    -- ^ __Returns:__ the distance of the given t'GI.Graphene.Structs.Point3D.Point3D' from the plane
planeDistance p point = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    point' <- unsafeManagedPtrGetPtr point
    result <- graphene_plane_distance p' point'
    let result' = realToFrac result
    touchManagedPtr p
    touchManagedPtr point
    return result'

#if defined(ENABLE_OVERLOADING)
data PlaneDistanceMethodInfo
instance (signature ~ (Graphene.Point3D.Point3D -> m Float), MonadIO m) => O.OverloadedMethod PlaneDistanceMethodInfo Plane signature where
    overloadedMethod = planeDistance

instance O.OverloadedMethodInfo PlaneDistanceMethodInfo Plane where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Plane.planeDistance",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Plane.html#v:planeDistance"
        })


#endif

-- method Plane::equal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Plane" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_plane_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Plane" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_plane_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_plane_equal" graphene_plane_equal :: 
    Ptr Plane ->                            -- a : TInterface (Name {namespace = "Graphene", name = "Plane"})
    Ptr Plane ->                            -- b : TInterface (Name {namespace = "Graphene", name = "Plane"})
    IO CInt

-- | Checks whether the two given t'GI.Graphene.Structs.Plane.Plane' are equal.
-- 
-- /Since: 1.2/
planeEqual ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Plane
    -- ^ /@a@/: a t'GI.Graphene.Structs.Plane.Plane'
    -> Plane
    -- ^ /@b@/: a t'GI.Graphene.Structs.Plane.Plane'
    -> m Bool
    -- ^ __Returns:__ @true@ if the given planes are equal
planeEqual a b = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    result <- graphene_plane_equal a' b'
    let result' = (/= 0) result
    touchManagedPtr a
    touchManagedPtr b
    return result'

#if defined(ENABLE_OVERLOADING)
data PlaneEqualMethodInfo
instance (signature ~ (Plane -> m Bool), MonadIO m) => O.OverloadedMethod PlaneEqualMethodInfo Plane signature where
    overloadedMethod = planeEqual

instance O.OverloadedMethodInfo PlaneEqualMethodInfo Plane where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Plane.planeEqual",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Plane.html#v:planeEqual"
        })


#endif

-- method Plane::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Plane" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_plane_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_plane_free" graphene_plane_free :: 
    Ptr Plane ->                            -- p : TInterface (Name {namespace = "Graphene", name = "Plane"})
    IO ()

-- | Frees the resources allocated by 'GI.Graphene.Structs.Plane.planeAlloc'.
-- 
-- /Since: 1.2/
planeFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Plane
    -- ^ /@p@/: a t'GI.Graphene.Structs.Plane.Plane'
    -> m ()
planeFree p = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    graphene_plane_free p'
    touchManagedPtr p
    return ()

#if defined(ENABLE_OVERLOADING)
data PlaneFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod PlaneFreeMethodInfo Plane signature where
    overloadedMethod = planeFree

instance O.OverloadedMethodInfo PlaneFreeMethodInfo Plane where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Plane.planeFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Plane.html#v:planeFree"
        })


#endif

-- method Plane::get_constant
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Plane" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_plane_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_plane_get_constant" graphene_plane_get_constant :: 
    Ptr Plane ->                            -- p : TInterface (Name {namespace = "Graphene", name = "Plane"})
    IO CFloat

-- | Retrieves the distance along the normal vector of the
-- given t'GI.Graphene.Structs.Plane.Plane' from the origin.
-- 
-- /Since: 1.2/
planeGetConstant ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Plane
    -- ^ /@p@/: a t'GI.Graphene.Structs.Plane.Plane'
    -> m Float
    -- ^ __Returns:__ the constant value of the plane
planeGetConstant p = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    result <- graphene_plane_get_constant p'
    let result' = realToFrac result
    touchManagedPtr p
    return result'

#if defined(ENABLE_OVERLOADING)
data PlaneGetConstantMethodInfo
instance (signature ~ (m Float), MonadIO m) => O.OverloadedMethod PlaneGetConstantMethodInfo Plane signature where
    overloadedMethod = planeGetConstant

instance O.OverloadedMethodInfo PlaneGetConstantMethodInfo Plane where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Plane.planeGetConstant",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Plane.html#v:planeGetConstant"
        })


#endif

-- method Plane::get_normal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Plane" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_plane_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "normal"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec3" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the normal vector"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_plane_get_normal" graphene_plane_get_normal :: 
    Ptr Plane ->                            -- p : TInterface (Name {namespace = "Graphene", name = "Plane"})
    Ptr Graphene.Vec3.Vec3 ->               -- normal : TInterface (Name {namespace = "Graphene", name = "Vec3"})
    IO ()

-- | Retrieves the normal vector pointing towards the origin of the
-- given t'GI.Graphene.Structs.Plane.Plane'.
-- 
-- /Since: 1.2/
planeGetNormal ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Plane
    -- ^ /@p@/: a t'GI.Graphene.Structs.Plane.Plane'
    -> m (Graphene.Vec3.Vec3)
planeGetNormal p = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    normal <- SP.callocBoxedBytes 16 :: IO (Ptr Graphene.Vec3.Vec3)
    graphene_plane_get_normal p' normal
    normal' <- (wrapBoxed Graphene.Vec3.Vec3) normal
    touchManagedPtr p
    return normal'

#if defined(ENABLE_OVERLOADING)
data PlaneGetNormalMethodInfo
instance (signature ~ (m (Graphene.Vec3.Vec3)), MonadIO m) => O.OverloadedMethod PlaneGetNormalMethodInfo Plane signature where
    overloadedMethod = planeGetNormal

instance O.OverloadedMethodInfo PlaneGetNormalMethodInfo Plane where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Plane.planeGetNormal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Plane.html#v:planeGetNormal"
        })


#endif

-- method Plane::init
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Plane" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_plane_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "normal"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec3" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a unit length normal vector defining the plane\n  pointing towards the origin; if unset, we use the X axis by default"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "constant"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the distance from the origin to the plane along the\n  normal vector; the sign determines the half-space occupied by the\n  plane"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Plane" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_plane_init" graphene_plane_init :: 
    Ptr Plane ->                            -- p : TInterface (Name {namespace = "Graphene", name = "Plane"})
    Ptr Graphene.Vec3.Vec3 ->               -- normal : TInterface (Name {namespace = "Graphene", name = "Vec3"})
    CFloat ->                               -- constant : TBasicType TFloat
    IO (Ptr Plane)

-- | Initializes the given t'GI.Graphene.Structs.Plane.Plane' using the given /@normal@/ vector
-- and /@constant@/ values.
-- 
-- /Since: 1.2/
planeInit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Plane
    -- ^ /@p@/: the t'GI.Graphene.Structs.Plane.Plane' to initialize
    -> Maybe (Graphene.Vec3.Vec3)
    -- ^ /@normal@/: a unit length normal vector defining the plane
    --   pointing towards the origin; if unset, we use the X axis by default
    -> Float
    -- ^ /@constant@/: the distance from the origin to the plane along the
    --   normal vector; the sign determines the half-space occupied by the
    --   plane
    -> m Plane
    -- ^ __Returns:__ the initialized plane
planeInit p normal constant = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    maybeNormal <- case normal of
        Nothing -> return FP.nullPtr
        Just jNormal -> do
            jNormal' <- unsafeManagedPtrGetPtr jNormal
            return jNormal'
    let constant' = realToFrac constant
    result <- graphene_plane_init p' maybeNormal constant'
    checkUnexpectedReturnNULL "planeInit" result
    result' <- (newBoxed Plane) result
    touchManagedPtr p
    whenJust normal touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data PlaneInitMethodInfo
instance (signature ~ (Maybe (Graphene.Vec3.Vec3) -> Float -> m Plane), MonadIO m) => O.OverloadedMethod PlaneInitMethodInfo Plane signature where
    overloadedMethod = planeInit

instance O.OverloadedMethodInfo PlaneInitMethodInfo Plane where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Plane.planeInit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Plane.html#v:planeInit"
        })


#endif

-- method Plane::init_from_plane
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Plane" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_plane_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "src"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Plane" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_plane_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Plane" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_plane_init_from_plane" graphene_plane_init_from_plane :: 
    Ptr Plane ->                            -- p : TInterface (Name {namespace = "Graphene", name = "Plane"})
    Ptr Plane ->                            -- src : TInterface (Name {namespace = "Graphene", name = "Plane"})
    IO (Ptr Plane)

-- | Initializes the given t'GI.Graphene.Structs.Plane.Plane' using the normal
-- vector and constant of another t'GI.Graphene.Structs.Plane.Plane'.
-- 
-- /Since: 1.2/
planeInitFromPlane ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Plane
    -- ^ /@p@/: the t'GI.Graphene.Structs.Plane.Plane' to initialize
    -> Plane
    -- ^ /@src@/: a t'GI.Graphene.Structs.Plane.Plane'
    -> m Plane
    -- ^ __Returns:__ the initialized plane
planeInitFromPlane p src = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    src' <- unsafeManagedPtrGetPtr src
    result <- graphene_plane_init_from_plane p' src'
    checkUnexpectedReturnNULL "planeInitFromPlane" result
    result' <- (newBoxed Plane) result
    touchManagedPtr p
    touchManagedPtr src
    return result'

#if defined(ENABLE_OVERLOADING)
data PlaneInitFromPlaneMethodInfo
instance (signature ~ (Plane -> m Plane), MonadIO m) => O.OverloadedMethod PlaneInitFromPlaneMethodInfo Plane signature where
    overloadedMethod = planeInitFromPlane

instance O.OverloadedMethodInfo PlaneInitFromPlaneMethodInfo Plane where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Plane.planeInitFromPlane",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Plane.html#v:planeInitFromPlane"
        })


#endif

-- method Plane::init_from_point
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Plane" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_plane_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "normal"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec3" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a normal vector defining the plane pointing towards the origin"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "point"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Plane" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_plane_init_from_point" graphene_plane_init_from_point :: 
    Ptr Plane ->                            -- p : TInterface (Name {namespace = "Graphene", name = "Plane"})
    Ptr Graphene.Vec3.Vec3 ->               -- normal : TInterface (Name {namespace = "Graphene", name = "Vec3"})
    Ptr Graphene.Point3D.Point3D ->         -- point : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO (Ptr Plane)

-- | Initializes the given t'GI.Graphene.Structs.Plane.Plane' using the given normal vector
-- and an arbitrary co-planar point.
-- 
-- /Since: 1.2/
planeInitFromPoint ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Plane
    -- ^ /@p@/: the t'GI.Graphene.Structs.Plane.Plane' to initialize
    -> Graphene.Vec3.Vec3
    -- ^ /@normal@/: a normal vector defining the plane pointing towards the origin
    -> Graphene.Point3D.Point3D
    -- ^ /@point@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> m Plane
    -- ^ __Returns:__ the initialized plane
planeInitFromPoint p normal point = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    normal' <- unsafeManagedPtrGetPtr normal
    point' <- unsafeManagedPtrGetPtr point
    result <- graphene_plane_init_from_point p' normal' point'
    checkUnexpectedReturnNULL "planeInitFromPoint" result
    result' <- (newBoxed Plane) result
    touchManagedPtr p
    touchManagedPtr normal
    touchManagedPtr point
    return result'

#if defined(ENABLE_OVERLOADING)
data PlaneInitFromPointMethodInfo
instance (signature ~ (Graphene.Vec3.Vec3 -> Graphene.Point3D.Point3D -> m Plane), MonadIO m) => O.OverloadedMethod PlaneInitFromPointMethodInfo Plane signature where
    overloadedMethod = planeInitFromPoint

instance O.OverloadedMethodInfo PlaneInitFromPointMethodInfo Plane where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Plane.planeInitFromPoint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Plane.html#v:planeInitFromPoint"
        })


#endif

-- method Plane::init_from_points
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Plane" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_plane_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "c"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Plane" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_plane_init_from_points" graphene_plane_init_from_points :: 
    Ptr Plane ->                            -- p : TInterface (Name {namespace = "Graphene", name = "Plane"})
    Ptr Graphene.Point3D.Point3D ->         -- a : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Graphene.Point3D.Point3D ->         -- b : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Graphene.Point3D.Point3D ->         -- c : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO (Ptr Plane)

-- | Initializes the given t'GI.Graphene.Structs.Plane.Plane' using the 3 provided co-planar
-- points.
-- 
-- The winding order is counter-clockwise, and determines which direction
-- the normal vector will point.
-- 
-- /Since: 1.2/
planeInitFromPoints ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Plane
    -- ^ /@p@/: the t'GI.Graphene.Structs.Plane.Plane' to initialize
    -> Graphene.Point3D.Point3D
    -- ^ /@a@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> Graphene.Point3D.Point3D
    -- ^ /@b@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> Graphene.Point3D.Point3D
    -- ^ /@c@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> m Plane
    -- ^ __Returns:__ the initialized plane
planeInitFromPoints p a b c = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    c' <- unsafeManagedPtrGetPtr c
    result <- graphene_plane_init_from_points p' a' b' c'
    checkUnexpectedReturnNULL "planeInitFromPoints" result
    result' <- (newBoxed Plane) result
    touchManagedPtr p
    touchManagedPtr a
    touchManagedPtr b
    touchManagedPtr c
    return result'

#if defined(ENABLE_OVERLOADING)
data PlaneInitFromPointsMethodInfo
instance (signature ~ (Graphene.Point3D.Point3D -> Graphene.Point3D.Point3D -> Graphene.Point3D.Point3D -> m Plane), MonadIO m) => O.OverloadedMethod PlaneInitFromPointsMethodInfo Plane signature where
    overloadedMethod = planeInitFromPoints

instance O.OverloadedMethodInfo PlaneInitFromPointsMethodInfo Plane where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Plane.planeInitFromPoints",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Plane.html#v:planeInitFromPoints"
        })


#endif

-- method Plane::init_from_vec4
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Plane" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_plane_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "src"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec4" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #graphene_vec4_t containing the normal vector in its first\n  three components, and the distance in its fourth component"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Plane" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_plane_init_from_vec4" graphene_plane_init_from_vec4 :: 
    Ptr Plane ->                            -- p : TInterface (Name {namespace = "Graphene", name = "Plane"})
    Ptr Graphene.Vec4.Vec4 ->               -- src : TInterface (Name {namespace = "Graphene", name = "Vec4"})
    IO (Ptr Plane)

-- | Initializes the given t'GI.Graphene.Structs.Plane.Plane' using the components of
-- the given t'GI.Graphene.Structs.Vec4.Vec4' vector.
-- 
-- /Since: 1.2/
planeInitFromVec4 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Plane
    -- ^ /@p@/: the t'GI.Graphene.Structs.Plane.Plane' to initialize
    -> Graphene.Vec4.Vec4
    -- ^ /@src@/: a t'GI.Graphene.Structs.Vec4.Vec4' containing the normal vector in its first
    --   three components, and the distance in its fourth component
    -> m Plane
    -- ^ __Returns:__ the initialized plane
planeInitFromVec4 p src = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    src' <- unsafeManagedPtrGetPtr src
    result <- graphene_plane_init_from_vec4 p' src'
    checkUnexpectedReturnNULL "planeInitFromVec4" result
    result' <- (newBoxed Plane) result
    touchManagedPtr p
    touchManagedPtr src
    return result'

#if defined(ENABLE_OVERLOADING)
data PlaneInitFromVec4MethodInfo
instance (signature ~ (Graphene.Vec4.Vec4 -> m Plane), MonadIO m) => O.OverloadedMethod PlaneInitFromVec4MethodInfo Plane signature where
    overloadedMethod = planeInitFromVec4

instance O.OverloadedMethodInfo PlaneInitFromVec4MethodInfo Plane where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Plane.planeInitFromVec4",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Plane.html#v:planeInitFromVec4"
        })


#endif

-- method Plane::negate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Plane" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_plane_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Plane" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the negated plane"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_plane_negate" graphene_plane_negate :: 
    Ptr Plane ->                            -- p : TInterface (Name {namespace = "Graphene", name = "Plane"})
    Ptr Plane ->                            -- res : TInterface (Name {namespace = "Graphene", name = "Plane"})
    IO ()

-- | Negates the normal vector and constant of a t'GI.Graphene.Structs.Plane.Plane', effectively
-- mirroring the plane across the origin.
-- 
-- /Since: 1.2/
planeNegate ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Plane
    -- ^ /@p@/: a t'GI.Graphene.Structs.Plane.Plane'
    -> m (Plane)
planeNegate p = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    res <- SP.callocBoxedBytes 20 :: IO (Ptr Plane)
    graphene_plane_negate p' res
    res' <- (wrapBoxed Plane) res
    touchManagedPtr p
    return res'

#if defined(ENABLE_OVERLOADING)
data PlaneNegateMethodInfo
instance (signature ~ (m (Plane)), MonadIO m) => O.OverloadedMethod PlaneNegateMethodInfo Plane signature where
    overloadedMethod = planeNegate

instance O.OverloadedMethodInfo PlaneNegateMethodInfo Plane where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Plane.planeNegate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Plane.html#v:planeNegate"
        })


#endif

-- method Plane::normalize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Plane" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_plane_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Plane" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the normalized plane"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_plane_normalize" graphene_plane_normalize :: 
    Ptr Plane ->                            -- p : TInterface (Name {namespace = "Graphene", name = "Plane"})
    Ptr Plane ->                            -- res : TInterface (Name {namespace = "Graphene", name = "Plane"})
    IO ()

-- | Normalizes the vector of the given t'GI.Graphene.Structs.Plane.Plane',
-- and adjusts the constant accordingly.
-- 
-- /Since: 1.2/
planeNormalize ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Plane
    -- ^ /@p@/: a t'GI.Graphene.Structs.Plane.Plane'
    -> m (Plane)
planeNormalize p = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    res <- SP.callocBoxedBytes 20 :: IO (Ptr Plane)
    graphene_plane_normalize p' res
    res' <- (wrapBoxed Plane) res
    touchManagedPtr p
    return res'

#if defined(ENABLE_OVERLOADING)
data PlaneNormalizeMethodInfo
instance (signature ~ (m (Plane)), MonadIO m) => O.OverloadedMethod PlaneNormalizeMethodInfo Plane signature where
    overloadedMethod = planeNormalize

instance O.OverloadedMethodInfo PlaneNormalizeMethodInfo Plane where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Plane.planeNormalize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Plane.html#v:planeNormalize"
        })


#endif

-- method Plane::transform
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Plane" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_plane_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "matrix"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Matrix" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_matrix_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "normal_matrix"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Matrix" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_matrix_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Plane" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the transformed plane"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_plane_transform" graphene_plane_transform :: 
    Ptr Plane ->                            -- p : TInterface (Name {namespace = "Graphene", name = "Plane"})
    Ptr Graphene.Matrix.Matrix ->           -- matrix : TInterface (Name {namespace = "Graphene", name = "Matrix"})
    Ptr Graphene.Matrix.Matrix ->           -- normal_matrix : TInterface (Name {namespace = "Graphene", name = "Matrix"})
    Ptr Plane ->                            -- res : TInterface (Name {namespace = "Graphene", name = "Plane"})
    IO ()

-- | Transforms a t'GI.Graphene.Structs.Plane.Plane' /@p@/ using the given /@matrix@/
-- and /@normalMatrix@/.
-- 
-- If /@normalMatrix@/ is 'P.Nothing', a transformation matrix for the plane
-- normal will be computed from /@matrix@/. If you are transforming
-- multiple planes using the same /@matrix@/ it\'s recommended to compute
-- the normal matrix beforehand to avoid incurring in the cost of
-- recomputing it every time.
-- 
-- /Since: 1.10/
planeTransform ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Plane
    -- ^ /@p@/: a t'GI.Graphene.Structs.Plane.Plane'
    -> Graphene.Matrix.Matrix
    -- ^ /@matrix@/: a t'GI.Graphene.Structs.Matrix.Matrix'
    -> Maybe (Graphene.Matrix.Matrix)
    -- ^ /@normalMatrix@/: a t'GI.Graphene.Structs.Matrix.Matrix'
    -> m (Plane)
planeTransform p matrix normalMatrix = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    matrix' <- unsafeManagedPtrGetPtr matrix
    maybeNormalMatrix <- case normalMatrix of
        Nothing -> return FP.nullPtr
        Just jNormalMatrix -> do
            jNormalMatrix' <- unsafeManagedPtrGetPtr jNormalMatrix
            return jNormalMatrix'
    res <- SP.callocBoxedBytes 20 :: IO (Ptr Plane)
    graphene_plane_transform p' matrix' maybeNormalMatrix res
    res' <- (wrapBoxed Plane) res
    touchManagedPtr p
    touchManagedPtr matrix
    whenJust normalMatrix touchManagedPtr
    return res'

#if defined(ENABLE_OVERLOADING)
data PlaneTransformMethodInfo
instance (signature ~ (Graphene.Matrix.Matrix -> Maybe (Graphene.Matrix.Matrix) -> m (Plane)), MonadIO m) => O.OverloadedMethod PlaneTransformMethodInfo Plane signature where
    overloadedMethod = planeTransform

instance O.OverloadedMethodInfo PlaneTransformMethodInfo Plane where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Plane.planeTransform",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Plane.html#v:planeTransform"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolvePlaneMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePlaneMethod "distance" o = PlaneDistanceMethodInfo
    ResolvePlaneMethod "equal" o = PlaneEqualMethodInfo
    ResolvePlaneMethod "free" o = PlaneFreeMethodInfo
    ResolvePlaneMethod "init" o = PlaneInitMethodInfo
    ResolvePlaneMethod "initFromPlane" o = PlaneInitFromPlaneMethodInfo
    ResolvePlaneMethod "initFromPoint" o = PlaneInitFromPointMethodInfo
    ResolvePlaneMethod "initFromPoints" o = PlaneInitFromPointsMethodInfo
    ResolvePlaneMethod "initFromVec4" o = PlaneInitFromVec4MethodInfo
    ResolvePlaneMethod "negate" o = PlaneNegateMethodInfo
    ResolvePlaneMethod "normalize" o = PlaneNormalizeMethodInfo
    ResolvePlaneMethod "transform" o = PlaneTransformMethodInfo
    ResolvePlaneMethod "getConstant" o = PlaneGetConstantMethodInfo
    ResolvePlaneMethod "getNormal" o = PlaneGetNormalMethodInfo
    ResolvePlaneMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePlaneMethod t Plane, O.OverloadedMethod info Plane p) => OL.IsLabel t (Plane -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePlaneMethod t Plane, O.OverloadedMethod info Plane p, R.HasField t Plane p) => R.HasField t Plane p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePlaneMethod t Plane, O.OverloadedMethodInfo info Plane) => OL.IsLabel t (O.MethodProxy info Plane) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


