

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkX11.Functions
    ( 

 -- * Methods


-- ** x11DeviceGetId #method:x11DeviceGetId#

    x11DeviceGetId                          ,


-- ** x11DeviceManagerLookup #method:x11DeviceManagerLookup#

    x11DeviceManagerLookup                  ,


-- ** x11FreeCompoundText #method:x11FreeCompoundText#

    x11FreeCompoundText                     ,


-- ** x11FreeTextList #method:x11FreeTextList#

    x11FreeTextList                         ,


-- ** x11GetServerTime #method:x11GetServerTime#

    x11GetServerTime                        ,


-- ** x11GetXatomByNameForDisplay #method:x11GetXatomByNameForDisplay#

    x11GetXatomByNameForDisplay             ,


-- ** x11GetXatomNameForDisplay #method:x11GetXatomNameForDisplay#

    x11GetXatomNameForDisplay               ,


-- ** x11LookupXdisplay #method:x11LookupXdisplay#

    x11LookupXdisplay                       ,


-- ** x11SetSmClientId #method:x11SetSmClientId#

    x11SetSmClientId                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.GdkX11.Objects.X11DeviceManagerXI2 as GdkX11.X11DeviceManagerXI2
import {-# SOURCE #-} qualified GI.GdkX11.Objects.X11DeviceXI2 as GdkX11.X11DeviceXI2
import {-# SOURCE #-} qualified GI.GdkX11.Objects.X11Display as GdkX11.X11Display
import {-# SOURCE #-} qualified GI.GdkX11.Objects.X11Screen as GdkX11.X11Screen
import {-# SOURCE #-} qualified GI.GdkX11.Objects.X11Surface as GdkX11.X11Surface
import qualified GI.Xlib.Structs.Display as Xlib.Display
import qualified GI.Xlib.Structs.Screen as Xlib.Screen

#else
import {-# SOURCE #-} qualified GI.GdkX11.Objects.X11DeviceManagerXI2 as GdkX11.X11DeviceManagerXI2
import {-# SOURCE #-} qualified GI.GdkX11.Objects.X11DeviceXI2 as GdkX11.X11DeviceXI2
import {-# SOURCE #-} qualified GI.GdkX11.Objects.X11Display as GdkX11.X11Display
import {-# SOURCE #-} qualified GI.GdkX11.Objects.X11Surface as GdkX11.X11Surface
import qualified GI.Xlib.Structs.Display as Xlib.Display

#endif

-- function x11_set_sm_client_id
-- Args: [ Arg
--           { argCName = "sm_client_id"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the client id assigned by the session manager\n   when the connection was opened, or %NULL to remove the property."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_set_sm_client_id" gdk_x11_set_sm_client_id :: 
    CString ->                              -- sm_client_id : TBasicType TUTF8
    IO ()

-- | Sets the @SM_CLIENT_ID@ property on the application’s leader window so that
-- the window manager can save the application’s state using the X11R6 ICCCM
-- session management protocol.
-- 
-- See the X Session Management Library documentation for more information on
-- session management and the Inter-Client Communication Conventions Manual
x11SetSmClientId ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@smClientId@/: the client id assigned by the session manager
    --    when the connection was opened, or 'P.Nothing' to remove the property.
    -> m ()
x11SetSmClientId smClientId = liftIO $ do
    maybeSmClientId <- case smClientId of
        Nothing -> return FP.nullPtr
        Just jSmClientId -> do
            jSmClientId' <- textToCString jSmClientId
            return jSmClientId'
    gdk_x11_set_sm_client_id maybeSmClientId
    freeMem maybeSmClientId
    return ()


-- function x11_lookup_xdisplay
-- Args: [ Arg
--           { argCName = "xdisplay"
--           , argType =
--               TInterface Name { namespace = "xlib" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to an X Display"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GdkX11" , name = "X11Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_lookup_xdisplay" gdk_x11_lookup_xdisplay :: 
    Ptr Xlib.Display.Display ->             -- xdisplay : TInterface (Name {namespace = "xlib", name = "Display"})
    IO (Ptr GdkX11.X11Display.X11Display)

-- | Find the @GdkDisplay@ corresponding to /@xdisplay@/, if any exists.
x11LookupXdisplay ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Xlib.Display.Display
    -- ^ /@xdisplay@/: a pointer to an X Display
    -> m GdkX11.X11Display.X11Display
    -- ^ __Returns:__ the @GdkDisplay@, if found, otherwise 'P.Nothing'.
x11LookupXdisplay xdisplay = liftIO $ do
    xdisplay' <- unsafeManagedPtrGetPtr xdisplay
    result <- gdk_x11_lookup_xdisplay xdisplay'
    checkUnexpectedReturnNULL "x11LookupXdisplay" result
    result' <- (newObject GdkX11.X11Display.X11Display) result
    touchManagedPtr xdisplay
    return result'


-- function x11_get_xatom_name_for_display
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GdkDisplay` where @xatom is defined"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "xatom"
--           , argType = TBasicType TULong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an X atom" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_get_xatom_name_for_display" gdk_x11_get_xatom_name_for_display :: 
    Ptr GdkX11.X11Display.X11Display ->     -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    FCT.CULong ->                           -- xatom : TBasicType TULong
    IO CString

{-# DEPRECATED x11GetXatomNameForDisplay ["(Since version 4.18)"] #-}
-- | Returns the name of an X atom for its display. This
-- function is meant mainly for debugging, so for convenience, unlike
-- @/XAtomName()/@ and the result doesn’t need to
-- be freed.
x11GetXatomNameForDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, GdkX11.X11Display.IsX11Display a) =>
    a
    -- ^ /@display@/: the @GdkDisplay@ where /@xatom@/ is defined
    -> FCT.CULong
    -- ^ /@xatom@/: an X atom
    -> m T.Text
    -- ^ __Returns:__ name of the X atom; this string is owned by GDK,
    --   so it shouldn’t be modified or freed.
x11GetXatomNameForDisplay display xatom = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_x11_get_xatom_name_for_display display' xatom
    checkUnexpectedReturnNULL "x11GetXatomNameForDisplay" result
    result' <- cstringToText result
    touchManagedPtr display
    return result'


-- function x11_get_xatom_by_name_for_display
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "atom_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TULong)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_get_xatom_by_name_for_display" gdk_x11_get_xatom_by_name_for_display :: 
    Ptr GdkX11.X11Display.X11Display ->     -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    CString ->                              -- atom_name : TBasicType TUTF8
    IO FCT.CULong

{-# DEPRECATED x11GetXatomByNameForDisplay ["(Since version 4.18)"] #-}
-- | Returns the X atom for a @GdkDisplay@ corresponding to /@atomName@/.
-- This function caches the result, so if called repeatedly it is much
-- faster than @/XInternAtom()/@, which is a round trip to the server each time.
x11GetXatomByNameForDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, GdkX11.X11Display.IsX11Display a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> T.Text
    -- ^ /@atomName@/: a string
    -> m FCT.CULong
    -- ^ __Returns:__ a X atom for a @GdkDisplay@
x11GetXatomByNameForDisplay display atomName = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    atomName' <- textToCString atomName
    result <- gdk_x11_get_xatom_by_name_for_display display' atomName'
    touchManagedPtr display
    freeMem atomName'
    return result


-- function x11_get_server_time
-- Args: [ Arg
--           { argCName = "surface"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Surface" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a `GdkSurface`, used for communication\n  with the server. The surface must have `GDK_PROPERTY_CHANGE_MASK` in\n  its events mask or a hang will result."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_get_server_time" gdk_x11_get_server_time :: 
    Ptr GdkX11.X11Surface.X11Surface ->     -- surface : TInterface (Name {namespace = "GdkX11", name = "X11Surface"})
    IO Word32

{-# DEPRECATED x11GetServerTime ["(Since version 4.18)"] #-}
-- | Routine to get the current X server time stamp.
x11GetServerTime ::
    (B.CallStack.HasCallStack, MonadIO m, GdkX11.X11Surface.IsX11Surface a) =>
    a
    -- ^ /@surface@/: a @GdkSurface@, used for communication
    --   with the server. The surface must have @GDK_PROPERTY_CHANGE_MASK@ in
    --   its events mask or a hang will result.
    -> m Word32
    -- ^ __Returns:__ the time stamp
x11GetServerTime surface = liftIO $ do
    surface' <- unsafeManagedPtrCastPtr surface
    result <- gdk_x11_get_server_time surface'
    touchManagedPtr surface
    return result


-- function x11_free_text_list
-- Args: [ Arg
--           { argCName = "list"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the value stored in the @list parameter by\n  a call to gdk_x11_display_text_property_to_text_list()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_free_text_list" gdk_x11_free_text_list :: 
    CString ->                              -- list : TBasicType TUTF8
    IO ()

{-# DEPRECATED x11FreeTextList ["(Since version 4.18)"] #-}
-- | Frees the array of strings created by
-- 'GI.GdkX11.Objects.X11Display.x11DisplayTextPropertyToTextList'.
x11FreeTextList ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@list@/: the value stored in the /@list@/ parameter by
    --   a call to 'GI.GdkX11.Objects.X11Display.x11DisplayTextPropertyToTextList'.
    -> m ()
x11FreeTextList list = liftIO $ do
    list' <- textToCString list
    gdk_x11_free_text_list list'
    freeMem list'
    return ()


-- function x11_free_compound_text
-- Args: [ Arg
--           { argCName = "ctext"
--           , argType = TBasicType TUInt8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The pointer stored in @ctext from a call to\n  gdk_x11_display_string_to_compound_text()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_free_compound_text" gdk_x11_free_compound_text :: 
    Word8 ->                                -- ctext : TBasicType TUInt8
    IO ()

{-# DEPRECATED x11FreeCompoundText ["(Since version 4.18)"] #-}
-- | Frees the data returned from 'GI.GdkX11.Objects.X11Display.x11DisplayStringToCompoundText'.
x11FreeCompoundText ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word8
    -- ^ /@ctext@/: The pointer stored in /@ctext@/ from a call to
    --   'GI.GdkX11.Objects.X11Display.x11DisplayStringToCompoundText'.
    -> m ()
x11FreeCompoundText ctext = liftIO $ do
    gdk_x11_free_compound_text ctext
    return ()


-- function x11_device_manager_lookup
-- Args: [ Arg
--           { argCName = "device_manager"
--           , argType =
--               TInterface
--                 Name { namespace = "GdkX11" , name = "X11DeviceManagerXI2" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDeviceManager`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "device_id"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a device ID, as understood by the XInput2 protocol"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GdkX11" , name = "X11DeviceXI2" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_device_manager_lookup" gdk_x11_device_manager_lookup :: 
    Ptr GdkX11.X11DeviceManagerXI2.X11DeviceManagerXI2 -> -- device_manager : TInterface (Name {namespace = "GdkX11", name = "X11DeviceManagerXI2"})
    Int32 ->                                -- device_id : TBasicType TInt
    IO (Ptr GdkX11.X11DeviceXI2.X11DeviceXI2)

{-# DEPRECATED x11DeviceManagerLookup ["(Since version 4.18)"] #-}
-- | Returns the @GdkDevice@ that wraps the given device ID.
x11DeviceManagerLookup ::
    (B.CallStack.HasCallStack, MonadIO m, GdkX11.X11DeviceManagerXI2.IsX11DeviceManagerXI2 a) =>
    a
    -- ^ /@deviceManager@/: a @GdkDeviceManager@
    -> Int32
    -- ^ /@deviceId@/: a device ID, as understood by the XInput2 protocol
    -> m (Maybe GdkX11.X11DeviceXI2.X11DeviceXI2)
    -- ^ __Returns:__ The
    --   @GdkDevice@ wrapping the device ID, or 'P.Nothing' if the given ID
    --   doesn’t currently represent a device.
x11DeviceManagerLookup deviceManager deviceId = liftIO $ do
    deviceManager' <- unsafeManagedPtrCastPtr deviceManager
    result <- gdk_x11_device_manager_lookup deviceManager' deviceId
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject GdkX11.X11DeviceXI2.X11DeviceXI2) result'
        return result''
    touchManagedPtr deviceManager
    return maybeResult


-- function x11_device_get_id
-- Args: [ Arg
--           { argCName = "device"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11DeviceXI2" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDevice`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_device_get_id" gdk_x11_device_get_id :: 
    Ptr GdkX11.X11DeviceXI2.X11DeviceXI2 -> -- device : TInterface (Name {namespace = "GdkX11", name = "X11DeviceXI2"})
    IO Int32

{-# DEPRECATED x11DeviceGetId ["(Since version 4.18)"] #-}
-- | Returns the device ID as seen by XInput2.
x11DeviceGetId ::
    (B.CallStack.HasCallStack, MonadIO m, GdkX11.X11DeviceXI2.IsX11DeviceXI2 a) =>
    a
    -- ^ /@device@/: a @GdkDevice@
    -> m Int32
    -- ^ __Returns:__ the XInput2 device ID
x11DeviceGetId device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_x11_device_get_id device'
    touchManagedPtr device
    return result



