// Generated by gmmproc 2.66.8 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gtkmm/widget.h>
#include <gtkmm/private/widget_p.h>

#include <gtk/gtk.h>

/* Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glibmm/vectorutils.h>

#include <gdkmm/frameclock.h>
#include <gtkmm/adjustment.h>
#include <gtkmm/window.h>
#include <gtkmm/accelgroup.h>
#include <gtkmm/settings.h>
#include <gtkmm/container.h>
#include <gtkmm/selectiondata_private.h>
#include <gtkmm/action.h>
#include <gtkmm/tooltip.h>
#include <gtk/gtk.h> //For gtk_widget_get_action().


namespace //anonymous
{

// This signal callback is custom implemented, so that we can refrain from calling
// the signal handler if the C++ wrapper is being deleted.
// https://bugzilla.gnome.org/show_bug.cgi?id=605728#c5
void Widget_signal_hide_callback(GObject* self, void* data)
{
  const auto obj = Glib::ObjectBase::_get_current_wrapper(self);

  // Do not try to call a signal on a disassociated wrapper.
  // This function might be invoked recursively if the signal_hide() handler
  // deletes the object.
  // Therefore we have to test for cpp_destruction_in_progress_ at this point.
  if(obj && !obj->_cpp_destruction_is_in_progress())
  {
    try
    {
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<sigc::slot<void>*>(slot))();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
}

//These signal callbacks are custom implemented, so that we can create a temporary SelectionData instance.
//To do this, we used the optional custom_c_callback paramater to _WRAP_SIGNAL() in the .hg file.
static void Widget_signal_drag_data_get_callback(GtkWidget* self, GdkDragContext* p0,GtkSelectionData* p1,guint p2,guint p3,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const Glib::RefPtr<Gdk::DragContext>&,SelectionData&,guint,guint > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    try
    {
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
      {
        SelectionData_WithoutOwnership temp_instance(p1);
        (*static_cast<SlotType*>(slot))( Glib::wrap(p0, true), temp_instance, p2, p3 );
      }
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
}

static void Widget_signal_selection_get_callback(GtkWidget* self, GtkSelectionData* p0,guint p1,guint p2,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void, SelectionData&, guint, guint > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    try
    {
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
      {
        SelectionData_WithoutOwnership temp_instance(p0);
        (*static_cast<SlotType*>(slot))( temp_instance, p1, p2 );
      }
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
}

gboolean SlotTick_gtk_callback(GtkWidget* self, GdkFrameClock* frame_clock, void* data)
{
  // Do not try to call a signal on a disassociated wrapper.
  if (Glib::ObjectBase::_get_current_wrapper((GObject*)self))
  {
    auto the_slot = static_cast<Gtk::Widget::SlotTick*>(data);
    try
    {
      return (*the_slot)(Glib::wrap(frame_clock, true));
    }
    catch (...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  return false;
}

} //anonymous

namespace Gtk
{

// This default handler callback is custom implemented, so that we can refrain
// from calling an on_hide() override, if the C++ wrapper is being deleted.
void Widget_Class::hide_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  // This function might be invoked recursively if an on_hide() override
  // deletes the object.
  // Therefore we test for cpp_destruction_in_progress_ at this point.
  // (Not sure if it's necessary, but it feels safer. Perhaps the following
  // dynamic_cast catches all dangerous cases. /Kjell Ahlstedt)
  if(obj_base && obj_base->is_derived_() && !obj_base->_cpp_destruction_is_in_progress())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_hide();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->hide)
    (*base->hide)(self);
}

//These default handler callbacks are custom implemented, so that we can create a temporary SelectionData instance.
//To do this, we used the optional custom_c_callback paramater to _WRAP_SIGNAL() in the .hg file.
void Widget_Class::selection_get_callback(GtkWidget* self, GtkSelectionData* p0, guint p1, guint p2)
{
  const auto obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      SelectionData_WithoutOwnership temp_instance(p0);
      obj->on_selection_get(temp_instance, p1, p2);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->selection_get)
      (*base->selection_get)(self, p0, p1, p2);
  }
}

void Widget_Class::drag_data_get_callback(GtkWidget* self, GdkDragContext* p0, GtkSelectionData* p1, guint p2, guint p3)
{
  const auto obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      SelectionData_WithoutOwnership temp_instance(p1);
      obj->on_drag_data_get(Glib::wrap(p0, true), temp_instance, p2, p3);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->drag_data_get)
      (*base->drag_data_get)(self, p0, p1, p2, p3);
  }
}

//These vfunc callbacks are custom implemented because we want the output
//arguments of the C++ vfuncs to be int& (not int*), and the vfunc_callback
//functions may be called from gtk+ with a NULL pointer.
void Widget_Class::get_preferred_width_vfunc_callback(GtkWidget* self, gint* minimum_width, gint* natural_width)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        int min_width = 0;
        int nat_width = 0;
        obj->get_preferred_width_vfunc(
             (minimum_width ? *minimum_width : min_width),
             (natural_width ? *natural_width : nat_width));
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->get_preferred_width)
    (*base->get_preferred_width)(self, minimum_width, natural_width);
}

void Widget_Class::get_preferred_height_for_width_vfunc_callback(GtkWidget* self, gint width, gint* minimum_height, gint* natural_height)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        int min_height = 0;
        int nat_height = 0;
        obj->get_preferred_height_for_width_vfunc(width,
             (minimum_height ? *minimum_height : min_height),
             (natural_height ? *natural_height : nat_height));
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->get_preferred_height_for_width)
    (*base->get_preferred_height_for_width)(self, width, minimum_height, natural_height);
}

void Widget_Class::get_preferred_height_vfunc_callback(GtkWidget* self, gint* minimum_height, gint* natural_height)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        int min_height = 0;
        int nat_height = 0;
        obj->get_preferred_height_vfunc(
             (minimum_height ? *minimum_height : min_height),
             (natural_height ? *natural_height : nat_height));
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->get_preferred_height)
    (*base->get_preferred_height)(self, minimum_height, natural_height);
}

void Widget_Class::get_preferred_width_for_height_vfunc_callback(GtkWidget* self, gint height, gint* minimum_width, gint* natural_width)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        int min_width = 0;
        int nat_width = 0;
        obj->get_preferred_width_for_height_vfunc(height,
             (minimum_width ? *minimum_width : min_width),
             (natural_width ? *natural_width : nat_width));
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->get_preferred_width_for_height)
    (*base->get_preferred_width_for_height)(self, height, minimum_width, natural_width);
}

Widget::~Widget() noexcept
{}

void Widget::reparent(Widget& new_parent)
{
  //TODO: When 'Widget& new_parent' is changed to 'Container& new_parent',
  // remove the next two statements.
  auto new_container = dynamic_cast<Container*>(&new_parent);
  g_return_if_fail(new_container != nullptr); // if new_parent is not a Container
  auto old_container = get_parent();
  g_return_if_fail(old_container != nullptr); // if the widget is not in a Container

  if (old_container != new_container)
  {
    reference();
    old_container->remove(*this);
    new_container->add(*this);
    unreference();
  }
}

bool Widget::intersect(const Gdk::Rectangle& area) const
{
  return gtk_widget_intersect(
      const_cast<GtkWidget*>(gobj()), const_cast<GdkRectangle*>(area.gobj()), nullptr);
}

void Widget::unset_name()
{
  gtk_widget_set_name(gobj(), nullptr);
}

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Widget::unset_composite_name()
{
  gtk_widget_set_composite_name(gobj(), nullptr);
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

void Widget::realize_if_needed()
{
  if(!get_realized())
    realize();
}

void Widget::add_modal_grab()
{
  gtk_grab_add(gobj());
}

void Widget::remove_modal_grab()
{
  gtk_grab_remove(gobj());
}

Widget* Widget::get_current_modal_grab()
{
  return Glib::wrap(gtk_grab_get_current());
}

void Widget::set_window(const Glib::RefPtr<Gdk::Window>& window)
{
  gtk_widget_set_window(gobj(), Glib::unwrap(window));
  if (window)
    window->reference(); // gtk_widget_set_window does not add a ref.
}

Allocation Widget::get_clip() const
{
  Allocation allocation;
  gtk_widget_get_clip(const_cast<GtkWidget*>(gobj()), allocation.gobj());
  return allocation;
}


Allocation Widget::get_allocation() const
{
  Allocation allocation;
  gtk_widget_get_allocation(const_cast<GtkWidget*>(gobj()), allocation.gobj());
  return allocation;
}

int Widget::get_width() const
  { return get_allocation().get_width(); }

int Widget::get_height() const
  { return get_allocation().get_height(); }


void Widget::drag_dest_set(DestDefaults flags, Gdk::DragAction actions)
{
  gtk_drag_dest_set(gobj(), (GtkDestDefaults)flags, nullptr, 0, (GdkDragAction)actions);
}

void Widget::drag_dest_set(const std::vector<TargetEntry>& targets,
                           DestDefaults flags, Gdk::DragAction actions)
{
  // I've used Gdk::ACTION_COPY as the default, because Gdk::ACTION_DEFAULT means that
  // it's never a drag destination, so it would seem like this method didn't work. murrayc.
  gtk_drag_dest_set(
      gobj(), (GtkDestDefaults)flags,
      Glib::ArrayHandler<TargetEntry, TargetEntryTraits>::vector_to_array(targets).data(),
      targets.size(), (GdkDragAction)actions);
}

void Widget::drag_source_set(const std::vector<TargetEntry>& targets,
                             Gdk::ModifierType start_button_mask, Gdk::DragAction actions)
{
  // I've used Gdk::MODIFIER_MASK as the default, because it seems
  // to mean 'whatever is possible in the context'. murrayc.
  gtk_drag_source_set(
      gobj(), (GdkModifierType)start_button_mask,
      Glib::ArrayHandler<TargetEntry, TargetEntryTraits>::vector_to_array(targets).data(),
      targets.size(), (GdkDragAction)actions);
}

Widget* Widget::drag_get_source_widget(const Glib::RefPtr<Gdk::DragContext>& context) //static
{
  return Glib::wrap( gtk_drag_get_source_widget(Glib::unwrap(context)) );
}

void Widget::drag_set_as_icon(const Glib::RefPtr<Gdk::DragContext>& context, int hot_x, int hot_y)
{
  gtk_drag_set_icon_widget(Glib::unwrap(context), gobj(), hot_x, hot_y);
}

void Widget_Class::hierarchy_changed_callback_custom(GtkWidget* self, GtkWidget* p0)
{
  //GTKMM_LIFECYCLE
  //Don't call wrap() on a GTK+ instance whose gtkmm instance has been deleted - just call the original C callback.
  bool gtkmm_child_already_deleted = Glib::_gobject_cppinstance_already_deleted((GObject*)p0);

  if(!gtkmm_child_already_deleted)
  {
    //Call the regular, generated callback:
    Widget_Class::hierarchy_changed_callback(self, p0);
  }
  else
  {
    const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    //Call the original underlying C function:
    if(base && base->hierarchy_changed)
      (*base->hierarchy_changed)(self, p0);
  }
}

void Widget_Class::parent_set_callback_custom(GtkWidget* self, GtkWidget* p0)
{
  //GTKMM_LIFECYCLE
  //Don't call wrap() on a GTK+ instance whose gtkmm instance has been deleted - just call the original C callback.
  bool gtkmm_p0_already_deleted = Glib::_gobject_cppinstance_already_deleted((GObject*)p0);

  if(!gtkmm_p0_already_deleted)
  {
    //Call the regular, generated callback:
    Widget_Class::parent_set_callback(self, p0);
  }
  else
  {
    const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    //Call the original underlying C function:
    if(base && base->parent_set)
      (*base->parent_set)(self, p0);
  }
}

void Widget_Class::dispose_vfunc_callback(GObject* self)
{
  //Avoid disposal. See also Window_Class::dispose_vfunc_callback().

  #ifdef GLIBMM_DEBUG_REFCOUNTING
  g_warning("Widget_Class::dispose_vfunc_callback(): gobject_: %p\n", (void*)self);
  //if(self)
   //g_warning("  gtypename: %s\n", G_OBJECT_TYPE_NAME(self));
  #endif

  const auto obj = dynamic_cast<Widget*>(
      Glib::ObjectBase::_get_current_wrapper(self));

  // This function might be invoked recursively because we're triggering
  // several signal emissions, particularly signal_hide().  Therefore we
  // have to test for cpp_destruction_in_progress_ at this point.

  if(obj && !obj->_cpp_destruction_is_in_progress()) //When it should really be destroyed, we zero gobj_.
  {
    const auto pWidget = obj->gobj();
    g_return_if_fail(pWidget == GTK_WIDGET(self));

    // Abort dispose if the widget isn't managed, in order to prevent
    // the nasty self-destroying behaviour of GTK+.  This applies to
    // any widget inside a GtkContainer on gtk_container_destroy()
    // See also Window_Class::dispose_vfunc_callback().

    if(obj->referenced_) //Not managed
    {
      // GTKMM_LIFECYCLE
      // Remove the widget from its parent container so that it
      // won't be destroyed later by gtk_container_destroy().
      GtkWidget* parent = gtk_widget_get_parent(pWidget);
      if(parent)
      {
        // Normally, we would have to ref the child widget because
        // gtk_container_remove() unrefs it.  But since we only remove
        // non-managed objects here, the container just releases the
        // reference it has acquired before in gtk_container_add().

        #ifdef GLIBMM_DEBUG_REFCOUNTING
        g_warning("Widget_Class::dispose_vfunc_callback(): removing gobject_: %p from parent: %p", (void*)self, (void*)parent);
        #endif

        gtk_container_remove(GTK_CONTAINER(parent), pWidget);

        #ifdef GLIBMM_DEBUG_REFCOUNTING
        g_warning("Widget_Class::dispose_vfunc_callback(): after removing from parent.");
        #endif
      }
      // Special case for GtkMenu because gtk_menu_attach_to_widget does
      // not set widget->parent but gtk_menu_item_destroy() destroys the menu
      // like gtk_container_destroy()
      // Gtk::Menu does not use a parent widget because it must
      // be contained in its Gtk::Window so that it can be displayed as a popup.
      else if (GTK_IS_MENU(pWidget) && GTK_IS_MENU_ITEM(gtk_menu_get_attach_widget(GTK_MENU(pWidget))))
      {
         gtk_menu_detach(GTK_MENU(pWidget));
      }

      #ifdef GLIBMM_DEBUG_REFCOUNTING
      g_warning("Widget_Class::dispose_vfunc_callback(): before gtk_widget_hide().");
      #endif

      // Now hide the widget.  The C++ object must _not_ be accessed anymore
      // after this call, because a signal_hide() handler might delete it.
      gtk_widget_hide(pWidget);

      #ifdef GLIBMM_DEBUG_REFCOUNTING
      g_warning("Widget_Class::dispose_vfunc_callback(): after gtk_widget_hide().");
      #endif

      // GTKMM_LIFECYCLE
      return; // Prevent calling of normal C dispose vfunc (see below)
    }

    #ifdef GLIBMM_DEBUG_REFCOUNTING
    g_warning("Widget_Class::dispose_vfunc_callback(): unreferenced: before gtk_widget_hide().");
    #endif

    // Always hide widgets on object destruction, regardless of whether
    // the widget is managed or not.  This is done for consistency so that
    // connecting to signal_hide() is guaranteed to work.
    gtk_widget_hide(pWidget);

    #ifdef GLIBMM_DEBUG_REFCOUNTING
    g_warning("Widget_Class::dispose_vfunc_callback(): unreferenced:  after gtk_widget_hide().");
    #endif
  }

  const auto base = static_cast<GObjectClass*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)));

  #ifdef GLIBMM_DEBUG_REFCOUNTING
  g_warning("Widget_Class::dispose_vfunc_callback(): before calling base->dispose.");
  #endif

  if(base->dispose)
    (*base->dispose)(self);

  #ifdef GLIBMM_DEBUG_REFCOUNTING
  g_warning("Widget_Class::dispose_vfunc_callback(): after calling base->dispose.");
  #endif
}

Glib::ustring Widget::drag_dest_find_target(const Glib::RefPtr<Gdk::DragContext>& context) const
{
  return Gdk::AtomUstring::to_cpp_type(gtk_drag_dest_find_target(const_cast<GtkWidget*>(gobj()), Glib::unwrap(context), nullptr /* See GTK+ docs */));
}

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Widget::draw_insertion_cursor(const Cairo::RefPtr<Cairo::Context>& cr, const Gdk::Rectangle& location, bool is_primary, TextDirection direction, bool draw_arrow)
{
  gtk_draw_insertion_cursor(gobj(), cr->cobj(), const_cast<GdkRectangle*>(location.gobj()), is_primary, (GtkTextDirection)direction, draw_arrow);
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
Requisition Widget::get_requisition() const
{
  Requisition result = {0, 0};
  gtk_widget_get_requisition(const_cast<GtkWidget*>(gobj()), &result);
  return result;
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

#ifndef GTKMM_DISABLE_DEPRECATED

G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Widget::unset_color(StateFlags state)
{
   gtk_widget_override_color(gobj(), ((GtkStateFlags)(state)), nullptr);
}

void Widget::unset_background_color(StateFlags state)
{
  gtk_widget_override_background_color(gobj(), ((GtkStateFlags)(state)), nullptr);
}

void Widget::unset_font()
{
  gtk_widget_override_font(gobj(), nullptr);
}

void Widget::unset_symbolic_color(const Glib::ustring& name)
{
  gtk_widget_override_symbolic_color(gobj(), name.c_str(), nullptr);
}

void Widget::unset_cursor()
{
  gtk_widget_override_cursor(gobj(), nullptr, nullptr);
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED


void Widget::unset_font_options()
{
  gtk_widget_set_font_options(gobj(), nullptr);
}

void Widget::transform_cairo_context_to_window(const Cairo::RefPtr<Cairo::Context>& cr, const Glib::RefPtr<const Gdk::Window>& window)
{
  gtk_cairo_transform_to_window((cr)->cobj(), gobj(), const_cast<GdkWindow*>(Glib::unwrap<Gdk::Window>(window)));
}

void Widget::remove_action_group(const Glib::ustring& name)
{
  gtk_widget_insert_action_group(gobj(), name.c_str(), nullptr /* see C docs */);
}

guint Widget::add_tick_callback(const SlotTick& slot)
{
  // Create a copy of the slot object. A pointer to this will be passed
  // through the callback's data parameter. It will be deleted
  // when Glib::destroy_notify_delete<SlotTick>() is called.
  auto slot_copy = new SlotTick(slot);

  return gtk_widget_add_tick_callback(gobj(), &SlotTick_gtk_callback, slot_copy,
    &Glib::destroy_notify_delete<SlotTick>);
}

} // namespace Gtk

namespace
{


static const Glib::SignalProxyInfo Widget_signal_show_info =
{
  "show",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Widget_signal_hide_info =
{
  "hide",
  (GCallback) &Widget_signal_hide_callback,
  (GCallback) &Widget_signal_hide_callback
};


static const Glib::SignalProxyInfo Widget_signal_map_info =
{
  "map",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Widget_signal_unmap_info =
{
  "unmap",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Widget_signal_realize_info =
{
  "realize",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Widget_signal_unrealize_info =
{
  "unrealize",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Widget_signal_size_allocate_callback(GtkWidget* self, GdkRectangle* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,Allocation& >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))((Allocation&)(Glib::wrap(p0))
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_size_allocate_info =
{
  "size_allocate",
  (GCallback) &Widget_signal_size_allocate_callback,
  (GCallback) &Widget_signal_size_allocate_callback
};


#ifndef GTKMM_DISABLE_DEPRECATED


static void Widget_signal_state_changed_callback(GtkWidget* self, GtkStateType p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,Gtk::StateType >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(((Gtk::StateType)(p0))
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_state_changed_info =
{
  "state_changed",
  (GCallback) &Widget_signal_state_changed_callback,
  (GCallback) &Widget_signal_state_changed_callback
};

#endif // GTKMM_DISABLE_DEPRECATED


static void Widget_signal_state_flags_changed_callback(GtkWidget* self, GtkStateFlags p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,Gtk::StateFlags >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(((Gtk::StateFlags)(p0))
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_state_flags_changed_info =
{
  "state-flags-changed",
  (GCallback) &Widget_signal_state_flags_changed_callback,
  (GCallback) &Widget_signal_state_flags_changed_callback
};


static void Widget_signal_parent_changed_callback(GtkWidget* self, GtkWidget* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,Widget* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_parent_changed_info =
{
  "parent_set",
  (GCallback) &Widget_signal_parent_changed_callback,
  (GCallback) &Widget_signal_parent_changed_callback
};


static void Widget_signal_hierarchy_changed_callback(GtkWidget* self, GtkWidget* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,Widget* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_hierarchy_changed_info =
{
  "hierarchy_changed",
  (GCallback) &Widget_signal_hierarchy_changed_callback,
  (GCallback) &Widget_signal_hierarchy_changed_callback
};


static const Glib::SignalProxyInfo Widget_signal_style_updated_info =
{
  "style_updated",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Widget_signal_direction_changed_callback(GtkWidget* self, GtkTextDirection p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,TextDirection >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(((TextDirection)(p0))
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_direction_changed_info =
{
  "direction_changed",
  (GCallback) &Widget_signal_direction_changed_callback,
  (GCallback) &Widget_signal_direction_changed_callback
};


static void Widget_signal_grab_notify_callback(GtkWidget* self, gboolean p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,bool >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_grab_notify_info =
{
  "grab_notify",
  (GCallback) &Widget_signal_grab_notify_callback,
  (GCallback) &Widget_signal_grab_notify_callback
};


static void Widget_signal_child_notify_callback(GtkWidget* self, GParamSpec* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GParamSpec* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_child_notify_info =
{
  "child_notify",
  (GCallback) &Widget_signal_child_notify_callback,
  (GCallback) &Widget_signal_child_notify_callback
};


static gboolean Widget_signal_mnemonic_activate_callback(GtkWidget* self, gboolean p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,bool >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_mnemonic_activate_notify_callback(GtkWidget* self, gboolean p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,bool >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_mnemonic_activate_info =
{
  "mnemonic_activate",
  (GCallback) &Widget_signal_mnemonic_activate_callback,
  (GCallback) &Widget_signal_mnemonic_activate_notify_callback
};


static const Glib::SignalProxyInfo Widget_signal_grab_focus_info =
{
  "grab_focus",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static gboolean Widget_signal_focus_callback(GtkWidget* self, GtkDirectionType p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,DirectionType >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(((DirectionType)(p0))
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_focus_notify_callback(GtkWidget* self, GtkDirectionType p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,DirectionType >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(((DirectionType)(p0))
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_focus_info =
{
  "focus",
  (GCallback) &Widget_signal_focus_callback,
  (GCallback) &Widget_signal_focus_notify_callback
};


static gboolean Widget_signal_event_callback(GtkWidget* self, GdkEvent* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEvent* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_event_notify_callback(GtkWidget* self, GdkEvent* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEvent* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_event_info =
{
  "event",
  (GCallback) &Widget_signal_event_callback,
  (GCallback) &Widget_signal_event_notify_callback
};


static void Widget_signal_event_after_callback(GtkWidget* self, GdkEvent* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEvent* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_event_after_info =
{
  "event_after",
  (GCallback) &Widget_signal_event_after_callback,
  (GCallback) &Widget_signal_event_after_callback
};


static gboolean Widget_signal_button_press_event_callback(GtkWidget* self, GdkEventButton* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventButton* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_button_press_event_notify_callback(GtkWidget* self, GdkEventButton* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventButton* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_button_press_event_info =
{
  "button_press_event",
  (GCallback) &Widget_signal_button_press_event_callback,
  (GCallback) &Widget_signal_button_press_event_notify_callback
};


static gboolean Widget_signal_button_release_event_callback(GtkWidget* self, GdkEventButton* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventButton* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_button_release_event_notify_callback(GtkWidget* self, GdkEventButton* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventButton* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_button_release_event_info =
{
  "button_release_event",
  (GCallback) &Widget_signal_button_release_event_callback,
  (GCallback) &Widget_signal_button_release_event_notify_callback
};


static gboolean Widget_signal_scroll_event_callback(GtkWidget* self, GdkEventScroll* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventScroll* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_scroll_event_notify_callback(GtkWidget* self, GdkEventScroll* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventScroll* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_scroll_event_info =
{
  "scroll_event",
  (GCallback) &Widget_signal_scroll_event_callback,
  (GCallback) &Widget_signal_scroll_event_notify_callback
};


static gboolean Widget_signal_motion_notify_event_callback(GtkWidget* self, GdkEventMotion* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventMotion* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_motion_notify_event_notify_callback(GtkWidget* self, GdkEventMotion* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventMotion* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_motion_notify_event_info =
{
  "motion_notify_event",
  (GCallback) &Widget_signal_motion_notify_event_callback,
  (GCallback) &Widget_signal_motion_notify_event_notify_callback
};


static gboolean Widget_signal_delete_event_callback(GtkWidget* self, GdkEventAny* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventAny* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_delete_event_notify_callback(GtkWidget* self, GdkEventAny* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventAny* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_delete_event_info =
{
  "delete_event",
  (GCallback) &Widget_signal_delete_event_callback,
  (GCallback) &Widget_signal_delete_event_notify_callback
};


static gboolean Widget_signal_draw_callback(GtkWidget* self, cairo_t* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,const ::Cairo::RefPtr< ::Cairo::Context>& >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(::Cairo::RefPtr< ::Cairo::Context>(new ::Cairo::Context(p0, false /* has_reference */))
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_draw_notify_callback(GtkWidget* self, cairo_t* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,const ::Cairo::RefPtr< ::Cairo::Context>& >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(::Cairo::RefPtr< ::Cairo::Context>(new ::Cairo::Context(p0, false /* has_reference */))
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_draw_info =
{
  "draw",
  (GCallback) &Widget_signal_draw_callback,
  (GCallback) &Widget_signal_draw_notify_callback
};


static gboolean Widget_signal_key_press_event_callback(GtkWidget* self, GdkEventKey* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventKey* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_key_press_event_notify_callback(GtkWidget* self, GdkEventKey* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventKey* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_key_press_event_info =
{
  "key_press_event",
  (GCallback) &Widget_signal_key_press_event_callback,
  (GCallback) &Widget_signal_key_press_event_notify_callback
};


static gboolean Widget_signal_key_release_event_callback(GtkWidget* self, GdkEventKey* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventKey* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_key_release_event_notify_callback(GtkWidget* self, GdkEventKey* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventKey* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_key_release_event_info =
{
  "key_release_event",
  (GCallback) &Widget_signal_key_release_event_callback,
  (GCallback) &Widget_signal_key_release_event_notify_callback
};


static gboolean Widget_signal_enter_notify_event_callback(GtkWidget* self, GdkEventCrossing* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventCrossing* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_enter_notify_event_notify_callback(GtkWidget* self, GdkEventCrossing* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventCrossing* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_enter_notify_event_info =
{
  "enter_notify_event",
  (GCallback) &Widget_signal_enter_notify_event_callback,
  (GCallback) &Widget_signal_enter_notify_event_notify_callback
};


static gboolean Widget_signal_leave_notify_event_callback(GtkWidget* self, GdkEventCrossing* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventCrossing* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_leave_notify_event_notify_callback(GtkWidget* self, GdkEventCrossing* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventCrossing* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_leave_notify_event_info =
{
  "leave_notify_event",
  (GCallback) &Widget_signal_leave_notify_event_callback,
  (GCallback) &Widget_signal_leave_notify_event_notify_callback
};


static gboolean Widget_signal_configure_event_callback(GtkWidget* self, GdkEventConfigure* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventConfigure* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_configure_event_notify_callback(GtkWidget* self, GdkEventConfigure* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventConfigure* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_configure_event_info =
{
  "configure_event",
  (GCallback) &Widget_signal_configure_event_callback,
  (GCallback) &Widget_signal_configure_event_notify_callback
};


static gboolean Widget_signal_focus_in_event_callback(GtkWidget* self, GdkEventFocus* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventFocus* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_focus_in_event_notify_callback(GtkWidget* self, GdkEventFocus* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventFocus* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_focus_in_event_info =
{
  "focus_in_event",
  (GCallback) &Widget_signal_focus_in_event_callback,
  (GCallback) &Widget_signal_focus_in_event_notify_callback
};


static gboolean Widget_signal_focus_out_event_callback(GtkWidget* self, GdkEventFocus* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventFocus* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_focus_out_event_notify_callback(GtkWidget* self, GdkEventFocus* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventFocus* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_focus_out_event_info =
{
  "focus_out_event",
  (GCallback) &Widget_signal_focus_out_event_callback,
  (GCallback) &Widget_signal_focus_out_event_notify_callback
};


static gboolean Widget_signal_map_event_callback(GtkWidget* self, GdkEventAny* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventAny* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_map_event_notify_callback(GtkWidget* self, GdkEventAny* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventAny* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_map_event_info =
{
  "map_event",
  (GCallback) &Widget_signal_map_event_callback,
  (GCallback) &Widget_signal_map_event_notify_callback
};


static gboolean Widget_signal_unmap_event_callback(GtkWidget* self, GdkEventAny* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventAny* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_unmap_event_notify_callback(GtkWidget* self, GdkEventAny* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventAny* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_unmap_event_info =
{
  "unmap_event",
  (GCallback) &Widget_signal_unmap_event_callback,
  (GCallback) &Widget_signal_unmap_event_notify_callback
};


static gboolean Widget_signal_property_notify_event_callback(GtkWidget* self, GdkEventProperty* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventProperty* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_property_notify_event_notify_callback(GtkWidget* self, GdkEventProperty* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventProperty* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_property_notify_event_info =
{
  "property_notify_event",
  (GCallback) &Widget_signal_property_notify_event_callback,
  (GCallback) &Widget_signal_property_notify_event_notify_callback
};


static gboolean Widget_signal_selection_clear_event_callback(GtkWidget* self, GdkEventSelection* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventSelection* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_selection_clear_event_notify_callback(GtkWidget* self, GdkEventSelection* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventSelection* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_selection_clear_event_info =
{
  "selection_clear_event",
  (GCallback) &Widget_signal_selection_clear_event_callback,
  (GCallback) &Widget_signal_selection_clear_event_notify_callback
};


static gboolean Widget_signal_selection_request_event_callback(GtkWidget* self, GdkEventSelection* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventSelection* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_selection_request_event_notify_callback(GtkWidget* self, GdkEventSelection* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventSelection* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_selection_request_event_info =
{
  "selection_request_event",
  (GCallback) &Widget_signal_selection_request_event_callback,
  (GCallback) &Widget_signal_selection_request_event_notify_callback
};


static gboolean Widget_signal_selection_notify_event_callback(GtkWidget* self, GdkEventSelection* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventSelection* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_selection_notify_event_notify_callback(GtkWidget* self, GdkEventSelection* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventSelection* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_selection_notify_event_info =
{
  "selection_notify_event",
  (GCallback) &Widget_signal_selection_notify_event_callback,
  (GCallback) &Widget_signal_selection_notify_event_notify_callback
};


static gboolean Widget_signal_proximity_in_event_callback(GtkWidget* self, GdkEventProximity* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventProximity* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_proximity_in_event_notify_callback(GtkWidget* self, GdkEventProximity* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventProximity* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_proximity_in_event_info =
{
  "proximity_in_event",
  (GCallback) &Widget_signal_proximity_in_event_callback,
  (GCallback) &Widget_signal_proximity_in_event_notify_callback
};


static gboolean Widget_signal_proximity_out_event_callback(GtkWidget* self, GdkEventProximity* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventProximity* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_proximity_out_event_notify_callback(GtkWidget* self, GdkEventProximity* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventProximity* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_proximity_out_event_info =
{
  "proximity_out_event",
  (GCallback) &Widget_signal_proximity_out_event_callback,
  (GCallback) &Widget_signal_proximity_out_event_notify_callback
};


#ifndef GTKMM_DISABLE_DEPRECATED


static gboolean Widget_signal_visibility_notify_event_callback(GtkWidget* self, GdkEventVisibility* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventVisibility* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_visibility_notify_event_notify_callback(GtkWidget* self, GdkEventVisibility* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventVisibility* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_visibility_notify_event_info =
{
  "visibility_notify_event",
  (GCallback) &Widget_signal_visibility_notify_event_callback,
  (GCallback) &Widget_signal_visibility_notify_event_notify_callback
};

#endif // GTKMM_DISABLE_DEPRECATED


static gboolean Widget_signal_window_state_event_callback(GtkWidget* self, GdkEventWindowState* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventWindowState* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_window_state_event_notify_callback(GtkWidget* self, GdkEventWindowState* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventWindowState* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_window_state_event_info =
{
  "window_state_event",
  (GCallback) &Widget_signal_window_state_event_callback,
  (GCallback) &Widget_signal_window_state_event_notify_callback
};


static const Glib::SignalProxyInfo Widget_signal_selection_get_info =
{
  "selection_get",
  (GCallback) &Widget_signal_selection_get_callback,
  (GCallback) &Widget_signal_selection_get_callback
};


static void Widget_signal_selection_received_callback(GtkWidget* self, GtkSelectionData* p0,guint p1,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,const SelectionData&,guint >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(SelectionData_WithoutOwnership(p0)
, p1);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_selection_received_info =
{
  "selection_received",
  (GCallback) &Widget_signal_selection_received_callback,
  (GCallback) &Widget_signal_selection_received_callback
};


static void Widget_signal_drag_begin_callback(GtkWidget* self, GdkDragContext* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,const Glib::RefPtr<Gdk::DragContext>& >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_drag_begin_info =
{
  "drag_begin",
  (GCallback) &Widget_signal_drag_begin_callback,
  (GCallback) &Widget_signal_drag_begin_callback
};


static void Widget_signal_drag_end_callback(GtkWidget* self, GdkDragContext* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,const Glib::RefPtr<Gdk::DragContext>& >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_drag_end_info =
{
  "drag_end",
  (GCallback) &Widget_signal_drag_end_callback,
  (GCallback) &Widget_signal_drag_end_callback
};


static const Glib::SignalProxyInfo Widget_signal_drag_data_get_info =
{
  "drag_data_get",
  (GCallback) &Widget_signal_drag_data_get_callback,
  (GCallback) &Widget_signal_drag_data_get_callback
};


static void Widget_signal_drag_data_delete_callback(GtkWidget* self, GdkDragContext* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,const Glib::RefPtr<Gdk::DragContext>& >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_drag_data_delete_info =
{
  "drag_data_delete",
  (GCallback) &Widget_signal_drag_data_delete_callback,
  (GCallback) &Widget_signal_drag_data_delete_callback
};


static gboolean Widget_signal_drag_failed_callback(GtkWidget* self, GdkDragContext* p0,GtkDragResult p1,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,const Glib::RefPtr<Gdk::DragContext>&,DragResult >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, (DragResult)p1
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_drag_failed_notify_callback(GtkWidget* self, GdkDragContext* p0,GtkDragResult p1, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,const Glib::RefPtr<Gdk::DragContext>&,DragResult >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, (DragResult)p1
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_drag_failed_info =
{
  "drag_failed",
  (GCallback) &Widget_signal_drag_failed_callback,
  (GCallback) &Widget_signal_drag_failed_notify_callback
};


static void Widget_signal_drag_leave_callback(GtkWidget* self, GdkDragContext* p0,guint p1,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,const Glib::RefPtr<Gdk::DragContext>&,guint >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_drag_leave_info =
{
  "drag_leave",
  (GCallback) &Widget_signal_drag_leave_callback,
  (GCallback) &Widget_signal_drag_leave_callback
};


static gboolean Widget_signal_drag_motion_callback(GtkWidget* self, GdkDragContext* p0,gint p1,gint p2,guint p3,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,const Glib::RefPtr<Gdk::DragContext>&,int,int,guint >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1
, p2
, p3));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_drag_motion_notify_callback(GtkWidget* self, GdkDragContext* p0,gint p1,gint p2,guint p3, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,const Glib::RefPtr<Gdk::DragContext>&,int,int,guint >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1
, p2
, p3);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_drag_motion_info =
{
  "drag_motion",
  (GCallback) &Widget_signal_drag_motion_callback,
  (GCallback) &Widget_signal_drag_motion_notify_callback
};


static gboolean Widget_signal_drag_drop_callback(GtkWidget* self, GdkDragContext* p0,gint p1,gint p2,guint p3,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,const Glib::RefPtr<Gdk::DragContext>&,int,int,guint >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1
, p2
, p3));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_drag_drop_notify_callback(GtkWidget* self, GdkDragContext* p0,gint p1,gint p2,guint p3, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,const Glib::RefPtr<Gdk::DragContext>&,int,int,guint >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1
, p2
, p3);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_drag_drop_info =
{
  "drag_drop",
  (GCallback) &Widget_signal_drag_drop_callback,
  (GCallback) &Widget_signal_drag_drop_notify_callback
};


static void Widget_signal_drag_data_received_callback(GtkWidget* self, GdkDragContext* p0,gint p1,gint p2,GtkSelectionData* p3,guint p4,guint p5,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,const Glib::RefPtr<Gdk::DragContext>&,int,int,const SelectionData&,guint,guint >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1
, p2
, SelectionData_WithoutOwnership(p3)
, p4, p5);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_drag_data_received_info =
{
  "drag_data_received",
  (GCallback) &Widget_signal_drag_data_received_callback,
  (GCallback) &Widget_signal_drag_data_received_callback
};


static void Widget_signal_screen_changed_callback(GtkWidget* self, GdkScreen* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,const Glib::RefPtr<Gdk::Screen>& >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_screen_changed_info =
{
  "screen_changed",
  (GCallback) &Widget_signal_screen_changed_callback,
  (GCallback) &Widget_signal_screen_changed_callback
};


#ifndef GTKMM_DISABLE_DEPRECATED


static const Glib::SignalProxyInfo Widget_signal_composited_changed_info =
{
  "composited_changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

#endif // GTKMM_DISABLE_DEPRECATED


static gboolean Widget_signal_popup_menu_callback(GtkWidget* self, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))());
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_popup_menu_notify_callback(GtkWidget* self,  void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_popup_menu_info =
{
  "popup_menu",
  (GCallback) &Widget_signal_popup_menu_callback,
  (GCallback) &Widget_signal_popup_menu_notify_callback
};


static gboolean Widget_signal_query_tooltip_callback(GtkWidget* self, gint p0,gint p1,gboolean p2,GtkTooltip* p3,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,int,int,bool,const Glib::RefPtr<Tooltip>& >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0
, p1
, p2
, Glib::wrap(p3, true)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_query_tooltip_notify_callback(GtkWidget* self, gint p0,gint p1,gboolean p2,GtkTooltip* p3, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,int,int,bool,const Glib::RefPtr<Tooltip>& >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
, p1
, p2
, Glib::wrap(p3, true)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_query_tooltip_info =
{
  "query_tooltip",
  (GCallback) &Widget_signal_query_tooltip_callback,
  (GCallback) &Widget_signal_query_tooltip_notify_callback
};


static gboolean Widget_signal_grab_broken_event_callback(GtkWidget* self, GdkEventGrabBroken* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventGrabBroken* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_grab_broken_event_notify_callback(GtkWidget* self, GdkEventGrabBroken* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventGrabBroken* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_grab_broken_event_info =
{
  "grab_broken_event",
  (GCallback) &Widget_signal_grab_broken_event_callback,
  (GCallback) &Widget_signal_grab_broken_event_notify_callback
};


static gboolean Widget_signal_damage_event_callback(GtkWidget* self, GdkEventExpose* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventExpose* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_damage_event_notify_callback(GtkWidget* self, GdkEventExpose* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventExpose* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_damage_event_info =
{
  "damage-event",
  (GCallback) &Widget_signal_damage_event_callback,
  (GCallback) &Widget_signal_damage_event_notify_callback
};


static gboolean Widget_signal_touch_event_callback(GtkWidget* self, GdkEventTouch* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< bool,GdkEventTouch* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_touch_event_notify_callback(GtkWidget* self, GdkEventTouch* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot< void,GdkEventTouch* >;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_touch_event_info =
{
  "touch_event",
  (GCallback) &Widget_signal_touch_event_callback,
  (GCallback) &Widget_signal_touch_event_notify_callback
};


} // anonymous namespace

// static
GType Glib::Value<Gtk::DestDefaults>::value_type()
{
  return gtk_dest_defaults_get_type();
}

// static
GType Glib::Value<Gtk::WidgetHelpType>::value_type()
{
  return gtk_widget_help_type_get_type();
}

// static
GType Glib::Value<Gtk::DragResult>::value_type()
{
  return gtk_drag_result_get_type();
}


namespace Glib
{

Gtk::Widget* wrap(GtkWidget* object, bool take_copy)
{
  return dynamic_cast<Gtk::Widget *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& Widget_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Widget_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_widget_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  Buildable::add_interface(get_type());
#ifdef GTKMM_ATKMM_ENABLED
  Atk::Implementor::add_interface(get_type());

#endif // GTKMM_ATKMM_ENABLED

  }

  return *this;
}


void Widget_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

    reinterpret_cast<GObjectClass*>(klass)->dispose = &dispose_vfunc_callback;
    klass->dispatch_child_properties_changed = &dispatch_child_properties_changed_vfunc_callback;
  klass->show_all = &show_all_vfunc_callback;
#ifdef GTKMM_ATKMM_ENABLED
  klass->get_accessible = &get_accessible_vfunc_callback;
#endif // GTKMM_ATKMM_ENABLED
  klass->get_request_mode = &get_request_mode_vfunc_callback;
  klass->get_preferred_width = &get_preferred_width_vfunc_callback;
  klass->get_preferred_height_for_width = &get_preferred_height_for_width_vfunc_callback;
  klass->get_preferred_height = &get_preferred_height_vfunc_callback;
  klass->get_preferred_width_for_height = &get_preferred_width_for_height_vfunc_callback;

  klass->show = &show_callback;
  klass->hide = &hide_callback;
  klass->map = &map_callback;
  klass->unmap = &unmap_callback;
  klass->realize = &realize_callback;
  klass->unrealize = &unrealize_callback;
  klass->size_allocate = &size_allocate_callback;
#ifndef GTKMM_DISABLE_DEPRECATED

  klass->state_changed = &state_changed_callback;
#endif // GTKMM_DISABLE_DEPRECATED

  klass->parent_set = &parent_set_callback;
  klass->hierarchy_changed = &hierarchy_changed_callback;
  klass->style_updated = &style_updated_callback;
  klass->direction_changed = &direction_changed_callback;
  klass->grab_notify = &grab_notify_callback;
  klass->child_notify = &child_notify_callback;
  klass->mnemonic_activate = &mnemonic_activate_callback;
  klass->grab_focus = &grab_focus_callback;
  klass->focus = &focus_callback;
  klass->event = &event_callback;
  klass->button_press_event = &button_press_event_callback;
  klass->button_release_event = &button_release_event_callback;
  klass->scroll_event = &scroll_event_callback;
  klass->motion_notify_event = &motion_notify_event_callback;
  klass->delete_event = &delete_event_callback;
  klass->draw = &draw_callback;
  klass->key_press_event = &key_press_event_callback;
  klass->key_release_event = &key_release_event_callback;
  klass->enter_notify_event = &enter_notify_event_callback;
  klass->leave_notify_event = &leave_notify_event_callback;
  klass->configure_event = &configure_event_callback;
  klass->focus_in_event = &focus_in_event_callback;
  klass->focus_out_event = &focus_out_event_callback;
  klass->map_event = &map_event_callback;
  klass->unmap_event = &unmap_event_callback;
  klass->property_notify_event = &property_notify_event_callback;
  klass->selection_clear_event = &selection_clear_event_callback;
  klass->selection_request_event = &selection_request_event_callback;
  klass->selection_notify_event = &selection_notify_event_callback;
  klass->proximity_in_event = &proximity_in_event_callback;
  klass->proximity_out_event = &proximity_out_event_callback;
#ifndef GTKMM_DISABLE_DEPRECATED

  klass->visibility_notify_event = &visibility_notify_event_callback;
#endif // GTKMM_DISABLE_DEPRECATED

  klass->window_state_event = &window_state_event_callback;
  klass->selection_get = &selection_get_callback;
  klass->selection_received = &selection_received_callback;
  klass->drag_begin = &drag_begin_callback;
  klass->drag_end = &drag_end_callback;
  klass->drag_data_get = &drag_data_get_callback;
  klass->drag_data_delete = &drag_data_delete_callback;
  klass->drag_leave = &drag_leave_callback;
  klass->drag_motion = &drag_motion_callback;
  klass->drag_drop = &drag_drop_callback;
  klass->drag_data_received = &drag_data_received_callback;
  klass->screen_changed = &screen_changed_callback;
    klass->hierarchy_changed = &hierarchy_changed_callback_custom;
      klass->parent_set = &parent_set_callback_custom;
  }

void Widget_Class::dispatch_child_properties_changed_vfunc_callback(GtkWidget* self, guint n_pspecs, GParamSpec** pspecs)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->dispatch_child_properties_changed_vfunc(n_pspecs, pspecs);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->dispatch_child_properties_changed)
    (*base->dispatch_child_properties_changed)(self, n_pspecs, pspecs);
}
void Widget_Class::show_all_vfunc_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->show_all_vfunc();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->show_all)
    (*base->show_all)(self);
}
#ifdef GTKMM_ATKMM_ENABLED
AtkObject* Widget_Class::get_accessible_vfunc_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return Glib::unwrap(obj->get_accessible_vfunc());
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->get_accessible)
    return (*base->get_accessible)(self);

  using RType = AtkObject*;
  return RType();
}
#endif // GTKMM_ATKMM_ENABLED
GtkSizeRequestMode Widget_Class::get_request_mode_vfunc_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return ((GtkSizeRequestMode)(obj->get_request_mode_vfunc()));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->get_request_mode)
    return (*base->get_request_mode)(self);

  using RType = GtkSizeRequestMode;
  return RType();
}

void Widget_Class::show_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_show();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->show)
    (*base->show)(self);
}
void Widget_Class::map_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_map();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->map)
    (*base->map)(self);
}
void Widget_Class::unmap_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_unmap();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->unmap)
    (*base->unmap)(self);
}
void Widget_Class::realize_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_realize();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->realize)
    (*base->realize)(self);
}
void Widget_Class::unrealize_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_unrealize();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->unrealize)
    (*base->unrealize)(self);
}
void Widget_Class::size_allocate_callback(GtkWidget* self, GdkRectangle* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_size_allocate((Allocation&)(Glib::wrap(p0))
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->size_allocate)
    (*base->size_allocate)(self, p0);
}
#ifndef GTKMM_DISABLE_DEPRECATED

void Widget_Class::state_changed_callback(GtkWidget* self, GtkStateType p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_state_changed(((Gtk::StateType)(p0))
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->state_changed)
    (*base->state_changed)(self, p0);
}
#endif // GTKMM_DISABLE_DEPRECATED

void Widget_Class::parent_set_callback(GtkWidget* self, GtkWidget* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_parent_changed(Glib::wrap(p0)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->parent_set)
    (*base->parent_set)(self, p0);
}
void Widget_Class::hierarchy_changed_callback(GtkWidget* self, GtkWidget* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_hierarchy_changed(Glib::wrap(p0)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->hierarchy_changed)
    (*base->hierarchy_changed)(self, p0);
}
void Widget_Class::style_updated_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_style_updated();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->style_updated)
    (*base->style_updated)(self);
}
void Widget_Class::direction_changed_callback(GtkWidget* self, GtkTextDirection p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_direction_changed(((TextDirection)(p0))
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->direction_changed)
    (*base->direction_changed)(self, p0);
}
void Widget_Class::grab_notify_callback(GtkWidget* self, gboolean p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_grab_notify(p0
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->grab_notify)
    (*base->grab_notify)(self, p0);
}
void Widget_Class::child_notify_callback(GtkWidget* self, GParamSpec* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_child_notify(p0);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->child_notify)
    (*base->child_notify)(self, p0);
}
gboolean Widget_Class::mnemonic_activate_callback(GtkWidget* self, gboolean p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_mnemonic_activate(p0
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->mnemonic_activate)
    return (*base->mnemonic_activate)(self, p0);

  using RType = gboolean;
  return RType();
}
void Widget_Class::grab_focus_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_grab_focus();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->grab_focus)
    (*base->grab_focus)(self);
}
gboolean Widget_Class::focus_callback(GtkWidget* self, GtkDirectionType p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_focus(((DirectionType)(p0))
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->focus)
    return (*base->focus)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::event_callback(GtkWidget* self, GdkEvent* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_event(p0));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->event)
    return (*base->event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::button_press_event_callback(GtkWidget* self, GdkEventButton* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_button_press_event(p0));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->button_press_event)
    return (*base->button_press_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::button_release_event_callback(GtkWidget* self, GdkEventButton* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_button_release_event(p0));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->button_release_event)
    return (*base->button_release_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::scroll_event_callback(GtkWidget* self, GdkEventScroll* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_scroll_event(p0));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->scroll_event)
    return (*base->scroll_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::motion_notify_event_callback(GtkWidget* self, GdkEventMotion* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_motion_notify_event(p0));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->motion_notify_event)
    return (*base->motion_notify_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::delete_event_callback(GtkWidget* self, GdkEventAny* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_delete_event(p0));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->delete_event)
    return (*base->delete_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::draw_callback(GtkWidget* self, cairo_t* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_draw(::Cairo::RefPtr< ::Cairo::Context>(new ::Cairo::Context(p0, false /* has_reference */))
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->draw)
    return (*base->draw)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::key_press_event_callback(GtkWidget* self, GdkEventKey* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_key_press_event(p0));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->key_press_event)
    return (*base->key_press_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::key_release_event_callback(GtkWidget* self, GdkEventKey* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_key_release_event(p0));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->key_release_event)
    return (*base->key_release_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::enter_notify_event_callback(GtkWidget* self, GdkEventCrossing* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_enter_notify_event(p0));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->enter_notify_event)
    return (*base->enter_notify_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::leave_notify_event_callback(GtkWidget* self, GdkEventCrossing* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_leave_notify_event(p0));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->leave_notify_event)
    return (*base->leave_notify_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::configure_event_callback(GtkWidget* self, GdkEventConfigure* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_configure_event(p0));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->configure_event)
    return (*base->configure_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::focus_in_event_callback(GtkWidget* self, GdkEventFocus* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_focus_in_event(p0));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->focus_in_event)
    return (*base->focus_in_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::focus_out_event_callback(GtkWidget* self, GdkEventFocus* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_focus_out_event(p0));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->focus_out_event)
    return (*base->focus_out_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::map_event_callback(GtkWidget* self, GdkEventAny* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_map_event(p0));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->map_event)
    return (*base->map_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::unmap_event_callback(GtkWidget* self, GdkEventAny* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_unmap_event(p0));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->unmap_event)
    return (*base->unmap_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::property_notify_event_callback(GtkWidget* self, GdkEventProperty* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_property_notify_event(p0));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->property_notify_event)
    return (*base->property_notify_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::selection_clear_event_callback(GtkWidget* self, GdkEventSelection* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_selection_clear_event(p0));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->selection_clear_event)
    return (*base->selection_clear_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::selection_request_event_callback(GtkWidget* self, GdkEventSelection* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_selection_request_event(p0));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->selection_request_event)
    return (*base->selection_request_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::selection_notify_event_callback(GtkWidget* self, GdkEventSelection* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_selection_notify_event(p0));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->selection_notify_event)
    return (*base->selection_notify_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::proximity_in_event_callback(GtkWidget* self, GdkEventProximity* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_proximity_in_event(p0));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->proximity_in_event)
    return (*base->proximity_in_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::proximity_out_event_callback(GtkWidget* self, GdkEventProximity* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_proximity_out_event(p0));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->proximity_out_event)
    return (*base->proximity_out_event)(self, p0);

  using RType = gboolean;
  return RType();
}
#ifndef GTKMM_DISABLE_DEPRECATED

gboolean Widget_Class::visibility_notify_event_callback(GtkWidget* self, GdkEventVisibility* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_visibility_notify_event(p0));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->visibility_notify_event)
    return (*base->visibility_notify_event)(self, p0);

  using RType = gboolean;
  return RType();
}
#endif // GTKMM_DISABLE_DEPRECATED

gboolean Widget_Class::window_state_event_callback(GtkWidget* self, GdkEventWindowState* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_window_state_event(p0));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->window_state_event)
    return (*base->window_state_event)(self, p0);

  using RType = gboolean;
  return RType();
}
void Widget_Class::selection_received_callback(GtkWidget* self, GtkSelectionData* p0, guint p1)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_selection_received(SelectionData_WithoutOwnership(p0)
, p1);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->selection_received)
    (*base->selection_received)(self, p0, p1);
}
void Widget_Class::drag_begin_callback(GtkWidget* self, GdkDragContext* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_drag_begin(Glib::wrap(p0, true)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->drag_begin)
    (*base->drag_begin)(self, p0);
}
void Widget_Class::drag_end_callback(GtkWidget* self, GdkDragContext* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_drag_end(Glib::wrap(p0, true)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->drag_end)
    (*base->drag_end)(self, p0);
}
void Widget_Class::drag_data_delete_callback(GtkWidget* self, GdkDragContext* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_drag_data_delete(Glib::wrap(p0, true)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->drag_data_delete)
    (*base->drag_data_delete)(self, p0);
}
void Widget_Class::drag_leave_callback(GtkWidget* self, GdkDragContext* p0, guint p1)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_drag_leave(Glib::wrap(p0, true)
, p1);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->drag_leave)
    (*base->drag_leave)(self, p0, p1);
}
gboolean Widget_Class::drag_motion_callback(GtkWidget* self, GdkDragContext* p0, gint p1, gint p2, guint p3)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_drag_motion(Glib::wrap(p0, true)
, p1
, p2
, p3));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->drag_motion)
    return (*base->drag_motion)(self, p0, p1, p2, p3);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::drag_drop_callback(GtkWidget* self, GdkDragContext* p0, gint p1, gint p2, guint p3)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_drag_drop(Glib::wrap(p0, true)
, p1
, p2
, p3));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->drag_drop)
    return (*base->drag_drop)(self, p0, p1, p2, p3);

  using RType = gboolean;
  return RType();
}
void Widget_Class::drag_data_received_callback(GtkWidget* self, GdkDragContext* p0, gint p1, gint p2, GtkSelectionData* p3, guint p4, guint p5)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_drag_data_received(Glib::wrap(p0, true)
, p1
, p2
, SelectionData_WithoutOwnership(p3)
, p4, p5);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->drag_data_received)
    (*base->drag_data_received)(self, p0, p1, p2, p3, p4, p5);
}
void Widget_Class::screen_changed_callback(GtkWidget* self, GdkScreen* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_screen_changed(Glib::wrap(p0, true)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->screen_changed)
    (*base->screen_changed)(self, p0);
}


Glib::ObjectBase* Widget_Class::wrap_new(GObject* o)
{
  return manage(new Widget((GtkWidget*)(o)));

}


/* The implementation: */

Widget::Widget(const Glib::ConstructParams& construct_params)
:
  Object(construct_params)
{
  }

Widget::Widget(GtkWidget* castitem)
:
  Object((GObject*)(castitem))
{
  }


Widget::Widget(Widget&& src) noexcept
: Object(std::move(src))
  , Buildable(std::move(src))
#ifdef GTKMM_ATKMM_ENABLED
  , Atk::Implementor(std::move(src))

#endif // GTKMM_ATKMM_ENABLED
{}

Widget& Widget::operator=(Widget&& src) noexcept
{
  Object::operator=(std::move(src));
  Buildable::operator=(std::move(src));
#ifdef GTKMM_ATKMM_ENABLED
  Atk::Implementor::operator=(std::move(src));

#endif // GTKMM_ATKMM_ENABLED
  return *this;
}

Widget::CppClassType Widget::widget_class_; // initialize static member

GType Widget::get_type()
{
  return widget_class_.init().get_type();
}


GType Widget::get_base_type()
{
  return gtk_widget_get_type();
}


void Widget::show()
{
  gtk_widget_show(gobj());
}

void Widget::show_now()
{
  gtk_widget_show_now(gobj());
}

void Widget::hide()
{
  gtk_widget_hide(gobj());
}

void Widget::show_all()
{
  gtk_widget_show_all(gobj());
}

void Widget::queue_draw()
{
  gtk_widget_queue_draw(gobj());
}

void Widget::queue_draw_area(int x, int y, int width, int height)
{
  gtk_widget_queue_draw_area(gobj(), x, y, width, height);
}

void Widget::queue_draw_region(const ::Cairo::RefPtr<const ::Cairo::Region>& region)
{
  gtk_widget_queue_draw_region(gobj(), ((region) ? (region)->cobj() : nullptr));
}

void Widget::queue_resize()
{
  gtk_widget_queue_resize(gobj());
}

void Widget::queue_allocate()
{
  gtk_widget_queue_allocate(gobj());
}

void Widget::size_allocate(const Allocation& allocation)
{
  gtk_widget_size_allocate(gobj(), (GtkAllocation*)(allocation.gobj()));
}

void Widget::size_allocate(const Allocation& allocation, int baseline)
{
  gtk_widget_size_allocate_with_baseline(gobj(), (GtkAllocation*)(allocation.gobj()), baseline);
}

SizeRequestMode Widget::get_request_mode() const
{
  return ((SizeRequestMode)(gtk_widget_get_request_mode(const_cast<GtkWidget*>(gobj()))));
}

void Widget::get_preferred_width(int& minimum_width, int& natural_width) const
{
  gtk_widget_get_preferred_width(const_cast<GtkWidget*>(gobj()), &(minimum_width), &(natural_width));
}

void Widget::get_preferred_height_for_width(int width, int& minimum_height, int& natural_height) const
{
  gtk_widget_get_preferred_height_for_width(const_cast<GtkWidget*>(gobj()), width, &(minimum_height), &(natural_height));
}

void Widget::get_preferred_height_for_width(int width, int& minimum_height, int& natural_height, int& minimum_baseline, int& natural_baseline) const
{
  gtk_widget_get_preferred_height_and_baseline_for_width(const_cast<GtkWidget*>(gobj()), width, &(minimum_height), &(natural_height), &(minimum_baseline), &(natural_baseline));
}

void Widget::get_preferred_height(int& minimum_height, int& natural_height) const
{
  gtk_widget_get_preferred_height(const_cast<GtkWidget*>(gobj()), &(minimum_height), &(natural_height));
}

void Widget::get_preferred_width_for_height(int height, int& minimum_width, int& natural_width) const
{
  gtk_widget_get_preferred_width_for_height(const_cast<GtkWidget*>(gobj()), height, &(minimum_width), &(natural_width));
}

void Widget::get_preferred_size(Requisition& minimum_size, Requisition& natural_size) const
{
  gtk_widget_get_preferred_size(const_cast<GtkWidget*>(gobj()), (GtkRequisition*)(&minimum_size), (GtkRequisition*)(&natural_size));
}

void Widget::add_accelerator(const Glib::ustring& accel_signal, const Glib::RefPtr<AccelGroup>& accel_group, guint accel_key, Gdk::ModifierType accel_mods, AccelFlags accel_flags)
{
  gtk_widget_add_accelerator(gobj(), accel_signal.c_str(), Glib::unwrap(accel_group), accel_key, ((GdkModifierType)(accel_mods)), ((GtkAccelFlags)(accel_flags)));
}

bool Widget::remove_accelerator(const Glib::RefPtr<AccelGroup>& accel_group, guint accel_key, Gdk::ModifierType accel_mods)
{
  return gtk_widget_remove_accelerator(gobj(), Glib::unwrap(accel_group), accel_key, ((GdkModifierType)(accel_mods)));
}

void Widget::set_accel_path(const Glib::ustring& accel_path, const Glib::RefPtr<AccelGroup>& accel_group)
{
  gtk_widget_set_accel_path(gobj(), accel_path.c_str(), Glib::unwrap(accel_group));
}

bool Widget::mnemonic_activate(bool group_cycling)
{
  return gtk_widget_mnemonic_activate(gobj(), static_cast<int>(group_cycling));
}

bool Widget::event(GdkEvent* gdk_event)
{
  return gtk_widget_event(gobj(), gdk_event);
}

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
int Widget::send_expose(GdkEvent* gdk_event)
{
  return gtk_widget_send_expose(gobj(), gdk_event);
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

bool Widget::send_focus_change(GdkEvent* gdk_event)
{
  return gtk_widget_send_focus_change(gobj(), gdk_event);
}

bool Widget::activate()
{
  return gtk_widget_activate(gobj());
}

bool Widget::intersect(const Gdk::Rectangle& area, Gdk::Rectangle& intersection) const
{
  return gtk_widget_intersect(const_cast<GtkWidget*>(gobj()), (area).gobj(), (intersection).gobj());
}

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
::Cairo::RefPtr< ::Cairo::Region> Widget::region_intersect(const ::Cairo::RefPtr< ::Cairo::Region>& region) const
{
  return ::Cairo::RefPtr< ::Cairo::Region>(new ::Cairo::Region(gtk_widget_region_intersect(const_cast<GtkWidget*>(gobj()), ((region) ? (region)->cobj() : nullptr)), true /* do not take ref */));
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

void Widget::freeze_child_notify()
{
  gtk_widget_freeze_child_notify(gobj());
}

void Widget::child_notify(const Glib::ustring& child_property)
{
  gtk_widget_child_notify(gobj(), child_property.c_str());
}

void Widget::thaw_child_notify()
{
  gtk_widget_thaw_child_notify(gobj());
}

void Widget::set_can_focus(bool can_focus)
{
  gtk_widget_set_can_focus(gobj(), static_cast<int>(can_focus));
}

bool Widget::get_can_focus() const
{
  return gtk_widget_get_can_focus(const_cast<GtkWidget*>(gobj()));
}

bool Widget::has_focus() const
{
  return gtk_widget_has_focus(const_cast<GtkWidget*>(gobj()));
}

bool Widget::is_focus() const
{
  return gtk_widget_is_focus(const_cast<GtkWidget*>(gobj()));
}

bool Widget::has_visible_focus() const
{
  return gtk_widget_has_visible_focus(const_cast<GtkWidget*>(gobj()));
}

void Widget::grab_focus()
{
  gtk_widget_grab_focus(gobj());
}

void Widget::set_focus_on_click(bool focus_on_click)
{
  gtk_widget_set_focus_on_click(gobj(), static_cast<int>(focus_on_click));
}

bool Widget::get_focus_on_click() const
{
  return gtk_widget_get_focus_on_click(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_can_default(bool can_default)
{
  gtk_widget_set_can_default(gobj(), static_cast<int>(can_default));
}

bool Widget::get_can_default() const
{
  return gtk_widget_get_can_default(const_cast<GtkWidget*>(gobj()));
}

bool Widget::has_default() const
{
  return gtk_widget_has_default(const_cast<GtkWidget*>(gobj()));
}

void Widget::grab_default()
{
  gtk_widget_grab_default(gobj());
}

void Widget::set_receives_default(bool receives_default)
{
  gtk_widget_set_receives_default(gobj(), static_cast<int>(receives_default));
}

bool Widget::get_receives_default() const
{
  return gtk_widget_get_receives_default(const_cast<GtkWidget*>(gobj()));
}

bool Widget::has_grab() const
{
  return gtk_widget_has_grab(const_cast<GtkWidget*>(gobj()));
}

bool Widget::device_is_shadowed(const Glib::RefPtr<const Gdk::Device>& device)
{
  return gtk_widget_device_is_shadowed(gobj(), const_cast<GdkDevice*>(Glib::unwrap<Gdk::Device>(device)));
}

void Widget::set_name(const Glib::ustring& name)
{
  gtk_widget_set_name(gobj(), name.c_str());
}

Glib::ustring Widget::get_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_widget_get_name(const_cast<GtkWidget*>(gobj())));
}

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Widget::set_state(StateType state)
{
  gtk_widget_set_state(gobj(), ((GtkStateType)(state)));
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
StateType Widget::get_state() const
{
  return ((StateType)(gtk_widget_get_state(const_cast<GtkWidget*>(gobj()))));
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

void Widget::set_state_flags(StateFlags flags, bool clear)
{
  gtk_widget_set_state_flags(gobj(), ((GtkStateFlags)(flags)), static_cast<int>(clear));
}

void Widget::unset_state_flags(StateFlags flags)
{
  gtk_widget_unset_state_flags(gobj(), ((GtkStateFlags)(flags)));
}

StateFlags Widget::get_state_flags() const
{
  return ((StateFlags)(gtk_widget_get_state_flags(const_cast<GtkWidget*>(gobj()))));
}

void Widget::set_sensitive(bool sensitive)
{
  gtk_widget_set_sensitive(gobj(), static_cast<int>(sensitive));
}

bool Widget::get_sensitive() const
{
  return gtk_widget_get_sensitive(const_cast<GtkWidget*>(gobj()));
}

bool Widget::is_sensitive() const
{
  return gtk_widget_is_sensitive(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_visible(bool visible)
{
  gtk_widget_set_visible(gobj(), static_cast<int>(visible));
}

bool Widget::get_visible() const
{
  return gtk_widget_get_visible(const_cast<GtkWidget*>(gobj()));
}

bool Widget::is_visible() const
{
  return gtk_widget_is_visible(const_cast<GtkWidget*>(gobj()));
}

bool Widget::get_has_window() const
{
  return gtk_widget_get_has_window(const_cast<GtkWidget*>(gobj()));
}

bool Widget::get_is_toplevel() const
{
  return gtk_widget_is_toplevel(const_cast<GtkWidget*>(gobj()));
}

bool Widget::get_is_drawable() const
{
  return gtk_widget_is_drawable(const_cast<GtkWidget*>(gobj()));
}

bool Widget::get_realized() const
{
  return gtk_widget_get_realized(const_cast<GtkWidget*>(gobj()));
}

bool Widget::get_mapped() const
{
  return gtk_widget_get_mapped(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_app_paintable(bool app_paintable)
{
  gtk_widget_set_app_paintable(gobj(), static_cast<int>(app_paintable));
}

bool Widget::get_app_paintable() const
{
  return gtk_widget_get_app_paintable(const_cast<GtkWidget*>(gobj()));
}

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Widget::set_double_buffered(bool double_buffered)
{
  gtk_widget_set_double_buffered(gobj(), static_cast<int>(double_buffered));
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
bool Widget::get_double_buffered() const
{
  return gtk_widget_get_double_buffered(const_cast<GtkWidget*>(gobj()));
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

void Widget::set_redraw_on_allocate(bool redraw_on_allocate)
{
  gtk_widget_set_redraw_on_allocate(gobj(), static_cast<int>(redraw_on_allocate));
}

void Widget::set_child_visible(bool visible)
{
  gtk_widget_set_child_visible(gobj(), static_cast<int>(visible));
}

bool Widget::get_child_visible() const
{
  return gtk_widget_get_child_visible(const_cast<GtkWidget*>(gobj()));
}

Glib::RefPtr<Gdk::Window> Widget::get_window()
{
  Glib::RefPtr<Gdk::Window> retvalue = Glib::wrap(gtk_widget_get_window(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gdk::Window> Widget::get_window() const
{
  return const_cast<Widget*>(this)->get_window();
}

void Widget::register_window(const Glib::RefPtr<Gdk::Window>& window)
{
  gtk_widget_register_window(gobj(), Glib::unwrap(window));
}

void Widget::unregister_window(const Glib::RefPtr<Gdk::Window>& window)
{
  gtk_widget_unregister_window(gobj(), Glib::unwrap(window));
}

int Widget::get_allocated_width() const
{
  return gtk_widget_get_allocated_width(const_cast<GtkWidget*>(gobj()));
}

int Widget::get_allocated_height() const
{
  return gtk_widget_get_allocated_height(const_cast<GtkWidget*>(gobj()));
}

int Widget::get_allocated_baseline() const
{
  return gtk_widget_get_allocated_baseline(const_cast<GtkWidget*>(gobj()));
}

void Widget::get_allocated_size(Allocation& allocation, int& baseline) const
{
  gtk_widget_get_allocated_size(const_cast<GtkWidget*>(gobj()), (GtkAllocation*)(allocation.gobj()), &(baseline));
}

void Widget::set_allocation(const Allocation& allocation)
{
  gtk_widget_set_allocation(gobj(), (allocation).gobj());
}

void Widget::set_clip(const Allocation& clip)
{
  gtk_widget_set_clip(gobj(), (clip).gobj());
}

Container* Widget::get_parent()
{
  return Glib::wrap((GtkContainer*)(gtk_widget_get_parent(gobj())));
}

const Container* Widget::get_parent() const
{
  return const_cast<Widget*>(this)->get_parent();
}

Glib::RefPtr<Gdk::Window> Widget::get_parent_window()
{
  Glib::RefPtr<Gdk::Window> retvalue = Glib::wrap(gtk_widget_get_parent_window(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gdk::Window> Widget::get_parent_window() const
{
  return const_cast<Widget*>(this)->get_parent_window();
}

void Widget::set_parent_window(const Glib::RefPtr<const Gdk::Window>& parent_window)
{
  gtk_widget_set_parent_window(gobj(), const_cast<GdkWindow*>(Glib::unwrap<Gdk::Window>(parent_window)));
}

bool Widget::child_focus(DirectionType direction)
{
  return gtk_widget_child_focus(gobj(), ((GtkDirectionType)(direction)));
}

bool Widget::keynav_failed(DirectionType direction)
{
  return gtk_widget_keynav_failed(gobj(), ((GtkDirectionType)(direction)));
}

void Widget::error_bell()
{
  gtk_widget_error_bell(gobj());
}

void Widget::set_size_request(int width, int height)
{
  gtk_widget_set_size_request(gobj(), width, height);
}

void Widget::get_size_request(int& width, int& height) const
{
  gtk_widget_get_size_request(const_cast<GtkWidget*>(gobj()), &(width), &(height));
}

void Widget::set_events(Gdk::EventMask events)
{
  gtk_widget_set_events(gobj(), events);
}

void Widget::add_events(Gdk::EventMask events)
{
  gtk_widget_add_events(gobj(), events);
}

void Widget::set_device_events(const Glib::RefPtr<const Gdk::Device>& device, Gdk::EventMask events)
{
  gtk_widget_set_device_events(gobj(), const_cast<GdkDevice*>(Glib::unwrap<Gdk::Device>(device)), ((GdkEventMask)(events)));
}

void Widget::add_device_events(const Glib::RefPtr<const Gdk::Device>& device, Gdk::EventMask events)
{
  gtk_widget_add_device_events(gobj(), const_cast<GdkDevice*>(Glib::unwrap<Gdk::Device>(device)), ((GdkEventMask)(events)));
}

void Widget::set_opacity(double opacity)
{
  gtk_widget_set_opacity(gobj(), opacity);
}

double Widget::get_opacity() const
{
  return gtk_widget_get_opacity(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_device_enabled(const Glib::RefPtr<Gdk::Device>& device, bool enabled)
{
  gtk_widget_set_device_enabled(gobj(), Glib::unwrap(device), static_cast<int>(enabled));
}

bool Widget::get_device_enabled(const Glib::RefPtr<const Gdk::Device>& device) const
{
  return gtk_widget_get_device_enabled(const_cast<GtkWidget*>(gobj()), const_cast<GdkDevice*>(Glib::unwrap<Gdk::Device>(device)));
}

Container* Widget::get_toplevel()
{
  return Glib::wrap((GtkContainer*)(gtk_widget_get_toplevel(gobj())));
}

const Container* Widget::get_toplevel() const
{
  return const_cast<Widget*>(this)->get_toplevel();
}

Widget* Widget::get_ancestor(GType widget_type)
{
  return Glib::wrap(gtk_widget_get_ancestor(gobj(), widget_type));
}

const Widget* Widget::get_ancestor(GType widget_type) const
{
  return const_cast<Widget*>(this)->get_ancestor(widget_type);
}

Glib::RefPtr<Gdk::Visual> Widget::get_visual()
{
  Glib::RefPtr<Gdk::Visual> retvalue = Glib::wrap(gtk_widget_get_visual(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<Gdk::Screen> Widget::get_screen()
{
  Glib::RefPtr<Gdk::Screen> retvalue = Glib::wrap(gtk_widget_get_screen(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gdk::Screen> Widget::get_screen() const
{
  return const_cast<Widget*>(this)->get_screen();
}

bool Widget::has_screen() const
{
  return gtk_widget_has_screen(const_cast<GtkWidget*>(gobj()));
}

int Widget::get_scale_factor() const
{
  return gtk_widget_get_scale_factor(const_cast<GtkWidget*>(gobj()));
}

Glib::RefPtr<Gdk::Display> Widget::get_display()
{
  Glib::RefPtr<Gdk::Display> retvalue = Glib::wrap(gtk_widget_get_display(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gdk::Display> Widget::get_display() const
{
  return const_cast<Widget*>(this)->get_display();
}

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
Glib::RefPtr<Gdk::Window> Widget::get_root_window()
{
  Glib::RefPtr<Gdk::Window> retvalue = Glib::wrap(gtk_widget_get_root_window(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
Glib::RefPtr<const Gdk::Window> Widget::get_root_window() const
{
  return const_cast<Widget*>(this)->get_root_window();
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

Glib::RefPtr<Settings> Widget::get_settings()
{
  Glib::RefPtr<Settings> retvalue = Glib::wrap(gtk_widget_get_settings(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<Clipboard> Widget::get_clipboard(const Glib::ustring& selection)
{
  Glib::RefPtr<Clipboard> retvalue = Glib::wrap(gtk_widget_get_clipboard(gobj(), Gdk::AtomUstring::to_c_type(selection)));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Clipboard> Widget::get_clipboard(const Glib::ustring& selection) const
{
  return const_cast<Widget*>(this)->get_clipboard(selection);
}

bool Widget::get_hexpand() const
{
  return gtk_widget_get_hexpand(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_hexpand(bool expand)
{
  gtk_widget_set_hexpand(gobj(), static_cast<int>(expand));
}

bool Widget::get_hexpand_set() const
{
  return gtk_widget_get_hexpand_set(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_hexpand_set(bool set)
{
  gtk_widget_set_hexpand_set(gobj(), static_cast<int>(set));
}

bool Widget::get_vexpand() const
{
  return gtk_widget_get_vexpand(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_vexpand(bool expand)
{
  gtk_widget_set_vexpand(gobj(), static_cast<int>(expand));
}

bool Widget::get_vexpand_set() const
{
  return gtk_widget_get_vexpand_set(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_vexpand_set(bool set)
{
  gtk_widget_set_vexpand_set(gobj(), static_cast<int>(set));
}

void Widget::queue_compute_expand()
{
  gtk_widget_queue_compute_expand(gobj());
}

bool Widget::compute_expand(Orientation orientation)
{
  return gtk_widget_compute_expand(gobj(), ((GtkOrientation)(orientation)));
}

bool Widget::get_support_multidevice() const
{
  return gtk_widget_get_support_multidevice(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_support_multidevice(bool support_multidevice)
{
  gtk_widget_set_support_multidevice(gobj(), static_cast<int>(support_multidevice));
}

#ifdef GTKMM_ATKMM_ENABLED
Glib::RefPtr<Atk::Object> Widget::get_accessible()
{
  Glib::RefPtr<Atk::Object> retvalue = Glib::wrap(gtk_widget_get_accessible(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}
#endif // GTKMM_ATKMM_ENABLED

#ifdef GTKMM_ATKMM_ENABLED
Glib::RefPtr<const Atk::Object> Widget::get_accessible() const
{
  return const_cast<Widget*>(this)->get_accessible();
}
#endif // GTKMM_ATKMM_ENABLED

Align Widget::get_halign() const
{
  return ((Align)(gtk_widget_get_halign(const_cast<GtkWidget*>(gobj()))));
}

void Widget::set_halign(Align align)
{
  gtk_widget_set_halign(gobj(), ((GtkAlign)(align)));
}

Align Widget::get_valign() const
{
  return ((Align)(gtk_widget_get_valign(const_cast<GtkWidget*>(gobj()))));
}

Align Widget::get_valign_with_baseline() const
{
  return ((Align)(gtk_widget_get_valign_with_baseline(const_cast<GtkWidget*>(gobj()))));
}

void Widget::set_valign(Align align)
{
  gtk_widget_set_valign(gobj(), ((GtkAlign)(align)));
}

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
int Widget::get_margin_left() const
{
  return gtk_widget_get_margin_left(const_cast<GtkWidget*>(gobj()));
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Widget::set_margin_left(int margin)
{
  gtk_widget_set_margin_left(gobj(), margin);
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
int Widget::get_margin_right() const
{
  return gtk_widget_get_margin_right(const_cast<GtkWidget*>(gobj()));
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Widget::set_margin_right(int margin)
{
  gtk_widget_set_margin_right(gobj(), margin);
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

int Widget::get_margin_start() const
{
  return gtk_widget_get_margin_start(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_margin_start(int margin)
{
  gtk_widget_set_margin_start(gobj(), margin);
}

int Widget::get_margin_end() const
{
  return gtk_widget_get_margin_end(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_margin_end(int margin)
{
  gtk_widget_set_margin_end(gobj(), margin);
}

int Widget::get_margin_top() const
{
  return gtk_widget_get_margin_top(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_margin_top(int margin)
{
  gtk_widget_set_margin_top(gobj(), margin);
}

int Widget::get_margin_bottom() const
{
  return gtk_widget_get_margin_bottom(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_margin_bottom(int margin)
{
  gtk_widget_set_margin_bottom(gobj(), margin);
}

Gdk::EventMask Widget::get_events() const
{
  return static_cast<Gdk::EventMask>(gtk_widget_get_events(const_cast<GtkWidget*>(gobj())));
}

Gdk::EventMask Widget::get_device_events(const Glib::RefPtr<const Gdk::Device>& device) const
{
  return ((Gdk::EventMask)(gtk_widget_get_device_events(const_cast<GtkWidget*>(gobj()), const_cast<GdkDevice*>(Glib::unwrap<Gdk::Device>(device)))));
}

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Widget::get_pointer(int & x, int & y) const
{
  gtk_widget_get_pointer(const_cast<GtkWidget*>(gobj()), &(x), &(y));
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

bool Widget::is_ancestor(Widget & ancestor) const
{
  return gtk_widget_is_ancestor(const_cast<GtkWidget*>(gobj()), (ancestor).gobj());
}

bool Widget::translate_coordinates(Widget& dest_widget, int src_x, int src_y, int& dest_x, int& dest_y)
{
  return gtk_widget_translate_coordinates(gobj(), (dest_widget).gobj(), src_x, src_y, &(dest_x), &(dest_y));
}

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Widget::override_color(const Gdk::RGBA& color, StateFlags state)
{
  gtk_widget_override_color(gobj(), ((GtkStateFlags)(state)), (color).gobj());
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Widget::override_background_color(const Gdk::RGBA& color, StateFlags state)
{
  gtk_widget_override_background_color(gobj(), ((GtkStateFlags)(state)), (color).gobj());
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Widget::override_font(const Pango::FontDescription& font_desc)
{
  gtk_widget_override_font(gobj(), (font_desc).gobj());
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Widget::override_symbolic_color(const Glib::ustring& name, const Gdk::RGBA& color)
{
  gtk_widget_override_symbolic_color(gobj(), name.c_str(), (color).gobj());
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Widget::override_cursor(const Gdk::RGBA& cursor, const Gdk::RGBA& secondary_cursor)
{
  gtk_widget_override_cursor(gobj(), (cursor).gobj(), (secondary_cursor).gobj());
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

void Widget::reset_style()
{
  gtk_widget_reset_style(gobj());
}

Glib::RefPtr<Pango::Context> Widget::create_pango_context()
{
  return Glib::wrap(gtk_widget_create_pango_context(gobj()));
}

Glib::RefPtr<Pango::Context> Widget::get_pango_context()
{
  Glib::RefPtr<Pango::Context> retvalue = Glib::wrap(gtk_widget_get_pango_context(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

void Widget::set_font_options(const ::Cairo::FontOptions& options)
{
  gtk_widget_set_font_options(gobj(), (options).cobj());
}

::Cairo::FontOptions Widget::get_font_options() const
{
  return ::Cairo::FontOptions(const_cast<cairo_font_options_t*>(gtk_widget_get_font_options(const_cast<GtkWidget*>(gobj()))), false /* take_ownership */);
}

Glib::RefPtr<Pango::Layout> Widget::create_pango_layout(const Glib::ustring& text)
{
  return Glib::wrap(gtk_widget_create_pango_layout(gobj(), text.c_str()));
}

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
Glib::RefPtr<Gdk::Pixbuf> Widget::render_icon_pixbuf(const StockID& stock_id, IconSize size)
{
  return Glib::wrap(gtk_widget_render_icon_pixbuf(gobj(), (stock_id).get_c_str(), static_cast<GtkIconSize>(int(size))));
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Widget::set_composite_name(const Glib::ustring& name)
{
  gtk_widget_set_composite_name(gobj(), name.c_str());
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
Glib::ustring Widget::get_composite_name() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_widget_get_composite_name(const_cast<GtkWidget*>(gobj())));
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Widget::push_composite_child()
{
  gtk_widget_push_composite_child();
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Widget::pop_composite_child()
{
  gtk_widget_pop_composite_child();
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

void Widget::set_direction(TextDirection dir)
{
  gtk_widget_set_direction(gobj(), ((GtkTextDirection)(dir)));
}

TextDirection Widget::get_direction() const
{
  return ((TextDirection)(gtk_widget_get_direction(const_cast<GtkWidget*>(gobj()))));
}

void Widget::set_default_direction(TextDirection dir)
{
  gtk_widget_set_default_direction(((GtkTextDirection)(dir)));
}

TextDirection Widget::get_default_direction()
{
  return ((TextDirection)(gtk_widget_get_default_direction()));
}

void Widget::shape_combine_region(const ::Cairo::RefPtr<const ::Cairo::Region>& region)
{
  gtk_widget_shape_combine_region(gobj(), const_cast<cairo_region_t*>((region) ? (region)->cobj() : nullptr));
}

void Widget::input_shape_combine_region(const ::Cairo::RefPtr<const ::Cairo::Region>& region)
{
  gtk_widget_input_shape_combine_region(gobj(), const_cast<cairo_region_t*>((region) ? (region)->cobj() : nullptr));
}

WidgetPath Widget::get_path() const
{
  return Glib::wrap(gtk_widget_get_path(const_cast<GtkWidget*>(gobj())), true);
}

std::vector<Widget*> Widget::list_mnemonic_labels()
{
  return Glib::ListHandler<Widget*>::list_to_vector(gtk_widget_list_mnemonic_labels(gobj()), Glib::OWNERSHIP_SHALLOW);
}

std::vector<const Widget*> Widget::list_mnemonic_labels() const
{
  return Glib::ListHandler<const Widget*>::list_to_vector(gtk_widget_list_mnemonic_labels(const_cast<GtkWidget*>(gobj())), Glib::OWNERSHIP_SHALLOW);
}

void Widget::add_mnemonic_label(Widget& label)
{
  gtk_widget_add_mnemonic_label(gobj(), (label).gobj());
}

void Widget::remove_mnemonic_label(Widget& label)
{
  gtk_widget_remove_mnemonic_label(gobj(), (label).gobj());
}

void Widget::drag_get_data(const Glib::RefPtr<Gdk::DragContext>& context, const Glib::ustring& target, guint32 time)
{
  gtk_drag_get_data(gobj(), Glib::unwrap(context), Gdk::AtomUstring::to_c_type(target), time);
}

void Widget::drag_highlight()
{
  gtk_drag_highlight(gobj());
}

void Widget::drag_unhighlight()
{
  gtk_drag_unhighlight(gobj());
}

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Widget::drag_dest_set_proxy(const Glib::RefPtr<Gdk::Window>& proxy_window, Gdk::DragProtocol protocol, bool use_coordinates)
{
  gtk_drag_dest_set_proxy(gobj(), Glib::unwrap(proxy_window), ((GdkDragProtocol)(protocol)), static_cast<int>(use_coordinates));
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

void Widget::drag_dest_unset()
{
  gtk_drag_dest_unset(gobj());
}

Glib::ustring Widget::drag_dest_find_target(const Glib::RefPtr<Gdk::DragContext>& context, const Glib::RefPtr<TargetList>& target_list) const
{
  return Gdk::AtomUstring::to_cpp_type(gtk_drag_dest_find_target(const_cast<GtkWidget*>(gobj()), Glib::unwrap(context), const_cast<GtkTargetList*>(Glib::unwrap(target_list))));
}

Glib::RefPtr<TargetList> Widget::drag_dest_get_target_list()
{
  Glib::RefPtr<TargetList> retvalue = Glib::wrap(gtk_drag_dest_get_target_list(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const TargetList> Widget::drag_dest_get_target_list() const
{
  return const_cast<Widget*>(this)->drag_dest_get_target_list();
}

void Widget::drag_dest_set_target_list(const Glib::RefPtr<TargetList>& target_list)
{
  gtk_drag_dest_set_target_list(gobj(), const_cast<GtkTargetList*>(Glib::unwrap(target_list)));
}

void Widget::drag_dest_add_text_targets()
{
  gtk_drag_dest_add_text_targets(gobj());
}

void Widget::drag_dest_add_image_targets()
{
  gtk_drag_dest_add_image_targets(gobj());
}

void Widget::drag_dest_add_uri_targets()
{
  gtk_drag_dest_add_uri_targets(gobj());
}

void Widget::drag_source_unset()
{
  gtk_drag_source_unset(gobj());
}

void Widget::drag_source_set_icon(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf)
{
  gtk_drag_source_set_icon_pixbuf(gobj(), Glib::unwrap(pixbuf));
}

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Widget::drag_source_set_icon(const StockID& stock_id)
{
  gtk_drag_source_set_icon_stock(gobj(), (stock_id).get_c_str());
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

void Widget::drag_source_set_icon(const Glib::ustring& icon_name)
{
  gtk_drag_source_set_icon_name(gobj(), icon_name.c_str());
}

void Widget::drag_source_add_text_targets()
{
  gtk_drag_source_add_text_targets(gobj());
}

void Widget::drag_source_add_uri_targets()
{
  gtk_drag_source_add_uri_targets(gobj());
}

void Widget::drag_source_add_image_targets()
{
  gtk_drag_source_add_image_targets(gobj());
}

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
Glib::RefPtr<Gdk::DragContext> Widget::drag_begin(const Glib::RefPtr<TargetList>& targets, Gdk::DragAction actions, int button, GdkEvent* gdk_event)
{
  Glib::RefPtr<Gdk::DragContext> retvalue = Glib::wrap(gtk_drag_begin(gobj(), const_cast<GtkTargetList*>(Glib::unwrap(targets)), ((GdkDragAction)(actions)), button, gdk_event), true);
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

Glib::RefPtr<Gdk::DragContext> Widget::drag_begin(const Glib::RefPtr<TargetList>& targets, Gdk::DragAction actions, int button, GdkEvent* gdk_event, int x, int y)
{
  Glib::RefPtr<Gdk::DragContext> retvalue = Glib::wrap(gtk_drag_begin_with_coordinates(gobj(), const_cast<GtkTargetList*>(Glib::unwrap(targets)), ((GdkDragAction)(actions)), button, gdk_event, x, y), true);
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

bool Widget::drag_check_threshold(int start_x, int start_y, int current_x, int current_y)
{
  return gtk_drag_check_threshold(gobj(), start_x, start_y, current_x, current_y);
}

void Widget::queue_resize_no_redraw()
{
  gtk_widget_queue_resize_no_redraw(gobj());
}

Glib::RefPtr<Gdk::FrameClock> Widget::get_frame_clock()
{
  Glib::RefPtr<Gdk::FrameClock> retvalue = Glib::wrap(gtk_widget_get_frame_clock(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gdk::FrameClock> Widget::get_frame_clock() const
{
  return const_cast<Widget*>(this)->get_frame_clock();
}

bool Widget::get_no_show_all() const
{
  return gtk_widget_get_no_show_all(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_no_show_all(bool no_show_all)
{
  gtk_widget_set_no_show_all(gobj(), static_cast<int>(no_show_all));
}

void Widget::set_parent(Widget& parent)
{
  gtk_widget_set_parent(gobj(), (parent).gobj());
}

void Widget::unparent()
{
  gtk_widget_unparent(gobj());
}

void Widget::map()
{
  gtk_widget_map(gobj());
}

void Widget::unmap()
{
  gtk_widget_unmap(gobj());
}

void Widget::set_tooltip_window(Window& custom_window)
{
  gtk_widget_set_tooltip_window(gobj(), (custom_window).gobj());
}

Window* Widget::get_tooltip_window()
{
  return Glib::wrap(gtk_widget_get_tooltip_window(gobj()));
}

void Widget::trigger_tooltip_query()
{
  gtk_widget_trigger_tooltip_query(gobj());
}

void Widget::set_tooltip_text(const Glib::ustring& text)
{
  gtk_widget_set_tooltip_text(gobj(), text.c_str());
}

Glib::ustring Widget::get_tooltip_text() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_widget_get_tooltip_text(const_cast<GtkWidget*>(gobj())));
}

void Widget::set_tooltip_markup(const Glib::ustring& markup)
{
  gtk_widget_set_tooltip_markup(gobj(), markup.c_str());
}

Glib::ustring Widget::get_tooltip_markup() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_widget_get_tooltip_markup(const_cast<GtkWidget*>(gobj())));
}

void Widget::set_has_tooltip(bool has_tooltip)
{
  gtk_widget_set_has_tooltip(gobj(), static_cast<int>(has_tooltip));
}

bool Widget::get_has_tooltip() const
{
  return gtk_widget_get_has_tooltip(const_cast<GtkWidget*>(gobj()));
}

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
bool Widget::is_composited() const
{
  return gtk_widget_is_composited(const_cast<GtkWidget*>(gobj()));
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

bool Widget::in_destruction() const
{
  return gtk_widget_in_destruction(const_cast<GtkWidget*>(gobj()));
}

Glib::RefPtr<StyleContext> Widget::get_style_context()
{
  Glib::RefPtr<StyleContext> retvalue = Glib::wrap(gtk_widget_get_style_context(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<Gtk::StyleContext> Widget::get_style_context() const
{
  return const_cast<Widget*>(this)->get_style_context();
}

Gdk::ModifierType Widget::get_modifier_mask(Gdk::ModifierIntent intent)
{
  return ((Gdk::ModifierType)(gtk_widget_get_modifier_mask(gobj(), ((GdkModifierIntent)(intent)))));
}

void Widget::remove_tick_callback(guint id)
{
  gtk_widget_remove_tick_callback(gobj(), id);
}

void Widget::insert_action_group(const Glib::ustring& name, const Glib::RefPtr<Gio::ActionGroup>& group)
{
  gtk_widget_insert_action_group(gobj(), name.c_str(), const_cast<GActionGroup*>(Glib::unwrap<Gio::ActionGroup>(group)));
}

Glib::RefPtr<Gio::ActionGroup> Widget::get_action_group(const Glib::ustring& prefix)
{
  Glib::RefPtr<Gio::ActionGroup> retvalue = Glib::wrap(gtk_widget_get_action_group(gobj(), prefix.c_str()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gio::ActionGroup> Widget::get_action_group(const Glib::ustring& prefix) const
{
  return const_cast<Widget*>(this)->get_action_group(prefix);
}

std::vector<Glib::ustring> Widget::list_action_prefixes() const
{
  return Glib::ArrayHandler<Glib::ustring>::array_to_vector(gtk_widget_list_action_prefixes(const_cast<GtkWidget*>(gobj())), Glib::OWNERSHIP_SHALLOW);
}

void Widget::set_font_map(const Glib::RefPtr<Pango::FontMap>& font_map)
{
  gtk_widget_set_font_map(gobj(), Glib::unwrap(font_map));
}

Glib::RefPtr<Pango::FontMap> Widget::get_font_map()
{
  Glib::RefPtr<Pango::FontMap> retvalue = Glib::wrap(gtk_widget_get_font_map(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Pango::FontMap> Widget::get_font_map() const
{
  return const_cast<Widget*>(this)->get_font_map();
}

Widget::Widget()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Object(Glib::ConstructParams(widget_class_.init()))
{
  

}

void Widget::realize()
{
  gtk_widget_realize(gobj());
}

void Widget::unrealize()
{
  gtk_widget_unrealize(gobj());
}

void Widget::draw(const ::Cairo::RefPtr< ::Cairo::Context>& cr)
{
  gtk_widget_draw(gobj(), (cr)->cobj());
}

void Widget::set_mapped(bool mapped)
{
  gtk_widget_set_mapped(gobj(), static_cast<int>(mapped));
}

void Widget::set_realized(bool realized)
{
  gtk_widget_set_realized(gobj(), static_cast<int>(realized));
}

void Widget::set_has_window(bool has_window)
{
  gtk_widget_set_has_window(gobj(), static_cast<int>(has_window));
}

bool Widget::should_draw_window(const ::Cairo::RefPtr<const ::Cairo::Context>& cr, const Glib::RefPtr<const Gdk::Window>& window)
{
  return gtk_cairo_should_draw_window(const_cast<cairo_t*>((cr)->cobj()), const_cast<GdkWindow*>(Glib::unwrap<Gdk::Window>(window)));
}

void Widget::get_style_property_value(const Glib::ustring& the_property_name, Glib::ValueBase& value) const
{
  gtk_widget_style_get_property(const_cast<GtkWidget*>(gobj()), the_property_name.c_str(), (value).gobj());
}


Glib::SignalProxy< void > Widget::signal_show()
{
  return Glib::SignalProxy< void >(this, &Widget_signal_show_info);
}


Glib::SignalProxy< void > Widget::signal_hide()
{
  return Glib::SignalProxy< void >(this, &Widget_signal_hide_info);
}


Glib::SignalProxy< void > Widget::signal_map()
{
  return Glib::SignalProxy< void >(this, &Widget_signal_map_info);
}


Glib::SignalProxy< void > Widget::signal_unmap()
{
  return Glib::SignalProxy< void >(this, &Widget_signal_unmap_info);
}


Glib::SignalProxy< void > Widget::signal_realize()
{
  return Glib::SignalProxy< void >(this, &Widget_signal_realize_info);
}


Glib::SignalProxy< void > Widget::signal_unrealize()
{
  return Glib::SignalProxy< void >(this, &Widget_signal_unrealize_info);
}


Glib::SignalProxy< void,Allocation& > Widget::signal_size_allocate()
{
  return Glib::SignalProxy< void,Allocation& >(this, &Widget_signal_size_allocate_info);
}


#ifndef GTKMM_DISABLE_DEPRECATED

Glib::SignalProxy< void,Gtk::StateType > Widget::signal_state_changed()
{
  return Glib::SignalProxy< void,Gtk::StateType >(this, &Widget_signal_state_changed_info);
}
#endif // GTKMM_DISABLE_DEPRECATED


Glib::SignalProxy< void,Gtk::StateFlags > Widget::signal_state_flags_changed()
{
  return Glib::SignalProxy< void,Gtk::StateFlags >(this, &Widget_signal_state_flags_changed_info);
}


Glib::SignalProxy< void,Widget* > Widget::signal_parent_changed()
{
  return Glib::SignalProxy< void,Widget* >(this, &Widget_signal_parent_changed_info);
}


Glib::SignalProxy< void,Widget* > Widget::signal_hierarchy_changed()
{
  return Glib::SignalProxy< void,Widget* >(this, &Widget_signal_hierarchy_changed_info);
}


Glib::SignalProxy< void > Widget::signal_style_updated()
{
  return Glib::SignalProxy< void >(this, &Widget_signal_style_updated_info);
}


Glib::SignalProxy< void,TextDirection > Widget::signal_direction_changed()
{
  return Glib::SignalProxy< void,TextDirection >(this, &Widget_signal_direction_changed_info);
}


Glib::SignalProxy< void,bool > Widget::signal_grab_notify()
{
  return Glib::SignalProxy< void,bool >(this, &Widget_signal_grab_notify_info);
}


Glib::SignalProxy< void,GParamSpec* > Widget::signal_child_notify()
{
  return Glib::SignalProxy< void,GParamSpec* >(this, &Widget_signal_child_notify_info);
}

Glib::SignalProxyDetailedAnyType< void,GParamSpec* > Widget::signal_child_notify(const Glib::ustring& child_property_name)
{
  return Glib::SignalProxyDetailedAnyType< void,GParamSpec* >(this, &Widget_signal_child_notify_info, child_property_name);
}


Glib::SignalProxy< bool,bool > Widget::signal_mnemonic_activate()
{
  return Glib::SignalProxy< bool,bool >(this, &Widget_signal_mnemonic_activate_info);
}


Glib::SignalProxy< void > Widget::signal_grab_focus()
{
  return Glib::SignalProxy< void >(this, &Widget_signal_grab_focus_info);
}


Glib::SignalProxy< bool,DirectionType > Widget::signal_focus()
{
  return Glib::SignalProxy< bool,DirectionType >(this, &Widget_signal_focus_info);
}


Glib::SignalProxy< bool,GdkEvent* > Widget::signal_event()
{
  return Glib::SignalProxy< bool,GdkEvent* >(this, &Widget_signal_event_info);
}


Glib::SignalProxy< void,GdkEvent* > Widget::signal_event_after()
{
  return Glib::SignalProxy< void,GdkEvent* >(this, &Widget_signal_event_after_info);
}


Glib::SignalProxy< bool,GdkEventButton* > Widget::signal_button_press_event()
{
  return Glib::SignalProxy< bool,GdkEventButton* >(this, &Widget_signal_button_press_event_info);
}


Glib::SignalProxy< bool,GdkEventButton* > Widget::signal_button_release_event()
{
  return Glib::SignalProxy< bool,GdkEventButton* >(this, &Widget_signal_button_release_event_info);
}


Glib::SignalProxy< bool,GdkEventScroll* > Widget::signal_scroll_event()
{
  return Glib::SignalProxy< bool,GdkEventScroll* >(this, &Widget_signal_scroll_event_info);
}


Glib::SignalProxy< bool,GdkEventMotion* > Widget::signal_motion_notify_event()
{
  return Glib::SignalProxy< bool,GdkEventMotion* >(this, &Widget_signal_motion_notify_event_info);
}


Glib::SignalProxy< bool,GdkEventAny* > Widget::signal_delete_event()
{
  return Glib::SignalProxy< bool,GdkEventAny* >(this, &Widget_signal_delete_event_info);
}


Glib::SignalProxy< bool,const ::Cairo::RefPtr< ::Cairo::Context>& > Widget::signal_draw()
{
  return Glib::SignalProxy< bool,const ::Cairo::RefPtr< ::Cairo::Context>& >(this, &Widget_signal_draw_info);
}


Glib::SignalProxy< bool,GdkEventKey* > Widget::signal_key_press_event()
{
  return Glib::SignalProxy< bool,GdkEventKey* >(this, &Widget_signal_key_press_event_info);
}


Glib::SignalProxy< bool,GdkEventKey* > Widget::signal_key_release_event()
{
  return Glib::SignalProxy< bool,GdkEventKey* >(this, &Widget_signal_key_release_event_info);
}


Glib::SignalProxy< bool,GdkEventCrossing* > Widget::signal_enter_notify_event()
{
  return Glib::SignalProxy< bool,GdkEventCrossing* >(this, &Widget_signal_enter_notify_event_info);
}


Glib::SignalProxy< bool,GdkEventCrossing* > Widget::signal_leave_notify_event()
{
  return Glib::SignalProxy< bool,GdkEventCrossing* >(this, &Widget_signal_leave_notify_event_info);
}


Glib::SignalProxy< bool,GdkEventConfigure* > Widget::signal_configure_event()
{
  return Glib::SignalProxy< bool,GdkEventConfigure* >(this, &Widget_signal_configure_event_info);
}


Glib::SignalProxy< bool,GdkEventFocus* > Widget::signal_focus_in_event()
{
  return Glib::SignalProxy< bool,GdkEventFocus* >(this, &Widget_signal_focus_in_event_info);
}


Glib::SignalProxy< bool,GdkEventFocus* > Widget::signal_focus_out_event()
{
  return Glib::SignalProxy< bool,GdkEventFocus* >(this, &Widget_signal_focus_out_event_info);
}


Glib::SignalProxy< bool,GdkEventAny* > Widget::signal_map_event()
{
  return Glib::SignalProxy< bool,GdkEventAny* >(this, &Widget_signal_map_event_info);
}


Glib::SignalProxy< bool,GdkEventAny* > Widget::signal_unmap_event()
{
  return Glib::SignalProxy< bool,GdkEventAny* >(this, &Widget_signal_unmap_event_info);
}


Glib::SignalProxy< bool,GdkEventProperty* > Widget::signal_property_notify_event()
{
  return Glib::SignalProxy< bool,GdkEventProperty* >(this, &Widget_signal_property_notify_event_info);
}


Glib::SignalProxy< bool,GdkEventSelection* > Widget::signal_selection_clear_event()
{
  return Glib::SignalProxy< bool,GdkEventSelection* >(this, &Widget_signal_selection_clear_event_info);
}


Glib::SignalProxy< bool,GdkEventSelection* > Widget::signal_selection_request_event()
{
  return Glib::SignalProxy< bool,GdkEventSelection* >(this, &Widget_signal_selection_request_event_info);
}


Glib::SignalProxy< bool,GdkEventSelection* > Widget::signal_selection_notify_event()
{
  return Glib::SignalProxy< bool,GdkEventSelection* >(this, &Widget_signal_selection_notify_event_info);
}


Glib::SignalProxy< bool,GdkEventProximity* > Widget::signal_proximity_in_event()
{
  return Glib::SignalProxy< bool,GdkEventProximity* >(this, &Widget_signal_proximity_in_event_info);
}


Glib::SignalProxy< bool,GdkEventProximity* > Widget::signal_proximity_out_event()
{
  return Glib::SignalProxy< bool,GdkEventProximity* >(this, &Widget_signal_proximity_out_event_info);
}


#ifndef GTKMM_DISABLE_DEPRECATED

Glib::SignalProxy< bool,GdkEventVisibility* > Widget::signal_visibility_notify_event()
{
  return Glib::SignalProxy< bool,GdkEventVisibility* >(this, &Widget_signal_visibility_notify_event_info);
}
#endif // GTKMM_DISABLE_DEPRECATED


Glib::SignalProxy< bool,GdkEventWindowState* > Widget::signal_window_state_event()
{
  return Glib::SignalProxy< bool,GdkEventWindowState* >(this, &Widget_signal_window_state_event_info);
}


Glib::SignalProxy< void,SelectionData&,guint,guint > Widget::signal_selection_get()
{
  return Glib::SignalProxy< void,SelectionData&,guint,guint >(this, &Widget_signal_selection_get_info);
}


Glib::SignalProxy< void,const SelectionData&,guint > Widget::signal_selection_received()
{
  return Glib::SignalProxy< void,const SelectionData&,guint >(this, &Widget_signal_selection_received_info);
}


Glib::SignalProxy< void,const Glib::RefPtr<Gdk::DragContext>& > Widget::signal_drag_begin()
{
  return Glib::SignalProxy< void,const Glib::RefPtr<Gdk::DragContext>& >(this, &Widget_signal_drag_begin_info);
}


Glib::SignalProxy< void,const Glib::RefPtr<Gdk::DragContext>& > Widget::signal_drag_end()
{
  return Glib::SignalProxy< void,const Glib::RefPtr<Gdk::DragContext>& >(this, &Widget_signal_drag_end_info);
}


Glib::SignalProxy< void,const Glib::RefPtr<Gdk::DragContext>&,SelectionData&,guint,guint > Widget::signal_drag_data_get()
{
  return Glib::SignalProxy< void,const Glib::RefPtr<Gdk::DragContext>&,SelectionData&,guint,guint >(this, &Widget_signal_drag_data_get_info);
}


Glib::SignalProxy< void,const Glib::RefPtr<Gdk::DragContext>& > Widget::signal_drag_data_delete()
{
  return Glib::SignalProxy< void,const Glib::RefPtr<Gdk::DragContext>& >(this, &Widget_signal_drag_data_delete_info);
}


Glib::SignalProxy< bool,const Glib::RefPtr<Gdk::DragContext>&,DragResult > Widget::signal_drag_failed()
{
  return Glib::SignalProxy< bool,const Glib::RefPtr<Gdk::DragContext>&,DragResult >(this, &Widget_signal_drag_failed_info);
}


Glib::SignalProxy< void,const Glib::RefPtr<Gdk::DragContext>&,guint > Widget::signal_drag_leave()
{
  return Glib::SignalProxy< void,const Glib::RefPtr<Gdk::DragContext>&,guint >(this, &Widget_signal_drag_leave_info);
}


Glib::SignalProxy< bool,const Glib::RefPtr<Gdk::DragContext>&,int,int,guint > Widget::signal_drag_motion()
{
  return Glib::SignalProxy< bool,const Glib::RefPtr<Gdk::DragContext>&,int,int,guint >(this, &Widget_signal_drag_motion_info);
}


Glib::SignalProxy< bool,const Glib::RefPtr<Gdk::DragContext>&,int,int,guint > Widget::signal_drag_drop()
{
  return Glib::SignalProxy< bool,const Glib::RefPtr<Gdk::DragContext>&,int,int,guint >(this, &Widget_signal_drag_drop_info);
}


Glib::SignalProxy< void,const Glib::RefPtr<Gdk::DragContext>&,int,int,const SelectionData&,guint,guint > Widget::signal_drag_data_received()
{
  return Glib::SignalProxy< void,const Glib::RefPtr<Gdk::DragContext>&,int,int,const SelectionData&,guint,guint >(this, &Widget_signal_drag_data_received_info);
}


Glib::SignalProxy< void,const Glib::RefPtr<Gdk::Screen>& > Widget::signal_screen_changed()
{
  return Glib::SignalProxy< void,const Glib::RefPtr<Gdk::Screen>& >(this, &Widget_signal_screen_changed_info);
}


#ifndef GTKMM_DISABLE_DEPRECATED

Glib::SignalProxy< void > Widget::signal_composited_changed()
{
  return Glib::SignalProxy< void >(this, &Widget_signal_composited_changed_info);
}
#endif // GTKMM_DISABLE_DEPRECATED


Glib::SignalProxy< bool > Widget::signal_popup_menu()
{
  return Glib::SignalProxy< bool >(this, &Widget_signal_popup_menu_info);
}


Glib::SignalProxy< bool,int,int,bool,const Glib::RefPtr<Tooltip>& > Widget::signal_query_tooltip()
{
  return Glib::SignalProxy< bool,int,int,bool,const Glib::RefPtr<Tooltip>& >(this, &Widget_signal_query_tooltip_info);
}


Glib::SignalProxy< bool,GdkEventGrabBroken* > Widget::signal_grab_broken_event()
{
  return Glib::SignalProxy< bool,GdkEventGrabBroken* >(this, &Widget_signal_grab_broken_event_info);
}


Glib::SignalProxy< bool,GdkEventExpose* > Widget::signal_damage_event()
{
  return Glib::SignalProxy< bool,GdkEventExpose* >(this, &Widget_signal_damage_event_info);
}


Glib::SignalProxy< bool,GdkEventTouch* > Widget::signal_touch_event()
{
  return Glib::SignalProxy< bool,GdkEventTouch* >(this, &Widget_signal_touch_event_info);
}


Glib::PropertyProxy< Glib::ustring > Widget::property_name() 
{
  return Glib::PropertyProxy< Glib::ustring >(this, "name");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Widget::property_name() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "name");
}

Glib::PropertyProxy< Container* > Widget::property_parent() 
{
  return Glib::PropertyProxy< Container* >(this, "parent");
}

Glib::PropertyProxy_ReadOnly< Container* > Widget::property_parent() const
{
  return Glib::PropertyProxy_ReadOnly< Container* >(this, "parent");
}

Glib::PropertyProxy< int > Widget::property_width_request() 
{
  return Glib::PropertyProxy< int >(this, "width-request");
}

Glib::PropertyProxy_ReadOnly< int > Widget::property_width_request() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "width-request");
}

Glib::PropertyProxy< int > Widget::property_height_request() 
{
  return Glib::PropertyProxy< int >(this, "height-request");
}

Glib::PropertyProxy_ReadOnly< int > Widget::property_height_request() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "height-request");
}

Glib::PropertyProxy< bool > Widget::property_visible() 
{
  return Glib::PropertyProxy< bool >(this, "visible");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_visible() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "visible");
}

Glib::PropertyProxy< bool > Widget::property_sensitive() 
{
  return Glib::PropertyProxy< bool >(this, "sensitive");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_sensitive() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "sensitive");
}

Glib::PropertyProxy< bool > Widget::property_app_paintable() 
{
  return Glib::PropertyProxy< bool >(this, "app-paintable");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_app_paintable() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "app-paintable");
}

Glib::PropertyProxy< bool > Widget::property_can_focus() 
{
  return Glib::PropertyProxy< bool >(this, "can-focus");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_can_focus() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "can-focus");
}

Glib::PropertyProxy< bool > Widget::property_has_focus() 
{
  return Glib::PropertyProxy< bool >(this, "has-focus");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_has_focus() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "has-focus");
}

Glib::PropertyProxy< bool > Widget::property_is_focus() 
{
  return Glib::PropertyProxy< bool >(this, "is-focus");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_is_focus() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "is-focus");
}

Glib::PropertyProxy< bool > Widget::property_focus_on_click() 
{
  return Glib::PropertyProxy< bool >(this, "focus-on-click");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_focus_on_click() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "focus-on-click");
}

Glib::PropertyProxy< bool > Widget::property_can_default() 
{
  return Glib::PropertyProxy< bool >(this, "can-default");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_can_default() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "can-default");
}

Glib::PropertyProxy< bool > Widget::property_has_default() 
{
  return Glib::PropertyProxy< bool >(this, "has-default");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_has_default() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "has-default");
}

Glib::PropertyProxy< bool > Widget::property_receives_default() 
{
  return Glib::PropertyProxy< bool >(this, "receives-default");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_receives_default() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "receives-default");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_composite_child() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "composite-child");
}

#ifndef GTKMM_DISABLE_DEPRECATED

Glib::PropertyProxy< Glib::RefPtr<Style> > Widget::property_style() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Style> >(this, "style");
}
#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Style> > Widget::property_style() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Style> >(this, "style");
}
#endif // GTKMM_DISABLE_DEPRECATED


Glib::PropertyProxy< Gdk::EventMask > Widget::property_events() 
{
  return Glib::PropertyProxy< Gdk::EventMask >(this, "events");
}

Glib::PropertyProxy_ReadOnly< Gdk::EventMask > Widget::property_events() const
{
  return Glib::PropertyProxy_ReadOnly< Gdk::EventMask >(this, "events");
}

Glib::PropertyProxy< bool > Widget::property_has_tooltip() 
{
  return Glib::PropertyProxy< bool >(this, "has-tooltip");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_has_tooltip() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "has-tooltip");
}

Glib::PropertyProxy< Glib::ustring > Widget::property_tooltip_markup() 
{
  return Glib::PropertyProxy< Glib::ustring >(this, "tooltip-markup");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Widget::property_tooltip_markup() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "tooltip-markup");
}

Glib::PropertyProxy< Glib::ustring > Widget::property_tooltip_text() 
{
  return Glib::PropertyProxy< Glib::ustring >(this, "tooltip-text");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Widget::property_tooltip_text() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "tooltip-text");
}

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Window> > Widget::property_window() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Window> >(this, "window");
}

Glib::PropertyProxy< bool > Widget::property_no_show_all() 
{
  return Glib::PropertyProxy< bool >(this, "no-show-all");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_no_show_all() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "no-show-all");
}

#ifndef GTKMM_DISABLE_DEPRECATED

Glib::PropertyProxy< bool > Widget::property_double_buffered() 
{
  return Glib::PropertyProxy< bool >(this, "double-buffered");
}
#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED

Glib::PropertyProxy_ReadOnly< bool > Widget::property_double_buffered() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "double-buffered");
}
#endif // GTKMM_DISABLE_DEPRECATED


Glib::PropertyProxy< Align > Widget::property_halign() 
{
  return Glib::PropertyProxy< Align >(this, "halign");
}

Glib::PropertyProxy_ReadOnly< Align > Widget::property_halign() const
{
  return Glib::PropertyProxy_ReadOnly< Align >(this, "halign");
}

Glib::PropertyProxy< Align > Widget::property_valign() 
{
  return Glib::PropertyProxy< Align >(this, "valign");
}

Glib::PropertyProxy_ReadOnly< Align > Widget::property_valign() const
{
  return Glib::PropertyProxy_ReadOnly< Align >(this, "valign");
}

#ifndef GTKMM_DISABLE_DEPRECATED

Glib::PropertyProxy< int > Widget::property_margin_left() 
{
  return Glib::PropertyProxy< int >(this, "margin-left");
}
#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED

Glib::PropertyProxy_ReadOnly< int > Widget::property_margin_left() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "margin-left");
}
#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED

Glib::PropertyProxy< int > Widget::property_margin_right() 
{
  return Glib::PropertyProxy< int >(this, "margin-right");
}
#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED

Glib::PropertyProxy_ReadOnly< int > Widget::property_margin_right() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "margin-right");
}
#endif // GTKMM_DISABLE_DEPRECATED


Glib::PropertyProxy< int > Widget::property_margin_start() 
{
  return Glib::PropertyProxy< int >(this, "margin-start");
}

Glib::PropertyProxy_ReadOnly< int > Widget::property_margin_start() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "margin-start");
}

Glib::PropertyProxy< int > Widget::property_margin_end() 
{
  return Glib::PropertyProxy< int >(this, "margin-end");
}

Glib::PropertyProxy_ReadOnly< int > Widget::property_margin_end() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "margin-end");
}

Glib::PropertyProxy< int > Widget::property_margin_top() 
{
  return Glib::PropertyProxy< int >(this, "margin-top");
}

Glib::PropertyProxy_ReadOnly< int > Widget::property_margin_top() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "margin-top");
}

Glib::PropertyProxy< int > Widget::property_margin_bottom() 
{
  return Glib::PropertyProxy< int >(this, "margin-bottom");
}

Glib::PropertyProxy_ReadOnly< int > Widget::property_margin_bottom() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "margin-bottom");
}

Glib::PropertyProxy< int > Widget::property_margin() 
{
  return Glib::PropertyProxy< int >(this, "margin");
}

Glib::PropertyProxy_ReadOnly< int > Widget::property_margin() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "margin");
}

Glib::PropertyProxy< bool > Widget::property_hexpand() 
{
  return Glib::PropertyProxy< bool >(this, "hexpand");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_hexpand() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "hexpand");
}

Glib::PropertyProxy< bool > Widget::property_hexpand_set() 
{
  return Glib::PropertyProxy< bool >(this, "hexpand-set");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_hexpand_set() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "hexpand-set");
}

Glib::PropertyProxy< bool > Widget::property_vexpand() 
{
  return Glib::PropertyProxy< bool >(this, "vexpand");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_vexpand() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "vexpand");
}

Glib::PropertyProxy< bool > Widget::property_vexpand_set() 
{
  return Glib::PropertyProxy< bool >(this, "vexpand-set");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_vexpand_set() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "vexpand-set");
}

Glib::PropertyProxy< bool > Widget::property_expand() 
{
  return Glib::PropertyProxy< bool >(this, "expand");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_expand() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "expand");
}

Glib::PropertyProxy< double > Widget::property_opacity() 
{
  return Glib::PropertyProxy< double >(this, "opacity");
}

Glib::PropertyProxy_ReadOnly< double > Widget::property_opacity() const
{
  return Glib::PropertyProxy_ReadOnly< double >(this, "opacity");
}

Glib::PropertyProxy_ReadOnly< int > Widget::property_scale_factor() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "scale-factor");
}


void Gtk::Widget::on_show()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->show)
    (*base->show)(gobj());
}
void Gtk::Widget::on_hide()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->hide)
    (*base->hide)(gobj());
}
void Gtk::Widget::on_map()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->map)
    (*base->map)(gobj());
}
void Gtk::Widget::on_unmap()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->unmap)
    (*base->unmap)(gobj());
}
void Gtk::Widget::on_realize()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->realize)
    (*base->realize)(gobj());
}
void Gtk::Widget::on_unrealize()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->unrealize)
    (*base->unrealize)(gobj());
}
void Gtk::Widget::on_size_allocate(Allocation& allocation)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->size_allocate)
    (*base->size_allocate)(gobj(),(GdkRectangle*)(allocation.gobj()));
}
void Gtk::Widget::on_state_changed(Gtk::StateType previous_state)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->state_changed)
    (*base->state_changed)(gobj(),((GtkStateType)(previous_state)));
}
void Gtk::Widget::on_parent_changed(Widget* previous_parent)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->parent_set)
    (*base->parent_set)(gobj(),(GtkWidget*)Glib::unwrap(previous_parent));
}
void Gtk::Widget::on_hierarchy_changed(Widget* previous_toplevel)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->hierarchy_changed)
    (*base->hierarchy_changed)(gobj(),(GtkWidget*)Glib::unwrap(previous_toplevel));
}
void Gtk::Widget::on_style_updated()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->style_updated)
    (*base->style_updated)(gobj());
}
void Gtk::Widget::on_direction_changed(TextDirection direction)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->direction_changed)
    (*base->direction_changed)(gobj(),((GtkTextDirection)(direction)));
}
void Gtk::Widget::on_grab_notify(bool was_grabbed)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->grab_notify)
    (*base->grab_notify)(gobj(),static_cast<int>(was_grabbed));
}
void Gtk::Widget::on_child_notify(GParamSpec* pspec)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->child_notify)
    (*base->child_notify)(gobj(),pspec);
}
bool Gtk::Widget::on_mnemonic_activate(bool group_cycling)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->mnemonic_activate)
    return (*base->mnemonic_activate)(gobj(),static_cast<int>(group_cycling));

  using RType = bool;
  return RType();
}
void Gtk::Widget::on_grab_focus()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->grab_focus)
    (*base->grab_focus)(gobj());
}
bool Gtk::Widget::on_focus(DirectionType direction)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->focus)
    return (*base->focus)(gobj(),((GtkDirectionType)(direction)));

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_event(GdkEvent* gdk_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->event)
    return (*base->event)(gobj(),gdk_event);

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_button_press_event(GdkEventButton* button_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->button_press_event)
    return (*base->button_press_event)(gobj(),button_event);

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_button_release_event(GdkEventButton* release_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->button_release_event)
    return (*base->button_release_event)(gobj(),release_event);

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_scroll_event(GdkEventScroll* scroll_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->scroll_event)
    return (*base->scroll_event)(gobj(),scroll_event);

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_motion_notify_event(GdkEventMotion* motion_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->motion_notify_event)
    return (*base->motion_notify_event)(gobj(),motion_event);

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_delete_event(GdkEventAny* any_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->delete_event)
    return (*base->delete_event)(gobj(),any_event);

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_draw(const ::Cairo::RefPtr< ::Cairo::Context>& cr)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw)
    return (*base->draw)(gobj(),(cr)->cobj());

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_key_press_event(GdkEventKey* key_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->key_press_event)
    return (*base->key_press_event)(gobj(),key_event);

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_key_release_event(GdkEventKey* key_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->key_release_event)
    return (*base->key_release_event)(gobj(),key_event);

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_enter_notify_event(GdkEventCrossing* crossing_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->enter_notify_event)
    return (*base->enter_notify_event)(gobj(),crossing_event);

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_leave_notify_event(GdkEventCrossing* crossing_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->leave_notify_event)
    return (*base->leave_notify_event)(gobj(),crossing_event);

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_configure_event(GdkEventConfigure* configure_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->configure_event)
    return (*base->configure_event)(gobj(),configure_event);

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_focus_in_event(GdkEventFocus* focus_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->focus_in_event)
    return (*base->focus_in_event)(gobj(),focus_event);

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_focus_out_event(GdkEventFocus* gdk_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->focus_out_event)
    return (*base->focus_out_event)(gobj(),gdk_event);

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_map_event(GdkEventAny* any_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->map_event)
    return (*base->map_event)(gobj(),any_event);

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_unmap_event(GdkEventAny* any_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->unmap_event)
    return (*base->unmap_event)(gobj(),any_event);

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_property_notify_event(GdkEventProperty* property_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->property_notify_event)
    return (*base->property_notify_event)(gobj(),property_event);

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_selection_clear_event(GdkEventSelection* selection_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->selection_clear_event)
    return (*base->selection_clear_event)(gobj(),selection_event);

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_selection_request_event(GdkEventSelection* selection_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->selection_request_event)
    return (*base->selection_request_event)(gobj(),selection_event);

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_selection_notify_event(GdkEventSelection* selection_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->selection_notify_event)
    return (*base->selection_notify_event)(gobj(),selection_event);

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_proximity_in_event(GdkEventProximity* proximity_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->proximity_in_event)
    return (*base->proximity_in_event)(gobj(),proximity_event);

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_proximity_out_event(GdkEventProximity* proximity_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->proximity_out_event)
    return (*base->proximity_out_event)(gobj(),proximity_event);

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_visibility_notify_event(GdkEventVisibility* visibility_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->visibility_notify_event)
    return (*base->visibility_notify_event)(gobj(),visibility_event);

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_window_state_event(GdkEventWindowState* window_state_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->window_state_event)
    return (*base->window_state_event)(gobj(),window_state_event);

  using RType = bool;
  return RType();
}
void Gtk::Widget::on_selection_get(SelectionData& selection_data, guint info, guint time)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->selection_get)
    (*base->selection_get)(gobj(),(selection_data).gobj(),info,time);
}
void Gtk::Widget::on_selection_received(const SelectionData& selection_data, guint time)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->selection_received)
    (*base->selection_received)(gobj(),const_cast<GtkSelectionData*>((selection_data).gobj()),time);
}
void Gtk::Widget::on_drag_begin(const Glib::RefPtr<Gdk::DragContext>& context)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->drag_begin)
    (*base->drag_begin)(gobj(),Glib::unwrap(context));
}
void Gtk::Widget::on_drag_end(const Glib::RefPtr<Gdk::DragContext>& context)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->drag_end)
    (*base->drag_end)(gobj(),Glib::unwrap(context));
}
void Gtk::Widget::on_drag_data_get(const Glib::RefPtr<Gdk::DragContext>& context, SelectionData& selection_data, guint info, guint time)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->drag_data_get)
    (*base->drag_data_get)(gobj(),Glib::unwrap(context),(selection_data).gobj(),info,time);
}
void Gtk::Widget::on_drag_data_delete(const Glib::RefPtr<Gdk::DragContext>& context)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->drag_data_delete)
    (*base->drag_data_delete)(gobj(),Glib::unwrap(context));
}
void Gtk::Widget::on_drag_leave(const Glib::RefPtr<Gdk::DragContext>& context, guint time)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->drag_leave)
    (*base->drag_leave)(gobj(),Glib::unwrap(context),time);
}
bool Gtk::Widget::on_drag_motion(const Glib::RefPtr<Gdk::DragContext>& context, int x, int y, guint time)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->drag_motion)
    return (*base->drag_motion)(gobj(),Glib::unwrap(context),x,y,time);

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_drag_drop(const Glib::RefPtr<Gdk::DragContext>& context, int x, int y, guint time)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->drag_drop)
    return (*base->drag_drop)(gobj(),Glib::unwrap(context),x,y,time);

  using RType = bool;
  return RType();
}
void Gtk::Widget::on_drag_data_received(const Glib::RefPtr<Gdk::DragContext>& context, int x, int y, const SelectionData& selection_data, guint info, guint time)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->drag_data_received)
    (*base->drag_data_received)(gobj(),Glib::unwrap(context),x,y,const_cast<GtkSelectionData*>((selection_data).gobj()),info,time);
}
void Gtk::Widget::on_screen_changed(const Glib::RefPtr<Gdk::Screen>& previous_screen)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->screen_changed)
    (*base->screen_changed)(gobj(),Glib::unwrap(previous_screen));
}

void Gtk::Widget::dispatch_child_properties_changed_vfunc(guint p1, GParamSpec** p2) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->dispatch_child_properties_changed)
  {
    (*base->dispatch_child_properties_changed)(gobj(),p1,p2);
  }
}
void Gtk::Widget::show_all_vfunc() 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->show_all)
  {
    (*base->show_all)(gobj());
  }
}
#ifdef GTKMM_ATKMM_ENABLED
Glib::RefPtr<Atk::Object> Gtk::Widget::get_accessible_vfunc() 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->get_accessible)
  {
    Glib::RefPtr<Atk::Object> retval(Glib::wrap((*base->get_accessible)(gobj()), true));
    return retval;
  }

  using RType = Glib::RefPtr<Atk::Object>;
  return RType();
}
#endif // GTKMM_ATKMM_ENABLED
SizeRequestMode Gtk::Widget::get_request_mode_vfunc() const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->get_request_mode)
  {
    SizeRequestMode retval(((SizeRequestMode)((*base->get_request_mode)(const_cast<GtkWidget*>(gobj())))));
    return retval;
  }

  using RType = SizeRequestMode;
  return RType();
}
void Gtk::Widget::get_preferred_width_vfunc(int& minimum_width, int& natural_width) const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->get_preferred_width)
  {
    (*base->get_preferred_width)(const_cast<GtkWidget*>(gobj()),&(minimum_width),&(natural_width));
  }
}
void Gtk::Widget::get_preferred_height_for_width_vfunc(int width, int& minimum_height, int& natural_height) const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->get_preferred_height_for_width)
  {
    (*base->get_preferred_height_for_width)(const_cast<GtkWidget*>(gobj()),width,&(minimum_height),&(natural_height));
  }
}
void Gtk::Widget::get_preferred_height_vfunc(int& minimum_height, int& natural_height) const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->get_preferred_height)
  {
    (*base->get_preferred_height)(const_cast<GtkWidget*>(gobj()),&(minimum_height),&(natural_height));
  }
}
void Gtk::Widget::get_preferred_width_for_height_vfunc(int height, int& minimum_width, int& natural_width) const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->get_preferred_width_for_height)
  {
    (*base->get_preferred_width_for_height)(const_cast<GtkWidget*>(gobj()),height,&(minimum_width),&(natural_width));
  }
}


} // namespace Gtk


