/* AlertView.c generated by valac 0.56.17, the Vala compiler
 * generated from AlertView.vala, do not modify */

/*
 * Copyright 2012-2017 elementary, Inc. (https://elementary.io)
 * Copyright 2012-2017 Corentin Noël <corentin@elementary.io>
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "granite.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_WIDGETS_ALERT_VIEW_0_PROPERTY,
	GRANITE_WIDGETS_ALERT_VIEW_TITLE_PROPERTY,
	GRANITE_WIDGETS_ALERT_VIEW_DESCRIPTION_PROPERTY,
	GRANITE_WIDGETS_ALERT_VIEW_ICON_NAME_PROPERTY,
	GRANITE_WIDGETS_ALERT_VIEW_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_alert_view_properties[GRANITE_WIDGETS_ALERT_VIEW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	GRANITE_WIDGETS_ALERT_VIEW_ACTION_ACTIVATED_SIGNAL,
	GRANITE_WIDGETS_ALERT_VIEW_NUM_SIGNALS
};
static guint granite_widgets_alert_view_signals[GRANITE_WIDGETS_ALERT_VIEW_NUM_SIGNALS] = {0};

struct _GraniteWidgetsAlertViewPrivate {
	GtkLabel* title_label;
	GtkLabel* description_label;
	GtkImage* image;
	GtkButton* action_button;
	GtkRevealer* action_revealer;
};

static gint GraniteWidgetsAlertView_private_offset;
static gpointer granite_widgets_alert_view_parent_class = NULL;

static GObject * granite_widgets_alert_view_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static void _granite_widgets_alert_view___lambda13_ (GraniteWidgetsAlertView* self);
static void __granite_widgets_alert_view___lambda13__gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self);
static void granite_widgets_alert_view_finalize (GObject * obj);
static GType granite_widgets_alert_view_get_type_once (void);
static void _vala_granite_widgets_alert_view_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_granite_widgets_alert_view_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);

static inline gpointer
granite_widgets_alert_view_get_instance_private (GraniteWidgetsAlertView* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsAlertView_private_offset);
}

const gchar*
granite_widgets_alert_view_get_title (GraniteWidgetsAlertView* self)
{
	const gchar* result;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->title_label;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
granite_widgets_alert_view_set_title (GraniteWidgetsAlertView* self,
                                      const gchar* value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->title_label;
	gtk_label_set_label (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_alert_view_properties[GRANITE_WIDGETS_ALERT_VIEW_TITLE_PROPERTY]);
}

const gchar*
granite_widgets_alert_view_get_description (GraniteWidgetsAlertView* self)
{
	const gchar* result;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->description_label;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
granite_widgets_alert_view_set_description (GraniteWidgetsAlertView* self,
                                            const gchar* value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->description_label;
	gtk_label_set_label (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_alert_view_properties[GRANITE_WIDGETS_ALERT_VIEW_DESCRIPTION_PROPERTY]);
}

gchar*
granite_widgets_alert_view_get_icon_name (GraniteWidgetsAlertView* self)
{
	gchar* result;
	gchar* _tmp0_ = NULL;
	GtkImage* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->image;
	g_object_get (_tmp1_, "icon-name", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp0_ = _tmp3_;
	if (_tmp0_ == NULL) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp5_;
	_g_free0 (_tmp0_);
	return result;
}

void
granite_widgets_alert_view_set_icon_name (GraniteWidgetsAlertView* self,
                                          const gchar* value)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = g_strcmp0 (value, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkImage* _tmp1_;
		GtkImage* _tmp2_;
		GtkImage* _tmp3_;
		_tmp1_ = self->priv->image;
		gtk_image_set_from_icon_name (_tmp1_, value, (GtkIconSize) GTK_ICON_SIZE_DIALOG);
		_tmp2_ = self->priv->image;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp2_, FALSE);
		_tmp3_ = self->priv->image;
		gtk_widget_show ((GtkWidget*) _tmp3_);
	} else {
		GtkImage* _tmp4_;
		GtkImage* _tmp5_;
		_tmp4_ = self->priv->image;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp4_, TRUE);
		_tmp5_ = self->priv->image;
		gtk_widget_hide ((GtkWidget*) _tmp5_);
	}
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_alert_view_properties[GRANITE_WIDGETS_ALERT_VIEW_ICON_NAME_PROPERTY]);
}

/**
     * Makes new AlertView
     *
     * @param title the first line of text
     * @param description the second line of text
     * @param icon_name the icon to be shown
     */
GraniteWidgetsAlertView*
granite_widgets_alert_view_construct (GType object_type,
                                      const gchar* title,
                                      const gchar* description,
                                      const gchar* icon_name)
{
	GraniteWidgetsAlertView * self = NULL;
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (description != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	self = (GraniteWidgetsAlertView*) g_object_new (object_type, "title", title, "description", description, "icon-name", icon_name, NULL);
	return self;
}

GraniteWidgetsAlertView*
granite_widgets_alert_view_new (const gchar* title,
                                const gchar* description,
                                const gchar* icon_name)
{
	return granite_widgets_alert_view_construct (GRANITE_WIDGETS_TYPE_ALERT_VIEW, title, description, icon_name);
}

/**
     * Creates the action button with the given label
     *
     * @param label the text of the action button
     */
void
granite_widgets_alert_view_show_action (GraniteWidgetsAlertView* self,
                                        const gchar* label)
{
	GtkButton* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GtkRevealer* _tmp4_;
	GtkRevealer* _tmp5_;
	g_return_if_fail (self != NULL);
	if (label != NULL) {
		GtkButton* _tmp0_;
		_tmp0_ = self->priv->action_button;
		gtk_button_set_label (_tmp0_, label);
	}
	_tmp1_ = self->priv->action_button;
	_tmp2_ = gtk_button_get_label (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		return;
	}
	_tmp4_ = self->priv->action_revealer;
	gtk_revealer_set_reveal_child (_tmp4_, TRUE);
	_tmp5_ = self->priv->action_revealer;
	gtk_widget_show_all ((GtkWidget*) _tmp5_);
}

/**
     * Hides the action button.
     */
void
granite_widgets_alert_view_hide_action (GraniteWidgetsAlertView* self)
{
	GtkRevealer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->action_revealer;
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
}

static void
_granite_widgets_alert_view___lambda13_ (GraniteWidgetsAlertView* self)
{
	g_signal_emit (self, granite_widgets_alert_view_signals[GRANITE_WIDGETS_ALERT_VIEW_ACTION_ACTIVATED_SIGNAL], 0);
}

static void
__granite_widgets_alert_view___lambda13__gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self)
{
	_granite_widgets_alert_view___lambda13_ ((GraniteWidgetsAlertView*) self);
}

static GObject *
granite_widgets_alert_view_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteWidgetsAlertView * self;
	GtkStyleContext* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkButton* _tmp16_;
	GtkButton* _tmp17_;
	GtkRevealer* _tmp18_;
	GtkRevealer* _tmp19_;
	GtkButton* _tmp20_;
	GtkRevealer* _tmp21_;
	GtkRevealer* _tmp22_;
	GtkImage* _tmp23_;
	GtkImage* _tmp24_;
	GtkImage* _tmp25_;
	GtkGrid* layout = NULL;
	GtkGrid* _tmp26_;
	GtkGrid* _tmp27_;
	GtkGrid* _tmp28_;
	GtkGrid* _tmp29_;
	GtkGrid* _tmp30_;
	GtkGrid* _tmp31_;
	GtkGrid* _tmp32_;
	GtkGrid* _tmp33_;
	GtkImage* _tmp34_;
	GtkGrid* _tmp35_;
	GtkLabel* _tmp36_;
	GtkGrid* _tmp37_;
	GtkLabel* _tmp38_;
	GtkGrid* _tmp39_;
	GtkRevealer* _tmp40_;
	GtkGrid* _tmp41_;
	GtkButton* _tmp42_;
	parent_class = G_OBJECT_CLASS (granite_widgets_alert_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_TYPE_ALERT_VIEW, GraniteWidgetsAlertView);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, GTK_STYLE_CLASS_VIEW);
	_tmp1_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->title_label);
	self->priv->title_label = _tmp1_;
	_tmp2_ = self->priv->title_label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = self->priv->title_label;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
	gtk_style_context_add_class (_tmp4_, GRANITE_STYLE_CLASS_H2_LABEL);
	_tmp5_ = self->priv->title_label;
	gtk_label_set_max_width_chars (_tmp5_, 75);
	_tmp6_ = self->priv->title_label;
	g_object_set (_tmp6_, "wrap", TRUE, NULL);
	_tmp7_ = self->priv->title_label;
	g_object_set (_tmp7_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	_tmp8_ = self->priv->title_label;
	gtk_label_set_xalign (_tmp8_, (gfloat) 0);
	_tmp9_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->description_label);
	self->priv->description_label = _tmp9_;
	_tmp10_ = self->priv->description_label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp10_, TRUE);
	_tmp11_ = self->priv->description_label;
	gtk_label_set_max_width_chars (_tmp11_, 75);
	_tmp12_ = self->priv->description_label;
	g_object_set (_tmp12_, "wrap", TRUE, NULL);
	_tmp13_ = self->priv->description_label;
	gtk_label_set_use_markup (_tmp13_, TRUE);
	_tmp14_ = self->priv->description_label;
	gtk_label_set_xalign (_tmp14_, (gfloat) 0);
	_tmp15_ = self->priv->description_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp15_, GTK_ALIGN_START);
	_tmp16_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->action_button);
	self->priv->action_button = _tmp16_;
	_tmp17_ = self->priv->action_button;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp17_, 24);
	_tmp18_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->action_revealer);
	self->priv->action_revealer = _tmp18_;
	_tmp19_ = self->priv->action_revealer;
	_tmp20_ = self->priv->action_button;
	gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = self->priv->action_revealer;
	gtk_widget_set_halign ((GtkWidget*) _tmp21_, GTK_ALIGN_END);
	_tmp22_ = self->priv->action_revealer;
	gtk_revealer_set_transition_type (_tmp22_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_UP);
	_tmp23_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp23_;
	_tmp24_ = self->priv->image;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp24_, 6);
	_tmp25_ = self->priv->image;
	gtk_widget_set_valign ((GtkWidget*) _tmp25_, GTK_ALIGN_START);
	_tmp26_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp26_);
	layout = _tmp26_;
	_tmp27_ = layout;
	gtk_grid_set_column_spacing (_tmp27_, 12);
	_tmp28_ = layout;
	gtk_grid_set_row_spacing (_tmp28_, 6);
	_tmp29_ = layout;
	gtk_widget_set_halign ((GtkWidget*) _tmp29_, GTK_ALIGN_CENTER);
	_tmp30_ = layout;
	gtk_widget_set_valign ((GtkWidget*) _tmp30_, GTK_ALIGN_CENTER);
	_tmp31_ = layout;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp31_, TRUE);
	_tmp32_ = layout;
	g_object_set ((GtkWidget*) _tmp32_, "margin", 24, NULL);
	_tmp33_ = layout;
	_tmp34_ = self->priv->image;
	gtk_grid_attach (_tmp33_, (GtkWidget*) _tmp34_, 1, 1, 1, 2);
	_tmp35_ = layout;
	_tmp36_ = self->priv->title_label;
	gtk_grid_attach (_tmp35_, (GtkWidget*) _tmp36_, 2, 1, 1, 1);
	_tmp37_ = layout;
	_tmp38_ = self->priv->description_label;
	gtk_grid_attach (_tmp37_, (GtkWidget*) _tmp38_, 2, 2, 1, 1);
	_tmp39_ = layout;
	_tmp40_ = self->priv->action_revealer;
	gtk_grid_attach (_tmp39_, (GtkWidget*) _tmp40_, 2, 3, 1, 1);
	_tmp41_ = layout;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp41_);
	_tmp42_ = self->priv->action_button;
	g_signal_connect_object (_tmp42_, "clicked", (GCallback) __granite_widgets_alert_view___lambda13__gtk_button_clicked, self, 0);
	_g_object_unref0 (layout);
	return obj;
}

static void
granite_widgets_alert_view_class_init (GraniteWidgetsAlertViewClass * klass,
                                       gpointer klass_data)
{
	granite_widgets_alert_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsAlertView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_widgets_alert_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_widgets_alert_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_widgets_alert_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_widgets_alert_view_finalize;
	/**
	     * The first line of text, should be short and not contain markup.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_ALERT_VIEW_TITLE_PROPERTY, granite_widgets_alert_view_properties[GRANITE_WIDGETS_ALERT_VIEW_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The second line of text, explaining why this alert is shown.
	     * You may need to escape it with #escape_text or #printf_escaped
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_ALERT_VIEW_DESCRIPTION_PROPERTY, granite_widgets_alert_view_properties[GRANITE_WIDGETS_ALERT_VIEW_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The icon name
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_ALERT_VIEW_ICON_NAME_PROPERTY, granite_widgets_alert_view_properties[GRANITE_WIDGETS_ALERT_VIEW_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	granite_widgets_alert_view_signals[GRANITE_WIDGETS_ALERT_VIEW_ACTION_ACTIVATED_SIGNAL] = g_signal_new ("action-activated", GRANITE_WIDGETS_TYPE_ALERT_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
granite_widgets_alert_view_instance_init (GraniteWidgetsAlertView * self,
                                          gpointer klass)
{
	self->priv = granite_widgets_alert_view_get_instance_private (self);
}

static void
granite_widgets_alert_view_finalize (GObject * obj)
{
	GraniteWidgetsAlertView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_TYPE_ALERT_VIEW, GraniteWidgetsAlertView);
	_g_object_unref0 (self->priv->title_label);
	_g_object_unref0 (self->priv->description_label);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->action_button);
	_g_object_unref0 (self->priv->action_revealer);
	G_OBJECT_CLASS (granite_widgets_alert_view_parent_class)->finalize (obj);
}

/**
 * The AlertView widget shows to the user that some actions are now restricted.
 *
 * It can be used to show an empty view or hiding a panel when this one is disabled.
 *
 * {{../doc/images/AlertView.png}}
 *
 * ''Example''<<BR>>
 * {{{
 * public class AlertViewView : Gtk.Grid {
 *     construct {
 *         var alert = new Granite.Widgets.AlertView ("Nothing here", "Maybe you can enable <b>something</b> to hide it but <i>otherwise</i> it will stay here", "dialog-warning");
 *         alert.show_action ("Hide this button");
 *
 *         alert.action_activated.connect (() => {
 *             alert.hide_action ();
 *         });
 *
 *         add (alert);
 *     }
 * }
 * }}}
 */
static GType
granite_widgets_alert_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsAlertViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_alert_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsAlertView), 0, (GInstanceInitFunc) granite_widgets_alert_view_instance_init, NULL };
	GType granite_widgets_alert_view_type_id;
	granite_widgets_alert_view_type_id = g_type_register_static (gtk_grid_get_type (), "GraniteWidgetsAlertView", &g_define_type_info, 0);
	GraniteWidgetsAlertView_private_offset = g_type_add_instance_private (granite_widgets_alert_view_type_id, sizeof (GraniteWidgetsAlertViewPrivate));
	return granite_widgets_alert_view_type_id;
}

GType
granite_widgets_alert_view_get_type (void)
{
	static volatile gsize granite_widgets_alert_view_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_alert_view_type_id__once)) {
		GType granite_widgets_alert_view_type_id;
		granite_widgets_alert_view_type_id = granite_widgets_alert_view_get_type_once ();
		g_once_init_leave (&granite_widgets_alert_view_type_id__once, granite_widgets_alert_view_type_id);
	}
	return granite_widgets_alert_view_type_id__once;
}

static void
_vala_granite_widgets_alert_view_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	GraniteWidgetsAlertView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_TYPE_ALERT_VIEW, GraniteWidgetsAlertView);
	switch (property_id) {
		case GRANITE_WIDGETS_ALERT_VIEW_TITLE_PROPERTY:
		g_value_set_string (value, granite_widgets_alert_view_get_title (self));
		break;
		case GRANITE_WIDGETS_ALERT_VIEW_DESCRIPTION_PROPERTY:
		g_value_set_string (value, granite_widgets_alert_view_get_description (self));
		break;
		case GRANITE_WIDGETS_ALERT_VIEW_ICON_NAME_PROPERTY:
		g_value_take_string (value, granite_widgets_alert_view_get_icon_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_widgets_alert_view_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	GraniteWidgetsAlertView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_TYPE_ALERT_VIEW, GraniteWidgetsAlertView);
	switch (property_id) {
		case GRANITE_WIDGETS_ALERT_VIEW_TITLE_PROPERTY:
		granite_widgets_alert_view_set_title (self, g_value_get_string (value));
		break;
		case GRANITE_WIDGETS_ALERT_VIEW_DESCRIPTION_PROPERTY:
		granite_widgets_alert_view_set_description (self, g_value_get_string (value));
		break;
		case GRANITE_WIDGETS_ALERT_VIEW_ICON_NAME_PROPERTY:
		granite_widgets_alert_view_set_icon_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

