/* Desktop.c generated by valac 0.56.18, the Vala compiler
 * generated from Desktop.vala, do not modify */

/* Desktop.vala
 *
 * Copyright (C) 2009-2025 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "font-manager.h"
#include <pango/pango.h>

#define FONT_MANAGER_GNOME_INTERFACE_ID "org.gnome.desktop.interface"
#define FONT_MANAGER_GNOME_XSETTINGS_ID "org.gnome.settings-daemon.plugins.xsettings"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FONT_MANAGER_TYPE_FONT_SETTING_KEY (font_manager_font_setting_key_get_type ())
typedef struct _FontManagerFontSettingKey FontManagerFontSettingKey;
#define _g_free0(var) (var = (g_free (var), NULL))

#define FONT_MANAGER_TYPE_PREFERENCE_LIST (font_manager_preference_list_get_type ())
#define FONT_MANAGER_PREFERENCE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_PREFERENCE_LIST, FontManagerPreferenceList))
#define FONT_MANAGER_PREFERENCE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_PREFERENCE_LIST, FontManagerPreferenceListClass))
#define FONT_MANAGER_IS_PREFERENCE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_PREFERENCE_LIST))
#define FONT_MANAGER_IS_PREFERENCE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_PREFERENCE_LIST))
#define FONT_MANAGER_PREFERENCE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_PREFERENCE_LIST, FontManagerPreferenceListClass))

typedef struct _FontManagerPreferenceList FontManagerPreferenceList;
typedef struct _FontManagerPreferenceListClass FontManagerPreferenceListClass;
typedef struct _FontManagerPreferenceListPrivate FontManagerPreferenceListPrivate;

#define FONT_MANAGER_TYPE_BASE_CONTROLS (font_manager_base_controls_get_type ())
#define FONT_MANAGER_BASE_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_BASE_CONTROLS, FontManagerBaseControls))
#define FONT_MANAGER_BASE_CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_BASE_CONTROLS, FontManagerBaseControlsClass))
#define FONT_MANAGER_IS_BASE_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_BASE_CONTROLS))
#define FONT_MANAGER_IS_BASE_CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_BASE_CONTROLS))
#define FONT_MANAGER_BASE_CONTROLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_BASE_CONTROLS, FontManagerBaseControlsClass))

typedef struct _FontManagerBaseControls FontManagerBaseControls;
typedef struct _FontManagerBaseControlsClass FontManagerBaseControlsClass;

#define FONT_MANAGER_TYPE_DESKTOP_PREFERENCES (font_manager_desktop_preferences_get_type ())
#define FONT_MANAGER_DESKTOP_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_DESKTOP_PREFERENCES, FontManagerDesktopPreferences))
#define FONT_MANAGER_DESKTOP_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_DESKTOP_PREFERENCES, FontManagerDesktopPreferencesClass))
#define FONT_MANAGER_IS_DESKTOP_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_DESKTOP_PREFERENCES))
#define FONT_MANAGER_IS_DESKTOP_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_DESKTOP_PREFERENCES))
#define FONT_MANAGER_DESKTOP_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_DESKTOP_PREFERENCES, FontManagerDesktopPreferencesClass))

typedef struct _FontManagerDesktopPreferences FontManagerDesktopPreferences;
typedef struct _FontManagerDesktopPreferencesClass FontManagerDesktopPreferencesClass;
typedef struct _FontManagerDesktopPreferencesPrivate FontManagerDesktopPreferencesPrivate;
enum  {
	FONT_MANAGER_DESKTOP_PREFERENCES_0_PROPERTY,
	FONT_MANAGER_DESKTOP_PREFERENCES_NUM_PROPERTIES
};
static GParamSpec* font_manager_desktop_preferences_properties[FONT_MANAGER_DESKTOP_PREFERENCES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))

#define FONT_MANAGER_TYPE_SUBPIXEL_GEOMETRY (font_manager_subpixel_geometry_get_type ())
#define FONT_MANAGER_SUBPIXEL_GEOMETRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_SUBPIXEL_GEOMETRY, FontManagerSubpixelGeometry))
#define FONT_MANAGER_SUBPIXEL_GEOMETRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_SUBPIXEL_GEOMETRY, FontManagerSubpixelGeometryClass))
#define FONT_MANAGER_IS_SUBPIXEL_GEOMETRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_SUBPIXEL_GEOMETRY))
#define FONT_MANAGER_IS_SUBPIXEL_GEOMETRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_SUBPIXEL_GEOMETRY))
#define FONT_MANAGER_SUBPIXEL_GEOMETRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_SUBPIXEL_GEOMETRY, FontManagerSubpixelGeometryClass))

typedef struct _FontManagerSubpixelGeometry FontManagerSubpixelGeometry;
typedef struct _FontManagerSubpixelGeometryClass FontManagerSubpixelGeometryClass;
typedef struct _Block25Data Block25Data;
typedef struct _Block26Data Block26Data;
#define _g_settings_schema_source_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_source_unref (var), NULL)))

struct _FontManagerFontSettingKey {
	gchar* key;
	gchar* name;
	gchar* description;
	gchar* type;
};

struct _FontManagerPreferenceList {
	GtkBox parent_instance;
	FontManagerPreferenceListPrivate * priv;
	GtkListBox* list;
	FontManagerBaseControls* controls;
	GtkSeparator* separator;
};

struct _FontManagerPreferenceListClass {
	GtkBoxClass parent_class;
	void (*on_add_selected) (FontManagerPreferenceList* self);
	void (*on_list_row_selected) (FontManagerPreferenceList* self, GtkListBox* box, GtkListBoxRow* row);
	void (*on_map) (FontManagerPreferenceList* self);
	void (*on_remove_selected) (FontManagerPreferenceList* self);
	void (*on_unmap) (FontManagerPreferenceList* self);
};

struct _FontManagerDesktopPreferences {
	FontManagerPreferenceList parent_instance;
	FontManagerDesktopPreferencesPrivate * priv;
};

struct _FontManagerDesktopPreferencesClass {
	FontManagerPreferenceListClass parent_class;
};

struct _Block25Data {
	int _ref_count_;
	FontManagerDesktopPreferences* self;
	GtkDropDown* combo;
};

struct _Block26Data {
	int _ref_count_;
	Block25Data * _data25_;
	FontManagerPreferenceRow* parent;
};

static gpointer font_manager_desktop_preferences_parent_class = NULL;
static gboolean font_manager_desktop_preferences_initialized;
static gboolean font_manager_desktop_preferences_initialized = FALSE;
static GSettings* font_manager_desktop_preferences_interface_settings;
static GSettings* font_manager_desktop_preferences_interface_settings = NULL;
static GSettings* font_manager_desktop_preferences_x_settings;
static GSettings* font_manager_desktop_preferences_x_settings = NULL;

VALA_EXTERN GType font_manager_font_setting_key_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FontManagerFontSettingKey* font_manager_font_setting_key_dup (const FontManagerFontSettingKey* self);
VALA_EXTERN void font_manager_font_setting_key_free (FontManagerFontSettingKey* self);
VALA_EXTERN void font_manager_font_setting_key_copy (const FontManagerFontSettingKey* self,
                                         FontManagerFontSettingKey* dest);
VALA_EXTERN void font_manager_font_setting_key_destroy (FontManagerFontSettingKey* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (FontManagerFontSettingKey, font_manager_font_setting_key_destroy)
VALA_EXTERN GType font_manager_preference_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerPreferenceList, g_object_unref)
VALA_EXTERN GType font_manager_base_controls_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerBaseControls, g_object_unref)
VALA_EXTERN GType font_manager_desktop_preferences_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerDesktopPreferences, g_object_unref)
VALA_EXTERN void font_manager_preference_list_on_map (FontManagerPreferenceList* self);
static gboolean font_manager_desktop_preferences_available (void);
VALA_EXTERN FontManagerDesktopPreferences* font_manager_desktop_preferences_new (void);
VALA_EXTERN FontManagerDesktopPreferences* font_manager_desktop_preferences_construct (GType object_type);
VALA_EXTERN FontManagerPreferenceList* font_manager_preference_list_new (void);
VALA_EXTERN FontManagerPreferenceList* font_manager_preference_list_construct (GType object_type);
static void font_manager_desktop_preferences_real_on_map (FontManagerPreferenceList* base);
static void font_manager_desktop_preferences_generate_options_list (FontManagerDesktopPreferences* self);
static gchar** font_manager_desktop_preferences_get_enum_values (const gchar* k,
                                                          gint* result_length1);
static gboolean font_manager_desktop_preferences_from_enum_setting (GValue* v,
                                                             GVariant* r,
                                                             const gchar* k);
static GVariant* font_manager_desktop_preferences_to_enum_setting (GValue* v,
                                                            const GVariantType* t,
                                                            const gchar* k);
static gboolean font_manager_desktop_preferences_from_font_setting (GValue* v,
                                                             GVariant* r,
                                                             const gchar* k);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static GVariant* font_manager_desktop_preferences_to_font_setting (GValue* v,
                                                            const GVariantType* t,
                                                            const gchar* k);
static PangoFontDescription* _vala_PangoFontDescription_copy (PangoFontDescription* self);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
VALA_EXTERN GType font_manager_subpixel_geometry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerSubpixelGeometry, g_object_unref)
VALA_EXTERN FontManagerSubpixelGeometry* font_manager_subpixel_geometry_new (void);
VALA_EXTERN FontManagerSubpixelGeometry* font_manager_subpixel_geometry_construct (GType object_type);
VALA_EXTERN GPtrArray* font_manager_subpixel_geometry_get_options (FontManagerSubpixelGeometry* self);
static gboolean _font_manager_desktop_preferences_from_font_setting_gsettings_bind_get_mapping (GValue* value,
                                                                                         GVariant* variant,
                                                                                         void* user_data);
static GVariant* _font_manager_desktop_preferences_to_font_setting_gsettings_bind_set_mapping (GValue* value,
                                                                                        const GVariantType* expected_type,
                                                                                        void* user_data);
static gboolean _font_manager_desktop_preferences_from_enum_setting_gsettings_bind_get_mapping (GValue* value,
                                                                                         GVariant* variant,
                                                                                         void* user_data);
static GVariant* _font_manager_desktop_preferences_to_enum_setting_gsettings_bind_set_mapping (GValue* value,
                                                                                        const GVariantType* expected_type,
                                                                                        void* user_data);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
static void __________lambda152_ (Block26Data* _data26_);
static void ___________lambda152__g_object_notify (GObject* _sender,
                                            GParamSpec* pspec,
                                            gpointer self);
VALA_EXTERN void font_manager_preference_list_append_row (FontManagerPreferenceList* self,
                                              GtkWidget* widget);
static void font_manager_desktop_preferences_finalize (GObject * obj);
static GType font_manager_desktop_preferences_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

const FontManagerFontSettingKey FONT_MANAGER_DesktopSettings[11] = {{"font-name", N_ ("Interface Font"), N_ ("Font used throughout interface."), "string"}, {"document-font-name", N_ ("Document Font"), N_ ("Font used for reading documents."), "string"}, {"monospace-font-name", N_ ("Monospace Font"), N_ ("Monospaced (fixed-width) font for use in locations such as terminals."), "string"}, {"text-scaling-factor", N_ ("Text Scaling Factor"), N_ ("Factor used to enlarge or reduce text display, without changing font s" \
"ize"), "double"}, {"font-rendering", N_ ("GTK 4 Font Rendering"), N_ ("Automatic option allows GTK 4 to disregard hinting settings."), "bool"}, {"antialiasing", N_ ("Antialiasing"), N_ ("The type of antialiasing to use when rendering fonts.\n" \
"\n" \
"Note : Starting with GTK 4 RGBA is no longer used, only None and Grays" \
"cale are valid values. "), "int"}, {"rgba-order", N_ ("RGBA order"), N_ ("The order of subpixel elements on an LCD screen; only used when antial" \
"iasing is set to rgba."), "int"}, {"hinting", N_ ("Hinting"), N_ ("The type of hinting to use when rendering fonts."), "int"}, {"font-hinting", N_ ("Hinting"), N_ ("The type of hinting to use when rendering fonts."), "int"}, {"font-antialiasing", N_ ("Antialiasing"), N_ ("The type of antialiasing to use when rendering fonts.\n" \
"\n" \
"Note : Starting with GTK 4 RGBA is no longer used, only None and Grays" \
"cale are valid values."), "int"}, {"font-rgba-order", N_ ("RGBA order"), N_ ("The order of subpixel elements on an LCD screen; only used when antial" \
"iasing is set to rgba."), "int"}};

void
font_manager_font_setting_key_copy (const FontManagerFontSettingKey* self,
                                    FontManagerFontSettingKey* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	_tmp0_ = (*self).key;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).key);
	(*dest).key = _tmp1_;
	_tmp2_ = (*self).name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp3_;
	_tmp4_ = (*self).description;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).description);
	(*dest).description = _tmp5_;
	_tmp6_ = (*self).type;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).type);
	(*dest).type = _tmp7_;
}

void
font_manager_font_setting_key_destroy (FontManagerFontSettingKey* self)
{
	_g_free0 ((*self).key);
	_g_free0 ((*self).name);
	_g_free0 ((*self).description);
	_g_free0 ((*self).type);
}

FontManagerFontSettingKey*
font_manager_font_setting_key_dup (const FontManagerFontSettingKey* self)
{
	FontManagerFontSettingKey* dup;
	dup = g_new0 (FontManagerFontSettingKey, 1);
	font_manager_font_setting_key_copy (self, dup);
	return dup;
}

void
font_manager_font_setting_key_free (FontManagerFontSettingKey* self)
{
	font_manager_font_setting_key_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
font_manager_font_setting_key_get_type_once (void)
{
	GType font_manager_font_setting_key_type_id;
	font_manager_font_setting_key_type_id = g_boxed_type_register_static ("FontManagerFontSettingKey", (GBoxedCopyFunc) font_manager_font_setting_key_dup, (GBoxedFreeFunc) font_manager_font_setting_key_free);
	return font_manager_font_setting_key_type_id;
}

GType
font_manager_font_setting_key_get_type (void)
{
	static volatile gsize font_manager_font_setting_key_type_id__once = 0;
	if (g_once_init_enter (&font_manager_font_setting_key_type_id__once)) {
		GType font_manager_font_setting_key_type_id;
		font_manager_font_setting_key_type_id = font_manager_font_setting_key_get_type_once ();
		g_once_init_leave (&font_manager_font_setting_key_type_id__once, font_manager_font_setting_key_type_id);
	}
	return font_manager_font_setting_key_type_id__once;
}

static gboolean
font_manager_desktop_preferences_available (void)
{
	GSettings* _tmp2_;
	gboolean result;
	if (!font_manager_desktop_preferences_initialized) {
		GSettings* _tmp0_;
		GSettings* _tmp1_;
		_tmp0_ = font_manager_get_gsettings (FONT_MANAGER_GNOME_INTERFACE_ID);
		_g_object_unref0 (font_manager_desktop_preferences_interface_settings);
		font_manager_desktop_preferences_interface_settings = _tmp0_;
		_tmp1_ = font_manager_get_gsettings (FONT_MANAGER_GNOME_XSETTINGS_ID);
		_g_object_unref0 (font_manager_desktop_preferences_x_settings);
		font_manager_desktop_preferences_x_settings = _tmp1_;
		font_manager_desktop_preferences_initialized = TRUE;
	}
	_tmp2_ = font_manager_desktop_preferences_interface_settings;
	result = _tmp2_ != NULL;
	return result;
}

FontManagerDesktopPreferences*
font_manager_desktop_preferences_construct (GType object_type)
{
	FontManagerDesktopPreferences * self = NULL;
	GtkListBox* _tmp0_;
	FontManagerPlaceHolder* place_holder = NULL;
	FontManagerPlaceHolder* _tmp1_;
	GtkListBox* _tmp2_;
	self = (FontManagerDesktopPreferences*) font_manager_preference_list_construct (object_type);
	font_manager_widget_set_name ((GtkWidget*) self, "FontManagerDesktopPreferences");
	_tmp0_ = ((FontManagerPreferenceList*) self)->list;
	gtk_list_box_set_selection_mode (_tmp0_, GTK_SELECTION_NONE);
	_tmp1_ = (FontManagerPlaceHolder*) font_manager_place_holder_new (NULL, NULL, _ ("GNOME desktop settings schema not found"), "computer-fail-symbolic");
	g_object_ref_sink (_tmp1_);
	place_holder = _tmp1_;
	_tmp2_ = ((FontManagerPreferenceList*) self)->list;
	gtk_list_box_set_placeholder (_tmp2_, (GtkWidget*) place_holder);
	_g_object_unref0 (place_holder);
	return self;
}

FontManagerDesktopPreferences*
font_manager_desktop_preferences_new (void)
{
	return font_manager_desktop_preferences_construct (FONT_MANAGER_TYPE_DESKTOP_PREFERENCES);
}

static void
font_manager_desktop_preferences_real_on_map (FontManagerPreferenceList* base)
{
	FontManagerDesktopPreferences * self;
	self = (FontManagerDesktopPreferences*) base;
	if (font_manager_desktop_preferences_initialized) {
		return;
	}
	if (font_manager_desktop_preferences_available ()) {
		font_manager_desktop_preferences_generate_options_list (self);
	}
	return;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar**
font_manager_desktop_preferences_get_enum_values (const gchar* k,
                                                  gint* result_length1)
{
	gchar** result;
	g_return_val_if_fail (k != NULL, NULL);
	if (string_contains (k, "antialiasing")) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp0_ = g_strdup ("none");
		_tmp1_ = g_strdup ("grayscale");
		_tmp2_ = g_strdup ("rgba");
		_tmp3_ = g_new0 (gchar*, 3 + 1);
		_tmp3_[0] = _tmp0_;
		_tmp3_[1] = _tmp1_;
		_tmp3_[2] = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp4__length1 = 3;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		return result;
	} else {
		if (string_contains (k, "hinting")) {
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar** _tmp9_;
			gchar** _tmp10_;
			gint _tmp10__length1;
			_tmp5_ = g_strdup ("none");
			_tmp6_ = g_strdup ("slight");
			_tmp7_ = g_strdup ("medium");
			_tmp8_ = g_strdup ("full");
			_tmp9_ = g_new0 (gchar*, 4 + 1);
			_tmp9_[0] = _tmp5_;
			_tmp9_[1] = _tmp6_;
			_tmp9_[2] = _tmp7_;
			_tmp9_[3] = _tmp8_;
			_tmp10_ = _tmp9_;
			_tmp10__length1 = 4;
			if (result_length1) {
				*result_length1 = _tmp10__length1;
			}
			result = _tmp10_;
			return result;
		} else {
			if (string_contains (k, "rgba")) {
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar** _tmp16_;
				gchar** _tmp17_;
				gint _tmp17__length1;
				_tmp11_ = g_strdup ("rgba");
				_tmp12_ = g_strdup ("rgb");
				_tmp13_ = g_strdup ("bgr");
				_tmp14_ = g_strdup ("vrgb");
				_tmp15_ = g_strdup ("vbgr");
				_tmp16_ = g_new0 (gchar*, 5 + 1);
				_tmp16_[0] = _tmp11_;
				_tmp16_[1] = _tmp12_;
				_tmp16_[2] = _tmp13_;
				_tmp16_[3] = _tmp14_;
				_tmp16_[4] = _tmp15_;
				_tmp17_ = _tmp16_;
				_tmp17__length1 = 5;
				if (result_length1) {
					*result_length1 = _tmp17__length1;
				}
				result = _tmp17_;
				return result;
			} else {
				if (string_contains (k, "font-rendering")) {
					gchar* _tmp18_;
					gchar* _tmp19_;
					gchar** _tmp20_;
					gchar** _tmp21_;
					gint _tmp21__length1;
					_tmp18_ = g_strdup ("automatic");
					_tmp19_ = g_strdup ("manual");
					_tmp20_ = g_new0 (gchar*, 2 + 1);
					_tmp20_[0] = _tmp18_;
					_tmp20_[1] = _tmp19_;
					_tmp21_ = _tmp20_;
					_tmp21__length1 = 2;
					if (result_length1) {
						*result_length1 = _tmp21__length1;
					}
					result = _tmp21_;
					return result;
				} else {
					g_return_val_if_reached (NULL);
				}
			}
		}
	}
}

static gboolean
font_manager_desktop_preferences_from_enum_setting (GValue* v,
                                                    GVariant* r,
                                                    const gchar* k)
{
	gchar* s = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** settings = NULL;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint settings_length1;
	gint _settings_size_;
	gboolean result;
	g_return_val_if_fail (v != NULL, FALSE);
	g_return_val_if_fail (r != NULL, FALSE);
	g_return_val_if_fail (k != NULL, FALSE);
	_tmp0_ = g_variant_get_string (r, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	s = _tmp1_;
	_tmp3_ = font_manager_desktop_preferences_get_enum_values (k, &_tmp2_);
	settings = _tmp3_;
	settings_length1 = _tmp2_;
	_settings_size_ = settings_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gchar** _tmp6_;
				gint _tmp6__length1;
				const gchar* _tmp7_;
				gchar** _tmp8_;
				gint _tmp8__length1;
				const gchar* _tmp9_;
				if (!_tmp4_) {
					guint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = settings;
				_tmp6__length1 = settings_length1;
				if (!(i < ((guint) _tmp6__length1))) {
					break;
				}
				_tmp7_ = s;
				_tmp8_ = settings;
				_tmp8__length1 = settings_length1;
				_tmp9_ = _tmp8_[i];
				if (g_strcmp0 (_tmp7_, _tmp9_) == 0) {
					g_value_set_uint (v, i);
					break;
				}
			}
		}
	}
	result = TRUE;
	settings = (_vala_array_free (settings, settings_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (s);
	return result;
}

static GVariant*
font_manager_desktop_preferences_to_enum_setting (GValue* v,
                                                  const GVariantType* t,
                                                  const gchar* k)
{
	gchar** settings = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint settings_length1;
	gint _settings_size_;
	gchar* s = NULL;
	GValue _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GVariant* _tmp5_;
	GVariant* result;
	g_return_val_if_fail (v != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	g_return_val_if_fail (k != NULL, NULL);
	_tmp1_ = font_manager_desktop_preferences_get_enum_values (k, &_tmp0_);
	settings = _tmp1_;
	settings_length1 = _tmp0_;
	_settings_size_ = settings_length1;
	_tmp2_ = *v;
	_tmp3_ = settings[g_value_get_uint (&_tmp2_)];
	_tmp4_ = g_strdup (_tmp3_);
	s = _tmp4_;
	_tmp5_ = g_variant_new_string (s);
	g_variant_ref_sink (_tmp5_);
	result = _tmp5_;
	_g_free0 (s);
	settings = (_vala_array_free (settings, settings_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static gboolean
font_manager_desktop_preferences_from_font_setting (GValue* v,
                                                    GVariant* r,
                                                    const gchar* k)
{
	PangoFontDescription* font_desc = NULL;
	const gchar* _tmp0_;
	PangoFontDescription* _tmp1_;
	gboolean result;
	g_return_val_if_fail (v != NULL, FALSE);
	g_return_val_if_fail (r != NULL, FALSE);
	g_return_val_if_fail (k != NULL, FALSE);
	_tmp0_ = g_variant_get_string (r, NULL);
	_tmp1_ = pango_font_description_from_string (_tmp0_);
	font_desc = _tmp1_;
	g_value_set_boxed (v, font_desc);
	result = TRUE;
	__vala_PangoFontDescription_free0 (font_desc);
	return result;
}

static PangoFontDescription*
_vala_PangoFontDescription_copy (PangoFontDescription* self)
{
	return g_boxed_copy (pango_font_description_get_type (), self);
}

static gpointer
__vala_PangoFontDescription_copy0 (gpointer self)
{
	return self ? _vala_PangoFontDescription_copy (self) : NULL;
}

static GVariant*
font_manager_desktop_preferences_to_font_setting (GValue* v,
                                                  const GVariantType* t,
                                                  const gchar* k)
{
	PangoFontDescription* font_desc = NULL;
	void* _tmp0_;
	PangoFontDescription* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GVariant* result;
	g_return_val_if_fail (v != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	g_return_val_if_fail (k != NULL, NULL);
	_tmp0_ = g_value_get_boxed (v);
	_tmp1_ = __vala_PangoFontDescription_copy0 ((PangoFontDescription*) _tmp0_);
	font_desc = _tmp1_;
	_tmp2_ = pango_font_description_to_string (font_desc);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_new_string (_tmp3_);
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	__vala_PangoFontDescription_free0 (font_desc);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_g_settings_schema_source_ref0 (gpointer self)
{
	return self ? g_settings_schema_source_ref (self) : NULL;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gboolean
_font_manager_desktop_preferences_from_font_setting_gsettings_bind_get_mapping (GValue* value,
                                                                                GVariant* variant,
                                                                                void* user_data)
{
	gboolean result;
	result = font_manager_desktop_preferences_from_font_setting (value, variant, user_data);
	return result;
}

static GVariant*
_font_manager_desktop_preferences_to_font_setting_gsettings_bind_set_mapping (GValue* value,
                                                                              const GVariantType* expected_type,
                                                                              void* user_data)
{
	GVariant* result;
	result = font_manager_desktop_preferences_to_font_setting (value, expected_type, user_data);
	return result;
}

static gboolean
_font_manager_desktop_preferences_from_enum_setting_gsettings_bind_get_mapping (GValue* value,
                                                                                GVariant* variant,
                                                                                void* user_data)
{
	gboolean result;
	result = font_manager_desktop_preferences_from_enum_setting (value, variant, user_data);
	return result;
}

static GVariant*
_font_manager_desktop_preferences_to_enum_setting_gsettings_bind_set_mapping (GValue* value,
                                                                              const GVariantType* expected_type,
                                                                              void* user_data)
{
	GVariant* result;
	result = font_manager_desktop_preferences_to_enum_setting (value, expected_type, user_data);
	return result;
}

static Block25Data*
block25_data_ref (Block25Data* _data25_)
{
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}

static void
block25_data_unref (void * _userdata_)
{
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		FontManagerDesktopPreferences* self;
		self = _data25_->self;
		_g_object_unref0 (_data25_->combo);
		_g_object_unref0 (self);
		g_slice_free (Block25Data, _data25_);
	}
}

static Block26Data*
block26_data_ref (Block26Data* _data26_)
{
	g_atomic_int_inc (&_data26_->_ref_count_);
	return _data26_;
}

static void
block26_data_unref (void * _userdata_)
{
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
		FontManagerDesktopPreferences* self;
		self = _data26_->_data25_->self;
		_g_object_unref0 (_data26_->parent);
		block25_data_unref (_data26_->_data25_);
		_data26_->_data25_ = NULL;
		g_slice_free (Block26Data, _data26_);
	}
}

static void
__________lambda152_ (Block26Data* _data26_)
{
	Block25Data* _data25_;
	FontManagerDesktopPreferences* self;
	FontManagerPreferenceRow* _tmp0_;
	GtkDropDown* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	_data25_ = _data26_->_data25_;
	self = _data25_->self;
	_tmp0_ = _data26_->parent;
	_tmp1_ = _data25_->combo;
	_tmp2_ = gtk_drop_down_get_selected (_tmp1_);
	_tmp3_ = _tmp2_;
	font_manager_preference_row_set_reveal_child (_tmp0_, _tmp3_ == ((guint) 2));
}

static void
___________lambda152__g_object_notify (GObject* _sender,
                                       GParamSpec* pspec,
                                       gpointer self)
{
	__________lambda152_ (self);
}

static void
font_manager_desktop_preferences_generate_options_list (FontManagerDesktopPreferences* self)
{
	GSettings* _settings = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettingsSchemaSource* default_schemas = NULL;
	GSettingsSchemaSource* _tmp2_;
	GSettingsSchemaSource* _tmp3_;
	GSettingsSchema* interface_schema = NULL;
	GSettingsSchemaSource* _tmp4_;
	GSettingsSchema* _tmp5_;
	gchar** interface_keys = NULL;
	gchar** _tmp6_;
	gint interface_keys_length1;
	gint _interface_keys_size_;
	GSettingsSchema* _tmp7_;
	gchar** xsettings_keys = NULL;
	gchar** _tmp11_;
	gint xsettings_keys_length1;
	gint _xsettings_keys_size_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	GSettings* _tmp19_;
	FontManagerSubpixelGeometry* spg = NULL;
	FontManagerSubpixelGeometry* _tmp22_ = NULL;
	FontManagerSubpixelGeometry* _tmp23_;
	GPtrArray* _tmp24_;
	GPtrArray* _tmp25_;
	gconstpointer _tmp26_;
	FontManagerSubpixelGeometry* _tmp27_;
	GPtrArray* _tmp28_;
	GPtrArray* _tmp29_;
	gconstpointer _tmp30_;
	g_return_if_fail (self != NULL);
	_tmp0_ = font_manager_desktop_preferences_interface_settings;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_settings = _tmp1_;
	_tmp2_ = g_settings_schema_source_get_default ();
	_tmp3_ = _g_settings_schema_source_ref0 (_tmp2_);
	default_schemas = _tmp3_;
	_tmp4_ = default_schemas;
	_tmp5_ = g_settings_schema_source_lookup (_tmp4_, FONT_MANAGER_GNOME_INTERFACE_ID, TRUE);
	interface_schema = _tmp5_;
	_tmp6_ = g_new0 (gchar*, 0 + 1);
	interface_keys = _tmp6_;
	interface_keys_length1 = 0;
	_interface_keys_size_ = interface_keys_length1;
	_tmp7_ = interface_schema;
	if (_tmp7_ != NULL) {
		GSettingsSchema* _tmp8_;
		gchar** _tmp9_;
		gchar** _tmp10_;
		_tmp8_ = interface_schema;
		_tmp10_ = _tmp9_ = g_settings_schema_list_keys (_tmp8_);
		interface_keys = (_vala_array_free (interface_keys, interface_keys_length1, (GDestroyNotify) g_free), NULL);
		interface_keys = _tmp10_;
		interface_keys_length1 = _vala_array_length (_tmp9_);
		_interface_keys_size_ = interface_keys_length1;
	}
	_tmp11_ = g_new0 (gchar*, 0 + 1);
	xsettings_keys = _tmp11_;
	xsettings_keys_length1 = 0;
	_xsettings_keys_size_ = xsettings_keys_length1;
	_tmp12_ = interface_keys;
	_tmp12__length1 = interface_keys_length1;
	if (_vala_string_array_contains (_tmp12_, _tmp12__length1, "font-antialiasing")) {
		_g_object_unref0 (font_manager_desktop_preferences_x_settings);
		font_manager_desktop_preferences_x_settings = NULL;
	} else {
		GSettingsSchema* xsettings_schema = NULL;
		GSettingsSchemaSource* _tmp13_;
		GSettingsSchema* _tmp14_;
		GSettingsSchema* _tmp15_;
		_tmp13_ = default_schemas;
		_tmp14_ = g_settings_schema_source_lookup (_tmp13_, FONT_MANAGER_GNOME_XSETTINGS_ID, TRUE);
		xsettings_schema = _tmp14_;
		_tmp15_ = xsettings_schema;
		if (_tmp15_ != NULL) {
			GSettingsSchema* _tmp16_;
			gchar** _tmp17_;
			gchar** _tmp18_;
			_tmp16_ = xsettings_schema;
			_tmp18_ = _tmp17_ = g_settings_schema_list_keys (_tmp16_);
			xsettings_keys = (_vala_array_free (xsettings_keys, xsettings_keys_length1, (GDestroyNotify) g_free), NULL);
			xsettings_keys = _tmp18_;
			xsettings_keys_length1 = _vala_array_length (_tmp17_);
			_xsettings_keys_size_ = xsettings_keys_length1;
		}
		_g_settings_schema_unref0 (xsettings_schema);
	}
	_tmp19_ = font_manager_desktop_preferences_x_settings;
	if (_tmp19_ != NULL) {
		GSettings* _tmp20_;
		GSettings* _tmp21_;
		_tmp20_ = font_manager_desktop_preferences_x_settings;
		_tmp21_ = _g_object_ref0 (_tmp20_);
		_g_object_unref0 (_settings);
		_settings = _tmp21_;
	}
	_tmp22_ = font_manager_subpixel_geometry_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp22_, FONT_MANAGER_DEFAULT_MARGIN * 3);
	g_object_ref_sink (_tmp22_);
	spg = _tmp22_;
	_tmp23_ = spg;
	_tmp24_ = font_manager_subpixel_geometry_get_options (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_ptr_array_index (_tmp25_, (guint) FONT_MANAGER_SUBPIXEL_ORDER_UNKNOWN);
	gtk_widget_set_visible ((GtkWidget*) ((GtkCheckButton*) _tmp26_), FALSE);
	_tmp27_ = spg;
	_tmp28_ = font_manager_subpixel_geometry_get_options (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_ptr_array_index (_tmp29_, (guint) FONT_MANAGER_SUBPIXEL_ORDER_NONE);
	gtk_widget_set_visible ((GtkWidget*) ((GtkCheckButton*) _tmp30_), FALSE);
	{
		FontManagerFontSettingKey* setting_collection = NULL;
		gint setting_collection_length1 = 0;
		gint _setting_collection_size_ = 0;
		gint setting_it = 0;
		setting_collection = FONT_MANAGER_DesktopSettings;
		setting_collection_length1 = G_N_ELEMENTS (FONT_MANAGER_DesktopSettings);
		for (setting_it = 0; setting_it < setting_collection_length1; setting_it = setting_it + 1) {
			FontManagerFontSettingKey setting = {0};
			setting = setting_collection[setting_it];
			{
				gboolean _tmp31_ = FALSE;
				FontManagerFontSettingKey _tmp32_;
				const gchar* _tmp33_;
				gchar** _tmp34_;
				gint _tmp34__length1;
				GtkWidget* widget = NULL;
				FontManagerFontSettingKey _tmp38_;
				const gchar* _tmp39_;
				GtkWidget* _tmp142_;
				GtkWidget* _tmp143_;
				FontManagerFontSettingKey _tmp144_;
				const gchar* _tmp145_;
				GtkWidget* _tmp146_;
				_tmp32_ = setting;
				_tmp33_ = _tmp32_.key;
				_tmp34_ = interface_keys;
				_tmp34__length1 = interface_keys_length1;
				if (!_vala_string_array_contains (_tmp34_, _tmp34__length1, _tmp33_)) {
					FontManagerFontSettingKey _tmp35_;
					const gchar* _tmp36_;
					gchar** _tmp37_;
					gint _tmp37__length1;
					_tmp35_ = setting;
					_tmp36_ = _tmp35_.key;
					_tmp37_ = xsettings_keys;
					_tmp37__length1 = xsettings_keys_length1;
					_tmp31_ = !_vala_string_array_contains (_tmp37_, _tmp37__length1, _tmp36_);
				} else {
					_tmp31_ = FALSE;
				}
				if (_tmp31_) {
					continue;
				}
				widget = NULL;
				_tmp38_ = setting;
				_tmp39_ = _tmp38_.type;
				if (g_strcmp0 (_tmp39_, "string") == 0) {
					GtkFontDialog* dialog = NULL;
					GtkFontDialog* _tmp40_;
					GtkFontDialogButton* control = NULL;
					GtkFontDialog* _tmp41_;
					GtkFontDialog* _tmp42_;
					GtkFontDialogButton* _tmp43_;
					FontManagerFontSettingKey _tmp44_;
					const gchar* _tmp45_;
					GtkFontDialogButton* _tmp46_;
					FontManagerPreferenceRow* _tmp47_;
					GSettings* _tmp48_;
					FontManagerFontSettingKey _tmp49_;
					const gchar* _tmp50_;
					GtkFontDialogButton* _tmp51_;
					FontManagerFontSettingKey _tmp52_;
					const gchar* _tmp53_;
					_tmp40_ = gtk_font_dialog_new ();
					dialog = _tmp40_;
					_tmp41_ = dialog;
					_tmp42_ = _g_object_ref0 (_tmp41_);
					_tmp43_ = (GtkFontDialogButton*) gtk_font_dialog_button_new (_tmp42_);
					g_object_ref_sink (_tmp43_);
					control = _tmp43_;
					_tmp44_ = setting;
					_tmp45_ = _tmp44_.name;
					_tmp46_ = control;
					_tmp47_ = (FontManagerPreferenceRow*) font_manager_preference_row_new (g_dgettext (NULL, _tmp45_), NULL, NULL, (GtkWidget*) _tmp46_);
					g_object_ref_sink (_tmp47_);
					_g_object_unref0 (widget);
					widget = (GtkWidget*) _tmp47_;
					_tmp48_ = font_manager_desktop_preferences_interface_settings;
					_tmp49_ = setting;
					_tmp50_ = _tmp49_.key;
					_tmp51_ = control;
					_tmp52_ = setting;
					_tmp53_ = _tmp52_.key;
					g_settings_bind_with_mapping (_tmp48_, _tmp50_, (GObject*) _tmp51_, "font-desc", G_SETTINGS_BIND_DEFAULT, _font_manager_desktop_preferences_from_font_setting_gsettings_bind_get_mapping, _font_manager_desktop_preferences_to_font_setting_gsettings_bind_set_mapping, _tmp53_, NULL);
					_g_object_unref0 (control);
					_g_object_unref0 (dialog);
				} else {
					FontManagerFontSettingKey _tmp54_;
					const gchar* _tmp55_;
					_tmp54_ = setting;
					_tmp55_ = _tmp54_.type;
					if (g_strcmp0 (_tmp55_, "bool") == 0) {
						FontManagerFontSettingKey _tmp56_;
						const gchar* _tmp57_;
						_tmp56_ = setting;
						_tmp57_ = _tmp56_.key;
						if (string_contains (_tmp57_, "font-rendering")) {
							gchar** options = NULL;
							gchar* _tmp58_;
							gchar* _tmp59_;
							gchar** _tmp60_;
							gint options_length1;
							gint _options_size_;
							GtkStringList* option_list = NULL;
							gchar** _tmp61_;
							gint _tmp61__length1;
							GtkStringList* _tmp62_;
							GtkDropDown* combo = NULL;
							GtkStringList* _tmp63_;
							GListModel* _tmp64_;
							GtkDropDown* _tmp65_;
							FontManagerFontSettingKey _tmp66_;
							const gchar* _tmp67_;
							GtkDropDown* _tmp68_;
							FontManagerPreferenceRow* _tmp69_;
							GSettings* _tmp70_;
							FontManagerFontSettingKey _tmp71_;
							const gchar* _tmp72_;
							GtkDropDown* _tmp73_;
							FontManagerFontSettingKey _tmp74_;
							const gchar* _tmp75_;
							_tmp58_ = g_strdup (_ ("Automatic"));
							_tmp59_ = g_strdup (_ ("Manual"));
							_tmp60_ = g_new0 (gchar*, 2 + 1);
							_tmp60_[0] = _tmp58_;
							_tmp60_[1] = _tmp59_;
							options = _tmp60_;
							options_length1 = 2;
							_options_size_ = options_length1;
							_tmp61_ = options;
							_tmp61__length1 = options_length1;
							_tmp62_ = gtk_string_list_new (_tmp61_);
							option_list = _tmp62_;
							_tmp63_ = option_list;
							_tmp64_ = _g_object_ref0 ((GListModel*) _tmp63_);
							_tmp65_ = (GtkDropDown*) gtk_drop_down_new (_tmp64_, NULL);
							g_object_ref_sink (_tmp65_);
							combo = _tmp65_;
							_tmp66_ = setting;
							_tmp67_ = _tmp66_.name;
							_tmp68_ = combo;
							_tmp69_ = (FontManagerPreferenceRow*) font_manager_preference_row_new (g_dgettext (NULL, _tmp67_), NULL, NULL, (GtkWidget*) _tmp68_);
							g_object_ref_sink (_tmp69_);
							_g_object_unref0 (widget);
							widget = (GtkWidget*) _tmp69_;
							_tmp70_ = _settings;
							_tmp71_ = setting;
							_tmp72_ = _tmp71_.key;
							_tmp73_ = combo;
							_tmp74_ = setting;
							_tmp75_ = _tmp74_.key;
							g_settings_bind_with_mapping (_tmp70_, _tmp72_, (GObject*) _tmp73_, "selected", G_SETTINGS_BIND_DEFAULT, _font_manager_desktop_preferences_from_enum_setting_gsettings_bind_get_mapping, _font_manager_desktop_preferences_to_enum_setting_gsettings_bind_set_mapping, _tmp75_, NULL);
							_g_object_unref0 (combo);
							_g_object_unref0 (option_list);
							options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
						}
					} else {
						FontManagerFontSettingKey _tmp76_;
						const gchar* _tmp77_;
						_tmp76_ = setting;
						_tmp77_ = _tmp76_.type;
						if (g_strcmp0 (_tmp77_, "double") == 0) {
							GtkSpinButton* control = NULL;
							GtkSpinButton* _tmp78_;
							FontManagerFontSettingKey _tmp79_;
							const gchar* _tmp80_;
							GtkSpinButton* _tmp81_;
							FontManagerPreferenceRow* _tmp82_;
							GSettings* _tmp83_;
							FontManagerFontSettingKey _tmp84_;
							const gchar* _tmp85_;
							GtkSpinButton* _tmp86_;
							_tmp78_ = (GtkSpinButton*) gtk_spin_button_new_with_range (0.5, 3.0, 0.1);
							g_object_ref_sink (_tmp78_);
							control = _tmp78_;
							_tmp79_ = setting;
							_tmp80_ = _tmp79_.name;
							_tmp81_ = control;
							_tmp82_ = (FontManagerPreferenceRow*) font_manager_preference_row_new (g_dgettext (NULL, _tmp80_), NULL, NULL, (GtkWidget*) _tmp81_);
							g_object_ref_sink (_tmp82_);
							_g_object_unref0 (widget);
							widget = (GtkWidget*) _tmp82_;
							_tmp83_ = font_manager_desktop_preferences_interface_settings;
							_tmp84_ = setting;
							_tmp85_ = _tmp84_.key;
							_tmp86_ = control;
							g_settings_bind (_tmp83_, _tmp85_, (GObject*) _tmp86_, "value", G_SETTINGS_BIND_DEFAULT);
							_g_object_unref0 (control);
						} else {
							FontManagerFontSettingKey _tmp87_;
							const gchar* _tmp88_;
							_tmp87_ = setting;
							_tmp88_ = _tmp87_.type;
							if (g_strcmp0 (_tmp88_, "int") == 0) {
								GObject* target = NULL;
								FontManagerFontSettingKey _tmp89_;
								const gchar* _tmp90_;
								GSettings* _tmp136_;
								FontManagerFontSettingKey _tmp137_;
								const gchar* _tmp138_;
								GObject* _tmp139_;
								FontManagerFontSettingKey _tmp140_;
								const gchar* _tmp141_;
								target = NULL;
								_tmp89_ = setting;
								_tmp90_ = _tmp89_.key;
								if (!string_contains (_tmp90_, "rgba-order")) {
									Block25Data* _data25_;
									gchar** options = NULL;
									gint options_length1;
									gint _options_size_;
									FontManagerFontSettingKey _tmp91_;
									const gchar* _tmp92_;
									GtkStringList* option_list = NULL;
									gchar** _tmp104_;
									gint _tmp104__length1;
									GtkStringList* _tmp105_;
									GtkStringList* _tmp106_;
									GListModel* _tmp107_;
									GtkDropDown* _tmp108_;
									GtkDropDown* _tmp109_;
									GObject* _tmp110_;
									FontManagerFontSettingKey _tmp111_;
									const gchar* _tmp112_;
									GtkDropDown* _tmp113_;
									FontManagerPreferenceRow* _tmp114_;
									FontManagerFontSettingKey _tmp115_;
									const gchar* _tmp116_;
									_data25_ = g_slice_new0 (Block25Data);
									_data25_->_ref_count_ = 1;
									_data25_->self = g_object_ref (self);
									options = NULL;
									options_length1 = 0;
									_options_size_ = options_length1;
									_tmp91_ = setting;
									_tmp92_ = _tmp91_.key;
									if (string_contains (_tmp92_, "antialiasing")) {
										gchar* _tmp93_;
										gchar* _tmp94_;
										gchar* _tmp95_;
										gchar** _tmp96_;
										_tmp93_ = g_strdup (_ ("None"));
										_tmp94_ = g_strdup (_ ("Grayscale"));
										_tmp95_ = g_strdup (_ ("RGBA"));
										_tmp96_ = g_new0 (gchar*, 3 + 1);
										_tmp96_[0] = _tmp93_;
										_tmp96_[1] = _tmp94_;
										_tmp96_[2] = _tmp95_;
										options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
										options = _tmp96_;
										options_length1 = 3;
										_options_size_ = options_length1;
									} else {
										FontManagerFontSettingKey _tmp97_;
										const gchar* _tmp98_;
										_tmp97_ = setting;
										_tmp98_ = _tmp97_.key;
										if (string_contains (_tmp98_, "hinting")) {
											gchar* _tmp99_;
											gchar* _tmp100_;
											gchar* _tmp101_;
											gchar* _tmp102_;
											gchar** _tmp103_;
											_tmp99_ = g_strdup (_ ("None"));
											_tmp100_ = g_strdup (_ ("Slight"));
											_tmp101_ = g_strdup (_ ("Medium"));
											_tmp102_ = g_strdup (_ ("Full"));
											_tmp103_ = g_new0 (gchar*, 4 + 1);
											_tmp103_[0] = _tmp99_;
											_tmp103_[1] = _tmp100_;
											_tmp103_[2] = _tmp101_;
											_tmp103_[3] = _tmp102_;
											options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
											options = _tmp103_;
											options_length1 = 4;
											_options_size_ = options_length1;
										}
									}
									_tmp104_ = options;
									_tmp104__length1 = options_length1;
									_tmp105_ = gtk_string_list_new (_tmp104_);
									option_list = _tmp105_;
									_tmp106_ = option_list;
									_tmp107_ = _g_object_ref0 ((GListModel*) _tmp106_);
									_tmp108_ = (GtkDropDown*) gtk_drop_down_new (_tmp107_, NULL);
									g_object_ref_sink (_tmp108_);
									_data25_->combo = _tmp108_;
									_tmp109_ = _data25_->combo;
									_tmp110_ = _g_object_ref0 ((GObject*) _tmp109_);
									_g_object_unref0 (target);
									target = _tmp110_;
									_tmp111_ = setting;
									_tmp112_ = _tmp111_.name;
									_tmp113_ = _data25_->combo;
									_tmp114_ = (FontManagerPreferenceRow*) font_manager_preference_row_new (g_dgettext (NULL, _tmp112_), NULL, NULL, (GtkWidget*) _tmp113_);
									g_object_ref_sink (_tmp114_);
									_g_object_unref0 (widget);
									widget = (GtkWidget*) _tmp114_;
									_tmp115_ = setting;
									_tmp116_ = _tmp115_.key;
									if (string_contains (_tmp116_, "antialiasing")) {
										Block26Data* _data26_;
										FontManagerPreferenceRow* child = NULL;
										FontManagerSubpixelGeometry* _tmp117_;
										FontManagerPreferenceRow* _tmp118_;
										GtkWidget* _tmp119_;
										FontManagerPreferenceRow* _tmp120_;
										FontManagerPreferenceRow* _tmp121_;
										FontManagerPreferenceRow* _tmp122_;
										FontManagerPreferenceRow* _tmp123_;
										GtkDropDown* _tmp124_;
										guint _tmp125_;
										guint _tmp126_;
										GtkDropDown* _tmp127_;
										_data26_ = g_slice_new0 (Block26Data);
										_data26_->_ref_count_ = 1;
										_data26_->_data25_ = block25_data_ref (_data25_);
										_tmp117_ = spg;
										_tmp118_ = (FontManagerPreferenceRow*) font_manager_preference_row_new (_ ("Subpixel Geometry"), NULL, NULL, (GtkWidget*) _tmp117_);
										g_object_ref_sink (_tmp118_);
										child = _tmp118_;
										_tmp119_ = widget;
										_tmp120_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp119_, font_manager_preference_row_get_type ()) ? ((FontManagerPreferenceRow*) _tmp119_) : NULL);
										_data26_->parent = _tmp120_;
										_tmp121_ = _data26_->parent;
										_tmp122_ = child;
										font_manager_preference_row_append_child (_tmp121_, _tmp122_);
										_tmp123_ = _data26_->parent;
										_tmp124_ = _data25_->combo;
										_tmp125_ = gtk_drop_down_get_selected (_tmp124_);
										_tmp126_ = _tmp125_;
										font_manager_preference_row_set_reveal_child (_tmp123_, _tmp126_ == ((guint) 2));
										_tmp127_ = _data25_->combo;
										g_signal_connect_data ((GObject*) _tmp127_, "notify::selected", (GCallback) ___________lambda152__g_object_notify, block26_data_ref (_data26_), (GClosureNotify) block26_data_unref, 0);
										_g_object_unref0 (child);
										block26_data_unref (_data26_);
										_data26_ = NULL;
									}
									_g_object_unref0 (option_list);
									options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
									block25_data_unref (_data25_);
									_data25_ = NULL;
								} else {
									FontManagerSubpixelGeometry* _tmp128_;
									GObject* _tmp129_;
									GtkWidget* pref_row = NULL;
									FontManagerSubpixelGeometry* _tmp130_;
									GtkWidget* _tmp131_;
									GtkWidget* _tmp132_;
									GtkWidget* _tmp133_;
									FontManagerFontSettingKey _tmp134_;
									const gchar* _tmp135_;
									_tmp128_ = spg;
									_tmp129_ = _g_object_ref0 ((GObject*) _tmp128_);
									_g_object_unref0 (target);
									target = _tmp129_;
									_tmp130_ = spg;
									_tmp131_ = gtk_widget_get_ancestor ((GtkWidget*) _tmp130_, font_manager_preference_row_get_type ());
									_tmp132_ = _g_object_ref0 (_tmp131_);
									pref_row = _tmp132_;
									_tmp133_ = pref_row;
									_tmp134_ = setting;
									_tmp135_ = _tmp134_.description;
									gtk_widget_set_tooltip_text (_tmp133_, g_dgettext (NULL, _tmp135_));
									_g_object_unref0 (pref_row);
								}
								_tmp136_ = _settings;
								_tmp137_ = setting;
								_tmp138_ = _tmp137_.key;
								_tmp139_ = target;
								_tmp140_ = setting;
								_tmp141_ = _tmp140_.key;
								g_settings_bind_with_mapping (_tmp136_, _tmp138_, _tmp139_, "selected", G_SETTINGS_BIND_DEFAULT, _font_manager_desktop_preferences_from_enum_setting_gsettings_bind_get_mapping, _font_manager_desktop_preferences_to_enum_setting_gsettings_bind_set_mapping, _tmp141_, NULL);
								_g_object_unref0 (target);
							}
						}
					}
				}
				_tmp142_ = widget;
				if (_tmp142_ == NULL) {
					_g_object_unref0 (widget);
					continue;
				}
				_tmp143_ = widget;
				_tmp144_ = setting;
				_tmp145_ = _tmp144_.description;
				gtk_widget_set_tooltip_text (_tmp143_, g_dgettext (NULL, _tmp145_));
				_tmp146_ = widget;
				font_manager_preference_list_append_row ((FontManagerPreferenceList*) self, _tmp146_);
				_g_object_unref0 (widget);
			}
		}
	}
	_g_object_unref0 (spg);
	xsettings_keys = (_vala_array_free (xsettings_keys, xsettings_keys_length1, (GDestroyNotify) g_free), NULL);
	interface_keys = (_vala_array_free (interface_keys, interface_keys_length1, (GDestroyNotify) g_free), NULL);
	_g_settings_schema_unref0 (interface_schema);
	_g_settings_schema_source_unref0 (default_schemas);
	_g_object_unref0 (_settings);
	return;
}

static void
font_manager_desktop_preferences_class_init (FontManagerDesktopPreferencesClass * klass,
                                             gpointer klass_data)
{
	font_manager_desktop_preferences_parent_class = g_type_class_peek_parent (klass);
	((FontManagerPreferenceListClass *) klass)->on_map = (void (*) (FontManagerPreferenceList*)) font_manager_desktop_preferences_real_on_map;
	G_OBJECT_CLASS (klass)->finalize = font_manager_desktop_preferences_finalize;
}

static void
font_manager_desktop_preferences_instance_init (FontManagerDesktopPreferences * self,
                                                gpointer klass)
{
}

static void
font_manager_desktop_preferences_finalize (GObject * obj)
{
	FontManagerDesktopPreferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_DESKTOP_PREFERENCES, FontManagerDesktopPreferences);
	G_OBJECT_CLASS (font_manager_desktop_preferences_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_desktop_preferences_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerDesktopPreferencesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_desktop_preferences_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerDesktopPreferences), 0, (GInstanceInitFunc) font_manager_desktop_preferences_instance_init, NULL };
	GType font_manager_desktop_preferences_type_id;
	font_manager_desktop_preferences_type_id = g_type_register_static (FONT_MANAGER_TYPE_PREFERENCE_LIST, "FontManagerDesktopPreferences", &g_define_type_info, 0);
	return font_manager_desktop_preferences_type_id;
}

GType
font_manager_desktop_preferences_get_type (void)
{
	static volatile gsize font_manager_desktop_preferences_type_id__once = 0;
	if (g_once_init_enter (&font_manager_desktop_preferences_type_id__once)) {
		GType font_manager_desktop_preferences_type_id;
		font_manager_desktop_preferences_type_id = font_manager_desktop_preferences_get_type_once ();
		g_once_init_leave (&font_manager_desktop_preferences_type_id__once, font_manager_desktop_preferences_type_id);
	}
	return font_manager_desktop_preferences_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

