/* window.c generated by valac 0.56.18, the Vala compiler
 * generated from window.vala, do not modify */

/*
 * Color lines for GNOME
 * Copyright © 1999 Free Software Foundation
 * Authors: Robert Szokovacs <szo@szo.hu>
 *          Szabolcs Ban <shooby@gnome.hu>
 *          Karuna Grewal <karunagrewal98@gmail.com>
 *          Ruxandra Simion <ruxandra.simion93@gmail.com>
 * Copyright © 2007 Christian Persch
 *
 * This game is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <libgnome-games-support.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <cairo-gobject.h>
#include <gee.h>

#define FIVE_OR_MORE_APP_KEY_BACKGROUND_COLOR "background-color"
#define FIVE_OR_MORE_APP_KEY_THEME "ball-theme"
#define FIVE_OR_MORE_APP_KEY_SIZE "size"
#define VIEW_default_background_color "rgb(117,144,174)"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_GAME_WINDOW (game_window_get_type ())
#define GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_WINDOW, GameWindow))
#define GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_WINDOW, GameWindowClass))
#define IS_GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_WINDOW))
#define IS_GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_WINDOW))
#define GAME_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_WINDOW, GameWindowClass))

typedef struct _GameWindow GameWindow;
typedef struct _GameWindowClass GameWindowClass;
typedef struct _GameWindowPrivate GameWindowPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define TYPE_THEME_RENDERER (theme_renderer_get_type ())
#define THEME_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_RENDERER, ThemeRenderer))
#define THEME_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_RENDERER, ThemeRendererClass))
#define IS_THEME_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_RENDERER))
#define IS_THEME_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_RENDERER))
#define THEME_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_RENDERER, ThemeRendererClass))

typedef struct _ThemeRenderer ThemeRenderer;
typedef struct _ThemeRendererClass ThemeRendererClass;
enum  {
	GAME_WINDOW_0_PROPERTY,
	GAME_WINDOW_NUM_PROPERTIES
};
static GParamSpec* game_window_properties[GAME_WINDOW_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
typedef void (*GSimpleActionChangeStateCallback) (GSimpleAction* action, GVariant* value, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _theme_renderer_unref0(var) ((var == NULL) ? NULL : (var = (theme_renderer_unref (var), NULL)))
typedef struct _GamePrivate GamePrivate;

#define TYPE_BOARD (board_get_type ())
#define BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOARD, Board))
#define BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOARD, BoardClass))
#define IS_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOARD))
#define IS_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOARD))
#define BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOARD, BoardClass))

typedef struct _Board Board;
typedef struct _BoardClass BoardClass;

#define TYPE_CELL (cell_get_type ())
#define CELL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CELL, Cell))
#define CELL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CELL, CellClass))
#define IS_CELL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CELL))
#define IS_CELL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CELL))
#define CELL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CELL, CellClass))

typedef struct _Cell Cell;
typedef struct _CellClass CellClass;

#define TYPE_PIECE (piece_get_type ())
#define PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIECE, Piece))
#define PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIECE, PieceClass))
#define IS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIECE))
#define IS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIECE))
#define PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIECE, PieceClass))

typedef struct _Piece Piece;
typedef struct _PieceClass PieceClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_KEY_VALUE (key_value_get_type ())
typedef struct _KeyValue KeyValue;

#define TYPE_GAME_DIFFICULTY (game_difficulty_get_type ())
typedef struct _GameDifficulty GameDifficulty;

#define TYPE_VIEW (view_get_type ())
#define VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW, View))
#define VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW, ViewClass))
#define IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW))
#define IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW))
#define VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW, ViewClass))

typedef struct _View View;
typedef struct _ViewClass ViewClass;
typedef struct _Block1Data Block1Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_NEXT_PIECES_WIDGET (next_pieces_widget_get_type ())
#define NEXT_PIECES_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NEXT_PIECES_WIDGET, NextPiecesWidget))
#define NEXT_PIECES_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NEXT_PIECES_WIDGET, NextPiecesWidgetClass))
#define IS_NEXT_PIECES_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NEXT_PIECES_WIDGET))
#define IS_NEXT_PIECES_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NEXT_PIECES_WIDGET))
#define NEXT_PIECES_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NEXT_PIECES_WIDGET, NextPiecesWidgetClass))

typedef struct _NextPiecesWidget NextPiecesWidget;
typedef struct _NextPiecesWidgetClass NextPiecesWidgetClass;
typedef enum  {
	STATUS_MESSAGE_DESCRIPTION,
	STATUS_MESSAGE_NO_PATH,
	STATUS_MESSAGE_GAME_OVER,
	STATUS_MESSAGE_NONE
} StatusMessage;

#define TYPE_STATUS_MESSAGE (status_message_get_type ())
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GameWindow {
	GtkApplicationWindow parent_instance;
	GameWindowPrivate * priv;
};

struct _GameWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _GameWindowPrivate {
	GtkHeaderBar* headerbar;
	GtkBox* preview_hbox;
	GamesGridFrame* grid_frame;
	GSettings* settings;
	gboolean window_tiled;
	gboolean window_maximized;
	gint window_width;
	gint window_height;
	Game* game;
	ThemeRenderer* theme;
	gchar** status;
	gint status_length1;
	gint _status_size_;
	GamesScoresContext* highscores;
};

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
	Board* board;
	gint n_next_pieces;
	gint n_filled_cells;
	GeeArrayList* current_path;
	gboolean animating;
	Piece* animating_piece;
	gint n_categories;
	gchar* score_current_category;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _KeyValue {
	gchar* key;
	gchar* name;
};

struct _GameDifficulty {
	gint n_cols;
	gint n_rows;
	gint n_types;
	gint n_next_pieces;
};

struct _Block1Data {
	int _ref_count_;
	GameWindow* self;
	View* game_view;
	GSimpleAction* reset_background_action;
};

static gint GameWindow_private_offset;
static gpointer game_window_parent_class = NULL;

VALA_EXTERN GType game_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameWindow, g_object_unref)
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
VALA_EXTERN gpointer theme_renderer_ref (gpointer instance);
VALA_EXTERN void theme_renderer_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_theme_renderer (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_theme_renderer (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_theme_renderer (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_theme_renderer (const GValue* value);
VALA_EXTERN GType theme_renderer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThemeRenderer, theme_renderer_unref)
static inline void game_window_change_background (GameWindow* self);
static void _game_window_change_background_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static inline void game_window_reset_background (GameWindow* self);
static void _game_window_reset_background_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static inline void game_window_change_size (GameWindow* self,
                              GSimpleAction* action,
                              GVariant* parameter);
static void _game_window_change_size_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                    GVariant* value,
                                                                    gpointer self);
static inline void game_window_change_theme (GameWindow* self,
                               GSimpleAction* action,
                               GVariant* parameter);
static void _game_window_change_theme_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                     GVariant* value,
                                                                     gpointer self);
static inline void game_window_new_game (GameWindow* self);
static void _game_window_new_game_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static inline void game_window_show_scores (GameWindow* self);
static void _game_window_show_scores_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static gboolean game_window_real_window_state_event (GtkWidget* base,
                                              GdkEventWindowState* event);
static void game_window_real_size_allocate (GtkWidget* base,
                                     GtkAllocation* allocation);
VALA_EXTERN void game_window_on_shutdown (GameWindow* self);
static void game_window_set_status_message (GameWindow* self,
                                     const gchar* message);
static inline void game_window_init_scores_dialog (GameWindow* self);
static inline GamesScoresCategory* game_window_create_category_from_key (GameWindow* self,
                                                           const gchar* key);
static GamesScoresCategory* _game_window_create_category_from_key_games_scores_context_category_request_func (const gchar* category_key,
                                                                                                       gpointer self);
static inline void game_window_score_cb (GameWindow* self);
static void _game_window_score_cb_game_game_over (Game* _sender,
                                           gpointer self);
static inline gchar* game_window_category_name_from_key (GameWindow* self,
                                           const gchar* key);
VALA_EXTERN gpointer board_ref (gpointer instance);
VALA_EXTERN void board_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_board (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_board (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_board (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_board (const GValue* value);
VALA_EXTERN GType board_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Board, board_unref)
VALA_EXTERN gpointer cell_ref (gpointer instance);
VALA_EXTERN void cell_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_cell (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_cell (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_cell (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_cell (const GValue* value);
VALA_EXTERN GType cell_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Cell, cell_unref)
VALA_EXTERN gpointer piece_ref (gpointer instance);
VALA_EXTERN void piece_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_piece (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_piece (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_piece (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_piece (const GValue* value);
VALA_EXTERN GType piece_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Piece, piece_unref)
VALA_EXTERN gint game_get_score (Game* self);
VALA_EXTERN GType key_value_get_type (void) G_GNUC_CONST ;
VALA_EXTERN KeyValue* key_value_dup (const KeyValue* self);
VALA_EXTERN void key_value_free (KeyValue* self);
VALA_EXTERN void key_value_copy (const KeyValue* self,
                     KeyValue* dest);
VALA_EXTERN void key_value_destroy (KeyValue* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (KeyValue, key_value_destroy)
static void __lambda4_ (GameWindow* self,
                 GObject* dialog,
                 GParamSpec* param);
static void ___lambda4__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
VALA_EXTERN GType game_difficulty_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GameDifficulty* game_difficulty_dup (const GameDifficulty* self);
VALA_EXTERN void game_difficulty_free (GameDifficulty* self);
VALA_EXTERN gboolean game_get_is_game_over (Game* self);
VALA_EXTERN void game_new_game (Game* self,
                    gint _size);
VALA_EXTERN GameWindow* game_window_new (void);
VALA_EXTERN GameWindow* game_window_construct (GType object_type);
static GObject * game_window_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
VALA_EXTERN GType view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (View, g_object_unref)
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static GVariant* _variant_new1 (const gchar* value);
VALA_EXTERN Game* game_new (gint size);
VALA_EXTERN Game* game_construct (GType object_type,
                      gint size);
VALA_EXTERN ThemeRenderer* theme_renderer_new (GSettings* settings);
VALA_EXTERN ThemeRenderer* theme_renderer_construct (GType object_type,
                                         GSettings* settings);
VALA_EXTERN GType next_pieces_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NextPiecesWidget, g_object_unref)
VALA_EXTERN NextPiecesWidget* next_pieces_widget_new (GSettings* settings,
                                          Game* game,
                                          ThemeRenderer* theme);
VALA_EXTERN NextPiecesWidget* next_pieces_widget_construct (GType object_type,
                                                GSettings* settings,
                                                Game* game,
                                                ThemeRenderer* theme);
VALA_EXTERN gint game_get_n_cols (Game* self);
VALA_EXTERN gint game_get_n_rows (Game* self);
static void _game_window___lambda6_ (GameWindow* self);
static void __game_window___lambda6__board_board_changed (Board* _sender,
                                                   gpointer self);
static void _game_window___lambda7_ (GameWindow* self,
                              GObject* s,
                              GParamSpec* p);
VALA_EXTERN GType status_message_get_type (void) G_GNUC_CONST ;
static void __game_window___lambda7__g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self);
static void _game_window___lambda8_ (GameWindow* self,
                              GObject* s,
                              GParamSpec* p);
VALA_EXTERN StatusMessage game_get_status_message (Game* self);
static void __game_window___lambda8__g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self);
VALA_EXTERN View* view_new (Game* game,
                ThemeRenderer* theme);
VALA_EXTERN View* view_construct (GType object_type,
                      Game* game,
                      ThemeRenderer* theme);
static void _game_window___lambda10_ (Block1Data* _data1_);
VALA_EXTERN const gchar* view_get_background_color (View* self);
static void __game_window___lambda10__g_object_notify (GObject* _sender,
                                                GParamSpec* pspec,
                                                gpointer self);
static void game_window_finalize (GObject * obj);
static GType game_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry GAME_WINDOW_win_actions[6] = {{"background", _game_window_change_background_gsimple_action_activate_callback}, {"reset-bg", _game_window_reset_background_gsimple_action_activate_callback}, {"change-size", NULL, "s", "'small'", _game_window_change_size_gsimple_action_change_state_callback}, {"change-theme", NULL, "s", "'balls.svg'", _game_window_change_theme_gsimple_action_change_state_callback}, {"new-game", _game_window_new_game_gsimple_action_activate_callback}, {"scores", _game_window_show_scores_gsimple_action_activate_callback}};
VALA_EXTERN const KeyValue GAME_scorecats[3];
VALA_EXTERN const GameDifficulty GAME_game_difficulty[4];

static inline gpointer
game_window_get_instance_private (GameWindow* self)
{
	return G_STRUCT_MEMBER_P (self, GameWindow_private_offset);
}

static void
_game_window_change_background_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	game_window_change_background ((GameWindow*) self);
}

static void
_game_window_reset_background_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	game_window_reset_background ((GameWindow*) self);
}

static void
_game_window_change_size_gsimple_action_change_state_callback (GSimpleAction* action,
                                                               GVariant* value,
                                                               gpointer self)
{
	game_window_change_size ((GameWindow*) self, action, value);
}

static void
_game_window_change_theme_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                GVariant* value,
                                                                gpointer self)
{
	game_window_change_theme ((GameWindow*) self, action, value);
}

static void
_game_window_new_game_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	game_window_new_game ((GameWindow*) self);
}

static void
_game_window_show_scores_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	game_window_show_scores ((GameWindow*) self);
}

static gboolean
game_window_real_window_state_event (GtkWidget* base,
                                     GdkEventWindowState* event)
{
	GameWindow * self;
	gboolean result;
	self = (GameWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if ((event->changed_mask & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		self->priv->window_maximized = (event->new_window_state & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	if ((event->changed_mask & GDK_WINDOW_STATE_TILED) != 0) {
		self->priv->window_tiled = (event->new_window_state & GDK_WINDOW_STATE_TILED) != 0;
	}
	result = FALSE;
	return result;
}

static void
game_window_real_size_allocate (GtkWidget* base,
                                GtkAllocation* allocation)
{
	GameWindow * self;
	GtkAllocation _tmp0_;
	gboolean _tmp1_ = FALSE;
	GtkAllocation _tmp2_;
	GtkAllocation _tmp3_;
	self = (GameWindow*) base;
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	GTK_WIDGET_CLASS (game_window_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow), &_tmp0_);
	if (self->priv->window_maximized) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->window_tiled;
	}
	if (_tmp1_) {
		return;
	}
	_tmp2_ = *allocation;
	self->priv->window_width = _tmp2_.width;
	_tmp3_ = *allocation;
	self->priv->window_height = _tmp3_.height;
}

inline void
game_window_on_shutdown (GameWindow* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	g_settings_delay (_tmp0_);
	_tmp1_ = self->priv->settings;
	g_settings_set_int (_tmp1_, "window-width", self->priv->window_width);
	_tmp2_ = self->priv->settings;
	g_settings_set_int (_tmp2_, "window-height", self->priv->window_height);
	_tmp3_ = self->priv->settings;
	g_settings_set_boolean (_tmp3_, "window-is-maximized", self->priv->window_maximized);
	_tmp4_ = self->priv->settings;
	g_settings_apply (_tmp4_);
}

static void
game_window_set_status_message (GameWindow* self,
                                const gchar* message)
{
	GtkHeaderBar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->headerbar;
	gtk_header_bar_set_subtitle (_tmp0_, message);
}

static GamesScoresCategory*
_game_window_create_category_from_key_games_scores_context_category_request_func (const gchar* category_key,
                                                                                  gpointer self)
{
	GamesScoresCategory* result;
	result = game_window_create_category_from_key ((GameWindow*) self, category_key);
	return result;
}

static void
_game_window_score_cb_game_game_over (Game* _sender,
                                      gpointer self)
{
	game_window_score_cb ((GameWindow*) self);
}

static inline void
game_window_init_scores_dialog (GameWindow* self)
{
	GamesScoresDirectoryImporter* importer = NULL;
	GamesScoresDirectoryImporter* _tmp0_;
	GamesScoresContext* _tmp1_;
	Game* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_scores_directory_importer_new ();
	importer = _tmp0_;
	_tmp1_ = games_scores_context_new_with_importer_and_icon_name ("five-or-more", _ ("Board Size: "), (GtkWindow*) self, _game_window_create_category_from_key_games_scores_context_category_request_func, self, GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER, (GamesScoresImporter*) importer, "org.gnome.five-or-more");
	_g_object_unref0 (self->priv->highscores);
	self->priv->highscores = _tmp1_;
	_tmp2_ = self->priv->game;
	g_signal_connect_object (_tmp2_, "game-over", (GCallback) _game_window_score_cb_game_game_over, self, 0);
	_g_object_unref0 (importer);
}

static inline void
game_window_score_cb (GameWindow* self)
{
	gchar* name = NULL;
	Game* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GamesScoresCategory* current_category = NULL;
	Game* _tmp3_;
	const gchar* _tmp4_;
	GamesScoresCategory* _tmp5_;
	GamesScoresContext* _tmp6_;
	Game* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GCancellable* _tmp10_;
	GCancellable* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = _tmp0_->score_current_category;
	_tmp2_ = game_window_category_name_from_key (self, _tmp1_);
	name = _tmp2_;
	_tmp3_ = self->priv->game;
	_tmp4_ = _tmp3_->score_current_category;
	_tmp5_ = games_scores_category_new (_tmp4_, name);
	current_category = _tmp5_;
	_tmp6_ = self->priv->highscores;
	_tmp7_ = self->priv->game;
	_tmp8_ = game_get_score (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_cancellable_new ();
	_tmp11_ = _tmp10_;
	games_scores_context_add_score (_tmp6_, (glong) _tmp9_, current_category, _tmp11_, NULL, NULL);
	_g_object_unref0 (_tmp11_);
	game_window_show_scores (self);
	_g_object_unref0 (current_category);
	_g_free0 (name);
}

static inline GamesScoresCategory*
game_window_create_category_from_key (GameWindow* self,
                                      const gchar* key)
{
	gchar* name = NULL;
	gchar* _tmp0_;
	GamesScoresCategory* _tmp1_;
	GamesScoresCategory* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = game_window_category_name_from_key (self, key);
	name = _tmp0_;
	_tmp1_ = games_scores_category_new (key, name);
	result = _tmp1_;
	_g_free0 (name);
	return result;
}

static inline gchar*
game_window_category_name_from_key (GameWindow* self,
                                    const gchar* key)
{
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				Game* _tmp2_;
				KeyValue _tmp3_;
				const gchar* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->game;
				if (!(i < _tmp2_->n_categories)) {
					break;
				}
				_tmp3_ = GAME_scorecats[i];
				_tmp4_ = _tmp3_.key;
				if (g_strcmp0 (_tmp4_, key) == 0) {
					KeyValue _tmp5_;
					const gchar* _tmp6_;
					gchar* _tmp7_;
					_tmp5_ = GAME_scorecats[i];
					_tmp6_ = _tmp5_.name;
					_tmp7_ = g_strdup (g_dpgettext2 (NULL, "board size", _tmp6_));
					result = _tmp7_;
					return result;
				}
			}
		}
	}
	_tmp8_ = g_strdup ("");
	result = _tmp8_;
	return result;
}

static inline void
game_window_show_scores (GameWindow* self)
{
	GamesScoresContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->highscores;
	games_scores_context_run_dialog (_tmp0_);
}

static void
__lambda4_ (GameWindow* self,
            GObject* dialog,
            GParamSpec* param)
{
	GdkRGBA color = {0};
	GdkRGBA _tmp0_ = {0};
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (dialog != NULL);
	g_return_if_fail (param != NULL);
	gtk_color_chooser_get_rgba ((GtkColorChooser*) G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_color_chooser_dialog_get_type (), GtkColorChooserDialog), &_tmp0_);
	color = _tmp0_;
	_tmp1_ = self->priv->settings;
	_tmp2_ = gdk_rgba_to_string (&color);
	_tmp3_ = _tmp2_;
	_tmp4_ = !g_settings_set_string (_tmp1_, FIVE_OR_MORE_APP_KEY_BACKGROUND_COLOR, _tmp3_);
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = gdk_rgba_to_string (&color);
		_tmp6_ = _tmp5_;
		g_warning ("window.vala:228: Failed to set color: %s", _tmp6_);
		_g_free0 (_tmp6_);
	}
}

static void
___lambda4__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda4_ ((GameWindow*) self, _sender, pspec);
}

static inline void
game_window_change_background (GameWindow* self)
{
	gchar* old_color_string = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	GtkColorChooserDialog* dialog = NULL;
	GtkColorChooserDialog* _tmp2_;
	GtkColorChooserDialog* _tmp3_;
	GdkRGBA _tmp4_ = {0};
	GdkRGBA _tmp5_;
	const gchar* _tmp6_;
	GtkColorChooserDialog* _tmp7_;
	gint _result_ = 0;
	GtkColorChooserDialog* _tmp8_;
	GtkColorChooserDialog* _tmp9_;
	GSettings* _tmp10_;
	const gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_string (_tmp0_, FIVE_OR_MORE_APP_KEY_BACKGROUND_COLOR);
	old_color_string = _tmp1_;
	_tmp2_ = (GtkColorChooserDialog*) gtk_color_chooser_dialog_new (_ ("Background color"), (GtkWindow*) self);
	g_object_ref_sink (_tmp2_);
	dialog = _tmp2_;
	_tmp3_ = dialog;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp3_, &_tmp4_);
	_tmp5_ = _tmp4_;
	_tmp6_ = old_color_string;
	if (!gdk_rgba_parse (&_tmp5_, _tmp6_)) {
		_g_object_unref0 (dialog);
		_g_free0 (old_color_string);
		return;
	}
	_tmp7_ = dialog;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::rgba", (GCallback) ___lambda4__g_object_notify, self, 0);
	_tmp8_ = dialog;
	_result_ = gtk_dialog_run ((GtkDialog*) _tmp8_);
	_tmp9_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp9_);
	if (_result_ == ((gint) GTK_RESPONSE_OK)) {
		_g_object_unref0 (dialog);
		_g_free0 (old_color_string);
		return;
	}
	_tmp10_ = self->priv->settings;
	_tmp11_ = old_color_string;
	g_settings_set_string (_tmp10_, FIVE_OR_MORE_APP_KEY_BACKGROUND_COLOR, _tmp11_);
	_g_object_unref0 (dialog);
	_g_free0 (old_color_string);
}

static inline void
game_window_reset_background (GameWindow* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	g_settings_reset (_tmp0_, FIVE_OR_MORE_APP_KEY_BACKGROUND_COLOR);
}

static inline void
game_window_change_theme (GameWindow* self,
                          GSimpleAction* action,
                          GVariant* parameter)
{
	GSettings* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (parameter != NULL, "parameter != null");
	g_simple_action_set_state (action, parameter);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_variant_get_string ((GVariant*) parameter, NULL);
	g_settings_set_string (_tmp0_, FIVE_OR_MORE_APP_KEY_THEME, _tmp1_);
}

static inline void
game_window_change_size (GameWindow* self,
                         GSimpleAction* action,
                         GVariant* parameter)
{
	gint size = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	GSettings* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (parameter != NULL, "parameter != null");
	g_simple_action_set_state (action, parameter);
	_tmp0_ = g_variant_get_string (parameter, NULL);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("small")))) {
		switch (0) {
			default:
			{
				size = 1;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("medium")))) {
		switch (0) {
			default:
			{
				size = 2;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("large")))) {
		switch (0) {
			default:
			{
				size = 3;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	_tmp4_ = self->priv->settings;
	g_settings_set_int (_tmp4_, FIVE_OR_MORE_APP_KEY_SIZE, size);
}

static inline void
game_window_new_game (GameWindow* self)
{
	gint size = 0;
	GSettings* _tmp0_;
	gint n_rows = 0;
	GameDifficulty _tmp1_;
	gint n_cols = 0;
	GameDifficulty _tmp2_;
	gboolean _tmp3_ = FALSE;
	Game* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	Game* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	size = g_settings_get_int (_tmp0_, FIVE_OR_MORE_APP_KEY_SIZE);
	_tmp1_ = GAME_game_difficulty[size];
	n_rows = _tmp1_.n_rows;
	_tmp2_ = GAME_game_difficulty[size];
	n_cols = _tmp2_.n_cols;
	_tmp4_ = self->priv->game;
	_tmp5_ = game_get_score (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ > 0) {
		Game* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = self->priv->game;
		_tmp8_ = game_get_is_game_over (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = !_tmp9_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GtkDialogFlags flags = 0U;
		GtkMessageDialog* restart_game_dialog = NULL;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GtkMessageDialog* _tmp12_;
		GtkMessageDialog* _tmp13_;
		GtkMessageDialog* _tmp14_;
		gint _result_ = 0;
		GtkMessageDialog* _tmp15_;
		GtkMessageDialog* _tmp16_;
		flags = GTK_DIALOG_DESTROY_WITH_PARENT;
		_tmp10_ = g_strdup_printf (_ ("Are you sure you want to start a new %u × %u game?"), (guint) n_rows, (guint) n_cols);
		_tmp11_ = _tmp10_;
		_tmp12_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, flags, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", _tmp11_);
		g_object_ref_sink (_tmp12_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		restart_game_dialog = _tmp13_;
		_tmp14_ = restart_game_dialog;
		gtk_dialog_add_buttons ((GtkDialog*) _tmp14_, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Restart"), GTK_RESPONSE_OK, NULL);
		_tmp15_ = restart_game_dialog;
		_result_ = gtk_dialog_run ((GtkDialog*) _tmp15_);
		_tmp16_ = restart_game_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp16_);
		if (_result_ != ((gint) GTK_RESPONSE_OK)) {
			_g_object_unref0 (restart_game_dialog);
			return;
		}
		_g_object_unref0 (restart_game_dialog);
	}
	_tmp17_ = self->priv->game;
	game_new_game (_tmp17_, size);
}

GameWindow*
game_window_construct (GType object_type)
{
	GameWindow * self = NULL;
	self = (GameWindow*) g_object_new (object_type, NULL);
	return self;
}

GameWindow*
game_window_new (void)
{
	return game_window_construct (TYPE_GAME_WINDOW);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		GameWindow* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->reset_background_action);
		_g_object_unref0 (_data1_->game_view);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
_game_window___lambda6_ (GameWindow* self)
{
	GamesGridFrame* _tmp0_;
	Game* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	Game* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	_tmp0_ = self->priv->grid_frame;
	_tmp1_ = self->priv->game;
	_tmp2_ = game_get_n_cols (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->game;
	_tmp5_ = game_get_n_rows (_tmp4_);
	_tmp6_ = _tmp5_;
	games_grid_frame_set (_tmp0_, _tmp3_, _tmp6_);
}

static void
__game_window___lambda6__board_board_changed (Board* _sender,
                                              gpointer self)
{
	_game_window___lambda6_ ((GameWindow*) self);
}

static void
_game_window___lambda7_ (GameWindow* self,
                         GObject* s,
                         GParamSpec* p)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	Game* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->status;
	_tmp0__length1 = self->priv->status_length1;
	_tmp1_ = _tmp0_[STATUS_MESSAGE_NONE];
	_tmp2_ = self->priv->game;
	_tmp3_ = game_get_score (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf (_tmp1_, _tmp4_);
	_tmp6_ = _tmp5_;
	game_window_set_status_message (self, _tmp6_);
	_g_free0 (_tmp6_);
}

static void
__game_window___lambda7__g_object_notify (GObject* _sender,
                                          GParamSpec* pspec,
                                          gpointer self)
{
	_game_window___lambda7_ ((GameWindow*) self, _sender, pspec);
}

static void
_game_window___lambda8_ (GameWindow* self,
                         GObject* s,
                         GParamSpec* p)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	Game* _tmp1_;
	StatusMessage _tmp2_;
	StatusMessage _tmp3_;
	const gchar* _tmp4_;
	Game* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->status;
	_tmp0__length1 = self->priv->status_length1;
	_tmp1_ = self->priv->game;
	_tmp2_ = game_get_status_message (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp0_[_tmp3_];
	_tmp5_ = self->priv->game;
	_tmp6_ = game_get_score (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf (_tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	game_window_set_status_message (self, _tmp9_);
	_g_free0 (_tmp9_);
}

static void
__game_window___lambda8__g_object_notify (GObject* _sender,
                                          GParamSpec* pspec,
                                          gpointer self)
{
	_game_window___lambda8_ ((GameWindow*) self, _sender, pspec);
}

static void
_game_window___lambda10_ (Block1Data* _data1_)
{
	GameWindow* self;
	GSimpleAction* _tmp0_;
	View* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	self = _data1_->self;
	_tmp0_ = _data1_->reset_background_action;
	_tmp1_ = _data1_->game_view;
	_tmp2_ = view_get_background_color (_tmp1_);
	_tmp3_ = _tmp2_;
	g_simple_action_set_enabled (_tmp0_, g_strcmp0 (_tmp3_, VIEW_default_background_color) != 0);
}

static void
__game_window___lambda10__g_object_notify (GObject* _sender,
                                           GParamSpec* pspec,
                                           gpointer self)
{
	_game_window___lambda10_ (self);
}

static GObject *
game_window_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GameWindow * self;
	Block1Data* _data1_;
	GSimpleAction* theme_action = NULL;
	GAction* _tmp0_;
	GSimpleAction* _tmp1_;
	gchar* theme_value = NULL;
	GSettings* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	GSimpleAction* _tmp11_;
	const gchar* _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	GAction* board_size_action = NULL;
	GAction* _tmp15_;
	GAction* _tmp16_;
	gchar* board_size_string = NULL;
	gint board_size = 0;
	GSettings* _tmp17_;
	GAction* _tmp21_;
	const gchar* _tmp22_;
	GVariant* _tmp23_;
	Game* _tmp24_;
	GSettings* _tmp25_;
	ThemeRenderer* _tmp26_;
	GSettings* _tmp27_;
	GSettings* _tmp28_;
	GSettings* _tmp29_;
	NextPiecesWidget* next_pieces_widget = NULL;
	GSettings* _tmp30_;
	Game* _tmp31_;
	ThemeRenderer* _tmp32_;
	NextPiecesWidget* _tmp33_;
	GtkBox* _tmp34_;
	NextPiecesWidget* _tmp35_;
	NextPiecesWidget* _tmp36_;
	NextPiecesWidget* _tmp37_;
	GamesGridFrame* _tmp38_;
	Game* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	Game* _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	Game* _tmp45_;
	Board* _tmp46_;
	Game* _tmp47_;
	Game* _tmp48_;
	gchar** _tmp49_;
	gint _tmp49__length1;
	Game* _tmp50_;
	StatusMessage _tmp51_;
	StatusMessage _tmp52_;
	const gchar* _tmp53_;
	Game* _tmp54_;
	ThemeRenderer* _tmp55_;
	View* _tmp56_;
	GAction* _tmp57_;
	GSimpleAction* _tmp58_;
	View* _tmp59_;
	GSettings* _tmp60_;
	View* _tmp61_;
	GamesGridFrame* _tmp62_;
	View* _tmp63_;
	View* _tmp64_;
	GamesGridFrame* _tmp65_;
	parent_class = G_OBJECT_CLASS (game_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_WINDOW, GameWindow);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	g_action_map_add_action_entries ((GActionMap*) self, GAME_WINDOW_win_actions, (gint) G_N_ELEMENTS (GAME_WINDOW_win_actions), self);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "change-theme");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction));
	theme_action = _tmp1_;
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_settings_get_string (_tmp2_, FIVE_OR_MORE_APP_KEY_THEME);
	theme_value = _tmp3_;
	_tmp6_ = theme_value;
	if (g_strcmp0 (_tmp6_, "balls.svg") != 0) {
		const gchar* _tmp7_;
		_tmp7_ = theme_value;
		_tmp5_ = g_strcmp0 (_tmp7_, "shapes.svg") != 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp8_;
		_tmp8_ = theme_value;
		_tmp4_ = g_strcmp0 (_tmp8_, "tango.svg") != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GSettings* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = self->priv->settings;
		g_settings_set_string (_tmp9_, FIVE_OR_MORE_APP_KEY_THEME, "balls.svg");
		_tmp10_ = g_strdup ("balls.svg");
		_g_free0 (theme_value);
		theme_value = _tmp10_;
	}
	_tmp11_ = theme_action;
	_tmp12_ = theme_value;
	_tmp13_ = g_variant_new_string (_tmp12_);
	g_variant_ref_sink (_tmp13_);
	_tmp14_ = _tmp13_;
	g_simple_action_set_state (_tmp11_, _tmp14_);
	_g_variant_unref0 (_tmp14_);
	_tmp15_ = g_action_map_lookup_action ((GActionMap*) self, "change-size");
	_tmp16_ = _g_object_ref0 (_tmp15_);
	board_size_action = _tmp16_;
	_tmp17_ = self->priv->settings;
	board_size = g_settings_get_int (_tmp17_, FIVE_OR_MORE_APP_KEY_SIZE);
	switch (board_size) {
		case 1:
		{
			gchar* _tmp18_;
			_tmp18_ = g_strdup ("small");
			_g_free0 (board_size_string);
			board_size_string = _tmp18_;
			break;
		}
		case 2:
		{
			gchar* _tmp19_;
			_tmp19_ = g_strdup ("medium");
			_g_free0 (board_size_string);
			board_size_string = _tmp19_;
			break;
		}
		case 3:
		{
			gchar* _tmp20_;
			_tmp20_ = g_strdup ("large");
			_g_free0 (board_size_string);
			board_size_string = _tmp20_;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp21_ = board_size_action;
	_tmp22_ = board_size_string;
	_tmp23_ = _variant_new1 (_tmp22_);
	g_simple_action_set_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, g_simple_action_get_type (), GSimpleAction), _tmp23_);
	_g_variant_unref0 (_tmp23_);
	_tmp24_ = game_new (board_size);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp24_;
	_tmp25_ = self->priv->settings;
	_tmp26_ = theme_renderer_new (_tmp25_);
	_theme_renderer_unref0 (self->priv->theme);
	self->priv->theme = _tmp26_;
	_tmp27_ = self->priv->settings;
	_tmp28_ = self->priv->settings;
	gtk_window_set_default_size ((GtkWindow*) self, g_settings_get_int (_tmp27_, "window-width"), g_settings_get_int (_tmp28_, "window-height"));
	_tmp29_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp29_, "window-is-maximized")) {
		gtk_window_maximize ((GtkWindow*) self);
	}
	_tmp30_ = self->priv->settings;
	_tmp31_ = self->priv->game;
	_tmp32_ = self->priv->theme;
	_tmp33_ = next_pieces_widget_new (_tmp30_, _tmp31_, _tmp32_);
	g_object_ref_sink (_tmp33_);
	next_pieces_widget = _tmp33_;
	_tmp34_ = self->priv->preview_hbox;
	_tmp35_ = next_pieces_widget;
	gtk_box_pack_start (_tmp34_, (GtkWidget*) _tmp35_, TRUE, TRUE, (guint) 0);
	_tmp36_ = next_pieces_widget;
	gtk_widget_realize ((GtkWidget*) _tmp36_);
	_tmp37_ = next_pieces_widget;
	gtk_widget_show ((GtkWidget*) _tmp37_);
	_tmp38_ = self->priv->grid_frame;
	_tmp39_ = self->priv->game;
	_tmp40_ = game_get_n_cols (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = self->priv->game;
	_tmp43_ = game_get_n_rows (_tmp42_);
	_tmp44_ = _tmp43_;
	games_grid_frame_set (_tmp38_, _tmp41_, _tmp44_);
	_tmp45_ = self->priv->game;
	_tmp46_ = _tmp45_->board;
	g_signal_connect_object (_tmp46_, "board-changed", (GCallback) __game_window___lambda6__board_board_changed, self, 0);
	_tmp47_ = self->priv->game;
	g_signal_connect_object ((GObject*) _tmp47_, "notify::score", (GCallback) __game_window___lambda7__g_object_notify, self, 0);
	_tmp48_ = self->priv->game;
	g_signal_connect_object ((GObject*) _tmp48_, "notify::status-message", (GCallback) __game_window___lambda8__g_object_notify, self, 0);
	_tmp49_ = self->priv->status;
	_tmp49__length1 = self->priv->status_length1;
	_tmp50_ = self->priv->game;
	_tmp51_ = game_get_status_message (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = _tmp49_[_tmp52_];
	game_window_set_status_message (self, _tmp53_);
	_tmp54_ = self->priv->game;
	_tmp55_ = self->priv->theme;
	_tmp56_ = view_new (_tmp54_, _tmp55_);
	g_object_ref_sink (_tmp56_);
	_data1_->game_view = _tmp56_;
	_tmp57_ = g_action_map_lookup_action ((GActionMap*) self, "reset-bg");
	_tmp58_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, g_simple_action_get_type (), GSimpleAction));
	_data1_->reset_background_action = _tmp58_;
	_tmp59_ = _data1_->game_view;
	g_signal_connect_data ((GObject*) _tmp59_, "notify::background-color", (GCallback) __game_window___lambda10__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp60_ = self->priv->settings;
	_tmp61_ = _data1_->game_view;
	g_settings_bind (_tmp60_, FIVE_OR_MORE_APP_KEY_BACKGROUND_COLOR, (GObject*) _tmp61_, "background-color", G_SETTINGS_BIND_DEFAULT);
	_tmp62_ = self->priv->grid_frame;
	_tmp63_ = _data1_->game_view;
	gtk_container_add ((GtkContainer*) _tmp62_, (GtkWidget*) _tmp63_);
	_tmp64_ = _data1_->game_view;
	gtk_widget_show ((GtkWidget*) _tmp64_);
	_tmp65_ = self->priv->grid_frame;
	gtk_widget_show ((GtkWidget*) _tmp65_);
	game_window_init_scores_dialog (self);
	_g_object_unref0 (next_pieces_widget);
	_g_free0 (board_size_string);
	_g_object_unref0 (board_size_action);
	_g_free0 (theme_value);
	_g_object_unref0 (theme_action);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return obj;
}

static void
game_window_class_init (GameWindowClass * klass,
                        gpointer klass_data)
{
	game_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GameWindow_private_offset);
	((GtkWidgetClass *) klass)->window_state_event = (gboolean (*) (GtkWidget*, GdkEventWindowState*)) game_window_real_window_state_event;
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, GtkAllocation*)) game_window_real_size_allocate;
	G_OBJECT_CLASS (klass)->constructor = game_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = game_window_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/five-or-more/ui/five-or-more.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "headerbar", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, headerbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "preview_hbox", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, preview_hbox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid_frame", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, grid_frame));
}

static void
game_window_instance_init (GameWindow * self,
                           gpointer klass)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	self->priv = game_window_get_instance_private (self);
	_tmp0_ = g_settings_new ("org.gnome.five-or-more");
	self->priv->settings = _tmp0_;
	self->priv->game = NULL;
	self->priv->theme = NULL;
	_tmp1_ = g_strdup (_ ("Match five objects of the same type in a row to score!"));
	_tmp2_ = g_strdup (_ ("You can’t move there!"));
	_tmp3_ = g_strdup (_ ("Game Over!"));
	_tmp4_ = g_strdup (_ ("Score: %d"));
	_tmp5_ = g_new0 (gchar*, 4 + 1);
	_tmp5_[0] = _tmp1_;
	_tmp5_[1] = _tmp2_;
	_tmp5_[2] = _tmp3_;
	_tmp5_[3] = _tmp4_;
	self->priv->status = _tmp5_;
	self->priv->status_length1 = 4;
	self->priv->_status_size_ = self->priv->status_length1;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
game_window_finalize (GObject * obj)
{
	GameWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_WINDOW, GameWindow);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->game);
	_theme_renderer_unref0 (self->priv->theme);
	self->priv->status = (_vala_array_free (self->priv->status, self->priv->status_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->highscores);
	G_OBJECT_CLASS (game_window_parent_class)->finalize (obj);
}

static GType
game_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameWindow), 0, (GInstanceInitFunc) game_window_instance_init, NULL };
	GType game_window_type_id;
	game_window_type_id = g_type_register_static (gtk_application_window_get_type (), "GameWindow", &g_define_type_info, 0);
	GameWindow_private_offset = g_type_add_instance_private (game_window_type_id, sizeof (GameWindowPrivate));
	return game_window_type_id;
}

GType
game_window_get_type (void)
{
	static volatile gsize game_window_type_id__once = 0;
	if (g_once_init_enter (&game_window_type_id__once)) {
		GType game_window_type_id;
		game_window_type_id = game_window_get_type_once ();
		g_once_init_leave (&game_window_type_id__once, game_window_type_id);
	}
	return game_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

