/* ToolSupport.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ToolSupport.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */
/* This file holds some abstractions around loading which ToolPlugin to use.*/
/* (i.e. whether to use Restic or Duplicity)*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include "deja.h"
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DejaDupGetToolForBackendData DejaDupGetToolForBackendData;

struct _DejaDupGetToolForBackendData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackend* backend;
	DejaDupToolPlugin* result;
	GList* filenames;
	GList* _tmp0_;
	GCompareFunc _tmp1_;
	GList* _tmp2_;
	gchar** expected;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gint expected_length1;
	gint _expected_size_;
	gint restic_found;
	GList* iter;
	GList* _tmp9_;
	GList* _tmp10_;
	GList* next;
	GList* _tmp11_;
	GList* _tmp12_;
	gint i;
	gboolean _tmp13_;
	gint _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	GList* _tmp16_;
	gconstpointer _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	GList* _tmp20_;
	gint _tmp21_;
	GList* _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	DejaDupToolPlugin* _tmp24_;
	DejaDupToolPlugin* _tmp25_;
	DejaDupToolPlugin* _tmp26_;
	GList* _tmp27_;
	GList* filename_collection;
	GList* filename_it;
	gchar* _tmp28_;
	gchar* filename;
	const gchar* _tmp29_;
	DejaDupToolPlugin* _tmp30_;
	DejaDupToolPlugin* _tmp31_;
	DejaDupToolPlugin* _tmp32_;
	gchar* msg;
	GList* _tmp33_;
	gconstpointer _tmp34_;
	gchar* _tmp35_;
	const gchar* _tmp36_;
	GError* _tmp37_;
	GError* _inner_error0_;
};

VALA_EXTERN DejaDupToolPlugin* deja_dup_restic_tool;
DejaDupToolPlugin* deja_dup_restic_tool = NULL;
VALA_EXTERN DejaDupToolPlugin* deja_dup_duplicity_tool;
DejaDupToolPlugin* deja_dup_duplicity_tool = NULL;

VALA_EXTERN gchar* deja_dup_unsupported_msg (const gchar* tool_name);
VALA_EXTERN DejaDupToolPlugin* deja_dup_make_borg_tool (GError** error);
VALA_EXTERN DejaDupToolPlugin* deja_dup_make_restic_tool (void);
VALA_EXTERN DejaDupToolPlugin* deja_dup_make_duplicity_tool (void);
VALA_EXTERN DejaDupToolPlugin* deja_dup_make_tool (const gchar* tool_name,
                                       GError** error);
static void deja_dup_get_tool_for_backend_data_free (gpointer _data);
static gboolean deja_dup_get_tool_for_backend_co (DejaDupGetToolForBackendData* _data_);
static void deja_dup_get_tool_for_backend_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

gchar*
deja_dup_unsupported_msg (const gchar* tool_name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (tool_name != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("%s backups are not supported in this release. Try using another storag" \
"e location."), tool_name);
	result = _tmp0_;
	return result;
}

DejaDupToolPlugin*
deja_dup_make_borg_tool (GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _tmp2_;
	GError* _tmp3_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = deja_dup_unsupported_msg ("Borg");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	_inner_error0_ = _tmp3_;
	if (_inner_error0_->domain == G_OPTION_ERROR) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

DejaDupToolPlugin*
deja_dup_make_restic_tool (void)
{
	DejaDupToolPlugin* _tmp0_;
	DejaDupToolPlugin* _tmp2_;
	DejaDupToolPlugin* _tmp3_;
	DejaDupToolPlugin* result;
	_tmp0_ = deja_dup_restic_tool;
	if (_tmp0_ == NULL) {
		ResticPlugin* _tmp1_;
		_tmp1_ = restic_plugin_new ();
		_g_object_unref0 (deja_dup_restic_tool);
		deja_dup_restic_tool = (DejaDupToolPlugin*) _tmp1_;
	}
	_tmp2_ = deja_dup_restic_tool;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

DejaDupToolPlugin*
deja_dup_make_duplicity_tool (void)
{
	DejaDupToolPlugin* _tmp0_;
	DejaDupToolPlugin* _tmp2_;
	DejaDupToolPlugin* _tmp3_;
	DejaDupToolPlugin* result;
	_tmp0_ = deja_dup_duplicity_tool;
	if (_tmp0_ == NULL) {
		DuplicityPlugin* _tmp1_;
		_tmp1_ = duplicity_plugin_new ();
		_g_object_unref0 (deja_dup_duplicity_tool);
		deja_dup_duplicity_tool = (DejaDupToolPlugin*) _tmp1_;
	}
	_tmp2_ = deja_dup_duplicity_tool;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

DejaDupToolPlugin*
deja_dup_make_tool (const gchar* tool_name,
                    GError** error)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	GError* _inner_error0_ = NULL;
	DejaDupToolPlugin* result;
	g_return_val_if_fail (tool_name != NULL, NULL);
	_tmp0_ = tool_name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("borg")))) {
		switch (0) {
			default:
			{
				DejaDupToolPlugin* _tmp3_ = NULL;
				DejaDupToolPlugin* _tmp4_;
				DejaDupToolPlugin* _tmp5_;
				_tmp4_ = deja_dup_make_borg_tool (&_inner_error0_);
				_tmp3_ = _tmp4_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_OPTION_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return NULL;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp5_ = _tmp3_;
				_tmp3_ = NULL;
				result = _tmp5_;
				_g_object_unref0 (_tmp3_);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("duplicity")))) {
		switch (0) {
			default:
			{
				DejaDupToolPlugin* _tmp6_;
				_tmp6_ = deja_dup_make_duplicity_tool ();
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("auto")))) {
		switch (0) {
			default:
			{
				DejaDupToolPlugin* _tmp7_;
				_tmp7_ = deja_dup_make_restic_tool ();
				result = _tmp7_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				DejaDupToolPlugin* _tmp8_;
				_tmp8_ = deja_dup_make_restic_tool ();
				result = _tmp8_;
				return result;
			}
		}
	}
}

DejaDupToolPlugin*
deja_dup_get_default_tool (void)
{
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_;
	gchar* tool_name = NULL;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	DejaDupToolPlugin* result;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_TOOL_WHEN_NEW_KEY);
	tool_name = _tmp1_;
	{
		DejaDupToolPlugin* _tmp2_ = NULL;
		DejaDupToolPlugin* _tmp3_;
		DejaDupToolPlugin* _tmp4_;
		_tmp3_ = deja_dup_make_tool (tool_name, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_free0 (tool_name);
			_g_object_unref0 (settings);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		result = _tmp4_;
		_g_object_unref0 (_tmp2_);
		_g_free0 (tool_name);
		_g_object_unref0 (settings);
		return result;
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		DejaDupToolPlugin* _tmp5_;
		g_clear_error (&_inner_error0_);
		_tmp5_ = deja_dup_make_duplicity_tool ();
		result = _tmp5_;
		_g_free0 (tool_name);
		_g_object_unref0 (settings);
		return result;
	}
	__finally0:
	_g_free0 (tool_name);
	_g_object_unref0 (settings);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
deja_dup_get_tool_for_backend_data_free (gpointer _data)
{
	DejaDupGetToolForBackendData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->backend);
	_g_object_unref0 (_data_->result);
	g_slice_free (DejaDupGetToolForBackendData, _data_);
}

void
deja_dup_get_tool_for_backend (DejaDupBackend* backend,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	DejaDupGetToolForBackendData* _data_;
	DejaDupBackend* _tmp0_;
	g_return_if_fail (backend != NULL);
	_data_ = g_slice_new0 (DejaDupGetToolForBackendData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_get_tool_for_backend_data_free);
	_tmp0_ = _g_object_ref0 (backend);
	_g_object_unref0 (_data_->backend);
	_data_->backend = _tmp0_;
	deja_dup_get_tool_for_backend_co (_data_);
}

DejaDupToolPlugin*
deja_dup_get_tool_for_backend_finish (GAsyncResult* _res_,
                                      GError** error)
{
	DejaDupToolPlugin* result;
	DejaDupGetToolForBackendData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
deja_dup_get_tool_for_backend_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	DejaDupGetToolForBackendData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_get_tool_for_backend_co (_data_);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static gboolean
deja_dup_get_tool_for_backend_co (DejaDupGetToolForBackendData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	deja_dup_backend_peek_at_files (_data_->backend, deja_dup_get_tool_for_backend_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = deja_dup_backend_peek_at_files_finish (_data_->backend, _data_->_res_);
	_data_->filenames = _data_->_tmp0_;
	_data_->_tmp1_ = ((GCompareFunc) g_strcmp0);
	_data_->filenames = g_list_sort (_data_->filenames, _data_->_tmp1_);
	_data_->_tmp2_ = _data_->filenames;
	if (_data_->_tmp2_ == NULL) {
		_data_->result = NULL;
		(_data_->filenames == NULL) ? NULL : (_data_->filenames = (_g_list_free__g_free0_ (_data_->filenames), NULL));
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = g_strdup ("config");
	_data_->_tmp4_ = g_strdup ("data");
	_data_->_tmp5_ = g_strdup ("index");
	_data_->_tmp6_ = g_strdup ("keys");
	_data_->_tmp7_ = g_strdup ("snapshots");
	_data_->_tmp8_ = g_new0 (gchar*, 5 + 1);
	_data_->_tmp8_[0] = _data_->_tmp3_;
	_data_->_tmp8_[1] = _data_->_tmp4_;
	_data_->_tmp8_[2] = _data_->_tmp5_;
	_data_->_tmp8_[3] = _data_->_tmp6_;
	_data_->_tmp8_[4] = _data_->_tmp7_;
	_data_->expected = _data_->_tmp8_;
	_data_->expected_length1 = 5;
	_data_->_expected_size_ = _data_->expected_length1;
	_data_->restic_found = 0;
	_data_->_tmp9_ = _data_->filenames;
	_data_->iter = _data_->_tmp9_;
	while (TRUE) {
		_data_->_tmp10_ = _data_->iter;
		if (!(_data_->_tmp10_ != NULL)) {
			break;
		}
		_data_->_tmp11_ = _data_->iter;
		_data_->_tmp12_ = _data_->_tmp11_->next;
		_data_->next = _data_->_tmp12_;
		{
			_data_->i = 0;
			{
				_data_->_tmp13_ = TRUE;
				while (TRUE) {
					if (!_data_->_tmp13_) {
						_data_->_tmp14_ = _data_->i;
						_data_->i = _data_->_tmp14_ + 1;
					}
					_data_->_tmp13_ = FALSE;
					_data_->_tmp15_ = _data_->expected;
					_data_->_tmp15__length1 = _data_->expected_length1;
					if (!(_data_->i < _data_->_tmp15__length1)) {
						break;
					}
					_data_->_tmp16_ = _data_->iter;
					_data_->_tmp17_ = _data_->_tmp16_->data;
					_data_->_tmp18_ = _data_->expected;
					_data_->_tmp18__length1 = _data_->expected_length1;
					_data_->_tmp19_ = _data_->_tmp18_[_data_->i];
					if (g_strcmp0 ((const gchar*) _data_->_tmp17_, _data_->_tmp19_) == 0) {
						_data_->_tmp20_ = _data_->iter;
						_data_->filenames = g_list_delete_link (_data_->filenames, _data_->_tmp20_);
						_data_->_tmp21_ = _data_->restic_found;
						_data_->restic_found = _data_->_tmp21_ + 1;
						break;
					}
				}
			}
		}
		_data_->_tmp22_ = _data_->next;
		_data_->iter = _data_->_tmp22_;
	}
	_data_->_tmp23_ = _data_->expected;
	_data_->_tmp23__length1 = _data_->expected_length1;
	if (_data_->restic_found == _data_->_tmp23__length1) {
		_data_->_tmp25_ = deja_dup_make_tool ("restic", &_data_->_inner_error0_);
		_data_->_tmp24_ = _data_->_tmp25_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == G_OPTION_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_data_->expected = (_vala_array_free (_data_->expected, _data_->expected_length1, (GDestroyNotify) g_free), NULL);
				(_data_->filenames == NULL) ? NULL : (_data_->filenames = (_g_list_free__g_free0_ (_data_->filenames), NULL));
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_data_->expected = (_vala_array_free (_data_->expected, _data_->expected_length1, (GDestroyNotify) g_free), NULL);
				(_data_->filenames == NULL) ? NULL : (_data_->filenames = (_g_list_free__g_free0_ (_data_->filenames), NULL));
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_data_->_tmp26_ = _data_->_tmp24_;
		_data_->_tmp24_ = NULL;
		_data_->result = _data_->_tmp26_;
		_g_object_unref0 (_data_->_tmp24_);
		_data_->expected = (_vala_array_free (_data_->expected, _data_->expected_length1, (GDestroyNotify) g_free), NULL);
		(_data_->filenames == NULL) ? NULL : (_data_->filenames = (_g_list_free__g_free0_ (_data_->filenames), NULL));
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp27_ = _data_->filenames;
	{
		_data_->filename_collection = _data_->_tmp27_;
		for (_data_->filename_it = _data_->filename_collection; _data_->filename_it != NULL; _data_->filename_it = _data_->filename_it->next) {
			_data_->_tmp28_ = g_strdup ((const gchar*) _data_->filename_it->data);
			_data_->filename = _data_->_tmp28_;
			{
				_data_->_tmp29_ = _data_->filename;
				if (g_str_has_prefix (_data_->_tmp29_, "duplicity-")) {
					_data_->_tmp31_ = deja_dup_make_tool ("duplicity", &_data_->_inner_error0_);
					_data_->_tmp30_ = _data_->_tmp31_;
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						if (_data_->_inner_error0_->domain == G_OPTION_ERROR) {
							g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
							_g_free0 (_data_->filename);
							_data_->expected = (_vala_array_free (_data_->expected, _data_->expected_length1, (GDestroyNotify) g_free), NULL);
							(_data_->filenames == NULL) ? NULL : (_data_->filenames = (_g_list_free__g_free0_ (_data_->filenames), NULL));
							g_object_unref (_data_->_async_result);
							return FALSE;
						} else {
							_g_free0 (_data_->filename);
							_data_->expected = (_vala_array_free (_data_->expected, _data_->expected_length1, (GDestroyNotify) g_free), NULL);
							(_data_->filenames == NULL) ? NULL : (_data_->filenames = (_g_list_free__g_free0_ (_data_->filenames), NULL));
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
							g_clear_error (&_data_->_inner_error0_);
							g_object_unref (_data_->_async_result);
							return FALSE;
						}
					}
					_data_->_tmp32_ = _data_->_tmp30_;
					_data_->_tmp30_ = NULL;
					_data_->result = _data_->_tmp32_;
					_g_object_unref0 (_data_->_tmp30_);
					_g_free0 (_data_->filename);
					_data_->expected = (_vala_array_free (_data_->expected, _data_->expected_length1, (GDestroyNotify) g_free), NULL);
					(_data_->filenames == NULL) ? NULL : (_data_->filenames = (_g_list_free__g_free0_ (_data_->filenames), NULL));
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
					if (_data_->_state_ != 0) {
						while (!g_task_get_completed (_data_->_async_result)) {
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
						}
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_g_free0 (_data_->filename);
			}
		}
	}
	_data_->_tmp33_ = _data_->filenames;
	_data_->_tmp34_ = _data_->_tmp33_->data;
	_data_->_tmp35_ = g_strdup_printf (_ ("Unrecognized file in storage location: '%s'. Choose an empty folder in" \
"stead."), (const gchar*) _data_->_tmp34_);
	_data_->msg = _data_->_tmp35_;
	_data_->_tmp36_ = _data_->msg;
	_data_->_tmp37_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, _data_->_tmp36_);
	_data_->_inner_error0_ = _data_->_tmp37_;
	if (_data_->_inner_error0_->domain == G_OPTION_ERROR) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->msg);
		_data_->expected = (_vala_array_free (_data_->expected, _data_->expected_length1, (GDestroyNotify) g_free), NULL);
		(_data_->filenames == NULL) ? NULL : (_data_->filenames = (_g_list_free__g_free0_ (_data_->filenames), NULL));
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_g_free0 (_data_->msg);
		_data_->expected = (_vala_array_free (_data_->expected, _data_->expected_length1, (GDestroyNotify) g_free), NULL);
		(_data_->filenames == NULL) ? NULL : (_data_->filenames = (_g_list_free__g_free0_ (_data_->filenames), NULL));
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

