/* ConfigAutoBackupRow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ConfigAutoBackupRow.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "deja.h"
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SWITCH_ROW (switch_row_get_type ())
#define SWITCH_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SWITCH_ROW, SwitchRow))
#define SWITCH_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SWITCH_ROW, SwitchRowClass))
#define IS_SWITCH_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SWITCH_ROW))
#define IS_SWITCH_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SWITCH_ROW))
#define SWITCH_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SWITCH_ROW, SwitchRowClass))

typedef struct _SwitchRow SwitchRow;
typedef struct _SwitchRowClass SwitchRowClass;
typedef struct _SwitchRowPrivate SwitchRowPrivate;

#define TYPE_CONFIG_AUTO_BACKUP_ROW (config_auto_backup_row_get_type ())
#define CONFIG_AUTO_BACKUP_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIG_AUTO_BACKUP_ROW, ConfigAutoBackupRow))
#define CONFIG_AUTO_BACKUP_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIG_AUTO_BACKUP_ROW, ConfigAutoBackupRowClass))
#define IS_CONFIG_AUTO_BACKUP_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIG_AUTO_BACKUP_ROW))
#define IS_CONFIG_AUTO_BACKUP_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIG_AUTO_BACKUP_ROW))
#define CONFIG_AUTO_BACKUP_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIG_AUTO_BACKUP_ROW, ConfigAutoBackupRowClass))

typedef struct _ConfigAutoBackupRow ConfigAutoBackupRow;
typedef struct _ConfigAutoBackupRowClass ConfigAutoBackupRowClass;
typedef struct _ConfigAutoBackupRowPrivate ConfigAutoBackupRowPrivate;
enum  {
	CONFIG_AUTO_BACKUP_ROW_0_PROPERTY,
	CONFIG_AUTO_BACKUP_ROW_NUM_PROPERTIES
};
static GParamSpec* config_auto_backup_row_properties[CONFIG_AUTO_BACKUP_ROW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SwitchRow {
	AdwActionRow parent_instance;
	SwitchRowPrivate * priv;
};

struct _SwitchRowClass {
	AdwActionRowClass parent_class;
};

struct _ConfigAutoBackupRow {
	SwitchRow parent_instance;
	ConfigAutoBackupRowPrivate * priv;
};

struct _ConfigAutoBackupRowClass {
	SwitchRowClass parent_class;
};

struct _ConfigAutoBackupRowPrivate {
	GSettings* settings;
	guint timeout_id;
};

static gint ConfigAutoBackupRow_private_offset;
static gpointer config_auto_backup_row_parent_class = NULL;

VALA_EXTERN GType switch_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwitchRow, g_object_unref)
VALA_EXTERN GType config_auto_backup_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigAutoBackupRow, g_object_unref)
static gboolean config_auto_backup_row_is_same_day (GDateTime* one,
                                             GDateTime* two);
static gchar* config_auto_backup_row_today_message (gboolean periodic);
static gchar* config_auto_backup_row_tomorrow_message (gboolean periodic);
static gchar* config_auto_backup_row_future_message (gint days,
                                              gboolean periodic);
static gchar* config_auto_backup_row_pretty_next_name (GDateTime* date,
                                                gboolean periodic);
VALA_EXTERN gchar* config_auto_backup_row_get_next_backup_desc (void);
static gboolean config_auto_backup_row_update_label_timer (ConfigAutoBackupRow* self);
static void config_auto_backup_row_update_label (ConfigAutoBackupRow* self);
static gboolean config_auto_backup_row_on_state_set (ConfigAutoBackupRow* self,
                                              gboolean state);
VALA_EXTERN void background_request_autostart (GtkWindow* window,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN gboolean background_request_autostart_finish (GAsyncResult* _res_);
static void ___lambda21_ (ConfigAutoBackupRow* self,
                   GObject* obj,
                   GAsyncResult* res);
VALA_EXTERN void switch_row_set_state (SwitchRow* self,
                           gboolean value);
static void config_auto_backup_row_set_periodic (gboolean state);
VALA_EXTERN void switch_row_set_active (SwitchRow* self,
                            gboolean value);
static void ____lambda21__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
VALA_EXTERN ConfigAutoBackupRow* config_auto_backup_row_new (void);
VALA_EXTERN ConfigAutoBackupRow* config_auto_backup_row_construct (GType object_type);
VALA_EXTERN SwitchRow* switch_row_new (void);
VALA_EXTERN SwitchRow* switch_row_construct (GType object_type);
static GObject * config_auto_backup_row_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void _config_auto_backup_row_update_label_g_settings_changed (GSettings* _sender,
                                                              const gchar* key,
                                                              gpointer self);
static gboolean _config_auto_backup_row_on_state_set_switch_row_state_set (SwitchRow* _sender,
                                                                    gboolean state,
                                                                    gpointer self);
static gboolean _config_auto_backup_row_update_label_timer_gsource_func (gpointer self);
static void config_auto_backup_row_finalize (GObject * obj);
static GType config_auto_backup_row_get_type_once (void);

static inline gpointer
config_auto_backup_row_get_instance_private (ConfigAutoBackupRow* self)
{
	return G_STRUCT_MEMBER_P (self, ConfigAutoBackupRow_private_offset);
}

static gboolean
config_auto_backup_row_is_same_day (GDateTime* one,
                                    GDateTime* two)
{
	gint ny = 0;
	gint nm = 0;
	gint nd = 0;
	gint dy = 0;
	gint dm = 0;
	gint dd = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean result;
	g_return_val_if_fail (one != NULL, FALSE);
	g_return_val_if_fail (two != NULL, FALSE);
	g_date_time_get_ymd (one, &_tmp0_, &_tmp1_, &_tmp2_);
	ny = _tmp0_;
	nm = _tmp1_;
	nd = _tmp2_;
	g_date_time_get_ymd (two, &_tmp3_, &_tmp4_, &_tmp5_);
	dy = _tmp3_;
	dm = _tmp4_;
	dd = _tmp5_;
	if (ny == dy) {
		_tmp7_ = nm == dm;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		_tmp6_ = nd == dd;
	} else {
		_tmp6_ = FALSE;
	}
	result = _tmp6_;
	return result;
}

static gchar*
config_auto_backup_row_today_message (gboolean periodic)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* result;
	if (periodic) {
		_tmp0_ = _ ("Next backup is today");
	} else {
		_tmp0_ = _ ("Next backup would be today");
	}
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
config_auto_backup_row_tomorrow_message (gboolean periodic)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* result;
	if (periodic) {
		_tmp0_ = _ ("Next backup is tomorrow");
	} else {
		_tmp0_ = _ ("Next backup would be tomorrow");
	}
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
config_auto_backup_row_future_message (gint days,
                                       gboolean periodic)
{
	gchar* result;
	if (periodic) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup_printf (g_dngettext (GETTEXT_PACKAGE, "Next backup is %d day from now", "Next backup is %d days from now", (gulong) days), days);
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup_printf (g_dngettext (GETTEXT_PACKAGE, "Next backup would be %d day from now", "Next backup would be %d days from now", (gulong) days), days);
		result = _tmp1_;
		return result;
	}
}

static gchar*
config_auto_backup_row_pretty_next_name (GDateTime* date,
                                         gboolean periodic)
{
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp3_;
	gchar* result;
	g_return_val_if_fail (date != NULL, NULL);
	_tmp0_ = deja_dup_now ();
	now = _tmp0_;
	_tmp1_ = now;
	if (g_date_time_compare (_tmp1_, date) > 0) {
		GDateTime* _tmp2_;
		_tmp2_ = now;
		date = _tmp2_;
	}
	_tmp3_ = now;
	if (config_auto_backup_row_is_same_day (date, _tmp3_)) {
		gchar* _tmp4_;
		_tmp4_ = config_auto_backup_row_today_message (periodic);
		result = _tmp4_;
		_g_date_time_unref0 (now);
		return result;
	} else {
		GDateTime* _tmp5_;
		GDateTime* _tmp6_;
		GDateTime* _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = now;
		_tmp6_ = g_date_time_add_days (_tmp5_, 1);
		_tmp7_ = _tmp6_;
		_tmp8_ = config_auto_backup_row_is_same_day (date, _tmp7_);
		_g_date_time_unref0 (_tmp7_);
		if (_tmp8_) {
			gchar* _tmp9_;
			_tmp9_ = config_auto_backup_row_tomorrow_message (periodic);
			result = _tmp9_;
			_g_date_time_unref0 (now);
			return result;
		} else {
			GDateTime* _tmp10_;
			GDateTime* _tmp11_;
			GDateTime* _tmp12_;
			GDateTime* _tmp13_;
			gint diff = 0;
			GDateTime* _tmp14_;
			gchar* _tmp15_;
			_tmp10_ = now;
			_tmp11_ = now;
			_tmp12_ = now;
			_tmp13_ = g_date_time_new_local (g_date_time_get_year (_tmp10_), g_date_time_get_month (_tmp11_), g_date_time_get_day_of_month (_tmp12_), 0, 0, 0.0);
			_g_date_time_unref0 (now);
			now = _tmp13_;
			_tmp14_ = now;
			diff = (gint) (g_date_time_difference (date, _tmp14_) / G_TIME_SPAN_DAY);
			_tmp15_ = config_auto_backup_row_future_message (diff, periodic);
			result = _tmp15_;
			_g_date_time_unref0 (now);
			return result;
		}
	}
}

gchar*
config_auto_backup_row_get_next_backup_desc (void)
{
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_;
	gboolean periodic = FALSE;
	DejaDupFilteredSettings* _tmp1_;
	GDateTime* next = NULL;
	GDateTime* _tmp2_;
	GDateTime* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = settings;
	periodic = g_settings_get_boolean ((GSettings*) _tmp1_, DEJA_DUP_PERIODIC_KEY);
	_tmp2_ = deja_dup_next_possible_run_date ();
	next = _tmp2_;
	if (deja_dup_in_demo_mode ()) {
		GDateTime* _tmp3_;
		GDateTime* _tmp4_;
		GDateTime* _tmp5_;
		_tmp3_ = deja_dup_now ();
		_tmp4_ = _tmp3_;
		_tmp5_ = g_date_time_add (_tmp4_, deja_dup_get_day () * 7);
		_g_date_time_unref0 (next);
		next = _tmp5_;
		_g_date_time_unref0 (_tmp4_);
	}
	_tmp6_ = next;
	_tmp7_ = config_auto_backup_row_pretty_next_name (_tmp6_, periodic);
	result = _tmp7_;
	_g_date_time_unref0 (next);
	_g_object_unref0 (settings);
	return result;
}

static gboolean
config_auto_backup_row_update_label_timer (ConfigAutoBackupRow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	config_auto_backup_row_update_label (self);
	result = G_SOURCE_CONTINUE;
	return result;
}

static void
config_auto_backup_row_update_label (ConfigAutoBackupRow* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = config_auto_backup_row_get_next_backup_desc ();
	_tmp1_ = _tmp0_;
	adw_action_row_set_subtitle ((AdwActionRow*) self, _tmp1_);
	_g_free0 (_tmp1_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
___lambda21_ (ConfigAutoBackupRow* self,
              GObject* obj,
              GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	if (background_request_autostart_finish (res)) {
		switch_row_set_state ((SwitchRow*) self, TRUE);
		config_auto_backup_row_set_periodic (TRUE);
	} else {
		switch_row_set_active ((SwitchRow*) self, FALSE);
	}
}

static void
____lambda21__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda21_ ((ConfigAutoBackupRow*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
config_auto_backup_row_on_state_set (ConfigAutoBackupRow* self,
                                     gboolean state)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (state) {
		GtkWindow* window = NULL;
		GtkRoot* _tmp0_;
		GtkRoot* _tmp1_;
		GtkWindow* _tmp2_;
		GtkWindow* _tmp3_;
		GtkWindow* _tmp4_;
		_tmp0_ = gtk_widget_get_root ((GtkWidget*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp1_) : NULL);
		window = _tmp2_;
		_tmp3_ = window;
		if (_tmp3_ == NULL) {
			result = TRUE;
			_g_object_unref0 (window);
			return result;
		}
		_tmp4_ = window;
		background_request_autostart (_tmp4_, ____lambda21__gasync_ready_callback, g_object_ref (self));
		result = TRUE;
		_g_object_unref0 (window);
		return result;
	}
	config_auto_backup_row_set_periodic (FALSE);
	result = FALSE;
	return result;
}

static void
config_auto_backup_row_set_periodic (gboolean state)
{
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	deja_dup_filtered_settings_set_boolean (settings, DEJA_DUP_PERIODIC_KEY, state);
	_tmp1_ = deja_dup_current_time_as_iso8601 ();
	_tmp2_ = _tmp1_;
	deja_dup_filtered_settings_set_string (settings, DEJA_DUP_PERIODIC_TIMESTAMP_KEY, _tmp2_);
	_g_free0 (_tmp2_);
	_g_object_unref0 (settings);
}

ConfigAutoBackupRow*
config_auto_backup_row_construct (GType object_type)
{
	ConfigAutoBackupRow * self = NULL;
	self = (ConfigAutoBackupRow*) switch_row_construct (object_type);
	return self;
}

ConfigAutoBackupRow*
config_auto_backup_row_new (void)
{
	return config_auto_backup_row_construct (TYPE_CONFIG_AUTO_BACKUP_ROW);
}

static void
_config_auto_backup_row_update_label_g_settings_changed (GSettings* _sender,
                                                         const gchar* key,
                                                         gpointer self)
{
	config_auto_backup_row_update_label ((ConfigAutoBackupRow*) self);
}

static gboolean
_config_auto_backup_row_on_state_set_switch_row_state_set (SwitchRow* _sender,
                                                           gboolean state,
                                                           gpointer self)
{
	gboolean result;
	result = config_auto_backup_row_on_state_set ((ConfigAutoBackupRow*) self, state);
	return result;
}

static gboolean
_config_auto_backup_row_update_label_timer_gsource_func (gpointer self)
{
	gboolean result;
	result = config_auto_backup_row_update_label_timer ((ConfigAutoBackupRow*) self);
	return result;
}

static GObject *
config_auto_backup_row_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ConfigAutoBackupRow * self;
	DejaDupFilteredSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	GSettings* _tmp3_;
	gchar* _tmp4_;
	GSettings* _tmp5_;
	gchar* _tmp6_;
	GSettings* _tmp7_;
	parent_class = G_OBJECT_CLASS (config_auto_backup_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONFIG_AUTO_BACKUP_ROW, ConfigAutoBackupRow);
	_tmp0_ = deja_dup_get_settings (NULL);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = (GSettings*) _tmp0_;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_strconcat ("changed::", DEJA_DUP_PERIODIC_KEY, NULL);
	g_signal_connect_object (_tmp1_, _tmp2_, (GCallback) _config_auto_backup_row_update_label_g_settings_changed, self, 0);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_strconcat ("changed::", DEJA_DUP_PERIODIC_PERIOD_KEY, NULL);
	g_signal_connect_object (_tmp3_, _tmp4_, (GCallback) _config_auto_backup_row_update_label_g_settings_changed, self, 0);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->settings;
	_tmp6_ = g_strconcat ("changed::", DEJA_DUP_LAST_BACKUP_KEY, NULL);
	g_signal_connect_object (_tmp5_, _tmp6_, (GCallback) _config_auto_backup_row_update_label_g_settings_changed, self, 0);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->settings;
	g_settings_bind (_tmp7_, DEJA_DUP_PERIODIC_KEY, (GObject*) self, "active", G_SETTINGS_BIND_GET);
	g_signal_connect_object ((SwitchRow*) self, "state-set", (GCallback) _config_auto_backup_row_on_state_set_switch_row_state_set, self, 0);
	adw_preferences_row_set_title ((AdwPreferencesRow*) self, _ ("Back Up _Automatically"));
	config_auto_backup_row_update_label (self);
	self->priv->timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) (60 * 60), _config_auto_backup_row_update_label_timer_gsource_func, g_object_ref (self), g_object_unref);
	return obj;
}

static void
config_auto_backup_row_class_init (ConfigAutoBackupRowClass * klass,
                                   gpointer klass_data)
{
	config_auto_backup_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ConfigAutoBackupRow_private_offset);
	G_OBJECT_CLASS (klass)->constructor = config_auto_backup_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = config_auto_backup_row_finalize;
}

static void
config_auto_backup_row_instance_init (ConfigAutoBackupRow * self,
                                      gpointer klass)
{
	self->priv = config_auto_backup_row_get_instance_private (self);
}

static void
config_auto_backup_row_finalize (GObject * obj)
{
	ConfigAutoBackupRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONFIG_AUTO_BACKUP_ROW, ConfigAutoBackupRow);
	g_source_remove (self->priv->timeout_id);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (config_auto_backup_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
config_auto_backup_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConfigAutoBackupRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) config_auto_backup_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConfigAutoBackupRow), 0, (GInstanceInitFunc) config_auto_backup_row_instance_init, NULL };
	GType config_auto_backup_row_type_id;
	config_auto_backup_row_type_id = g_type_register_static (TYPE_SWITCH_ROW, "ConfigAutoBackupRow", &g_define_type_info, 0);
	ConfigAutoBackupRow_private_offset = g_type_add_instance_private (config_auto_backup_row_type_id, sizeof (ConfigAutoBackupRowPrivate));
	return config_auto_backup_row_type_id;
}

GType
config_auto_backup_row_get_type (void)
{
	static gsize config_auto_backup_row_type_id__once = 0;
	if (g_once_init_enter (&config_auto_backup_row_type_id__once)) {
		GType config_auto_backup_row_type_id;
		config_auto_backup_row_type_id = config_auto_backup_row_get_type_once ();
		g_once_init_leave (&config_auto_backup_row_type_id__once, config_auto_backup_row_type_id);
	}
	return config_auto_backup_row_type_id__once;
}

