/* Background.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Background.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include <gdk/wayland/gdkwayland.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/x11/gdkx.h>
#include "deja.h"
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BACKGROUND (background_get_type ())
#define BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND, Background))
#define BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND, BackgroundClass))
#define IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND))
#define IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND))
#define BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND, BackgroundClass))

typedef struct _Background Background;
typedef struct _BackgroundClass BackgroundClass;
typedef struct _BackgroundPrivate BackgroundPrivate;
enum  {
	BACKGROUND_0_PROPERTY,
	BACKGROUND_NUM_PROPERTIES
};
static GParamSpec* background_properties[BACKGROUND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _BackgroundExportHandleData BackgroundExportHandleData;
typedef struct _BackgroundRequestAutostartData BackgroundRequestAutostartData;

struct _Background {
	GObject parent_instance;
	BackgroundPrivate * priv;
};

struct _BackgroundClass {
	GObjectClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	gpointer _async_data_;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	gchar* handle;
};

struct _BackgroundExportHandleData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GtkWindow* window;
	gchar* result;
	Block1Data* _data1_;
	GdkSurface* surface;
	GdkSurface* _tmp0_;
	GdkSurface* _tmp1_;
	GdkWaylandToplevel* wayland_surface;
	GdkSurface* _tmp2_;
	GdkWaylandToplevel* _tmp3_;
	GdkWaylandToplevel* _tmp4_;
	Block2Data* _data2_;
	gchar* _tmp5_;
	gboolean success;
	GdkWaylandToplevel* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GdkX11Surface* x11_surface;
	GdkSurface* _tmp9_;
	GdkX11Surface* _tmp10_;
	GdkX11Surface* _tmp11_;
	GdkX11Surface* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
};

struct _BackgroundRequestAutostartData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GtkWindow* window;
	gboolean result;
	gchar* mitigation;
	DejaDupInstallEnv* install_env;
	DejaDupInstallEnv* _tmp0_;
	gchar* handle;
	gchar* _tmp1_;
	gboolean allowed;
	DejaDupInstallEnv* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
};

static gpointer background_parent_class = NULL;

void gdk_wayland_toplevel_drop_exported_handle (GdkWaylandToplevel* toplevel,
                                                const gchar* handle);
VALA_EXTERN GType background_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Background, g_object_unref)
static void background_export_handle_data_free (gpointer _data);
static void background_export_handle (GtkWindow* window,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
static gchar* background_export_handle_finish (GAsyncResult* _res_);
static gboolean background_export_handle_co (BackgroundExportHandleData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ___lambda4_ (Block2Data* _data2_,
                  GdkWaylandToplevel* t,
                  const gchar* h);
static void ____lambda4__gdk_wayland_toplevel_exported (GdkWaylandToplevel* toplevel,
                                                 const gchar* handle,
                                                 gpointer self);
static void background_unexport_handle (GtkWindow* window,
                                 const gchar* handle);
static void background_request_autostart_data_free (gpointer _data);
VALA_EXTERN void background_request_autostart (GtkWindow* window,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN gboolean background_request_autostart_finish (GAsyncResult* _res_);
static gboolean background_request_autostart_co (BackgroundRequestAutostartData* _data_);
static void background_request_autostart_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
VALA_EXTERN void deja_dup_run_error_dialog (GtkWidget* parent,
                                const gchar* header,
                                const gchar* message,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
VALA_EXTERN void deja_dup_run_error_dialog_finish (GAsyncResult* _res_);
VALA_EXTERN Background* background_new (void);
VALA_EXTERN Background* background_construct (GType object_type);
static GType background_get_type_once (void);

/**
 * There are several supported installations, which affect autostarting:
 *
 * Traditional distro package.
 * - We ship an /etc/xdg/autostart file.
 * - After 30 days, we use that autostart to prompt the user to consider backing up.
 * - May or may not support the Background portal, but we don't need or use it.
 *
 * Snap package.
 * - On first start, we make an autostart file in the expected snap user data folder.
 * - No prompt support as a result.
 * - Does not support the Background portal, but we don't need or use it.
 *
 * Flatpak package.
 * - Uses the Background portal when the user enables automatic backups.
 * - Since we can't query permission status, we just ask the portal each time and don't notice revocations.
 */
static void
background_export_handle_data_free (gpointer _data)
{
	BackgroundExportHandleData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->window);
	_g_free0 (_data_->result);
	g_slice_free (BackgroundExportHandleData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
background_export_handle (GtkWindow* window,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	BackgroundExportHandleData* _data_;
	GtkWindow* _tmp0_;
	g_return_if_fail (window != NULL);
	_data_ = g_slice_new0 (BackgroundExportHandleData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, background_export_handle_data_free);
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (_data_->window);
	_data_->window = _tmp0_;
	background_export_handle_co (_data_);
}

static gchar*
background_export_handle_finish (GAsyncResult* _res_)
{
	gchar* result;
	BackgroundExportHandleData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		g_slice_free (Block1Data, _data1_);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_free0 (_data2_->handle);
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}

static void
___lambda4_ (Block2Data* _data2_,
             GdkWaylandToplevel* t,
             const gchar* h)
{
	Block1Data* _data1_;
	gchar* _tmp0_;
	_data1_ = _data2_->_data1_;
	g_return_if_fail (t != NULL);
	g_return_if_fail (h != NULL);
	_tmp0_ = g_strdup (h);
	_g_free0 (_data2_->handle);
	_data2_->handle = _tmp0_;
	background_export_handle_co (_data1_->_async_data_);
}

static void
____lambda4__gdk_wayland_toplevel_exported (GdkWaylandToplevel* toplevel,
                                            const gchar* handle,
                                            gpointer self)
{
	___lambda4_ (self, toplevel, handle);
}

static gboolean
background_export_handle_co (BackgroundExportHandleData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp0_ = gtk_native_get_surface ((GtkNative*) _data_->window);
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
	_data_->surface = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->surface;
	_data_->_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp2_, gdk_wayland_toplevel_get_type ()) ? ((GdkWaylandToplevel*) _data_->_tmp2_) : NULL);
	_data_->wayland_surface = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->wayland_surface;
	if (_data_->_tmp4_ != NULL) {
		_data_->_data2_ = g_slice_new0 (Block2Data);
		_data_->_data2_->_ref_count_ = 1;
		_data_->_data2_->_data1_ = block1_data_ref (_data_->_data1_);
		_data_->_tmp5_ = g_strdup ("");
		_data_->_data2_->handle = _data_->_tmp5_;
		_data_->_tmp6_ = _data_->wayland_surface;
		_data_->success = gdk_wayland_toplevel_export_handle (_data_->_tmp6_, ____lambda4__gdk_wayland_toplevel_exported, block2_data_ref (_data_->_data2_), block2_data_unref);
		if (_data_->success) {
			_data_->_state_ = 1;
			return FALSE;
			_state_1:
			;
			_data_->_tmp7_ = _data_->_data2_->handle;
			_data_->_tmp8_ = g_strdup_printf ("wayland:%s", _data_->_tmp7_);
			_data_->result = _data_->_tmp8_;
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			_g_object_unref0 (_data_->wayland_surface);
			_g_object_unref0 (_data_->surface);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
	}
	_data_->_tmp9_ = _data_->surface;
	_data_->_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp9_, gdk_x11_surface_get_type ()) ? ((GdkX11Surface*) _data_->_tmp9_) : NULL);
	_data_->x11_surface = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->x11_surface;
	if (_data_->_tmp11_ != NULL) {
		_data_->_tmp12_ = _data_->x11_surface;
		_data_->_tmp13_ = g_strdup_printf ("x11:%x", (guint) gdk_x11_surface_get_xid (_data_->_tmp12_));
		_data_->result = _data_->_tmp13_;
		_g_object_unref0 (_data_->x11_surface);
		_g_object_unref0 (_data_->wayland_surface);
		_g_object_unref0 (_data_->surface);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = g_strdup ("");
	_data_->result = _data_->_tmp14_;
	_g_object_unref0 (_data_->x11_surface);
	_g_object_unref0 (_data_->wayland_surface);
	_g_object_unref0 (_data_->surface);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
background_unexport_handle (GtkWindow* window,
                            const gchar* handle)
{
	GdkSurface* surface = NULL;
	GdkSurface* _tmp0_;
	GdkSurface* _tmp1_;
	GdkWaylandToplevel* wayland_surface = NULL;
	GdkSurface* _tmp2_;
	GdkWaylandToplevel* _tmp3_;
	GdkWaylandToplevel* _tmp4_;
	g_return_if_fail (window != NULL);
	g_return_if_fail (handle != NULL);
	_tmp0_ = gtk_native_get_surface ((GtkNative*) window);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	surface = _tmp1_;
	_tmp2_ = surface;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gdk_wayland_toplevel_get_type ()) ? ((GdkWaylandToplevel*) _tmp2_) : NULL);
	wayland_surface = _tmp3_;
	_tmp4_ = wayland_surface;
	if (_tmp4_ != NULL) {
		GdkWaylandToplevel* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = wayland_surface;
		_tmp6_ = strlen ("wayland:");
		_tmp7_ = _tmp6_;
		_tmp8_ = string_substring (handle, (glong) _tmp7_, (glong) -1);
		_tmp9_ = _tmp8_;
		gdk_wayland_toplevel_drop_exported_handle (_tmp5_, _tmp9_);
		_g_free0 (_tmp9_);
	}
	_g_object_unref0 (wayland_surface);
	_g_object_unref0 (surface);
}

static void
background_request_autostart_data_free (gpointer _data)
{
	BackgroundRequestAutostartData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->window);
	g_slice_free (BackgroundRequestAutostartData, _data_);
}

void
background_request_autostart (GtkWindow* window,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	BackgroundRequestAutostartData* _data_;
	GtkWindow* _tmp0_;
	g_return_if_fail (window != NULL);
	_data_ = g_slice_new0 (BackgroundRequestAutostartData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, background_request_autostart_data_free);
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (_data_->window);
	_data_->window = _tmp0_;
	background_request_autostart_co (_data_);
}

gboolean
background_request_autostart_finish (GAsyncResult* _res_)
{
	gboolean result;
	BackgroundRequestAutostartData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
background_request_autostart_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	BackgroundRequestAutostartData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	background_request_autostart_co (_data_);
}

static gboolean
background_request_autostart_co (BackgroundRequestAutostartData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = deja_dup_install_env_instance ();
	_data_->install_env = _data_->_tmp0_;
	_data_->_state_ = 1;
	background_export_handle (_data_->window, background_request_autostart_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = background_export_handle_finish (_data_->_res_);
	_data_->handle = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->install_env;
	_data_->_tmp3_ = _data_->handle;
	_data_->_tmp4_ = NULL;
	_data_->_state_ = 2;
	deja_dup_install_env_request_autostart (_data_->_tmp2_, _data_->_tmp3_, background_request_autostart_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp5_ = deja_dup_install_env_request_autostart_finish (_data_->_tmp2_, _data_->_res_, &_data_->_tmp4_);
	_g_free0 (_data_->mitigation);
	_data_->mitigation = _data_->_tmp4_;
	_data_->allowed = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->handle;
	background_unexport_handle (_data_->window, _data_->_tmp6_);
	if (!_data_->allowed) {
		_data_->_tmp8_ = _data_->mitigation;
		_data_->_tmp7_ = _data_->_tmp8_ != NULL;
	} else {
		_data_->_tmp7_ = FALSE;
	}
	if (_data_->_tmp7_) {
		_data_->_tmp9_ = _data_->mitigation;
		_data_->_state_ = 3;
		deja_dup_run_error_dialog ((GtkWidget*) _data_->window, _ ("Cannot back up automatically"), _data_->_tmp9_, background_request_autostart_ready, _data_);
		return FALSE;
		_state_3:
		deja_dup_run_error_dialog_finish (_data_->_res_);
	}
	_data_->result = _data_->allowed;
	_g_free0 (_data_->handle);
	_g_object_unref0 (_data_->install_env);
	_g_free0 (_data_->mitigation);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

Background*
background_construct (GType object_type)
{
	Background * self = NULL;
	self = (Background*) g_object_new (object_type, NULL);
	return self;
}

Background*
background_new (void)
{
	return background_construct (TYPE_BACKGROUND);
}

static void
background_class_init (BackgroundClass * klass,
                       gpointer klass_data)
{
	background_parent_class = g_type_class_peek_parent (klass);
}

static void
background_instance_init (Background * self,
                          gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
background_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BackgroundClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) background_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Background), 0, (GInstanceInitFunc) background_instance_init, NULL };
	GType background_type_id;
	background_type_id = g_type_register_static (G_TYPE_OBJECT, "Background", &g_define_type_info, 0);
	return background_type_id;
}

GType
background_get_type (void)
{
	static gsize background_type_id__once = 0;
	if (g_once_init_enter (&background_type_id__once)) {
		GType background_type_id;
		background_type_id = background_get_type_once ();
		g_once_init_leave (&background_type_id__once, background_type_id);
	}
	return background_type_id__once;
}

