/* base-headerbar.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from base-headerbar.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#define BASE_HEADER_BAR_default_mode_id ((guint8) 0)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_BASE_HEADER_BAR (base_header_bar_get_type ())
#define BASE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_HEADER_BAR, BaseHeaderBar))
#define BASE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_HEADER_BAR, BaseHeaderBarClass))
#define IS_BASE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_HEADER_BAR))
#define IS_BASE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_HEADER_BAR))
#define BASE_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_HEADER_BAR, BaseHeaderBarClass))

typedef struct _BaseHeaderBar BaseHeaderBar;
typedef struct _BaseHeaderBarClass BaseHeaderBarClass;
typedef struct _BaseHeaderBarPrivate BaseHeaderBarPrivate;
enum  {
	BASE_HEADER_BAR_0_PROPERTY,
	BASE_HEADER_BAR_ABOUT_ACTION_LABEL_PROPERTY,
	BASE_HEADER_BAR_HAS_HELP_PROPERTY,
	BASE_HEADER_BAR_HAS_KEYBOARD_SHORTCUTS_PROPERTY,
	BASE_HEADER_BAR_NO_IN_WINDOW_MODE_PROPERTY,
	BASE_HEADER_BAR_NUM_PROPERTIES
};
static GParamSpec* base_header_bar_properties[BASE_HEADER_BAR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	BASE_HEADER_BAR_CHANGE_MODE_SIGNAL,
	BASE_HEADER_BAR_NUM_SIGNALS
};
static guint base_header_bar_signals[BASE_HEADER_BAR_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _BaseHeaderBar {
	GtkHeaderBar parent_instance;
	BaseHeaderBarPrivate * priv;
	GtkBox* center_box;
	gboolean disable_popovers;
	gboolean disable_action_bar;
};

struct _BaseHeaderBarClass {
	GtkHeaderBarClass parent_class;
	void (*set_window_size) (BaseHeaderBar* self, AdaptativeWidgetWindowSize new_size);
	void (*populate_menu) (BaseHeaderBar* self, GMenu** menu);
	void (*toggle_view_menu) (BaseHeaderBar* self);
	void (*set_default_widgets_default_states) (BaseHeaderBar* self, BaseHeaderBar* _this);
	void (*close_popovers) (BaseHeaderBar* self);
	gboolean (*has_popover) (BaseHeaderBar* self);
};

struct _BaseHeaderBarPrivate {
	gboolean has_a_phone_size;
	gchar* _about_action_label;
	gboolean _has_help;
	gboolean _has_keyboard_shortcuts;
	guint8 last_mode_id;
	guint8 current_mode_id;
	GtkStack* quit_button_stack;
	GtkButton* go_back_button;
	GtkSeparator* ltr_left_separator;
	GtkLabel* title_label;
	GtkMenuButton* info_button;
	GtkSeparator* ltr_right_separator;
	gboolean default_mode_on;
	guint8 about_mode_id;
	gboolean about_mode_on;
};

static gint BaseHeaderBar_private_offset;
static gpointer base_header_bar_parent_class = NULL;
static AdaptativeWidgetIface * base_header_bar_adaptative_widget_parent_iface = NULL;

VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType base_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseHeaderBar, g_object_unref)
VALA_EXTERN void base_header_bar_set_window_size (BaseHeaderBar* self,
                                      AdaptativeWidgetWindowSize new_size);
VALA_EXTERN void base_header_bar_populate_menu (BaseHeaderBar* self,
                                    GMenu** menu);
VALA_EXTERN void base_header_bar_toggle_view_menu (BaseHeaderBar* self);
VALA_EXTERN void base_header_bar_set_default_widgets_default_states (BaseHeaderBar* self,
                                                         BaseHeaderBar* _this);
VALA_EXTERN void base_header_bar_close_popovers (BaseHeaderBar* self);
VALA_EXTERN gboolean base_header_bar_has_popover (BaseHeaderBar* self);
static void base_header_bar_real_set_window_size (BaseHeaderBar* self,
                                           AdaptativeWidgetWindowSize new_size);
VALA_EXTERN gboolean adaptative_widget_window_size_is_phone_size (AdaptativeWidgetWindowSize window_size);
VALA_EXTERN gboolean adaptative_widget_window_size_is_extra_thin (AdaptativeWidgetWindowSize window_size);
VALA_EXTERN gboolean adaptative_widget_window_size_is_extra_flat (AdaptativeWidgetWindowSize window_size);
VALA_EXTERN void base_header_bar_update_hamburger_menu (BaseHeaderBar* self);
static void base_header_bar_append_app_actions_section (BaseHeaderBar* self,
                                                 GMenu** menu);
static void base_header_bar_real_populate_menu (BaseHeaderBar* self,
                                         GMenu** menu);
static inline void base_header_bar_append_or_not_keyboard_shortcuts_entry (gboolean has_keyboard_shortcuts,
                                                             gboolean show_keyboard_shortcuts,
                                                             GMenu** section);
static gboolean base_header_bar_get_has_keyboard_shortcuts (BaseHeaderBar* self);
static inline void base_header_bar_append_or_not_help_entry (gboolean has_help,
                                               GMenu** section);
static gboolean base_header_bar_get_has_help (BaseHeaderBar* self);
static inline void base_header_bar_append_about_entry (const gchar* about_action_label,
                                         GMenu** section);
VALA_EXTERN const gchar* base_header_bar_get_about_action_label (BaseHeaderBar* self);
VALA_EXTERN void base_header_bar_hide_hamburger_menu (BaseHeaderBar* self);
VALA_EXTERN void base_header_bar_toggle_hamburger_menu (BaseHeaderBar* self);
static void base_header_bar_real_toggle_view_menu (BaseHeaderBar* self);
VALA_EXTERN guint8 base_header_bar_register_new_mode (BaseHeaderBar* self);
VALA_EXTERN gboolean base_header_bar_is_not_requested_mode (guint8 mode_id,
                                                guint8 requested_mode_id,
                                                gboolean* mode_is_active);
static void base_header_bar_register_modes (BaseHeaderBar* self);
static void base_header_bar_register_default_mode (BaseHeaderBar* self);
static void base_header_bar_register_about_mode (BaseHeaderBar* self);
static void base_header_bar_update_current_mode_id (BaseHeaderBar* _this,
                                             guint8 requested_mode_id);
static void _base_header_bar_update_current_mode_id_base_header_bar_change_mode (BaseHeaderBar* _sender,
                                                                          guint8 mode_id,
                                                                          gpointer self);
VALA_EXTERN void base_header_bar_add_named_widget_to_quit_button_stack (BaseHeaderBar* self,
                                                            GtkWidget* widget,
                                                            const gchar* name);
VALA_EXTERN void base_header_bar_set_quit_button_stack_child (BaseHeaderBar* self,
                                                  const gchar* name);
VALA_EXTERN void base_header_bar_set_quit_button_stack_visibility (BaseHeaderBar* self,
                                                       gboolean visible);
VALA_EXTERN void base_header_bar_set_default_widgets_states (BaseHeaderBar* self,
                                                 const gchar* title_label_text_or_null,
                                                 gboolean show_go_back_button,
                                                 gboolean show_ltr_left_separator,
                                                 gboolean show_info_button,
                                                 gboolean show_ltr_right_separator,
                                                 gboolean show_quit_button_stack);
VALA_EXTERN void base_header_bar_show_default_view (BaseHeaderBar* self);
static void base_header_bar_mode_changed_default (BaseHeaderBar* _this,
                                           guint8 requested_mode_id);
static void _base_header_bar_mode_changed_default_base_header_bar_change_mode (BaseHeaderBar* _sender,
                                                                        guint8 mode_id,
                                                                        gpointer self);
static void base_header_bar_real_set_default_widgets_default_states (BaseHeaderBar* self,
                                                              BaseHeaderBar* _this);
VALA_EXTERN void base_header_bar_show_about_view (BaseHeaderBar* self);
static void base_header_bar_mode_changed_about (BaseHeaderBar* _this,
                                         guint8 requested_mode_id);
static void _base_header_bar_mode_changed_about_base_header_bar_change_mode (BaseHeaderBar* _sender,
                                                                      guint8 mode_id,
                                                                      gpointer self);
static void base_header_bar_real_close_popovers (BaseHeaderBar* self);
static gboolean base_header_bar_real_has_popover (BaseHeaderBar* self);
VALA_EXTERN BaseHeaderBar* base_header_bar_new (void);
VALA_EXTERN BaseHeaderBar* base_header_bar_construct (GType object_type);
static void base_header_bar_set_about_action_label (BaseHeaderBar* self,
                                             const gchar* value);
static void base_header_bar_set_has_help (BaseHeaderBar* self,
                                   gboolean value);
static void base_header_bar_set_has_keyboard_shortcuts (BaseHeaderBar* self,
                                                 gboolean value);
VALA_EXTERN gboolean base_header_bar_get_no_in_window_mode (BaseHeaderBar* self);
static GObject * base_header_bar_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
VALA_EXTERN void adaptative_widget_set_window_size (AdaptativeWidget* self,
                                        AdaptativeWidgetWindowSize new_size);
static void base_header_bar_finalize (GObject * obj);
static GType base_header_bar_get_type_once (void);
static void _vala_base_header_bar_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_base_header_bar_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
base_header_bar_get_instance_private (BaseHeaderBar* self)
{
	return G_STRUCT_MEMBER_P (self, BaseHeaderBar_private_offset);
}

static void
base_header_bar_real_set_window_size (BaseHeaderBar* self,
                                      AdaptativeWidgetWindowSize new_size)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _disable_action_bar = FALSE;
	self->priv->has_a_phone_size = adaptative_widget_window_size_is_phone_size (new_size);
	if (self->priv->has_a_phone_size) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = adaptative_widget_window_size_is_extra_thin (new_size);
	}
	self->disable_popovers = _tmp0_;
	if (self->disable_popovers) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = adaptative_widget_window_size_is_extra_flat (new_size);
	}
	_disable_action_bar = _tmp1_;
	if (self->disable_action_bar != _disable_action_bar) {
		self->disable_action_bar = _disable_action_bar;
		if (self->disable_action_bar) {
			GtkStack* _tmp2_;
			GtkSeparator* _tmp3_;
			gtk_header_bar_set_show_close_button ((GtkHeaderBar*) self, FALSE);
			_tmp2_ = self->priv->quit_button_stack;
			gtk_widget_show ((GtkWidget*) _tmp2_);
			_tmp3_ = self->priv->ltr_right_separator;
			gtk_widget_set_visible ((GtkWidget*) _tmp3_, self->priv->current_mode_id == BASE_HEADER_BAR_default_mode_id);
		} else {
			GtkSeparator* _tmp4_;
			GtkStack* _tmp5_;
			_tmp4_ = self->priv->ltr_right_separator;
			gtk_widget_hide ((GtkWidget*) _tmp4_);
			_tmp5_ = self->priv->quit_button_stack;
			gtk_widget_hide ((GtkWidget*) _tmp5_);
			gtk_header_bar_set_show_close_button ((GtkHeaderBar*) self, TRUE);
		}
	}
	base_header_bar_update_hamburger_menu (self);
}

void
base_header_bar_set_window_size (BaseHeaderBar* self,
                                 AdaptativeWidgetWindowSize new_size)
{
	BaseHeaderBarClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BASE_HEADER_BAR_GET_CLASS (self);
	if (_klass_->set_window_size) {
		_klass_->set_window_size (self, new_size);
	}
}

void
base_header_bar_update_hamburger_menu (BaseHeaderBar* self)
{
	GMenu* menu = NULL;
	GMenu* _tmp0_;
	GMenu* _tmp1_;
	GtkMenuButton* _tmp2_;
	GMenu* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_menu_new ();
	menu = _tmp0_;
	base_header_bar_populate_menu (self, &menu);
	base_header_bar_append_app_actions_section (self, &menu);
	_tmp1_ = menu;
	g_menu_freeze (_tmp1_);
	_tmp2_ = self->priv->info_button;
	_tmp3_ = menu;
	gtk_menu_button_set_menu_model (_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_menu_model_get_type (), GMenuModel));
	_g_object_unref0 (menu);
}

static void
base_header_bar_real_populate_menu (BaseHeaderBar* self,
                                    GMenu** menu)
{
	g_return_if_fail (*menu != NULL);
}

void
base_header_bar_populate_menu (BaseHeaderBar* self,
                               GMenu** menu)
{
	BaseHeaderBarClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BASE_HEADER_BAR_GET_CLASS (self);
	if (_klass_->populate_menu) {
		_klass_->populate_menu (self, menu);
	}
}

static void
base_header_bar_append_app_actions_section (BaseHeaderBar* self,
                                            GMenu** menu)
{
	GMenu* section = NULL;
	GMenu* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	GMenu* _tmp4_;
	GMenu* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*menu != NULL);
	_tmp0_ = g_menu_new ();
	section = _tmp0_;
	_tmp1_ = self->priv->_has_keyboard_shortcuts;
	base_header_bar_append_or_not_keyboard_shortcuts_entry (_tmp1_, !self->priv->has_a_phone_size, &section);
	_tmp2_ = self->priv->_has_help;
	base_header_bar_append_or_not_help_entry (_tmp2_, &section);
	_tmp3_ = self->priv->_about_action_label;
	base_header_bar_append_about_entry (_tmp3_, &section);
	_tmp4_ = section;
	g_menu_freeze (_tmp4_);
	_tmp5_ = section;
	g_menu_append_section (*menu, NULL, (GMenuModel*) _tmp5_);
	_g_object_unref0 (section);
}

static inline void
base_header_bar_append_or_not_keyboard_shortcuts_entry (gboolean has_keyboard_shortcuts,
                                                        gboolean show_keyboard_shortcuts,
                                                        GMenu** section)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (*section != NULL);
	if (!has_keyboard_shortcuts) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !show_keyboard_shortcuts;
	}
	if (_tmp0_) {
		return;
	}
	g_menu_append (*section, _ ("Keyboard Shortcuts"), "win.show-help-overlay");
}

static inline void
base_header_bar_append_or_not_help_entry (gboolean has_help,
                                          GMenu** section)
{
	g_return_if_fail (*section != NULL);
	if (!has_help) {
		return;
	}
}

static inline void
base_header_bar_append_about_entry (const gchar* about_action_label,
                                    GMenu** section)
{
	g_return_if_fail (about_action_label != NULL);
	g_return_if_fail (*section != NULL);
	g_menu_append (*section, about_action_label, "base.about");
}

inline void
base_header_bar_hide_hamburger_menu (BaseHeaderBar* self)
{
	GtkMenuButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->info_button;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkMenuButton* _tmp3_;
		_tmp3_ = self->priv->info_button;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp3_, FALSE);
	}
}

void
base_header_bar_toggle_hamburger_menu (BaseHeaderBar* self)
{
	GtkMenuButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->info_button;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkMenuButton* _tmp3_;
		GtkMenuButton* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp3_ = self->priv->info_button;
		_tmp4_ = self->priv->info_button;
		_tmp5_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp4_);
		_tmp6_ = _tmp5_;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp3_, !_tmp6_);
	} else {
		base_header_bar_toggle_view_menu (self);
	}
}

static void
base_header_bar_real_toggle_view_menu (BaseHeaderBar* self)
{
}

void
base_header_bar_toggle_view_menu (BaseHeaderBar* self)
{
	BaseHeaderBarClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BASE_HEADER_BAR_GET_CLASS (self);
	if (_klass_->toggle_view_menu) {
		_klass_->toggle_view_menu (self);
	}
}

guint8
base_header_bar_register_new_mode (BaseHeaderBar* self)
{
	guint8 _tmp0_;
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	self->priv->last_mode_id = self->priv->last_mode_id + 1;
	_tmp0_ = self->priv->last_mode_id;
	result = _tmp0_;
	return result;
}

gboolean
base_header_bar_is_not_requested_mode (guint8 mode_id,
                                       guint8 requested_mode_id,
                                       gboolean* mode_is_active)
{
	gboolean result;
	if (mode_id == requested_mode_id) {
		if (*mode_is_active) {
			g_assert_not_reached ();
		}
		*mode_is_active = TRUE;
		result = FALSE;
		return result;
	} else {
		*mode_is_active = FALSE;
		result = TRUE;
		return result;
	}
}

static void
_base_header_bar_update_current_mode_id_base_header_bar_change_mode (BaseHeaderBar* _sender,
                                                                     guint8 mode_id,
                                                                     gpointer self)
{
	base_header_bar_update_current_mode_id (_sender, mode_id);
}

static void
base_header_bar_register_modes (BaseHeaderBar* self)
{
	g_return_if_fail (self != NULL);
	base_header_bar_register_default_mode (self);
	base_header_bar_register_about_mode (self);
	g_signal_connect (self, "change-mode", (GCallback) _base_header_bar_update_current_mode_id_base_header_bar_change_mode, NULL);
}

static void
base_header_bar_update_current_mode_id (BaseHeaderBar* _this,
                                        guint8 requested_mode_id)
{
	g_return_if_fail (_this != NULL);
	_this->priv->current_mode_id = requested_mode_id;
}

void
base_header_bar_add_named_widget_to_quit_button_stack (BaseHeaderBar* self,
                                                       GtkWidget* widget,
                                                       const gchar* name)
{
	GtkStack* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->quit_button_stack;
	gtk_stack_add_named (_tmp0_, widget, name);
}

void
base_header_bar_set_quit_button_stack_child (BaseHeaderBar* self,
                                             const gchar* name)
{
	GtkStack* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->quit_button_stack;
	gtk_stack_set_visible_child_name (_tmp0_, name);
}

void
base_header_bar_set_quit_button_stack_visibility (BaseHeaderBar* self,
                                                  gboolean visible)
{
	g_return_if_fail (self != NULL);
	if (visible) {
		GtkStack* _tmp0_;
		_tmp0_ = self->priv->quit_button_stack;
		gtk_widget_show ((GtkWidget*) _tmp0_);
	} else {
		GtkStack* _tmp1_;
		_tmp1_ = self->priv->quit_button_stack;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	}
}

void
base_header_bar_set_default_widgets_states (BaseHeaderBar* self,
                                            const gchar* title_label_text_or_null,
                                            gboolean show_go_back_button,
                                            gboolean show_ltr_left_separator,
                                            gboolean show_info_button,
                                            gboolean show_ltr_right_separator,
                                            gboolean show_quit_button_stack)
{
	GtkButton* _tmp0_;
	GtkSeparator* _tmp1_;
	GtkMenuButton* _tmp6_;
	GtkSeparator* _tmp7_;
	GtkStack* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->go_back_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, show_go_back_button);
	_tmp1_ = self->priv->ltr_left_separator;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, show_ltr_left_separator);
	if (title_label_text_or_null == NULL) {
		GtkLabel* _tmp2_;
		GtkLabel* _tmp3_;
		_tmp2_ = self->priv->title_label;
		gtk_label_set_label (_tmp2_, "");
		_tmp3_ = self->priv->title_label;
		gtk_widget_hide ((GtkWidget*) _tmp3_);
	} else {
		GtkLabel* _tmp4_;
		GtkLabel* _tmp5_;
		_tmp4_ = self->priv->title_label;
		gtk_label_set_label (_tmp4_, (const gchar*) title_label_text_or_null);
		_tmp5_ = self->priv->title_label;
		gtk_widget_show ((GtkWidget*) _tmp5_);
	}
	_tmp6_ = self->priv->info_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, show_info_button);
	_tmp7_ = self->priv->ltr_right_separator;
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, show_ltr_right_separator);
	_tmp8_ = self->priv->quit_button_stack;
	gtk_widget_set_visible ((GtkWidget*) _tmp8_, show_quit_button_stack);
}

void
base_header_bar_show_default_view (BaseHeaderBar* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, base_header_bar_signals[BASE_HEADER_BAR_CHANGE_MODE_SIGNAL], 0, BASE_HEADER_BAR_default_mode_id);
}

static void
_base_header_bar_mode_changed_default_base_header_bar_change_mode (BaseHeaderBar* _sender,
                                                                   guint8 mode_id,
                                                                   gpointer self)
{
	base_header_bar_mode_changed_default (_sender, mode_id);
}

static void
base_header_bar_register_default_mode (BaseHeaderBar* self)
{
	g_return_if_fail (self != NULL);
	g_signal_connect (self, "change-mode", (GCallback) _base_header_bar_mode_changed_default_base_header_bar_change_mode, NULL);
}

static void
base_header_bar_mode_changed_default (BaseHeaderBar* _this,
                                      guint8 requested_mode_id)
{
	gboolean _tmp0_;
	g_return_if_fail (_this != NULL);
	_tmp0_ = base_header_bar_is_not_requested_mode (BASE_HEADER_BAR_default_mode_id, requested_mode_id, &_this->priv->default_mode_on);
	if (_tmp0_) {
		return;
	}
	base_header_bar_set_default_widgets_default_states (_this, _this);
}

static void
base_header_bar_real_set_default_widgets_default_states (BaseHeaderBar* self,
                                                         BaseHeaderBar* _this)
{
	g_return_if_fail (_this != NULL);
	base_header_bar_set_default_widgets_states (_this, NULL, FALSE, FALSE, TRUE, _this->disable_action_bar, _this->disable_action_bar);
}

void
base_header_bar_set_default_widgets_default_states (BaseHeaderBar* self,
                                                    BaseHeaderBar* _this)
{
	BaseHeaderBarClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BASE_HEADER_BAR_GET_CLASS (self);
	if (_klass_->set_default_widgets_default_states) {
		_klass_->set_default_widgets_default_states (self, _this);
	}
}

void
base_header_bar_show_about_view (BaseHeaderBar* self)
{
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (((gint) self->priv->about_mode_id) > 0, "about_mode_id > 0");
	g_signal_emit (self, base_header_bar_signals[BASE_HEADER_BAR_CHANGE_MODE_SIGNAL], 0, self->priv->about_mode_id);
}

static void
_base_header_bar_mode_changed_about_base_header_bar_change_mode (BaseHeaderBar* _sender,
                                                                 guint8 mode_id,
                                                                 gpointer self)
{
	base_header_bar_mode_changed_about (_sender, mode_id);
}

static void
base_header_bar_register_about_mode (BaseHeaderBar* self)
{
	g_return_if_fail (self != NULL);
	self->priv->about_mode_id = base_header_bar_register_new_mode (self);
	g_signal_connect (self, "change-mode", (GCallback) _base_header_bar_mode_changed_about_base_header_bar_change_mode, NULL);
}

static void
base_header_bar_mode_changed_about (BaseHeaderBar* _this,
                                    guint8 requested_mode_id)
{
	gboolean _tmp0_;
	g_return_if_fail (_this != NULL);
	_vala_return_if_fail (((gint) _this->priv->about_mode_id) > 0, "_this.about_mode_id > 0");
	_tmp0_ = base_header_bar_is_not_requested_mode (_this->priv->about_mode_id, requested_mode_id, &_this->priv->about_mode_on);
	if (_tmp0_) {
		return;
	}
	base_header_bar_set_default_widgets_states (_this, _ ("About"), TRUE, FALSE, FALSE, FALSE, TRUE);
}

static void
base_header_bar_real_close_popovers (BaseHeaderBar* self)
{
	base_header_bar_hide_hamburger_menu (self);
}

void
base_header_bar_close_popovers (BaseHeaderBar* self)
{
	BaseHeaderBarClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BASE_HEADER_BAR_GET_CLASS (self);
	if (_klass_->close_popovers) {
		_klass_->close_popovers (self);
	}
}

static gboolean
base_header_bar_real_has_popover (BaseHeaderBar* self)
{
	GtkMenuButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	_tmp0_ = self->priv->info_button;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gboolean
base_header_bar_has_popover (BaseHeaderBar* self)
{
	BaseHeaderBarClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BASE_HEADER_BAR_GET_CLASS (self);
	if (_klass_->has_popover) {
		return _klass_->has_popover (self);
	}
	return FALSE;
}

BaseHeaderBar*
base_header_bar_construct (GType object_type)
{
	BaseHeaderBar * self = NULL;
	self = (BaseHeaderBar*) g_object_new (object_type, NULL);
	return self;
}

BaseHeaderBar*
base_header_bar_new (void)
{
	return base_header_bar_construct (TYPE_BASE_HEADER_BAR);
}

const gchar*
base_header_bar_get_about_action_label (BaseHeaderBar* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_about_action_label;
	result = _tmp0_;
	return result;
}

static void
base_header_bar_set_about_action_label (BaseHeaderBar* self,
                                        const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_about_action_label);
	self->priv->_about_action_label = _tmp0_;
}

static gboolean
base_header_bar_get_has_help (BaseHeaderBar* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_help;
	return result;
}

static void
base_header_bar_set_has_help (BaseHeaderBar* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_help = value;
}

static gboolean
base_header_bar_get_has_keyboard_shortcuts (BaseHeaderBar* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_keyboard_shortcuts;
	return result;
}

static void
base_header_bar_set_has_keyboard_shortcuts (BaseHeaderBar* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_keyboard_shortcuts = value;
}

gboolean
base_header_bar_get_no_in_window_mode (BaseHeaderBar* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->default_mode_on;
	return result;
}

static GObject *
base_header_bar_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BaseHeaderBar * self;
	GtkBox* _tmp0_;
	parent_class = G_OBJECT_CLASS (base_header_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BASE_HEADER_BAR, BaseHeaderBar);
	_tmp0_ = self->center_box;
	gtk_widget_set_valign ((GtkWidget*) _tmp0_, GTK_ALIGN_FILL);
	base_header_bar_register_modes (self);
	return obj;
}

static void
base_header_bar_class_init (BaseHeaderBarClass * klass,
                            gpointer klass_data)
{
	base_header_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BaseHeaderBar_private_offset);
	((BaseHeaderBarClass *) klass)->set_window_size = (void (*) (BaseHeaderBar*, AdaptativeWidgetWindowSize)) base_header_bar_real_set_window_size;
	((BaseHeaderBarClass *) klass)->populate_menu = (void (*) (BaseHeaderBar*, GMenu**)) base_header_bar_real_populate_menu;
	((BaseHeaderBarClass *) klass)->toggle_view_menu = (void (*) (BaseHeaderBar*)) base_header_bar_real_toggle_view_menu;
	((BaseHeaderBarClass *) klass)->set_default_widgets_default_states = (void (*) (BaseHeaderBar*, BaseHeaderBar*)) base_header_bar_real_set_default_widgets_default_states;
	((BaseHeaderBarClass *) klass)->close_popovers = (void (*) (BaseHeaderBar*)) base_header_bar_real_close_popovers;
	((BaseHeaderBarClass *) klass)->has_popover = (gboolean (*) (BaseHeaderBar*)) base_header_bar_real_has_popover;
	G_OBJECT_CLASS (klass)->get_property = _vala_base_header_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_base_header_bar_set_property;
	G_OBJECT_CLASS (klass)->constructor = base_header_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = base_header_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BASE_HEADER_BAR_ABOUT_ACTION_LABEL_PROPERTY, base_header_bar_properties[BASE_HEADER_BAR_ABOUT_ACTION_LABEL_PROPERTY] = g_param_spec_string ("about-action-label", "about-action-label", "about-action-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BASE_HEADER_BAR_HAS_HELP_PROPERTY, base_header_bar_properties[BASE_HEADER_BAR_HAS_HELP_PROPERTY] = g_param_spec_boolean ("has-help", "has-help", "has-help", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BASE_HEADER_BAR_HAS_KEYBOARD_SHORTCUTS_PROPERTY, base_header_bar_properties[BASE_HEADER_BAR_HAS_KEYBOARD_SHORTCUTS_PROPERTY] = g_param_spec_boolean ("has-keyboard-shortcuts", "has-keyboard-shortcuts", "has-keyboard-shortcuts", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BASE_HEADER_BAR_NO_IN_WINDOW_MODE_PROPERTY, base_header_bar_properties[BASE_HEADER_BAR_NO_IN_WINDOW_MODE_PROPERTY] = g_param_spec_boolean ("no-in-window-mode", "no-in-window-mode", "no-in-window-mode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/ca/desrt/dconf-editor/ui/base-headerbar.ui");
	base_header_bar_signals[BASE_HEADER_BAR_CHANGE_MODE_SIGNAL] = g_signal_new ("change-mode", TYPE_BASE_HEADER_BAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UCHAR, G_TYPE_NONE, 1, G_TYPE_UCHAR);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "center_box", FALSE, G_STRUCT_OFFSET (BaseHeaderBar, center_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "quit_button_stack", FALSE, BaseHeaderBar_private_offset + G_STRUCT_OFFSET (BaseHeaderBarPrivate, quit_button_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "go_back_button", FALSE, BaseHeaderBar_private_offset + G_STRUCT_OFFSET (BaseHeaderBarPrivate, go_back_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "ltr_left_separator", FALSE, BaseHeaderBar_private_offset + G_STRUCT_OFFSET (BaseHeaderBarPrivate, ltr_left_separator));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title_label", FALSE, BaseHeaderBar_private_offset + G_STRUCT_OFFSET (BaseHeaderBarPrivate, title_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "info_button", FALSE, BaseHeaderBar_private_offset + G_STRUCT_OFFSET (BaseHeaderBarPrivate, info_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "ltr_right_separator", FALSE, BaseHeaderBar_private_offset + G_STRUCT_OFFSET (BaseHeaderBarPrivate, ltr_right_separator));
}

static void
base_header_bar_adaptative_widget_interface_init (AdaptativeWidgetIface * iface,
                                                  gpointer iface_data)
{
	base_header_bar_adaptative_widget_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_window_size = (void (*) (AdaptativeWidget*, AdaptativeWidgetWindowSize)) base_header_bar_set_window_size;
}

static void
base_header_bar_instance_init (BaseHeaderBar * self,
                               gpointer klass)
{
	self->priv = base_header_bar_get_instance_private (self);
	self->priv->has_a_phone_size = FALSE;
	self->disable_popovers = FALSE;
	self->disable_action_bar = FALSE;
	self->priv->_has_help = FALSE;
	self->priv->_has_keyboard_shortcuts = FALSE;
	self->priv->last_mode_id = (guint8) 0;
	self->priv->current_mode_id = BASE_HEADER_BAR_default_mode_id;
	self->priv->default_mode_on = TRUE;
	self->priv->about_mode_id = (guint8) 0;
	self->priv->about_mode_on = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
base_header_bar_finalize (GObject * obj)
{
	BaseHeaderBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BASE_HEADER_BAR, BaseHeaderBar);
	_g_free0 (self->priv->_about_action_label);
	G_OBJECT_CLASS (base_header_bar_parent_class)->finalize (obj);
}

static GType
base_header_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BaseHeaderBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) base_header_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaseHeaderBar), 0, (GInstanceInitFunc) base_header_bar_instance_init, NULL };
	static const GInterfaceInfo adaptative_widget_info = { (GInterfaceInitFunc) base_header_bar_adaptative_widget_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType base_header_bar_type_id;
	base_header_bar_type_id = g_type_register_static (gtk_header_bar_get_type (), "BaseHeaderBar", &g_define_type_info, 0);
	g_type_add_interface_static (base_header_bar_type_id, TYPE_ADAPTATIVE_WIDGET, &adaptative_widget_info);
	BaseHeaderBar_private_offset = g_type_add_instance_private (base_header_bar_type_id, sizeof (BaseHeaderBarPrivate));
	return base_header_bar_type_id;
}

GType
base_header_bar_get_type (void)
{
	static volatile gsize base_header_bar_type_id__once = 0;
	if (g_once_init_enter (&base_header_bar_type_id__once)) {
		GType base_header_bar_type_id;
		base_header_bar_type_id = base_header_bar_get_type_once ();
		g_once_init_leave (&base_header_bar_type_id__once, base_header_bar_type_id);
	}
	return base_header_bar_type_id__once;
}

static void
_vala_base_header_bar_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	BaseHeaderBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BASE_HEADER_BAR, BaseHeaderBar);
	switch (property_id) {
		case BASE_HEADER_BAR_ABOUT_ACTION_LABEL_PROPERTY:
		g_value_set_string (value, base_header_bar_get_about_action_label (self));
		break;
		case BASE_HEADER_BAR_HAS_HELP_PROPERTY:
		g_value_set_boolean (value, base_header_bar_get_has_help (self));
		break;
		case BASE_HEADER_BAR_HAS_KEYBOARD_SHORTCUTS_PROPERTY:
		g_value_set_boolean (value, base_header_bar_get_has_keyboard_shortcuts (self));
		break;
		case BASE_HEADER_BAR_NO_IN_WINDOW_MODE_PROPERTY:
		g_value_set_boolean (value, base_header_bar_get_no_in_window_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_base_header_bar_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	BaseHeaderBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BASE_HEADER_BAR, BaseHeaderBar);
	switch (property_id) {
		case BASE_HEADER_BAR_ABOUT_ACTION_LABEL_PROPERTY:
		base_header_bar_set_about_action_label (self, g_value_get_string (value));
		break;
		case BASE_HEADER_BAR_HAS_HELP_PROPERTY:
		base_header_bar_set_has_help (self, g_value_get_boolean (value));
		break;
		case BASE_HEADER_BAR_HAS_KEYBOARD_SHORTCUTS_PROPERTY:
		base_header_bar_set_has_keyboard_shortcuts (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

