// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
#include <bdep/types-parsers.hxx>
#include <bdep/ci-parsers.hxx>
//
// End prologue.

#include <bdep/ci-options.hxx>

#include <map>
#include <set>
#include <string>
#include <vector>
#include <utility>
#include <ostream>
#include <sstream>
#include <cstring>

namespace bdep
{
  namespace cli
  {
    template <typename X>
    struct parser
    {
      static void
      parse (X& x, bool& xs, scanner& s)
      {
        using namespace std;

        const char* o (s.next ());
        if (s.more ())
        {
          string v (s.next ());
          istringstream is (v);
          if (!(is >> x && is.peek () == istringstream::traits_type::eof ()))
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (X& b, const X& a)
      {
        b = a;
      }
    };

    template <>
    struct parser<bool>
    {
      static void
      parse (bool& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          const char* v (s.next ());

          if (std::strcmp (v, "1")    == 0 ||
              std::strcmp (v, "true") == 0 ||
              std::strcmp (v, "TRUE") == 0 ||
              std::strcmp (v, "True") == 0)
            x = true;
          else if (std::strcmp (v, "0")     == 0 ||
                   std::strcmp (v, "false") == 0 ||
                   std::strcmp (v, "FALSE") == 0 ||
                   std::strcmp (v, "False") == 0)
            x = false;
          else
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (bool& b, const bool&)
      {
        b = true;
      }
    };

    template <>
    struct parser<std::string>
    {
      static void
      parse (std::string& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
          x = s.next ();
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::string& b, const std::string& a)
      {
        b = a;
      }
    };

    template <typename X>
    struct parser<std::pair<X, std::size_t> >
    {
      static void
      parse (std::pair<X, std::size_t>& x, bool& xs, scanner& s)
      {
        x.second = s.position ();
        parser<X>::parse (x.first, xs, s);
      }

      static void
      merge (std::pair<X, std::size_t>& b, const std::pair<X, std::size_t>& a)
      {
        b = a;
      }
    };

    template <typename X>
    struct parser<std::vector<X> >
    {
      static void
      parse (std::vector<X>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.push_back (x);
        xs = true;
      }

      static void
      merge (std::vector<X>& b, const std::vector<X>& a)
      {
        b.insert (b.end (), a.begin (), a.end ());
      }
    };

    template <typename X, typename C>
    struct parser<std::set<X, C> >
    {
      static void
      parse (std::set<X, C>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.insert (x);
        xs = true;
      }

      static void
      merge (std::set<X, C>& b, const std::set<X, C>& a)
      {
        b.insert (a.begin (), a.end ());
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::map<K, V, C> >
    {
      static void
      parse (std::map<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m[k] = v;
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::map<K, V, C>& b, const std::map<K, V, C>& a)
      {
        for (typename std::map<K, V, C>::const_iterator i (a.begin ()); 
             i != a.end (); 
             ++i)
          b[i->first] = i->second;
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::multimap<K, V, C> >
    {
      static void
      parse (std::multimap<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m.insert (typename std::multimap<K, V, C>::value_type (k, v));
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::multimap<K, V, C>& b, const std::multimap<K, V, C>& a)
      {
        for (typename std::multimap<K, V, C>::const_iterator i (a.begin ()); 
             i != a.end (); 
             ++i)
          b.insert (typename std::multimap<K, V, C>::value_type (i->first,
                                                                 i->second));
      }
    };

    template <typename X, typename T, T X::*M>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, s);
    }

    template <typename X, bool X::*M>
    void
    thunk (X& x, scanner& s)
    {
      s.next ();
      x.*M = true;
    }

    template <typename X, typename T, T X::*M, bool X::*S>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, x.*S, s);
    }
  }
}

#include <map>

namespace bdep
{
  // cmd_ci_options
  //

  cmd_ci_options::
  cmd_ci_options ()
  : yes_ (),
    interactive_ (),
    interactive_specified_ (false),
    server_ (),
    server_specified_ (false),
    repository_ (),
    repository_specified_ (false),
    override_ (),
    override_specified_ (false),
    overrides_file_ (),
    overrides_file_specified_ (false),
    builds_ (),
    builds_specified_ (false),
    build_config_ (),
    build_config_specified_ (false),
    target_config_ (),
    target_config_specified_ (false),
    package_config_ (),
    package_config_specified_ (false),
    build_email_ (),
    build_email_specified_ (false),
    overrides_ (),
    overrides_specified_ (false),
    simulate_ (),
    simulate_specified_ (false),
    forward_ ()
  {
  }

  bool cmd_ci_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_ci_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_ci_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_ci_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_ci_options::
  parse (::bdep::cli::scanner& s,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void cmd_ci_options::
  merge (const cmd_ci_options& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    // project_options base
    //
    ::bdep::project_options::merge (a);

    if (a.yes_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->yes_, a.yes_);
    }

    if (a.interactive_specified_)
    {
      ::bdep::cli::parser< string>::merge (
        this->interactive_, a.interactive_);
      this->interactive_specified_ = true;
    }

    if (a.server_specified_)
    {
      ::bdep::cli::parser< url>::merge (
        this->server_, a.server_);
      this->server_specified_ = true;
    }

    if (a.repository_specified_)
    {
      ::bdep::cli::parser< url>::merge (
        this->repository_, a.repository_);
      this->repository_specified_ = true;
    }

    if (a.override_specified_)
    {
      ::bdep::cli::parser< strings>::merge (
        this->override_, a.override_);
      this->override_specified_ = true;
    }

    if (a.overrides_file_specified_)
    {
      ::bdep::cli::parser< path>::merge (
        this->overrides_file_, a.overrides_file_);
      this->overrides_file_specified_ = true;
    }

    if (a.builds_specified_)
    {
      ::bdep::cli::parser< strings>::merge (
        this->builds_, a.builds_);
      this->builds_specified_ = true;
    }

    if (a.build_config_specified_)
    {
      ::bdep::cli::parser< strings>::merge (
        this->build_config_, a.build_config_);
      this->build_config_specified_ = true;
    }

    if (a.target_config_specified_)
    {
      ::bdep::cli::parser< strings>::merge (
        this->target_config_, a.target_config_);
      this->target_config_specified_ = true;
    }

    if (a.package_config_specified_)
    {
      ::bdep::cli::parser< strings>::merge (
        this->package_config_, a.package_config_);
      this->package_config_specified_ = true;
    }

    if (a.build_email_specified_)
    {
      ::bdep::cli::parser< string>::merge (
        this->build_email_, a.build_email_);
      this->build_email_specified_ = true;
    }

    if (a.overrides_specified_)
    {
      ::bdep::cli::parser< cmd_ci_override>::merge (
        this->overrides_, a.overrides_);
      this->overrides_specified_ = true;
    }

    if (a.simulate_specified_)
    {
      ::bdep::cli::parser< string>::merge (
        this->simulate_, a.simulate_);
      this->simulate_specified_ = true;
    }

    if (a.forward_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->forward_, a.forward_);
    }
  }

  ::bdep::cli::usage_para cmd_ci_options::
  print_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mCI OPTIONS\033[0m" << ::std::endl;

    os << std::endl
       << "\033[1m--yes\033[0m|\033[1m-y\033[0m                  Don't prompt for confirmation before submitting." << ::std::endl;

    os << std::endl
       << "\033[1m--interactive\033[0m|\033[1m-i\033[0m \033[4mcf\033[0m[:\033[4mbp\033[0m]  Test the package interactively in the specified build" << ::std::endl
       << "                          configuration, pausing the execution at the specified" << ::std::endl
       << "                          breakpoint. The build configuration is a target" << ::std::endl
       << "                          configuration (\033[4mtc\033[0m), optionally for a specific package" << ::std::endl
       << "                          configuration (\033[4mpc\033[0m) and/or for a specific target (\033[4mtg\033[0m):" << ::std::endl
       << ::std::endl
       << "                          \033[4mcf\033[0m = [\033[4mpc\033[0m\033[1m/\033[0m]\033[4mtc\033[0m | \033[4mpc\033[0m\033[1m/\033[0m\033[4mtc\033[0m\033[1m/\033[0m\033[4mtg\033[0m\033[0m" << ::std::endl
       << ::std::endl
       << "                          Refer to the \033[1m--build-config\033[0m option for details on the" << ::std::endl
       << "                          build configuration component semantics. Note that" << ::std::endl
       << "                          for interactive testing they should identify a single" << ::std::endl
       << "                          build configuration. Failed that, the test request" << ::std::endl
       << "                          will be aborted." << ::std::endl
       << ::std::endl
       << "                          Valid breakpoint values are \033[1mnone\033[0m (don't stop), \033[1merror\033[0m" << ::std::endl
       << "                          (stop after first error), \033[1mwarning\033[0m (stop after first" << ::std::endl
       << "                          warning), as well as the CI service-specific step ids" << ::std::endl
       << "                          in which case the execution stops before performing" << ::std::endl
       << "                          the specified step (see \033[1mbbot\033[0m worker step ids" << ::std::endl
       << "                          (bbot#arch-worker)). If no breakpoint is specified," << ::std::endl
       << "                          then \033[1merror\033[0m is assumed." << ::std::endl;

    os << std::endl
       << "\033[1m--server\033[0m \033[4murl\033[0m              CI server to submit the request to." << ::std::endl;

    os << std::endl
       << "\033[1m--repository\033[0m \033[4murl\033[0m          Remote repository URL for the project." << ::std::endl;

    os << std::endl
       << "\033[1m--override\033[0m \033[4mname\033[0m:\033[4mvalue\033[0m     Package manifest value override. Repeat this option" << ::std::endl
       << "                          to override multiple values." << ::std::endl;

    os << std::endl
       << "\033[1m--overrides-file\033[0m \033[4mfile\033[0m     Read manifest value overrides from the specified" << ::std::endl
       << "                          manifest fragment file. Repeat this option to specify" << ::std::endl
       << "                          multiple override files." << ::std::endl;

    os << std::endl
       << "\033[1m--builds\033[0m [\033[4mpc\033[0m/]\033[4mclass-expr\033[0m  Shortcut for the following option:" << ::std::endl
       << ::std::endl
       << "                          \033[1m--override \033[0m[\033[4mpc\033[0m\033[1m-\033[0m]\033[1mbuilds:\033[0m\033[4mclass-expr\033[0m\033[0m" << ::std::endl
       << ::std::endl
       << "                          Repeat this option to specify multiple build target" << ::std::endl
       << "                          configuration classes." << ::std::endl;

    os << std::endl
       << "\033[1m--build-config\033[0m \033[4mpc\033[0m/\033[4mtc\033[0m[/\033[4mtg\033[0m] Shortcut for the following options sequence:" << ::std::endl
       << ::std::endl
       << "                          [\033[1m--override \033[0m\033[4mpc\033[0m\033[1m-builds:all\033[0m\033[0m]" << ::std::endl
       << "                          \033[1m--override \033[0m\033[4mpc\033[0m\033[1m-build-include:\033[0m\033[4mtc\033[0m[\033[1m/\033[0m\033[4mtg\033[0m]\033[0m" << ::std::endl
       << "                          \033[1m--override \033[0m\033[4mpc\033[0m\033[1m-build-exclude:**\033[0m\033[0m" << ::std::endl
       << ::std::endl
       << "                          The first override is omitted from the above sequence" << ::std::endl
       << "                          if the \033[4mpc\033[0m\033[1m-builds\033[0m\033[0m override is specified on the command" << ::std::endl
       << "                          line." << ::std::endl
       << ::std::endl
       << "                          Repeat this option to specify multiple build" << ::std::endl
       << "                          configurations." << ::std::endl;

    os << std::endl
       << "\033[1m--target-config\033[0m \033[4mtc\033[0m[/\033[4mtg\033[0m]   Shortcut for the following options sequence:" << ::std::endl
       << ::std::endl
       << "                          [\033[1m--override builds:all\033[0m\033[0m]" << ::std::endl
       << "                          \033[1m--override build-include:\033[0m\033[4mtc\033[0m[\033[1m/\033[0m\033[4mtg\033[0m]\033[0m" << ::std::endl
       << "                          \033[1m--override build-exclude:**\033[0m\033[0m" << ::std::endl
       << ::std::endl
       << "                          The first override is omitted from the above sequence" << ::std::endl
       << "                          if the \033[1mbuilds\033[0m override is specified on the command" << ::std::endl
       << "                          line." << ::std::endl
       << ::std::endl
       << "                          Repeat this option to specify multiple build target" << ::std::endl
       << "                          configurations." << ::std::endl;

    os << std::endl
       << "\033[1m--package-config\033[0m \033[4mpc\033[0m       Shortcut for the following options sequence:" << ::std::endl
       << ::std::endl
       << "                          \033[1m--override \033[0m\033[4mpc\033[0m\033[1m-builds:\033[0m...\033[0m" << ::std::endl
       << "                          \033[1m--override \033[0m\033[4mpc\033[0m\033[1m-build-include:\033[0m...\033[0m" << ::std::endl
       << "                          \033[1m--override \033[0m\033[4mpc\033[0m\033[1m-build-exclude:\033[0m...\033[0m" << ::std::endl
       << ::std::endl
       << "                          Where the override values are the build constraints" << ::std::endl
       << "                          for the specified build package configuration from" << ::std::endl
       << "                          the package manifest." << ::std::endl
       << ::std::endl
       << "                          Repeat this option to specify multiple build package" << ::std::endl
       << "                          configurations." << ::std::endl;

    os << std::endl
       << "\033[1m--build-email\033[0m \033[4memail\033[0m       Shortcut for the following option:" << ::std::endl
       << ::std::endl
       << "                          \033[1m--override build-email:\033[0m\033[4memail\033[0m\033[0m" << ::std::endl;

    os << std::endl
       << "\033[1m--simulate\033[0m \033[4moutcome\033[0m        Simulate the specified outcome of the CI process" << ::std::endl
       << "                          without actually performing any externally visible" << ::std::endl
       << "                          actions (such as testing the packages or publishing" << ::std::endl
       << "                          the result). The commonly used outcome value is" << ::std::endl
       << "                          \033[1msuccess\033[0m. For other recognized outcomes refer to the" << ::std::endl
       << "                          CI service documentation." << ::std::endl;

    os << std::endl
       << "\033[1m--forward\033[0m                 Use the forwarded configuration for each package" << ::std::endl
       << "                          instead of the default configuration." << ::std::endl;

    p = ::bdep::cli::usage_para::option;

    // project_options base
    //
    p = ::bdep::project_options::print_usage (os, p);

    return p;
  }

  struct _cli_cmd_ci_options_desc_type: ::bdep::cli::options
  {
    _cli_cmd_ci_options_desc_type ()
    {
      ::bdep::cmd_ci_options::fill (*this);
    }
  };

  void cmd_ci_options::
  fill (::bdep::cli::options& os)
  {
    // project_options base
    //
    ::bdep::project_options::fill (os);

    // --yes
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-y");
      std::string dv;
      ::bdep::cli::option o ("--yes", a, true, dv);
      os.push_back (o);
    }

    // --interactive
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-i");
      std::string dv;
      ::bdep::cli::option o ("--interactive", a, false, dv);
      os.push_back (o);
    }

    // --server
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--server", a, false, dv);
      os.push_back (o);
    }

    // --repository
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--repository", a, false, dv);
      os.push_back (o);
    }

    // --override
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--override", a, false, dv);
      os.push_back (o);
    }

    // --overrides-file
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--overrides-file", a, false, dv);
      os.push_back (o);
    }

    // --builds
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--builds", a, false, dv);
      os.push_back (o);
    }

    // --build-config
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--build-config", a, false, dv);
      os.push_back (o);
    }

    // --target-config
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--target-config", a, false, dv);
      os.push_back (o);
    }

    // --package-config
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--package-config", a, false, dv);
      os.push_back (o);
    }

    // --build-email
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--build-email", a, false, dv);
      os.push_back (o);
    }

    // --overrides
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("--override");
      a.push_back ("--overrides-file");
      a.push_back ("--builds");
      a.push_back ("--build-email");
      std::string dv;
      ::bdep::cli::option o ("--overrides", a, false, dv);
      os.push_back (o);
    }

    // --simulate
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--simulate", a, false, dv);
      os.push_back (o);
    }

    // --forward
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--forward", a, true, dv);
      os.push_back (o);
    }
  }

  const ::bdep::cli::options& cmd_ci_options::
  description ()
  {
    static _cli_cmd_ci_options_desc_type _cli_cmd_ci_options_desc_;
    return _cli_cmd_ci_options_desc_;
  }

  typedef
  std::map<std::string, void (*) (cmd_ci_options&, ::bdep::cli::scanner&)>
  _cli_cmd_ci_options_map;

  static _cli_cmd_ci_options_map _cli_cmd_ci_options_map_;

  struct _cli_cmd_ci_options_map_init
  {
    _cli_cmd_ci_options_map_init ()
    {
      _cli_cmd_ci_options_map_["--yes"] =
      &::bdep::cli::thunk< cmd_ci_options, &cmd_ci_options::yes_ >;
      _cli_cmd_ci_options_map_["-y"] =
      &::bdep::cli::thunk< cmd_ci_options, &cmd_ci_options::yes_ >;
      _cli_cmd_ci_options_map_["--interactive"] =
      &::bdep::cli::thunk< cmd_ci_options, string, &cmd_ci_options::interactive_,
        &cmd_ci_options::interactive_specified_ >;
      _cli_cmd_ci_options_map_["-i"] =
      &::bdep::cli::thunk< cmd_ci_options, string, &cmd_ci_options::interactive_,
        &cmd_ci_options::interactive_specified_ >;
      _cli_cmd_ci_options_map_["--server"] =
      &::bdep::cli::thunk< cmd_ci_options, url, &cmd_ci_options::server_,
        &cmd_ci_options::server_specified_ >;
      _cli_cmd_ci_options_map_["--repository"] =
      &::bdep::cli::thunk< cmd_ci_options, url, &cmd_ci_options::repository_,
        &cmd_ci_options::repository_specified_ >;
      _cli_cmd_ci_options_map_["--override"] =
      &::bdep::cli::thunk< cmd_ci_options, strings, &cmd_ci_options::override_,
        &cmd_ci_options::override_specified_ >;
      _cli_cmd_ci_options_map_["--overrides-file"] =
      &::bdep::cli::thunk< cmd_ci_options, path, &cmd_ci_options::overrides_file_,
        &cmd_ci_options::overrides_file_specified_ >;
      _cli_cmd_ci_options_map_["--builds"] =
      &::bdep::cli::thunk< cmd_ci_options, strings, &cmd_ci_options::builds_,
        &cmd_ci_options::builds_specified_ >;
      _cli_cmd_ci_options_map_["--build-config"] =
      &::bdep::cli::thunk< cmd_ci_options, strings, &cmd_ci_options::build_config_,
        &cmd_ci_options::build_config_specified_ >;
      _cli_cmd_ci_options_map_["--target-config"] =
      &::bdep::cli::thunk< cmd_ci_options, strings, &cmd_ci_options::target_config_,
        &cmd_ci_options::target_config_specified_ >;
      _cli_cmd_ci_options_map_["--package-config"] =
      &::bdep::cli::thunk< cmd_ci_options, strings, &cmd_ci_options::package_config_,
        &cmd_ci_options::package_config_specified_ >;
      _cli_cmd_ci_options_map_["--build-email"] =
      &::bdep::cli::thunk< cmd_ci_options, string, &cmd_ci_options::build_email_,
        &cmd_ci_options::build_email_specified_ >;
      _cli_cmd_ci_options_map_["--overrides"] =
      &::bdep::cli::thunk< cmd_ci_options, cmd_ci_override, &cmd_ci_options::overrides_,
        &cmd_ci_options::overrides_specified_ >;
      _cli_cmd_ci_options_map_["--override"] =
      &::bdep::cli::thunk< cmd_ci_options, cmd_ci_override, &cmd_ci_options::overrides_,
        &cmd_ci_options::overrides_specified_ >;
      _cli_cmd_ci_options_map_["--overrides-file"] =
      &::bdep::cli::thunk< cmd_ci_options, cmd_ci_override, &cmd_ci_options::overrides_,
        &cmd_ci_options::overrides_specified_ >;
      _cli_cmd_ci_options_map_["--builds"] =
      &::bdep::cli::thunk< cmd_ci_options, cmd_ci_override, &cmd_ci_options::overrides_,
        &cmd_ci_options::overrides_specified_ >;
      _cli_cmd_ci_options_map_["--build-email"] =
      &::bdep::cli::thunk< cmd_ci_options, cmd_ci_override, &cmd_ci_options::overrides_,
        &cmd_ci_options::overrides_specified_ >;
      _cli_cmd_ci_options_map_["--simulate"] =
      &::bdep::cli::thunk< cmd_ci_options, string, &cmd_ci_options::simulate_,
        &cmd_ci_options::simulate_specified_ >;
      _cli_cmd_ci_options_map_["--forward"] =
      &::bdep::cli::thunk< cmd_ci_options, &cmd_ci_options::forward_ >;
    }
  };

  static _cli_cmd_ci_options_map_init _cli_cmd_ci_options_map_init_;

  bool cmd_ci_options::
  _parse (const char* o, ::bdep::cli::scanner& s)
  {
    _cli_cmd_ci_options_map::const_iterator i (_cli_cmd_ci_options_map_.find (o));

    if (i != _cli_cmd_ci_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    // project_options base
    //
    if (::bdep::project_options::_parse (o, s))
      return true;

    return false;
  }

  bool cmd_ci_options::
  _parse (::bdep::cli::scanner& s,
          ::bdep::cli::unknown_mode opt_mode,
          ::bdep::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bdep::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bdep::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bdep::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bdep::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bdep::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bdep::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bdep::cli::unknown_mode::fail:
            {
              throw ::bdep::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bdep::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bdep::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bdep::cli::unknown_mode::fail:
        {
          throw ::bdep::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }
}

namespace bdep
{
  ::bdep::cli::usage_para
  print_bdep_ci_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mSYNOPSIS\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mbdep ci\033[0m [\033[4moptions\033[0m] [\033[4mcfg-spec\033[0m] [\033[4mpkg-spec\033[0m]\033[0m" << ::std::endl
       << ::std::endl
       << "\033[4mcfg-spec\033[0m = (\033[1m@\033[0m\033[4mcfg-name\033[0m | \033[1m--config\033[0m|\033[1m-c\033[0m \033[4mcfg-dir\033[0m)... | \033[1m--all\033[0m|\033[1m-a\033[0m | \033[1m--forward\033[0m" << ::std::endl
       << "\033[4mpkg-spec\033[0m = (\033[1m--directory\033[0m|\033[1m-d\033[0m \033[4mpkg-dir\033[0m)... | \033[4mprj-spec\033[0m" << ::std::endl
       << "\033[4mprj-spec\033[0m = \033[1m--directory\033[0m|\033[1m-d\033[0m \033[4mprj-dir\033[0m\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mDESCRIPTION\033[0m" << ::std::endl
       << ::std::endl
       << "The \033[1mci\033[0m command submits the project packages test request to a CI server." << ::std::endl
       << ::std::endl
       << "If no project or package directory is specified, then the current working" << ::std::endl
       << "directory is assumed. If no configuration is specified, then the default" << ::std::endl
       << "configurations are used. If the specified directory is a project directory," << ::std::endl
       << "then all the packages initialized in the configurations are submitted, unless" << ::std::endl
       << "the \033[1m--forward\033[0m option is specified (see below). See \033[1mbdep-projects-configs(1)\033[0m for" << ::std::endl
       << "details on specifying projects and configurations." << ::std::endl
       << ::std::endl
       << "A CI request consists of the specified packages and their versions as well as" << ::std::endl
       << "the project's remote version control repository URL corresponding to the" << ::std::endl
       << "current (local) state of the project. The CI server should be able to fetch" << ::std::endl
       << "these package versions from this repository as well as any dependencies from" << ::std::endl
       << "this repository or its prerequisite/complement repositories, according to each" << ::std::endl
       << "package's \033[1mrepositories.manifest\033[0m." << ::std::endl
       << ::std::endl
       << "If the CI server is not explicitly specified with the \033[1m--server\033[0m option, the" << ::std::endl
       << "request is submitted to \033[1mci.cppget.org\033[0m by default." << ::std::endl
       << ::std::endl
       << "Unless the remote repository URL is specified with the \033[1m--repository\033[0m option, it" << ::std::endl
       << "will be automatically derived from the version control's \"remote\" URL. In case" << ::std::endl
       << "of \033[1mgit(1)\033[0m, it will be based on the \033[1mremote.origin.url\033[0m configuration value unless" << ::std::endl
       << "overridden with \033[1mremote.origin.build2Url\033[0m. The repository URL is then adjusted to" << ::std::endl
       << "corresponding to the current (local) state of the project. In case of \033[1mgit(1)\033[0m," << ::std::endl
       << "the current branch and commit id are added as the repository URL fragment (see" << ::std::endl
       << "\033[1mbpkg-repository-types(1)\033[0m for details)." << ::std::endl
       << ::std::endl
       << "Some package manifest values can be overridden as part of the CI request" << ::std::endl
       << "submission using the \033[1m--override\033[0m and \033[1m--overrides-file\033[0m options as well as their" << ::std::endl
       << "\033[1m--builds\033[0m, \033[1m--build-config\033[0m, \033[1m--target-config\033[0m, \033[1m--package-config\033[0m, and \033[1m--build-email\033[0m" << ::std::endl
       << "shortcuts. This is primarily useful for specifying alternative build" << ::std::endl
       << "configurations and/or build notification emails. For example:" << ::std::endl
       << ::std::endl
       << "$ bdep ci --builds gcc" << ::std::endl
       << "$ bdep ci --builds network/gcc" << ::std::endl
       << "$ bdep ci --target-config 'linux*-gcc*'" << ::std::endl
       << "$ bdep ci --package-config network" << ::std::endl
       << "$ bdep ci --build-config 'network/linux*-gcc*'" << ::std::endl
       << ::std::endl
       << "$ bdep ci --override \\" << ::std::endl
       << "  'default-build-config: config.foo.cache=true config.foo.buffer=16'" << ::std::endl
       << ::std::endl
       << "$ bdep ci --override 'mytest-build-config: config.foo.cache=true' \\" << ::std::endl
       << "  --package-config mytest" << ::std::endl
       << ::std::endl
       << "$ bdep ci --override 'build-auxiliary: *-postgresql_16'" << ::std::endl
       << ::std::endl
       << "Manifest overrides other than [\033[1m*-\033[0m]\033[1mbuild-auxiliary\033[0m[\033[1m-*\033[0m]\033[0m override the entire value" << ::std::endl
       << "group that they belong to. The [\033[1m*-\033[0m]\033[1mbuild-auxiliary\033[0m[\033[1m-*\033[0m]\033[0m values only override the" << ::std::endl
       << "matching values, which are expected to already be present in the package" << ::std::endl
       << "manifest. Currently, the following value groups/values can be overridden. The" << ::std::endl
       << "\033[1mbuild-*email\033[0m group is overridden by default as if by specifying an empty build" << ::std::endl
       << "email." << ::std::endl
       << ::std::endl
       << "build-email build-{warning,error}-email" << ::std::endl
       << "builds build-{include,exclude}" << ::std::endl
       << "build-bot" << ::std::endl
       << "*-builds *-build-{include,exclude}" << ::std::endl
       << "*-build-bot" << ::std::endl
       << "*-build-config" << ::std::endl
       << "*-build-email *-build-{warning,error}-email" << ::std::endl
       << ::std::endl
       << "[*-]build-auxiliary[-*]" << ::std::endl
       << ::std::endl
       << "For the package configuration-specific build constraint, email, auxiliary, and" << ::std::endl
       << "custom bot public key overrides, the corresponding configuration must exist in" << ::std::endl
       << "the package manifest. In contrast, the package configuration override" << ::std::endl
       << "(\033[1m*-build-config\033[0m) adds a new configuration if it doesn't exist and updates the" << ::std::endl
       << "arguments of the existing configuration otherwise. In the former case, all the" << ::std::endl
       << "potential build constraint, email, auxiliary, and custom bot public key" << ::std::endl
       << "overrides for such a newly added configuration must follow the corresponding" << ::std::endl
       << "\033[1m*-build-config\033[0m override." << ::std::endl
       << ::std::endl
       << "Note that the build constraints group values (both common and build package" << ::std::endl
       << "configuration-specific) are overridden hierarchically so that the" << ::std::endl
       << "[\033[1m*-\033[0m]\033[1mbuild-\033[0m{\033[1minclude\033[0m,\033[1mexclude\033[0m}\033[0m overrides don't affect the respective [\033[1m*-\033[0m]\033[1mbuilds\033[0m\033[0m" << ::std::endl
       << "values." << ::std::endl
       << ::std::endl
       << "Note also that the common and build package configuration-specific build" << ::std::endl
       << "constraints group value overrides are mutually exclusive. If the common build" << ::std::endl
       << "constraints are overridden, then all the configuration-specific constraints are" << ::std::endl
       << "removed. Otherwise, if any configuration-specific constraints are overridden," << ::std::endl
       << "then for the remaining configurations the build constraints are reset to" << ::std::endl
       << "\033[1mbuilds: none\033[0m." << ::std::endl
       << ::std::endl
       << "Similar to the build constraints groups, the common and build package" << ::std::endl
       << "configuration-specific custom bot public key value overrides are mutually" << ::std::endl
       << "exclusive. If the common build custom bot public keys are overridden, then all" << ::std::endl
       << "the configuration-specific custom bot public keys are removed. Otherwise, if" << ::std::endl
       << "any configuration-specific custom bot public keys are overridden, then for the" << ::std::endl
       << "remaining configurations the custom bot public keys are left unchanged." << ::std::endl
       << ::std::endl
       << "Similar to the above, the common and build package configuration-specific build" << ::std::endl
       << "emails group value overrides are mutually exclusive. If the common build emails" << ::std::endl
       << "are overridden, then all the configuration-specific emails are removed." << ::std::endl
       << "Otherwise, if any configuration-specific emails are overridden, then for the" << ::std::endl
       << "remaining configurations the build emails are reset to the empty values and the" << ::std::endl
       << "build warning and error emails are removed (which effectively disables email" << ::std::endl
       << "notifications for such configurations)." << ::std::endl
       << ::std::endl
       << "If supported by the CI service, a package can be tested interactively in a" << ::std::endl
       << "specific build configuration using the \033[1m--interactive\033[0m|\033[1m-i\033[0m\033[0m option. In this mode" << ::std::endl
       << "the CI service provides the login information for the execution environment and" << ::std::endl
       << "pauses the testing at the specified breakpoint." << ::std::endl
       << ::std::endl
       << "While the exact interpretation of the CI request depends on the specific" << ::std::endl
       << "service, normally, the CI server will respond with a reference that can be used" << ::std::endl
       << "to query the results. See Package CI (brep#ci) for details on the CI request" << ::std::endl
       << "handling." << ::std::endl
       << ::std::endl
       << "If the \033[1m--forward\033[0m option is specified then the forwarded configurations are used" << ::std::endl
       << "instead of the default configurations. In particular, this means that in this" << ::std::endl
       << "mode the project doesn't need to be initialized and all that's required is for" << ::std::endl
       << "package's source directories to be configured to forward to an out of source" << ::std::endl
       << "build configuration (see \033[1mb(1)\033[0m for details on forwarded configurations). This," << ::std::endl
       << "for example, can be used to submit packages that don't use the standard" << ::std::endl
       << "version." << ::std::endl;

    p = ::bdep::cmd_ci_options::print_usage (os, ::bdep::cli::usage_para::text);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mDEFAULT OPTIONS FILES\033[0m" << ::std::endl
       << ::std::endl
       << "See \033[1mbdep-default-options-files(1)\033[0m for an overview of the default options files." << ::std::endl
       << "For the \033[1mci\033[0m command the search start directory is the project directory. The" << ::std::endl
       << "following options files are searched for in each directory and, if found," << ::std::endl
       << "loaded in the order listed:" << ::std::endl
       << ::std::endl
       << "bdep.options" << ::std::endl
       << "bdep-ci.options" << ::std::endl
       << ::std::endl
       << "The following \033[1mci\033[0m command options cannot be specified in the default options" << ::std::endl
       << "files:" << ::std::endl
       << ::std::endl
       << "--directory|-d" << ::std::endl;

    p = ::bdep::cli::usage_para::text;

    return p;
  }
}

// Begin epilogue.
//
//
// End epilogue.

