/* SvgFontFormatWriter.c generated by valac 0.56.17, the Vala compiler
 * generated from SvgFontFormatWriter.vala, do not modify */

/*
Copyright (C) 2012, 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include "birdfont.h"
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define BIRD_FONT_TYPE_SVG_FONT_FORMAT_WRITER (bird_font_svg_font_format_writer_get_type ())
#define BIRD_FONT_SVG_FONT_FORMAT_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BIRD_FONT_TYPE_SVG_FONT_FORMAT_WRITER, BirdFontSvgFontFormatWriter))
#define BIRD_FONT_SVG_FONT_FORMAT_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BIRD_FONT_TYPE_SVG_FONT_FORMAT_WRITER, BirdFontSvgFontFormatWriterClass))
#define BIRD_FONT_IS_SVG_FONT_FORMAT_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BIRD_FONT_TYPE_SVG_FONT_FORMAT_WRITER))
#define BIRD_FONT_IS_SVG_FONT_FORMAT_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BIRD_FONT_TYPE_SVG_FONT_FORMAT_WRITER))
#define BIRD_FONT_SVG_FONT_FORMAT_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BIRD_FONT_TYPE_SVG_FONT_FORMAT_WRITER, BirdFontSvgFontFormatWriterClass))

typedef struct _BirdFontSvgFontFormatWriter BirdFontSvgFontFormatWriter;
typedef struct _BirdFontSvgFontFormatWriterClass BirdFontSvgFontFormatWriterClass;
typedef struct _BirdFontSvgFontFormatWriterPrivate BirdFontSvgFontFormatWriterPrivate;
enum  {
	BIRD_FONT_SVG_FONT_FORMAT_WRITER_0_PROPERTY,
	BIRD_FONT_SVG_FONT_FORMAT_WRITER_NUM_PROPERTIES
};
static GParamSpec* bird_font_svg_font_format_writer_properties[BIRD_FONT_SVG_FONT_FORMAT_WRITER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _BirdFontSvgFontFormatWriter {
	GObject parent_instance;
	BirdFontSvgFontFormatWriterPrivate * priv;
};

struct _BirdFontSvgFontFormatWriterClass {
	GObjectClass parent_class;
};

struct _BirdFontSvgFontFormatWriterPrivate {
	GDataOutputStream* os;
};

static gint BirdFontSvgFontFormatWriter_private_offset;
static gpointer bird_font_svg_font_format_writer_parent_class = NULL;

VALA_EXTERN GType bird_font_svg_font_format_writer_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BirdFontSvgFontFormatWriter* bird_font_svg_font_format_writer_new (void);
VALA_EXTERN BirdFontSvgFontFormatWriter* bird_font_svg_font_format_writer_construct (GType object_type);
VALA_EXTERN void bird_font_svg_font_format_writer_open (BirdFontSvgFontFormatWriter* self,
                                            GFile* file,
                                            GError** error);
VALA_EXTERN void bird_font_svg_font_format_writer_close (BirdFontSvgFontFormatWriter* self,
                                             GError** error);
VALA_EXTERN void bird_font_svg_font_format_writer_write_font_file (BirdFontSvgFontFormatWriter* self,
                                                       BirdFontFont* font,
                                                       GError** error);
static void bird_font_svg_font_format_writer_put (BirdFontSvgFontFormatWriter* self,
                                           const gchar* line,
                                           GError** error);
VALA_EXTERN gchar* bird_font_bird_font_file_encode (const gchar* s);
static gchar* bird_font_svg_font_format_writer_to_float (BirdFontSvgFontFormatWriter* self,
                                                  gdouble d);
static void __lambda180_ (BirdFontSvgFontFormatWriter* self,
                   BirdFontKerningPair* kerning);
static void ___lambda180__bird_font_kerning_classes_kerning_iterator (BirdFontKerningPair* list,
                                                               gpointer self);
static void bird_font_svg_font_format_writer_finalize (GObject * obj);
static GType bird_font_svg_font_format_writer_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_svg_font_format_writer_get_instance_private (BirdFontSvgFontFormatWriter* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontSvgFontFormatWriter_private_offset);
}

BirdFontSvgFontFormatWriter*
bird_font_svg_font_format_writer_construct (GType object_type)
{
	BirdFontSvgFontFormatWriter * self = NULL;
	self = (BirdFontSvgFontFormatWriter*) g_object_new (object_type, NULL);
	return self;
}

BirdFontSvgFontFormatWriter*
bird_font_svg_font_format_writer_new (void)
{
	return bird_font_svg_font_format_writer_construct (BIRD_FONT_TYPE_SVG_FONT_FORMAT_WRITER);
}

void
bird_font_svg_font_format_writer_open (BirdFontSvgFontFormatWriter* self,
                                       GFile* file,
                                       GError** error)
{
	GFileOutputStream* _tmp1_ = NULL;
	GFileOutputStream* _tmp2_;
	GDataOutputStream* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	if (g_file_query_exists (file, NULL)) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_EXIST, "SvgFontFormatWriter: file exists.");
		_inner_error0_ = _tmp0_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = g_file_create (file, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
	_tmp1_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp3_ = g_data_output_stream_new ((GOutputStream*) _tmp1_);
	_g_object_unref0 (self->priv->os);
	self->priv->os = _tmp3_;
	_g_object_unref0 (_tmp1_);
}

void
bird_font_svg_font_format_writer_close (BirdFontSvgFontFormatWriter* self,
                                        GError** error)
{
	GDataOutputStream* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->os;
	g_output_stream_close ((GOutputStream*) _tmp0_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda180_ (BirdFontSvgFontFormatWriter* self,
              BirdFontKerningPair* kerning)
{
	gchar* l = NULL;
	gchar* r = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (kerning != NULL);
	{
		GeeArrayList* _k_list = NULL;
		GeeArrayList* _tmp0_;
		gint _k_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _k_index = 0;
		_tmp0_ = kerning->kerning;
		_k_list = _tmp0_;
		_tmp1_ = _k_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_k_size = _tmp3_;
		_k_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontKerning* k = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_k_index = _k_index + 1;
			_tmp4_ = _k_index;
			_tmp5_ = _k_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _k_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _k_index);
			k = (BirdFontKerning*) _tmp7_;
			{
				BirdFontKerning* _tmp8_;
				BirdFontGlyph* _tmp9_;
				_tmp8_ = k;
				_tmp9_ = _tmp8_->glyph;
				if (_tmp9_ != NULL) {
					BirdFontGlyph* _tmp10_;
					gchar* _tmp11_;
					BirdFontKerning* _tmp12_;
					BirdFontGlyph* _tmp13_;
					gchar* _tmp14_;
					GDataOutputStream* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					BirdFontKerning* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					const gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					_tmp10_ = kerning->character;
					_tmp11_ = bird_font_font_to_hex_code (_tmp10_->unichar_code);
					_g_free0 (l);
					l = _tmp11_;
					_tmp12_ = k;
					_tmp13_ = _tmp12_->glyph;
					_tmp14_ = bird_font_font_to_hex_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph)->unichar_code);
					_g_free0 (r);
					r = _tmp14_;
					_tmp15_ = self->priv->os;
					_tmp16_ = l;
					_tmp17_ = string_to_string (_tmp16_);
					_tmp18_ = r;
					_tmp19_ = string_to_string (_tmp18_);
					_tmp20_ = k;
					_tmp21_ = bird_font_svg_font_format_writer_to_float (self, -_tmp20_->val);
					_tmp22_ = _tmp21_;
					_tmp23_ = string_to_string (_tmp22_);
					_tmp24_ = g_strconcat ("<hkern u1=\"&#x", _tmp17_, ";\" u2=\"&#x", _tmp19_, ";\" k=\"", _tmp23_, "\"/>\n", NULL);
					_tmp25_ = _tmp24_;
					g_data_output_stream_put_string (_tmp15_, _tmp25_, NULL, &_inner_error0_);
					_g_free0 (_tmp25_);
					_g_free0 (_tmp22_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				} else {
					g_warning ("SvgFontFormatWriter.vala:106: No glyph.");
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp26_;
				const gchar* _tmp27_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp26_ = e;
				_tmp27_ = _tmp26_->message;
				g_warning ("SvgFontFormatWriter.vala:109: %s", _tmp27_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (k);
				_g_free0 (r);
				_g_free0 (l);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_object_unref0 (k);
		}
	}
	_g_free0 (r);
	_g_free0 (l);
}

static void
___lambda180__bird_font_kerning_classes_kerning_iterator (BirdFontKerningPair* list,
                                                          gpointer self)
{
	__lambda180_ ((BirdFontSvgFontFormatWriter*) self, list);
}

void
bird_font_svg_font_format_writer_write_font_file (BirdFontSvgFontFormatWriter* self,
                                                  BirdFontFont* font,
                                                  GError** error)
{
	gchar* font_name = NULL;
	gchar* _tmp0_;
	gint units_per_em = 0;
	gint ascent = 0;
	gint descent = 0;
	GString* b = NULL;
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* glyph = NULL;
	gunichar index = 0U;
	gchar* uni = NULL;
	BirdFontKerningClasses* classes = NULL;
	gchar* font_id = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	BirdFontGlyph* space = NULL;
	BirdFontGlyphCollection* _tmp5_;
	BirdFontGlyphCollection* _tmp6_;
	BirdFontGlyph* _tmp7_;
	BirdFontGlyph* _tmp8_;
	gdouble space_width = 0.0;
	BirdFontGlyph* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	BirdFontFont* _tmp78_;
	BirdFontFont* _tmp79_;
	BirdFontKerningClasses* _tmp80_;
	BirdFontKerningClasses* _tmp81_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (font != NULL);
	_tmp0_ = bird_font_font_get_full_name (font);
	font_name = _tmp0_;
	units_per_em = 100;
	ascent = 80;
	descent = -20;
	index = (gunichar) 0;
	bird_font_svg_font_format_writer_put (self, "<?xml version=\"1.0\" standalone=\"no\"?>", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (classes);
		_g_free0 (uni);
		_g_object_unref0 (glyph);
		_g_object_unref0 (g);
		_g_string_free0 (b);
		_g_free0 (font_name);
		return;
	}
	bird_font_svg_font_format_writer_put (self, "<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/G" \
"raphics/SVG/1.1/DTD/svg11.dtd\" >", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (classes);
		_g_free0 (uni);
		_g_object_unref0 (glyph);
		_g_object_unref0 (g);
		_g_string_free0 (b);
		_g_free0 (font_name);
		return;
	}
	bird_font_svg_font_format_writer_put (self, "<svg>", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (classes);
		_g_free0 (uni);
		_g_object_unref0 (glyph);
		_g_object_unref0 (g);
		_g_string_free0 (b);
		_g_free0 (font_name);
		return;
	}
	_tmp1_ = font_name;
	_tmp2_ = string_replace (_tmp1_, " ", "-");
	font_id = _tmp2_;
	_tmp3_ = font_id;
	_tmp4_ = bird_font_bird_font_file_encode (_tmp3_);
	_g_free0 (font_id);
	font_id = _tmp4_;
	_tmp5_ = bird_font_font_get_space (font);
	_tmp6_ = _tmp5_;
	_tmp7_ = bird_font_glyph_collection_get_current (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp6_);
	space = _tmp8_;
	_tmp9_ = space;
	space_width = bird_font_glyph_get_width (_tmp9_);
	_tmp10_ = font_id;
	_tmp11_ = string_to_string (_tmp10_);
	_tmp12_ = bird_font_svg_font_format_writer_to_float (self, space_width);
	_tmp13_ = _tmp12_;
	_tmp14_ = string_to_string (_tmp13_);
	_tmp15_ = g_strconcat ("<font id=\"", _tmp11_, "\" horiz-adv-x=\"", _tmp14_, "\" >", NULL);
	_tmp16_ = _tmp15_;
	bird_font_svg_font_format_writer_put (self, _tmp16_, &_inner_error0_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp13_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (space);
		_g_free0 (font_id);
		_g_object_unref0 (classes);
		_g_free0 (uni);
		_g_object_unref0 (glyph);
		_g_object_unref0 (g);
		_g_string_free0 (b);
		_g_free0 (font_name);
		return;
	}
	_tmp17_ = bird_font_svg_font_format_writer_to_float (self, (gdouble) units_per_em);
	_tmp18_ = _tmp17_;
	_tmp19_ = string_to_string (_tmp18_);
	_tmp20_ = bird_font_svg_font_format_writer_to_float (self, (gdouble) ascent);
	_tmp21_ = _tmp20_;
	_tmp22_ = string_to_string (_tmp21_);
	_tmp23_ = bird_font_svg_font_format_writer_to_float (self, (gdouble) descent);
	_tmp24_ = _tmp23_;
	_tmp25_ = string_to_string (_tmp24_);
	_tmp26_ = g_strconcat ("<font-face units-per-em=\"", _tmp19_, "\" ascent=\"", _tmp22_, "\" descent=\"", _tmp25_, "\" />", NULL);
	_tmp27_ = _tmp26_;
	bird_font_svg_font_format_writer_put (self, _tmp27_, &_inner_error0_);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp24_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp18_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (space);
		_g_free0 (font_id);
		_g_object_unref0 (classes);
		_g_free0 (uni);
		_g_object_unref0 (glyph);
		_g_object_unref0 (g);
		_g_string_free0 (b);
		_g_free0 (font_name);
		return;
	}
	while (TRUE) {
		gunichar _tmp28_;
		BirdFontGlyph* _tmp29_;
		BirdFontGlyph* _tmp30_;
		BirdFontGlyph* _tmp31_;
		BirdFontGlyph* _tmp32_;
		GString* _tmp33_;
		GString* _tmp34_;
		BirdFontGlyph* _tmp35_;
		gboolean _tmp36_ = FALSE;
		BirdFontGlyph* _tmp37_;
		_tmp28_ = index;
		index = _tmp28_ + 1;
		_tmp29_ = bird_font_font_get_glyph_index (font, _tmp28_);
		_g_object_unref0 (g);
		g = _tmp29_;
		_tmp30_ = g;
		if (_tmp30_ == NULL) {
			break;
		}
		_tmp31_ = g;
		_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
		_g_object_unref0 (glyph);
		glyph = _tmp32_;
		_tmp33_ = g_string_new ("");
		_g_string_free0 (b);
		b = _tmp33_;
		_tmp34_ = b;
		_tmp35_ = glyph;
		g_string_append_unichar (_tmp34_, bird_font_glyph_get_unichar (_tmp35_));
		_tmp37_ = glyph;
		if (bird_font_glyph_get_unichar (_tmp37_) >= ((gunichar) ' ')) {
			GString* _tmp38_;
			const gchar* _tmp39_;
			_tmp38_ = b;
			_tmp39_ = _tmp38_->str;
			_tmp36_ = g_utf8_validate (_tmp39_, (gssize) -1, NULL);
		} else {
			_tmp36_ = FALSE;
		}
		if (_tmp36_) {
			gboolean _tmp40_ = FALSE;
			gboolean _tmp41_ = FALSE;
			gboolean _tmp42_ = FALSE;
			GString* _tmp43_;
			const gchar* _tmp44_;
			_tmp43_ = b;
			_tmp44_ = _tmp43_->str;
			if (g_strcmp0 (_tmp44_, "\"") == 0) {
				_tmp42_ = TRUE;
			} else {
				GString* _tmp45_;
				const gchar* _tmp46_;
				_tmp45_ = b;
				_tmp46_ = _tmp45_->str;
				_tmp42_ = g_strcmp0 (_tmp46_, "&") == 0;
			}
			if (_tmp42_) {
				_tmp41_ = TRUE;
			} else {
				GString* _tmp47_;
				const gchar* _tmp48_;
				_tmp47_ = b;
				_tmp48_ = _tmp47_->str;
				_tmp41_ = g_strcmp0 (_tmp48_, "<") == 0;
			}
			if (_tmp41_) {
				_tmp40_ = TRUE;
			} else {
				GString* _tmp49_;
				const gchar* _tmp50_;
				_tmp49_ = b;
				_tmp50_ = _tmp49_->str;
				_tmp40_ = g_strcmp0 (_tmp50_, ">") == 0;
			}
			if (_tmp40_) {
				BirdFontGlyph* _tmp51_;
				gchar* _tmp52_;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				BirdFontGlyph* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				const gchar* _tmp58_;
				BirdFontGlyph* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				const gchar* _tmp62_;
				gchar* _tmp63_;
				gchar* _tmp64_;
				_tmp51_ = glyph;
				_tmp52_ = bird_font_font_to_hex_code (bird_font_glyph_get_unichar (_tmp51_));
				_g_free0 (uni);
				uni = _tmp52_;
				_tmp53_ = uni;
				_tmp54_ = string_to_string (_tmp53_);
				_tmp55_ = glyph;
				_tmp56_ = bird_font_svg_font_format_writer_to_float (self, bird_font_glyph_get_width (_tmp55_));
				_tmp57_ = _tmp56_;
				_tmp58_ = string_to_string (_tmp57_);
				_tmp59_ = glyph;
				_tmp60_ = bird_font_glyph_get_svg_data (_tmp59_);
				_tmp61_ = _tmp60_;
				_tmp62_ = string_to_string (_tmp61_);
				_tmp63_ = g_strconcat ("<glyph unicode=\"&#x", _tmp54_, ";\" horiz-adv-x=\"", _tmp58_, "\" d=\"", _tmp62_, "\" />", NULL);
				_tmp64_ = _tmp63_;
				bird_font_svg_font_format_writer_put (self, _tmp64_, &_inner_error0_);
				_g_free0 (_tmp64_);
				_g_free0 (_tmp61_);
				_g_free0 (_tmp57_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (space);
					_g_free0 (font_id);
					_g_object_unref0 (classes);
					_g_free0 (uni);
					_g_object_unref0 (glyph);
					_g_object_unref0 (g);
					_g_string_free0 (b);
					_g_free0 (font_name);
					return;
				}
			} else {
				GString* _tmp65_;
				const gchar* _tmp66_;
				const gchar* _tmp67_;
				BirdFontGlyph* _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				const gchar* _tmp71_;
				BirdFontGlyph* _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				const gchar* _tmp75_;
				gchar* _tmp76_;
				gchar* _tmp77_;
				_tmp65_ = b;
				_tmp66_ = _tmp65_->str;
				_tmp67_ = string_to_string (_tmp66_);
				_tmp68_ = glyph;
				_tmp69_ = bird_font_svg_font_format_writer_to_float (self, bird_font_glyph_get_width (_tmp68_));
				_tmp70_ = _tmp69_;
				_tmp71_ = string_to_string (_tmp70_);
				_tmp72_ = glyph;
				_tmp73_ = bird_font_glyph_get_svg_data (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = string_to_string (_tmp74_);
				_tmp76_ = g_strconcat ("<glyph unicode=\"", _tmp67_, "\" horiz-adv-x=\"", _tmp71_, "\" d=\"", _tmp75_, "\" />", NULL);
				_tmp77_ = _tmp76_;
				bird_font_svg_font_format_writer_put (self, _tmp77_, &_inner_error0_);
				_g_free0 (_tmp77_);
				_g_free0 (_tmp74_);
				_g_free0 (_tmp70_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (space);
					_g_free0 (font_id);
					_g_object_unref0 (classes);
					_g_free0 (uni);
					_g_object_unref0 (glyph);
					_g_object_unref0 (g);
					_g_string_free0 (b);
					_g_free0 (font_name);
					return;
				}
			}
		}
	}
	_tmp78_ = bird_font_bird_font_get_current_font ();
	_tmp79_ = _tmp78_;
	_tmp80_ = bird_font_font_get_kerning_classes (_tmp79_);
	_g_object_unref0 (classes);
	classes = _tmp80_;
	_g_object_unref0 (_tmp79_);
	_tmp81_ = classes;
	bird_font_kerning_classes_all_pairs (_tmp81_, ___lambda180__bird_font_kerning_classes_kerning_iterator, self);
	bird_font_svg_font_format_writer_put (self, "</font>", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (space);
		_g_free0 (font_id);
		_g_object_unref0 (classes);
		_g_free0 (uni);
		_g_object_unref0 (glyph);
		_g_object_unref0 (g);
		_g_string_free0 (b);
		_g_free0 (font_name);
		return;
	}
	bird_font_svg_font_format_writer_put (self, "</svg>", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (space);
		_g_free0 (font_id);
		_g_object_unref0 (classes);
		_g_free0 (uni);
		_g_object_unref0 (glyph);
		_g_object_unref0 (g);
		_g_string_free0 (b);
		_g_free0 (font_name);
		return;
	}
	_g_object_unref0 (space);
	_g_free0 (font_id);
	_g_object_unref0 (classes);
	_g_free0 (uni);
	_g_object_unref0 (glyph);
	_g_object_unref0 (g);
	_g_string_free0 (b);
	_g_free0 (font_name);
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
bird_font_svg_font_format_writer_to_float (BirdFontSvgFontFormatWriter* self,
                                           gdouble d)
{
	gchar* s = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = double_to_string (d);
	s = _tmp0_;
	_tmp1_ = s;
	if (string_index_of (_tmp1_, "e", 0) != -1) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("0");
		result = _tmp2_;
		_g_free0 (s);
		return result;
	}
	_tmp3_ = s;
	_tmp4_ = string_replace (_tmp3_, ",", ".");
	result = _tmp4_;
	_g_free0 (s);
	return result;
}

/** Write a new line */
static void
bird_font_svg_font_format_writer_put (BirdFontSvgFontFormatWriter* self,
                                      const gchar* line,
                                      GError** error)
{
	GDataOutputStream* _tmp0_;
	GDataOutputStream* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_tmp0_ = self->priv->os;
	g_data_output_stream_put_string (_tmp0_, line, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = self->priv->os;
	g_data_output_stream_put_string (_tmp1_, "\n", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
bird_font_svg_font_format_writer_class_init (BirdFontSvgFontFormatWriterClass * klass,
                                             gpointer klass_data)
{
	bird_font_svg_font_format_writer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontSvgFontFormatWriter_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_svg_font_format_writer_finalize;
}

static void
bird_font_svg_font_format_writer_instance_init (BirdFontSvgFontFormatWriter * self,
                                                gpointer klass)
{
	self->priv = bird_font_svg_font_format_writer_get_instance_private (self);
}

static void
bird_font_svg_font_format_writer_finalize (GObject * obj)
{
	BirdFontSvgFontFormatWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_SVG_FONT_FORMAT_WRITER, BirdFontSvgFontFormatWriter);
	_g_object_unref0 (self->priv->os);
	G_OBJECT_CLASS (bird_font_svg_font_format_writer_parent_class)->finalize (obj);
}

static GType
bird_font_svg_font_format_writer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontSvgFontFormatWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_svg_font_format_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontSvgFontFormatWriter), 0, (GInstanceInitFunc) bird_font_svg_font_format_writer_instance_init, NULL };
	GType bird_font_svg_font_format_writer_type_id;
	bird_font_svg_font_format_writer_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontSvgFontFormatWriter", &g_define_type_info, 0);
	BirdFontSvgFontFormatWriter_private_offset = g_type_add_instance_private (bird_font_svg_font_format_writer_type_id, sizeof (BirdFontSvgFontFormatWriterPrivate));
	return bird_font_svg_font_format_writer_type_id;
}

GType
bird_font_svg_font_format_writer_get_type (void)
{
	static volatile gsize bird_font_svg_font_format_writer_type_id__once = 0;
	if (g_once_init_enter (&bird_font_svg_font_format_writer_type_id__once)) {
		GType bird_font_svg_font_format_writer_type_id;
		bird_font_svg_font_format_writer_type_id = bird_font_svg_font_format_writer_get_type_once ();
		g_once_init_leave (&bird_font_svg_font_format_writer_type_id__once, bird_font_svg_font_format_writer_type_id);
	}
	return bird_font_svg_font_format_writer_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

