/*
 * PropsTemplate.java
 *
 * Brazil project web application toolkit,
 * export version: 2.1 
 * Copyright (c) 1998-2004 Sun Microsystems, Inc.
 *
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License Version 
 * 1.0 (the "License"). You may not use this file except in compliance with 
 * the License. A copy of the License is included as the file "license.terms",
 * and also available at http://www.sun.com/
 * 
 * The Original Code is from:
 *    Brazil project web application toolkit release 2.1.
 * The Initial Developer of the Original Code is: suhler.
 * Portions created by suhler are Copyright (C) Sun Microsystems, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s): cstevens, suhler.
 *
 * Version:  2.3
 * Created by suhler on 98/09/14
 * Last modified by suhler on 04/11/03 08:35:55
 */

package sunlabs.brazil.template;

import sunlabs.brazil.util.Format;
import sunlabs.brazil.util.http.HttpUtil;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Dictionary;
import java.util.Properties;
import java.io.Serializable;

/**
 * [<i>Deprecated, use the the SetTemplate</i>.]<br>
 * Template class for substituting request properties into an HTML page.
 * This class is used by the TemplateHandler
 * The following request properties are used:
 * <dl class=props>
 * <dt>query	<dd> The query parameters are placed into the request object,
 *	        prefixed by the value assigned to "query".
 * <dt>headers	<dd> The mime headers are placed into the request object,
 *		prefixed by the value assigned to "headers".  The values:
 *		url, query, method, and version are copied from the request
 *		object into the properties. The clients IP address is
 *		saved in the "address" property.
 * <dt>url.orig	<dd> If set and "headers" are requested, this value is used as
 *		the <code>url</code> instead of the one in request.url. 
 * </dl>
 * <p>
 * A new HTML tag,  
 * <code>&lt;property&gt;</code> is defined.  It takes the following 
 * tag attributes:
 * <dl>
 * <dt>name	<dd> The name of the property in
 *                   {@link sunlabs.brazil.server.Request#props props}
 *		     to replace the <code>property</code> tag with.
 * <dt>default	<dd> The value to use if the property is not defined.
 *		     If no <code>default</code> is specified, the empty
 *		     string is used instead.
 * <dt>convert	<dd> The value is converted before substitution into
 *		     the content.  Convert accepts either:
 *		     <ul>
 *		     <li><b>convert=html</b>Protect plain text by escaping the
 *			characters &quot; &lt; &gt; and &amp;.
 *		     <li><b>convert=url</b>Make sure the string is suitable
 *			for use in a url or query string.
 *		     </ul>
 * </dl>
 *
 * @author		Stephen Uhler
 * @version		%V% PropsTemplate.java 2.3
 */

public class PropsTemplate
    extends Template implements Serializable
{
    /**
     * This gets called at every page, at the beginning.  See if we should add
     * the mime headers and query parameters into the request object
     */

    public boolean
    init(RewriteContext hr)
    {
	Properties props = hr.request.props;
	String query = props.getProperty(hr.prefix + "query");
	if (query != null) {
	    Dictionary h = hr.request.getQueryData(null);
	    Enumeration keys = h.keys();
	    while(keys.hasMoreElements()) {
		String key = (String) keys.nextElement();
		props.put(query + key, h.get(key));
	    }
	}

	String headers = props.getProperty(hr.prefix + "headers");
	if (headers != null) {
	    Enumeration keys = hr.request.headers.keys();
	    while(keys.hasMoreElements()) {
		String key = (String) keys.nextElement();
		props.put(headers + key.toLowerCase(),
			hr.request.headers.get(key));
	    }
	    props.put(headers + "method", hr.request.method);
	    if (props.containsKey("url.orig")) {
		props.put(headers + "url", props.getProperty("url.orig"));
	    } else {
		props.put(headers + "url", hr.request.url);
	    }
	    props.put(headers + "query", hr.request.query);
	    props.put(headers + "protocol", hr.request.protocol);
    	    props.put(headers + "address",
		"" + hr.request.getSocket().getInetAddress().getHostAddress());
	}
	return super.init(hr);
    }

    /**
     * Convert the html tag "property" in to the request's property
     * @param key	The name of the property to substitute.  Variable
     *			substitution using the style described in 
     *		 	{@link Format#getProperty} is permitted, e.g.:
     *			<code>employee.${id}.last</code>
     */

    public void
    tag_property(RewriteContext hr) {
	String name = hr.getArgs();
	String result = null;
	if (name.indexOf('=') >= 0) {
	    name = hr.get("name");
	    result = hr.get("default");
	} else {
	    name = Format.subst(hr.request.props, name);
	}

	if (name == null) {
	    debug(hr, "property: no name");
	    return;
	}
	result = hr.request.props.getProperty(name,result);

	if (result != null) {
	    String convert = hr.get("convert");
	    if ("html".equals(convert)) {
		result = HttpUtil.htmlEncode(result);
	    } else if ("url".equals(convert)) {
		result = HttpUtil.urlEncode(result);
	    }
	    hr.append(result);
	} else {
	    debug(hr, "property: no value for " + name);
	}
	hr.killToken();
    }

    /**
     * Insert a literal "&lt;".
     * Using the current scheme, there is no easy way to substitute into
     * a tag parameter.  So we'll invent a "magic" tag (called tag)
     * that will allow us to create entities dynamically.  Thus values
     * can be substituted into entities by escaping the entity as in:
     * <pre>
     * &lt;tag&gt;a href=&lt;property href&gt;&lt;/tag&gt;
     * </pre>
     */

    public void
    tag_tag(RewriteContext hr)
    {
	hr.append("<");
    }

    /**
     * Insert a literal "&gt;"
     */

    public void
    tag_slash_tag(RewriteContext hr)
    {
	hr.append(">");
    }
}
