/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Arrays;
import java.util.Collections;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.string.Strings;

public class JavaScriptContentHeaderItem
extends JavaScriptHeaderItem {
    private final CharSequence javaScript;
    private final String id;

    public JavaScriptContentHeaderItem(CharSequence javaScript, String id, String condition) {
        super(condition);
        this.javaScript = javaScript;
        this.id = id;
    }

    public CharSequence getJavaScript() {
        return this.javaScript;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void render(Response response) {
        boolean hasCondition;
        boolean bl = hasCondition = !Strings.isEmpty((CharSequence)this.getCondition());
        if (hasCondition) {
            response.write((CharSequence)"<!--[if ");
            response.write((CharSequence)this.getCondition());
            response.write((CharSequence)"]>");
        }
        JavaScriptUtils.writeJavaScript(response, this.getJavaScript(), this.getId());
        if (hasCondition) {
            response.write((CharSequence)"<![endif]-->\n");
        }
    }

    @Override
    public Iterable<?> getRenderTokens() {
        if (Strings.isEmpty((CharSequence)this.getId())) {
            return Collections.singletonList(this.getJavaScript());
        }
        return Arrays.asList(this.getId(), this.getJavaScript());
    }

    public String toString() {
        return "JavaScriptHeaderItem(" + this.getJavaScript() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JavaScriptContentHeaderItem that = (JavaScriptContentHeaderItem)o;
        if (this.javaScript != null ? !this.javaScript.equals(that.javaScript) : that.javaScript != null) {
            return false;
        }
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.javaScript != null ? this.javaScript.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }
}

