/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Arrays;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IReferenceHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.bundles.IResourceBundle;
import org.apache.wicket.util.string.Strings;

public class CssReferenceHeaderItem
extends CssHeaderItem
implements IReferenceHeaderItem {
    private final ResourceReference reference;
    private final String media;
    private final PageParameters pageParameters;

    public CssReferenceHeaderItem(ResourceReference reference, PageParameters pageParameters, String media, String condition) {
        super(condition);
        this.reference = reference;
        this.pageParameters = pageParameters;
        this.media = media;
    }

    @Override
    public ResourceReference getReference() {
        return this.reference;
    }

    public String getMedia() {
        return this.media;
    }

    public PageParameters getPageParameters() {
        return this.pageParameters;
    }

    @Override
    public Iterable<? extends HeaderItem> getDependencies() {
        return this.getReference().getDependencies();
    }

    @Override
    public Iterable<? extends HeaderItem> getProvidedResources() {
        if (this.getReference() instanceof IResourceBundle) {
            return ((IResourceBundle)((Object)this.getReference())).getProvidedResources();
        }
        return super.getProvidedResources();
    }

    @Override
    public void render(Response response) {
        this.internalRenderCSSReference(response, this.getUrl(), this.media, this.getCondition());
    }

    @Override
    public Iterable<?> getRenderTokens() {
        return Arrays.asList("css-" + Strings.stripJSessionId((String)this.getUrl()) + "-" + this.media);
    }

    public String toString() {
        return "CSSReferenceHeaderItem(" + this.getReference() + ", " + this.getPageParameters() + ")";
    }

    private String getUrl() {
        ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(this.getReference(), this.getPageParameters());
        return ((Object)RequestCycle.get().urlFor(handler)).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CssReferenceHeaderItem that = (CssReferenceHeaderItem)o;
        if (this.reference != null ? !this.reference.equals(that.reference) : that.reference != null) {
            return false;
        }
        if (this.media != null ? !this.media.equals(that.media) : that.media != null) {
            return false;
        }
        return this.pageParameters != null ? this.pageParameters.equals((Object)that.pageParameters) : that.pageParameters == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.reference != null ? this.reference.hashCode() : 0);
        result = 31 * result + (this.media != null ? this.media.hashCode() : 0);
        result = 31 * result + (this.pageParameters != null ? this.pageParameters.hashCode() : 0);
        return result;
    }
}

