/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.Application;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.HtmlSpecialTag;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.RawMarkup;
import org.apache.wicket.markup.parser.IMarkupFilter;
import org.apache.wicket.markup.parser.IXmlPullParser;
import org.apache.wicket.markup.parser.XmlPullParser;
import org.apache.wicket.markup.parser.filter.RootMarkupFilter;
import org.apache.wicket.settings.IMarkupSettings;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.resource.StringResourceStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMarkupParser {
    private static final Logger log = LoggerFactory.getLogger(AbstractMarkupParser.class);
    public static final Pattern CONDITIONAL_COMMENT_OPENING = Pattern.compile("(s?)^[^>]*?<!--\\[if.*?\\]>(-->)?(<!.*?-->)?");
    private static final Pattern PRE_BLOCK = Pattern.compile("<pre>.*?</pre>", 40);
    private final IXmlPullParser xmlParser;
    private IMarkupFilter markupFilterChain;
    private final Markup markup;
    private final IMarkupSettings markupSettings;
    private final List<IMarkupFilter> filters;

    public AbstractMarkupParser(MarkupResourceStream resource) {
        this(new XmlPullParser(), resource);
    }

    public AbstractMarkupParser(String markup) {
        this(new XmlPullParser(), new MarkupResourceStream((IResourceStream)new StringResourceStream((CharSequence)markup)));
    }

    public AbstractMarkupParser(IXmlPullParser xmlParser, MarkupResourceStream resource) {
        this.xmlParser = xmlParser;
        this.markupSettings = Application.get().getMarkupSettings();
        this.markup = new Markup(resource);
        this.markupFilterChain = new RootMarkupFilter(xmlParser, resource);
        this.filters = this.initializeMarkupFilters(this.markup);
    }

    public List<IMarkupFilter> getMarkupFilters() {
        return this.filters;
    }

    public final void setWicketNamespace(String namespace) {
        this.markup.getMarkupResourceStream().setWicketNamespace(namespace);
    }

    protected MarkupResourceStream getMarkupResourceStream() {
        return this.markup.getMarkupResourceStream();
    }

    protected abstract List<IMarkupFilter> initializeMarkupFilters(Markup var1);

    public final Markup parse() throws IOException, ResourceStreamNotFoundException {
        this.markupFilterChain = new RootMarkupFilter(this.xmlParser, this.markup.getMarkupResourceStream());
        for (IMarkupFilter filter : this.getMarkupFilters()) {
            filter.setNextFilter(this.markupFilterChain);
            this.markupFilterChain = filter;
        }
        MarkupResourceStream markupResourceStream = this.markup.getMarkupResourceStream();
        this.xmlParser.parse(markupResourceStream.getResource().getInputStream(), this.markupSettings.getDefaultMarkupEncoding());
        this.parseMarkup();
        markupResourceStream.setEncoding(this.xmlParser.getEncoding());
        markupResourceStream.setDoctype(this.xmlParser.getDoctype());
        if (this.xmlParser.getEncoding() == null) {
            String a = "The markup file does not have a XML declaration prolog with 'encoding' attribute";
            String b = ". E.g. <?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
            if (this.markupSettings.getThrowExceptionOnMissingXmlDeclaration()) {
                throw new MarkupException(markupResourceStream.getResource(), a + b);
            }
            log.debug(a + ":" + markupResourceStream.getResource() + ". It is safer to use it" + b);
        }
        return this.markup;
    }

    private MarkupElement getNextTag() throws ParseException {
        return this.markupFilterChain.nextElement();
    }

    private void parseMarkup() {
        try {
            MarkupElement elem;
            int size = this.markup.size();
            while (null != (elem = this.getNextTag())) {
                boolean add;
                if (elem instanceof HtmlSpecialTag) {
                    elem = new ComponentTag(((HtmlSpecialTag)elem).getXmlTag());
                }
                if (!(elem instanceof ComponentTag)) continue;
                ComponentTag tag = (ComponentTag)elem;
                boolean bl = add = tag.getId() != null;
                if (!add && tag.isClose()) {
                    boolean bl2 = add = tag.getOpenTag() != null && tag.getOpenTag().getId() != null;
                }
                if (add || tag.isModified() || this.markup.size() != size) {
                    CharSequence text = this.xmlParser.getInputFromPositionMarker(tag.getPos());
                    if (text.length() > 0) {
                        text = this.handleRawText(((Object)text).toString());
                        this.markup.addMarkupElement(size, new RawMarkup(text));
                    }
                    this.xmlParser.setPositionMarker();
                    if (add) {
                        if (!tag.isIgnore()) {
                            this.markup.addMarkupElement(tag);
                        }
                    } else if (tag.isModified()) {
                        this.markup.addMarkupElement(new RawMarkup(tag.toCharSequence()));
                    } else {
                        this.xmlParser.setPositionMarker(tag.getPos());
                    }
                }
                size = this.markup.size();
            }
        }
        catch (ParseException ex) {
            CharSequence text = this.xmlParser.getInputFromPositionMarker(-1);
            if (text.length() > 0) {
                this.markup.addMarkupElement(new RawMarkup(text));
            }
            this.markup.getMarkupResourceStream().setEncoding(this.xmlParser.getEncoding());
            this.markup.getMarkupResourceStream().setDoctype(this.xmlParser.getDoctype());
            MarkupStream markupStream = new MarkupStream(this.markup);
            markupStream.setCurrentIndex(this.markup.size() - 1);
            throw new MarkupException(markupStream, ex.getMessage(), (Throwable)ex);
        }
        CharSequence text = this.xmlParser.getInputFromPositionMarker(-1);
        if (text.length() > 0) {
            text = this.handleRawText(((Object)text).toString());
            this.markup.addMarkupElement(new RawMarkup(text));
        }
        this.postProcess(this.markup);
        this.markup.makeImmutable();
    }

    protected void postProcess(Markup markup) {
        for (IMarkupFilter filter = this.markupFilterChain; filter != null; filter = filter.getNextFilter()) {
            filter.postProcess(markup);
        }
    }

    protected CharSequence handleRawText(String rawMarkup) {
        boolean stripComments = this.markupSettings.getStripComments();
        boolean compressWhitespace = this.markupSettings.getCompressWhitespace();
        if (stripComments) {
            rawMarkup = AbstractMarkupParser.removeComment(rawMarkup);
        }
        if (compressWhitespace) {
            rawMarkup = this.compressWhitespace(rawMarkup);
        }
        return rawMarkup;
    }

    protected String compressWhitespace(String rawMarkup) {
        Matcher m = PRE_BLOCK.matcher(rawMarkup);
        int lastend = 0;
        StringBuilder sb = null;
        while (true) {
            boolean matched;
            String nonPre = (matched = m.find()) ? rawMarkup.substring(lastend, m.start()) : rawMarkup.substring(lastend);
            nonPre = nonPre.replaceAll("[ \\t]+", " ");
            nonPre = nonPre.replaceAll("( ?[\\r\\n] ?)+", "\n");
            if (lastend == 0) {
                if (matched) {
                    sb = new StringBuilder(rawMarkup.length());
                } else {
                    return nonPre;
                }
            }
            sb.append(nonPre);
            if (!matched) break;
            sb.append(m.group());
            lastend = m.end();
        }
        return sb.toString();
    }

    private static String removeComment(String rawMarkup) {
        int pos1 = rawMarkup.indexOf("<!--");
        while (pos1 != -1) {
            StringBuilder buf = new StringBuilder(rawMarkup.length());
            String possibleComment = rawMarkup.substring(pos1);
            Matcher matcher = CONDITIONAL_COMMENT_OPENING.matcher(possibleComment);
            if (matcher.find()) {
                pos1 += matcher.end();
            } else {
                int pos2 = rawMarkup.indexOf("-->", pos1 + 4);
                buf.append(rawMarkup.substring(0, pos1));
                if (rawMarkup.length() >= pos2 + 3) {
                    buf.append(rawMarkup.substring(pos2 + 3));
                }
                rawMarkup = buf.toString();
            }
            pos1 = rawMarkup.indexOf("<!--", pos1);
        }
        return rawMarkup;
    }

    public String toString() {
        return this.markup.toString();
    }
}

