/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.ast;

import com.strobel.annotations.NotNull;
import com.strobel.assembler.metadata.Flags;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.StrongBox;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.ast.AstCode;
import com.strobel.decompiler.ast.BasicBlock;
import com.strobel.decompiler.ast.Block;
import com.strobel.decompiler.ast.CaseBlock;
import com.strobel.decompiler.ast.CatchBlock;
import com.strobel.decompiler.ast.Condition;
import com.strobel.decompiler.ast.DefaultMap;
import com.strobel.decompiler.ast.Error;
import com.strobel.decompiler.ast.Expression;
import com.strobel.decompiler.ast.Label;
import com.strobel.decompiler.ast.Loop;
import com.strobel.decompiler.ast.LoopType;
import com.strobel.decompiler.ast.Node;
import com.strobel.decompiler.ast.PatternMatching;
import com.strobel.decompiler.ast.Switch;
import com.strobel.decompiler.ast.TryCatchBlock;
import com.strobel.util.ContractUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

final class GotoRemoval {
    static final int OPTION_MERGE_ADJACENT_LABELS = 1;
    static final int OPTION_REMOVE_REDUNDANT_RETURNS = 2;
    final Map<Node, Label> labels = new IdentityHashMap<Node, Label>();
    final Map<Label, Node> labelLookup = new IdentityHashMap<Label, Node>();
    final Map<Node, Node> parentLookup = new IdentityHashMap<Node, Node>();
    final Map<Node, Node> nextSibling = new IdentityHashMap<Node, Node>();
    final int options;

    GotoRemoval() {
        this(0);
    }

    GotoRemoval(int options) {
        this.options = options;
    }

    public final void removeGotos(Block method) {
        this.traverseGraph(method);
        this.removeGotosCore(method);
    }

    private void removeGotosCore(Block method) {
        boolean modified;
        this.transformLeaveStatements(method);
        do {
            modified = false;
            for (Expression e : method.getSelfAndChildrenRecursive(Expression.class)) {
                if (e.getCode() != AstCode.Goto) continue;
                modified |= this.trySimplifyGoto(e);
            }
        } while (modified);
        this.removeRedundantCodeCore(method);
    }

    private void traverseGraph(Block method) {
        this.labels.clear();
        this.labelLookup.clear();
        this.parentLookup.clear();
        this.nextSibling.clear();
        this.parentLookup.put(method, Node.NULL);
        for (Node node : method.getSelfAndChildrenRecursive(Node.class)) {
            Node previousChild = null;
            for (Node child : node.getChildren()) {
                if (this.parentLookup.containsKey(child)) {
                    throw Error.expressionLinkedFromMultipleLocations(child);
                }
                this.parentLookup.put(child, node);
                if (previousChild != null) {
                    if (previousChild instanceof Label) {
                        this.labels.put(child, (Label)previousChild);
                        this.labelLookup.put((Label)previousChild, child);
                    }
                    this.nextSibling.put(previousChild, child);
                }
                previousChild = child;
            }
            if (previousChild == null) continue;
            this.nextSibling.put(previousChild, Node.NULL);
        }
    }

    private boolean trySimplifyGoto(Expression gotoExpression) {
        Node firstChild;
        Node parent;
        boolean isRedundant;
        assert (gotoExpression.getCode() == AstCode.Goto);
        assert (gotoExpression.getOperand() instanceof Label);
        Node target = this.enter(gotoExpression, new LinkedHashSet<Node>());
        if (target == null) {
            return false;
        }
        LinkedHashSet<Node> visitedNodes = new LinkedHashSet<Node>();
        visitedNodes.add(gotoExpression);
        Node exitTo = this.exit(gotoExpression, visitedNodes);
        boolean bl = isRedundant = target == exitTo;
        if (!(!isRedundant || (parent = this.parentLookup.get(gotoExpression)) instanceof Block && ((Block)parent).getBody().size() == 1 && this.parentLookup.get(parent) instanceof Condition)) {
            gotoExpression.setCode(AstCode.Nop);
            gotoExpression.setOperand(null);
            if (target instanceof Expression) {
                ((Expression)target).getRanges().addAll(gotoExpression.getRanges());
            }
            gotoExpression.getRanges().clear();
            return true;
        }
        visitedNodes.clear();
        visitedNodes.add(gotoExpression);
        for (TryCatchBlock tryCatchBlock : this.getParents(gotoExpression, TryCatchBlock.class)) {
            Block finallyBlock = tryCatchBlock.getFinallyBlock();
            if (finallyBlock == null || target != this.enter(finallyBlock, visitedNodes)) continue;
            gotoExpression.setCode(AstCode.Nop);
            gotoExpression.setOperand(null);
            gotoExpression.getRanges().clear();
            return true;
        }
        visitedNodes.clear();
        visitedNodes.add(gotoExpression);
        Loop continueBlock = null;
        for (Node parent2 : this.getParents(gotoExpression)) {
            Node firstChild2;
            if (!(parent2 instanceof Loop)) continue;
            Node enter = this.enter(parent2, visitedNodes);
            if (target == enter) {
                continueBlock = (Loop)parent2;
                break;
            }
            if (!(enter instanceof TryCatchBlock) || (firstChild2 = (Node)CollectionUtilities.firstOrDefault(enter.getChildren())) == null) break;
            visitedNodes.clear();
            if (this.enter(firstChild2, visitedNodes) != target) break;
            continueBlock = (Loop)parent2;
            break;
        }
        if (continueBlock != null) {
            gotoExpression.setCode(AstCode.LoopContinue);
            gotoExpression.setOperand(null);
            return true;
        }
        if (isRedundant) {
            gotoExpression.setCode(AstCode.Nop);
            gotoExpression.setOperand(null);
            if (target instanceof Expression) {
                ((Expression)target).getRanges().addAll(gotoExpression.getRanges());
            }
            gotoExpression.getRanges().clear();
            return true;
        }
        visitedNodes.clear();
        visitedNodes.add(gotoExpression);
        int loopDepth = 0;
        int switchDepth = 0;
        Node breakBlock = null;
        for (Node parent3 : this.getParents(gotoExpression)) {
            Node exit;
            if (parent3 instanceof Loop) {
                ++loopDepth;
                exit = this.exit(parent3, visitedNodes);
                if (target == exit) {
                    breakBlock = parent3;
                    break;
                }
                if (!(exit instanceof TryCatchBlock) || (firstChild = (Node)CollectionUtilities.firstOrDefault(exit.getChildren())) == null) continue;
                visitedNodes.clear();
                if (this.enter(firstChild, visitedNodes) != target) continue;
                breakBlock = parent3;
                break;
            }
            if (!(parent3 instanceof Switch)) continue;
            ++switchDepth;
            exit = this.exit(parent3, visitedNodes);
            if (target != exit) continue;
            breakBlock = parent3;
            break;
        }
        if (breakBlock != null) {
            gotoExpression.setCode(AstCode.LoopOrSwitchBreak);
            gotoExpression.setOperand(loopDepth + switchDepth > 1 ? gotoExpression.getOperand() : null);
            return true;
        }
        visitedNodes.clear();
        visitedNodes.add(gotoExpression);
        loopDepth = 0;
        for (Node parent3 : this.getParents(gotoExpression)) {
            if (!(parent3 instanceof Loop)) continue;
            ++loopDepth;
            Node enter = this.enter(parent3, visitedNodes);
            if (target == enter) {
                continueBlock = (Loop)parent3;
                break;
            }
            if (!(enter instanceof TryCatchBlock) || (firstChild = (Node)CollectionUtilities.firstOrDefault(enter.getChildren())) == null) continue;
            visitedNodes.clear();
            if (this.enter(firstChild, visitedNodes) != target) continue;
            continueBlock = (Loop)parent3;
            break;
        }
        if (continueBlock != null) {
            gotoExpression.setCode(AstCode.LoopContinue);
            gotoExpression.setOperand(loopDepth > 1 ? gotoExpression.getOperand() : null);
            return true;
        }
        return this.tryInlineReturn(gotoExpression, target, AstCode.Return) || this.tryInlineReturn(gotoExpression, target, AstCode.AThrow);
    }

    private boolean tryInlineReturn(Expression gotoExpression, Node target, AstCode code) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        if (PatternMatching.matchGetArguments(target, code, expressions) && (expressions.isEmpty() || expressions.size() == 1)) {
            gotoExpression.setCode(code);
            gotoExpression.setOperand(null);
            gotoExpression.getArguments().clear();
            if (!expressions.isEmpty()) {
                gotoExpression.getArguments().add(((Expression)expressions.get(0)).clone());
            }
            return true;
        }
        StrongBox v = new StrongBox();
        StrongBox v2 = new StrongBox();
        Node next = this.nextSibling.get(target);
        while (next instanceof Label) {
            next = this.nextSibling.get(next);
        }
        if (PatternMatching.matchGetArguments(target, AstCode.Store, v, expressions) && expressions.size() == 1 && PatternMatching.matchGetArguments(next, code, expressions) && expressions.size() == 1 && PatternMatching.matchGetOperand((Node)expressions.get(0), AstCode.Load, v2) && v2.get() == v.get()) {
            gotoExpression.setCode(code);
            gotoExpression.setOperand(null);
            gotoExpression.getArguments().clear();
            gotoExpression.getArguments().add(((Expression)target).getArguments().get(0).clone());
            return true;
        }
        return false;
    }

    private Iterable<Node> getParents(Node node) {
        return this.getParents(node, Node.class);
    }

    private <T extends Node> Iterable<T> getParents(final Node node, final Class<T> parentType) {
        return new Iterable<T>(){

            @Override
            @NotNull
            public final Iterator<T> iterator() {
                return new Iterator<T>(){
                    T current;
                    {
                        this.current = this.updateCurrent(node);
                    }

                    private T updateCurrent(Node node) {
                        while (node != null && node != Node.NULL) {
                            if (!parentType.isInstance(node = GotoRemoval.this.parentLookup.get(node))) continue;
                            return node;
                        }
                        return null;
                    }

                    @Override
                    public final boolean hasNext() {
                        return this.current != null;
                    }

                    @Override
                    public final T next() {
                        Object next = this.current;
                        if (next == null) {
                            throw new NoSuchElementException();
                        }
                        this.current = this.updateCurrent((Node)next);
                        return next;
                    }

                    @Override
                    public final void remove() {
                        throw ContractUtils.unsupported();
                    }
                };
            }
        };
    }

    private Node enter(Node node, Set<Node> visitedNodes) {
        VerifyArgument.notNull((Object)node, (String)"node");
        VerifyArgument.notNull(visitedNodes, (String)"visitedNodes");
        if (!visitedNodes.add(node)) {
            return null;
        }
        if (node instanceof Label) {
            return this.exit(node, visitedNodes);
        }
        if (node instanceof Expression) {
            Expression e = (Expression)node;
            switch (e.getCode()) {
                case Goto: {
                    TryCatchBlock targetTryBlock;
                    int i;
                    Label target = (Label)e.getOperand();
                    if (CollectionUtilities.firstOrDefault(this.getParents(e, TryCatchBlock.class)) == CollectionUtilities.firstOrDefault(this.getParents(target, TryCatchBlock.class))) {
                        return this.enter(target, visitedNodes);
                    }
                    List sourceTryBlocks = CollectionUtilities.toList(this.getParents(e, TryCatchBlock.class));
                    List targetTryBlocks = CollectionUtilities.toList(this.getParents(target, TryCatchBlock.class));
                    Collections.reverse(sourceTryBlocks);
                    Collections.reverse(targetTryBlocks);
                    for (i = 0; i < sourceTryBlocks.size() && i < targetTryBlocks.size() && sourceTryBlocks.get(i) == targetTryBlocks.get(i); ++i) {
                    }
                    if (i == targetTryBlocks.size()) {
                        return this.enter(target, visitedNodes);
                    }
                    TryCatchBlock current = targetTryBlock = (TryCatchBlock)targetTryBlocks.get(i);
                    block4: while (current != null) {
                        List<Node> body = current.getTryBlock().getBody();
                        current = null;
                        for (Node n : body) {
                            if (n instanceof Label) {
                                if (n != target) continue;
                                return targetTryBlock;
                            }
                            if (PatternMatching.match(n, AstCode.Nop)) continue;
                            current = n instanceof TryCatchBlock ? (TryCatchBlock)n : null;
                            continue block4;
                        }
                    }
                    return null;
                }
            }
            return e;
        }
        if (node instanceof Block) {
            Block block = (Block)node;
            if (block.getEntryGoto() != null) {
                return this.enter(block.getEntryGoto(), visitedNodes);
            }
            if (block.getBody().isEmpty()) {
                return this.exit(block, visitedNodes);
            }
            return this.enter(block.getBody().get(0), visitedNodes);
        }
        if (node instanceof Condition) {
            return ((Condition)node).getCondition();
        }
        if (node instanceof Loop) {
            Loop loop = (Loop)node;
            if (loop.getLoopType() == LoopType.PreCondition && loop.getCondition() != null) {
                return loop.getCondition();
            }
            return this.enter(loop.getBody(), visitedNodes);
        }
        if (node instanceof TryCatchBlock) {
            return node;
        }
        if (node instanceof Switch) {
            return ((Switch)node).getCondition();
        }
        throw Error.unsupportedNode(node);
    }

    private Node exit(Node node, Set<Node> visitedNodes) {
        VerifyArgument.notNull((Object)node, (String)"node");
        VerifyArgument.notNull(visitedNodes, (String)"visitedNodes");
        Node parent = this.parentLookup.get(node);
        if (parent == null || parent == Node.NULL) {
            return null;
        }
        if (parent instanceof Block) {
            Node nextCase;
            Node nextNode = this.nextSibling.get(node);
            if (nextNode != null && nextNode != Node.NULL) {
                return this.enter(nextNode, visitedNodes);
            }
            if (parent instanceof CaseBlock && (nextCase = this.nextSibling.get(parent)) != null && nextCase != Node.NULL) {
                return this.enter(nextCase, visitedNodes);
            }
            return this.exit(parent, visitedNodes);
        }
        if (parent instanceof Condition) {
            return this.exit(parent, visitedNodes);
        }
        if (parent instanceof TryCatchBlock) {
            return this.exit(parent, visitedNodes);
        }
        if (parent instanceof Switch) {
            return null;
        }
        if (parent instanceof Loop) {
            return this.enter(parent, visitedNodes);
        }
        throw Error.unsupportedNode(parent);
    }

    private void transformLeaveStatements(Block method) {
        StrongBox target = new StrongBox();
        LinkedHashSet visitedNodes = new LinkedHashSet();
        for (Expression e : method.getSelfAndChildrenRecursive(Expression.class)) {
            Node grandParent;
            if (!PatternMatching.matchGetOperand(e, AstCode.Goto, target)) continue;
            visitedNodes.clear();
            Node exit = this.exit(e, new HashSet<Node>());
            if (exit == null || !PatternMatching.matchLeaveHandler(exit)) continue;
            Node parent = this.parentLookup.get(e);
            Node node = grandParent = parent != null ? this.parentLookup.get(parent) : null;
            if (!(parent instanceof Block) || !(grandParent instanceof CatchBlock) && !(grandParent instanceof TryCatchBlock) || e != CollectionUtilities.last(((Block)parent).getBody())) continue;
            if (grandParent instanceof TryCatchBlock && parent == ((TryCatchBlock)grandParent).getFinallyBlock()) {
                e.setCode(AstCode.EndFinally);
            } else {
                e.setCode(AstCode.Leave);
            }
            e.setOperand(null);
        }
    }

    public static void removeRedundantCode(Block method) {
        GotoRemoval.removeRedundantCode(method, 0);
    }

    public static void removeRedundantCode(Block method, int options) {
        GotoRemoval gotoRemoval = new GotoRemoval(options);
        gotoRemoval.traverseGraph(method);
        gotoRemoval.removeRedundantCodeCore(method);
    }

    private void removeRedundantCodeCore(Block method) {
        Object body;
        LinkedHashSet<Label> liveLabels = new LinkedHashSet<Label>();
        StrongBox target = new StrongBox();
        LinkedHashSet<Expression> returns = new LinkedHashSet<Expression>();
        DefaultMap jumps = new DefaultMap(CollectionUtilities.listFactory());
        List<TryCatchBlock> tryCatchBlocks = null;
        block0: for (Expression e : method.getSelfAndChildrenRecursive(Expression.class)) {
            if (PatternMatching.matchEmptyReturn(e)) {
                returns.add(e);
            }
            if (!e.isBranch()) continue;
            if (PatternMatching.matchGetOperand(e, AstCode.Goto, target)) {
                if (tryCatchBlocks == null) {
                    tryCatchBlocks = method.getSelfAndChildrenRecursive(TryCatchBlock.class);
                }
                for (TryCatchBlock tryCatchBlock : tryCatchBlocks) {
                    Node firstInBody;
                    Block finallyBlock = tryCatchBlock.getFinallyBlock();
                    if (finallyBlock != null) {
                        firstInBody = (Node)CollectionUtilities.firstOrDefault(finallyBlock.getBody());
                        if (firstInBody != target.get()) continue;
                        e.setCode(AstCode.Leave);
                        e.setOperand(null);
                        continue block0;
                    }
                    if (tryCatchBlock.getCatchBlocks().size() != 1 || (firstInBody = (Node)CollectionUtilities.firstOrDefault(((CatchBlock)CollectionUtilities.first(tryCatchBlock.getCatchBlocks())).getBody())) != target.get()) continue;
                    e.setCode(AstCode.Leave);
                    e.setOperand(null);
                    continue block0;
                }
            }
            List<Label> branchTargets = e.getBranchTargets();
            for (Label label : branchTargets) {
                ((List)jumps.get(label)).add(e);
            }
            liveLabels.addAll(branchTargets);
        }
        boolean mergeAdjacentLabels = Flags.testAny(this.options, 1);
        for (Block block : method.getSelfAndChildrenRecursive(Block.class)) {
            body = block.getBody();
            for (int i = 0; i < body.size(); ++i) {
                Node n = body.get(i);
                if (PatternMatching.match(n, AstCode.Nop) || PatternMatching.match(n, AstCode.Leave) || PatternMatching.match(n, AstCode.EndFinally) || n instanceof Label && !liveLabels.contains(n)) {
                    body.remove(i--);
                }
                if (!mergeAdjacentLabels || !(n instanceof Label) || i >= body.size() - 1 || !(body.get(i + 1) instanceof Label)) continue;
                Label newLabel = (Label)n;
                Label oldLabel = (Label)body.remove(i + 1);
                List oldLabelJumps = (List)jumps.get(oldLabel);
                for (Expression jump : oldLabelJumps) {
                    if (jump.getOperand() instanceof Label) {
                        jump.setOperand(n);
                        continue;
                    }
                    Label[] branchTargets = (Label[])jump.getOperand();
                    for (int j = 0; j < branchTargets.length; ++j) {
                        if (branchTargets[j] != oldLabel) continue;
                        branchTargets[j] = newLabel;
                    }
                }
            }
        }
        for (Loop loop : method.getSelfAndChildrenRecursive(Loop.class)) {
            Condition condition;
            Block falseBlock;
            body = loop.getBody();
            Node lastInLoop = (Node)CollectionUtilities.lastOrDefault(((Block)body).getBody());
            if (lastInLoop == null) continue;
            if (PatternMatching.match(lastInLoop, AstCode.LoopContinue)) {
                Expression last = (Expression)CollectionUtilities.last(((Block)body).getBody());
                if (last.getOperand() != null) continue;
                ((Block)body).getBody().remove(last);
                continue;
            }
            if (!(lastInLoop instanceof Condition) || !PatternMatching.matchSingle(falseBlock = (condition = (Condition)lastInLoop).getFalseBlock(), AstCode.LoopContinue, target) || target.get() != null) continue;
            falseBlock.getBody().clear();
        }
        for (Switch switchNode : method.getSelfAndChildrenRecursive(Switch.class)) {
            Block defaultCase = null;
            List<CaseBlock> caseBlocks = switchNode.getCaseBlocks();
            for (CaseBlock caseBlock : caseBlocks) {
                List<Node> caseBody;
                int size;
                assert (caseBlock.getEntryGoto() == null);
                if (caseBlock.getValues().isEmpty()) {
                    defaultCase = caseBlock;
                }
                if ((size = (caseBody = caseBlock.getBody()).size()) < 2 || !caseBody.get(size - 2).isUnconditionalControlFlow() || !PatternMatching.match(caseBody.get(size - 1), AstCode.LoopOrSwitchBreak)) continue;
                caseBody.remove(size - 1);
            }
            if (defaultCase != null && (defaultCase.getBody().size() != 1 || !PatternMatching.match((Node)CollectionUtilities.firstOrDefault(defaultCase.getBody()), AstCode.LoopOrSwitchBreak))) continue;
            for (int i = 0; i < caseBlocks.size(); ++i) {
                List<Node> body2 = caseBlocks.get(i).getBody();
                if (body2.size() != 1 || !PatternMatching.matchGetOperand((Node)CollectionUtilities.firstOrDefault(body2), AstCode.LoopOrSwitchBreak, target) || target.get() != null) continue;
                caseBlocks.remove(i--);
            }
        }
        List<Node> methodBody = method.getBody();
        Node lastStatement = (Node)CollectionUtilities.lastOrDefault(methodBody);
        if (PatternMatching.match(lastStatement, AstCode.Return) && ((Expression)lastStatement).getArguments().isEmpty()) {
            methodBody.remove(methodBody.size() - 1);
            returns.remove(lastStatement);
        }
        boolean modified = false;
        for (Block block : method.getSelfAndChildrenRecursive(Block.class)) {
            List<Node> blockBody = block.getBody();
            for (int i = 0; i < blockBody.size() - 1; ++i) {
                Node node = blockBody.get(i);
                if (!node.isUnconditionalControlFlow() || !PatternMatching.match(blockBody.get(i + 1), AstCode.Return) && !PatternMatching.match(blockBody.get(i + 1), AstCode.AThrow)) continue;
                modified = true;
                blockBody.remove(i-- + 1);
                returns.remove(blockBody.get(i + 1));
            }
        }
        if (Flags.testAny(this.options, 2)) {
            for (Expression r : returns) {
                Node immediateParent = this.parentLookup.get(r);
                Node current = r;
                Node parent = immediateParent;
                boolean firstBlock = true;
                boolean isRedundant = true;
                while (parent != null && parent != Node.NULL) {
                    if (parent instanceof BasicBlock || parent instanceof Block) {
                        Node last;
                        List<Node> body3;
                        List<Node> list = body3 = parent instanceof BasicBlock ? ((BasicBlock)parent).getBody() : ((Block)parent).getBody();
                        if (firstBlock) {
                            Condition c;
                            Node grandparent = this.parentLookup.get(parent);
                            if (grandparent instanceof Condition && (c = (Condition)grandparent).getTrueBlock().getBody().size() == 1 && r == CollectionUtilities.last(c.getTrueBlock().getBody()) && (PatternMatching.matchNullOrEmpty(c.getFalseBlock()) || PatternMatching.matchEmptyReturn(c.getFalseBlock()))) {
                                isRedundant = false;
                                break;
                            }
                            firstBlock = false;
                        }
                        if ((last = (Node)CollectionUtilities.last(body3)) != current) {
                            if (PatternMatching.matchEmptyReturn(last) && body3.size() > 1 && body3.get(body3.size() - 2) == current) break;
                            isRedundant = false;
                            break;
                        }
                    }
                    current = parent;
                    parent = this.parentLookup.get(current);
                }
                if (!isRedundant) continue;
                if (immediateParent instanceof Block) {
                    ((Block)immediateParent).getBody().remove(r);
                    continue;
                }
                if (!(immediateParent instanceof BasicBlock)) continue;
                ((BasicBlock)immediateParent).getBody().remove(r);
            }
        }
        if (modified) {
            this.removeGotosCore(method);
        }
    }
}

