/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.engine;

import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.resource.CasManager;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;

public class CPECasPool {
    private Vector mAllInstances = new Vector();
    private Vector mFreeInstances = new Vector();
    private LinkedList checkedOutInstances = new LinkedList();
    private final int mNumInstances;

    public CPECasPool(int aNumInstances, CasManager aCasManager) throws ResourceInitializationException {
        this.mNumInstances = aNumInstances;
        this.fillPool(aCasManager, UIMAFramework.getDefaultPerformanceTuningProperties());
    }

    public CPECasPool(int aNumInstances, CasManager aCasManager, Properties aPerformanceTuningSettings) throws ResourceInitializationException {
        this.mNumInstances = aNumInstances;
        this.fillPool(aCasManager, aPerformanceTuningSettings);
    }

    protected void fillPool(CasManager aCasManager, Properties aPerformanceTuningSettings) throws ResourceInitializationException {
        for (int i = 0; i < this.mNumInstances; ++i) {
            CAS c = aCasManager.createNewCas(aPerformanceTuningSettings);
            this.mAllInstances.add(c);
            this.mFreeInstances.add(c);
        }
    }

    public synchronized CAS getCas(long aTimeout) {
        CAS cas = this.getCas();
        if (cas != null) {
            return cas;
        }
        try {
            this.wait(aTimeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.getCas();
    }

    public synchronized CAS getCas() {
        if (!this.mFreeInstances.isEmpty()) {
            CAS cas = (CAS)this.mFreeInstances.remove(0);
            if (cas != null) {
                this.checkedOutInstances.add(cas);
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_add_cas_to_checkedout_list__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(this.checkedOutInstances.size())});
                }
            }
            return cas;
        }
        return null;
    }

    public synchronized void releaseCas(CAS aCas) {
        if (!this.mAllInstances.contains(aCas) || this.mFreeInstances.contains(aCas)) {
            if (UIMAFramework.getLogger().isLoggable(Level.WARNING)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_invalid_checkin__WARNING", new Object[]{Thread.currentThread().getName()});
            }
        } else {
            aCas.reset();
            this.mFreeInstances.add(aCas);
            int index = this.checkedOutInstances.indexOf(aCas);
            if (index != -1) {
                this.checkedOutInstances.remove(index);
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_removed_from_checkedout_list__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(this.checkedOutInstances.size())});
                }
            }
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_return_cas_to_pool__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(this.checkedOutInstances.size())});
            }
            this.notifyAll();
        }
    }

    public synchronized int getCheckedOutCasCount() {
        return this.checkedOutInstances.size();
    }

    public synchronized CAS getCheckedOutCas(int aIndex) {
        if (aIndex > this.checkedOutInstances.size()) {
            return null;
        }
        return (CAS)this.checkedOutInstances.get(aIndex);
    }

    public int getSize() {
        return this.mNumInstances;
    }
}

