/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.SideEffectCapable;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class SubgraphStep
extends SideEffectBarrierStep<Edge>
implements SideEffectCapable {
    private static final Set<TraverserRequirement> REQUIREMENTS = EnumSet.of(TraverserRequirement.OBJECT, TraverserRequirement.SIDE_EFFECTS);
    private Graph subgraph;
    private String sideEffectKey;
    private Graph.Features.VertexFeatures parentGraphFeatures;
    private boolean subgraphSupportsMetaProperties = false;
    private static final Map<String, Object> DEFAULT_CONFIGURATION = new HashMap<String, Object>(){
        {
            this.put("gremlin.graph", "org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph");
        }
    };

    public SubgraphStep(Traversal.Admin traversal, String sideEffectKey) {
        super(traversal);
        this.sideEffectKey = sideEffectKey;
        this.getTraversal().asAdmin().getSideEffects().registerIfAbsent(this.sideEffectKey, () -> GraphFactory.open(DEFAULT_CONFIGURATION), Operator.assign);
    }

    @Override
    protected void sideEffect(Traverser.Admin<Edge> traverser) {
        this.parentGraphFeatures = this.traversal.getGraph().get().features().vertex();
        if (null == this.subgraph) {
            this.subgraph = (Graph)traverser.sideEffects(this.sideEffectKey);
            if (!this.subgraph.features().vertex().supportsUserSuppliedIds() || !this.subgraph.features().edge().supportsUserSuppliedIds()) {
                throw new IllegalArgumentException("The provided subgraph must support user supplied ids for vertices and edges: " + this.subgraph);
            }
        }
        this.subgraphSupportsMetaProperties = this.subgraph.features().vertex().supportsMetaProperties();
        this.addEdgeToSubgraph((Edge)traverser.get());
    }

    @Override
    public String getSideEffectKey() {
        return this.sideEffectKey;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.sideEffectKey);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return REQUIREMENTS;
    }

    @Override
    public SubgraphStep clone() {
        SubgraphStep clone = (SubgraphStep)super.clone();
        this.subgraph = null;
        return clone;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.sideEffectKey.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vertex getOrCreate(Vertex vertex) {
        Iterator<Vertex> vertexIterator = this.subgraph.vertices(vertex.id());
        try {
            if (vertexIterator.hasNext()) {
                Vertex vertex2 = vertexIterator.next();
                return vertex2;
            }
        }
        finally {
            CloseableIterator.closeIterator(vertexIterator);
        }
        Vertex subgraphVertex = this.subgraph.addVertex(T.id, vertex.id(), T.label, vertex.label());
        vertex.properties(new String[0]).forEachRemaining(vertexProperty -> {
            VertexProperty.Cardinality cardinality = this.parentGraphFeatures.getCardinality(vertexProperty.key());
            VertexProperty subgraphVertexProperty = subgraphVertex.property(cardinality, vertexProperty.key(), vertexProperty.value(), T.id, vertexProperty.id());
            if (this.parentGraphFeatures.supportsMetaProperties() && this.subgraphSupportsMetaProperties) {
                vertexProperty.properties(new String[0]).forEachRemaining(property -> subgraphVertexProperty.property(property.key(), property.value()));
            }
        });
        return subgraphVertex;
    }

    private void addEdgeToSubgraph(Edge edge) {
        Iterator<Edge> edgeIterator = this.subgraph.edges(edge.id());
        try {
            if (edgeIterator.hasNext()) {
                return;
            }
        }
        finally {
            CloseableIterator.closeIterator(edgeIterator);
        }
        Iterator<Vertex> vertexIterator = edge.vertices(Direction.BOTH);
        Vertex subGraphOutVertex = this.getOrCreate(vertexIterator.next());
        Vertex subGraphInVertex = this.getOrCreate(vertexIterator.next());
        Edge subGraphEdge = subGraphOutVertex.addEdge(edge.label(), subGraphInVertex, T.id, edge.id());
        edge.properties(new String[0]).forEachRemaining(property -> subGraphEdge.property(property.key(), property.value()));
    }
}

