/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.jsr223;

import org.apache.tinkerpop.gremlin.jsr223.Customizer;

class CompilationOptionsCustomizer
implements Customizer {
    private final long expectedCompilationTime;
    private final String cacheSpecification;
    private final boolean globalFunctionCacheEnabled;

    private CompilationOptionsCustomizer(Builder builder) {
        this.expectedCompilationTime = builder.expectedCompilationTime;
        this.cacheSpecification = builder.cacheSpecification;
        this.globalFunctionCacheEnabled = builder.globalFunctionCacheEnabled;
    }

    public long getExpectedCompilationTime() {
        return this.expectedCompilationTime;
    }

    public String getClassMapCacheSpecification() {
        return this.cacheSpecification;
    }

    public boolean isGlobalFunctionCacheEnabled() {
        return this.globalFunctionCacheEnabled;
    }

    public static Builder build() {
        return new Builder();
    }

    public static class Builder {
        private long expectedCompilationTime;
        private String cacheSpecification = "softValues";
        private boolean globalFunctionCacheEnabled = true;

        public Builder setExpectedCompilationTime(long expectedCompilationTime) {
            this.expectedCompilationTime = expectedCompilationTime;
            return this;
        }

        public Builder setClassMapCacheSpecification(String cacheSpecification) {
            this.cacheSpecification = cacheSpecification;
            return this;
        }

        public Builder enableGlobalFunctionCache(boolean enabled) {
            this.globalFunctionCacheEnabled = enabled;
            return this;
        }

        public CompilationOptionsCustomizer create() {
            return new CompilationOptionsCustomizer(this);
        }
    }
}

