/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.logging.proto;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.VersionInfo;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.dag.impl.ServicePluginInfo;
import org.apache.tez.dag.app.dag.impl.VertexStats;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.events.AMLaunchedEvent;
import org.apache.tez.dag.history.events.AMStartedEvent;
import org.apache.tez.dag.history.events.AppLaunchedEvent;
import org.apache.tez.dag.history.events.ContainerLaunchedEvent;
import org.apache.tez.dag.history.events.ContainerStoppedEvent;
import org.apache.tez.dag.history.events.DAGFinishedEvent;
import org.apache.tez.dag.history.events.DAGInitializedEvent;
import org.apache.tez.dag.history.events.DAGRecoveredEvent;
import org.apache.tez.dag.history.events.DAGStartedEvent;
import org.apache.tez.dag.history.events.DAGSubmittedEvent;
import org.apache.tez.dag.history.events.TaskAttemptFinishedEvent;
import org.apache.tez.dag.history.events.TaskAttemptStartedEvent;
import org.apache.tez.dag.history.events.TaskFinishedEvent;
import org.apache.tez.dag.history.events.TaskStartedEvent;
import org.apache.tez.dag.history.events.VertexConfigurationDoneEvent;
import org.apache.tez.dag.history.events.VertexFinishedEvent;
import org.apache.tez.dag.history.events.VertexInitializedEvent;
import org.apache.tez.dag.history.events.VertexStartedEvent;
import org.apache.tez.dag.history.logging.proto.HistoryLoggerProtos;
import org.apache.tez.dag.history.utils.DAGUtils;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryEventProtoConverter {
    private static final Logger log = LoggerFactory.getLogger(HistoryEventProtoConverter.class);
    private final ObjectMapper mapper = new ObjectMapper();

    public HistoryLoggerProtos.HistoryEventProto convert(HistoryEvent historyEvent) {
        this.validateEvent(historyEvent);
        switch (historyEvent.getEventType()) {
            case APP_LAUNCHED: {
                return this.convertAppLaunchedEvent((AppLaunchedEvent)historyEvent);
            }
            case AM_LAUNCHED: {
                return this.convertAMLaunchedEvent((AMLaunchedEvent)historyEvent);
            }
            case AM_STARTED: {
                return this.convertAMStartedEvent((AMStartedEvent)historyEvent);
            }
            case CONTAINER_LAUNCHED: {
                return this.convertContainerLaunchedEvent((ContainerLaunchedEvent)historyEvent);
            }
            case CONTAINER_STOPPED: {
                return this.convertContainerStoppedEvent((ContainerStoppedEvent)historyEvent);
            }
            case DAG_SUBMITTED: {
                return this.convertDAGSubmittedEvent((DAGSubmittedEvent)historyEvent);
            }
            case DAG_INITIALIZED: {
                return this.convertDAGInitializedEvent((DAGInitializedEvent)historyEvent);
            }
            case DAG_STARTED: {
                return this.convertDAGStartedEvent((DAGStartedEvent)historyEvent);
            }
            case DAG_FINISHED: {
                return this.convertDAGFinishedEvent((DAGFinishedEvent)historyEvent);
            }
            case VERTEX_INITIALIZED: {
                return this.convertVertexInitializedEvent((VertexInitializedEvent)historyEvent);
            }
            case VERTEX_STARTED: {
                return this.convertVertexStartedEvent((VertexStartedEvent)historyEvent);
            }
            case VERTEX_FINISHED: {
                return this.convertVertexFinishedEvent((VertexFinishedEvent)historyEvent);
            }
            case TASK_STARTED: {
                return this.convertTaskStartedEvent((TaskStartedEvent)historyEvent);
            }
            case TASK_FINISHED: {
                return this.convertTaskFinishedEvent((TaskFinishedEvent)historyEvent);
            }
            case TASK_ATTEMPT_STARTED: {
                return this.convertTaskAttemptStartedEvent((TaskAttemptStartedEvent)historyEvent);
            }
            case TASK_ATTEMPT_FINISHED: {
                return this.convertTaskAttemptFinishedEvent((TaskAttemptFinishedEvent)historyEvent);
            }
            case VERTEX_CONFIGURE_DONE: {
                return this.convertVertexReconfigureDoneEvent((VertexConfigurationDoneEvent)historyEvent);
            }
            case DAG_RECOVERED: {
                return this.convertDAGRecoveredEvent((DAGRecoveredEvent)historyEvent);
            }
            case VERTEX_COMMIT_STARTED: 
            case VERTEX_GROUP_COMMIT_STARTED: 
            case VERTEX_GROUP_COMMIT_FINISHED: 
            case DAG_COMMIT_STARTED: 
            case DAG_KILL_REQUEST: {
                throw new UnsupportedOperationException("Invalid Event, does not support history, eventType=" + historyEvent.getEventType());
            }
        }
        throw new UnsupportedOperationException("Unhandled Event, eventType=" + historyEvent.getEventType());
    }

    private void validateEvent(HistoryEvent event) {
        if (!event.isHistoryEvent()) {
            throw new UnsupportedOperationException("Invalid Event, does not support history, eventType=" + event.getEventType());
        }
    }

    private HistoryLoggerProtos.HistoryEventProto.Builder makeBuilderForEvent(HistoryEvent event, long time, TezDAGID dagId, ApplicationId appId, ApplicationAttemptId appAttemptId, TezVertexID vertexId, TezTaskID taskId, TezTaskAttemptID taskAttemptId, String user) {
        HistoryLoggerProtos.HistoryEventProto.Builder builder = HistoryLoggerProtos.HistoryEventProto.newBuilder();
        builder.setEventType(event.getEventType().name());
        builder.setEventTime(time);
        if (taskAttemptId != null) {
            builder.setTaskAttemptId(taskAttemptId.toString());
            taskId = taskAttemptId.getTaskID();
        }
        if (taskId != null) {
            builder.setTaskId(taskId.toString());
            vertexId = taskId.getVertexID();
        }
        if (vertexId != null) {
            builder.setVertexId(vertexId.toString());
            dagId = vertexId.getDAGId();
        }
        if (dagId != null) {
            builder.setDagId(dagId.toString());
            if (appId == null) {
                appId = dagId.getApplicationId();
            }
        }
        if (appAttemptId != null) {
            builder.setAppAttemptId(appAttemptId.toString());
            if (appId == null) {
                appId = appAttemptId.getApplicationId();
            }
        }
        if (appId != null) {
            builder.setAppId(appId.toString());
        }
        if (user != null) {
            builder.setUser(user);
        }
        return builder;
    }

    private void addEventData(HistoryLoggerProtos.HistoryEventProto.Builder builder, String key, String value) {
        if (value == null) {
            return;
        }
        builder.addEventData(HistoryLoggerProtos.KVPair.newBuilder().setKey(key).setValue(value));
    }

    private void addEventData(HistoryLoggerProtos.HistoryEventProto.Builder builder, String key, Number value) {
        builder.addEventData(HistoryLoggerProtos.KVPair.newBuilder().setKey(key).setValue(value.toString()));
    }

    private void addEventData(HistoryLoggerProtos.HistoryEventProto.Builder builder, String key, Map<String, Object> value) {
        try {
            builder.addEventData(HistoryLoggerProtos.KVPair.newBuilder().setKey(key).setValue(this.mapper.writeValueAsString(value)));
        }
        catch (IOException e) {
            log.error("Error converting value for key {} to json: ", (Object)key, (Object)e);
        }
    }

    private HistoryLoggerProtos.HistoryEventProto convertAppLaunchedEvent(AppLaunchedEvent event) {
        HistoryLoggerProtos.HistoryEventProto.Builder builder = this.makeBuilderForEvent((HistoryEvent)event, event.getLaunchTime(), null, event.getApplicationId(), null, null, null, null, event.getUser());
        Map confMap = DAGUtils.convertConfigurationToATSMap((Configuration)event.getConf());
        this.addEventData(builder, "config", confMap);
        if (event.getVersion() != null) {
            this.addEventData(builder, "tezVersion", DAGUtils.convertTezVersionToATSMap((VersionInfo)event.getVersion()));
        }
        this.addEventData(builder, "amWebServiceVersion", "2");
        return builder.build();
    }

    private HistoryLoggerProtos.HistoryEventProto convertAMLaunchedEvent(AMLaunchedEvent event) {
        HistoryLoggerProtos.HistoryEventProto.Builder builder = this.makeBuilderForEvent((HistoryEvent)event, event.getLaunchTime(), null, null, event.getApplicationAttemptId(), null, null, null, event.getUser());
        this.addEventData(builder, "appSubmitTime", event.getAppSubmitTime());
        return builder.build();
    }

    private HistoryLoggerProtos.HistoryEventProto convertAMStartedEvent(AMStartedEvent event) {
        HistoryLoggerProtos.HistoryEventProto.Builder builder = this.makeBuilderForEvent((HistoryEvent)event, event.getStartTime(), null, null, event.getApplicationAttemptId(), null, null, null, event.getUser());
        return builder.build();
    }

    private HistoryLoggerProtos.HistoryEventProto convertContainerLaunchedEvent(ContainerLaunchedEvent event) {
        HistoryLoggerProtos.HistoryEventProto.Builder builder = this.makeBuilderForEvent((HistoryEvent)event, event.getLaunchTime(), null, null, event.getApplicationAttemptId(), null, null, null, null);
        this.addEventData(builder, "containerId", event.getContainerId().toString());
        return builder.build();
    }

    private HistoryLoggerProtos.HistoryEventProto convertContainerStoppedEvent(ContainerStoppedEvent event) {
        HistoryLoggerProtos.HistoryEventProto.Builder builder = this.makeBuilderForEvent((HistoryEvent)event, event.getStoppedTime(), null, null, event.getApplicationAttemptId(), null, null, null, null);
        this.addEventData(builder, "containerId", event.getContainerId().toString());
        this.addEventData(builder, "exitStatus", event.getExitStatus());
        this.addEventData(builder, "endTime", event.getStoppedTime());
        return builder.build();
    }

    private HistoryLoggerProtos.HistoryEventProto convertDAGSubmittedEvent(DAGSubmittedEvent event) {
        HistoryLoggerProtos.HistoryEventProto.Builder builder = this.makeBuilderForEvent((HistoryEvent)event, event.getSubmitTime(), event.getDagID(), null, event.getApplicationAttemptId(), null, null, null, event.getUser());
        this.addEventData(builder, "dagName", event.getDAGName());
        if (event.getDAGPlan().hasCallerContext() && event.getDAGPlan().getCallerContext().hasCallerId()) {
            DAGProtos.CallerContextProto callerContext = event.getDagPlan().getCallerContext();
            this.addEventData(builder, "callerId", callerContext.getCallerId());
            this.addEventData(builder, "callerType", callerContext.getCallerType());
            this.addEventData(builder, "callerContext", callerContext.getContext());
        }
        if (event.getQueueName() != null) {
            this.addEventData(builder, "queueName", event.getQueueName());
        }
        this.addEventData(builder, "amWebServiceVersion", "2");
        this.addEventData(builder, "inProgressLogsURL_" + event.getApplicationAttemptId().getAttemptId(), event.getContainerLogs());
        try {
            this.addEventData(builder, "dagPlan", DAGUtils.convertDAGPlanToATSMap((DAGProtos.DAGPlan)event.getDAGPlan()));
        }
        catch (IOException e) {
            throw new TezUncheckedException((Throwable)e);
        }
        return builder.build();
    }

    private HistoryLoggerProtos.HistoryEventProto convertDAGInitializedEvent(DAGInitializedEvent event) {
        HistoryLoggerProtos.HistoryEventProto.Builder builder = this.makeBuilderForEvent((HistoryEvent)event, event.getInitTime(), event.getDagID(), null, null, null, null, null, event.getUser());
        this.addEventData(builder, "dagName", event.getDagName());
        if (event.getVertexNameIDMap() != null) {
            TreeMap<String, Object> nameIdStrMap = new TreeMap<String, Object>();
            for (Map.Entry entry : event.getVertexNameIDMap().entrySet()) {
                nameIdStrMap.put((String)entry.getKey(), ((TezVertexID)entry.getValue()).toString());
            }
            this.addEventData(builder, "vertexNameIdMapping", nameIdStrMap);
        }
        return builder.build();
    }

    private HistoryLoggerProtos.HistoryEventProto convertDAGStartedEvent(DAGStartedEvent event) {
        HistoryLoggerProtos.HistoryEventProto.Builder builder = this.makeBuilderForEvent((HistoryEvent)event, event.getStartTime(), event.getDagID(), null, null, null, null, null, event.getUser());
        this.addEventData(builder, "dagName", event.getDagName());
        this.addEventData(builder, "status", event.getDagState().name());
        return builder.build();
    }

    private HistoryLoggerProtos.HistoryEventProto convertDAGFinishedEvent(DAGFinishedEvent event) {
        HistoryLoggerProtos.HistoryEventProto.Builder builder = this.makeBuilderForEvent((HistoryEvent)event, event.getFinishTime(), event.getDagID(), null, event.getApplicationAttemptId(), null, null, null, event.getUser());
        this.addEventData(builder, "dagName", event.getDagName());
        if (event.getDAGPlan().hasCallerContext()) {
            if (event.getDAGPlan().getCallerContext().hasCallerType()) {
                this.addEventData(builder, "callerType", event.getDAGPlan().getCallerContext().getCallerType());
            }
            if (event.getDAGPlan().getCallerContext().hasCallerId()) {
                this.addEventData(builder, "callerId", event.getDAGPlan().getCallerContext().getCallerId());
            }
        }
        this.addEventData(builder, "startTime", event.getStartTime());
        this.addEventData(builder, "timeTaken", event.getFinishTime() - event.getStartTime());
        this.addEventData(builder, "status", event.getState().name());
        this.addEventData(builder, "diagnostics", event.getDiagnostics());
        this.addEventData(builder, "completionApplicationAttemptId", event.getApplicationAttemptId().toString());
        this.addEventData(builder, "counters", DAGUtils.convertCountersToATSMap((TezCounters)event.getTezCounters()));
        Map dagTaskStats = event.getDagTaskStats();
        if (dagTaskStats != null) {
            for (Map.Entry entry : dagTaskStats.entrySet()) {
                this.addEventData(builder, (String)entry.getKey(), (Number)entry.getValue());
            }
        }
        return builder.build();
    }

    private HistoryLoggerProtos.HistoryEventProto convertTaskAttemptStartedEvent(TaskAttemptStartedEvent event) {
        HistoryLoggerProtos.HistoryEventProto.Builder builder = this.makeBuilderForEvent((HistoryEvent)event, event.getStartTime(), null, null, null, null, null, event.getTaskAttemptID(), null);
        if (event.getInProgressLogsUrl() != null) {
            this.addEventData(builder, "inProgressLogsURL", event.getInProgressLogsUrl());
        }
        if (event.getCompletedLogsUrl() != null) {
            this.addEventData(builder, "completedLogsURL", event.getCompletedLogsUrl());
        }
        this.addEventData(builder, "nodeId", event.getNodeId().toString());
        this.addEventData(builder, "nodeHttpAddress", event.getNodeHttpAddress());
        this.addEventData(builder, "containerId", event.getContainerId().toString());
        this.addEventData(builder, "status", TaskAttemptState.RUNNING.name());
        return builder.build();
    }

    private HistoryLoggerProtos.HistoryEventProto convertTaskAttemptFinishedEvent(TaskAttemptFinishedEvent event) {
        HistoryLoggerProtos.HistoryEventProto.Builder builder = this.makeBuilderForEvent((HistoryEvent)event, event.getFinishTime(), null, null, null, null, null, event.getTaskAttemptID(), null);
        this.addEventData(builder, "status", event.getState().name());
        if (event.getTaskFailureType() != null) {
            this.addEventData(builder, "taskFailureType", event.getTaskFailureType().name());
        }
        this.addEventData(builder, "creationTime", event.getCreationTime());
        this.addEventData(builder, "allocationTime", event.getAllocationTime());
        this.addEventData(builder, "startTime", event.getStartTime());
        if (event.getCreationCausalTA() != null) {
            this.addEventData(builder, "creationCausalAttempt", event.getCreationCausalTA().toString());
        }
        this.addEventData(builder, "timeTaken", event.getFinishTime() - event.getStartTime());
        if (event.getTaskAttemptError() != null) {
            this.addEventData(builder, "taskAttemptErrorEnum", event.getTaskAttemptError().name());
        }
        this.addEventData(builder, "diagnostics", event.getDiagnostics());
        this.addEventData(builder, "counters", DAGUtils.convertCountersToATSMap((TezCounters)event.getCounters()));
        if (event.getDataEvents() != null && !event.getDataEvents().isEmpty()) {
            this.addEventData(builder, "lastDataEvents", DAGUtils.convertDataEventDependecyInfoToATS((List)event.getDataEvents()));
        }
        if (event.getNodeId() != null) {
            this.addEventData(builder, "nodeId", event.getNodeId().toString());
        }
        if (event.getContainerId() != null) {
            this.addEventData(builder, "containerId", event.getContainerId().toString());
        }
        if (event.getInProgressLogsUrl() != null) {
            this.addEventData(builder, "inProgressLogsURL", event.getInProgressLogsUrl());
        }
        if (event.getCompletedLogsUrl() != null) {
            this.addEventData(builder, "completedLogsURL", event.getCompletedLogsUrl());
        }
        if (event.getNodeHttpAddress() != null) {
            this.addEventData(builder, "nodeHttpAddress", event.getNodeHttpAddress());
        }
        return builder.build();
    }

    private HistoryLoggerProtos.HistoryEventProto convertTaskFinishedEvent(TaskFinishedEvent event) {
        HistoryLoggerProtos.HistoryEventProto.Builder builder = this.makeBuilderForEvent((HistoryEvent)event, event.getFinishTime(), null, null, null, null, event.getTaskID(), null, null);
        this.addEventData(builder, "timeTaken", event.getFinishTime() - event.getStartTime());
        this.addEventData(builder, "status", event.getState().name());
        this.addEventData(builder, "numFailedTaskAttempts", event.getNumFailedAttempts());
        if (event.getSuccessfulAttemptID() != null) {
            this.addEventData(builder, "successfulAttemptId", event.getSuccessfulAttemptID().toString());
        }
        this.addEventData(builder, "diagnostics", event.getDiagnostics());
        this.addEventData(builder, "counters", DAGUtils.convertCountersToATSMap((TezCounters)event.getTezCounters()));
        return builder.build();
    }

    private HistoryLoggerProtos.HistoryEventProto convertTaskStartedEvent(TaskStartedEvent event) {
        HistoryLoggerProtos.HistoryEventProto.Builder builder = this.makeBuilderForEvent((HistoryEvent)event, event.getStartTime(), null, null, null, null, event.getTaskID(), null, null);
        this.addEventData(builder, "scheduledTime", event.getScheduledTime());
        this.addEventData(builder, "status", event.getState().name());
        return builder.build();
    }

    private HistoryLoggerProtos.HistoryEventProto convertVertexFinishedEvent(VertexFinishedEvent event) {
        Map vertexTaskStats;
        HistoryLoggerProtos.HistoryEventProto.Builder builder = this.makeBuilderForEvent((HistoryEvent)event, event.getFinishTime(), null, null, null, event.getVertexID(), null, null, null);
        this.addEventData(builder, "status", event.getState().name());
        this.addEventData(builder, "vertexName", event.getVertexName());
        this.addEventData(builder, "timeTaken", event.getFinishTime() - event.getStartTime());
        this.addEventData(builder, "diagnostics", event.getDiagnostics());
        this.addEventData(builder, "counters", DAGUtils.convertCountersToATSMap((TezCounters)event.getTezCounters()));
        this.addEventData(builder, "stats", DAGUtils.convertVertexStatsToATSMap((VertexStats)event.getVertexStats()));
        if (event.getServicePluginInfo() != null) {
            this.addEventData(builder, "servicePlugin", DAGUtils.convertServicePluginToATSMap((ServicePluginInfo)event.getServicePluginInfo()));
        }
        if ((vertexTaskStats = event.getVertexTaskStats()) != null) {
            for (Map.Entry entry : vertexTaskStats.entrySet()) {
                this.addEventData(builder, (String)entry.getKey(), (Number)entry.getValue());
            }
        }
        return builder.build();
    }

    private HistoryLoggerProtos.HistoryEventProto convertVertexInitializedEvent(VertexInitializedEvent event) {
        HistoryLoggerProtos.HistoryEventProto.Builder builder = this.makeBuilderForEvent((HistoryEvent)event, event.getInitedTime(), null, null, null, event.getVertexID(), null, null, null);
        this.addEventData(builder, "vertexName", event.getVertexName());
        this.addEventData(builder, "initRequestedTime", event.getInitRequestedTime());
        this.addEventData(builder, "numTasks", event.getNumTasks());
        this.addEventData(builder, "processorClassName", event.getProcessorName());
        if (event.getServicePluginInfo() != null) {
            this.addEventData(builder, "servicePlugin", DAGUtils.convertServicePluginToATSMap((ServicePluginInfo)event.getServicePluginInfo()));
        }
        return builder.build();
    }

    private HistoryLoggerProtos.HistoryEventProto convertVertexStartedEvent(VertexStartedEvent event) {
        HistoryLoggerProtos.HistoryEventProto.Builder builder = this.makeBuilderForEvent((HistoryEvent)event, event.getStartTime(), null, null, null, event.getVertexID(), null, null, null);
        this.addEventData(builder, "startRequestedTime", event.getStartRequestedTime());
        this.addEventData(builder, "status", event.getVertexState().name());
        return builder.build();
    }

    private HistoryLoggerProtos.HistoryEventProto convertVertexReconfigureDoneEvent(VertexConfigurationDoneEvent event) {
        HistoryLoggerProtos.HistoryEventProto.Builder builder = this.makeBuilderForEvent((HistoryEvent)event, event.getReconfigureDoneTime(), null, null, null, event.getVertexID(), null, null, null);
        if (event.getSourceEdgeProperties() != null && !event.getSourceEdgeProperties().isEmpty()) {
            HashMap<String, Object> updatedEdgeManagers = new HashMap<String, Object>();
            for (Map.Entry entry : event.getSourceEdgeProperties().entrySet()) {
                updatedEdgeManagers.put((String)entry.getKey(), DAGUtils.convertEdgeProperty((EdgeProperty)((EdgeProperty)entry.getValue())));
            }
            this.addEventData(builder, "updatedEdgeManagers", updatedEdgeManagers);
        }
        this.addEventData(builder, "numTasks", event.getNumTasks());
        return builder.build();
    }

    private HistoryLoggerProtos.HistoryEventProto convertDAGRecoveredEvent(DAGRecoveredEvent event) {
        HistoryLoggerProtos.HistoryEventProto.Builder builder = this.makeBuilderForEvent((HistoryEvent)event, event.getRecoveredTime(), event.getDagID(), null, event.getApplicationAttemptId(), null, null, null, event.getUser());
        this.addEventData(builder, "dagName", event.getDagName());
        if (event.getRecoveredDagState() != null) {
            this.addEventData(builder, "dagState", event.getRecoveredDagState().name());
        }
        if (event.getRecoveryFailureReason() != null) {
            this.addEventData(builder, "recoveryFailureReason", event.getRecoveryFailureReason());
        }
        this.addEventData(builder, "inProgressLogsURL_" + event.getApplicationAttemptId().getAttemptId(), event.getContainerLogs());
        return builder.build();
    }
}

