/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.orderedgrouped;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.SecretKey;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.tez.common.CallableWithNdc;
import org.apache.tez.common.GuavaShim;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.http.HttpConnectionParams;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.events.InputReadErrorEvent;
import org.apache.tez.runtime.library.common.CompositeInputAttemptIdentifier;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.TezRuntimeUtils;
import org.apache.tez.runtime.library.common.shuffle.HostPort;
import org.apache.tez.runtime.library.common.shuffle.InputAttemptFetchFailure;
import org.apache.tez.runtime.library.common.shuffle.ShuffleUtils;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ExceptionReporter;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.FetchedInputAllocatorOrderedGrouped;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.FetcherOrderedGrouped;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.FetcherOrderedGroupedWithInjectableErrors;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MapHost;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MapOutput;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MergeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShuffleScheduler {
    @VisibleForTesting
    static final String SHUFFLE_ERR_GRP_NAME = "Shuffle Errors";
    private final AtomicLong shuffleStart = new AtomicLong(0L);
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleScheduler.class);
    private static final Logger LOG_FETCH = LoggerFactory.getLogger((String)(LOG.getName() + ".fetch"));
    private static final ShuffleUtils.FetchStatsLogger fetchStatsLogger = new ShuffleUtils.FetchStatsLogger(LOG_FETCH, LOG);
    static final long INITIAL_PENALTY = 2000L;
    private static final float PENALTY_GROWTH_RATE = 1.3f;
    private final BitSet finishedMaps;
    private final int numInputs;
    private int numFetchedSpills;
    @VisibleForTesting
    final Map<MapHost.HostPortPartition, MapHost> mapLocations = new HashMap<MapHost.HostPortPartition, MapHost>();
    @VisibleForTesting
    final ConcurrentMap<PathPartition, InputAttemptIdentifier> pathToIdentifierMap = new ConcurrentHashMap<PathPartition, InputAttemptIdentifier>();
    @VisibleForTesting
    final Map<Integer, ShuffleEventInfo> pipelinedShuffleInfoEventsMap;
    @VisibleForTesting
    final Set<MapHost> pendingHosts = new HashSet<MapHost>();
    private final Set<InputAttemptIdentifier> obsoleteInputs = new HashSet<InputAttemptIdentifier>();
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private final Random random = new Random(System.currentTimeMillis());
    private final DelayQueue<Penalty> penalties = new DelayQueue();
    private final Referee referee;
    @VisibleForTesting
    final Map<InputAttemptIdentifier, IntWritable> failureCounts = new HashMap<InputAttemptIdentifier, IntWritable>();
    final Set<HostPort> uniqueHosts = Sets.newHashSet();
    private final Map<HostPort, IntWritable> hostFailures = new HashMap<HostPort, IntWritable>();
    private final InputContext inputContext;
    private final TezCounter shuffledInputsCounter;
    private final TezCounter skippedInputCounter;
    private final TezCounter reduceShuffleBytes;
    private final TezCounter reduceBytesDecompressed;
    @VisibleForTesting
    final TezCounter failedShuffleCounter;
    private final TezCounter bytesShuffledToDisk;
    private final TezCounter bytesShuffledToDiskDirect;
    private final TezCounter bytesShuffledToMem;
    private final TezCounter firstEventReceived;
    private final TezCounter lastEventReceived;
    private final String srcNameTrimmed;
    @VisibleForTesting
    final AtomicInteger remainingMaps;
    private final long startTime;
    @VisibleForTesting
    long lastProgressTime;
    @VisibleForTesting
    long failedShufflesSinceLastCompletion;
    private final int numFetchers;
    private final Set<FetcherOrderedGrouped> runningFetchers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ListeningExecutorService fetcherExecutor;
    private final HttpConnectionParams httpConnectionParams;
    private final FetchedInputAllocatorOrderedGrouped allocator;
    private final ExceptionReporter exceptionReporter;
    private final MergeManager mergeManager;
    private final JobTokenSecretManager jobTokenSecretManager;
    private final boolean ifileReadAhead;
    private final int ifileReadAheadLength;
    private final CompressionCodec codec;
    private final Configuration conf;
    private final RawLocalFileSystem localFs;
    private final boolean localDiskFetchEnabled;
    private final String localHostname;
    private final int shufflePort;
    private final boolean asyncHttp;
    private final boolean sslShuffle;
    private final TezCounter ioErrsCounter;
    private final TezCounter wrongLengthErrsCounter;
    private final TezCounter badIdErrsCounter;
    private final TezCounter wrongMapErrsCounter;
    private final TezCounter connectionErrsCounter;
    private final TezCounter wrongReduceErrsCounter;
    private final int maxTaskOutputAtOnce;
    private final int maxFetchFailuresBeforeReporting;
    private final boolean reportReadErrorImmediately;
    private final int maxFailedUniqueFetches;
    private final int abortFailureLimit;
    private final int minFailurePerHost;
    private final float hostFailureFraction;
    private final float maxStallTimeFraction;
    private final float minReqProgressFraction;
    private final float maxAllowedFailedFetchFraction;
    private final boolean checkFailedFetchSinceLastCompletion;
    private final boolean verifyDiskChecksum;
    private final boolean compositeFetch;
    private final boolean enableFetcherTestingErrors;
    private volatile Thread shuffleSchedulerThread = null;
    private final int maxPenaltyTime;
    private long totalBytesShuffledTillNow = 0L;
    private final DecimalFormat mbpsFormat = new DecimalFormat("0.00");
    private final AtomicInteger nextProgressLineEventCount = new AtomicInteger(0);

    public ShuffleScheduler(InputContext inputContext, Configuration conf, int numberOfInputs, ExceptionReporter exceptionReporter, MergeManager mergeManager, FetchedInputAllocatorOrderedGrouped allocator, long startTime, CompressionCodec codec, boolean ifileReadAhead, int ifileReadAheadLength, String srcNameTrimmed) throws IOException {
        this.inputContext = inputContext;
        this.conf = conf;
        this.localFs = (RawLocalFileSystem)FileSystem.getLocal((Configuration)conf).getRaw();
        this.exceptionReporter = exceptionReporter;
        this.allocator = allocator;
        this.mergeManager = mergeManager;
        this.numInputs = numberOfInputs;
        int abortFailureLimitConf = conf.getInt("tez.runtime.shuffle.src-attempt.abort.limit", -1);
        this.abortFailureLimit = abortFailureLimitConf <= -1 ? Math.max(15, numberOfInputs / 10) : abortFailureLimitConf;
        this.remainingMaps = new AtomicInteger(numberOfInputs);
        this.finishedMaps = new BitSet(numberOfInputs);
        this.ifileReadAhead = ifileReadAhead;
        this.ifileReadAheadLength = ifileReadAheadLength;
        this.srcNameTrimmed = srcNameTrimmed;
        this.codec = codec;
        int configuredNumFetchers = conf.getInt("tez.runtime.shuffle.parallel.copies", 20);
        this.numFetchers = Math.min(configuredNumFetchers, this.numInputs);
        this.localDiskFetchEnabled = conf.getBoolean("tez.runtime.optimize.local.fetch", true);
        this.minFailurePerHost = conf.getInt("tez.runtime.shuffle.min.failures.per.host", 4);
        Preconditions.checkArgument((this.minFailurePerHost >= 0 ? 1 : 0) != 0, (Object)("tez.runtime.shuffle.min.failures.per.host=" + this.minFailurePerHost + " should not be negative"));
        this.hostFailureFraction = conf.getFloat("tez.runtime.shuffle.acceptable.host-fetch.failure.fraction", 0.2f);
        this.maxStallTimeFraction = conf.getFloat("tez.runtime.shuffle.max.stall.time.fraction", 0.5f);
        Preconditions.checkArgument((this.maxStallTimeFraction >= 0.0f ? 1 : 0) != 0, (Object)("tez.runtime.shuffle.max.stall.time.fraction=" + this.maxStallTimeFraction + " should not be negative"));
        this.minReqProgressFraction = conf.getFloat("tez.runtime.shuffle.min.required.progress.fraction", 0.5f);
        Preconditions.checkArgument((this.minReqProgressFraction >= 0.0f ? 1 : 0) != 0, (Object)("tez.runtime.shuffle.min.required.progress.fraction=" + this.minReqProgressFraction + " should not be negative"));
        this.maxAllowedFailedFetchFraction = conf.getFloat("tez.runtime.shuffle.max.allowed.failed.fetch.fraction", 0.5f);
        Preconditions.checkArgument((this.maxAllowedFailedFetchFraction >= 0.0f ? 1 : 0) != 0, (Object)("tez.runtime.shuffle.max.allowed.failed.fetch.fraction=" + this.maxAllowedFailedFetchFraction + " should not be negative"));
        this.checkFailedFetchSinceLastCompletion = conf.getBoolean("tez.runtime.shuffle.failed.check.since-last.completion", true);
        this.localHostname = inputContext.getExecutionContext().getHostName();
        String auxiliaryService = conf.get("tez.am.shuffle.auxiliary-service.id", "mapreduce_shuffle");
        ByteBuffer shuffleMetadata = inputContext.getServiceProviderMetaData(auxiliaryService);
        this.shufflePort = ShuffleUtils.deserializeShuffleProviderMetaData(shuffleMetadata);
        this.referee = new Referee();
        this.shuffledInputsCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.NUM_SHUFFLED_INPUTS);
        this.reduceShuffleBytes = inputContext.getCounters().findCounter((Enum)TaskCounter.SHUFFLE_BYTES);
        this.reduceBytesDecompressed = inputContext.getCounters().findCounter((Enum)TaskCounter.SHUFFLE_BYTES_DECOMPRESSED);
        this.failedShuffleCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.NUM_FAILED_SHUFFLE_INPUTS);
        this.bytesShuffledToDisk = inputContext.getCounters().findCounter((Enum)TaskCounter.SHUFFLE_BYTES_TO_DISK);
        this.bytesShuffledToDiskDirect = inputContext.getCounters().findCounter((Enum)TaskCounter.SHUFFLE_BYTES_DISK_DIRECT);
        this.bytesShuffledToMem = inputContext.getCounters().findCounter((Enum)TaskCounter.SHUFFLE_BYTES_TO_MEM);
        this.ioErrsCounter = inputContext.getCounters().findCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.IO_ERROR.toString());
        this.wrongLengthErrsCounter = inputContext.getCounters().findCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.WRONG_LENGTH.toString());
        this.badIdErrsCounter = inputContext.getCounters().findCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.BAD_ID.toString());
        this.wrongMapErrsCounter = inputContext.getCounters().findCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.WRONG_MAP.toString());
        this.connectionErrsCounter = inputContext.getCounters().findCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.CONNECTION.toString());
        this.wrongReduceErrsCounter = inputContext.getCounters().findCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.WRONG_REDUCE.toString());
        this.startTime = startTime;
        this.lastProgressTime = startTime;
        this.sslShuffle = conf.getBoolean("tez.runtime.shuffle.ssl.enable", false);
        this.asyncHttp = conf.getBoolean("tez.runtime.shuffle.use.async.http", false);
        this.httpConnectionParams = ShuffleUtils.getHttpConnectionParams(conf);
        SecretKey jobTokenSecret = ShuffleUtils.getJobTokenSecretFromTokenBytes(inputContext.getServiceConsumerMetaData(auxiliaryService));
        this.jobTokenSecretManager = new JobTokenSecretManager(jobTokenSecret);
        ExecutorService fetcherRawExecutor = conf.getBoolean("tez.runtime.shuffle.fetcher.use-shared-pool", false) ? inputContext.createTezFrameworkExecutorService(this.numFetchers, "Fetcher_O {" + srcNameTrimmed + "} #%d") : Executors.newFixedThreadPool(this.numFetchers, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Fetcher_O {" + srcNameTrimmed + "} #%d").build());
        this.fetcherExecutor = MoreExecutors.listeningDecorator((ExecutorService)fetcherRawExecutor);
        this.maxFailedUniqueFetches = Math.min(numberOfInputs, 5);
        this.referee.start();
        this.maxFetchFailuresBeforeReporting = conf.getInt("tez.runtime.shuffle.fetch.failures.limit", 5);
        this.reportReadErrorImmediately = conf.getBoolean("tez.runtime.shuffle.notify.readerror", true);
        this.verifyDiskChecksum = conf.getBoolean("tez.runtime.shuffle.fetch.verify-disk-checksum", true);
        this.maxTaskOutputAtOnce = Math.max(1, Math.min(75, conf.getInt("tez.runtime.shuffle.fetch.max.task.output.at.once", 20)));
        this.skippedInputCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.NUM_SKIPPED_INPUTS);
        this.firstEventReceived = inputContext.getCounters().findCounter((Enum)TaskCounter.FIRST_EVENT_RECEIVED);
        this.lastEventReceived = inputContext.getCounters().findCounter((Enum)TaskCounter.LAST_EVENT_RECEIVED);
        this.compositeFetch = ShuffleUtils.isTezShuffleHandler(conf);
        this.maxPenaltyTime = conf.getInt("tez.runtime.shuffle.host.penalty.time.limit", 600000);
        this.enableFetcherTestingErrors = conf.getBoolean("tez.runtime.shuffle.fetch.testing.errors.enable", false);
        this.pipelinedShuffleInfoEventsMap = Maps.newConcurrentMap();
        LOG.info("ShuffleScheduler running for sourceVertex: " + inputContext.getSourceVertexName() + " with configuration: maxFetchFailuresBeforeReporting=" + this.maxFetchFailuresBeforeReporting + ", reportReadErrorImmediately=" + this.reportReadErrorImmediately + ", maxFailedUniqueFetches=" + this.maxFailedUniqueFetches + ", abortFailureLimit=" + this.abortFailureLimit + ", maxTaskOutputAtOnce=" + this.maxTaskOutputAtOnce + ", numFetchers=" + this.numFetchers + ", hostFailureFraction=" + this.hostFailureFraction + ", minFailurePerHost=" + this.minFailurePerHost + ", maxAllowedFailedFetchFraction=" + this.maxAllowedFailedFetchFraction + ", maxStallTimeFraction=" + this.maxStallTimeFraction + ", minReqProgressFraction=" + this.minReqProgressFraction + ", checkFailedFetchSinceLastCompletion=" + this.checkFailedFetchSinceLastCompletion + ", asyncHttp=" + this.asyncHttp + ", enableFetcherTestingErrors=" + this.enableFetcherTestingErrors);
    }

    public void start() throws Exception {
        this.shuffleSchedulerThread = Thread.currentThread();
        this.mergeManager.setupParentThread(this.shuffleSchedulerThread);
        ShuffleSchedulerCallable schedulerCallable = new ShuffleSchedulerCallable();
        schedulerCallable.call();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block16: {
            try {
                if (this.isShutdown.getAndSet(true)) break block16;
                try {
                    this.logProgress();
                }
                catch (Exception e) {
                    LOG.warn("Failed log progress while closing, ignoring and continuing shutdown. Message={}", (Object)e.getMessage());
                }
                ShuffleScheduler e = this;
                synchronized (e) {
                    this.notifyAll();
                }
                if (this.shuffleSchedulerThread != null && !Thread.currentThread().equals(this.shuffleSchedulerThread)) {
                    this.shuffleSchedulerThread.interrupt();
                }
                for (FetcherOrderedGrouped fetcher : this.runningFetchers) {
                    try {
                        fetcher.shutDown();
                    }
                    catch (Exception e2) {
                        LOG.warn("Error while shutting down fetcher. Ignoring and continuing shutdown. Message={}", (Object)e2.getMessage());
                    }
                }
                try {
                    this.referee.interrupt();
                    this.referee.join();
                }
                catch (InterruptedException e2) {
                    LOG.warn("Interrupted while shutting down referee. Ignoring and continuing shutdown");
                    Thread.currentThread().interrupt();
                }
                catch (Exception e3) {
                    LOG.warn("Error while shutting down referee. Ignoring and continuing shutdown. Message={}", (Object)e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                long startTime = System.currentTimeMillis();
                if (!this.fetcherExecutor.isShutdown()) {
                    this.fetcherExecutor.shutdownNow();
                }
                long endTime = System.currentTimeMillis();
                LOG.info("Shutting down fetchers for input: {}, shutdown timetaken: {} ms, hasFetcherExecutorStopped: {}", new Object[]{this.srcNameTrimmed, endTime - startTime, this.hasFetcherExecutorStopped()});
                throw throwable;
            }
        }
        long startTime = System.currentTimeMillis();
        if (!this.fetcherExecutor.isShutdown()) {
            this.fetcherExecutor.shutdownNow();
        }
        long endTime = System.currentTimeMillis();
        LOG.info("Shutting down fetchers for input: {}, shutdown timetaken: {} ms, hasFetcherExecutorStopped: {}", new Object[]{this.srcNameTrimmed, endTime - startTime, this.hasFetcherExecutorStopped()});
    }

    @VisibleForTesting
    boolean hasFetcherExecutorStopped() {
        return this.fetcherExecutor.isShutdown();
    }

    @VisibleForTesting
    public boolean isShutdown() {
        return this.isShutdown.get();
    }

    protected synchronized void updateEventReceivedTime() {
        long relativeTime = System.currentTimeMillis() - this.startTime;
        if (this.firstEventReceived.getValue() == 0L) {
            this.firstEventReceived.setValue(relativeTime);
            this.lastEventReceived.setValue(relativeTime);
            return;
        }
        this.lastEventReceived.setValue(relativeTime);
    }

    public synchronized void copySucceeded(InputAttemptIdentifier srcAttemptIdentifier, MapHost host, long bytesCompressed, long bytesDecompressed, long millis, MapOutput output, boolean isLocalFetch) throws IOException {
        this.inputContext.notifyProgress();
        if (!this.isInputFinished(srcAttemptIdentifier.getInputIdentifier())) {
            if (!isLocalFetch) {
                this.failedShufflesSinceLastCompletion = 0L;
            }
            if (output != null) {
                this.failureCounts.remove(srcAttemptIdentifier);
                if (host != null) {
                    this.hostFailures.remove(new HostPort(host.getHost(), host.getPort()));
                }
                output.commit();
                fetchStatsLogger.logIndividualFetchComplete(millis, bytesCompressed, bytesDecompressed, output.getType().toString(), srcAttemptIdentifier);
                if (output.getType() == MapOutput.Type.DISK) {
                    this.bytesShuffledToDisk.increment(bytesCompressed);
                } else if (output.getType() == MapOutput.Type.DISK_DIRECT) {
                    this.bytesShuffledToDiskDirect.increment(bytesCompressed);
                } else {
                    this.bytesShuffledToMem.increment(bytesCompressed);
                }
                this.shuffledInputsCounter.increment(1L);
            } else {
                this.skippedInputCounter.increment(1L);
            }
            if (!srcAttemptIdentifier.canRetrieveInputInChunks()) {
                this.remainingMaps.decrementAndGet();
                this.setInputFinished(srcAttemptIdentifier.getInputIdentifier());
                ++this.numFetchedSpills;
            } else {
                int inputIdentifier = srcAttemptIdentifier.getInputIdentifier();
                if (!this.validateInputAttemptForPipelinedShuffle(srcAttemptIdentifier)) {
                    return;
                }
                ShuffleEventInfo eventInfo = this.pipelinedShuffleInfoEventsMap.get(inputIdentifier);
                if (eventInfo == null && output == null) {
                    eventInfo = new ShuffleEventInfo(srcAttemptIdentifier);
                    this.pipelinedShuffleInfoEventsMap.put(inputIdentifier, eventInfo);
                }
                assert (eventInfo != null);
                eventInfo.spillProcessed(srcAttemptIdentifier.getSpillEventId());
                ++this.numFetchedSpills;
                if (srcAttemptIdentifier.getFetchTypeInfo() == InputAttemptIdentifier.SPILL_INFO.FINAL_UPDATE) {
                    eventInfo.setFinalEventId(srcAttemptIdentifier.getSpillEventId());
                }
                if (eventInfo.isDone()) {
                    this.remainingMaps.decrementAndGet();
                    this.setInputFinished(inputIdentifier);
                    this.pipelinedShuffleInfoEventsMap.remove(inputIdentifier);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Removing : " + srcAttemptIdentifier + ", pending: " + this.pipelinedShuffleInfoEventsMap);
                    }
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("eventInfo " + eventInfo.toString());
                }
            }
            if (this.remainingMaps.get() == 0) {
                this.notifyAll();
                LOG.info("All inputs fetched for input vertex : " + this.inputContext.getInputOutputVertexNames());
            }
            this.lastProgressTime = System.currentTimeMillis();
            this.totalBytesShuffledTillNow += bytesCompressed;
            this.logProgress();
            this.reduceShuffleBytes.increment(bytesCompressed);
            this.reduceBytesDecompressed.increment(bytesDecompressed);
            if (LOG.isDebugEnabled()) {
                LOG.debug("src task: " + TezRuntimeUtils.getTaskAttemptIdentifier(this.inputContext.getSourceVertexName(), srcAttemptIdentifier.getInputIdentifier(), srcAttemptIdentifier.getAttemptNumber()) + " done");
            }
        } else {
            LOG.warn("Duplicate fetch of input no longer needs to be fetched: " + srcAttemptIdentifier);
            if (output != null) {
                output.abort();
            }
        }
    }

    private boolean validateInputAttemptForPipelinedShuffle(InputAttemptIdentifier input) {
        if (input.canRetrieveInputInChunks()) {
            ShuffleEventInfo eventInfo = this.pipelinedShuffleInfoEventsMap.get(input.getInputIdentifier());
            if (eventInfo != null && input.getAttemptNumber() != eventInfo.attemptNum) {
                if (eventInfo.scheduledForDownload || !eventInfo.eventsProcessed.isEmpty()) {
                    IOException exception = new IOException("Previous event already got scheduled for " + input + ". Previous attempt's data could have been already merged to memory/disk outputs.  Killing (self) this task early. currentAttemptNum=" + eventInfo.attemptNum + ", eventsProcessed=" + eventInfo.eventsProcessed + ", scheduledForDownload=" + eventInfo.scheduledForDownload + ", newAttemptNum=" + input.getAttemptNumber());
                    String message = "Killing self as previous attempt data could have been consumed";
                    this.killSelf(exception, message);
                    return false;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ignoring current attempt=" + eventInfo.attemptNum + " with eventInfo=" + eventInfo.toString() + "and processing new attempt=" + input.getAttemptNumber());
                }
            }
            if (eventInfo == null) {
                this.pipelinedShuffleInfoEventsMap.put(input.getInputIdentifier(), new ShuffleEventInfo(input));
            }
        }
        return true;
    }

    @VisibleForTesting
    void killSelf(Exception exception, String message) {
        LOG.error(message, (Throwable)exception);
        this.exceptionReporter.killSelf(exception, message);
    }

    private void logProgress() {
        int inputsDone = this.numInputs - this.remainingMaps.get();
        if (inputsDone > this.nextProgressLineEventCount.get() || inputsDone == this.numInputs || this.isShutdown.get()) {
            this.nextProgressLineEventCount.addAndGet(50);
            double mbs = (double)this.totalBytesShuffledTillNow / 1048576.0;
            long secsSinceStart = (System.currentTimeMillis() - this.startTime) / 1000L + 1L;
            double transferRate = mbs / (double)secsSinceStart;
            LOG.info("copy(" + inputsDone + " (spillsFetched=" + this.numFetchedSpills + ") of " + this.numInputs + ". Transfer rate (CumulativeDataFetched/TimeSinceInputStarted)) " + this.mbpsFormat.format(transferRate) + " MB/s)");
        }
    }

    public synchronized void copyFailed(InputAttemptFetchFailure fetchFailure, MapHost host, boolean readError, boolean connectError) {
        boolean shouldInformAM;
        this.failedShuffleCounter.increment(1L);
        this.inputContext.notifyProgress();
        int failures = this.incrementAndGetFailureAttempt(fetchFailure.getInputAttemptIdentifier());
        if (!fetchFailure.isLocalFetch()) {
            ++this.failedShufflesSinceLastCompletion;
        }
        boolean bl = shouldInformAM = this.reportReadErrorImmediately && (readError || connectError) || failures % this.maxFetchFailuresBeforeReporting == 0;
        if (shouldInformAM) {
            this.informAM(fetchFailure);
        }
        if (!this.isShuffleHealthy(fetchFailure)) {
            return;
        }
        this.penalizeHost(host, failures);
    }

    private boolean isAbortLimitExceeedFor(InputAttemptIdentifier srcAttempt) {
        int attemptFailures = this.getFailureCount(srcAttempt);
        if (attemptFailures >= this.abortFailureLimit) {
            String errorMsg = "Failed " + attemptFailures + " times trying to download from " + TezRuntimeUtils.getTaskAttemptIdentifier(this.inputContext.getSourceVertexName(), srcAttempt.getInputIdentifier(), srcAttempt.getAttemptNumber()) + ". threshold=" + this.abortFailureLimit;
            IOException ioe = new IOException(errorMsg);
            this.exceptionReporter.reportException(ioe);
            return true;
        }
        return false;
    }

    private void penalizeHost(MapHost host, int failures) {
        host.penalize();
        HostPort hostPort = new HostPort(host.getHost(), host.getPort());
        if (this.hostFailures.containsKey(hostPort)) {
            IntWritable x = this.hostFailures.get(hostPort);
            x.set(x.get() + 1);
        } else {
            this.hostFailures.put(hostPort, new IntWritable(1));
        }
        long delay = (long)(2000.0 * Math.pow(1.3f, failures));
        long penaltyDelay = Math.min(delay, (long)this.maxPenaltyTime);
        this.penalties.add(new Penalty(host, penaltyDelay));
    }

    private int getFailureCount(InputAttemptIdentifier srcAttempt) {
        IntWritable failureCount = this.failureCounts.get(srcAttempt);
        return failureCount == null ? 0 : failureCount.get();
    }

    private int incrementAndGetFailureAttempt(InputAttemptIdentifier srcAttempt) {
        int failures = 1;
        if (this.failureCounts.containsKey(srcAttempt)) {
            IntWritable x = this.failureCounts.get(srcAttempt);
            x.set(x.get() + 1);
            failures = x.get();
        } else {
            this.failureCounts.put(srcAttempt, new IntWritable(1));
        }
        return failures;
    }

    public void reportLocalError(IOException ioe) {
        LOG.error(this.srcNameTrimmed + ": Shuffle failed : caused by local error", (Throwable)ioe);
        this.exceptionReporter.reportException(ioe);
    }

    private void informAM(InputAttemptFetchFailure fetchFailure) {
        InputAttemptIdentifier srcAttempt = fetchFailure.getInputAttemptIdentifier();
        LOG.info("{}: Reporting fetch failure for InputIdentifier: {} taskAttemptIdentifier: {}, local fetch: {}, remote fetch failure reported as local failure: {}) to AM.", new Object[]{this.srcNameTrimmed, srcAttempt, TezRuntimeUtils.getTaskAttemptIdentifier(this.inputContext.getSourceVertexName(), srcAttempt.getInputIdentifier(), srcAttempt.getAttemptNumber()), fetchFailure.isLocalFetch(), fetchFailure.isDiskErrorAtSource()});
        ArrayList failedEvents = Lists.newArrayListWithCapacity((int)1);
        failedEvents.add(InputReadErrorEvent.create((String)("Fetch failure for " + TezRuntimeUtils.getTaskAttemptIdentifier(this.inputContext.getSourceVertexName(), srcAttempt.getInputIdentifier(), srcAttempt.getAttemptNumber()) + " to jobtracker."), (int)srcAttempt.getInputIdentifier(), (int)srcAttempt.getAttemptNumber(), (boolean)fetchFailure.isLocalFetch(), (boolean)fetchFailure.isDiskErrorAtSource(), (String)this.localHostname));
        this.inputContext.sendEvents((List)failedEvents);
    }

    private boolean hasFailedAcrossNodes(String logContext) {
        HostPort host;
        IntWritable failures;
        int numUniqueHosts = this.uniqueHosts.size();
        Preconditions.checkArgument((numUniqueHosts > 0 ? 1 : 0) != 0, (Object)"No values in unique hosts");
        int threshold = Math.max(3, (int)Math.ceil((float)numUniqueHosts * this.hostFailureFraction));
        int total = 0;
        boolean failedAcrossNodes = false;
        Iterator<HostPort> iterator = this.uniqueHosts.iterator();
        while (iterator.hasNext() && ((failures = this.hostFailures.get(host = iterator.next())) == null || failures.get() <= this.minFailurePerHost || !(failedAcrossNodes = ++total > threshold * this.minFailurePerHost))) {
        }
        LOG.info(logContext + ", numUniqueHosts=" + numUniqueHosts + ", hostFailureThreshold=" + threshold + ", hostFailuresCount=" + this.hostFailures.size() + ", hosts crossing threshold=" + total + ", reducerFetchIssues=" + failedAcrossNodes);
        return failedAcrossNodes;
    }

    private boolean allEventsReceived() {
        if (!this.pipelinedShuffleInfoEventsMap.isEmpty()) {
            return this.pipelinedShuffleInfoEventsMap.size() == this.numInputs;
        }
        return (long)this.pathToIdentifierMap.size() + this.skippedInputCounter.getValue() == (long)this.numInputs;
    }

    private boolean isFetcherHealthy(String logContext) {
        long totalFailures = this.failedShuffleCounter.getValue();
        int doneMaps = this.numInputs - this.remainingMaps.get();
        boolean fetcherHealthy = true;
        if (doneMaps > 0) {
            boolean bl = fetcherHealthy = (float)totalFailures / (float)(totalFailures + (long)doneMaps) < this.maxAllowedFailedFetchFraction;
        }
        if (fetcherHealthy && this.allEventsReceived()) {
            boolean failedAcrossNodes;
            if (this.hostFailureFraction > 0.0f && (failedAcrossNodes = this.hasFailedAcrossNodes(logContext))) {
                return false;
            }
            if (this.checkFailedFetchSinceLastCompletion && this.failedShufflesSinceLastCompletion >= (long)(this.remainingMaps.get() * this.minFailurePerHost)) {
                fetcherHealthy = (float)this.failedShufflesSinceLastCompletion / (float)(this.failedShufflesSinceLastCompletion + (long)this.remainingMaps.get()) < this.maxAllowedFailedFetchFraction;
                LOG.info(logContext + ", fetcherHealthy=" + fetcherHealthy + ", failedShufflesSinceLastCompletion=" + this.failedShufflesSinceLastCompletion + ", remainingMaps=" + this.remainingMaps.get());
            }
        }
        return fetcherHealthy;
    }

    boolean isShuffleHealthy(InputAttemptFetchFailure fetchFailure) {
        boolean reducerStalled;
        InputAttemptIdentifier srcAttempt = fetchFailure.getInputAttemptIdentifier();
        if (this.isAbortLimitExceeedFor(srcAttempt)) {
            return false;
        }
        float MIN_REQUIRED_PROGRESS_PERCENT = this.minReqProgressFraction;
        float MAX_ALLOWED_STALL_TIME_PERCENT = this.maxStallTimeFraction;
        int doneMaps = this.numInputs - this.remainingMaps.get();
        String logContext = "srcAttempt=" + srcAttempt.toString();
        boolean fetcherHealthy = this.isFetcherHealthy(logContext);
        boolean reducerProgressedEnough = (float)doneMaps / (float)this.numInputs >= MIN_REQUIRED_PROGRESS_PERCENT;
        int stallDuration = (int)(System.currentTimeMillis() - this.lastProgressTime);
        int shuffleProgressDuration = (int)(this.lastProgressTime - this.startTime);
        boolean bl = reducerStalled = shuffleProgressDuration > 0 && (float)stallDuration / (float)shuffleProgressDuration >= MAX_ALLOWED_STALL_TIME_PERCENT;
        if (!(this.failureCounts.size() < this.maxFailedUniqueFetches && this.failureCounts.size() != this.numInputs - doneMaps || fetcherHealthy || reducerProgressedEnough && !reducerStalled)) {
            String errorMsg = this.srcNameTrimmed + ": Shuffle failed with too many fetch failures and insufficient progress: [failureCounts=" + this.failureCounts.size() + ", pendingInputs=" + (this.numInputs - doneMaps) + ", fetcherHealthy=" + fetcherHealthy + ", reducerProgressedEnough=" + reducerProgressedEnough + ", reducerStalled=" + reducerStalled + ", hostFailures=" + this.hostFailures + "]";
            LOG.error(errorMsg);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Host failures=" + this.hostFailures.keySet());
            }
            this.exceptionReporter.reportException(new IOException(errorMsg, fetchFailure.getCause()));
            return false;
        }
        return true;
    }

    public synchronized void addKnownMapOutput(String inputHostName, int port, int partitionId, CompositeInputAttemptIdentifier srcAttempt) {
        this.uniqueHosts.add(new HostPort(inputHostName, port));
        MapHost.HostPortPartition identifier = new MapHost.HostPortPartition(inputHostName, port, partitionId);
        MapHost host = this.mapLocations.get(identifier);
        if (host == null) {
            host = new MapHost(inputHostName, port, partitionId, srcAttempt.getInputIdentifierCount());
            this.mapLocations.put(identifier, host);
        }
        if (!this.validateInputAttemptForPipelinedShuffle(srcAttempt)) {
            return;
        }
        host.addKnownMap(srcAttempt);
        for (int i = 0; i < srcAttempt.getInputIdentifierCount(); ++i) {
            PathPartition pathPartition = new PathPartition(srcAttempt.getPathComponent(), partitionId + i);
            this.pathToIdentifierMap.put(pathPartition, srcAttempt.expand(i));
        }
        if (host.getState() == MapHost.State.PENDING) {
            this.pendingHosts.add(host);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void obsoleteInput(InputAttemptIdentifier srcAttempt) {
        LOG.info(this.srcNameTrimmed + ": Adding obsolete input: " + srcAttempt);
        ShuffleEventInfo eventInfo = this.pipelinedShuffleInfoEventsMap.get(srcAttempt.getInputIdentifier());
        if (eventInfo != null) {
            if (eventInfo.eventsProcessed.isEmpty() && !eventInfo.scheduledForDownload) {
                this.pipelinedShuffleInfoEventsMap.remove(srcAttempt.getInputIdentifier());
                LOG.debug("Removing {} from tracking", (Object)eventInfo);
                return;
            }
            IOException exception = new IOException(srcAttempt + " is marked as obsoleteInput, but it exists in shuffleInfoEventMap. Some data could have been already merged to memory/disk outputs. Failing the fetch early. eventInfo: " + eventInfo);
            String message = "Got obsolete event. Killing self as attempt's data could have been consumed";
            this.killSelf(exception, message);
            return;
        }
        ShuffleScheduler shuffleScheduler = this;
        synchronized (shuffleScheduler) {
            this.obsoleteInputs.add(srcAttempt);
        }
    }

    public synchronized void putBackKnownMapOutput(MapHost host, InputAttemptIdentifier srcAttempt) {
        host.addKnownMap(srcAttempt);
    }

    public synchronized MapHost getHost() throws InterruptedException {
        while (this.pendingHosts.isEmpty() && this.remainingMaps.get() > 0) {
            LOG.debug("PendingHosts={}", this.pendingHosts);
            this.waitAndNotifyProgress();
        }
        if (!this.pendingHosts.isEmpty()) {
            MapHost host = null;
            Iterator<MapHost> iter = this.pendingHosts.iterator();
            int numToPick = this.random.nextInt(this.pendingHosts.size());
            for (int i = 0; i <= numToPick; ++i) {
                host = iter.next();
            }
            this.pendingHosts.remove(host);
            host.markBusy();
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.srcNameTrimmed + ": Assigning " + host + " with " + host.getNumKnownMapOutputs() + " to " + Thread.currentThread().getName());
            }
            this.shuffleStart.set(System.currentTimeMillis());
            return host;
        }
        return null;
    }

    public InputAttemptIdentifier getIdentifierForFetchedOutput(String path, int reduceId) {
        return (InputAttemptIdentifier)this.pathToIdentifierMap.get(new PathPartition(path, reduceId));
    }

    @VisibleForTesting
    DelayQueue<Penalty> getPenalties() {
        return this.penalties;
    }

    private synchronized boolean inputShouldBeConsumed(InputAttemptIdentifier id) {
        boolean isInputFinished = false;
        if (id instanceof CompositeInputAttemptIdentifier) {
            CompositeInputAttemptIdentifier cid = (CompositeInputAttemptIdentifier)id;
            isInputFinished = this.isInputFinished(cid.getInputIdentifier(), cid.getInputIdentifier() + cid.getInputIdentifierCount());
        } else {
            isInputFinished = this.isInputFinished(id.getInputIdentifier());
        }
        return !this.obsoleteInputs.contains(id) && !isInputFinished;
    }

    public synchronized List<InputAttemptIdentifier> getMapsForHost(MapHost host) {
        List<InputAttemptIdentifier> origList = host.getAndClearKnownMaps();
        LinkedListMultimap dedupedList = LinkedListMultimap.create();
        for (InputAttemptIdentifier id : origList) {
            if (this.inputShouldBeConsumed(id)) {
                Integer inputNumber = id.getInputIdentifier();
                List oldIdList = dedupedList.get((Object)inputNumber);
                if (oldIdList == null || oldIdList.isEmpty()) {
                    dedupedList.put((Object)inputNumber, (Object)id);
                    continue;
                }
                boolean addIdentifierToList = false;
                Iterator oldIdIterator = oldIdList.iterator();
                while (oldIdIterator.hasNext()) {
                    InputAttemptIdentifier oldId = (InputAttemptIdentifier)oldIdIterator.next();
                    if (id.canRetrieveInputInChunks()) {
                        if (oldId.getSpillEventId() == id.getSpillEventId()) {
                            addIdentifierToList = false;
                            continue;
                        }
                        if (oldId.getAttemptNumber() == id.getAttemptNumber()) {
                            addIdentifierToList = true;
                            break;
                        }
                    }
                    if (oldId.getAttemptNumber() >= id.getAttemptNumber()) continue;
                    oldIdIterator.remove();
                    LOG.warn("Old Src for InputIndex: " + inputNumber + " with attemptNumber: " + oldId.getAttemptNumber() + " was not determined to be invalid. Ignoring it for now in favour of " + id.getAttemptNumber());
                    addIdentifierToList = true;
                    break;
                }
                if (!addIdentifierToList) continue;
                dedupedList.put((Object)inputNumber, (Object)id);
                continue;
            }
            LOG.info("Ignoring finished or obsolete source: " + id);
        }
        ArrayList<InputAttemptIdentifier> result = new ArrayList<InputAttemptIdentifier>();
        int includedMaps = 0;
        int totalSize = dedupedList.size();
        for (Integer inputIndex : dedupedList.keySet()) {
            List attemptIdentifiers = dedupedList.get((Object)inputIndex);
            for (InputAttemptIdentifier inputAttemptIdentifier : attemptIdentifiers) {
                ShuffleEventInfo shuffleEventInfo;
                if (includedMaps++ >= this.maxTaskOutputAtOnce) {
                    host.addKnownMap(inputAttemptIdentifier);
                    continue;
                }
                if (inputAttemptIdentifier.canRetrieveInputInChunks() && (shuffleEventInfo = this.pipelinedShuffleInfoEventsMap.get(inputAttemptIdentifier.getInputIdentifier())) != null) {
                    shuffleEventInfo.scheduledForDownload = true;
                }
                result.add(inputAttemptIdentifier);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("assigned " + includedMaps + " of " + totalSize + " to " + host + " to " + Thread.currentThread().getName());
        }
        return result;
    }

    public synchronized void freeHost(MapHost host) {
        if (host.getState() != MapHost.State.PENALIZED && host.markAvailable() == MapHost.State.PENDING) {
            this.pendingHosts.add(host);
            this.notifyAll();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(host + " freed by " + Thread.currentThread().getName() + " in " + (System.currentTimeMillis() - this.shuffleStart.get()) + "ms");
        }
    }

    public synchronized void resetKnownMaps() {
        this.mapLocations.clear();
        this.obsoleteInputs.clear();
        this.pendingHosts.clear();
        this.pathToIdentifierMap.clear();
    }

    public synchronized boolean isDone() {
        return this.remainingMaps.get() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInputFinished(int inputIndex) {
        BitSet bitSet = this.finishedMaps;
        synchronized (bitSet) {
            this.finishedMaps.set(inputIndex, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isInputFinished(int inputIndex) {
        BitSet bitSet = this.finishedMaps;
        synchronized (bitSet) {
            return this.finishedMaps.get(inputIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isInputFinished(int inputIndex, int inputEnd) {
        BitSet bitSet = this.finishedMaps;
        synchronized (bitSet) {
            return this.finishedMaps.nextClearBit(inputIndex) > inputEnd;
        }
    }

    private synchronized void waitAndNotifyProgress() throws InterruptedException {
        this.inputContext.notifyProgress();
        this.wait(1000L);
    }

    @VisibleForTesting
    FetcherOrderedGrouped constructFetcherForHost(MapHost mapHost) {
        if (this.enableFetcherTestingErrors) {
            return new FetcherOrderedGroupedWithInjectableErrors(this.httpConnectionParams, this, this.allocator, this.exceptionReporter, this.jobTokenSecretManager, this.ifileReadAhead, this.ifileReadAheadLength, this.codec, this.conf, this.localFs, this.localDiskFetchEnabled, this.localHostname, this.shufflePort, mapHost, this.ioErrsCounter, this.wrongLengthErrsCounter, this.badIdErrsCounter, this.wrongMapErrsCounter, this.connectionErrsCounter, this.wrongReduceErrsCounter, this.asyncHttp, this.sslShuffle, this.verifyDiskChecksum, this.compositeFetch, this.inputContext);
        }
        return new FetcherOrderedGrouped(this.httpConnectionParams, this, this.allocator, this.exceptionReporter, this.jobTokenSecretManager, this.ifileReadAhead, this.ifileReadAheadLength, this.codec, this.conf, this.localFs, this.localDiskFetchEnabled, this.localHostname, this.shufflePort, mapHost, this.ioErrsCounter, this.wrongLengthErrsCounter, this.badIdErrsCounter, this.wrongMapErrsCounter, this.connectionErrsCounter, this.wrongReduceErrsCounter, this.asyncHttp, this.sslShuffle, this.verifyDiskChecksum, this.compositeFetch, this.inputContext);
    }

    private class FetchFutureCallback
    implements FutureCallback<Void> {
        private final FetcherOrderedGrouped fetcherOrderedGrouped;

        public FetchFutureCallback(FetcherOrderedGrouped fetcherOrderedGrouped) {
            this.fetcherOrderedGrouped = fetcherOrderedGrouped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doBookKeepingForFetcherComplete() {
            ShuffleScheduler shuffleScheduler = ShuffleScheduler.this;
            synchronized (shuffleScheduler) {
                ShuffleScheduler.this.runningFetchers.remove((Object)this.fetcherOrderedGrouped);
                ShuffleScheduler.this.notifyAll();
            }
        }

        public void onSuccess(Void result) {
            this.fetcherOrderedGrouped.shutDown();
            if (ShuffleScheduler.this.isShutdown.get()) {
                LOG.info(ShuffleScheduler.this.srcNameTrimmed + ": Already shutdown. Ignoring fetch complete");
            } else {
                this.doBookKeepingForFetcherComplete();
            }
        }

        public void onFailure(Throwable t) {
            this.fetcherOrderedGrouped.shutDown();
            if (ShuffleScheduler.this.isShutdown.get()) {
                LOG.info(ShuffleScheduler.this.srcNameTrimmed + ": Already shutdown. Ignoring fetch complete");
            } else {
                LOG.error(ShuffleScheduler.this.srcNameTrimmed + ": Fetcher failed with error", t);
                ShuffleScheduler.this.exceptionReporter.reportException(t);
                this.doBookKeepingForFetcherComplete();
            }
        }
    }

    private class ShuffleSchedulerCallable
    extends CallableWithNdc<Void> {
        private ShuffleSchedulerCallable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void callInternal() throws InterruptedException {
            while (!ShuffleScheduler.this.isShutdown.get() && ShuffleScheduler.this.remainingMaps.get() > 0) {
                ShuffleScheduler shuffleScheduler = ShuffleScheduler.this;
                synchronized (shuffleScheduler) {
                    while ((ShuffleScheduler.this.runningFetchers.size() >= ShuffleScheduler.this.numFetchers || ShuffleScheduler.this.pendingHosts.isEmpty()) && ShuffleScheduler.this.remainingMaps.get() > 0) {
                        try {
                            ShuffleScheduler.this.waitAndNotifyProgress();
                        }
                        catch (InterruptedException e) {
                            if (ShuffleScheduler.this.isShutdown.get()) {
                                LOG.info(ShuffleScheduler.this.srcNameTrimmed + ": Interrupted while waiting for fetchers to complete and hasBeenShutdown. Breaking out of ShuffleSchedulerCallable loop");
                                Thread.currentThread().interrupt();
                                break;
                            }
                            throw e;
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(ShuffleScheduler.this.srcNameTrimmed + ": NumCompletedInputs: {}" + (ShuffleScheduler.this.numInputs - ShuffleScheduler.this.remainingMaps.get()));
                }
                try {
                    ShuffleScheduler.this.mergeManager.waitForInMemoryMerge();
                    ShuffleScheduler.this.mergeManager.waitForShuffleToMergeMemory();
                }
                catch (InterruptedException e) {
                    if (ShuffleScheduler.this.isShutdown.get()) {
                        LOG.info(ShuffleScheduler.this.srcNameTrimmed + ": Interrupted while waiting for merge to complete and hasBeenShutdown. Breaking out of ShuffleSchedulerCallable loop");
                        Thread.currentThread().interrupt();
                        break;
                    }
                    throw e;
                }
                if (ShuffleScheduler.this.isShutdown.get() || ShuffleScheduler.this.remainingMaps.get() <= 0) continue;
                shuffleScheduler = ShuffleScheduler.this;
                synchronized (shuffleScheduler) {
                    int numFetchersToRun = ShuffleScheduler.this.numFetchers - ShuffleScheduler.this.runningFetchers.size();
                    int count = 0;
                    while (count < numFetchersToRun && !ShuffleScheduler.this.isShutdown.get() && ShuffleScheduler.this.remainingMaps.get() > 0) {
                        MapHost mapHost;
                        try {
                            mapHost = ShuffleScheduler.this.getHost();
                        }
                        catch (InterruptedException e) {
                            if (ShuffleScheduler.this.isShutdown.get()) {
                                LOG.info(ShuffleScheduler.this.srcNameTrimmed + ": Interrupted while waiting for host and hasBeenShutdown. Breaking out of ShuffleSchedulerCallable loop");
                                Thread.currentThread().interrupt();
                                break;
                            }
                            throw e;
                        }
                        if (mapHost == null) break;
                        LOG.debug("{}: Processing pending host: {}", (Object)ShuffleScheduler.this.srcNameTrimmed, (Object)mapHost);
                        if (ShuffleScheduler.this.isShutdown.get()) continue;
                        ++count;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(ShuffleScheduler.this.srcNameTrimmed + ": Scheduling fetch for inputHost: {}", (Object)(mapHost.getHostIdentifier() + ":" + mapHost.getPartitionId()));
                        }
                        FetcherOrderedGrouped fetcherOrderedGrouped = ShuffleScheduler.this.constructFetcherForHost(mapHost);
                        ShuffleScheduler.this.runningFetchers.add(fetcherOrderedGrouped);
                        ListenableFuture future = ShuffleScheduler.this.fetcherExecutor.submit((Callable)((Object)fetcherOrderedGrouped));
                        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FetchFutureCallback(fetcherOrderedGrouped), (Executor)GuavaShim.directExecutor());
                    }
                }
            }
            LOG.info("Shutting down FetchScheduler for input: {}, wasInterrupted={}", (Object)ShuffleScheduler.this.srcNameTrimmed, (Object)Thread.currentThread().isInterrupted());
            if (!ShuffleScheduler.this.fetcherExecutor.isShutdown()) {
                ShuffleScheduler.this.fetcherExecutor.shutdownNow();
            }
            return null;
        }
    }

    private class Referee
    extends Thread {
        public Referee() {
            this.setName("ShufflePenaltyReferee {" + TezUtilsInternal.cleanVertexName((String)ShuffleScheduler.this.inputContext.getSourceVertexName()) + "}");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!ShuffleScheduler.this.isShutdown.get()) {
                    MapHost host = ((Penalty)((ShuffleScheduler)ShuffleScheduler.this).penalties.take()).host;
                    ShuffleScheduler shuffleScheduler = ShuffleScheduler.this;
                    synchronized (shuffleScheduler) {
                        if (host.markAvailable() == MapHost.State.PENDING) {
                            ShuffleScheduler.this.pendingHosts.add(host);
                            ShuffleScheduler.this.notifyAll();
                        }
                    }
                }
                return;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (Throwable t) {
                ShuffleScheduler.this.exceptionReporter.reportException(t);
            }
        }
    }

    static class Penalty
    implements Delayed {
        MapHost host;
        private long endTime;

        Penalty(MapHost host, long delay) {
            this.host = host;
            this.endTime = System.currentTimeMillis() + delay;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long remainingTime = this.endTime - System.currentTimeMillis();
            return unit.convert(remainingTime, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            long other = ((Penalty)o).endTime;
            return this.endTime == other ? 0 : (this.endTime < other ? -1 : 1);
        }
    }

    static class ShuffleEventInfo {
        BitSet eventsProcessed;
        int finalEventId = -1;
        int attemptNum;
        String id;
        boolean scheduledForDownload;

        ShuffleEventInfo(InputAttemptIdentifier input) {
            this.id = input.getInputIdentifier() + "_" + input.getAttemptNumber();
            this.eventsProcessed = new BitSet();
            this.attemptNum = input.getAttemptNumber();
        }

        void spillProcessed(int spillId) {
            if (this.finalEventId != -1) {
                Preconditions.checkState((this.eventsProcessed.cardinality() <= this.finalEventId + 1 ? 1 : 0) != 0, (Object)("Wrong state. eventsProcessed cardinality=" + this.eventsProcessed.cardinality() + " finalEventId=" + this.finalEventId + ", spillId=" + spillId + ", " + this.toString()));
            }
            this.eventsProcessed.set(spillId);
        }

        void setFinalEventId(int spillId) {
            this.finalEventId = spillId;
        }

        boolean isDone() {
            return this.finalEventId != -1 && this.finalEventId + 1 == this.eventsProcessed.cardinality();
        }

        public String toString() {
            return "[eventsProcessed=" + this.eventsProcessed + ", finalEventId=" + this.finalEventId + ", id=" + this.id + ", attemptNum=" + this.attemptNum + ", scheduledForDownload=" + this.scheduledForDownload + "]";
        }
    }

    @VisibleForTesting
    static enum ShuffleErrors {
        IO_ERROR,
        WRONG_LENGTH,
        BAD_ID,
        WRONG_MAP,
        CONNECTION,
        WRONG_REDUCE;

    }

    public static class PathPartition {
        final String path;
        final int partition;

        PathPartition(String path, int partition) {
            this.path = path;
            this.partition = partition;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            result = 31 * result + this.partition;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathPartition other = (PathPartition)obj;
            if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
                return false;
            }
            return this.partition == other.partition;
        }

        public String toString() {
            return "PathPartition [path=" + this.path + ", partition=" + this.partition + "]";
        }
    }
}

