/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.readers;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.library.api.IOInterruptedException;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.apache.tez.runtime.library.common.shuffle.FetchedInput;
import org.apache.tez.runtime.library.common.shuffle.MemoryFetchedInput;
import org.apache.tez.runtime.library.common.shuffle.impl.ShuffleManager;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.InMemoryReader;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Unstable
@InterfaceAudience.Private
public class UnorderedKVReader<K, V>
extends KeyValueReader {
    private static final Logger LOG = LoggerFactory.getLogger(UnorderedKVReader.class);
    private final ShuffleManager shuffleManager;
    private final CompressionCodec codec;
    private final Class<K> keyClass;
    private final Class<V> valClass;
    private final Deserializer<K> keyDeserializer;
    private final Deserializer<V> valDeserializer;
    private final DataInputBuffer keyIn;
    private final DataInputBuffer valIn;
    private final boolean ifileReadAhead;
    private final int ifileReadAheadLength;
    private final int ifileBufferSize;
    private final TezCounter inputRecordCounter;
    private final InputContext context;
    private K key;
    private V value;
    private FetchedInput currentFetchedInput;
    private IFile.Reader currentReader;
    private int numRecordsRead = 0;
    private final AtomicLong totalBytesRead = new AtomicLong(0L);
    private final AtomicLong totalFileBytes = new AtomicLong(0L);

    public UnorderedKVReader(ShuffleManager shuffleManager, Configuration conf, CompressionCodec codec, boolean ifileReadAhead, int ifileReadAheadLength, int ifileBufferSize, TezCounter inputRecordCounter, InputContext context) throws IOException {
        this.shuffleManager = shuffleManager;
        this.context = context;
        this.codec = codec;
        this.ifileReadAhead = ifileReadAhead;
        this.ifileReadAheadLength = ifileReadAheadLength;
        this.ifileBufferSize = ifileBufferSize;
        this.inputRecordCounter = inputRecordCounter;
        this.keyClass = ConfigUtils.getIntermediateInputKeyClass(conf);
        this.valClass = ConfigUtils.getIntermediateInputValueClass(conf);
        this.keyIn = new DataInputBuffer();
        this.valIn = new DataInputBuffer();
        SerializationFactory serializationFactory = new SerializationFactory(conf);
        this.keyDeserializer = serializationFactory.getDeserializer(this.keyClass);
        this.keyDeserializer.open((InputStream)this.keyIn);
        this.valDeserializer = serializationFactory.getDeserializer(this.valClass);
        this.valDeserializer.open((InputStream)this.valIn);
    }

    @Override
    public boolean next() throws IOException {
        if (this.readNextFromCurrentReader()) {
            this.inputRecordCounter.increment(1L);
            this.context.notifyProgress();
            ++this.numRecordsRead;
            return true;
        }
        boolean nextInputExists = this.moveToNextInput();
        while (nextInputExists) {
            if (this.readNextFromCurrentReader()) {
                this.inputRecordCounter.increment(1L);
                this.context.notifyProgress();
                ++this.numRecordsRead;
                return true;
            }
            nextInputExists = this.moveToNextInput();
        }
        LOG.info("Num Records read: " + this.numRecordsRead);
        this.completedProcessing = true;
        return false;
    }

    @Override
    public Object getCurrentKey() throws IOException {
        return this.key;
    }

    @Override
    public Object getCurrentValue() throws IOException {
        return this.value;
    }

    public float getProgress() throws IOException, InterruptedException {
        int numInputs = this.shuffleManager.getNumInputs();
        if (this.totalFileBytes.get() > 0L && numInputs > 0) {
            return 1.0f * ((float)this.totalBytesRead.get() + (this.currentReader != null ? (float)this.currentReader.bytesRead : 0.0f)) / (float)this.totalFileBytes.get() * (this.shuffleManager.getNumCompletedInputsFloat() / (1.0f * (float)numInputs));
        }
        return 0.0f;
    }

    private boolean readNextFromCurrentReader() throws IOException {
        if (this.currentReader == null) {
            return false;
        }
        boolean hasMore = this.currentReader.nextRawKey(this.keyIn);
        if (hasMore) {
            this.currentReader.nextRawValue(this.valIn);
            this.key = this.keyDeserializer.deserialize(this.key);
            this.value = this.valDeserializer.deserialize(this.value);
            return true;
        }
        return false;
    }

    private boolean moveToNextInput() throws IOException {
        if (this.currentReader != null) {
            this.totalBytesRead.getAndAdd(this.currentReader.bytesRead);
            this.currentReader.close();
            this.currentReader = null;
            this.currentFetchedInput.free();
        }
        try {
            this.currentFetchedInput = this.shuffleManager.getNextInput();
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for next available input", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new IOInterruptedException(e);
        }
        if (this.currentFetchedInput == null) {
            this.hasCompletedProcessing();
            return false;
        }
        this.currentReader = this.openIFileReader(this.currentFetchedInput);
        this.totalFileBytes.getAndAdd(this.currentReader.getLength());
        return true;
    }

    public IFile.Reader openIFileReader(FetchedInput fetchedInput) throws IOException {
        if (fetchedInput.getType() == FetchedInput.Type.MEMORY) {
            MemoryFetchedInput mfi = (MemoryFetchedInput)fetchedInput;
            return new InMemoryReader(null, mfi.getInputAttemptIdentifier(), mfi.getBytes(), 0, (int)mfi.getSize());
        }
        return new IFile.Reader(fetchedInput.getInputStream(), fetchedInput.getSize(), this.codec, null, null, this.ifileReadAhead, this.ifileReadAheadLength, this.ifileBufferSize);
    }
}

