/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.recovery.records.RecoveryProtos;

public class ContainerLaunchedEvent
implements HistoryEvent {
    private ContainerId containerId;
    private long launchTime;
    private ApplicationAttemptId applicationAttemptId;

    public ContainerLaunchedEvent() {
    }

    public ContainerLaunchedEvent(ContainerId containerId, long launchTime, ApplicationAttemptId applicationAttemptId) {
        this.containerId = containerId;
        this.launchTime = launchTime;
        this.applicationAttemptId = applicationAttemptId;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.CONTAINER_LAUNCHED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return false;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.ContainerLaunchedProto toProto() {
        return RecoveryProtos.ContainerLaunchedProto.newBuilder().setApplicationAttemptId(this.applicationAttemptId.toString()).setContainerId(this.containerId.toString()).setLaunchTime(this.launchTime).build();
    }

    public void fromProto(RecoveryProtos.ContainerLaunchedProto proto) {
        this.containerId = ConverterUtils.toContainerId((String)proto.getContainerId());
        this.launchTime = proto.getLaunchTime();
        this.applicationAttemptId = ConverterUtils.toApplicationAttemptId((String)proto.getApplicationAttemptId());
    }

    @Override
    public void toProtoStream(CodedOutputStream outputStream) throws IOException {
        outputStream.writeMessageNoTag((MessageLite)this.toProto());
    }

    @Override
    public void fromProtoStream(CodedInputStream inputStream) throws IOException {
        RecoveryProtos.ContainerLaunchedProto proto = (RecoveryProtos.ContainerLaunchedProto)inputStream.readMessage(RecoveryProtos.ContainerLaunchedProto.PARSER, null);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "containerId=" + this.containerId + ", launchTime=" + this.launchTime;
    }

    public ContainerId getContainerId() {
        return this.containerId;
    }

    public long getLaunchTime() {
        return this.launchTime;
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.applicationAttemptId;
    }
}

