/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.beanvalidator.modules;

import java.util.Map;
import javax.validation.MessageInterpolator;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.validation.groups.Default;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.beanvalidator.BeanValidatorConfigurer;
import org.apache.tapestry5.beanvalidator.BeanValidatorGroupSource;
import org.apache.tapestry5.beanvalidator.BeanValidatorSource;
import org.apache.tapestry5.beanvalidator.ClientConstraintDescriptor;
import org.apache.tapestry5.beanvalidator.ClientConstraintDescriptorSource;
import org.apache.tapestry5.internal.beanvalidator.BaseCCD;
import org.apache.tapestry5.internal.beanvalidator.BeanFieldValidatorDefaultSource;
import org.apache.tapestry5.internal.beanvalidator.BeanValidationGroupSourceImpl;
import org.apache.tapestry5.internal.beanvalidator.BeanValidatorSourceImpl;
import org.apache.tapestry5.internal.beanvalidator.ClientConstraintDescriptorImpl;
import org.apache.tapestry5.internal.beanvalidator.MessageInterpolatorImpl;
import org.apache.tapestry5.ioc.Configuration;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.annotations.Local;
import org.apache.tapestry5.ioc.services.PropertyShadowBuilder;
import org.apache.tapestry5.ioc.services.ThreadLocale;
import org.apache.tapestry5.services.FieldValidatorDefaultSource;
import org.apache.tapestry5.services.javascript.DataConstants;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

public class BeanValidatorModule {
    private static final String MODULE_NAME = "t5/beanvalidator/beanvalidator-validation";

    public static void bind(ServiceBinder binder) {
        binder.bind(FieldValidatorDefaultSource.class, BeanFieldValidatorDefaultSource.class).withSimpleId();
        binder.bind(BeanValidatorGroupSource.class, BeanValidationGroupSourceImpl.class);
        binder.bind(BeanValidatorSource.class, BeanValidatorSourceImpl.class);
        binder.bind(ClientConstraintDescriptorSource.class, ClientConstraintDescriptorImpl.class);
    }

    public static void contributeServiceOverride(MappedConfiguration<Class<?>, Object> configuration, @Local FieldValidatorDefaultSource source) {
        configuration.add(FieldValidatorDefaultSource.class, (Object)source);
    }

    public static Validator buildBeanValidator(ValidatorFactory validatorFactory, PropertyShadowBuilder propertyShadowBuilder) {
        return (Validator)propertyShadowBuilder.build((Object)validatorFactory, "validator", Validator.class);
    }

    public static ValidatorFactory buildValidatorFactory(BeanValidatorSource beanValidatorSource, PropertyShadowBuilder propertyShadowBuilder) {
        return (ValidatorFactory)propertyShadowBuilder.build((Object)beanValidatorSource, "validatorFactory", ValidatorFactory.class);
    }

    public static void contributeBeanValidatorGroupSource(Configuration<Class<?>> configuration) {
        configuration.add(Default.class);
    }

    public static void contributeBeanValidatorSource(OrderedConfiguration<BeanValidatorConfigurer> configuration, final ThreadLocale threadLocale) {
        configuration.add("LocaleAwareMessageInterpolator", (Object)new BeanValidatorConfigurer(){

            @Override
            public void configure(javax.validation.Configuration<?> configuration) {
                MessageInterpolator defaultInterpolator = configuration.getDefaultMessageInterpolator();
                configuration.messageInterpolator((MessageInterpolator)new MessageInterpolatorImpl(defaultInterpolator, threadLocale));
            }
        }, new String[0]);
    }

    public static void contributeClientConstraintDescriptorSource(final JavaScriptSupport javaScriptSupport, Configuration<ClientConstraintDescriptor> configuration) {
        configuration.add((Object)new BaseCCD(Max.class, new String[]{"value"}){

            @Override
            public void applyClientValidation(MarkupWriter writer, String message, Map<String, Object> attributes) {
                javaScriptSupport.require("t5/core/validation");
                writer.attributes(new Object[]{"data-validate", true, "data-validate-max", attributes.get("value"), "data-max-message", message});
            }
        });
        configuration.add((Object)new BaseCCD(Min.class, new String[]{"value"}){

            @Override
            public void applyClientValidation(MarkupWriter writer, String message, Map<String, Object> attributes) {
                javaScriptSupport.require("t5/core/validation");
                writer.attributes(new Object[]{DataConstants.VALIDATION_ATTRIBUTE, true, "data-validate-min", attributes.get("value"), "data-min-message", message});
            }
        });
        configuration.add((Object)new BaseCCD(NotNull.class, new String[0]){

            @Override
            public void applyClientValidation(MarkupWriter writer, String message, Map<String, Object> attributes) {
                javaScriptSupport.require("t5/core/validation");
                writer.attributes(new Object[]{DataConstants.VALIDATION_ATTRIBUTE, true, "data-optionality", "required", "data-required-message", message});
            }
        });
        configuration.add((Object)new BaseCCD(Null.class, new String[0]){

            @Override
            public void applyClientValidation(MarkupWriter writer, String message, Map<String, Object> attributes) {
                javaScriptSupport.require(BeanValidatorModule.MODULE_NAME);
                writer.attributes(new Object[]{DataConstants.VALIDATION_ATTRIBUTE, true, "data-optionality", "prohibited", "data-prohibited-message", message});
            }
        });
        configuration.add((Object)new BaseCCD(Pattern.class, new String[]{"regexp"}){

            @Override
            public void applyClientValidation(MarkupWriter writer, String message, Map<String, Object> attributes) {
                javaScriptSupport.require(BeanValidatorModule.MODULE_NAME);
                writer.attributes(new Object[]{DataConstants.VALIDATION_ATTRIBUTE, true, "data-validate-regexp", attributes.get("regexp"), "data-regexp-message", message});
            }
        });
        configuration.add((Object)new BaseCCD(Size.class, new String[]{"min", "max"}){

            @Override
            public void applyClientValidation(MarkupWriter writer, String message, Map<String, Object> attributes) {
                int max;
                javaScriptSupport.require(BeanValidatorModule.MODULE_NAME);
                writer.attributes(new Object[]{DataConstants.VALIDATION_ATTRIBUTE, true, "data-range-message", message});
                int min = (Integer)attributes.get("min");
                if (min != 0) {
                    writer.attributes(new Object[]{"data-range-min", min});
                }
                if ((max = ((Integer)attributes.get("max")).intValue()) != Integer.MAX_VALUE) {
                    writer.attributes(new Object[]{"data-range-max", max});
                }
            }
        });
        configuration.add((Object)new BaseCCD(AssertTrue.class, new String[0]){

            @Override
            public void applyClientValidation(MarkupWriter writer, String message, Map<String, Object> attributes) {
                javaScriptSupport.require("t5/core/validation");
                writer.attributes(new Object[]{DataConstants.VALIDATION_ATTRIBUTE, true, "data-expected-status", "checked", "data-checked-message", message});
            }
        });
        configuration.add((Object)new BaseCCD(AssertFalse.class, new String[0]){

            @Override
            public void applyClientValidation(MarkupWriter writer, String message, Map<String, Object> attributes) {
                javaScriptSupport.require("t5/core/validation");
                writer.attributes(new Object[]{DataConstants.VALIDATION_ATTRIBUTE, true, "data-expected-status", "unchecked", "data-checked-message", message});
            }
        });
    }
}

