/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.def.ServiceDef;
import org.apache.tapestry5.ioc.internal.IOCMessages;
import org.slf4j.Logger;

public class RecursiveServiceCreationCheckWrapper
implements ObjectCreator {
    private final ServiceDef serviceDef;
    private final ObjectCreator delegate;
    private final Logger logger;
    private boolean locked;

    public RecursiveServiceCreationCheckWrapper(ServiceDef serviceDef, ObjectCreator delegate, Logger logger) {
        this.serviceDef = serviceDef;
        this.delegate = delegate;
        this.logger = logger;
    }

    public Object createObject() {
        if (this.locked) {
            throw new IllegalStateException(IOCMessages.recursiveServiceBuild(this.serviceDef));
        }
        this.locked = true;
        try {
            return this.delegate.createObject();
        }
        catch (RuntimeException ex) {
            this.logger.error(IOCMessages.serviceConstructionFailed(this.serviceDef, ex), (Throwable)ex);
            this.locked = false;
            throw ex;
        }
    }
}

