/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.translator;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Set;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.internal.translator.BigDecimalNumericFormatter;
import org.apache.tapestry5.internal.translator.BigIntegerNumericFormatter;
import org.apache.tapestry5.internal.translator.NumericFormatter;
import org.apache.tapestry5.internal.translator.NumericFormatterImpl;
import org.apache.tapestry5.internal.translator.NumericTranslatorSupport;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ThreadLocale;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

public class NumericTranslatorSupportImpl
implements NumericTranslatorSupport {
    private final TypeCoercer typeCoercer;
    private final ThreadLocale threadLocale;
    private final JavaScriptSupport javascriptSupport;
    private final Set<Class> integerTypes = CollectionFactory.newSet();

    public NumericTranslatorSupportImpl(TypeCoercer typeCoercer, ThreadLocale threadLocale, JavaScriptSupport javascriptSupport) {
        Class[] integerTypes;
        this.typeCoercer = typeCoercer;
        this.threadLocale = threadLocale;
        this.javascriptSupport = javascriptSupport;
        for (Class c : integerTypes = new Class[]{Byte.class, Short.class, Integer.class, Long.class, BigInteger.class}) {
            this.integerTypes.add(c);
        }
    }

    @Override
    public <T extends Number> void setupTranslation(Class<T> type, Element element, String message) {
        String translation = this.isIntegerType(type) ? "integer" : "numeric";
        this.javascriptSupport.require("t5/core/validation");
        element.attributes("data-validation", "true", "data-translation", translation, "data-translation-message", message);
    }

    private boolean isIntegerType(Class type) {
        return this.integerTypes.contains(type);
    }

    @Override
    public <T extends Number> T parseClient(Class<T> type, String clientValue) throws ParseException {
        NumericFormatter formatter = this.getParseFormatter(type);
        Number number = formatter.parse(clientValue.trim());
        return (T)((Number)this.typeCoercer.coerce((Object)number, type));
    }

    private NumericFormatter getParseFormatter(Class type) {
        Locale locale = this.threadLocale.getLocale();
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
        if (type.equals(BigInteger.class)) {
            return new BigIntegerNumericFormatter(symbols);
        }
        if (type.equals(BigDecimal.class)) {
            return new BigDecimalNumericFormatter(symbols);
        }
        if (this.isIntegerType(type)) {
            NumberFormat format = NumberFormat.getIntegerInstance(locale);
            return new NumericFormatterImpl(format);
        }
        DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(locale);
        if (type.equals(BigDecimal.class)) {
            df.setParseBigDecimal(true);
        }
        return new NumericFormatterImpl(df);
    }

    private NumericFormatter getOutputFormatter(Class type) {
        Locale locale = this.threadLocale.getLocale();
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
        if (type.equals(BigInteger.class)) {
            return new BigIntegerNumericFormatter(symbols);
        }
        if (type.equals(BigDecimal.class)) {
            return new BigDecimalNumericFormatter(symbols);
        }
        if (!this.isIntegerType(type)) {
            NumberFormat format = NumberFormat.getNumberInstance(locale);
            return new NumericFormatterImpl(format);
        }
        DecimalFormat df = new DecimalFormat(NumericTranslatorSupportImpl.toString(symbols.getZeroDigit()), symbols);
        return new NumericFormatterImpl(df);
    }

    @Override
    public <T extends Number> String toClient(Class<T> type, T value) {
        return this.getOutputFormatter(type).toClient(value);
    }

    @Override
    public <T extends Number> String getMessageKey(Class<T> type) {
        return this.isIntegerType(type) ? "integer-format-exception" : "number-format-exception";
    }

    private static String toString(char ch) {
        return String.valueOf(ch);
    }
}

