/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.internal.services.PageRenderQueue;
import org.apache.tapestry5.internal.services.RenderQueueImpl;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.ioc.LoggerSource;
import org.apache.tapestry5.ioc.annotations.Scope;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.util.Stack;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.runtime.RenderCommand;
import org.apache.tapestry5.services.PartialMarkupRenderer;
import org.apache.tapestry5.services.PartialMarkupRendererFilter;
import org.slf4j.Logger;

@Scope(value="perthread")
public class PageRenderQueueImpl
implements PageRenderQueue {
    private final LoggerSource loggerSource;
    private Page page;
    private boolean partialRenderInitialized;
    private final Stack<PartialMarkupRendererFilter> filters = CollectionFactory.newStack();
    private RenderQueueImpl queue;

    public PageRenderQueueImpl(LoggerSource loggerSource) {
        this.loggerSource = loggerSource;
    }

    @Override
    public void initializeForCompletePage(Page page) {
        this.setRenderingPage(page);
        this.queue.push(page.getRootElement());
    }

    @Override
    public void setRenderingPage(Page page) {
        assert (page != null);
        this.page = page;
        String name = "tapestry.render." + page.getLogger().getName();
        Logger logger = this.loggerSource.getLogger(name);
        this.queue = new RenderQueueImpl(logger);
    }

    @Override
    public boolean isPartialRenderInitialized() {
        return this.partialRenderInitialized;
    }

    @Override
    public void addPartialRenderer(RenderCommand renderer) {
        assert (renderer != null);
        this.checkQueue();
        this.partialRenderInitialized = true;
        this.queue.push(renderer);
    }

    private void checkQueue() {
        if (this.queue == null) {
            throw new IllegalStateException("The page used as the basis for partial rendering has not been set.");
        }
    }

    @Override
    public Page getRenderingPage() {
        return this.page;
    }

    @Override
    public void render(MarkupWriter writer) {
        this.queue.run(writer);
    }

    @Override
    public void addPartialMarkupRendererFilter(PartialMarkupRendererFilter filter) {
        assert (filter != null);
        this.partialRenderInitialized = true;
        this.filters.push((Object)filter);
    }

    @Override
    public void renderPartial(MarkupWriter writer, JSONObject reply) {
        PartialMarkupRenderer terminator;
        this.checkQueue();
        PartialMarkupRenderer delegate = terminator = new PartialMarkupRenderer(){

            @Override
            public void renderMarkup(MarkupWriter writer, JSONObject reply) {
                PageRenderQueueImpl.this.render(writer);
            }
        };
        while (!this.filters.isEmpty()) {
            PartialMarkupRendererFilter filter = (PartialMarkupRendererFilter)this.filters.pop();
            Bridge bridge = new Bridge(filter, delegate);
            delegate = bridge;
        }
        delegate.renderMarkup(writer, reply);
    }

    private static class Bridge
    implements PartialMarkupRenderer {
        private final PartialMarkupRendererFilter filter;
        private final PartialMarkupRenderer delegate;

        private Bridge(PartialMarkupRendererFilter filter, PartialMarkupRenderer delegate) {
            this.filter = filter;
            this.delegate = delegate;
        }

        @Override
        public void renderMarkup(MarkupWriter writer, JSONObject reply) {
            this.filter.renderMarkup(writer, reply, this.delegate);
        }
    }
}

