/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.ComponentEventCallback;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.FieldTranslator;
import org.apache.tapestry5.FieldValidationSupport;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.NullFieldStrategy;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.internal.util.Holder;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.ioc.util.ExceptionUtils;

public class FieldValidationSupportImpl
implements FieldValidationSupport {
    private final TypeCoercer typeCoercer;
    private final PropertyAccess propertyAccess;

    public FieldValidationSupportImpl(TypeCoercer typeCoercer, PropertyAccess propertyAccess) {
        this.typeCoercer = typeCoercer;
        this.propertyAccess = propertyAccess;
    }

    @Override
    public String toClient(Object value, ComponentResources componentResources, FieldTranslator<Object> translator, NullFieldStrategy nullFieldStrategy) {
        assert (componentResources != null);
        assert (translator != null);
        assert (nullFieldStrategy != null);
        final Holder resultHolder = Holder.create();
        ComponentEventCallback callback = new ComponentEventCallback(){

            public boolean handleResult(Object result) {
                if (!(result instanceof String)) {
                    throw new RuntimeException("Return value from 'parseClient' event handler method must be a string.");
                }
                resultHolder.put((String)result);
                return true;
            }
        };
        componentResources.triggerEvent("toClient", new Object[]{value}, callback);
        if (resultHolder.hasValue()) {
            return (String)resultHolder.get();
        }
        Object effectiveValue = value;
        if (effectiveValue == null && (effectiveValue = nullFieldStrategy.replaceToClient()) == null) {
            return null;
        }
        Object coerced = this.typeCoercer.coerce(effectiveValue, translator.getType());
        return translator.toClient(coerced);
    }

    @Override
    public Object parseClient(String clientValue, ComponentResources componentResources, FieldTranslator<Object> translator, NullFieldStrategy nullFieldStrategy) throws ValidationException {
        assert (componentResources != null);
        assert (translator != null);
        assert (nullFieldStrategy != null);
        String effectiveValue = clientValue;
        if (InternalUtils.isBlank((String)effectiveValue) && (effectiveValue = nullFieldStrategy.replaceFromClient()) == null) {
            return null;
        }
        final Holder resultHolder = Holder.create();
        ComponentEventCallback callback = new ComponentEventCallback(){

            public boolean handleResult(Object result) {
                resultHolder.put(result);
                return true;
            }
        };
        try {
            componentResources.triggerEvent("parseClient", new Object[]{effectiveValue}, callback);
        }
        catch (RuntimeException ex) {
            this.rethrowValidationException(ex);
        }
        if (resultHolder.hasValue()) {
            return resultHolder.get();
        }
        return translator.parse(effectiveValue);
    }

    private void rethrowValidationException(RuntimeException outerException) throws ValidationException {
        ValidationException ve = (ValidationException)ExceptionUtils.findCause((Throwable)outerException, ValidationException.class, (PropertyAccess)this.propertyAccess);
        if (ve != null) {
            throw ve;
        }
        throw outerException;
    }

    @Override
    public void validate(Object value, ComponentResources componentResources, FieldValidator validator) throws ValidationException {
        assert (componentResources != null);
        assert (validator != null);
        validator.validate(value);
        try {
            componentResources.triggerEvent("validate", new Object[]{value}, null);
        }
        catch (RuntimeException ex) {
            this.rethrowValidationException(ex);
        }
    }
}

