/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.event;

import java.util.List;
import java.util.Map;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.services.InvalidationEventHub;
import org.apache.tapestry5.services.InvalidationListener;

public class InvalidationEventHubImpl
implements InvalidationEventHub {
    private final List<Runnable> callbacks;

    protected InvalidationEventHubImpl(boolean productionMode) {
        this.callbacks = productionMode ? null : CollectionFactory.newThreadSafeList();
    }

    protected final void fireInvalidationEvent() {
        if (this.callbacks == null) {
            return;
        }
        for (Runnable callback : this.callbacks) {
            callback.run();
        }
    }

    public final void addInvalidationCallback(Runnable callback) {
        assert (callback != null);
        if (this.callbacks != null) {
            this.callbacks.add(callback);
        }
    }

    public final void clearOnInvalidation(final Map<?, ?> map) {
        assert (map != null);
        this.addInvalidationCallback(new Runnable(){

            @Override
            public void run() {
                map.clear();
            }
        });
    }

    public final void addInvalidationListener(final InvalidationListener listener) {
        assert (listener != null);
        this.addInvalidationCallback(new Runnable(){

            @Override
            public void run() {
                listener.objectWasInvalidated();
            }
        });
    }
}

