/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.matrix.data.MatrixCell;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.data.MatrixValue;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.ReorgOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public class WeightedCell
extends MatrixCell {
    private static final long serialVersionUID = -2283995259000895325L;
    protected double weight = 0.0;

    public String toString() {
        return this.value + ": " + this.weight;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.value = in.readDouble();
        this.weight = in.readDouble();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeDouble(this.value);
        out.writeDouble(this.weight);
    }

    private static WeightedCell checkType(MatrixValue cell) {
        if (cell != null && !(cell instanceof WeightedCell)) {
            throw new DMLRuntimeException("the Matrix Value is not WeightedCell!");
        }
        return (WeightedCell)cell;
    }

    @Override
    public void copy(MatrixValue that) {
        WeightedCell c2;
        try {
            c2 = WeightedCell.checkType(that);
        }
        catch (DMLRuntimeException e) {
            throw new RuntimeException(e);
        }
        this.value = c2.getValue();
        this.weight = c2.getWeight();
    }

    @Override
    public int compareTo(Object o) {
        if (!(o instanceof WeightedCell)) {
            return -1;
        }
        WeightedCell that = (WeightedCell)o;
        if (this.value != that.value) {
            return Double.compare(this.value, that.value);
        }
        if (this.weight != that.weight) {
            return Double.compare(this.weight, that.weight);
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof WeightedCell)) {
            return false;
        }
        WeightedCell that = (WeightedCell)o;
        return this.value == that.value && this.weight == that.weight;
    }

    @Override
    public int hashCode() {
        throw new RuntimeException("hashCode() should never be called on instances of this class.");
    }

    public void setWeight(double w) {
        this.weight = w;
    }

    public double getWeight() {
        return this.weight;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public MatrixValue aggregateUnaryOperations(AggregateUnaryOperator op, MatrixValue result, int blen, MatrixIndexes indexesIn, boolean inCP) {
        super.aggregateUnaryOperations(op, result, blen, indexesIn, inCP);
        WeightedCell c3 = WeightedCell.checkType(result);
        c3.setWeight(this.weight);
        return c3;
    }

    @Override
    public void denseScalarOperationsInPlace(ScalarOperator op) {
        this.value = op.executeScalar(this.value);
    }

    @Override
    public MatrixValue reorgOperations(ReorgOperator op, MatrixValue result, int startRow, int startColumn, int length) {
        super.reorgOperations(op, result, startRow, startColumn, length);
        WeightedCell c3 = WeightedCell.checkType(result);
        c3.setWeight(this.weight);
        return c3;
    }

    @Override
    public MatrixValue scalarOperations(ScalarOperator op, MatrixValue result) {
        WeightedCell c3 = WeightedCell.checkType(result);
        c3.setValue(op.fn.execute(this.value, op.getConstant()));
        c3.setWeight(this.weight);
        return c3;
    }

    @Override
    public void sparseScalarOperationsInPlace(ScalarOperator op) {
        this.value = op.executeScalar(this.value);
    }

    @Override
    public void sparseUnaryOperationsInPlace(UnaryOperator op) {
        this.value = op.fn.execute(this.value);
    }

    @Override
    public MatrixValue unaryOperations(UnaryOperator op, MatrixValue result) {
        WeightedCell c3 = WeightedCell.checkType(result);
        c3.setValue(op.fn.execute(this.value));
        c3.setWeight(this.weight);
        return c3;
    }
}

