/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.dictionary.AIdentityDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IdentityDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class IdentityDictionarySlice
extends AIdentityDictionary {
    private static final long serialVersionUID = 2535887782153555098L;
    private final int l;
    private final int u;

    public IdentityDictionarySlice(int nRowCol, boolean withEmpty, int l, int u) {
        super(nRowCol, withEmpty);
        this.l = l;
        this.u = u;
    }

    public static IDictionary create(int nRowCol, boolean withEmpty, int l, int u) {
        if (u > nRowCol || l < 0 || l >= u) {
            throw new DMLRuntimeException("Invalid slice Identity: " + nRowCol + " range: " + l + "--" + u);
        }
        if (nRowCol == 1) {
            if (withEmpty) {
                return new Dictionary(new double[]{1.0, 0.0});
            }
            return new Dictionary(new double[]{1.0});
        }
        if (l == 0 && u == nRowCol) {
            return IdentityDictionary.create(nRowCol, withEmpty);
        }
        return new IdentityDictionarySlice(nRowCol, withEmpty, l, u);
    }

    @Override
    public double[] getValues() {
        LOG.warn((Object)"Should not call getValues on Identity Dictionary");
        int nCol = this.u - this.l;
        double[] ret = new double[nCol * (this.nRowCol + (this.withEmpty ? 1 : 0))];
        for (int i = this.l; i < this.u; ++i) {
            ret[i * nCol + (i - this.l)] = 1.0;
        }
        return ret;
    }

    @Override
    public double getValue(int i) {
        int nCol = this.u - this.l;
        int vRow = i / nCol;
        if (vRow < this.l || vRow >= this.u) {
            return 0.0;
        }
        int oRow = vRow - this.l;
        int col = i % nCol;
        return oRow == col ? 1.0 : 0.0;
    }

    @Override
    public final double getValue(int r, int c, int nCol) {
        if (r < this.l || r > this.u) {
            return 0.0;
        }
        return r - this.l == c ? 1.0 : 0.0;
    }

    @Override
    public long getInMemorySize() {
        return IdentityDictionarySlice.getInMemorySize(this.nRowCol);
    }

    public static long getInMemorySize(int numberColumns) {
        return AIdentityDictionary.getInMemorySize(numberColumns) + 8L;
    }

    @Override
    public double[] aggregateRows(Builtin fn, int nCol) {
        double[] ret = new double[this.nRowCol + (this.withEmpty ? 1 : 0)];
        if (this.l + 1 == this.u) {
            ret[this.l] = 1.0;
            return ret;
        }
        Arrays.fill(ret, this.l, this.u, fn.execute(1L, 0L));
        return ret;
    }

    @Override
    public void aggregateCols(double[] c, Builtin fn, IColIndex colIndexes) {
        for (int i = 0; i < this.u - this.l; ++i) {
            int idx = colIndexes.get(i);
            c[idx] = fn.execute(c[idx], 0.0);
            c[idx] = fn.execute(c[idx], 1.0);
        }
    }

    @Override
    public IDictionary clone() {
        return new IdentityDictionarySlice(this.nRowCol, this.withEmpty, this.l, this.u);
    }

    @Override
    public IDictionary.DictType getDictType() {
        return IDictionary.DictType.IdentitySlice;
    }

    @Override
    public double[] sumAllRowsToDouble(int nrColumns) {
        double[] ret = new double[this.nRowCol + (this.withEmpty ? 1 : 0)];
        Arrays.fill(ret, this.l, this.u, 1.0);
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleWithDefault(double[] defaultTuple) {
        int i;
        double[] ret = new double[this.getNumberOfValues(defaultTuple.length) + 1];
        for (i = this.l; i < this.u; ++i) {
            ret[i] = 1.0;
        }
        for (i = 0; i < defaultTuple.length; ++i) {
            int n = ret.length - 1;
            ret[n] = ret[n] + defaultTuple[i];
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleWithReference(double[] reference) {
        int i;
        double[] ret = new double[this.getNumberOfValues(reference.length)];
        double refSum = 0.0;
        for (i = 0; i < reference.length; ++i) {
            refSum += reference[i];
        }
        for (i = 0; i < this.l; ++i) {
            ret[i] = refSum;
        }
        for (i = this.l; i < this.u; ++i) {
            ret[i] = 1.0 + refSum;
        }
        for (i = this.u; i < ret.length; ++i) {
            ret[i] = refSum;
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleSq(int nrColumns) {
        double[] ret = new double[this.nRowCol + (this.withEmpty ? 1 : 0)];
        Arrays.fill(ret, this.l, this.u, 1.0);
        return ret;
    }

    @Override
    public double[] productAllRowsToDouble(int nCol) {
        double[] ret = new double[this.nRowCol + (this.withEmpty ? 1 : 0)];
        if (this.u - this.l - 1 == 0) {
            ret[this.l] = 1.0;
        }
        return ret;
    }

    @Override
    public double[] productAllRowsToDoubleWithDefault(double[] defaultTuple) {
        int nVal = this.nRowCol + (this.withEmpty ? 1 : 0);
        double[] ret = new double[nVal + 1];
        if (this.u - this.l - 1 == 0) {
            ret[this.l] = 1.0;
        }
        ret[nVal] = defaultTuple[0];
        for (int i = 1; i < defaultTuple.length; ++i) {
            int n = nVal;
            ret[n] = ret[n] * defaultTuple[i];
        }
        return ret;
    }

    @Override
    public void colSum(double[] c, int[] counts, IColIndex colIndexes) {
        for (int i = this.l; i < this.u; ++i) {
            c[colIndexes.get((int)(i - this.l))] = counts[i];
        }
    }

    @Override
    public double sum(int[] counts, int ncol) {
        double s = 0.0;
        for (int i = this.l; i < this.u; ++i) {
            s += (double)counts[i];
        }
        return s;
    }

    @Override
    public double sumSq(int[] counts, int ncol) {
        return this.sum(counts, ncol);
    }

    @Override
    public long getNumberNonZeros(int[] counts, int nCol) {
        return (long)this.sum(counts, nCol);
    }

    @Override
    public int getNumberOfValues(int ncol) {
        return this.nRowCol + (this.withEmpty ? 1 : 0);
    }

    @Override
    public int getNumberOfColumns(int nrow) {
        if (nrow != this.nRowCol + (this.withEmpty ? 1 : 0)) {
            throw new DMLCompressionException("Invalid call to get Number of values assuming wrong number of columns");
        }
        return this.u - this.l;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(DictionaryFactory.Type.IDENTITY_SLICE.ordinal());
        out.writeInt(this.nRowCol);
        out.writeBoolean(this.withEmpty);
        out.writeInt(this.l);
        out.writeInt(this.u);
    }

    public static IdentityDictionarySlice read(DataInput in) throws IOException {
        int nRowCol = in.readInt();
        boolean empty = in.readBoolean();
        int l = in.readInt();
        int u = in.readInt();
        return new IdentityDictionarySlice(nRowCol, empty, l, u);
    }

    @Override
    public long getExactSizeOnDisk() {
        return 14L;
    }

    @Override
    public double getSparsity() {
        return (double)(this.u - this.l) / (double)((this.u - this.l) * (this.nRowCol + (this.withEmpty ? 1 : 0)));
    }

    @Override
    public void addToEntry(double[] v, int fr, int to, int nCol, int rep) {
        if (fr >= this.l && fr < this.u) {
            int n = to * nCol + fr - this.l;
            v[n] = v[n] + (double)rep;
        }
    }

    @Override
    public boolean equals(IDictionary o) {
        if (o instanceof IdentityDictionarySlice) {
            IdentityDictionarySlice os = (IdentityDictionarySlice)o;
            return os.nRowCol == this.nRowCol && os.l == this.l && os.u == this.u && this.withEmpty == os.withEmpty;
        }
        if (o instanceof IdentityDictionary) {
            return false;
        }
        return this.getMBDict().equals(o);
    }

    @Override
    public MatrixBlockDictionary getMBDict() {
        return this.getMBDict(this.nRowCol);
    }

    @Override
    public MatrixBlockDictionary createMBDict(int nCol) {
        MatrixBlock identity = new MatrixBlock(this.nRowCol + (this.withEmpty ? 1 : 0), this.u - this.l, true);
        for (int i = this.l; i < this.u; ++i) {
            identity.set(i, i - this.l, 1.0);
        }
        return new MatrixBlockDictionary(identity);
    }

    @Override
    public String getString(int colIndexes) {
        return this.toString();
    }

    public String toString() {
        return "IdentityMatrixSlice of size: " + this.nRowCol + " l " + this.l + " u " + this.u;
    }
}

