/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.common;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.sysds.common.InstructionType;
import org.apache.sysds.common.Types;

public enum Opcodes {
    MMULT("ba+*", InstructionType.AggregateBinary),
    TAKPM("tak+*", InstructionType.AggregateTernary),
    TACKPM("tack+*", InstructionType.AggregateTernary),
    UAKP("uak+", InstructionType.AggregateUnary),
    UARKP("uark+", InstructionType.AggregateUnary),
    UACKP("uack+", InstructionType.AggregateUnary),
    UASQKP("uasqk+", InstructionType.AggregateUnary),
    UARSQKP("uarsqk+", InstructionType.AggregateUnary),
    UACSQKP("uacsqk+", InstructionType.AggregateUnary),
    UAMEAN("uamean", InstructionType.AggregateUnary),
    UARMEAN("uarmean", InstructionType.AggregateUnary),
    UACMEAN("uacmean", InstructionType.AggregateUnary),
    UAVAR("uavar", InstructionType.AggregateUnary),
    UARVAR("uarvar", InstructionType.AggregateUnary),
    UACVAR("uacvar", InstructionType.AggregateUnary),
    UAMAX("uamax", InstructionType.AggregateUnary),
    UARMAX("uarmax", InstructionType.AggregateUnary),
    UARIMAX("uarimax", InstructionType.AggregateUnary),
    UACMAX("uacmax", InstructionType.AggregateUnary),
    UAMIN("uamin", InstructionType.AggregateUnary),
    UARMIN("uarmin", InstructionType.AggregateUnary),
    UARIMIN("uarimin", InstructionType.AggregateUnary),
    UACMIN("uacmin", InstructionType.AggregateUnary),
    UAP("ua+", InstructionType.AggregateUnary),
    UARP("uar+", InstructionType.AggregateUnary),
    UACP("uac+", InstructionType.AggregateUnary),
    UAM("ua*", InstructionType.AggregateUnary),
    UARM("uar*", InstructionType.AggregateUnary),
    UACM("uac*", InstructionType.AggregateUnary),
    UATRACE("uatrace", InstructionType.AggregateUnary),
    UAKTRACE("uaktrace", InstructionType.AggregateUnary),
    NROW("nrow", InstructionType.AggregateUnary),
    NCOL("ncol", InstructionType.AggregateUnary),
    LENGTH("length", InstructionType.AggregateUnary),
    EXISTS("exists", InstructionType.AggregateUnary),
    LINEAGE("lineage", InstructionType.AggregateUnary),
    UACD("uacd", InstructionType.AggregateUnary, InstructionType.AggregateUnarySketch),
    UACDR("uacdr", InstructionType.AggregateUnary, InstructionType.AggregateUnarySketch),
    UACDC("uacdc", InstructionType.AggregateUnary, InstructionType.AggregateUnarySketch),
    UACDAP("uacdap", InstructionType.AggregateUnary, InstructionType.AggregateUnarySketch),
    UACDAPR("uacdapr", InstructionType.AggregateUnary, InstructionType.AggregateUnarySketch),
    UACDAPC("uacdapc", InstructionType.AggregateUnary, InstructionType.AggregateUnarySketch),
    UNIQUE("unique", InstructionType.AggregateUnary),
    UNIQUER("uniquer", InstructionType.AggregateUnary),
    UNIQUEC("uniquec", InstructionType.AggregateUnary),
    UAGGOUTERCHAIN("uaggouterchain", InstructionType.UaggOuterChain),
    PLUS("+", InstructionType.Binary),
    MINUS("-", InstructionType.Binary),
    MULT("*", InstructionType.Binary),
    DIV("/", InstructionType.Binary),
    MODULUS("%%", InstructionType.Binary),
    INTDIV("%/%", InstructionType.Binary),
    POW("^", InstructionType.Binary),
    MINUS1_MULT("1-*", InstructionType.Binary),
    POW2("^2", InstructionType.Binary),
    MULT2("*2", InstructionType.Binary),
    MINUS_NZ("-nz", InstructionType.Binary),
    AND("&&", InstructionType.Binary),
    OR("||", InstructionType.Binary),
    XOR("xor", InstructionType.Binary),
    BITWAND("bitwAnd", InstructionType.Binary),
    BITWOR("bitwOr", InstructionType.Binary),
    BITWXOR("bitwXor", InstructionType.Binary),
    BITWSHIFTL("bitwShiftL", InstructionType.Binary),
    BITWSHIFTR("bitwShiftR", InstructionType.Binary),
    NOT("!", InstructionType.Unary),
    EQUAL("==", InstructionType.Binary),
    NOTEQUAL("!=", InstructionType.Binary),
    LESS("<", InstructionType.Binary),
    GREATER(">", InstructionType.Binary),
    LESSEQUAL("<=", InstructionType.Binary),
    GREATEREQUAL(">=", InstructionType.Binary),
    LOG("log", InstructionType.Builtin),
    LOGNZ("log_nz", InstructionType.Builtin),
    SOLVE("solve", InstructionType.Binary),
    MAX("max", InstructionType.Binary),
    MIN("min", InstructionType.Binary),
    DROPINVALIDTYPE("dropInvalidType", InstructionType.Binary),
    DROPINVALIDLENGTH("dropInvalidLength", InstructionType.Binary),
    FREPLICATE("freplicate", InstructionType.Binary),
    VALUESWAP("valueSwap", InstructionType.Binary),
    APPLYSCHEMA("applySchema", InstructionType.Binary),
    MAP("_map", InstructionType.Ternary),
    NMAX("nmax", InstructionType.BuiltinNary),
    NMIN("nmin", InstructionType.BuiltinNary),
    NP("n+", InstructionType.BuiltinNary),
    NM("n*", InstructionType.BuiltinNary),
    EXP("exp", InstructionType.Unary),
    ABS("abs", InstructionType.Unary),
    SIN("sin", InstructionType.Unary),
    COS("cos", InstructionType.Unary),
    TAN("tan", InstructionType.Unary),
    SINH("sinh", InstructionType.Unary),
    COSH("cosh", InstructionType.Unary),
    TANH("tanh", InstructionType.Unary),
    ASIN("asin", InstructionType.Unary),
    ACOS("acos", InstructionType.Unary),
    ATAN("atan", InstructionType.Unary),
    SIGN("sign", InstructionType.Unary),
    SQRT("sqrt", InstructionType.Unary),
    SQRT_MATRIX_JAVA("sqrt_matrix_java", InstructionType.Unary),
    PLOGP("plogp", InstructionType.Unary),
    PRINT("print", InstructionType.Unary),
    ASSERT("assert", InstructionType.Unary),
    ROUND("round", InstructionType.Unary),
    CEIL("ceil", InstructionType.Unary),
    FLOOR("floor", InstructionType.Unary),
    UCUMKP("ucumk+", InstructionType.Unary),
    UCUMM("ucum*", InstructionType.Unary),
    UCUMKPM("ucumk+*", InstructionType.Unary),
    UCUMMIN("ucummin", InstructionType.Unary),
    UCUMMAX("ucummax", InstructionType.Unary),
    STOP("stop", InstructionType.Unary),
    INVERSE("inverse", InstructionType.Unary),
    CHOLESKY("cholesky", InstructionType.Unary),
    DET("det", InstructionType.Unary),
    SPROP("sprop", InstructionType.Unary),
    SIGMOID("sigmoid", InstructionType.Unary),
    TYPEOF("typeOf", InstructionType.Unary),
    DETECTSCHEMA("detectSchema", InstructionType.Unary),
    COLNAMES("colnames", InstructionType.Unary),
    ISNA("isna", InstructionType.Unary),
    ISNAN("isnan", InstructionType.Unary),
    ISINF("isinf", InstructionType.Unary),
    PRINTF("printf", InstructionType.BuiltinNary),
    CBIND("cbind", InstructionType.BuiltinNary),
    RBIND("rbind", InstructionType.BuiltinNary),
    EVAL("eval", InstructionType.BuiltinNary),
    LIST("list", InstructionType.BuiltinNary),
    AUTODIFF("autoDiff", InstructionType.ParameterizedBuiltin),
    CONTAINS("contains", InstructionType.ParameterizedBuiltin),
    PARAMSERV("paramserv", InstructionType.ParameterizedBuiltin),
    NVLIST("nvlist", InstructionType.ParameterizedBuiltin),
    CDF("cdf", InstructionType.ParameterizedBuiltin),
    INVCDF("invcdf", InstructionType.ParameterizedBuiltin),
    GROUPEDAGG("groupedagg", InstructionType.ParameterizedBuiltin),
    RMEMPTY("rmempty", InstructionType.ParameterizedBuiltin),
    REPLACE("replace", InstructionType.ParameterizedBuiltin),
    LOWERTRI("lowertri", InstructionType.ParameterizedBuiltin),
    UPPERTRI("uppertri", InstructionType.ParameterizedBuiltin),
    REXPAND("rexpand", InstructionType.ParameterizedBuiltin),
    TOSTRING("toString", InstructionType.ParameterizedBuiltin),
    TOKENIZE("tokenize", InstructionType.ParameterizedBuiltin),
    TRANSFORMAPPLY("transformapply", InstructionType.ParameterizedBuiltin),
    TRANSFORMDECODE("transformdecode", InstructionType.ParameterizedBuiltin),
    TRANSFORMCOLMAP("transformcolmap", InstructionType.ParameterizedBuiltin),
    TRANSFORMMETA("transformmeta", InstructionType.ParameterizedBuiltin),
    TRANSFORMENCODE("transformencode", InstructionType.MultiReturnParameterizedBuiltin, InstructionType.MultiReturnBuiltin),
    PM("+*", InstructionType.Ternary),
    MINUSMULT("-*", InstructionType.Ternary),
    IFELSE("ifelse", InstructionType.Ternary),
    ASSIGNVAR("assignvar", InstructionType.Variable),
    CPVAR("cpvar", InstructionType.Variable),
    MVVAR("mvvar", InstructionType.Variable),
    RMVAR("rmvar", InstructionType.Variable),
    RMFILEVAR("rmfilevar", InstructionType.Variable),
    CAST_AS_SCALAR(Types.OpOp1.CAST_AS_SCALAR.toString(), InstructionType.Variable),
    CAST_AS_MATRIX(Types.OpOp1.CAST_AS_MATRIX.toString(), InstructionType.Variable, InstructionType.Cast),
    CAST_AS_FRAME_VAR("cast_as_frame", InstructionType.Variable),
    CAST_AS_FRAME(Types.OpOp1.CAST_AS_FRAME.toString(), InstructionType.Variable, InstructionType.Cast),
    CAST_AS_LIST(Types.OpOp1.CAST_AS_LIST.toString(), InstructionType.Variable),
    CAST_AS_DOUBLE(Types.OpOp1.CAST_AS_DOUBLE.toString(), InstructionType.Variable),
    CAST_AS_INT(Types.OpOp1.CAST_AS_INT.toString(), InstructionType.Variable),
    CAST_AS_BOOLEAN(Types.OpOp1.CAST_AS_BOOLEAN.toString(), InstructionType.Variable),
    ATTACHFILETOVAR("attachfiletovar", InstructionType.Variable),
    READ("read", InstructionType.Variable),
    WRITE("write", InstructionType.Variable, InstructionType.Write),
    CREATEVAR("createvar", InstructionType.Variable),
    TRANSPOSE("r'", InstructionType.Reorg),
    REV("rev", InstructionType.Reorg),
    ROLL("roll", InstructionType.Reorg),
    DIAG("rdiag", InstructionType.Reorg),
    RESHAPE("rshape", InstructionType.Reshape, InstructionType.MatrixReshape),
    SORT("rsort", InstructionType.Reorg),
    RELU_BACKWARD("relu_backward", InstructionType.Dnn),
    RELU_MAXPOOLING("relu_maxpooling", InstructionType.Dnn),
    RELU_MAXPOOLING_BACKWARD("relu_maxpooling_backward", InstructionType.Dnn),
    MAXPOOLING("maxpooling", InstructionType.Dnn),
    MAXPOOLING_BACKWARD("maxpooling_backward", InstructionType.Dnn),
    AVGPOOLING("avgpooling", InstructionType.Dnn),
    AVGPOOLING_BACKWARD("avgpooling_backward", InstructionType.Dnn),
    CONV2D("conv2d", InstructionType.Dnn),
    CONV2D_BIAS_ADD("conv2d_bias_add", InstructionType.Dnn),
    CONV2D_BACKWARD_FILTER("conv2d_backward_filter", InstructionType.Dnn),
    CONV2D_BACKWARD_DATA("conv2d_backward_data", InstructionType.Dnn),
    BIAS_ADD("bias_add", InstructionType.Dnn),
    BIAS_MULTIPLY("bias_multiply", InstructionType.Dnn),
    BATCH_NORM2D("batch_norm2d", InstructionType.Dnn),
    BATCH_NORM2D_BACKWARD("batch_norm2d_backward", InstructionType.Dnn),
    LSTM("lstm", InstructionType.Dnn),
    LSTM_BACKWARD("lstm_backward", InstructionType.Dnn),
    WSLOSS("wsloss", InstructionType.Quaternary),
    WSIGMOID("wsigmoid", InstructionType.Quaternary),
    WDIVMM("wdivmm", InstructionType.Quaternary),
    WCEMM("wcemm", InstructionType.Quaternary),
    WUMM("wumm", InstructionType.Quaternary),
    FCALL("fcall", InstructionType.FCall),
    APPEND("append", InstructionType.Append),
    REMOVE("remove", InstructionType.Append),
    RANDOM("rand", InstructionType.Rand),
    SEQUENCE("seq", InstructionType.Rand),
    STRINGINIT("sinit", InstructionType.StringInit),
    SAMPLE("sample", InstructionType.Rand),
    TIME("time", InstructionType.Rand),
    FRAME("frame", InstructionType.Rand),
    CTABLE("ctable", InstructionType.Ctable),
    CTABLEEXPAND("ctableexpand", InstructionType.Ctable),
    CM("cm", InstructionType.CentralMoment),
    COV("cov", InstructionType.Covariance),
    QSORT("qsort", InstructionType.QSort),
    QPICK("qpick", InstructionType.QPick),
    RIGHT_INDEX("rightIndex", InstructionType.MatrixIndexing),
    LEFT_INDEX("leftIndex", InstructionType.MatrixIndexing),
    TSMM("tsmm", InstructionType.MMTSJ, InstructionType.TSMM, InstructionType.Tsmm),
    PMM("pmm", InstructionType.PMMJ, InstructionType.PMM),
    MMCHAIN("mmchain", InstructionType.MMChain),
    QR("qr", InstructionType.MultiReturnBuiltin),
    LU("lu", InstructionType.MultiReturnBuiltin),
    EIGEN("eigen", InstructionType.MultiReturnBuiltin),
    FFT("fft", InstructionType.MultiReturnBuiltin),
    IFFT("ifft", InstructionType.MultiReturnComplexMatrixBuiltin),
    FFT_LINEARIZED("fft_linearized", InstructionType.MultiReturnBuiltin),
    IFFT_LINEARIZED("ifft_linearized", InstructionType.MultiReturnComplexMatrixBuiltin),
    STFT("stft", InstructionType.MultiReturnComplexMatrixBuiltin),
    SVD("svd", InstructionType.MultiReturnBuiltin),
    RCM("rcm", InstructionType.MultiReturnComplexMatrixBuiltin),
    PARTITION("partition", InstructionType.Partition),
    COMPRESS("compress", InstructionType.Compression, InstructionType.Compression),
    DECOMPRESS("decompress", InstructionType.DeCompression, InstructionType.DeCompression),
    SPOOF("spoof", InstructionType.SpoofFused),
    PREFETCH("prefetch", InstructionType.Prefetch),
    EVICT("_evict", InstructionType.EvictLineageCache),
    BROADCAST("broadcast", InstructionType.Broadcast),
    TRIGREMOTE("trigremote", InstructionType.TrigRemote),
    LOCAL("local", InstructionType.Local),
    SQL("sql", InstructionType.Sql),
    MAPMM("mapmm", InstructionType.MAPMM),
    MAPMMCHAIN("mapmmchain", InstructionType.MAPMMCHAIN),
    TSMM2("tsmm2", InstructionType.TSMM2),
    CPMM("cpmm", InstructionType.CPMM),
    RMM("rmm", InstructionType.RMM),
    ZIPMM("zipmm", InstructionType.ZIPMM),
    PMAPMM("pmapmm", InstructionType.PMAPMM),
    MAPLEFTINDEX("mapLeftIndex", InstructionType.MatrixIndexing),
    MAPPLUS("map+", InstructionType.Binary),
    MAPMINUS("map-", InstructionType.Binary),
    MAPMULT("map*", InstructionType.Binary),
    MAPDIV("map/", InstructionType.Binary),
    MAPMOD("map%%", InstructionType.Binary),
    MAPINTDIV("map%/%", InstructionType.Binary),
    MAPMINUS1_MULT("map1-*", InstructionType.Binary),
    MAPPOW("map^", InstructionType.Binary),
    MAPPM("map+*", InstructionType.Binary),
    MAPMINUSMULT("map-*", InstructionType.Binary),
    MAPDROPINVALIDLENGTH("mapdropInvalidLength", InstructionType.Binary),
    MAPGT("map>", InstructionType.Binary),
    MAPGE("map>=", InstructionType.Binary),
    MAPLT("map<", InstructionType.Binary),
    MAPLE("map<=", InstructionType.Binary),
    MAPEQ("map==", InstructionType.Binary),
    MAPNEQ("map!=", InstructionType.Binary),
    MAPAND("map&&", InstructionType.Binary),
    MAPOR("map||", InstructionType.Binary),
    MAPXOR("mapxor", InstructionType.Binary),
    MAPBITWAND("mapbitwAnd", InstructionType.Binary),
    MAPBITWOR("mapbitwOr", InstructionType.Binary),
    MAPBITWXOR("mapbitwXor", InstructionType.Binary),
    MAPBITWSHIFTL("mapbitwShiftL", InstructionType.Binary),
    MAPBITWSHIFTR("mapbitwShiftR", InstructionType.Binary),
    MAPMAX("mapmax", InstructionType.Binary),
    MAPMIN("mapmin", InstructionType.Binary),
    RBLK("rblk", null, InstructionType.Reblock),
    CSVRBLK("csvrblk", InstructionType.CSVReblock),
    LIBSVMRBLK("libsvmrblk", InstructionType.LIBSVMReblock),
    DEFAULTCPOPCODE("chkpoint", InstructionType.Checkpoint),
    ASYNCCPOPCODE("chkpoint_e", InstructionType.Checkpoint),
    MAPGROUPEDAGG("mapgroupedagg", InstructionType.ParameterizedBuiltin),
    MAPPEND("mappend", InstructionType.MAppend),
    RAPPEND("rappend", InstructionType.RAppend),
    GAPPEND("gappend", InstructionType.GAppend),
    GALIGNEDAPPEND("galignedappend", InstructionType.GAlignedAppend),
    WEIGHTEDSQUAREDLOSS("mapwsloss", InstructionType.Quaternary),
    WEIGHTEDSQUAREDLOSSR("redwsloss", InstructionType.Quaternary),
    WEIGHTEDSIGMOID("mapwsigmoid", InstructionType.Quaternary),
    WEIGHTEDSIGMOIDR("redwsigmoid", InstructionType.Quaternary),
    WEIGHTEDDIVMM("mapwdivmm", InstructionType.Quaternary),
    WEIGHTEDDIVMMR("redwdivmm", InstructionType.Quaternary),
    WEIGHTEDCROSSENTROPY("mapwcemm", InstructionType.Quaternary),
    WEIGHTEDCROSSENTROPYR("redwcemm", InstructionType.Quaternary),
    WEIGHTEDUNARYMM("mapwumm", InstructionType.Quaternary),
    WEIGHTEDUNARYMMR("redwumm", InstructionType.Quaternary),
    UCUMACKP("ucumack+", InstructionType.CumsumAggregate),
    UCUMACM("ucumac*", InstructionType.CumsumAggregate),
    UCUMACPM("ucumac+*", InstructionType.CumsumAggregate),
    UCUMACMIN("ucumacmin", InstructionType.CumsumAggregate),
    UCUMACMAX("ucumacmax", InstructionType.CumsumAggregate),
    BCUMOFFKP("bcumoffk+", InstructionType.CumsumOffset),
    BCUMOFFM("bcumoff*", InstructionType.CumsumOffset),
    BCUMOFFPM("bcumoff+*", InstructionType.CumsumOffset),
    BCUMOFFMIN("bcumoffmin", InstructionType.CumsumOffset),
    BCUMOFFMAX("bcumoffmax", InstructionType.CumsumOffset),
    BINUAGGCHAIN("binuaggchain", InstructionType.BinUaggChain),
    CASTDTM("castdtm", InstructionType.Cast),
    CASTDTF("castdtf", InstructionType.Cast),
    FEDINIT("fedinit", InstructionType.Init);

    private final String _name;
    private final InstructionType _type;
    private final InstructionType _spType;
    private final InstructionType _fedType;
    private static final Map<String, Opcodes> _lookupMap;

    private Opcodes(String name, InstructionType type) {
        this._name = name;
        this._type = type;
        this._spType = null;
        this._fedType = null;
    }

    private Opcodes(String name, InstructionType type, InstructionType spType) {
        this._name = name;
        this._type = type;
        this._spType = spType;
        this._fedType = null;
    }

    private Opcodes(String name, InstructionType type, InstructionType spType, InstructionType fedType) {
        this._name = name;
        this._type = type;
        this._spType = spType;
        this._fedType = fedType;
    }

    public String toString() {
        return this._name;
    }

    public InstructionType getType() {
        return this._type;
    }

    public InstructionType getSpType() {
        return this._spType != null ? this._spType : this._type;
    }

    public InstructionType getFedType() {
        return this._fedType != null ? this._fedType : this._type;
    }

    public static InstructionType getTypeByOpcode(String opcode, Types.ExecType type) {
        if (opcode == null || opcode.trim().isEmpty()) {
            return null;
        }
        for (Opcodes op : Opcodes.values()) {
            if (!op.toString().equalsIgnoreCase(opcode.trim())) continue;
            switch (type) {
                case SPARK: {
                    return op.getSpType() != null ? op.getSpType() : op.getType();
                }
                case FED: {
                    return op.getFedType() != null ? op.getFedType() : op.getType();
                }
            }
            return op.getType();
        }
        return null;
    }

    static {
        _lookupMap = new HashMap<String, Opcodes>();
        for (Opcodes op : EnumSet.allOf(Opcodes.class)) {
            if (op._name == null) continue;
            _lookupMap.put(op._name.toLowerCase(), op);
        }
    }
}

