/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.util.Collection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ContainerTokenSelector
implements TokenSelector<ContainerTokenIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerTokenSelector.class);

    public Token<ContainerTokenIdentifier> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (service == null) {
            return null;
        }
        for (Token<? extends TokenIdentifier> token : tokens) {
            LOG.debug("Looking for service: {}. Current token is {}", (Object)service, token);
            if (!ContainerTokenIdentifier.KIND.equals((Object)token.getKind()) || !service.equals((Object)token.getService())) continue;
            return token;
        }
        return null;
    }
}

