/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.instructions.InstructionParser;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.AggregateBinaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.AggregateTernaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.AggregateUnaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.AppendCPInstruction;
import org.apache.sysds.runtime.instructions.cp.BinaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.BroadcastCPInstruction;
import org.apache.sysds.runtime.instructions.cp.BuiltinNaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CentralMomentCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CompressionCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CovarianceCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CtableCPInstruction;
import org.apache.sysds.runtime.instructions.cp.DataGenCPInstruction;
import org.apache.sysds.runtime.instructions.cp.DeCompressionCPInstruction;
import org.apache.sysds.runtime.instructions.cp.DnnCPInstruction;
import org.apache.sysds.runtime.instructions.cp.FunctionCallCPInstruction;
import org.apache.sysds.runtime.instructions.cp.IndexingCPInstruction;
import org.apache.sysds.runtime.instructions.cp.LocalCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MMChainCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MMTSJCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MultiReturnBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MultiReturnParameterizedBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.PMMJCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ParameterizedBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.PrefetchCPInstruction;
import org.apache.sysds.runtime.instructions.cp.QuantilePickCPInstruction;
import org.apache.sysds.runtime.instructions.cp.QuantileSortCPInstruction;
import org.apache.sysds.runtime.instructions.cp.QuaternaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ReorgCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ReshapeCPInstruction;
import org.apache.sysds.runtime.instructions.cp.SpoofCPInstruction;
import org.apache.sysds.runtime.instructions.cp.SqlCPInstruction;
import org.apache.sysds.runtime.instructions.cp.StringInitCPInstruction;
import org.apache.sysds.runtime.instructions.cp.TernaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.UaggOuterChainCPInstruction;
import org.apache.sysds.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysds.runtime.instructions.cpfile.MatrixIndexingCPFileInstruction;

public class CPInstructionParser
extends InstructionParser {
    protected static final Log LOG = LogFactory.getLog((String)CPInstructionParser.class.getName());
    public static final HashMap<String, CPInstruction.CPType> String2CPInstructionType = new HashMap();

    public static CPInstruction parseSingleInstruction(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        CPInstruction.CPType cptype = InstructionUtils.getCPType(str);
        if (cptype == null) {
            throw new DMLRuntimeException("Unable derive cptype for instruction: " + str);
        }
        CPInstruction cpinst = CPInstructionParser.parseSingleInstruction(cptype, str);
        if (cpinst == null) {
            throw new DMLRuntimeException("Unable to parse instruction: " + str);
        }
        return cpinst;
    }

    public static CPInstruction parseSingleInstruction(CPInstruction.CPType cptype, String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        switch (cptype) {
            case AggregateUnary: {
                return AggregateUnaryCPInstruction.parseInstruction(str);
            }
            case AggregateBinary: {
                return AggregateBinaryCPInstruction.parseInstruction(str);
            }
            case AggregateTernary: {
                return AggregateTernaryCPInstruction.parseInstruction(str);
            }
            case Unary: {
                return UnaryCPInstruction.parseInstruction(str);
            }
            case Binary: {
                return BinaryCPInstruction.parseInstruction(str);
            }
            case Ternary: {
                return TernaryCPInstruction.parseInstruction(str);
            }
            case Quaternary: {
                return QuaternaryCPInstruction.parseInstruction(str);
            }
            case BuiltinNary: {
                return BuiltinNaryCPInstruction.parseInstruction(str);
            }
            case Ctable: {
                return CtableCPInstruction.parseInstruction(str);
            }
            case Reorg: {
                return ReorgCPInstruction.parseInstruction(str);
            }
            case Dnn: {
                return DnnCPInstruction.parseInstruction(str);
            }
            case UaggOuterChain: {
                return UaggOuterChainCPInstruction.parseInstruction(str);
            }
            case Reshape: {
                return ReshapeCPInstruction.parseInstruction(str);
            }
            case Append: {
                return AppendCPInstruction.parseInstruction(str);
            }
            case Variable: {
                return VariableCPInstruction.parseInstruction(str);
            }
            case Rand: {
                return DataGenCPInstruction.parseInstruction(str);
            }
            case StringInit: {
                return StringInitCPInstruction.parseInstruction(str);
            }
            case FCall: {
                return FunctionCallCPInstruction.parseInstruction(str);
            }
            case ParameterizedBuiltin: {
                return ParameterizedBuiltinCPInstruction.parseInstruction(str);
            }
            case MultiReturnParameterizedBuiltin: {
                return MultiReturnParameterizedBuiltinCPInstruction.parseInstruction(str);
            }
            case MultiReturnBuiltin: {
                return MultiReturnBuiltinCPInstruction.parseInstruction(str);
            }
            case QSort: {
                return QuantileSortCPInstruction.parseInstruction(str);
            }
            case QPick: {
                return QuantilePickCPInstruction.parseInstruction(str);
            }
            case MatrixIndexing: {
                Types.ExecType execType = Types.ExecType.valueOf(str.split("\u00b0")[0]);
                if (execType == Types.ExecType.CP) {
                    return IndexingCPInstruction.parseInstruction(str);
                }
                return MatrixIndexingCPFileInstruction.parseInstruction(str);
            }
            case Builtin: {
                String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
                if (parts[0].equals("log") || parts[0].equals("log_nz")) {
                    if (InstructionUtils.isInteger(parts[3])) {
                        return UnaryCPInstruction.parseInstruction(str);
                    }
                    return BinaryCPInstruction.parseInstruction(str);
                }
                throw new DMLRuntimeException("Invalid Builtin Instruction: " + str);
            }
            case MMTSJ: {
                return MMTSJCPInstruction.parseInstruction(str);
            }
            case PMMJ: {
                return PMMJCPInstruction.parseInstruction(str);
            }
            case MMChain: {
                return MMChainCPInstruction.parseInstruction(str);
            }
            case CentralMoment: {
                return CentralMomentCPInstruction.parseInstruction(str);
            }
            case Covariance: {
                return CovarianceCPInstruction.parseInstruction(str);
            }
            case Compression: {
                return CompressionCPInstruction.parseInstruction(str);
            }
            case DeCompression: {
                return DeCompressionCPInstruction.parseInstruction(str);
            }
            case Local: {
                return LocalCPInstruction.parseInstruction(str);
            }
            case SpoofFused: {
                return SpoofCPInstruction.parseInstruction(str);
            }
            case Sql: {
                return SqlCPInstruction.parseInstruction(str);
            }
            case Prefetch: {
                return PrefetchCPInstruction.parseInstruction(str);
            }
            case Broadcast: {
                return BroadcastCPInstruction.parseInstruction(str);
            }
        }
        throw new DMLRuntimeException("Invalid CP Instruction Type: " + cptype);
    }

    static {
        String2CPInstructionType.put("ba+*", CPInstruction.CPType.AggregateBinary);
        String2CPInstructionType.put("tak+*", CPInstruction.CPType.AggregateTernary);
        String2CPInstructionType.put("tack+*", CPInstruction.CPType.AggregateTernary);
        String2CPInstructionType.put("uak+", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uark+", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uack+", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uasqk+", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uarsqk+", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uacsqk+", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uamean", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uarmean", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uacmean", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uavar", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uarvar", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uacvar", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uamax", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uarmax", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uarimax", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uacmax", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uamin", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uarmin", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uarimin", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uacmin", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("ua+", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uar+", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uac+", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("ua*", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uar*", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uac*", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uatrace", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uaktrace", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("nrow", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("ncol", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("length", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("exists", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("lineage", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uacd", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uacdr", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uacdc", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uacdap", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uacdapr", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uacdapc", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("unique", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uniquer", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uniquec", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uaggouterchain", CPInstruction.CPType.UaggOuterChain);
        String2CPInstructionType.put("+", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("-", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("*", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("/", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("%%", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("%/%", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("^", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("1-*", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("^2", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("*2", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("-nz", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("&&", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("||", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("xor", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("bitwAnd", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("bitwOr", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("bitwXor", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("bitwShiftL", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("bitwShiftR", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("!", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("==", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("!=", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("<", CPInstruction.CPType.Binary);
        String2CPInstructionType.put(">", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("<=", CPInstruction.CPType.Binary);
        String2CPInstructionType.put(">=", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("log", CPInstruction.CPType.Builtin);
        String2CPInstructionType.put("log_nz", CPInstruction.CPType.Builtin);
        String2CPInstructionType.put("solve", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("max", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("min", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("dropInvalidType", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("dropInvalidLength", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("freplicate", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("valueSwap", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("applySchema", CPInstruction.CPType.Binary);
        String2CPInstructionType.put("_map", CPInstruction.CPType.Ternary);
        String2CPInstructionType.put("nmax", CPInstruction.CPType.BuiltinNary);
        String2CPInstructionType.put("nmin", CPInstruction.CPType.BuiltinNary);
        String2CPInstructionType.put("n+", CPInstruction.CPType.BuiltinNary);
        String2CPInstructionType.put("exp", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("abs", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("sin", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("cos", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("tan", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("sinh", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("cosh", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("tanh", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("asin", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("acos", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("atan", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("sign", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("sqrt", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("plogp", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("print", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("assert", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("round", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("ceil", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("floor", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("ucumk+", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("ucum*", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("ucumk+*", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("ucummin", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("ucummax", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("stop", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("inverse", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("cholesky", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("sprop", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("sigmoid", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("typeOf", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("detectSchema", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("colnames", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("isna", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("isnan", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("isinf", CPInstruction.CPType.Unary);
        String2CPInstructionType.put("printf", CPInstruction.CPType.BuiltinNary);
        String2CPInstructionType.put("cbind", CPInstruction.CPType.BuiltinNary);
        String2CPInstructionType.put("rbind", CPInstruction.CPType.BuiltinNary);
        String2CPInstructionType.put("eval", CPInstruction.CPType.BuiltinNary);
        String2CPInstructionType.put("list", CPInstruction.CPType.BuiltinNary);
        String2CPInstructionType.put("autoDiff", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("contains", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("paramserv", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("nvlist", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("cdf", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("invcdf", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("groupedagg", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("rmempty", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("replace", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("lowertri", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("uppertri", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("rexpand", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("toString", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("tokenize", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("transformapply", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("transformdecode", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("transformcolmap", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("transformmeta", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("transformencode", CPInstruction.CPType.MultiReturnParameterizedBuiltin);
        String2CPInstructionType.put("+*", CPInstruction.CPType.Ternary);
        String2CPInstructionType.put("-*", CPInstruction.CPType.Ternary);
        String2CPInstructionType.put("ifelse", CPInstruction.CPType.Ternary);
        String2CPInstructionType.put("assignvar", CPInstruction.CPType.Variable);
        String2CPInstructionType.put("cpvar", CPInstruction.CPType.Variable);
        String2CPInstructionType.put("mvvar", CPInstruction.CPType.Variable);
        String2CPInstructionType.put("rmvar", CPInstruction.CPType.Variable);
        String2CPInstructionType.put("rmfilevar", CPInstruction.CPType.Variable);
        String2CPInstructionType.put(Types.OpOp1.CAST_AS_SCALAR.toString(), CPInstruction.CPType.Variable);
        String2CPInstructionType.put(Types.OpOp1.CAST_AS_MATRIX.toString(), CPInstruction.CPType.Variable);
        String2CPInstructionType.put(Types.OpOp1.CAST_AS_FRAME.toString(), CPInstruction.CPType.Variable);
        String2CPInstructionType.put(Types.OpOp1.CAST_AS_LIST.toString(), CPInstruction.CPType.Variable);
        String2CPInstructionType.put(Types.OpOp1.CAST_AS_DOUBLE.toString(), CPInstruction.CPType.Variable);
        String2CPInstructionType.put(Types.OpOp1.CAST_AS_INT.toString(), CPInstruction.CPType.Variable);
        String2CPInstructionType.put(Types.OpOp1.CAST_AS_BOOLEAN.toString(), CPInstruction.CPType.Variable);
        String2CPInstructionType.put("attachfiletovar", CPInstruction.CPType.Variable);
        String2CPInstructionType.put("read", CPInstruction.CPType.Variable);
        String2CPInstructionType.put("write", CPInstruction.CPType.Variable);
        String2CPInstructionType.put("createvar", CPInstruction.CPType.Variable);
        String2CPInstructionType.put("r'", CPInstruction.CPType.Reorg);
        String2CPInstructionType.put("rev", CPInstruction.CPType.Reorg);
        String2CPInstructionType.put("rdiag", CPInstruction.CPType.Reorg);
        String2CPInstructionType.put("rshape", CPInstruction.CPType.Reshape);
        String2CPInstructionType.put("rsort", CPInstruction.CPType.Reorg);
        String2CPInstructionType.put("relu_backward", CPInstruction.CPType.Dnn);
        String2CPInstructionType.put("relu_maxpooling", CPInstruction.CPType.Dnn);
        String2CPInstructionType.put("relu_maxpooling_backward", CPInstruction.CPType.Dnn);
        String2CPInstructionType.put("maxpooling", CPInstruction.CPType.Dnn);
        String2CPInstructionType.put("maxpooling_backward", CPInstruction.CPType.Dnn);
        String2CPInstructionType.put("avgpooling", CPInstruction.CPType.Dnn);
        String2CPInstructionType.put("avgpooling_backward", CPInstruction.CPType.Dnn);
        String2CPInstructionType.put("conv2d", CPInstruction.CPType.Dnn);
        String2CPInstructionType.put("conv2d_bias_add", CPInstruction.CPType.Dnn);
        String2CPInstructionType.put("conv2d_backward_filter", CPInstruction.CPType.Dnn);
        String2CPInstructionType.put("conv2d_backward_data", CPInstruction.CPType.Dnn);
        String2CPInstructionType.put("bias_add", CPInstruction.CPType.Dnn);
        String2CPInstructionType.put("bias_multiply", CPInstruction.CPType.Dnn);
        String2CPInstructionType.put("batch_norm2d", CPInstruction.CPType.Dnn);
        String2CPInstructionType.put("batch_norm2d_backward", CPInstruction.CPType.Dnn);
        String2CPInstructionType.put("wsloss", CPInstruction.CPType.Quaternary);
        String2CPInstructionType.put("wsigmoid", CPInstruction.CPType.Quaternary);
        String2CPInstructionType.put("wdivmm", CPInstruction.CPType.Quaternary);
        String2CPInstructionType.put("wcemm", CPInstruction.CPType.Quaternary);
        String2CPInstructionType.put("wumm", CPInstruction.CPType.Quaternary);
        String2CPInstructionType.put("fcall", CPInstruction.CPType.FCall);
        String2CPInstructionType.put("append", CPInstruction.CPType.Append);
        String2CPInstructionType.put("remove", CPInstruction.CPType.Append);
        String2CPInstructionType.put("rand", CPInstruction.CPType.Rand);
        String2CPInstructionType.put("seq", CPInstruction.CPType.Rand);
        String2CPInstructionType.put("sinit", CPInstruction.CPType.StringInit);
        String2CPInstructionType.put("sample", CPInstruction.CPType.Rand);
        String2CPInstructionType.put("time", CPInstruction.CPType.Rand);
        String2CPInstructionType.put("frame", CPInstruction.CPType.Rand);
        String2CPInstructionType.put("ctable", CPInstruction.CPType.Ctable);
        String2CPInstructionType.put("ctableexpand", CPInstruction.CPType.Ctable);
        String2CPInstructionType.put("cm", CPInstruction.CPType.CentralMoment);
        String2CPInstructionType.put("cov", CPInstruction.CPType.Covariance);
        String2CPInstructionType.put("qsort", CPInstruction.CPType.QSort);
        String2CPInstructionType.put("qpick", CPInstruction.CPType.QPick);
        String2CPInstructionType.put("rightIndex", CPInstruction.CPType.MatrixIndexing);
        String2CPInstructionType.put("leftIndex", CPInstruction.CPType.MatrixIndexing);
        String2CPInstructionType.put("tsmm", CPInstruction.CPType.MMTSJ);
        String2CPInstructionType.put("pmm", CPInstruction.CPType.PMMJ);
        String2CPInstructionType.put("mmchain", CPInstruction.CPType.MMChain);
        String2CPInstructionType.put("qr", CPInstruction.CPType.MultiReturnBuiltin);
        String2CPInstructionType.put("lu", CPInstruction.CPType.MultiReturnBuiltin);
        String2CPInstructionType.put("eigen", CPInstruction.CPType.MultiReturnBuiltin);
        String2CPInstructionType.put("svd", CPInstruction.CPType.MultiReturnBuiltin);
        String2CPInstructionType.put("partition", CPInstruction.CPType.Partition);
        String2CPInstructionType.put("compress", CPInstruction.CPType.Compression);
        String2CPInstructionType.put("decompress", CPInstruction.CPType.DeCompression);
        String2CPInstructionType.put("spoof", CPInstruction.CPType.SpoofFused);
        String2CPInstructionType.put("prefetch", CPInstruction.CPType.Prefetch);
        String2CPInstructionType.put("broadcast", CPInstruction.CPType.Broadcast);
        String2CPInstructionType.put("trigremote", CPInstruction.CPType.TrigRemote);
        String2CPInstructionType.put("local", CPInstruction.CPType.Local);
        String2CPInstructionType.put("sql", CPInstruction.CPType.Sql);
    }
}

