# -------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# -------------------------------------------------------------

# Autogenerated By   : src/main/python/generator/generator.py
# Autogenerated From : scripts/builtin/impurityMeasures.dml

from typing import Dict, Iterable

from systemds.operator import OperationNode, Matrix, Frame, List, MultiReturn, Scalar
from systemds.script_building.dag import OutputType
from systemds.utils.consts import VALID_INPUT_TYPES


def impurityMeasures(X: Matrix,
                     Y: Matrix,
                     R: Matrix,
                     method: str,
                     **kwargs: Dict[str, VALID_INPUT_TYPES]):
    """
     This function computes the measure of impurity for the given dataset based on the passed method (gini or entropy).
     The current version expects the target vector to contain only 0 or 1 values.
    
    
    
    :param X: Feature matrix.
    :param Y: Target vector containing 0 and 1 values.
    :param R: Vector indicating whether a feature is categorical or continuous.
        1 denotes a continuous feature, 2 denotes a categorical feature.
    :param n_bins: Number of bins for binning in case of scale features.
    :param method: String indicating the method to use; either "entropy" or "gini".
    :return: (1 x ncol(X)) row vector containing information/gini gain for
        each feature of the dataset.
        In case of gini, the values denote the gini gains, i.e. how much
        impurity was removed with the respective split. The higher the
        value, the better the split.
        In case of entropy, the values denote the information gain, i.e.
        how much entropy was removed. The higher the information gain,
        the better the split.
    """

    params_dict = {'X': X, 'Y': Y, 'R': R, 'method': method}
    params_dict.update(kwargs)
    return Matrix(X.sds_context,
        'impurityMeasures',
        named_input_nodes=params_dict)
