/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated.monitoring.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.BaseEntityModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.NodeEntityModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.Request;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.StatsEntityModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.repositories.EntityEnum;

public class MapperService {
    public static BaseEntityModel getModelFromBody(Request request) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (BaseEntityModel)mapper.readValue(request.getBody(), NodeEntityModel.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static BaseEntityModel mapEntityToModel(ResultSet resultSet, EntityEnum targetModel) {
        try {
            if (targetModel != EntityEnum.WORKER_STATS) {
                NodeEntityModel tmpModel = new NodeEntityModel();
                for (int column = 1; column <= resultSet.getMetaData().getColumnCount(); ++column) {
                    if (resultSet.getMetaData().getColumnType(column) == 4) {
                        tmpModel.setId(resultSet.getLong(column));
                    }
                    if (resultSet.getMetaData().getColumnType(column) != 12) continue;
                    if (resultSet.getMetaData().getColumnName(column).equalsIgnoreCase("name")) {
                        tmpModel.setName(resultSet.getString(column));
                        continue;
                    }
                    if (!resultSet.getMetaData().getColumnName(column).equalsIgnoreCase("address")) continue;
                    tmpModel.setAddress(resultSet.getString(column));
                }
                return tmpModel;
            }
            StatsEntityModel tmpModel = new StatsEntityModel();
            for (int column = 1; column <= resultSet.getMetaData().getColumnCount(); ++column) {
                if (resultSet.getMetaData().getColumnType(column) == 12) {
                    if (resultSet.getMetaData().getColumnName(column).equalsIgnoreCase("coordinatorTraffic")) {
                        tmpModel.setTransferredBytes(resultSet.getString(column));
                        continue;
                    }
                    if (!resultSet.getMetaData().getColumnName(column).equalsIgnoreCase("heavyHitters")) continue;
                    tmpModel.setHeavyHitterInstructions(resultSet.getString(column));
                    continue;
                }
                if (resultSet.getMetaData().getColumnName(column).equalsIgnoreCase("cpuUsage")) {
                    tmpModel.setCPUUsage(resultSet.getDouble(column));
                    continue;
                }
                if (!resultSet.getMetaData().getColumnName(column).equalsIgnoreCase("memoryUsage")) continue;
                tmpModel.setMemoryUsage(resultSet.getDouble(column));
            }
            return tmpModel;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

