/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.bitmap;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.utils.IntArrayList;

public abstract class ABitmap {
    protected static final Log LOG = LogFactory.getLog((String)ABitmap.class.getName());
    protected IntArrayList[] _offsetsLists;
    protected final int _numZeros;

    protected ABitmap(IntArrayList[] offsetsLists, int rows) {
        int offsetsTotal = 0;
        for (IntArrayList a : offsetsLists) {
            offsetsTotal += a.size();
        }
        this._numZeros = rows - offsetsTotal;
        this._offsetsLists = offsetsLists;
    }

    public final IntArrayList[] getOffsetList() {
        return this._offsetsLists;
    }

    public final IntArrayList getOffsetsList(int idx) {
        return this._offsetsLists[idx];
    }

    public final long getNumOffsets() {
        long ret = 0L;
        for (IntArrayList off : this._offsetsLists) {
            ret += (long)off.size();
        }
        return ret;
    }

    public final int getNumOffsets(int ix) {
        return this._offsetsLists[ix].size();
    }

    public final int getNumZeros() {
        return this._numZeros;
    }

    public final boolean containsZero() {
        return this._numZeros > 0;
    }

    public abstract int getNumValues();

    public abstract int getNumNonZerosInOffset(int var1);

    public abstract int getNumColumns();

    protected abstract void addToString(StringBuilder var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("  zeros:  " + this._numZeros);
        sb.append("\nOffsets:" + Arrays.toString(this._offsetsLists));
        this.addToString(sb);
        return sb.toString();
    }
}

