/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.bitmap.ABitmap;
import org.apache.sysds.runtime.compress.bitmap.BitmapEncoder;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class CompressedSizeEstimatorExact
extends CompressedSizeEstimator {
    protected CompressedSizeEstimatorExact(MatrixBlock data, CompressionSettings compSettings) {
        super(data, compSettings);
    }

    @Override
    public CompressedSizeInfoColGroup estimateCompressedColGroupSize(int[] colIndexes, int estimate, int nrUniqueUpperBound) {
        ABitmap entireBitMap = BitmapEncoder.extractBitmap(colIndexes, this._data, this._cs.transposed, estimate);
        EstimationFactors em = null;
        if (entireBitMap != null) {
            em = this.estimateCompressedColGroupSize(entireBitMap, colIndexes);
        }
        if (em == null) {
            em = EstimationFactors.emptyFactors(colIndexes.length, this.getNumRows());
        }
        return new CompressedSizeInfoColGroup(colIndexes, em, this._cs.validCompressions, entireBitMap, this.getNumRows());
    }

    @Override
    protected CompressedSizeInfoColGroup estimateJoinCompressedSize(int[] joined, CompressedSizeInfoColGroup g1, CompressedSizeInfoColGroup g2, int joinedMaxDistinct) {
        int _numRows = this.getNumRows();
        AMapToData map = MapToFactory.join(g1.getMap(), g2.getMap());
        EstimationFactors em = null;
        if (map != null) {
            em = EstimationFactors.computeSizeEstimation(joined, map, this._cs.validCompressions.contains((Object)AColGroup.CompressionType.RLE), _numRows, false);
        }
        if (em == null) {
            em = EstimationFactors.emptyFactors(joined.length, this.getNumRows());
        }
        return new CompressedSizeInfoColGroup(joined, em, this._cs.validCompressions, map);
    }

    @Override
    protected int worstCaseUpperBound(int[] columns) {
        return this.getNumRows();
    }
}

