/*
 * Decompiled with CFR 0.152.
 */
package jcuda;

public class cuComplex {
    public float x;
    public float y;

    private cuComplex() {
    }

    public static float cuCreal(cuComplex x) {
        return x.x;
    }

    public static float cuCimag(cuComplex x) {
        return x.y;
    }

    public static cuComplex cuCmplx(float r, float i) {
        cuComplex res = new cuComplex();
        res.x = r;
        res.y = i;
        return res;
    }

    public static cuComplex cuConj(cuComplex x) {
        return cuComplex.cuCmplx(cuComplex.cuCreal(x), -cuComplex.cuCimag(x));
    }

    public static cuComplex cuCadd(cuComplex x, cuComplex y) {
        return cuComplex.cuCmplx(cuComplex.cuCreal(x) + cuComplex.cuCreal(y), cuComplex.cuCimag(x) + cuComplex.cuCimag(y));
    }

    public static cuComplex cuCmul(cuComplex x, cuComplex y) {
        cuComplex prod = cuComplex.cuCmplx(cuComplex.cuCreal(x) * cuComplex.cuCreal(y) - cuComplex.cuCimag(x) * cuComplex.cuCimag(y), cuComplex.cuCreal(x) * cuComplex.cuCimag(y) + cuComplex.cuCimag(x) * cuComplex.cuCreal(y));
        return prod;
    }

    public static cuComplex cuCdiv(cuComplex x, cuComplex y) {
        float s = Math.abs(cuComplex.cuCreal(y)) + Math.abs(cuComplex.cuCimag(y));
        float oos = 1.0f / s;
        float ars = cuComplex.cuCreal(x) * oos;
        float ais = cuComplex.cuCimag(x) * oos;
        float brs = cuComplex.cuCreal(y) * oos;
        float bis = cuComplex.cuCimag(y) * oos;
        s = brs * brs + bis * bis;
        oos = 1.0f / s;
        cuComplex quot = cuComplex.cuCmplx((ars * brs + ais * bis) * oos, (ais * brs - ars * bis) * oos);
        return quot;
    }

    public static float cuCabs(cuComplex x) {
        float r;
        float p = cuComplex.cuCreal(x);
        float q = cuComplex.cuCimag(x);
        if (p == 0.0f) {
            return q;
        }
        if (q == 0.0f) {
            return p;
        }
        if ((p = (float)Math.sqrt(p)) < (q = (float)Math.sqrt(q))) {
            r = p;
            p = q;
            q = r;
        }
        r = q / p;
        return p * (float)Math.sqrt(1.0f + r * r);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }
}

