/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import java.util.ArrayList;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.lops.PickByCount;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederatedUDF;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.fed.BinaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class QuantilePickFEDInstruction
extends BinaryFEDInstruction {
    private final PickByCount.OperationTypes _type;

    private QuantilePickFEDInstruction(Operator op, CPOperand in, CPOperand out, PickByCount.OperationTypes type, boolean inmem, String opcode, String istr) {
        this(op, in, null, out, type, inmem, opcode, istr);
    }

    private QuantilePickFEDInstruction(Operator op, CPOperand in, CPOperand in2, CPOperand out, PickByCount.OperationTypes type, boolean inmem, String opcode, String istr, FEDInstruction.FederatedOutput fedOut) {
        super(FEDInstruction.FEDType.QPick, op, in, in2, out, opcode, istr, fedOut);
        this._type = type;
    }

    private QuantilePickFEDInstruction(Operator op, CPOperand in, CPOperand in2, CPOperand out, PickByCount.OperationTypes type, boolean inmem, String opcode, String istr) {
        this(op, in, in2, out, type, inmem, opcode, istr, FEDInstruction.FederatedOutput.NONE);
    }

    public static QuantilePickFEDInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (!opcode.equalsIgnoreCase("qpick")) {
            throw new DMLRuntimeException("Unknown opcode while parsing a QuantilePickCPInstruction: " + str);
        }
        if (parts.length == 4) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            CPOperand out = new CPOperand(parts[3]);
            PickByCount.OperationTypes ptype = PickByCount.OperationTypes.IQM;
            boolean inmem = false;
            return new QuantilePickFEDInstruction(null, in1, in2, out, ptype, inmem, opcode, str);
        }
        if (parts.length == 5) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand out = new CPOperand(parts[2]);
            PickByCount.OperationTypes ptype = PickByCount.OperationTypes.valueOf(parts[3]);
            boolean inmem = Boolean.parseBoolean(parts[4]);
            return new QuantilePickFEDInstruction(null, in1, out, ptype, inmem, opcode, str);
        }
        if (parts.length == 6) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            CPOperand out = new CPOperand(parts[3]);
            PickByCount.OperationTypes ptype = PickByCount.OperationTypes.valueOf(parts[4]);
            boolean inmem = Boolean.parseBoolean(parts[5]);
            return new QuantilePickFEDInstruction(null, in1, in2, out, ptype, inmem, opcode, str);
        }
        return null;
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixObject in = ec.getMatrixObject(this.input1);
        FederationMap fedMapping = in.getFedMapping();
        ArrayList res = new ArrayList();
        long varID = FederationUtils.getNextFedDataID();
        fedMapping.mapParallel(varID, (range, data) -> {
            try {
                FederatedResponse response;
                switch (this._type) {
                    case VALUEPICK: {
                        if (this.input2.isScalar()) {
                            ScalarObject quantile = ec.getScalarInput(this.input2);
                            response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new ValuePick(data.getVarID(), quantile))).get();
                            break;
                        }
                        MatrixBlock quantiles = ec.getMatrixInput(this.input2.getName());
                        response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new ValuePick(data.getVarID(), quantiles))).get();
                        break;
                    }
                    case IQM: {
                        response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new IQM(data.getVarID()))).get();
                        break;
                    }
                    case MEDIAN: {
                        response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new Median(data.getVarID()))).get();
                        break;
                    }
                    default: {
                        throw new DMLRuntimeException("Unsupported qpick operation type: " + (Object)((Object)this._type));
                    }
                }
                if (!response.isSuccessful()) {
                    response.throwExceptionFromResponse();
                }
                res.add(response.getData()[0]);
            }
            catch (Exception e) {
                throw new DMLRuntimeException(e);
            }
            return null;
        });
        assert (res.size() == 1);
        if (this.output.isScalar()) {
            ec.setScalarOutput(this.output.getName(), new DoubleObject((Double)res.get(0)));
        } else {
            ec.setMatrixOutput(this.output.getName(), (MatrixBlock)res.get(0));
        }
    }

    private static class Median
    extends FederatedUDF {
        private static final long serialVersionUID = -2808597461054603816L;

        protected Median(long input) {
            super(new long[]{input});
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            MatrixBlock mb = (MatrixBlock)((MatrixObject)data[0]).acquireReadAndRelease();
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, new Object[]{mb.median()});
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }

    private static class IQM
    extends FederatedUDF {
        private static final long serialVersionUID = 2223186699111957677L;

        protected IQM(long input) {
            super(new long[]{input});
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            MatrixBlock mb = (MatrixBlock)((MatrixObject)data[0]).acquireReadAndRelease();
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, new Object[]{mb.interQuartileMean()});
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }

    private static class ValuePick
    extends FederatedUDF {
        private static final long serialVersionUID = -2594912886841345102L;
        private final MatrixBlock _quantiles;

        protected ValuePick(long input, ScalarObject quantile) {
            super(new long[]{input});
            this._quantiles = new MatrixBlock(quantile.getDoubleValue());
        }

        protected ValuePick(long input, MatrixBlock quantiles) {
            super(new long[]{input});
            this._quantiles = quantiles;
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            MatrixBlock mb = (MatrixBlock)((MatrixObject)data[0]).acquireReadAndRelease();
            if (this._quantiles.getLength() == 1L) {
                return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, new Object[]{mb.pickValue(this._quantiles.getValue(0, 0))});
            }
            MatrixBlock picked = mb.pickValues(this._quantiles, new MatrixBlock());
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, new Object[]{picked});
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }
}

