/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor;

import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.spark.broadcast.Broadcast;
import org.apache.sysds.runtime.controlprogram.LocalVariableMap;
import org.apache.sysds.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.instructions.cp.Data;

public class CachedReuseVariables {
    private final HashMap<Long, SoftReference<LocalVariableMap>> _data = new HashMap();

    public synchronized boolean containsVars(long pfid) {
        return this._data.containsKey(pfid);
    }

    public synchronized void reuseVariables(long pfid, LocalVariableMap vars, Collection<String> excludeList, Map<String, Broadcast<CacheBlock>> _brInputs, boolean cleanCache) {
        if (ParForProgramBlock.ALLOW_BROADCAST_INPUTS && !this.containsVars(pfid)) {
            CachedReuseVariables.loadBroadcastVariables(vars, _brInputs);
        }
        LocalVariableMap tmp = null;
        if (this.containsVars(pfid)) {
            tmp = this._data.get(pfid).get();
        }
        if (tmp == null) {
            if (cleanCache) {
                this._data.clear();
            }
            tmp = new LocalVariableMap(vars);
            tmp.removeAllIn((Set<String>)(excludeList instanceof HashSet ? (HashSet<Object>)excludeList : new HashSet<String>(excludeList)));
            this._data.put(pfid, new SoftReference<LocalVariableMap>(tmp));
        } else {
            for (String varName : tmp.keySet()) {
                vars.put(varName, tmp.get(varName));
            }
        }
    }

    public synchronized void clearVariables(long pfid) {
        this._data.remove(pfid);
    }

    private static void loadBroadcastVariables(LocalVariableMap variables, Map<String, Broadcast<CacheBlock>> brInputs) {
        for (Map.Entry<String, Broadcast<CacheBlock>> e : brInputs.entrySet()) {
            Data d = variables.get(e.getKey());
            CacheableData cdcb = (CacheableData)d;
            cdcb.acquireModify((CacheBlock)e.getValue().getValue());
            cdcb.setEmptyStatus();
            cdcb.refreshMetaData();
        }
    }
}

