/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.privacy.finegrained;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sysds.runtime.privacy.PrivacyConstraint;
import org.apache.sysds.runtime.privacy.finegrained.DataRange;
import org.apache.sysds.runtime.privacy.finegrained.FineGrainedPrivacy;

public class FineGrainedPrivacyMap
implements FineGrainedPrivacy {
    private Map<DataRange, PrivacyConstraint.PrivacyLevel> constraintCollection = new LinkedHashMap<DataRange, PrivacyConstraint.PrivacyLevel>();

    @Override
    public void put(DataRange dataRange, PrivacyConstraint.PrivacyLevel privacyLevel) {
        this.constraintCollection.put(dataRange, privacyLevel);
    }

    @Override
    public void putRow(int rowIndex, int rowLength, PrivacyConstraint.PrivacyLevel privacyLevel) {
    }

    @Override
    public void putCol(int colIndex, int colLength, PrivacyConstraint.PrivacyLevel privacyLevel) {
    }

    @Override
    public void putElement(int rowIndex, int colIndex, PrivacyConstraint.PrivacyLevel privacyLevel) {
    }

    @Override
    public Map<DataRange, PrivacyConstraint.PrivacyLevel> getPrivacyLevel(DataRange searchRange) {
        LinkedHashMap<DataRange, PrivacyConstraint.PrivacyLevel> matches = new LinkedHashMap<DataRange, PrivacyConstraint.PrivacyLevel>();
        this.constraintCollection.forEach((range, level) -> {
            if (range.overlaps(searchRange)) {
                matches.put((DataRange)range, (PrivacyConstraint.PrivacyLevel)((Object)level));
            }
        });
        return matches;
    }

    @Override
    public Map<DataRange, PrivacyConstraint.PrivacyLevel> getPrivacyLevelOfElement(long[] searchIndex) {
        LinkedHashMap<DataRange, PrivacyConstraint.PrivacyLevel> matches = new LinkedHashMap<DataRange, PrivacyConstraint.PrivacyLevel>();
        this.constraintCollection.forEach((range, level) -> {
            if (range.contains(searchIndex)) {
                matches.put((DataRange)range, (PrivacyConstraint.PrivacyLevel)((Object)level));
            }
        });
        return matches;
    }

    @Override
    public DataRange[] getDataRangesOfPrivacyLevel(PrivacyConstraint.PrivacyLevel privacyLevel) {
        ArrayList matches = new ArrayList();
        this.constraintCollection.forEach((k, v) -> {
            if (v == privacyLevel) {
                matches.add(k);
            }
        });
        return matches.toArray(new DataRange[0]);
    }

    @Override
    public void removeAllConstraints() {
        this.constraintCollection.clear();
    }

    @Override
    public boolean hasConstraints() {
        return !this.constraintCollection.isEmpty();
    }

    @Override
    public Map<String, long[][][]> getAllConstraints() {
        ArrayList privateRanges = new ArrayList();
        ArrayList aggregateRanges = new ArrayList();
        this.constraintCollection.forEach((range, privacylevel) -> {
            if (privacylevel == PrivacyConstraint.PrivacyLevel.Private) {
                privateRanges.add(new long[][]{range.getBeginDims(), range.getEndDims()});
            } else if (privacylevel == PrivacyConstraint.PrivacyLevel.PrivateAggregation) {
                aggregateRanges.add(new long[][]{range.getBeginDims(), range.getEndDims()});
            }
        });
        LinkedHashMap<String, long[][][]> constraintMap = new LinkedHashMap<String, long[][][]>();
        constraintMap.put(PrivacyConstraint.PrivacyLevel.Private.name(), (long[][][])privateRanges.toArray((T[])new long[0][][]));
        constraintMap.put(PrivacyConstraint.PrivacyLevel.PrivateAggregation.name(), (long[][][])privateRanges.toArray((T[])new long[0][][]));
        return constraintMap;
    }

    @Override
    public ArrayList<Map.Entry<DataRange, PrivacyConstraint.PrivacyLevel>> getAllConstraintsList() {
        ArrayList<Map.Entry<DataRange, PrivacyConstraint.PrivacyLevel>> outputList = new ArrayList<Map.Entry<DataRange, PrivacyConstraint.PrivacyLevel>>();
        this.constraintCollection.forEach((k, v) -> outputList.add(new AbstractMap.SimpleEntry<DataRange, PrivacyConstraint.PrivacyLevel>((DataRange)k, (PrivacyConstraint.PrivacyLevel)((Object)v))));
        return outputList;
    }

    @Override
    public PrivacyConstraint.PrivacyLevel[] getRowPrivacy(int numRows, int numCols) {
        return new PrivacyConstraint.PrivacyLevel[0];
    }

    @Override
    public PrivacyConstraint.PrivacyLevel[] getColPrivacy(int numRows, int numCols) {
        return new PrivacyConstraint.PrivacyLevel[0];
    }
}

