/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.meta;

import java.util.Arrays;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.meta.DataCharacteristics;

public class MatrixCharacteristics
extends DataCharacteristics {
    private static final long serialVersionUID = 8300479822915546000L;
    private long numRows = -1L;
    private long numColumns = -1L;
    private long nonZero = -1L;
    private boolean ubNnz = false;

    public MatrixCharacteristics() {
    }

    public MatrixCharacteristics(long nr, long nc) {
        this.set(nr, nc, -1, -1L);
    }

    public MatrixCharacteristics(long nr, long nc, long nnz) {
        this.set(nr, nc, -1, nnz);
    }

    public MatrixCharacteristics(long nr, long nc, int blen) {
        this.set(nr, nc, blen, -1L);
    }

    public MatrixCharacteristics(long nr, long nc, int blen, long nnz) {
        this.set(nr, nc, blen, nnz);
    }

    public MatrixCharacteristics(DataCharacteristics that) {
        this.set(that);
    }

    @Override
    public DataCharacteristics set(long nr, long nc, int blen) {
        this.numRows = nr;
        this.numColumns = nc;
        this._blocksize = blen;
        return this;
    }

    @Override
    public DataCharacteristics set(long nr, long nc, int blen, long nnz) {
        this.set(nr, nc, blen);
        this.nonZero = nnz;
        this.ubNnz = false;
        return this;
    }

    @Override
    public DataCharacteristics set(DataCharacteristics that) {
        this.set(that.getRows(), that.getCols(), that.getBlocksize(), that.getNonZeros());
        this.ubNnz = that instanceof MatrixCharacteristics && ((MatrixCharacteristics)that).ubNnz;
        return this;
    }

    @Override
    public long getRows() {
        return this.numRows;
    }

    @Override
    public DataCharacteristics setRows(long rlen) {
        this.numRows = rlen;
        return this;
    }

    @Override
    public long getCols() {
        return this.numColumns;
    }

    @Override
    public DataCharacteristics setCols(long clen) {
        this.numColumns = clen;
        return this;
    }

    @Override
    public long getLength() {
        return this.numRows * this.numColumns;
    }

    @Override
    public long getNumBlocks() {
        return this.getNumRowBlocks() * this.getNumColBlocks();
    }

    @Override
    public long getNumRowBlocks() {
        return Math.max((long)Math.ceil((double)this.getRows() / (double)this.getBlocksize()), 1L);
    }

    @Override
    public long getNumColBlocks() {
        return Math.max((long)Math.ceil((double)this.getCols() / (double)this.getBlocksize()), 1L);
    }

    public String toString() {
        return "[" + this.numRows + " x " + this.numColumns + ", nnz=" + this.nonZero + " (" + this.ubNnz + "), blocks (" + this._blocksize + " x " + this._blocksize + ")]";
    }

    @Override
    public DataCharacteristics setDimension(long nr, long nc) {
        this.numRows = nr;
        this.numColumns = nc;
        return this;
    }

    @Override
    public long getDim(int i) {
        if (i == 0) {
            return this.numRows;
        }
        if (i == 1) {
            return this.numColumns;
        }
        throw new DMLRuntimeException("Matrices have only 2 dimensions");
    }

    @Override
    public long[] getLongDims() {
        return new long[]{this.numRows, this.numColumns};
    }

    @Override
    public int[] getIntDims() {
        return new int[]{(int)this.numRows, (int)this.numColumns};
    }

    @Override
    public int getNumDims() {
        return 2;
    }

    @Override
    public DataCharacteristics setNonZeros(long nnz) {
        this.ubNnz = false;
        this.nonZero = nnz;
        return this;
    }

    @Override
    public long getNonZeros() {
        return !this.ubNnz ? this.nonZero : -1L;
    }

    @Override
    public DataCharacteristics setNonZerosBound(long nnz) {
        this.ubNnz = true;
        this.nonZero = nnz;
        return this;
    }

    @Override
    public long getNonZerosBound() {
        return this.nonZero;
    }

    @Override
    public double getSparsity() {
        return OptimizerUtils.getSparsity(this);
    }

    @Override
    public boolean dimsKnown() {
        return this.numRows >= 0L && this.numColumns >= 0L;
    }

    @Override
    public boolean dimsKnown(boolean includeNnz) {
        return this.numRows >= 0L && this.numColumns >= 0L && (!includeNnz || this.nnzKnown());
    }

    @Override
    public boolean rowsKnown() {
        return this.numRows >= 0L;
    }

    @Override
    public boolean colsKnown() {
        return this.numColumns >= 0L;
    }

    @Override
    public boolean nnzKnown() {
        return !this.ubNnz && this.nonZero >= 0L;
    }

    @Override
    public boolean isUltraSparse() {
        return this.dimsKnown(true) && OptimizerUtils.getSparsity(this) < 4.0E-5;
    }

    @Override
    public boolean mightHaveEmptyBlocks() {
        long singleBlk = Math.max(Math.min(this.numRows, (long)this._blocksize), 1L) * Math.max(Math.min(this.numColumns, (long)this._blocksize), 1L);
        return !this.nnzKnown() || this.numRows == 0L || this.numColumns == 0L || this.nonZero < this.numRows * this.numColumns - singleBlk;
    }

    @Override
    public boolean equals(Object anObject) {
        if (!(anObject instanceof MatrixCharacteristics)) {
            return false;
        }
        MatrixCharacteristics mc = (MatrixCharacteristics)anObject;
        return this.numRows == mc.numRows && this.numColumns == mc.numColumns && this._blocksize == mc._blocksize && this.nonZero == mc.nonZero;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(new long[]{this.numRows, this.numColumns, this._blocksize, this.nonZero});
    }
}

