/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.ColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSizes;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;

public class CompressedSizeInfoColGroup {
    private final int _numVals;
    private final int _numOffs;
    private final long _minSize;
    private final ColGroup.CompressionType _bestCompressionType;
    private final Map<ColGroup.CompressionType, Long> _sizes;

    public CompressedSizeInfoColGroup(EstimationFactors fact, Set<ColGroup.CompressionType> validCompressionTypes) {
        this._numVals = fact.numVals;
        this._numOffs = fact.numOffs;
        this._sizes = CompressedSizeInfoColGroup.calculateCompressionSizes(fact, validCompressionTypes);
        Map.Entry<ColGroup.CompressionType, Long> bestEntry = null;
        for (Map.Entry<ColGroup.CompressionType, Long> ent : this._sizes.entrySet()) {
            if (bestEntry != null && ent.getValue() >= bestEntry.getValue()) continue;
            bestEntry = ent;
        }
        this._bestCompressionType = (ColGroup.CompressionType)((Object)bestEntry.getKey());
        this._minSize = bestEntry.getValue();
    }

    public long getCompressionSize(ColGroup.CompressionType ct) {
        return this._sizes.get((Object)ct);
    }

    public ColGroup.CompressionType getBestCompressionType() {
        return this._bestCompressionType;
    }

    public Map<ColGroup.CompressionType, Long> getAllCompressionSizes() {
        return this._sizes;
    }

    public long getMinSize() {
        return this._minSize;
    }

    public int getEstCard() {
        return this._numVals;
    }

    public int getEstNnz() {
        return this._numOffs;
    }

    private static Map<ColGroup.CompressionType, Long> calculateCompressionSizes(EstimationFactors fact, Set<ColGroup.CompressionType> validCompressionTypes) {
        HashMap<ColGroup.CompressionType, Long> res = new HashMap<ColGroup.CompressionType, Long>();
        for (ColGroup.CompressionType ct : validCompressionTypes) {
            res.put(ct, CompressedSizeInfoColGroup.getCompressionSize(ct, fact));
        }
        return res;
    }

    private static Long getCompressionSize(ColGroup.CompressionType ct, EstimationFactors fact) {
        long size = 0L;
        switch (ct) {
            case DDC: {
                if (fact.numVals < 256) {
                    size = ColGroupSizes.estimateInMemorySizeDDC1(fact.numCols, fact.numVals, fact.numRows, fact.lossy);
                    break;
                }
                size = ColGroupSizes.estimateInMemorySizeDDC2(fact.numCols, fact.numVals, fact.numRows, fact.lossy);
                break;
            }
            case RLE: {
                size = ColGroupSizes.estimateInMemorySizeRLE(fact.numCols, fact.numVals, fact.numRuns, fact.numRows, fact.lossy);
                break;
            }
            case OLE: {
                size = ColGroupSizes.estimateInMemorySizeOLE(fact.numCols, fact.numVals, fact.numOffs, fact.numRows, fact.lossy);
                break;
            }
            case UNCOMPRESSED: {
                size = ColGroupSizes.estimateInMemorySizeUncompressed(fact.numRows, fact.numCols, (double)fact.numVals / (double)(fact.numRows * fact.numCols));
                break;
            }
            default: {
                throw new NotImplementedException("The col compression Type is not yet supported");
            }
        }
        return size;
    }
}

